pragma Warnings (Off);
with GNAT.Expect;  use GNAT.Expect;
with GNAT.Expect.TTY;  use GNAT.Expect.TTY;
pragma Warnings (On);

with Ada.Text_IO;  use Ada.Text_IO;
with GNAT.OS_Lib;  use GNAT.OS_Lib;
with GNAT.Regpat;  use GNAT.Regpat;

procedure Test_Expect is
   Debugger : Tty_Process_Descriptor;
   Num      : Expect_Match;
   Params   : Argument_List (1 .. 0);
begin
   --  Doesn't work with gdb
   Non_Blocking_Spawn (Debugger, "/usr/gnat/bin/gdb",
                       Params,
                       Err_To_Out => True,
                       Buffer_Size => 500);

   --  Doesn't work if we don't allocate the strings the same way ???
--     Debugger := Non_Blocking_Spawn ("sh",
--                                     (1 => +"-c",
--                                      2 => +"/usr/gnat/bin/gdb"));

   Add_Filter (Debugger, Trace_Filter'Access, Output);
   Add_Filter (Debugger, Trace_Filter'Access, Input);

   Put_Line ("-------- expect warranty -------");
   Expect (Debugger, Num, Quote ("warranty"), Timeout => 5000);
   case Num is
      when Expect_Timeout =>
         Put_Line ("Got a timeout");
      when others =>
         New_Line;
         Put_Line ("@@GOT " & Num'Img & "@@");
         Put_Line ("Expect_Out = --"
                   & Expect_Out (Debugger) & "--");
         Put_Line ("Expect_Out_Match = --"
                   & Expect_Out_Match (Debugger) & "--");
   end case;

   Put_Line ("----------------- break exception --------------");
   Send (Debugger, "break exception");

   Put_Line ("----------------- Expect No_Symbol_Table -------");
   Expect (Debugger, Num,
           Regexp_Array'(3 => +"[Nn]o symbol table",
                         4 => +"breakpoint at"),
           Timeout => 5000);
   New_Line;
   Put_Line ("@@GOT " & Num'Img & "@@");
   case Num is
      when Expect_Timeout =>
         Put_Line ("Got a timeout");
      when others =>
         Put_Line ("Expect_Out = --" & Expect_Out (Debugger) & "--");
         Put_Line ("Expect_Out_Match = --"
                   & Expect_Out_Match (Debugger) & "--");
   end case;


--     Send (Debugger, "help" & ASCII.LF);
--     Expect (Debugger, Num, Quote ("(gdb)"), Timeout => 5000);

--     Send (Debugger, "help breakpoints" & ASCII.LF);
--     Expect (Debugger, Num, Quote ("(gdb)"), Timeout => 5000,
--             Full_Buffer => False);
--     if Num = Expect_Full_Buffer then
--        Put_Line ("!!!! WAS FULL BUFFER !!!!");

--     else
--        Send (Debugger, "break exception" & ASCII.LF);
--        Expect (Debugger, Num, Quote ("(gdb)"), Timeout => 5000);
--     end if;

   Close (Debugger);
end Test_Expect;
