with Glib;
with Gtkada.Canvas;
with Gdk.Window;
with Gdk.Pixmap;
with Pango.Layout;
with Gtk.Widget; use Gtk.Widget;

package Test_Display_Items is

   type Display_Item_Record is new Gtkada.Canvas.Canvas_Item_Record
     with private;
   type Display_Item is access all Display_Item_Record'Class;

   procedure Gtk_New (Item : out Display_Item;
                      Widget : access Gtk_Widget_Record'Class;
                      Win  : in Gdk.Window.Gdk_Window);
   procedure Initialize (Item : access Display_Item_Record'Class;
                         Widget : access Gtk_Widget_Record'Class;
                         Win  : in Gdk.Window.Gdk_Window);
   procedure Draw
     (Item : access Display_Item_Record;
      Canvas : access Gtkada.Canvas.Interactive_Canvas_Record'Class;
      Dest : Gdk.Pixmap.Gdk_Pixmap;
      Xdest, Ydest : Glib.Gint);
   procedure On_Button_Click (Item   : access Display_Item_Record;
                              Button : Glib.Guint;
                              X, Y   : Glib.Gint);

private
   type Display_Item_Record is new Gtkada.Canvas.Canvas_Item_Record with
      record
         Layout : Pango.Layout.Pango_Layout;
      end record;

end Test_Display_Items;
