#!/bin/sh
# test02/test.cmd

# Search with various scopes

do_it () {
   my_match_case="$1"
   my_whole_word="$2"
   my_scope="$3"

   echo "==== test with case=$my_match_case whole_word=$my_whole_word scope=$my_scope"

   run                       \
      -P dummy.gpr           \
      -look_for "foo"        \
      -files_pattern "*.c"   \
      -case $my_match_case   \
      -whole $my_whole_word  \
      -scope $my_scope
}

# Main

for match_case in 0 1; do
   for whole_word in 0 1; do
      for scope in whole comm_only str_only comm_str all_but_comm; do
         do_it $match_case $whole_word $scope
      done
   done
done
