#!/bin/sh

base=`dirname $0`
base=`cd $base; pwd`
GNATDEBUG=`pwd`/gnatdebug

cd $base

# Make sure the testsuite driver is in the PATH
PATH=$base/obj:$PATH
export PATH

result=0
for dir in test0*; do
(
   cd $dir

   if [ -f .gnatdebug ]; then
      unset ADA_DEBUG_FILE
   else
      export ADA_DEBUG_FILE=$GNATDEBUG
   fi

   printf "Testing in "$dir"... "
   ./test.cmd > out 2>&1
   if diff test.out out > /dev/null 2>&1; then
      rm -f out
      echo "ok"
   else
      echo "FAILED !"
      result=1
   fi
)
done
exit $result
