#! /bin/sh

##  Command line parameters:
##     ./run_regression_test.sh [-simple] [test1] [test2] ...
##  If "-simple" is specified, only the status of the test is returned, not
##  the actual diff


tmp_ext="`whoami`_$$"
test_output='output'
ref_output='test.out'
build_script='build'
test_script='test.cmd'
verbose='no'
GNATDEBUG=`pwd`/gnatdebug

pipe_error() {
  echo "!!!! Interrupted !!!!"
  exit -1
}
trap pipe_error PIPE INT QUIT TERM

## Add read_ali to the path
PATH=`pwd`/../standalone_obj/:$PATH
export PATH

### Some global files...
build_output=`pwd`/build.out.$tmp_ext
touch $build_output

if type dbimp >/dev/null; then
   true;
else
   echo "dbimp not found in the path"
   exit
fi

simple=0
if [ "$1" = "-simple" ]; then
   shift
   simple=1
fi

tests="$@"
if [ "$tests " = " " ]; then
   tests=*
fi

expected_failure="\ \
 cpp_ellipsis1                    \
 cpp_instance_variable            \
 cpp_localvar                     \
 cpp_macro                        \
 cpp_nested1                      \
 cpp_overloading1                 \
 cpp_overloading2                 \
 cpp_overloading3                 \
 cpp_ref_to_impl                  \
 cpp_separate_files               \
 cpp_separate_files1              \
 cpp_template1                    \
 cpp_template2                    \
 cpp_template3                    \
 cpp_typedef                      \
 cpp_union                        \
\ "

pwd=`pwd`

for current_dir in $tests
do
   cd $pwd

   if [ -f .gnatdebug ]; then
      unset ADA_DEBUG_FILE
   else
      export ADA_DEBUG_FILE=$GNATDEBUG
   fi

   current_dir=`basename $current_dir`
   if [ $current_dir != "parse_all" -a -d $current_dir -a $current_dir != '.' -a $current_dir != 'CVS' ]
   then
      copy_dir=${current_dir}_${tmp_ext}

      if [ -f $current_dir/$test_script ]; then
         cp -R $current_dir $copy_dir
         cd $copy_dir
         rm -rf .gpssnprj/

         if [ -f $build_script ]; then
             echo "" >> $build_output
             echo "--  Building in $current_dir:" >> $build_output
             sh ./$build_script >> $build_output 2>&1
         fi

         if echo $expected_failure | fgrep " $current_dir " >/dev/null; then
            is_expected="(expected)"
         else
            is_expected=""
         fi

         test_parse $test_script > $test_output 2>&1 
         if [ -f $ref_output ]; then
            if [ $simple = 0 ]; then
               echo "---------  $current_dir $is_expected"
               diff -c $ref_output $test_output
            else
               diff $ref_output $test_output >/dev/null 2>&1
               if [ $? -ne 0 ]; then
                  echo "+++++++++  $current_dir (FAILURE) $is_expected"
               else
                  echo "---------  $current_dir $is_expected"
               fi
            fi
         else
            if [ $simple = 0 ]; then
               echo "---------  $current_dir $is_expected"
               cat $test_output
            elif [ -z $test_output ]; then
               echo "---------  $current_dir $is_expected"
               true
            else
               echo "+++++++++  $current_dir (FAILURE) $is_expected"
            fi
         fi
       
         cd .. 

         rm -rf $copy_dir
      else
         echo "$current_dir: test.cmd missing, test skipped." > $build_output
      fi
   fi
done

if [ "$verbose" = "yes" ]; then
   echo "==========   Build output  ============"
   cat $build_output
fi

rm $build_output
