// XMLSocket_as.hx:  ActionScript 3 "XMLSocket" class, for Gnash. 
// Includes all ming cases as well
//
// Generated by gen-as3.sh on: 20090514 by "rob". Remove this
// after any hand editing loosing changes.
//
//   Copyright (C) 2009 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// This test case must be processed by CPP before compiling to include the
//  DejaGnu.hx header file for the testing framework support.

#if flash9
import flash.net.XMLSocket;
import flash.display.MovieClip;
#else
import flash.XMLSocket;
import flash.MovieClip;
#end
import flash.Lib;
import Type;
import Std;

// import our testing API
import DejaGnu;

// Class must be named with the _as suffix, as that's the same name as the file.
class XMLSocket_as {
    static function main() {
        var x1:XMLSocket = new XMLSocket();

        // Make sure we actually get a valid class        
        if (Std.is(x1, XMLSocket)) {
            DejaGnu.pass("XMLSocket class exists");
        } else {
            DejaGnu.fail("XMLSocket class doesn't exist");
        }

		// Tests to see if all the properties exist. All these do is test for
		// existance of a property, and don't test the functionality at all. This
		// is primarily useful only to test completeness of the API implementation.
		#if flash9
		if (Type.typeof(x1.connected)==TBool) {
			DejaGnu.pass("XMLSocket.hasOwnProperty('connected')");
		} else {
			DejaGnu.fail("XMLSocket.hasOwnProperty('connected')");
		}
		#end
		
		if (Type.typeof(x1.connect)==ValueType.TFunction) {
			DejaGnu.pass("XMLSocket.prototype.hasOwnProperty('connect')");
		} else {
			DejaGnu.fail("!XMLSocket.prototype.hasOwnProperty('connect')");
		}
		if (Type.typeof(x1.send)==ValueType.TFunction) {
			DejaGnu.pass("XMLSocket.prototype.hasOwnProperty('send')");
		} else {
			DejaGnu.fail("!XMLSocket.prototype.hasOwnProperty('send')");
		}
		if (Type.typeof(x1.close)==ValueType.TFunction) {
			DejaGnu.pass("XMLSocket.prototype.hasOwnProperty('close')");
		} else {
			DejaGnu.fail("!XMLSocket.prototype.hasOwnProperty('close')");
		}
		
		#if !flash9
		if (Std.is(untyped XMLSocket.onData, Dynamic)) {
			DejaGnu.pass("XMLSocket.prototype.hasOwnProperty('onData')");
		} else {
			DejaGnu.fail("!XMLSocket.prototype.hasOwnProperty('onData')");
		}
		if (!untyped XMLSocket.prototype.hasOwnProperty("onXML")) {
			DejaGnu.pass("!XMLSocket.prototype.hasOwnProperty('onXML')");
		} else {
			DejaGnu.fail("XMLSocket.prototype.hasOwnProperty('onXML')");
		}
		if (!untyped XMLSocket.prototype.hasOwnProperty("onConnect")) {
			DejaGnu.pass("!XMLSocket.prototype.hasOwnProperty('onConnect')");
		} else {
			DejaGnu.fail("XMLSocket.prototype.hasOwnProperty('onConnect')");
		}
		if (!untyped XMLSocket.prototype.hasOwnProperty("onClose")) {
			DejaGnu.pass("!XMLSocket.prototype.hasOwnProperty('onClose')");
		} else {
			DejaGnu.fail("XMLSocket.prototype.hasOwnProperty('onClose')");
		}
		
		if (Type.typeof(untyped XMLSocket) == ValueType.TFunction) {
			DejaGnu.pass("typeof(XMLSocket)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket)!='function'");
		}
		
		#end
		
		if (untyped XMLSocket.connect==null) {
			DejaGnu.pass("typeof(XMLSocket.connect)=='undefined'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.connect)!='undefined'");
		}
		if (untyped XMLSocket.close==null) {
			DejaGnu.pass("typeof(XMLSocket.close)=='undefined'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.close)!='undefined'");
		}
		if (untyped XMLSocket.send==null) {
			DejaGnu.pass("typeof(XMLSocket.send)=='undefined'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.send)!='undefined'");
		}	

		if (untyped XMLSocket.connected==null) {
			DejaGnu.pass("typeof(XMLSocket.connected)=='undefined'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.connected)!='undefined'");
		}			
		if (untyped XMLSocket.prototype.Connected==null) {
			DejaGnu.pass("typeof(XMLSocket.prototype.Connected)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.prototype.Connected)!='function'");
		}
		if (untyped XMLSocket.prototype.connected==null) {
			DejaGnu.pass("typeof(XMLSocket.prototype.connected)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.prototype.connected)!='function'");
		}

		var socketObj = untyped __new__(XMLSocket);
		
		#if !flash9
		if (Type.typeof(socketObj.onData)==ValueType.TFunction) {
			DejaGnu.pass("typeof(socketObj.onData)=='function'");
		} else {
			DejaGnu.fail("typeof(socketObj.onData)!='function'");
		}
		if (Type.typeof(socketObj.__proto__)==ValueType.TObject) {
			DejaGnu.pass("typeof(socketObj.__proto__)==XMLSocket.prototype");
		} else {
			DejaGnu.fail("typeof(socketObj.__proto__)!=XMLSocket.prototype");
		}
		if (Type.typeof(socketObj)==ValueType.TObject) {
			DejaGnu.pass("typeof(socketObj)=='object'");
		} else {
			DejaGnu.fail("typeof(socketObj)!='object'");
		}
		
		if (Type.typeof(untyped XMLSocket.prototype.connect)==ValueType.TFunction) {
			DejaGnu.pass("typeof(XMLSocket.prototype.connect)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.prototype.connect)!='function'");
		}
		if (Type.typeof(untyped XMLSocket.prototype.close)==ValueType.TFunction) {
			DejaGnu.pass("typeof(XMLSocket.prototype.close)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.prototype.close)!='function'");
		}
		if (Type.typeof(untyped XMLSocket.prototype.send)==ValueType.TFunction) {
			DejaGnu.pass("typeof(XMLSocket.prototype.send)=='function'");
		} else {
			DejaGnu.fail("typeof(XMLSocket.prototype.send)!='function'");
		}
		
		if (! untyped socketObj.hasOwnProperty("connect")) {
			DejaGnu.pass("! socketObj.hasOwnProperty('connect')");
		} else {
			DejaGnu.fail("socketObj.hasOwnProperty('connect')");
		}
		if (! untyped socketObj.hasOwnProperty("close")) {
			DejaGnu.pass("! socketObj.hasOwnProperty('close')");
		} else {
			DejaGnu.fail("socketObj.hasOwnProperty('close')");
		}
		if (! untyped socketObj.hasOwnProperty("send")) {
			DejaGnu.pass("! socketObj.hasOwnProperty('send')");
		} else {
			DejaGnu.fail("socketObj.hasOwnProperty('send')");
		}
		#end
	
		
		#if !flash9
		untyped socketObj.secret = 4;
		
		socketObj.onConnect = function(success) {
			if (socketObj.secret==4) {
				DejaGnu.note("socketObj.secret==4");
			} else {
				DejaGnu.note("socketObj.secret!=4");
			}
			
			if (success) {
				DejaGnu.note("XMLSocket.onConnect(success) called");
			}
			else {
				DejaGnu.note("XMLSocket.onConnect(failure) called");
			}
		};
		
		socketObj.onXML = function(x) {
			if (socketObj.secret==4) {
				DejaGnu.note("socketObj.secret==4");
			} else {
				DejaGnu.note("socketObj.secret!=4");
			}
			
			if (untyped __arguments__.length==1) {
				DejaGnu.note("arguments.length==1");
			} else {
				DejaGnu.note("arguments.length!=1");
			}
			
			if (Std.is(x, XMLSocket)) {
				DejaGnu.note("instanceof(x, XMLSocket)");
			} else {
				DejaGnu.note("!instanceof(x, XMLSocket)");
			}
			
			DejaGnu.note("XMLSocket.onXML() called with a " + Type.typeof(untyped __arguments__[0]) + " as arg");
			DejaGnu.note("Parsed XML: " + x.toString());
		};
		
		socketObj.onClose = function() {
			if (socketObj.secret==4) {
				DejaGnu.note("socketObj.secret==4");
			} else {
				DejaGnu.note("socketObj.secret!=4");
			}
			
			DejaGnu.note("XMLSocket.onClose() called with " + untyped __arguments__.length);
		};
		
		var host:String = "madeuphost";
		var port:Int = 109092989;
		
		// This is supposed to be repeated twice...
		if (socketObj.connect(host, port)==false) {
			DejaGnu.pass("socketObj.connect(host, port)==false");
		} else {
			DejaGnu.fail("socketObj.connect(host, port)!=false");
		}
		if (socketObj.connect(host, port)==false) {
			DejaGnu.pass("socketObj.connect(host, port)==false");
		} else {
			DejaGnu.fail("socketObj.connect(host, port)!=false");
		}
		
		// Same here
		var ret = socketObj.close();
		
		if (ret==null) {
			DejaGnu.pass("ret=='undefined'");
		} else {
			DejaGnu.fail("ret!='undefined'");
		}
		
		var ret = socketObj.close();
		
		if (ret==null) {
			DejaGnu.pass("ret=='undefined'");
		} else {
			DejaGnu.fail("ret!='undefined'");
		}
		
		var ret = socketObj.send("This won't work");
		
		if (ret==null) {
			DejaGnu.pass("ret=='undefined'");
		} else {
			DejaGnu.fail("ret!='undefined'");
		}
		#end

		// Call this after finishing all tests. It prints out the totals.
		DejaGnu.done();
    }
}

// local Variables:
// mode: C++
// indent-tabs-mode: t
// End:

