------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_bounded.adb,v 1.7 2003/10/30 09:23:18 vagul Exp $

with OCI.Lib, OCI.Thread;

package body OCI.Thick.String_Bounded is

   use Lib;

   ---------------
   -- Get_Value --
   ---------------

   function Get_Value (Var : Variable'Class) return String is
   begin
      if Is_Null(Var) then
         raise NULL_VALUE;
      else
         return C.To_Ada(Var.Value);
      end if;
   end Get_Value;

   procedure Set_Value (Var : in out Variable; Value : String) is
      Len : String_Size;
      use type String_Size;
   begin
      if Value'Length > Var.Length then
         raise Constraint_Error;
      end if;

      Var.Indicator := 0;

      C.To_C
        (Item       => Value,
         Target     => Var.Value,
         Count      => Len,
         Append_Nul => True);
   end Set_Value;

   use type sb4;

   procedure Bind
     (Stmt  : in     Statement;
      Value : in out Variable;
      Name  : in     String)
   is
      rc : sword := OCIBindByName
                  (stmtp       => OCIStmt (Handle (Stmt)),
                   bindpp      => Value.Bind'Access,
                   errhp       => Thread.Error,
                   placeholder => C.To_C (Name),
                   placeh_len  => Name'Length,
                   valuep      => Value.Value'Address,
                   value_sz    => Value.Value'Length,
                   dty         => SQLT_STR,
                   indp        => Value.Indicator'Unchecked_Access);
   begin
      Check_Error(rc);
   end Bind;

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive)
   is
      Rc : sword := OCIBindByPos
                  (stmtp    => OCIStmt (Handle (Stmt)),
                   bindpp   => Value.Bind'Access,
                   errhp    => Thread.Error,
                   Position => Ub4 (Position),
                   valuep   => Value.Value'Address,
                   value_sz => Value.Value'Length,
                   dty      => SQLT_STR,
                   indp     => Value.Indicator'Unchecked_Access);
   begin
      Check_Error (Rc);
   end Bind;

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive)
   is
      rc : sword := OCIDefineByPos
                  (stmtp => OCIStmt (Handle (Stmt)),
                   defnpp => Value.Define'Access,
                   errhp => Thread.Error,
                   position => ub4(Position),
                   value => Value.Value'Address,
                   value_sz => Value.Value'Length,
                   dty => SQLT_STR,
                   indp => Value.Indicator'Unchecked_Access);
   begin
      Check_Error(rc);
   end Define;

end OCI.Thick.string_Bounded;
