------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-environments.ads,v 1.4 2003/11/26 07:34:56 vagul Exp $

with
   OCI.Lib,
   OCI.Reference_Finalization;

package OCI.Environments is

   use OCI.Lib;
   package RF renames Reference_Finalization;

   type Thread_Environment is new RF.Controlled_Reference with record
      Handle : OCIEnv := OCIEnv (Empty_Handle);
   end record;

   function Create return Thread_Environment;

   Init_Environment : constant Thread_Environment;

   procedure Set_Create_Mode_Flag (Flag : in Ub4);

   protected Counter is
      procedure Add (It : Integer);
      function Value return Integer;
   private
      Val : Integer := 0;
   end Counter;

   Last_Size : Integer := 0;

private

   procedure Destroy   (Object : in out Thread_Environment);

   Init_Environment : constant Thread_Environment
     := (RF.Controlled_Reference with
         Handle => OCIEnv (Empty_Handle));

   Environment_Creation_Error : exception;

end OCI.Environments;