-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-hostvariable-types.adb,v $
--  Description     : Ada Database Objects - Hostvariable                    --
--  Author          : Michael Erdmann                                        --
--  Created         : 29.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/04/04 19:10:49 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2002 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                                  use Ada.Text_IO;
with System.Address_To_Access_Conversions;

package body GNU.DB.ADBC.Hostvariable.Types  is

   -----------
   -- Value --
   -----------
   procedure Value(
      This : in out SQL_String;
      V    : in String ) is
      -- store the string into the object store
   begin
      This.Str := To_Unbounded_String(V);
   end Value;

   -----------
   -- Value --
   -----------
   function Value(
      This : in SQL_String) return String is
   begin
      return To_String(This.Str);
   end Value;

   -----------
   -- Value --
   -----------
   procedure Value(
      This : in out SQL_Integer;
      V    : in Integer ) is
      -- store the string into the object store
      T    : Integer;
      for T'Address use Allocate( This, V'Size );
   begin
      T  := V;
   end Value;

   -----------
   -- Value --
   -----------
   function Value(
      This : in SQL_Integer) return Integer is

      package Integer_Access is
         new System.Address_To_Access_Conversions( Object => Integer );
      use Integer_Access;

      Result : Object_Pointer := To_Pointer(Hostdata(This));
   begin
      return Result.all;
   end Value;

   -----------
   -- Value --
   -----------
   procedure Value(
      This : in out SQL_Float;
      V    : in Float ) is
      -- store the string into the object store
      T    : Float;
      for T'Address use Allocate( This, V'Size );
   begin
      T    := V;
   end Value;

   -----------
   -- Value --
   -----------
   function Value(
      This : in SQL_Float) return Float is

      package Float_Access is
         new System.Address_To_Access_Conversions( Object => Float );
      use Float_Access;

      Result : Object_Pointer := To_Pointer(Hostdata(This));
   begin
      return Result.all;
   end Value;

end GNU.DB.ADBC.Hostvariable.Types ;

