/**
 * GMyth Library
 *
 * @file test/main.c
 * 
 * @brief <p> GMythUPnP allows that a MythTV frontend discovers a 
 * MythTV backend, using the UPnP architecture.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 * @authon Renato Araujo Oliveira Filho <renato.filho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gmyth/gmyth.h>
#include "gmyth_upnp.h"

static void
_device_found_cb (GMythUPnP *upnp,
                  GMythBackendInfo *info,
                  gpointer data)
{
    g_debug ("BACKEND FOUND: %s", info->hostname);
}

static void
_device_lost_cb (GMythUPnP *upnp,
                  GMythBackendInfo *info,
                  gpointer data)
{
    g_debug ("BACKEND LOST: %s", info->hostname);
}



int main (int argc, char** argv)
{
    GMythUPnP *o;
    GMainLoop *loop;

    g_type_init ();
    g_thread_init (NULL);

    o = gmyth_upnp_get_instance ();
    g_signal_connect (o,
                      "device-found",
                       G_CALLBACK (_device_found_cb),
                       NULL);
    g_signal_connect (o,
                      "device-lost",
                       G_CALLBACK (_device_lost_cb),
                       NULL);


    gmyth_upnp_search (o);

    loop = g_main_loop_new (NULL, FALSE);
    g_main_loop_run (loop);
    g_object_unref (o);

    return 0;
}
