/* GtkMult.c generated by valac, the Vala compiler
 * generated from GtkMult.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <config.h>
#include <pango/pango.h>


#define TYPE_GTK_MULT (gtk_mult_get_type ())
#define GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_MULT, GtkMult))
#define GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_MULT, GtkMultClass))
#define IS_GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_MULT))
#define IS_GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_MULT))
#define GTK_MULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_MULT, GtkMultClass))

typedef struct _GtkMult GtkMult;
typedef struct _GtkMultClass GtkMultClass;
typedef struct _GtkMultPrivate GtkMultPrivate;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _GtkMult {
	GtkWindow parent_instance;
	GtkMultPrivate * priv;
};

struct _GtkMultClass {
	GtkWindowClass parent_class;
};

struct _GtkMultPrivate {
	MultPuzzle* _puzzle;
	gboolean _cheated;
	GtkStatusbar* _status;
	GtkAction* solve_action;
	GtkAction* hint_action;
	Canvas* canvas;
	GtkVBox* vbox;
	GTimer* timer;
	GtkLabel* timer_label;
	GtkLabel* score;
	GtkHBox* status_box;
	guint status_timeout_id;
	guint timer_timeout_id;
	GtkAboutDialog* _about;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;


extern gint gtk_mult_dpi;
gint gtk_mult_dpi = 0;
static gunichar gtk_mult_a_char;
static gunichar gtk_mult_a_char = 0U;
static gunichar gtk_mult_b_char;
static gunichar gtk_mult_b_char = 0U;
static gunichar gtk_mult_c_char;
static gunichar gtk_mult_c_char = 0U;
static gunichar gtk_mult_d_char;
static gunichar gtk_mult_d_char = 0U;
static gunichar gtk_mult_e_char;
static gunichar gtk_mult_e_char = 0U;
static gunichar gtk_mult_f_char;
static gunichar gtk_mult_f_char = 0U;
static gunichar gtk_mult_g_char;
static gunichar gtk_mult_g_char = 0U;
static gunichar gtk_mult_h_char;
static gunichar gtk_mult_h_char = 0U;
static gunichar gtk_mult_i_char;
static gunichar gtk_mult_i_char = 0U;
static gunichar gtk_mult_j_char;
static gunichar gtk_mult_j_char = 0U;
static gunichar gtk_mult_0_char;
static gunichar gtk_mult_0_char = 0U;
static gunichar gtk_mult_1_char;
static gunichar gtk_mult_1_char = 0U;
static gunichar gtk_mult_2_char;
static gunichar gtk_mult_2_char = 0U;
static gunichar gtk_mult_3_char;
static gunichar gtk_mult_3_char = 0U;
static gunichar gtk_mult_4_char;
static gunichar gtk_mult_4_char = 0U;
static gunichar gtk_mult_5_char;
static gunichar gtk_mult_5_char = 0U;
static gunichar gtk_mult_6_char;
static gunichar gtk_mult_6_char = 0U;
static gunichar gtk_mult_7_char;
static gunichar gtk_mult_7_char = 0U;
static gunichar gtk_mult_8_char;
static gunichar gtk_mult_8_char = 0U;
static gunichar gtk_mult_9_char;
static gunichar gtk_mult_9_char = 0U;
static gpointer gtk_mult_parent_class = NULL;

GType gtk_mult_get_type (void);
GType mult_puzzle_get_type (void);
GType canvas_get_type (void);
#define GTK_MULT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GTK_MULT, GtkMultPrivate))
enum  {
	GTK_MULT_DUMMY_PROPERTY,
	GTK_MULT_PUZZLE,
	GTK_MULT_CHEATED,
	GTK_MULT_STATUS
};
#define GTK_MULT_ASPECT (8.0 / 6.0)
static gboolean gtk_mult_pop_guess_feedback (GtkMult* self);
void gtk_mult_clear_guess_feedback (GtkMult* self);
void canvas_clear_mode (Canvas* self);
void canvas_start_choice (Canvas* self, gchar ch);
static gboolean gtk_mult_handle_key_press (GtkMult* self, GtkMult* mult, GdkEventKey* event);
static void gtk_mult_on_menu_game_new (GtkMult* self);
static void _gtk_mult_on_menu_game_new_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_hint (GtkMult* self);
static void _gtk_mult_on_menu_game_hint_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_solve (GtkMult* self);
static void _gtk_mult_on_menu_game_solve_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_close (GtkMult* self);
static void _gtk_mult_on_menu_game_close_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_help_about (GtkMult* self);
static void _gtk_mult_on_menu_help_about_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_select_new (GtkMult* self);
static void _gtk_mult_on_menu_select_new_gtk_item_select (GtkItem* _sender, gpointer self);
static void gtk_mult_on_menu_deselect (GtkMult* self);
static void _gtk_mult_on_menu_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_hint (GtkMult* self);
static void _gtk_mult_on_menu_select_hint_gtk_item_select (GtkItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_solve (GtkMult* self);
static void _gtk_mult_on_menu_select_solve_gtk_item_select (GtkItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_close (GtkMult* self);
static void _gtk_mult_on_menu_select_close_gtk_item_select (GtkItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_about (GtkMult* self);
static void _gtk_mult_on_menu_select_about_gtk_item_select (GtkItem* _sender, gpointer self);
static GtkWidget* gtk_mult_setup_menu (GtkMult* self);
GtkStatusbar* gtk_mult_get_status (GtkMult* self);
static void gtk_mult_set_status (GtkMult* self, GtkStatusbar* value);
MultPuzzle* mult_puzzle_new (gint num_x, gint num_y);
MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y);
static void gtk_mult_set_puzzle (GtkMult* self, MultPuzzle* value);
Canvas* canvas_new (GtkMult* mult);
Canvas* canvas_construct (GType object_type, GtkMult* mult);
static gboolean gtk_mult_update_timer (GtkMult* self);
static gboolean _gtk_mult_update_timer_gsource_func (gpointer self);
static void gtk_mult_set_cheated (GtkMult* self, gboolean value);
static void gtk_mult_update_score (GtkMult* self);
static void gtk_mult_on_puzzle_change (GtkMult* self, MultPuzzle* p);
MultPuzzle* gtk_mult_get_puzzle (GtkMult* self);
GType mult_puzzle_char_get_type (void);
GType mult_puzzle_guess_status_get_type (void);
static void gtk_mult_on_puzzle_guess (GtkMult* self, MultPuzzle* p, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus response);
static void _gtk_mult_on_puzzle_guess_mult_puzzle_guessed (MultPuzzle* _sender, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus status, gpointer self);
static void _gtk_mult_on_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self);
static void gtk_mult_new_puzzle (GtkMult* self);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
static gboolean _gtk_mult_pop_guess_feedback_gsource_func (gpointer self);
gint mult_puzzle_get_wrong_guesses (MultPuzzle* self);
gboolean gtk_mult_get_cheated (GtkMult* self);
void mult_puzzle_solve (MultPuzzle* self);
gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1);
MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit);
static void gtk_mult_handle_about_uri (GtkMult* self, GtkAboutDialog* about, const char* link);
static void gtk_mult_handle_about_mail (GtkMult* self, GtkAboutDialog* about, const char* link);
static GtkAboutDialog* gtk_mult_get_about (GtkMult* self);
static void gtk_mult_set_about (GtkMult* self, GtkAboutDialog* value);
static void _gtk_mult_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _gtk_mult_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _lambda0_ (GtkAboutDialog* dlg, gint resp, GtkMult* self);
static void __lambda0__gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self);
GtkMult* gtk_mult_new (void);
GtkMult* gtk_mult_construct (GType object_type);
gint gtk_mult_main (char** args, int args_length1);
static gboolean _gtk_mult_handle_key_press_gtk_widget_key_press_event (GtkMult* _sender, GdkEventKey* event, gpointer self);
static void _gtk_main_quit_gtk_object_destroy (GtkMult* _sender, gpointer self);
static GObject * gtk_mult_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gtk_mult_finalize (GObject* obj);
static void gtk_mult_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gtk_mult_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const char* GTK_MULT_authors[] = {"Michael Terry <mike@mterry.name>", NULL};
static const char* GTK_MULT_artists[] = {"Eugenia Loli-Queru <eloli@hotmail.com>", "Michael Terry <mike@mterry.name>", NULL};


void gtk_mult_clear_guess_feedback (GtkMult* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->status_timeout_id != 0) {
		g_source_remove (self->priv->status_timeout_id);
	}
	gtk_mult_pop_guess_feedback (self);
}


static gboolean gtk_mult_handle_key_press (GtkMult* self, GtkMult* mult, GdkEventKey* event) {
	gboolean result;
	GdkModifierType state;
	gchar ch = '\0';
	gunichar ev_char;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mult != NULL, FALSE);
	state = (*event).state & gtk_accelerator_get_default_mod_mask ();
	state = state & (~0x03);
	if (state != 0) {
		result = FALSE;
		return result;
	}
	ev_char = (gunichar) gdk_keyval_to_unicode (gdk_keyval_to_upper ((*event).keyval));
	if (ev_char == gtk_mult_a_char) {
		ch = 'A';
	} else {
		if (ev_char == gtk_mult_b_char) {
			ch = 'B';
		} else {
			if (ev_char == gtk_mult_c_char) {
				ch = 'C';
			} else {
				if (ev_char == gtk_mult_d_char) {
					ch = 'D';
				} else {
					if (ev_char == gtk_mult_e_char) {
						ch = 'E';
					} else {
						if (ev_char == gtk_mult_f_char) {
							ch = 'F';
						} else {
							if (ev_char == gtk_mult_g_char) {
								ch = 'G';
							} else {
								if (ev_char == gtk_mult_h_char) {
									ch = 'H';
								} else {
									if (ev_char == gtk_mult_i_char) {
										ch = 'I';
									} else {
										if (ev_char == gtk_mult_j_char) {
											ch = 'J';
										} else {
											if (ev_char == gtk_mult_0_char) {
												ch = '0';
											} else {
												if (ev_char == gtk_mult_1_char) {
													ch = '1';
												} else {
													if (ev_char == gtk_mult_2_char) {
														ch = '2';
													} else {
														if (ev_char == gtk_mult_3_char) {
															ch = '3';
														} else {
															if (ev_char == gtk_mult_4_char) {
																ch = '4';
															} else {
																if (ev_char == gtk_mult_5_char) {
																	ch = '5';
																} else {
																	if (ev_char == gtk_mult_6_char) {
																		ch = '6';
																	} else {
																		if (ev_char == gtk_mult_7_char) {
																			ch = '7';
																		} else {
																			if (ev_char == gtk_mult_8_char) {
																				ch = '8';
																			} else {
																				if (ev_char == gtk_mult_9_char) {
																					ch = '9';
																				} else {
																					if ((*event).keyval == 65307) {
																						canvas_clear_mode (self->priv->canvas);
																						result = TRUE;
																						return result;
																					} else {
																						result = FALSE;
																						return result;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	canvas_start_choice (self->priv->canvas, ch);
	result = TRUE;
	return result;
}


static void _gtk_mult_on_menu_game_new_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_new (self);
}


static void _gtk_mult_on_menu_game_hint_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_hint (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_mult_on_menu_game_solve_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_solve (self);
}


static void _gtk_mult_on_menu_game_close_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_close (self);
}


static void _gtk_mult_on_menu_help_about_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_help_about (self);
}


static void _gtk_mult_on_menu_select_new_gtk_item_select (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_new (self);
}


static void _gtk_mult_on_menu_deselect_gtk_item_deselect (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_deselect (self);
}


static void _gtk_mult_on_menu_select_hint_gtk_item_select (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_hint (self);
}


static void _gtk_mult_on_menu_select_solve_gtk_item_select (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_solve (self);
}


static void _gtk_mult_on_menu_select_close_gtk_item_select (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_close (self);
}


static void _gtk_mult_on_menu_select_about_gtk_item_select (GtkItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_about (self);
}


static GtkWidget* gtk_mult_setup_menu (GtkMult* self) {
	GtkWidget* result;
	GError * _inner_error_;
	GtkActionGroup* action_group;
	GtkAction* action;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	GtkAction* _tmp7_;
	char* ui;
	GtkUIManager* manager;
	GtkItem* menu_item;
	GtkItem* _tmp8_;
	GtkItem* _tmp9_;
	GtkItem* _tmp10_;
	GtkItem* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	action_group = gtk_action_group_new ("gmult-actions");
	action = gtk_action_new ("GameMenuAction", _ ("_Game"), NULL, NULL);
	gtk_action_group_add_action (action_group, action);
	action = (_tmp0_ = gtk_action_new ("NewAction", NULL, NULL, GTK_STOCK_NEW), _g_object_unref0 (action), _tmp0_);
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_new_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>N");
	action = (_tmp1_ = gtk_action_new ("HintAction", _ ("_Hint"), NULL, NULL), _g_object_unref0 (action), _tmp1_);
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_hint_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>H");
	self->priv->hint_action = (_tmp2_ = _g_object_ref0 (action), _g_object_unref0 (self->priv->hint_action), _tmp2_);
	action = (_tmp3_ = gtk_action_new ("SolveAction", _ ("_Solve"), NULL, NULL), _g_object_unref0 (action), _tmp3_);
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_solve_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	self->priv->solve_action = (_tmp4_ = _g_object_ref0 (action), _g_object_unref0 (self->priv->solve_action), _tmp4_);
	action = (_tmp5_ = gtk_action_new ("CloseAction", NULL, NULL, GTK_STOCK_QUIT), _g_object_unref0 (action), _tmp5_);
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_close_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>Q");
	action = (_tmp6_ = gtk_action_new ("HelpMenuAction", _ ("_Help"), NULL, NULL), _g_object_unref0 (action), _tmp6_);
	gtk_action_group_add_action (action_group, action);
	action = (_tmp7_ = gtk_action_new ("AboutAction", NULL, NULL, GTK_STOCK_ABOUT), _g_object_unref0 (action), _tmp7_);
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_help_about_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	ui = g_strdup ("\n<ui>\n  <menubar>\n    <menu name=\"GameMenu\" action=\"GameMenuAction\">\n      <menuitem name=\"New\" action=\"NewAction\" />\n      <separator />\n      <menuitem name=\"Hint\" action=\"HintAction\" />\n      <menuitem name=\"Solve\" action=\"SolveAction\" />\n      <separator />\n      <menuitem name=\"Close\" action=\"CloseAction\" />\n    </menu>\n    <menu name=\"HelpMenu\" action=\"HelpMenuAction\">\n      <menuitem name=\"About\" action=\"AboutAction\"/>\n    </menu>\n  </menubar>\n</ui>");
	manager = gtk_ui_manager_new ();
	{
		gtk_ui_manager_add_ui_from_string (manager, ui, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("GtkMult.vala:206: Internal error: bad ui string.\n");
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action_group);
		_g_object_unref0 (action);
		_g_free0 (ui);
		_g_object_unref0 (manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_ui_manager_insert_action_group (manager, action_group, 0);
	gtk_window_add_accel_group ((GtkWindow*) self, gtk_ui_manager_get_accel_group (manager));
	menu_item = _g_object_ref0 (GTK_ITEM (gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/New")));
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_new_gtk_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_item_deselect, self, 0);
	menu_item = (_tmp8_ = _g_object_ref0 (GTK_ITEM (gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Hint"))), _g_object_unref0 (menu_item), _tmp8_);
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_hint_gtk_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_item_deselect, self, 0);
	menu_item = (_tmp9_ = _g_object_ref0 (GTK_ITEM (gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Solve"))), _g_object_unref0 (menu_item), _tmp9_);
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_solve_gtk_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_item_deselect, self, 0);
	menu_item = (_tmp10_ = _g_object_ref0 (GTK_ITEM (gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Close"))), _g_object_unref0 (menu_item), _tmp10_);
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_close_gtk_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_item_deselect, self, 0);
	menu_item = (_tmp11_ = _g_object_ref0 (GTK_ITEM (gtk_ui_manager_get_widget (manager, "/ui/menubar/HelpMenu/About"))), _g_object_unref0 (menu_item), _tmp11_);
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_about_gtk_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_item_deselect, self, 0);
	result = _g_object_ref0 (gtk_ui_manager_get_widget (manager, "/ui/menubar"));
	_g_object_unref0 (action_group);
	_g_object_unref0 (action);
	_g_free0 (ui);
	_g_object_unref0 (manager);
	_g_object_unref0 (menu_item);
	return result;
}


static gboolean _gtk_mult_update_timer_gsource_func (gpointer self) {
	return gtk_mult_update_timer (self);
}


static void _gtk_mult_on_puzzle_guess_mult_puzzle_guessed (MultPuzzle* _sender, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus status, gpointer self) {
	gtk_mult_on_puzzle_guess (self, _sender, digit, letter, status);
}


static void _gtk_mult_on_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self) {
	gtk_mult_on_puzzle_change (self, _sender);
}


static void gtk_mult_new_puzzle (GtkMult* self) {
	GtkStatusbar* _tmp0_;
	MultPuzzle* _tmp1_;
	Canvas* _tmp2_;
	GdkGeometry _tmp3_ = {0};
	GdkGeometry geom;
	g_return_if_fail (self != NULL);
	if (self->priv->canvas != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->vbox, (GtkWidget*) self->priv->canvas);
	}
	if (self->priv->_status != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->status_box, (GtkWidget*) self->priv->_status);
	}
	gtk_mult_set_status (self, _tmp0_ = g_object_ref_sink ((GtkStatusbar*) gtk_statusbar_new ()));
	_g_object_unref0 (_tmp0_);
	gtk_statusbar_set_has_resize_grip (self->priv->_status, FALSE);
	gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) self->priv->_status, TRUE, TRUE, (guint) 0);
	gtk_box_reorder_child ((GtkBox*) self->priv->status_box, (GtkWidget*) self->priv->_status, 0);
	gtk_mult_set_puzzle (self, _tmp1_ = mult_puzzle_new (3, 2));
	_g_object_unref0 (_tmp1_);
	self->priv->canvas = (_tmp2_ = g_object_ref_sink (canvas_new (self)), _g_object_unref0 (self->priv->canvas), _tmp2_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->canvas, TRUE, TRUE, (guint) 0);
	geom = (memset (&_tmp3_, 0, sizeof (GdkGeometry)), _tmp3_);
	geom.min_aspect = GTK_MULT_ASPECT;
	geom.max_aspect = GTK_MULT_ASPECT;
	gtk_window_set_geometry_hints ((GtkWindow*) self, (GtkWidget*) self->priv->canvas, &geom, GDK_HINT_ASPECT);
	g_timer_reset (self->priv->timer);
	gtk_mult_update_timer (self);
	if (self->priv->timer_timeout_id != 0) {
		g_source_remove (self->priv->timer_timeout_id);
	}
	self->priv->timer_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _gtk_mult_update_timer_gsource_func, g_object_ref (self), g_object_unref);
	gtk_mult_set_cheated (self, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_mult_update_score (self);
	gtk_mult_on_puzzle_change (self, self->priv->_puzzle);
	if (self->priv->status_timeout_id != 0) {
		g_source_remove (self->priv->status_timeout_id);
	}
	self->priv->status_timeout_id = (guint) 0;
	g_signal_connect_object (self->priv->_puzzle, "guessed", (GCallback) _gtk_mult_on_puzzle_guess_mult_puzzle_guessed, self, 0);
	g_signal_connect_object (self->priv->_puzzle, "changed", (GCallback) _gtk_mult_on_puzzle_change_mult_puzzle_changed, self, 0);
}


static gboolean _gtk_mult_pop_guess_feedback_gsource_func (gpointer self) {
	return gtk_mult_pop_guess_feedback (self);
}


static void gtk_mult_on_puzzle_guess (GtkMult* self, MultPuzzle* p, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus response) {
	guint context_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gtk_mult_update_score (self);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	gtk_mult_clear_guess_feedback (self);
	if (mult_puzzle_get_is_done (self->priv->_puzzle)) {
		gtk_statusbar_push (self->priv->_status, context_id, _ ("Congratulations!"));
	} else {
		char* message_pattern;
		message_pattern = NULL;
		switch (response) {
			case MULT_PUZZLE_GUESS_STATUS_WRONG:
			{
				char* _tmp0_;
				message_pattern = (_tmp0_ = g_strdup (_ ("Incorrect — %1$s is not %2$s")), _g_free0 (message_pattern), _tmp0_);
				break;
			}
			case MULT_PUZZLE_GUESS_STATUS_CORRECT:
			{
				char* _tmp1_;
				message_pattern = (_tmp1_ = g_strdup (_ ("Correct — %1$s is %2$s")), _g_free0 (message_pattern), _tmp1_);
				break;
			}
			default:
			{
				break;
			}
		}
		if (message_pattern != NULL) {
			char* letter_str;
			char* digit_str;
			char* _tmp2_;
			letter_str = g_strdup_printf ("%c", (gint) ((gchar) letter));
			digit_str = g_strdup_printf ("%i", digit);
			gtk_statusbar_push (self->priv->_status, context_id, _tmp2_ = g_strdup_printf (message_pattern, _ (letter_str), _ (digit_str)));
			_g_free0 (_tmp2_);
			self->priv->status_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _gtk_mult_pop_guess_feedback_gsource_func, g_object_ref (self), g_object_unref);
			_g_free0 (letter_str);
			_g_free0 (digit_str);
		}
		_g_free0 (message_pattern);
	}
}


static void gtk_mult_on_puzzle_change (GtkMult* self, MultPuzzle* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gtk_action_set_sensitive (self->priv->solve_action, !mult_puzzle_get_is_done (p));
	gtk_action_set_sensitive (self->priv->hint_action, !mult_puzzle_get_is_done (p));
}


static gboolean gtk_mult_pop_guess_feedback (GtkMult* self) {
	gboolean result;
	guint context_id;
	g_return_val_if_fail (self != NULL, FALSE);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	gtk_statusbar_pop (self->priv->_status, context_id);
	self->priv->status_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static void gtk_mult_update_score (GtkMult* self) {
	gint wrong;
	const char* _tmp0_;
	char* text;
	g_return_if_fail (self != NULL);
	wrong = mult_puzzle_get_wrong_guesses (self->priv->_puzzle);
	_tmp0_ = NULL;
	if (self->priv->_cheated) {
		_tmp0_ = "*";
	} else {
		_tmp0_ = "";
	}
	text = g_strdup_printf ("%s: %i%s", _ ("Incorrect Guesses"), wrong, _tmp0_);
	gtk_label_set_text (self->priv->score, text);
	_g_free0 (text);
}


static gboolean gtk_mult_update_timer (GtkMult* self) {
	gboolean result;
	guint secs;
	char* text;
	g_return_val_if_fail (self != NULL, FALSE);
	if (mult_puzzle_get_is_done (self->priv->_puzzle)) {
		result = FALSE;
		return result;
	}
	secs = (guint) g_timer_elapsed (self->priv->timer, NULL);
	text = g_strdup_printf ("%s: %02u:%02u:%02u", _ ("Time"), (secs / 60) / 60, (secs / 60) % 60, secs % 60);
	gtk_label_set_text (self->priv->timer_label, text);
	result = TRUE;
	_g_free0 (text);
	return result;
}


static void gtk_mult_on_menu_deselect (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_statusbar_pop (self->priv->_status, context_id);
}


static void gtk_mult_on_menu_game_close (GtkMult* self) {
	g_return_if_fail (self != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void gtk_mult_on_menu_select_close (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("Quit Multiplication Puzzle"));
}


static void gtk_mult_on_menu_game_new (GtkMult* self) {
	g_return_if_fail (self != NULL);
	gtk_mult_new_puzzle (self);
}


static void gtk_mult_on_menu_select_new (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("Start a new game"));
}


static void gtk_mult_on_menu_game_solve (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	gtk_mult_set_cheated (self, TRUE);
	mult_puzzle_solve (self->priv->_puzzle);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("Puzzle solved"));
	gtk_mult_update_score (self);
}


static void gtk_mult_on_menu_select_solve (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("Solve this game"));
}


static void gtk_mult_on_menu_game_hint (GtkMult* self) {
	MultPuzzleChar character;
	gint digit;
	gboolean* _tmp1_;
	gint needed_size;
	gint needed_length1;
	gint _tmp0_;
	gboolean* needed;
	gint num_needed;
	gint32 choice;
	guint context_id;
	char* message_pattern;
	char* letter_str;
	char* digit_str;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	gtk_mult_set_cheated (self, TRUE);
	character = MULT_PUZZLE_CHAR_INVALID;
	digit = 0;
	needed = (_tmp1_ = mult_puzzle_get_needed_digits (self->priv->_puzzle, &_tmp0_), needed_length1 = _tmp0_, needed_size = needed_length1, _tmp1_);
	num_needed = 0;
	{
		gboolean* n_collection;
		int n_collection_length1;
		int n_it;
		n_collection = needed;
		n_collection_length1 = needed_length1;
		for (n_it = 0; n_it < needed_length1; n_it = n_it + 1) {
			gboolean n;
			n = n_collection[n_it];
			{
				gint _tmp2_ = 0;
				if (n) {
					_tmp2_ = 1;
				} else {
					_tmp2_ = 0;
				}
				num_needed = num_needed + _tmp2_;
			}
		}
	}
	if (num_needed == 0) {
		needed = (g_free (needed), NULL);
		return;
	}
	choice = g_random_int_range ((gint32) 0, (gint32) num_needed);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				if (!_tmp3_) {
					i = i + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				if (needed[i]) {
					_tmp4_ = choice == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					character = mult_puzzle_solve_digit (self->priv->_puzzle, i);
					digit = i;
					break;
				} else {
					if (needed[i]) {
						choice = choice - 1;
					}
				}
			}
		}
	}
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	gtk_mult_clear_guess_feedback (self);
	message_pattern = g_strdup (_ ("%1$s is %2$s"));
	letter_str = g_strdup_printf ("%c", (gint) ((gchar) character));
	digit_str = g_strdup_printf ("%i", digit);
	gtk_statusbar_push (self->priv->_status, context_id, _tmp5_ = g_strdup_printf (message_pattern, _ (letter_str), _ (digit_str)));
	_g_free0 (_tmp5_);
	self->priv->status_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _gtk_mult_pop_guess_feedback_gsource_func, g_object_ref (self), g_object_unref);
	gtk_mult_update_score (self);
	needed = (g_free (needed), NULL);
	_g_free0 (message_pattern);
	_g_free0 (letter_str);
	_g_free0 (digit_str);
}


static void gtk_mult_on_menu_select_hint (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("Reveal a digit at random"));
}


static void gtk_mult_handle_about_uri (GtkMult* self, GtkAboutDialog* about, const char* link) {
	GError * _inner_error_;
	GAppLaunchContext* context;
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	_inner_error_ = NULL;
	context = g_app_launch_context_new ();
	{
		g_app_info_launch_default_for_uri (link, context, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * er;
		er = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp0_;
			GtkMessageDialog* _tmp1_;
			GtkMessageDialog* dlg;
			dlg = (_tmp1_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "<b>%s</b>", _tmp0_ = g_strdup_printf (_ ("Could not display %s"), link), NULL)), _g_free0 (_tmp0_), _tmp1_);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			_g_error_free0 (er);
			_g_object_unref0 (dlg);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (context);
}


static void gtk_mult_handle_about_mail (GtkMult* self, GtkAboutDialog* about, const char* link) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	gtk_mult_handle_about_uri (self, about, _tmp0_ = g_strdup_printf ("mailto:%s", link));
	_g_free0 (_tmp0_);
}


static void _gtk_mult_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	gtk_mult_handle_about_mail (self, about, link_);
}


static void _gtk_mult_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	gtk_mult_handle_about_uri (self, about, link_);
}


static void _lambda0_ (GtkAboutDialog* dlg, gint resp, GtkMult* self) {
	g_return_if_fail (dlg != NULL);
	gtk_object_destroy ((GtkObject*) dlg);
	gtk_mult_set_about (self, NULL);
}


static void __lambda0__gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (_sender, response_id, self);
}


static void gtk_mult_on_menu_help_about (GtkMult* self) {
	GtkAboutDialog* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->_about != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->_about);
		return;
	}
	gtk_mult_set_about (self, _tmp0_ = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ()));
	_g_object_unref0 (_tmp0_);
	gtk_about_dialog_set_email_hook (_gtk_mult_handle_about_mail_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_about_dialog_set_url_hook (_gtk_mult_handle_about_uri_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_window_set_title ((GtkWindow*) self->priv->_about, _ ("About Multiplication Puzzle"));
	gtk_about_dialog_set_authors (self->priv->_about, GTK_MULT_authors);
	gtk_about_dialog_set_artists (self->priv->_about, GTK_MULT_artists);
	gtk_about_dialog_set_translator_credits (self->priv->_about, _ ("translator-credits"));
	gtk_about_dialog_set_logo_icon_name (self->priv->_about, PACKAGE);
	gtk_about_dialog_set_version (self->priv->_about, VERSION);
	gtk_about_dialog_set_copyright (self->priv->_about, "© 2003—2010 Michael Terry");
	gtk_about_dialog_set_website (self->priv->_about, "https://launchpad.net/gmult");
	gtk_about_dialog_set_license (self->priv->_about, _tmp1_ = g_strdup_printf ("%s\n\n%s\n\n%s", _ ("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version."), _ ("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details."), _ ("You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.")));
	_g_free0 (_tmp1_);
	gtk_about_dialog_set_wrap_license (self->priv->_about, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_about, (GtkWindow*) self);
	g_signal_connect_object ((GtkDialog*) self->priv->_about, "response", (GCallback) __lambda0__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->_about);
}


static void gtk_mult_on_menu_select_about (GtkMult* self) {
	guint context_id;
	g_return_if_fail (self != NULL);
	context_id = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	gtk_mult_clear_guess_feedback (self);
	gtk_statusbar_push (self->priv->_status, context_id, _ ("About Multiplication Puzzle"));
}


gint gtk_mult_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	GOptionContext* context;
	GtkMult* window;
	_inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	context = g_option_context_new ("");
	g_option_context_add_group (context, gtk_get_option_group (FALSE));
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp0_;
			g_printerr ("%s\n\n%s", e->message, _tmp0_ = g_option_context_get_help (context, TRUE, NULL));
			_g_free0 (_tmp0_);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (context);
			return result;
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&args_length1, &args);
	g_set_application_name (_ ("Multiplication Puzzle"));
	gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), THEME_DIR);
	gtk_window_set_default_icon_name (PACKAGE);
	window = g_object_ref_sink (gtk_mult_new ());
	gtk_widget_show_all ((GtkWidget*) window);
	gtk_main ();
	result = 0;
	_g_option_context_free0 (context);
	_g_object_unref0 (window);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gtk_mult_main (argv, argc);
}


GtkMult* gtk_mult_construct (GType object_type) {
	GtkMult * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkMult* gtk_mult_new (void) {
	return gtk_mult_construct (TYPE_GTK_MULT);
}


MultPuzzle* gtk_mult_get_puzzle (GtkMult* self) {
	MultPuzzle* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_puzzle;
	return result;
}


static void gtk_mult_set_puzzle (GtkMult* self, MultPuzzle* value) {
	MultPuzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_puzzle = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_puzzle), _tmp0_);
	g_object_notify ((GObject *) self, "puzzle");
}


gboolean gtk_mult_get_cheated (GtkMult* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cheated;
	return result;
}


static void gtk_mult_set_cheated (GtkMult* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_cheated = value;
	g_object_notify ((GObject *) self, "cheated");
}


GtkStatusbar* gtk_mult_get_status (GtkMult* self) {
	GtkStatusbar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
	return result;
}


static void gtk_mult_set_status (GtkMult* self, GtkStatusbar* value) {
	GtkStatusbar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_status = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_status), _tmp0_);
	g_object_notify ((GObject *) self, "status");
}


static GtkAboutDialog* gtk_mult_get_about (GtkMult* self) {
	GtkAboutDialog* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_about;
	return result;
}


static void gtk_mult_set_about (GtkMult* self, GtkAboutDialog* value) {
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_about = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_about), _tmp0_);
}


static gboolean _gtk_mult_handle_key_press_gtk_widget_key_press_event (GtkMult* _sender, GdkEventKey* event, gpointer self) {
	return gtk_mult_handle_key_press (self, _sender, event);
}


static void _gtk_main_quit_gtk_object_destroy (GtkMult* _sender, gpointer self) {
	gtk_main_quit ();
}


static GObject * gtk_mult_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GtkMult * self;
	parent_class = G_OBJECT_CLASS (gtk_mult_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTK_MULT (obj);
	{
		GtkVBox* _tmp0_;
		GtkLabel* _tmp1_;
		Canvas* _tmp2_;
		GtkAction* _tmp3_;
		GtkAction* _tmp4_;
		GTimer* _tmp5_;
		GtkLabel* _tmp6_;
		GValue _tmp7_ = {0};
		GValue dpiValue;
		gint height;
		GtkVBox* vb;
		GtkHBox* _tmp8_;
		GtkWidget* _tmp9_;
		GtkEventBox* eb;
		GtkEventBox* _tmp10_;
		self->priv->vbox = (_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (self->priv->vbox), _tmp0_);
		gtk_mult_set_status (self, NULL);
		self->priv->score = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->score), _tmp1_);
		self->priv->canvas = (_tmp2_ = NULL, _g_object_unref0 (self->priv->canvas), _tmp2_);
		self->priv->status_timeout_id = (guint) 0;
		self->priv->solve_action = (_tmp3_ = NULL, _g_object_unref0 (self->priv->solve_action), _tmp3_);
		self->priv->hint_action = (_tmp4_ = NULL, _g_object_unref0 (self->priv->hint_action), _tmp4_);
		self->priv->timer = (_tmp5_ = g_timer_new (), _g_timer_destroy0 (self->priv->timer), _tmp5_);
		self->priv->timer_label = (_tmp6_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->timer_label), _tmp6_);
		self->priv->timer_timeout_id = (guint) 0;
		dpiValue = (g_value_init (&_tmp7_, G_TYPE_INT), _tmp7_);
		gdk_screen_get_setting (gtk_window_get_screen ((GtkWindow*) self), "gtk-xft-dpi", &dpiValue);
		gtk_mult_dpi = g_value_get_int (&dpiValue) / PANGO_SCALE;
		height = 4 * gtk_mult_dpi;
		gtk_window_set_default_size ((GtkWindow*) self, (gint) (height * GTK_MULT_ASPECT), height);
		vb = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
		self->priv->status_box = (_tmp8_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (self->priv->status_box), _tmp8_);
		gtk_box_pack_start ((GtkBox*) vb, _tmp9_ = gtk_mult_setup_menu (self), FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp9_);
		gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) self->priv->vbox, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) self->priv->status_box, FALSE, FALSE, (guint) 0);
		eb = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
		gtk_container_add ((GtkContainer*) eb, (GtkWidget*) self->priv->score);
		gtk_container_set_border_width ((GtkContainer*) eb, (guint) 5);
		gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) eb, FALSE, FALSE, (guint) 0);
		eb = (_tmp10_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (eb), _tmp10_);
		gtk_container_add ((GtkContainer*) eb, (GtkWidget*) self->priv->timer_label);
		gtk_container_set_border_width ((GtkContainer*) eb, (guint) 5);
		gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) eb, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) vb);
		gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_KEY_PRESS_MASK);
		g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _gtk_mult_handle_key_press_gtk_widget_key_press_event, self, 0);
		gtk_window_set_title ((GtkWindow*) self, _ ("Multiplication Puzzle"));
		gtk_mult_new_puzzle (self);
		g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
		G_IS_VALUE (&dpiValue) ? (g_value_unset (&dpiValue), NULL) : NULL;
		_g_object_unref0 (vb);
		_g_object_unref0 (eb);
	}
	return obj;
}


static void gtk_mult_class_init (GtkMultClass * klass) {
	gtk_mult_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkMultPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtk_mult_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtk_mult_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtk_mult_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtk_mult_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_MULT_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_CHEATED, g_param_spec_boolean ("cheated", "cheated", "cheated", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_STATUS, g_param_spec_object ("status", "status", "status", GTK_TYPE_STATUSBAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	gtk_mult_a_char = g_unichar_toupper (g_utf8_get_char (_ ("A")));
	gtk_mult_b_char = g_unichar_toupper (g_utf8_get_char (_ ("B")));
	gtk_mult_c_char = g_unichar_toupper (g_utf8_get_char (_ ("C")));
	gtk_mult_d_char = g_unichar_toupper (g_utf8_get_char (_ ("D")));
	gtk_mult_e_char = g_unichar_toupper (g_utf8_get_char (_ ("E")));
	gtk_mult_f_char = g_unichar_toupper (g_utf8_get_char (_ ("F")));
	gtk_mult_g_char = g_unichar_toupper (g_utf8_get_char (_ ("G")));
	gtk_mult_h_char = g_unichar_toupper (g_utf8_get_char (_ ("H")));
	gtk_mult_i_char = g_unichar_toupper (g_utf8_get_char (_ ("I")));
	gtk_mult_j_char = g_unichar_toupper (g_utf8_get_char (_ ("J")));
	gtk_mult_0_char = g_unichar_toupper (g_utf8_get_char (_ ("0")));
	gtk_mult_1_char = g_unichar_toupper (g_utf8_get_char (_ ("1")));
	gtk_mult_2_char = g_unichar_toupper (g_utf8_get_char (_ ("2")));
	gtk_mult_3_char = g_unichar_toupper (g_utf8_get_char (_ ("3")));
	gtk_mult_4_char = g_unichar_toupper (g_utf8_get_char (_ ("4")));
	gtk_mult_5_char = g_unichar_toupper (g_utf8_get_char (_ ("5")));
	gtk_mult_6_char = g_unichar_toupper (g_utf8_get_char (_ ("6")));
	gtk_mult_7_char = g_unichar_toupper (g_utf8_get_char (_ ("7")));
	gtk_mult_8_char = g_unichar_toupper (g_utf8_get_char (_ ("8")));
	gtk_mult_9_char = g_unichar_toupper (g_utf8_get_char (_ ("9")));
}


static void gtk_mult_instance_init (GtkMult * self) {
	self->priv = GTK_MULT_GET_PRIVATE (self);
	self->priv->_about = NULL;
}


static void gtk_mult_finalize (GObject* obj) {
	GtkMult * self;
	self = GTK_MULT (obj);
	_g_object_unref0 (self->priv->_puzzle);
	_g_object_unref0 (self->priv->_status);
	_g_object_unref0 (self->priv->solve_action);
	_g_object_unref0 (self->priv->hint_action);
	_g_object_unref0 (self->priv->canvas);
	_g_object_unref0 (self->priv->vbox);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->timer_label);
	_g_object_unref0 (self->priv->score);
	_g_object_unref0 (self->priv->status_box);
	_g_object_unref0 (self->priv->_about);
	G_OBJECT_CLASS (gtk_mult_parent_class)->finalize (obj);
}


GType gtk_mult_get_type (void) {
	static GType gtk_mult_type_id = 0;
	if (gtk_mult_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkMultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtk_mult_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkMult), 0, (GInstanceInitFunc) gtk_mult_instance_init, NULL };
		gtk_mult_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GtkMult", &g_define_type_info, 0);
	}
	return gtk_mult_type_id;
}


static void gtk_mult_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkMult * self;
	self = GTK_MULT (object);
	switch (property_id) {
		case GTK_MULT_PUZZLE:
		g_value_set_object (value, gtk_mult_get_puzzle (self));
		break;
		case GTK_MULT_CHEATED:
		g_value_set_boolean (value, gtk_mult_get_cheated (self));
		break;
		case GTK_MULT_STATUS:
		g_value_set_object (value, gtk_mult_get_status (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtk_mult_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkMult * self;
	self = GTK_MULT (object);
	switch (property_id) {
		case GTK_MULT_PUZZLE:
		gtk_mult_set_puzzle (self, g_value_get_object (value));
		break;
		case GTK_MULT_CHEATED:
		gtk_mult_set_cheated (self, g_value_get_boolean (value));
		break;
		case GTK_MULT_STATUS:
		gtk_mult_set_status (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




