/* DigitBox.c generated by valac, the Vala compiler
 * generated from DigitBox.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _CharBoxPrivate CharBoxPrivate;

#define TYPE_DIGIT_BOX (digit_box_get_type ())
#define DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGIT_BOX, DigitBox))
#define DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGIT_BOX, DigitBoxClass))
#define IS_DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGIT_BOX))
#define IS_DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGIT_BOX))
#define DIGIT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGIT_BOX, DigitBoxClass))

typedef struct _DigitBox DigitBox;
typedef struct _DigitBoxClass DigitBoxClass;
typedef struct _DigitBoxPrivate DigitBoxPrivate;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CANVAS_MODE (canvas_mode_get_type ())

struct _CharBox {
	GtkEventBox parent_instance;
	CharBoxPrivate * priv;
};

struct _CharBoxClass {
	GtkEventBoxClass parent_class;
};

struct _DigitBox {
	CharBox parent_instance;
	DigitBoxPrivate * priv;
};

struct _DigitBoxClass {
	CharBoxClass parent_class;
};

struct _DigitBoxPrivate {
	Canvas* _canvas;
};

typedef enum  {
	CANVAS_MODE_NONE,
	CANVAS_MODE_DIGIT,
	CANVAS_MODE_CHAR
} CanvasMode;


static gpointer digit_box_parent_class = NULL;

GType char_box_get_type (void);
GType digit_box_get_type (void);
GType canvas_get_type (void);
#define DIGIT_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIGIT_BOX, DigitBoxPrivate))
enum  {
	DIGIT_BOX_DUMMY_PROPERTY,
	DIGIT_BOX_CANVAS
};
DigitBox* digit_box_new (Canvas* canvas, const char* letter);
DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter);
Canvas* digit_box_get_canvas (DigitBox* self);
GType canvas_mode_get_type (void);
void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box);
static void digit_box_handle_drag_begin (DigitBox* self, DigitBox* box, GdkDragContext* context);
static void digit_box_handle_drag_end (DigitBox* self, DigitBox* box, GdkDragContext* context);
const char* char_box_get_letter (CharBox* self);
static void digit_box_handle_drag_get (DigitBox* self, DigitBox* box, GdkDragContext* context, GtkSelectionData* data, guint info, guint time_);
static void digit_box_set_canvas (DigitBox* self, Canvas* value);
void char_box_set_border (CharBox* self, GtkShadowType value);
static void _digit_box_handle_drag_get_gtk_widget_drag_data_get (DigitBox* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void _digit_box_handle_drag_begin_gtk_widget_drag_begin (DigitBox* _sender, GdkDragContext* context, gpointer self);
static void _digit_box_handle_drag_end_gtk_widget_drag_end (DigitBox* _sender, GdkDragContext* context, gpointer self);
static GObject * digit_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void digit_box_finalize (GObject* obj);
static void digit_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void digit_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter) {
	DigitBox * self;
	g_return_val_if_fail (canvas != NULL, NULL);
	g_return_val_if_fail (letter != NULL, NULL);
	self = (DigitBox*) g_object_new (object_type, "canvas", canvas, "letter", letter, NULL);
	return self;
}


DigitBox* digit_box_new (Canvas* canvas, const char* letter) {
	return digit_box_construct (TYPE_DIGIT_BOX, canvas, letter);
}


static void digit_box_handle_drag_begin (DigitBox* self, DigitBox* box, GdkDragContext* context) {
	gint width = 0;
	gint height = 0;
	GdkGC* gc;
	GdkPixmap* pixmap;
	gint x = 0;
	gint y = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	canvas_set_mode (self->priv->_canvas, CANVAS_MODE_DIGIT, (CharBox*) box);
	gdk_window_invalidate_region (((GtkWidget*) box)->window, gdk_drawable_get_visible_region ((GdkDrawable*) ((GtkWidget*) box)->window), TRUE);
	gdk_window_process_updates (((GtkWidget*) box)->window, TRUE);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) self)->window, &width, &height);
	gc = gdk_gc_new ((GdkDrawable*) ((GtkWidget*) self)->window);
	pixmap = gdk_pixmap_new ((GdkDrawable*) ((GtkWidget*) self)->window, width, height, -1);
	gdk_draw_drawable ((GdkDrawable*) pixmap, gc, (GdkDrawable*) ((GtkWidget*) self)->window, 0, 0, 0, 0, width, height);
	gtk_widget_get_pointer ((GtkWidget*) self, &x, &y);
	x = CLAMP (x, 0, width);
	y = CLAMP (y, 0, height);
	gtk_drag_set_icon_pixmap (context, gc->colormap, pixmap, NULL, x, y);
	gtk_widget_hide ((GtkWidget*) self);
	_g_object_unref0 (gc);
	_g_object_unref0 (pixmap);
}


static void digit_box_handle_drag_end (DigitBox* self, DigitBox* box, GdkDragContext* context) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	gtk_widget_show ((GtkWidget*) self);
}


static void digit_box_handle_drag_get (DigitBox* self, DigitBox* box, GdkDragContext* context, GtkSelectionData* data, guint info, guint time_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	gtk_selection_data_set_text (data, char_box_get_letter ((CharBox*) self), (gint) strlen (char_box_get_letter ((CharBox*) self)));
}


Canvas* digit_box_get_canvas (DigitBox* self) {
	Canvas* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_canvas;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void digit_box_set_canvas (DigitBox* self, Canvas* value) {
	Canvas* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_canvas = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_canvas), _tmp0_);
	g_object_notify ((GObject *) self, "canvas");
}


static void _digit_box_handle_drag_get_gtk_widget_drag_data_get (DigitBox* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	digit_box_handle_drag_get (self, _sender, context, selection_data, info, time_);
}


static void _digit_box_handle_drag_begin_gtk_widget_drag_begin (DigitBox* _sender, GdkDragContext* context, gpointer self) {
	digit_box_handle_drag_begin (self, _sender, context);
}


static void _digit_box_handle_drag_end_gtk_widget_drag_end (DigitBox* _sender, GdkDragContext* context, gpointer self) {
	digit_box_handle_drag_end (self, _sender, context);
}


static GObject * digit_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DigitBox * self;
	parent_class = G_OBJECT_CLASS (digit_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DIGIT_BOX (obj);
	{
		GtkTargetEntry* _tmp0_;
		gint entries_size;
		gint entries_length1;
		GtkTargetEntry* entries;
		char_box_set_border ((CharBox*) self, GTK_SHADOW_OUT);
		entries = (_tmp0_ = g_new0 (GtkTargetEntry, 1), entries_length1 = 1, entries_size = entries_length1, _tmp0_);
		entries[0].target = "STRING";
		entries[0].flags = (guint) GTK_TARGET_SAME_APP;
		entries[0].info = (guint) 0;
		gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, entries, entries_length1, GDK_ACTION_MOVE);
		g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) _digit_box_handle_drag_get_gtk_widget_drag_data_get, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) _digit_box_handle_drag_begin_gtk_widget_drag_begin, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) _digit_box_handle_drag_end_gtk_widget_drag_end, self, 0);
		N_ ("0");
		N_ ("1");
		N_ ("2");
		N_ ("3");
		N_ ("4");
		N_ ("5");
		N_ ("6");
		N_ ("7");
		N_ ("8");
		N_ ("9");
		entries = (g_free (entries), NULL);
	}
	return obj;
}


static void digit_box_class_init (DigitBoxClass * klass) {
	digit_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DigitBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = digit_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = digit_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = digit_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = digit_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGIT_BOX_CANVAS, g_param_spec_object ("canvas", "canvas", "canvas", TYPE_CANVAS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void digit_box_instance_init (DigitBox * self) {
	self->priv = DIGIT_BOX_GET_PRIVATE (self);
}


static void digit_box_finalize (GObject* obj) {
	DigitBox * self;
	self = DIGIT_BOX (obj);
	_g_object_unref0 (self->priv->_canvas);
	G_OBJECT_CLASS (digit_box_parent_class)->finalize (obj);
}


GType digit_box_get_type (void) {
	static GType digit_box_type_id = 0;
	if (digit_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DigitBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) digit_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DigitBox), 0, (GInstanceInitFunc) digit_box_instance_init, NULL };
		digit_box_type_id = g_type_register_static (TYPE_CHAR_BOX, "DigitBox", &g_define_type_info, 0);
	}
	return digit_box_type_id;
}


static void digit_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DigitBox * self;
	self = DIGIT_BOX (object);
	switch (property_id) {
		case DIGIT_BOX_CANVAS:
		g_value_set_object (value, digit_box_get_canvas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void digit_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DigitBox * self;
	self = DIGIT_BOX (object);
	switch (property_id) {
		case DIGIT_BOX_CANVAS:
		digit_box_set_canvas (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




