/* CharBox.c generated by valac, the Vala compiler
 * generated from CharBox.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _CharBoxPrivate CharBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _CharBox {
	GtkEventBox parent_instance;
	CharBoxPrivate * priv;
};

struct _CharBoxClass {
	GtkEventBoxClass parent_class;
};

struct _CharBoxPrivate {
	char* _letter;
	GtkShadowType _border;
	gint _points;
	GtkStateType _highlight;
	GtkDrawingArea* area;
};


static gpointer char_box_parent_class = NULL;

GType char_box_get_type (void);
#define CHAR_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHAR_BOX, CharBoxPrivate))
enum  {
	CHAR_BOX_DUMMY_PROPERTY,
	CHAR_BOX_LETTER,
	CHAR_BOX_BORDER,
	CHAR_BOX_POINTS,
	CHAR_BOX_HIGHLIGHT
};
GtkShadowType char_box_get_border (CharBox* self);
GtkStateType char_box_get_highlight (CharBox* self);
gint char_box_get_points (CharBox* self);
const char* char_box_get_letter (CharBox* self);
static gboolean char_box_exposed (CharBox* self, GtkDrawingArea* da, GdkEventExpose* event);
void char_box_set_letter (CharBox* self, const char* value);
void char_box_set_border (CharBox* self, GtkShadowType value);
CharBox* char_box_new (const char* letter, GtkShadowType border);
CharBox* char_box_construct (GType object_type, const char* letter, GtkShadowType border);
void char_box_set_points (CharBox* self, gint value);
void char_box_set_highlight (CharBox* self, GtkStateType value);
static gboolean _char_box_exposed_gtk_widget_expose_event (GtkDrawingArea* _sender, GdkEventExpose* event, gpointer self);
static GObject * char_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void char_box_finalize (GObject* obj);
static void char_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void char_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean char_box_exposed (CharBox* self, GtkDrawingArea* da, GdkEventExpose* event) {
	gboolean result;
	gint w;
	gint h;
	GtkStyle* style;
	cairo_t* ctx;
	GdkColor fg_color;
	cairo_text_extents_t _tmp0_ = {0};
	cairo_text_extents_t te;
	cairo_font_extents_t _tmp1_ = {0};
	cairo_font_extents_t fe;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	w = ((GtkWidget*) da)->allocation.width;
	h = ((GtkWidget*) da)->allocation.height;
	style = _g_object_ref0 (gtk_widget_get_style ((GtkWidget*) self));
	if (self->priv->_border != GTK_SHADOW_NONE) {
		gtk_paint_box (style, ((GtkWidget*) da)->window, char_box_get_highlight (self), self->priv->_border, NULL, NULL, NULL, 0, 0, w, h);
	}
	ctx = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) da)->window);
	fg_color = style->fg[(gint) char_box_get_highlight (self)];
	cairo_set_source_rgb (ctx, fg_color.red / 65535.0, fg_color.green / 65535.0, fg_color.blue / 65535.0);
	cairo_set_font_size (ctx, (double) self->priv->_points);
	te = (memset (&_tmp0_, 0, sizeof (cairo_text_extents_t)), _tmp0_);
	cairo_text_extents (ctx, _ (self->priv->_letter), &te);
	fe = (memset (&_tmp1_, 0, sizeof (cairo_font_extents_t)), _tmp1_);
	cairo_font_extents (ctx, &fe);
	cairo_move_to (ctx, ((w / 2) - te.x_bearing) - (te.width / 2), ((h / 2) - fe.descent) + (fe.height / 2));
	cairo_show_text (ctx, _ (self->priv->_letter));
	result = TRUE;
	_g_object_unref0 (style);
	_cairo_destroy0 (ctx);
	return result;
}


CharBox* char_box_construct (GType object_type, const char* letter, GtkShadowType border) {
	CharBox * self;
	g_return_val_if_fail (letter != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	char_box_set_letter (self, letter);
	char_box_set_border (self, border);
	return self;
}


CharBox* char_box_new (const char* letter, GtkShadowType border) {
	return char_box_construct (TYPE_CHAR_BOX, letter, border);
}


const char* char_box_get_letter (CharBox* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_letter;
	return result;
}


void char_box_set_letter (CharBox* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_letter = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_letter), _tmp0_);
	g_object_notify ((GObject *) self, "letter");
}


GtkShadowType char_box_get_border (CharBox* self) {
	GtkShadowType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border;
	return result;
}


void char_box_set_border (CharBox* self, GtkShadowType value) {
	g_return_if_fail (self != NULL);
	self->priv->_border = value;
	g_object_notify ((GObject *) self, "border");
}


gint char_box_get_points (CharBox* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_points;
	return result;
}


void char_box_set_points (CharBox* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_points = value;
	g_object_notify ((GObject *) self, "points");
}


GtkStateType char_box_get_highlight (CharBox* self) {
	GtkStateType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_highlight;
	return result;
}


void char_box_set_highlight (CharBox* self, GtkStateType value) {
	g_return_if_fail (self != NULL);
	self->priv->_highlight = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "highlight");
}


static gboolean _char_box_exposed_gtk_widget_expose_event (GtkDrawingArea* _sender, GdkEventExpose* event, gpointer self) {
	return char_box_exposed (self, _sender, event);
}


static GObject * char_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CharBox * self;
	parent_class = G_OBJECT_CLASS (char_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CHAR_BOX (obj);
	{
		GtkDrawingArea* _tmp0_;
		self->priv->area = (_tmp0_ = g_object_ref_sink ((GtkDrawingArea*) gtk_drawing_area_new ()), _g_object_unref0 (self->priv->area), _tmp0_);
		g_signal_connect_object ((GtkWidget*) self->priv->area, "expose-event", (GCallback) _char_box_exposed_gtk_widget_expose_event, self, 0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->area);
	}
	return obj;
}


static void char_box_class_init (CharBoxClass * klass) {
	char_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CharBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = char_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = char_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = char_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = char_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_LETTER, g_param_spec_string ("letter", "letter", "letter", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_BORDER, g_param_spec_enum ("border", "border", "border", GTK_TYPE_SHADOW_TYPE, GTK_SHADOW_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_POINTS, g_param_spec_int ("points", "points", "points", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHAR_BOX_HIGHLIGHT, g_param_spec_enum ("highlight", "highlight", "highlight", GTK_TYPE_STATE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void char_box_instance_init (CharBox * self) {
	self->priv = CHAR_BOX_GET_PRIVATE (self);
	self->priv->_letter = g_strdup ("?");
	self->priv->_border = GTK_SHADOW_NONE;
	self->priv->_highlight = GTK_STATE_NORMAL;
}


static void char_box_finalize (GObject* obj) {
	CharBox * self;
	self = CHAR_BOX (obj);
	_g_free0 (self->priv->_letter);
	_g_object_unref0 (self->priv->area);
	G_OBJECT_CLASS (char_box_parent_class)->finalize (obj);
}


GType char_box_get_type (void) {
	static GType char_box_type_id = 0;
	if (char_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (CharBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) char_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CharBox), 0, (GInstanceInitFunc) char_box_instance_init, NULL };
		char_box_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "CharBox", &g_define_type_info, 0);
	}
	return char_box_type_id;
}


static void char_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CharBox * self;
	self = CHAR_BOX (object);
	switch (property_id) {
		case CHAR_BOX_LETTER:
		g_value_set_string (value, char_box_get_letter (self));
		break;
		case CHAR_BOX_BORDER:
		g_value_set_enum (value, char_box_get_border (self));
		break;
		case CHAR_BOX_POINTS:
		g_value_set_int (value, char_box_get_points (self));
		break;
		case CHAR_BOX_HIGHLIGHT:
		g_value_set_enum (value, char_box_get_highlight (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void char_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CharBox * self;
	self = CHAR_BOX (object);
	switch (property_id) {
		case CHAR_BOX_LETTER:
		char_box_set_letter (self, g_value_get_string (value));
		break;
		case CHAR_BOX_BORDER:
		char_box_set_border (self, g_value_get_enum (value));
		break;
		case CHAR_BOX_POINTS:
		char_box_set_points (self, g_value_get_int (value));
		break;
		case CHAR_BOX_HIGHLIGHT:
		char_box_set_highlight (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




