/* Canvas.c generated by valac, the Vala compiler
 * generated from Canvas.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_CANVAS_MODE (canvas_mode_get_type ())

#define TYPE_ARRAY_BOX (array_box_get_type ())

#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _ArrayBox ArrayBox;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
typedef struct _CanvasPrivate CanvasPrivate;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_GTK_MULT (gtk_mult_get_type ())
#define GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_MULT, GtkMult))
#define GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_MULT, GtkMultClass))
#define IS_GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_MULT))
#define IS_GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_MULT))
#define GTK_MULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_MULT, GtkMultClass))

typedef struct _GtkMult GtkMult;
typedef struct _GtkMultClass GtkMultClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())

#define TYPE_TABLE_BOX (table_box_get_type ())
#define TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TABLE_BOX, TableBox))
#define TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TABLE_BOX, TableBoxClass))
#define IS_TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TABLE_BOX))
#define IS_TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TABLE_BOX))
#define TABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TABLE_BOX, TableBoxClass))

typedef struct _TableBox TableBox;
typedef struct _TableBoxClass TableBoxClass;

#define TYPE_DIGIT_BOX (digit_box_get_type ())
#define DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGIT_BOX, DigitBox))
#define DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGIT_BOX, DigitBoxClass))
#define IS_DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGIT_BOX))
#define IS_DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGIT_BOX))
#define DIGIT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGIT_BOX, DigitBoxClass))

typedef struct _DigitBox DigitBox;
typedef struct _DigitBoxClass DigitBoxClass;

typedef enum  {
	CANVAS_MODE_NONE,
	CANVAS_MODE_DIGIT,
	CANVAS_MODE_CHAR
} CanvasMode;

struct _ArrayBox {
	CharBox** array;
	gint array_length1;
	gint array_size;
};

struct _Canvas {
	GtkEventBox parent_instance;
	CanvasPrivate * priv;
};

struct _CanvasClass {
	GtkEventBoxClass parent_class;
};

struct _CanvasPrivate {
	MultPuzzle* _puzzle;
	GtkMult* _mult;
	char* mode_letter;
	CanvasMode mode;
	gint min_box_request;
	gint num_box_rows;
	gint num_box_cols;
	gint min_width;
	gint min_height;
	GtkFixed* fixed;
	GtkWidget* vsep;
	GtkWidget* hsep1;
	GtkWidget* hsep2;
	GList* mult_boxes;
	GList* digit_boxes;
	CharBox** xboxes;
	gint xboxes_length1;
	gint xboxes_size;
	CharBox** yboxes;
	gint yboxes_length1;
	gint yboxes_size;
	CharBox** zboxes;
	gint zboxes_length1;
	gint zboxes_size;
	ArrayBox* addboxes;
	gint addboxes_length1;
	gint addboxes_size;
	CharBox** digitboxes;
	gint digitboxes_length1;
	gint digitboxes_size;
	CharBox* plusbox;
	CharBox* timesbox;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;


extern gint gtk_mult_dpi;
static gpointer canvas_parent_class = NULL;

GType canvas_mode_get_type (void);
GType array_box_get_type (void);
GType char_box_get_type (void);
ArrayBox* array_box_dup (const ArrayBox* self);
void array_box_free (ArrayBox* self);
void array_box_copy (const ArrayBox* self, ArrayBox* dest);
void array_box_destroy (ArrayBox* self);
static CharBox** _vala_array_dup1 (CharBox** self, int length);
GType canvas_get_type (void);
GType mult_puzzle_get_type (void);
GType gtk_mult_get_type (void);
#define CANVAS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANVAS, CanvasPrivate))
enum  {
	CANVAS_DUMMY_PROPERTY,
	CANVAS_PUZZLE,
	CANVAS_MULT
};
static void _g_list_free_g_object_unref (GList* self);
static void _vala_ArrayBox_array_free (ArrayBox* array, gint array_length);
#define CANVAS_SPACING 6
Canvas* canvas_new (GtkMult* mult);
Canvas* canvas_construct (GType object_type, GtkMult* mult);
void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box);
void canvas_clear_mode (Canvas* self);
const char* char_box_get_letter (CharBox* self);
void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all);
GtkMult* canvas_get_mult (Canvas* self);
GtkStatusbar* gtk_mult_get_status (GtkMult* self);
void gtk_mult_clear_guess_feedback (GtkMult* self);
void canvas_start_digit_choice (Canvas* self, CharBox* b);
void canvas_start_char_choice (Canvas* self, CharBox* b);
void canvas_start_choice (Canvas* self, gchar ch);
GtkStateType char_box_get_highlight (CharBox* self);
MultPuzzle* canvas_get_puzzle (Canvas* self);
GType mult_puzzle_char_get_type (void);
GType mult_puzzle_guess_status_get_type (void);
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
static void canvas_allocate_box (Canvas* self, CharBox* b, GdkRectangle* rect);
static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset);
void char_box_set_points (CharBox* self, gint value);
guint mult_puzzle_get_num_addends (MultPuzzle* self);
static void canvas_handle_size_allocate (Canvas* self, GtkFixed* box, GdkRectangle* rect);
CharBox* char_box_new (const char* letter, GtkShadowType border);
CharBox* char_box_construct (GType object_type, const char* letter, GtkShadowType border);
TableBox* table_box_new (gchar c, Canvas* can);
TableBox* table_box_construct (GType object_type, gchar c, Canvas* can);
GType table_box_get_type (void);
static gboolean canvas_handle_char_release (Canvas* self, CharBox* box, GdkEventButton* event);
static gboolean _canvas_handle_char_release_gtk_widget_button_release_event (CharBox* _sender, GdkEventButton* event, gpointer self);
static gboolean canvas_handle_mult_enter_notify (Canvas* self, CharBox* box, GdkEventCrossing* event);
static gboolean _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self);
static gboolean canvas_handle_mult_leave_notify (Canvas* self, CharBox* box, GdkEventCrossing* event);
static gboolean _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self);
static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch);
DigitBox* digit_box_new (Canvas* canvas, const char* letter);
DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter);
GType digit_box_get_type (void);
static gboolean canvas_handle_digit_release (Canvas* self, CharBox* box, GdkEventButton* event);
static gboolean _canvas_handle_digit_release_gtk_widget_button_release_event (CharBox* _sender, GdkEventButton* event, gpointer self);
static gboolean canvas_handle_digit_enter_notify (Canvas* self, CharBox* box, GdkEventCrossing* event);
static gboolean _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self);
static gboolean canvas_handle_digit_leave_notify (Canvas* self, CharBox* box, GdkEventCrossing* event);
static gboolean _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self);
static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i);
char* mult_puzzle_get_multiplicand (MultPuzzle* self);
char* mult_puzzle_get_multiplier (MultPuzzle* self);
char* mult_puzzle_get_addend (MultPuzzle* self, gint n);
char* mult_puzzle_get_answer (MultPuzzle* self);
gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
void char_box_set_highlight (CharBox* self, GtkStateType value);
static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
static gboolean canvas_handle_release (Canvas* self, CharBox* box, GdkEventButton* event, gboolean digit_box);
static gboolean canvas_handle_none_release (Canvas* self, Canvas* canvas, GdkEventButton* event);
static void canvas_set_puzzle (Canvas* self, MultPuzzle* value);
static void canvas_set_mult (Canvas* self, GtkMult* value);
MultPuzzle* gtk_mult_get_puzzle (GtkMult* self);
static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (Canvas* _sender, GdkEventButton* event, gpointer self);
static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkFixed* _sender, GdkRectangle* allocation, gpointer self);
static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self);
static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void canvas_finalize (GObject* obj);
static void canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType canvas_mode_get_type (void) {
	static GType canvas_mode_type_id = 0;
	if (G_UNLIKELY (canvas_mode_type_id == 0)) {
		static const GEnumValue values[] = {{CANVAS_MODE_NONE, "CANVAS_MODE_NONE", "none"}, {CANVAS_MODE_DIGIT, "CANVAS_MODE_DIGIT", "digit"}, {CANVAS_MODE_CHAR, "CANVAS_MODE_CHAR", "char"}, {0, NULL, NULL}};
		canvas_mode_type_id = g_enum_register_static ("CanvasMode", values);
	}
	return canvas_mode_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static CharBox** _vala_array_dup1 (CharBox** self, int length) {
	CharBox** result;
	int i;
	result = g_new0 (CharBox*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


void array_box_copy (const ArrayBox* self, ArrayBox* dest) {
	CharBox** _tmp0_;
	dest->array = (_tmp0_ = self->array, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, (*self).array_length1));
	dest->array_length1 = self->array_length1;
}


void array_box_destroy (ArrayBox* self) {
	self->array = (_vala_array_free (self->array, (*self).array_length1, (GDestroyNotify) g_object_unref), NULL);
}


ArrayBox* array_box_dup (const ArrayBox* self) {
	ArrayBox* dup;
	dup = g_new0 (ArrayBox, 1);
	array_box_copy (self, dup);
	return dup;
}


void array_box_free (ArrayBox* self) {
	array_box_destroy (self);
	g_free (self);
}


GType array_box_get_type (void) {
	static GType array_box_type_id = 0;
	if (array_box_type_id == 0) {
		array_box_type_id = g_boxed_type_register_static ("ArrayBox", (GBoxedCopyFunc) array_box_dup, (GBoxedFreeFunc) array_box_free);
	}
	return array_box_type_id;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _vala_ArrayBox_array_free (ArrayBox* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			array_box_destroy (&array[i]);
		}
	}
	g_free (array);
}


Canvas* canvas_construct (GType object_type, GtkMult* mult) {
	Canvas * self;
	g_return_val_if_fail (mult != NULL, NULL);
	self = (Canvas*) g_object_new (object_type, "mult", mult, NULL);
	return self;
}


Canvas* canvas_new (GtkMult* mult) {
	return canvas_construct (TYPE_CANVAS, mult);
}


void canvas_clear_mode (Canvas* self) {
	g_return_if_fail (self != NULL);
	canvas_set_mode (self, CANVAS_MODE_NONE, NULL);
}


void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box) {
	const char* _tmp0_;
	char* _tmp1_;
	guint context_id;
	g_return_if_fail (self != NULL);
	self->priv->mode = m;
	_tmp0_ = NULL;
	if (box == NULL) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = char_box_get_letter (box);
	}
	self->priv->mode_letter = (_tmp1_ = g_strdup (_tmp0_), _g_free0 (self->priv->mode_letter), _tmp1_);
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->mult_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* b;
			b = _g_object_ref0 ((CharBox*) b_it->data);
			{
				canvas_highlight_box (self, b, FALSE, FALSE, FALSE);
				_g_object_unref0 (b);
			}
		}
	}
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->digit_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* b;
			b = _g_object_ref0 ((CharBox*) b_it->data);
			{
				canvas_highlight_box (self, b, TRUE, FALSE, FALSE);
				_g_object_unref0 (b);
			}
		}
	}
	context_id = gtk_statusbar_get_context_id (gtk_mult_get_status (self->priv->_mult), "guess-prompt");
	gtk_statusbar_pop (gtk_mult_get_status (self->priv->_mult), context_id);
	if (self->priv->mode != CANVAS_MODE_NONE) {
		char* _tmp2_;
		gtk_mult_clear_guess_feedback (self->priv->_mult);
		gtk_statusbar_push (gtk_mult_get_status (self->priv->_mult), context_id, _tmp2_ = g_strdup_printf ("%s = ?", _ (self->priv->mode_letter)));
		_g_free0 (_tmp2_);
	}
}


void canvas_start_choice (Canvas* self, gchar ch) {
	GList* _tmp0_;
	GList* boxes;
	char* str;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	if (g_ascii_isdigit (ch)) {
		_tmp0_ = self->priv->digit_boxes;
	} else {
		_tmp0_ = self->priv->mult_boxes;
	}
	boxes = _tmp0_;
	str = g_strdup_printf ("%c", (gint) ch);
	{
		GList* b_collection;
		GList* b_it;
		b_collection = boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* b;
			b = _g_object_ref0 ((CharBox*) b_it->data);
			{
				if (_vala_strcmp0 (str, char_box_get_letter (b)) == 0) {
					if (g_ascii_isdigit (ch)) {
						canvas_start_digit_choice (self, b);
					} else {
						canvas_start_char_choice (self, b);
					}
					_g_object_unref0 (b);
					break;
				}
				_g_object_unref0 (b);
			}
		}
	}
	_g_free0 (str);
}


void canvas_start_digit_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_CHAR) {
		if (char_box_get_highlight (b) != GTK_STATE_INSENSITIVE) {
			mult_puzzle_guess (self->priv->_puzzle, g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (b), 0))), (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)));
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_DIGIT, b);
	}
}


void canvas_start_char_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_DIGIT) {
		if (char_box_get_highlight (b) != GTK_STATE_INSENSITIVE) {
			mult_puzzle_guess (self->priv->_puzzle, g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0))), (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (b), 0)));
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_CHAR, b);
	}
}


static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset) {
	gint x;
	gint y;
	g_return_if_fail (self != NULL);
	indent = self->priv->num_box_cols - indent;
	x = mult_x_offset + (indent * (w + CANVAS_SPACING));
	y = mult_y_offset + (row * (w + CANVAS_SPACING));
	if (row >= 2) {
		y = y + (self->priv->hsep1->requisition.height + CANVAS_SPACING);
	}
	if (row == (self->priv->num_box_rows - 1)) {
		y = y + (self->priv->hsep2->requisition.height + CANVAS_SPACING);
	}
	{
		CharBox** b_collection;
		int b_collection_length1;
		int b_it;
		b_collection = boxes;
		b_collection_length1 = boxes_length1;
		for (b_it = 0; b_it < boxes_length1; b_it = b_it + 1) {
			CharBox* b;
			b = _g_object_ref0 (b_collection[b_it]);
			{
				GdkRectangle _tmp0_ = {0};
				GdkRectangle alloc;
				alloc = (_tmp0_.x = x, _tmp0_.y = y, _tmp0_.width = w, _tmp0_.height = w, _tmp0_);
				canvas_allocate_box (self, b, &alloc);
				x = x + (w + CANVAS_SPACING);
				_g_object_unref0 (b);
			}
		}
	}
}


static void canvas_allocate_box (Canvas* self, CharBox* b, GdkRectangle* rect) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_widget_size_allocate ((GtkWidget*) b, rect);
	char_box_set_points (b, (gint) ((*rect).height * (72.0 / gtk_mult_dpi)));
}


static void canvas_handle_size_allocate (Canvas* self, GtkFixed* box, GdkRectangle* rect) {
	gint w;
	gint h;
	gint _tmp0_ = 0;
	gint mult_x_offset;
	gint mult_y_offset;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle rec;
	gint digit_y_offset;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	((GtkWidget*) box)->allocation.x = (*rect).x;
	((GtkWidget*) box)->allocation.y = (*rect).y;
	((GtkWidget*) box)->allocation.width = (*rect).width;
	((GtkWidget*) box)->allocation.height = (*rect).height;
	w = (gint) (((*rect).width - self->priv->min_width) / (self->priv->num_box_cols + 2));
	h = (gint) (((*rect).height - self->priv->min_height) / self->priv->num_box_rows);
	if (w > h) {
		_tmp0_ = h;
	} else {
		_tmp0_ = w;
	}
	w = _tmp0_;
	mult_x_offset = (((GtkWidget*) box)->allocation.x + 12) + (((((GtkWidget*) box)->allocation.width - self->priv->min_width) - (w * (self->priv->num_box_cols + 2))) / 2);
	mult_y_offset = (((GtkWidget*) box)->allocation.y + 12) + (((((GtkWidget*) box)->allocation.height - self->priv->min_height) - (w * self->priv->num_box_rows)) / 2);
	if (mult_x_offset > (((GtkWidget*) box)->allocation.width / 2)) {
		_tmp1_ = ((GtkWidget*) box)->allocation.width / 2;
	} else {
		_tmp1_ = mult_x_offset;
	}
	mult_x_offset = _tmp1_;
	if (mult_y_offset > (((GtkWidget*) box)->allocation.height / 2)) {
		_tmp2_ = ((GtkWidget*) box)->allocation.height / 2;
	} else {
		_tmp2_ = mult_y_offset;
	}
	mult_y_offset = _tmp2_;
	canvas_layout_mult_string (self, self->priv->xboxes, self->priv->xboxes_length1, 0, self->priv->xboxes_length1, w, mult_x_offset, mult_y_offset);
	canvas_layout_mult_string (self, self->priv->yboxes, self->priv->yboxes_length1, 1, self->priv->yboxes_length1, w, mult_x_offset, mult_y_offset);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					i = i + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < self->priv->addboxes_length1)) {
					break;
				}
				canvas_layout_mult_string (self, self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, 2 + i, self->priv->addboxes[i].array_length1 + i, w, mult_x_offset, mult_y_offset);
			}
		}
	}
	canvas_layout_mult_string (self, self->priv->zboxes, self->priv->zboxes_length1, self->priv->num_box_rows - 1, self->priv->zboxes_length1, w, mult_x_offset, mult_y_offset);
	rec = (memset (&_tmp4_, 0, sizeof (GdkRectangle)), _tmp4_);
	rec.x = mult_x_offset;
	rec.y = mult_y_offset + (2 * (w + CANVAS_SPACING));
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = self->priv->hsep1->requisition.height;
	gtk_widget_size_allocate (self->priv->hsep1, &rec);
	rec.x = mult_x_offset;
	rec.y = ((mult_y_offset + (((gint) (2 + mult_puzzle_get_num_addends (self->priv->_puzzle))) * (w + CANVAS_SPACING))) + self->priv->hsep1->requisition.height) + CANVAS_SPACING;
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = self->priv->hsep2->requisition.height;
	gtk_widget_size_allocate (self->priv->hsep2, &rec);
	rec.x = mult_x_offset;
	rec.y = (mult_y_offset + w) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->timesbox, &rec);
	rec.x = mult_x_offset;
	rec.y = ((mult_y_offset + (((gint) (1 + mult_puzzle_get_num_addends (self->priv->_puzzle))) * (w + CANVAS_SPACING))) + self->priv->hsep1->requisition.height) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->plusbox, &rec);
	rec.x = (mult_x_offset + (self->priv->num_box_cols * (w + CANVAS_SPACING))) + CANVAS_SPACING;
	rec.y = mult_y_offset;
	rec.width = self->priv->vsep->requisition.width;
	rec.height = ((GtkWidget*) box)->allocation.height - ((mult_y_offset - ((GtkWidget*) box)->allocation.y) * 2);
	gtk_widget_size_allocate (self->priv->vsep, &rec);
	digit_y_offset = (((GtkWidget*) box)->allocation.y + 12) + ((((((*rect).height - 12) - 12) - (5 * w)) - (4 * CANVAS_SPACING)) / 2);
	rec.width = w;
	rec.height = w;
	rec.x = rec.x + (CANVAS_SPACING * 2);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				if (!_tmp5_) {
					i = i + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
				canvas_allocate_box (self, self->priv->digitboxes[i * 2], &rec);
			}
		}
	}
	rec.x = (rec.x + w) + CANVAS_SPACING;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					i = i + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
				canvas_allocate_box (self, self->priv->digitboxes[(i * 2) + 1], &rec);
			}
		}
	}
}


static gboolean _canvas_handle_char_release_gtk_widget_button_release_event (CharBox* _sender, GdkEventButton* event, gpointer self) {
	return canvas_handle_char_release (self, _sender, event);
}


static gboolean _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self) {
	return canvas_handle_mult_enter_notify (self, _sender, event);
}


static gboolean _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self) {
	return canvas_handle_mult_leave_notify (self, _sender, event);
}


static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch) {
	CharBox* result;
	CharBox* b;
	g_return_val_if_fail (self != NULL, NULL);
	b = NULL;
	if (g_unichar_isdigit (ch)) {
		CharBox* _tmp1_;
		char* _tmp0_;
		b = (_tmp1_ = g_object_ref_sink (char_box_new (_tmp0_ = g_strdup_printf ("%c", (gint) ((gchar) ch)), GTK_SHADOW_NONE)), _g_object_unref0 (b), _tmp1_);
		_g_free0 (_tmp0_);
	} else {
		CharBox* _tmp2_;
		b = (_tmp2_ = (CharBox*) g_object_ref_sink (table_box_new ((gchar) ch, self)), _g_object_unref0 (b), _tmp2_);
		gtk_widget_add_events ((GtkWidget*) b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_object ((GtkWidget*) b, "button-release-event", (GCallback) _canvas_handle_char_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "enter-notify-event", (GCallback) _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "leave-notify-event", (GCallback) _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event, self, 0);
		self->priv->mult_boxes = g_list_append (self->priv->mult_boxes, _g_object_ref0 (b));
	}
	result = b;
	return result;
}


static gboolean _canvas_handle_digit_release_gtk_widget_button_release_event (CharBox* _sender, GdkEventButton* event, gpointer self) {
	return canvas_handle_digit_release (self, _sender, event);
}


static gboolean _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self) {
	return canvas_handle_digit_enter_notify (self, _sender, event);
}


static gboolean _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, GdkEventCrossing* event, gpointer self) {
	return canvas_handle_digit_leave_notify (self, _sender, event);
}


static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i) {
	CharBox* result;
	CharBox* b;
	g_return_val_if_fail (self != NULL, NULL);
	b = NULL;
	if (unknown[i] == TRUE) {
		char* digit_str;
		CharBox* _tmp0_;
		digit_str = g_strdup_printf ("%i", i);
		b = (_tmp0_ = (CharBox*) g_object_ref_sink (digit_box_new (self, digit_str)), _g_object_unref0 (b), _tmp0_);
		gtk_widget_add_events ((GtkWidget*) b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_object ((GtkWidget*) b, "button-release-event", (GCallback) _canvas_handle_digit_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "enter-notify-event", (GCallback) _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "leave-notify-event", (GCallback) _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event, self, 0);
		self->priv->digit_boxes = g_list_append (self->priv->digit_boxes, _g_object_ref0 (b));
		_g_free0 (digit_str);
	} else {
		CharBox* _tmp1_;
		b = (_tmp1_ = g_object_ref_sink (char_box_new (" ", GTK_SHADOW_NONE)), _g_object_unref0 (b), _tmp1_);
	}
	result = b;
	return result;
}


static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p) {
	GList* _tmp0_;
	GList* _tmp1_;
	char* multiplicand;
	char* multiplier;
	char* answer;
	gboolean* _tmp12_;
	gint unknown_size;
	gint unknown_length1;
	gint _tmp11_;
	gboolean* unknown;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->mult_boxes = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->mult_boxes), _tmp0_);
	self->priv->digit_boxes = (_tmp1_ = NULL, __g_list_free_g_object_unref0 (self->priv->digit_boxes), _tmp1_);
	multiplicand = mult_puzzle_get_multiplicand (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				CharBox* _tmp3_;
				if (!_tmp2_) {
					i = i + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < strlen (multiplicand))) {
					break;
				}
				self->priv->xboxes[i] = (_tmp3_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (multiplicand, i))), _g_object_unref0 (self->priv->xboxes[i]), _tmp3_);
				gtk_widget_show_all ((GtkWidget*) self->priv->xboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->xboxes[i]);
			}
		}
	}
	multiplier = mult_puzzle_get_multiplier (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				CharBox* _tmp5_;
				if (!_tmp4_) {
					i = i + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < strlen (multiplier))) {
					break;
				}
				self->priv->yboxes[i] = (_tmp5_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (multiplier, i))), _g_object_unref0 (self->priv->yboxes[i]), _tmp5_);
				gtk_widget_show_all ((GtkWidget*) self->priv->yboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->yboxes[i]);
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				char* addend;
				if (!_tmp6_) {
					i = i + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < mult_puzzle_get_num_addends (self->priv->_puzzle))) {
					break;
				}
				addend = mult_puzzle_get_addend (self->priv->_puzzle, i);
				{
					gint j;
					j = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							CharBox* _tmp8_;
							if (!_tmp7_) {
								j = j + 1;
							}
							_tmp7_ = FALSE;
							if (!(j < strlen (addend))) {
								break;
							}
							self->priv->addboxes[i].array[j] = (_tmp8_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (addend, j))), _g_object_unref0 (self->priv->addboxes[i].array[j]), _tmp8_);
							gtk_widget_show_all ((GtkWidget*) self->priv->addboxes[i].array[j]);
							gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->addboxes[i].array[j]);
						}
					}
				}
				_g_free0 (addend);
			}
		}
	}
	answer = mult_puzzle_get_answer (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				CharBox* _tmp10_;
				if (!_tmp9_) {
					i = i + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < strlen (answer))) {
					break;
				}
				self->priv->zboxes[i] = (_tmp10_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (answer, i))), _g_object_unref0 (self->priv->zboxes[i]), _tmp10_);
				gtk_widget_show_all ((GtkWidget*) self->priv->zboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->zboxes[i]);
			}
		}
	}
	unknown = (_tmp12_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp11_), unknown_length1 = _tmp11_, unknown_size = unknown_length1, _tmp12_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				CharBox* _tmp14_;
				if (!_tmp13_) {
					i++;
				}
				_tmp13_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				self->priv->digitboxes[i] = (_tmp14_ = canvas_create_digit_box (self, unknown, unknown_length1, i), _g_object_unref0 (self->priv->digitboxes[i]), _tmp14_);
				gtk_widget_show_all ((GtkWidget*) self->priv->digitboxes[i]);
				gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->digitboxes[i]);
			}
		}
	}
	if (mult_puzzle_get_is_done (p)) {
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp15_;
				_tmp15_ = TRUE;
				while (TRUE) {
					if (!_tmp15_) {
						i++;
					}
					_tmp15_ = FALSE;
					if (!(i < 10)) {
						break;
					}
					char_box_set_highlight (self->priv->digitboxes[i], GTK_STATE_INSENSITIVE);
				}
			}
		}
	}
	_g_free0 (multiplicand);
	_g_free0 (multiplier);
	_g_free0 (answer);
	unknown = (g_free (unknown), NULL);
}


void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all) {
	CanvasMode _tmp2_ = 0;
	CanvasMode native_mode;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	if (all) {
		GList* _tmp0_;
		GList* boxes;
		_tmp0_ = NULL;
		if (digit_box) {
			_tmp0_ = self->priv->digit_boxes;
		} else {
			_tmp0_ = self->priv->mult_boxes;
		}
		boxes = _tmp0_;
		{
			GList* b_collection;
			GList* b_it;
			b_collection = boxes;
			for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
				CharBox* b;
				b = _g_object_ref0 ((CharBox*) b_it->data);
				{
					gboolean _tmp1_ = FALSE;
					if (b != box) {
						_tmp1_ = _vala_strcmp0 (char_box_get_letter (b), char_box_get_letter (box)) == 0;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						canvas_highlight_box (self, b, digit_box, hover, FALSE);
					}
					_g_object_unref0 (b);
				}
			}
		}
	}
	if (digit_box) {
		_tmp2_ = CANVAS_MODE_DIGIT;
	} else {
		_tmp2_ = CANVAS_MODE_CHAR;
	}
	native_mode = _tmp2_;
	if (self->priv->mode == native_mode) {
		if (_vala_strcmp0 (self->priv->mode_letter, char_box_get_letter (box)) == 0) {
			char_box_set_highlight (box, GTK_STATE_ACTIVE);
			return;
		}
	} else {
		if (self->priv->mode != CANVAS_MODE_NONE) {
			if (digit_box) {
				gboolean* _tmp4_;
				gint unknowns_size;
				gint unknowns_length1;
				gint _tmp3_;
				gboolean* unknowns;
				gboolean* _tmp6_;
				gint guesses_size;
				gint guesses_length1;
				gint _tmp5_;
				gboolean* guesses;
				gint digit;
				gboolean _tmp7_ = FALSE;
				unknowns = (_tmp4_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp3_), unknowns_length1 = _tmp3_, unknowns_size = unknowns_length1, _tmp4_);
				guesses = (_tmp6_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)), &_tmp5_), guesses_length1 = _tmp5_, guesses_size = guesses_length1, _tmp6_);
				digit = g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (box), 0)));
				if (!unknowns[digit]) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = guesses[digit];
				}
				if (_tmp7_) {
					char_box_set_highlight (box, GTK_STATE_INSENSITIVE);
					unknowns = (g_free (unknowns), NULL);
					guesses = (g_free (guesses), NULL);
					return;
				}
				unknowns = (g_free (unknowns), NULL);
				guesses = (g_free (guesses), NULL);
			} else {
				gint digit;
				gint _tmp9__length1;
				gboolean* _tmp9_;
				gint _tmp8_;
				gboolean _tmp10_;
				digit = g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)));
				if ((_tmp10_ = (_tmp9_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (box), 0)), &_tmp8_), _tmp9__length1 = _tmp8_, _tmp9_)[digit], _tmp9_ = (g_free (_tmp9_), NULL), _tmp10_)) {
					char_box_set_highlight (box, GTK_STATE_INSENSITIVE);
					return;
				}
			}
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_PRELIGHT);
				return;
			}
		} else {
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_PRELIGHT);
				return;
			}
		}
	}
	char_box_set_highlight (box, GTK_STATE_NORMAL);
}


static gboolean canvas_handle_digit_enter_notify (Canvas* self, CharBox* box, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, TRUE, TRUE, TRUE);
	result = FALSE;
	return result;
}


static gboolean canvas_handle_mult_enter_notify (Canvas* self, CharBox* box, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, FALSE, TRUE, TRUE);
	result = FALSE;
	return result;
}


static gboolean canvas_handle_digit_leave_notify (Canvas* self, CharBox* box, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, TRUE, FALSE, TRUE);
	result = FALSE;
	return result;
}


static gboolean canvas_handle_mult_leave_notify (Canvas* self, CharBox* box, GdkEventCrossing* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, FALSE, FALSE, TRUE);
	result = FALSE;
	return result;
}


static gboolean canvas_handle_release (Canvas* self, CharBox* box, GdkEventButton* event, gboolean digit_box) {
	gboolean result;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	if (!gtk_widget_get_visible ((GtkWidget*) box)) {
		result = FALSE;
		return result;
	}
	gtk_widget_get_pointer ((GtkWidget*) box, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) box)->window, &w, &h);
	if (CLAMP (x, 0, w) != x) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = CLAMP (y, 0, h) != y;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if ((*event).button == 1) {
		if (digit_box) {
			canvas_start_digit_choice (self, box);
		} else {
			canvas_start_char_choice (self, box);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean canvas_handle_char_release (Canvas* self, CharBox* box, GdkEventButton* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	result = canvas_handle_release (self, box, event, FALSE);
	return result;
}


static gboolean canvas_handle_digit_release (Canvas* self, CharBox* box, GdkEventButton* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	result = canvas_handle_release (self, box, event, TRUE);
	return result;
}


static gboolean canvas_handle_none_release (Canvas* self, Canvas* canvas, GdkEventButton* event) {
	gboolean result;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (canvas != NULL, FALSE);
	gtk_widget_get_pointer ((GtkWidget*) canvas, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) canvas)->window, &w, &h);
	if (CLAMP (x, 0, w) != x) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = CLAMP (y, 0, h) != y;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if ((*event).button == 1) {
		canvas_clear_mode (self);
	}
	result = TRUE;
	return result;
}


MultPuzzle* canvas_get_puzzle (Canvas* self) {
	MultPuzzle* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_puzzle;
	return result;
}


static void canvas_set_puzzle (Canvas* self, MultPuzzle* value) {
	MultPuzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_puzzle = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_puzzle), _tmp0_);
	g_object_notify ((GObject *) self, "puzzle");
}


GtkMult* canvas_get_mult (Canvas* self) {
	GtkMult* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mult;
	return result;
}


static void canvas_set_mult (Canvas* self, GtkMult* value) {
	GtkMult* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_mult = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_mult), _tmp0_);
	g_object_notify ((GObject *) self, "mult");
}


static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (Canvas* _sender, GdkEventButton* event, gpointer self) {
	return canvas_handle_none_release (self, _sender, event);
}


static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkFixed* _sender, GdkRectangle* allocation, gpointer self) {
	canvas_handle_size_allocate (self, _sender, allocation);
}


static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self) {
	canvas_handle_puzzle_change (self, _sender);
}


static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Canvas * self;
	parent_class = G_OBJECT_CLASS (canvas_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CANVAS (obj);
	{
		char* _tmp1_;
		GList* _tmp2_;
		GList* _tmp3_;
		GtkFixed* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		CharBox* _tmp8_;
		CharBox* _tmp9_;
		char* x;
		char* y;
		char* z;
		CharBox** _tmp11_;
		gint _tmp10_;
		CharBox** _tmp13_;
		gint _tmp12_;
		CharBox** _tmp15_;
		gint _tmp14_;
		CharBox** _tmp16_;
		ArrayBox* _tmp18_;
		gint _tmp17_;
		canvas_set_puzzle (self, gtk_mult_get_puzzle (self->priv->_mult));
		self->priv->mode = CANVAS_MODE_NONE;
		self->priv->mode_letter = (_tmp1_ = NULL, _g_free0 (self->priv->mode_letter), _tmp1_);
		self->priv->min_box_request = -1;
		self->priv->mult_boxes = (_tmp2_ = NULL, __g_list_free_g_object_unref0 (self->priv->mult_boxes), _tmp2_);
		self->priv->digit_boxes = (_tmp3_ = NULL, __g_list_free_g_object_unref0 (self->priv->digit_boxes), _tmp3_);
		self->priv->fixed = (_tmp4_ = g_object_ref_sink ((GtkFixed*) gtk_fixed_new ()), _g_object_unref0 (self->priv->fixed), _tmp4_);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->fixed);
		self->priv->vsep = (_tmp5_ = (GtkWidget*) g_object_ref_sink ((GtkVSeparator*) gtk_vseparator_new ()), _g_object_unref0 (self->priv->vsep), _tmp5_);
		self->priv->hsep1 = (_tmp6_ = (GtkWidget*) g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), _g_object_unref0 (self->priv->hsep1), _tmp6_);
		self->priv->hsep2 = (_tmp7_ = (GtkWidget*) g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), _g_object_unref0 (self->priv->hsep2), _tmp7_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->vsep);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep1);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep2);
		self->priv->plusbox = (_tmp8_ = g_object_ref_sink (char_box_new ("+", GTK_SHADOW_NONE)), _g_object_unref0 (self->priv->plusbox), _tmp8_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->plusbox);
		self->priv->timesbox = (_tmp9_ = g_object_ref_sink (char_box_new ("×", GTK_SHADOW_NONE)), _g_object_unref0 (self->priv->timesbox), _tmp9_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->timesbox);
		x = mult_puzzle_get_multiplicand (self->priv->_puzzle);
		y = mult_puzzle_get_multiplier (self->priv->_puzzle);
		z = mult_puzzle_get_answer (self->priv->_puzzle);
		self->priv->num_box_rows = 3 + ((gint) strlen (y));
		self->priv->num_box_cols = 1 + ((gint) strlen (z));
		self->priv->xboxes = (_tmp11_ = g_new0 (CharBox*, (_tmp10_ = strlen (x)) + 1), self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->xboxes_length1 = _tmp10_, self->priv->xboxes_size = self->priv->xboxes_length1, _tmp11_);
		self->priv->yboxes = (_tmp13_ = g_new0 (CharBox*, (_tmp12_ = strlen (y)) + 1), self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->yboxes_length1 = _tmp12_, self->priv->yboxes_size = self->priv->yboxes_length1, _tmp13_);
		self->priv->zboxes = (_tmp15_ = g_new0 (CharBox*, (_tmp14_ = strlen (z)) + 1), self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->zboxes_length1 = _tmp14_, self->priv->zboxes_size = self->priv->zboxes_length1, _tmp15_);
		self->priv->digitboxes = (_tmp16_ = g_new0 (CharBox*, 10 + 1), self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->digitboxes_length1 = 10, self->priv->digitboxes_size = self->priv->digitboxes_length1, _tmp16_);
		self->priv->addboxes = (_tmp18_ = g_new0 (ArrayBox, _tmp17_ = mult_puzzle_get_num_addends (self->priv->_puzzle)), self->priv->addboxes = (_vala_ArrayBox_array_free (self->priv->addboxes, self->priv->addboxes_length1), NULL), self->priv->addboxes_length1 = _tmp17_, self->priv->addboxes_size = self->priv->addboxes_length1, _tmp18_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					CharBox** _tmp22_;
					gint _tmp21_;
					char* _tmp20_;
					if (!_tmp19_) {
						i = i + 1;
					}
					_tmp19_ = FALSE;
					if (!(i < self->priv->addboxes_length1)) {
						break;
					}
					self->priv->addboxes[i].array = (_tmp22_ = g_new0 (CharBox*, (_tmp21_ = strlen (_tmp20_ = mult_puzzle_get_addend (self->priv->_puzzle, i))) + 1), self->priv->addboxes[i].array = (_vala_array_free (self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->addboxes[i].array_length1 = _tmp21_, self->priv->addboxes[i].array_size = self->priv->addboxes[i].array_length1, _tmp22_);
					_g_free0 (_tmp20_);
				}
			}
		}
		self->priv->min_width = ((((12 + ((self->priv->num_box_cols - 1) * CANVAS_SPACING)) + CANVAS_SPACING) + self->priv->vsep->requisition.width) + (CANVAS_SPACING * 4)) + 12;
		self->priv->min_height = ((12 + ((self->priv->num_box_rows + 1) * CANVAS_SPACING)) + (self->priv->hsep1->requisition.height * 2)) + 12;
		gtk_widget_set_size_request ((GtkWidget*) self, self->priv->min_width, self->priv->min_height);
		gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_RELEASE_MASK);
		g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _canvas_handle_none_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->fixed, "size-allocate", (GCallback) _canvas_handle_size_allocate_gtk_widget_size_allocate, self, 0);
		canvas_handle_puzzle_change (self, self->priv->_puzzle);
		g_signal_connect_object (self->priv->_puzzle, "changed", (GCallback) _canvas_handle_puzzle_change_mult_puzzle_changed, self, 0);
		_g_free0 (x);
		_g_free0 (y);
		_g_free0 (z);
	}
	return obj;
}


static void canvas_class_init (CanvasClass * klass) {
	canvas_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CanvasPrivate));
	G_OBJECT_CLASS (klass)->get_property = canvas_get_property;
	G_OBJECT_CLASS (klass)->set_property = canvas_set_property;
	G_OBJECT_CLASS (klass)->constructor = canvas_constructor;
	G_OBJECT_CLASS (klass)->finalize = canvas_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_MULT_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_MULT, g_param_spec_object ("mult", "mult", "mult", TYPE_GTK_MULT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void canvas_instance_init (Canvas * self) {
	self->priv = CANVAS_GET_PRIVATE (self);
}


static void canvas_finalize (GObject* obj) {
	Canvas * self;
	self = CANVAS (obj);
	_g_object_unref0 (self->priv->_puzzle);
	_g_object_unref0 (self->priv->_mult);
	_g_free0 (self->priv->mode_letter);
	_g_object_unref0 (self->priv->fixed);
	_g_object_unref0 (self->priv->vsep);
	_g_object_unref0 (self->priv->hsep1);
	_g_object_unref0 (self->priv->hsep2);
	__g_list_free_g_object_unref0 (self->priv->mult_boxes);
	__g_list_free_g_object_unref0 (self->priv->digit_boxes);
	self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->addboxes = (_vala_ArrayBox_array_free (self->priv->addboxes, self->priv->addboxes_length1), NULL);
	self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->plusbox);
	_g_object_unref0 (self->priv->timesbox);
	G_OBJECT_CLASS (canvas_parent_class)->finalize (obj);
}


GType canvas_get_type (void) {
	static GType canvas_type_id = 0;
	if (canvas_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (CanvasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) canvas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Canvas), 0, (GInstanceInitFunc) canvas_instance_init, NULL };
		canvas_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "Canvas", &g_define_type_info, 0);
	}
	return canvas_type_id;
}


static void canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Canvas * self;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		g_value_set_object (value, canvas_get_puzzle (self));
		break;
		case CANVAS_MULT:
		g_value_set_object (value, canvas_get_mult (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Canvas * self;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		canvas_set_puzzle (self, g_value_get_object (value));
		break;
		case CANVAS_MULT:
		canvas_set_mult (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




