/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;
typedef struct _MultPuzzlePrivate MultPuzzlePrivate;

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

struct _MultPuzzle {
	GObject parent_instance;
	MultPuzzlePrivate * priv;
};

struct _MultPuzzleClass {
	GObjectClass parent_class;
};

struct _MultPuzzlePrivate {
	gint _num_x_digits;
	gint _num_y_digits;
	gint _total_guesses;
	gint _wrong_guesses;
	gint _correct_guesses;
	gboolean _is_done;
	MultPuzzleChar* symbols;
	gint symbols_length1;
	gint symbols_size;
	gboolean* needed;
	gint needed_length1;
	gint needed_size;
	gboolean* unknown;
	gint unknown_length1;
	gint unknown_size;
	gboolean* have_guessed;
	gint have_guessed_length1;
	gint have_guessed_size;
	char* x;
	char* y;
	char* z;
	char** addends;
	gint addends_length1;
	gint addends_size;
};



GType mult_puzzle_guess_status_get_type (void);
GType mult_puzzle_char_get_type (void);
GType mult_puzzle_get_type (void);
#define MULT_PUZZLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MULT_PUZZLE, MultPuzzlePrivate))
enum  {
	MULT_PUZZLE_DUMMY_PROPERTY,
	MULT_PUZZLE_NUM_X_DIGITS,
	MULT_PUZZLE_NUM_Y_DIGITS,
	MULT_PUZZLE_TOTAL_GUESSES,
	MULT_PUZZLE_WRONG_GUESSES,
	MULT_PUZZLE_CORRECT_GUESSES,
	MULT_PUZZLE_IS_DONE
};
static void mult_puzzle_set_num_x_digits (MultPuzzle* self, gint value);
static void mult_puzzle_set_num_y_digits (MultPuzzle* self, gint value);
MultPuzzle* mult_puzzle_new (gint num_x, gint num_y);
MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y);
MultPuzzle* mult_puzzle_new (gint num_x, gint num_y);
char* mult_puzzle_get_multiplicand (MultPuzzle* self);
char* mult_puzzle_get_multiplier (MultPuzzle* self);
char* mult_puzzle_get_answer (MultPuzzle* self);
guint mult_puzzle_get_num_addends (MultPuzzle* self);
char* mult_puzzle_get_addend (MultPuzzle* self, gint n);
MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit);
gint mult_puzzle_get_total_guesses (MultPuzzle* self);
static void mult_puzzle_set_total_guesses (MultPuzzle* self, gint value);
gint mult_puzzle_get_correct_guesses (MultPuzzle* self);
static void mult_puzzle_set_correct_guesses (MultPuzzle* self, gint value);
gint mult_puzzle_get_wrong_guesses (MultPuzzle* self);
static void mult_puzzle_set_wrong_guesses (MultPuzzle* self, gint value);
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
void mult_puzzle_solve (MultPuzzle* self);
static void mult_puzzle_replace (MultPuzzle* self, char** n, gint digit);
static void mult_puzzle_set_is_done (MultPuzzle* self, gboolean value);
gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1);
gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
static void mult_puzzle_expand_num_string (MultPuzzle* self, char** n, glong minimum);
static void mult_puzzle_shuffle (MultPuzzleChar* symbolList, int symbolList_length1);
static void mult_puzzle_interpret (MultPuzzle* self, char** n);
static void mult_puzzle_note_needed (MultPuzzle* self, const char* n);
static gint mult_puzzle_num_with_n_digits (gint n);
gint mult_puzzle_get_num_x_digits (MultPuzzle* self);
gint mult_puzzle_get_num_y_digits (MultPuzzle* self);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
static GObject * mult_puzzle_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer mult_puzzle_parent_class = NULL;
static void mult_puzzle_finalize (GObject* obj);
static void mult_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void mult_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void g_cclosure_user_marshal_VOID__INT_ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


GType mult_puzzle_guess_status_get_type (void) {
	static GType mult_puzzle_guess_status_type_id = 0;
	if (G_UNLIKELY (mult_puzzle_guess_status_type_id == 0)) {
		static const GEnumValue values[] = {{MULT_PUZZLE_GUESS_STATUS_WRONG, "MULT_PUZZLE_GUESS_STATUS_WRONG", "wrong"}, {MULT_PUZZLE_GUESS_STATUS_CORRECT, "MULT_PUZZLE_GUESS_STATUS_CORRECT", "correct"}, {MULT_PUZZLE_GUESS_STATUS_KNOWN, "MULT_PUZZLE_GUESS_STATUS_KNOWN", "known"}, {MULT_PUZZLE_GUESS_STATUS_INVALID, "MULT_PUZZLE_GUESS_STATUS_INVALID", "invalid"}, {0, NULL, NULL}};
		mult_puzzle_guess_status_type_id = g_enum_register_static ("MultPuzzleGuessStatus", values);
	}
	return mult_puzzle_guess_status_type_id;
}



GType mult_puzzle_char_get_type (void) {
	static GType mult_puzzle_char_type_id = 0;
	if (G_UNLIKELY (mult_puzzle_char_type_id == 0)) {
		static const GEnumValue values[] = {{MULT_PUZZLE_CHAR_A, "MULT_PUZZLE_CHAR_A", "a"}, {MULT_PUZZLE_CHAR_B, "MULT_PUZZLE_CHAR_B", "b"}, {MULT_PUZZLE_CHAR_C, "MULT_PUZZLE_CHAR_C", "c"}, {MULT_PUZZLE_CHAR_D, "MULT_PUZZLE_CHAR_D", "d"}, {MULT_PUZZLE_CHAR_E, "MULT_PUZZLE_CHAR_E", "e"}, {MULT_PUZZLE_CHAR_F, "MULT_PUZZLE_CHAR_F", "f"}, {MULT_PUZZLE_CHAR_G, "MULT_PUZZLE_CHAR_G", "g"}, {MULT_PUZZLE_CHAR_H, "MULT_PUZZLE_CHAR_H", "h"}, {MULT_PUZZLE_CHAR_I, "MULT_PUZZLE_CHAR_I", "i"}, {MULT_PUZZLE_CHAR_J, "MULT_PUZZLE_CHAR_J", "j"}, {MULT_PUZZLE_CHAR_INVALID, "MULT_PUZZLE_CHAR_INVALID", "invalid"}, {0, NULL, NULL}};
		mult_puzzle_char_type_id = g_enum_register_static ("MultPuzzleChar", values);
	}
	return mult_puzzle_char_type_id;
}


/* Constructors */
MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y) {
	GParameter * __params;
	GParameter * __params_it;
	MultPuzzle * self;
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "num-x-digits";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, num_x);
	__params_it++;
	__params_it->name = "num-y-digits";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, num_y);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


MultPuzzle* mult_puzzle_new (gint num_x, gint num_y) {
	return mult_puzzle_construct (TYPE_MULT_PUZZLE, num_x, num_y);
}


/* Methods */
char* mult_puzzle_get_multiplicand (MultPuzzle* self) {
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	return (_tmp0_ = self->priv->x, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
}


char* mult_puzzle_get_multiplier (MultPuzzle* self) {
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	return (_tmp0_ = self->priv->y, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
}


char* mult_puzzle_get_answer (MultPuzzle* self) {
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	return (_tmp0_ = self->priv->z, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
}


guint mult_puzzle_get_num_addends (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return (guint) self->priv->addends_length1;
}


char* mult_puzzle_get_addend (MultPuzzle* self, gint n) {
	gboolean _tmp0_;
	const char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = FALSE;
	if (n < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = n >= self->priv->addends_length1;
	}
	if (_tmp0_) {
		return NULL;
	}
	_tmp2_ = NULL;
	return (_tmp2_ = self->priv->addends[n], (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
}


MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	MultPuzzleGuessStatus rv;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (digit < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = digit > 9;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = letter == MULT_PUZZLE_CHAR_INVALID;
	}
	if (_tmp0_) {
		return MULT_PUZZLE_GUESS_STATUS_INVALID;
	}
	rv = 0;
	if (self->priv->symbols[digit] == letter) {
		gint _tmp3_;
		gint _tmp4_;
		mult_puzzle_solve_digit (self, digit);
		_tmp3_ = self->priv->_total_guesses;
		mult_puzzle_set_total_guesses (self, _tmp3_ + 1);
		_tmp3_;
		_tmp4_ = self->priv->_correct_guesses;
		mult_puzzle_set_correct_guesses (self, _tmp4_ + 1);
		_tmp4_;
		self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + digit] = TRUE;
		rv = MULT_PUZZLE_GUESS_STATUS_CORRECT;
	} else {
		if (self->priv->symbols[digit] == MULT_PUZZLE_CHAR_INVALID) {
			rv = MULT_PUZZLE_GUESS_STATUS_KNOWN;
		} else {
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = self->priv->_total_guesses;
			mult_puzzle_set_total_guesses (self, _tmp5_ + 1);
			_tmp5_;
			_tmp6_ = self->priv->_wrong_guesses;
			mult_puzzle_set_wrong_guesses (self, _tmp6_ + 1);
			_tmp6_;
			self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + digit] = TRUE;
			rv = MULT_PUZZLE_GUESS_STATUS_WRONG;
		}
	}
	g_signal_emit_by_name (self, "guessed", digit, letter, rv);
	return rv;
}


void mult_puzzle_solve (MultPuzzle* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		for (; i < 10; i++) {
			mult_puzzle_solve_digit (self, i);
		}
	}
}


MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit) {
	gboolean _tmp0_;
	MultPuzzleChar symbol;
	gboolean any_left;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = FALSE;
	if (digit < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = digit > 9;
	}
	if (_tmp0_) {
		return MULT_PUZZLE_CHAR_INVALID;
	}
	if (!self->priv->needed[digit]) {
		return MULT_PUZZLE_CHAR_INVALID;
	}
	mult_puzzle_replace (self, &self->priv->x, digit);
	mult_puzzle_replace (self, &self->priv->y, digit);
	mult_puzzle_replace (self, &self->priv->z, digit);
	{
		gint i;
		i = 0;
		for (; i < self->priv->addends_length1; i = i + 1) {
			const char* _tmp3_;
			char* addend;
			char* _tmp5_;
			const char* _tmp4_;
			_tmp3_ = NULL;
			addend = (_tmp3_ = self->priv->addends[i], (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
			mult_puzzle_replace (self, &addend, digit);
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			self->priv->addends[i] = (_tmp5_ = (_tmp4_ = addend, (_tmp4_ == NULL) ? NULL : g_strdup (_tmp4_)), self->priv->addends[i] = (g_free (self->priv->addends[i]), NULL), _tmp5_);
			addend = (g_free (addend), NULL);
		}
	}
	symbol = self->priv->symbols[digit];
	self->priv->symbols[digit] = MULT_PUZZLE_CHAR_INVALID;
	self->priv->needed[digit] = FALSE;
	self->priv->unknown[digit] = FALSE;
	any_left = FALSE;
	{
		gboolean* g_collection;
		int g_collection_length1;
		int g_it;
		g_collection = self->priv->needed;
		g_collection_length1 = self->priv->needed_length1;
		for (g_it = 0; g_it < self->priv->needed_length1; g_it = g_it + 1) {
			gboolean g;
			g = g_collection[g_it];
			{
				if (g) {
					any_left = TRUE;
					break;
				}
			}
		}
	}
	if (!any_left) {
		mult_puzzle_set_is_done (self, TRUE);
	}
	g_signal_emit_by_name (self, "changed");
	return symbol;
}


gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1) {
	gboolean* _tmp0_;
	gint rv_size;
	gint rv_length1;
	gboolean* rv;
	gboolean* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	rv = (_tmp0_ = g_new0 (gboolean, self->priv->unknown_length1), rv_length1 = self->priv->unknown_length1, rv_size = rv_length1, _tmp0_);
	{
		gint i;
		i = 0;
		for (; i < self->priv->unknown_length1; i++) {
			rv[i] = self->priv->unknown[i];
		}
	}
	_tmp1_ = NULL;
	return (_tmp1_ = rv, *result_length1 = rv_length1, _tmp1_);
}


gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1) {
	gboolean* _tmp0_;
	gint rv_size;
	gint rv_length1;
	gboolean* rv;
	gboolean* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	rv = (_tmp0_ = g_new0 (gboolean, self->priv->needed_length1), rv_length1 = self->priv->needed_length1, rv_size = rv_length1, _tmp0_);
	{
		gint i;
		i = 0;
		for (; i < self->priv->needed_length1; i++) {
			rv[i] = self->priv->needed[i];
		}
	}
	_tmp1_ = NULL;
	return (_tmp1_ = rv, *result_length1 = rv_length1, _tmp1_);
}


gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1) {
	gboolean* _tmp0_;
	gint rv_size;
	gint rv_length1;
	gboolean* rv;
	gboolean* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	rv = (_tmp0_ = g_new0 (gboolean, 10), rv_length1 = 10, rv_size = rv_length1, _tmp0_);
	if (letter == MULT_PUZZLE_CHAR_INVALID) {
		{
			gint i;
			i = 0;
			for (; i < 10; i++) {
				rv[i] = FALSE;
			}
		}
	} else {
		{
			gint i;
			i = 0;
			for (; i < 10; i++) {
				rv[i] = self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + i];
			}
		}
	}
	_tmp1_ = NULL;
	return (_tmp1_ = rv, *result_length1 = rv_length1, _tmp1_);
}


/* Private methods 
 pads a string with 0's in the front if it is less than the minimum*/
static void mult_puzzle_expand_num_string (MultPuzzle* self, char** n, glong minimum) {
	glong difference;
	GString* rv;
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	difference = minimum - strlen ((*n));
	if (difference < 0) {
		return;
	}
	rv = g_string_new ("");
	{
		glong i;
		i = (glong) 0;
		for (; i < difference; i = i + 1) {
			g_string_append_c (rv, '0');
		}
	}
	g_string_append (rv, (*n));
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	(*n) = (_tmp1_ = (_tmp0_ = rv->str, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), (*n) = (g_free ((*n)), NULL), _tmp1_);
	(rv == NULL) ? NULL : (rv = (g_string_free (rv, TRUE), NULL));
}


static void mult_puzzle_shuffle (MultPuzzleChar* symbolList, int symbolList_length1) {
	{
		gint i;
		/**
		     * Here, we need to pick a spot from 0...9, and place the first digit there.
		     * Then, we pick a spot k from 0...8, and place the next digit in the kth free spot.
		     * Repeat.
		     */
		i = 0;
		for (; i < 10; i++) {
			gint spot;
			gint j;
			spot = (gint) g_random_int_range ((gint32) 0, (gint32) (10 - i));
			j = 0;
			for (j = 0; j < 10; j++) {
				if (symbolList[j] == MULT_PUZZLE_CHAR_INVALID) {
					if ((spot--) == 0) {
						break;
					}
				}
			}
			symbolList[j] = (MultPuzzleChar) (i + 65);
		}
	}
}


static void mult_puzzle_replace (MultPuzzle* self, char** n, gint digit) {
	GString* rv;
	const char* np;
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	rv = g_string_new ("");
	np = (*n);
	while (strlen (np) > 0) {
		gunichar ch;
		ch = g_utf8_get_char (np);
		if (((gint) ch) == ((gint) self->priv->symbols[digit])) {
			g_string_append_c (rv, (gchar) (digit + 48));
		} else {
			g_string_append_unichar (rv, ch);
		}
		np = g_utf8_next_char (np);
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	(*n) = (_tmp1_ = (_tmp0_ = rv->str, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), (*n) = (g_free ((*n)), NULL), _tmp1_);
	(rv == NULL) ? NULL : (rv = (g_string_free (rv, TRUE), NULL));
}


/* Modifies a list of characters, replacing each that represents an unguessed
     incoming integer with the appropriate letter. */
static void mult_puzzle_interpret (MultPuzzle* self, char** n) {
	GString* rv;
	const char* np;
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	rv = g_string_new ("");
	np = (*n);
	while (strlen (np) > 0) {
		gunichar ch;
		ch = g_utf8_get_char (np);
		if (g_unichar_isdigit (ch)) {
			g_string_append_c (rv, (gchar) self->priv->symbols[g_unichar_digit_value (ch)]);
		} else {
			g_string_append_unichar (rv, ch);
		}
		np = g_utf8_next_char (np);
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	(*n) = (_tmp1_ = (_tmp0_ = rv->str, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), (*n) = (g_free ((*n)), NULL), _tmp1_);
	(rv == NULL) ? NULL : (rv = (g_string_free (rv, TRUE), NULL));
}


/* n is  a string full of digit characters */
static void mult_puzzle_note_needed (MultPuzzle* self, const char* n) {
	const char* np;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	np = n;
	while (strlen (np) > 0) {
		gunichar ch;
		ch = g_utf8_get_char (np);
		if (g_unichar_isdigit (ch)) {
			self->priv->needed[g_unichar_digit_value (ch)] = TRUE;
		}
		np = g_utf8_next_char (np);
	}
}


static gint mult_puzzle_num_with_n_digits (gint n) {
	gint32 low;
	gint32 high;
	low = 0;
	high = 0;
	if (n <= 1) {
		low = (gint32) 0;
	} else {
		low = (gint32) pow ((double) 10, (double) (n - 1));
	}
	high = (gint32) pow ((double) 10, (double) n);
	return (gint) g_random_int_range (low, high);
}


gint mult_puzzle_get_num_x_digits (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_num_x_digits;
}


static void mult_puzzle_set_num_x_digits (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num_x_digits = value;
	g_object_notify ((GObject *) self, "num-x-digits");
}


gint mult_puzzle_get_num_y_digits (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_num_y_digits;
}


static void mult_puzzle_set_num_y_digits (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num_y_digits = value;
	g_object_notify ((GObject *) self, "num-y-digits");
}


gint mult_puzzle_get_total_guesses (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_total_guesses;
}


static void mult_puzzle_set_total_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_total_guesses = value;
	g_object_notify ((GObject *) self, "total-guesses");
}


gint mult_puzzle_get_wrong_guesses (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_wrong_guesses;
}


static void mult_puzzle_set_wrong_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_wrong_guesses = value;
	g_object_notify ((GObject *) self, "wrong-guesses");
}


gint mult_puzzle_get_correct_guesses (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_correct_guesses;
}


static void mult_puzzle_set_correct_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_correct_guesses = value;
	g_object_notify ((GObject *) self, "correct-guesses");
}


gboolean mult_puzzle_get_is_done (MultPuzzle* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_is_done;
}


static void mult_puzzle_set_is_done (MultPuzzle* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_done = value;
	g_object_notify ((GObject *) self, "is-done");
}


static GObject * mult_puzzle_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	MultPuzzleClass * klass;
	GObjectClass * parent_class;
	MultPuzzle * self;
	klass = MULT_PUZZLE_CLASS (g_type_class_peek (TYPE_MULT_PUZZLE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MULT_PUZZLE (obj);
	{
		gboolean* _tmp0_;
		gboolean* _tmp1_;
		MultPuzzleChar* _tmp2_;
		gboolean* _tmp3_;
		gint valX;
		gint valY;
		gint valZ;
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		char** _tmp8_;
		gint _tmp7_;
		_tmp0_ = NULL;
		self->priv->needed = (_tmp0_ = g_new0 (gboolean, 10), self->priv->needed = (g_free (self->priv->needed), NULL), self->priv->needed_length1 = 10, self->priv->needed_size = self->priv->needed_length1, _tmp0_);
		_tmp1_ = NULL;
		self->priv->unknown = (_tmp1_ = g_new0 (gboolean, 10), self->priv->unknown = (g_free (self->priv->unknown), NULL), self->priv->unknown_length1 = 10, self->priv->unknown_size = self->priv->unknown_length1, _tmp1_);
		_tmp2_ = NULL;
		self->priv->symbols = (_tmp2_ = g_new0 (MultPuzzleChar, 10), self->priv->symbols = (g_free (self->priv->symbols), NULL), self->priv->symbols_length1 = 10, self->priv->symbols_size = self->priv->symbols_length1, _tmp2_);
		_tmp3_ = NULL;
		self->priv->have_guessed = (_tmp3_ = g_new0 (gboolean, 100), self->priv->have_guessed = (g_free (self->priv->have_guessed), NULL), self->priv->have_guessed_length1 = 100, self->priv->have_guessed_size = self->priv->have_guessed_length1, _tmp3_);
		{
			gint i;
			i = 0;
			for (; i < 10; i = i + 1) {
				self->priv->needed[i] = FALSE;
				self->priv->unknown[i] = TRUE;
				self->priv->symbols[i] = MULT_PUZZLE_CHAR_INVALID;
				{
					gint j;
					j = 0;
					for (; j < 10; j++) {
						self->priv->have_guessed[(i * 10) + j] = FALSE;
					}
				}
			}
		}
		mult_puzzle_shuffle (self->priv->symbols, self->priv->symbols_length1);
		/* Get value for x and y.*/
		valX = mult_puzzle_num_with_n_digits (self->priv->_num_x_digits);
		valY = 0;
		do {
			valY = mult_puzzle_num_with_n_digits (self->priv->_num_y_digits);
		} while ((valY % 10) == 0);
		valZ = valX * valY;
		_tmp4_ = NULL;
		self->priv->x = (_tmp4_ = g_strdup_printf ("%i", valX), self->priv->x = (g_free (self->priv->x), NULL), _tmp4_);
		_tmp5_ = NULL;
		self->priv->y = (_tmp5_ = g_strdup_printf ("%i", valY), self->priv->y = (g_free (self->priv->y), NULL), _tmp5_);
		_tmp6_ = NULL;
		self->priv->z = (_tmp6_ = g_strdup_printf ("%i", valZ), self->priv->z = (g_free (self->priv->z), NULL), _tmp6_);
		mult_puzzle_expand_num_string (self, &self->priv->z, strlen (self->priv->x) + strlen (self->priv->y));
		/* Calculate addends.*/
		_tmp8_ = NULL;
		self->priv->addends = (_tmp8_ = g_new0 (char*, (_tmp7_ = strlen (self->priv->y)) + 1), self->priv->addends = (_vala_array_free (self->priv->addends, self->priv->addends_length1, (GDestroyNotify) g_free), NULL), self->priv->addends_length1 = _tmp7_, self->priv->addends_size = self->priv->addends_length1, _tmp8_);
		{
			gint i;
			i = 0;
			for (; i < strlen (self->priv->y); i++) {
				gint addend;
				char* addend_str;
				char* _tmp10_;
				const char* _tmp9_;
				addend = valX * g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->y, (strlen (self->priv->y) - i) - 1)));
				addend_str = g_strdup_printf ("%i", addend);
				mult_puzzle_expand_num_string (self, &addend_str, strlen (self->priv->x) + 1);
				mult_puzzle_note_needed (self, addend_str);
				mult_puzzle_interpret (self, &addend_str);
				_tmp10_ = NULL;
				_tmp9_ = NULL;
				self->priv->addends[i] = (_tmp10_ = (_tmp9_ = addend_str, (_tmp9_ == NULL) ? NULL : g_strdup (_tmp9_)), self->priv->addends[i] = (g_free (self->priv->addends[i]), NULL), _tmp10_);
				addend_str = (g_free (addend_str), NULL);
			}
		}
		mult_puzzle_note_needed (self, self->priv->x);
		mult_puzzle_note_needed (self, self->priv->y);
		mult_puzzle_note_needed (self, self->priv->z);
		mult_puzzle_interpret (self, &self->priv->x);
		mult_puzzle_interpret (self, &self->priv->y);
		mult_puzzle_interpret (self, &self->priv->z);
	}
	return obj;
}


static void mult_puzzle_class_init (MultPuzzleClass * klass) {
	mult_puzzle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MultPuzzlePrivate));
	G_OBJECT_CLASS (klass)->get_property = mult_puzzle_get_property;
	G_OBJECT_CLASS (klass)->set_property = mult_puzzle_set_property;
	G_OBJECT_CLASS (klass)->constructor = mult_puzzle_constructor;
	G_OBJECT_CLASS (klass)->finalize = mult_puzzle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_NUM_X_DIGITS, g_param_spec_int ("num-x-digits", "num-x-digits", "num-x-digits", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_NUM_Y_DIGITS, g_param_spec_int ("num-y-digits", "num-y-digits", "num-y-digits", G_MININT, G_MAXINT, 2, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_TOTAL_GUESSES, g_param_spec_int ("total-guesses", "total-guesses", "total-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_WRONG_GUESSES, g_param_spec_int ("wrong-guesses", "wrong-guesses", "wrong-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_CORRECT_GUESSES, g_param_spec_int ("correct-guesses", "correct-guesses", "correct-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_IS_DONE, g_param_spec_boolean ("is-done", "is-done", "is-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("guessed", TYPE_MULT_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_ENUM_ENUM, G_TYPE_NONE, 3, G_TYPE_INT, TYPE_MULT_PUZZLE_CHAR, TYPE_MULT_PUZZLE_GUESS_STATUS);
	g_signal_new ("changed", TYPE_MULT_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void mult_puzzle_instance_init (MultPuzzle * self) {
	self->priv = MULT_PUZZLE_GET_PRIVATE (self);
	self->priv->_num_x_digits = 3;
	self->priv->_num_y_digits = 2;
	self->priv->_total_guesses = 0;
	self->priv->_wrong_guesses = 0;
	self->priv->_correct_guesses = 0;
	self->priv->_is_done = FALSE;
}


static void mult_puzzle_finalize (GObject* obj) {
	MultPuzzle * self;
	self = MULT_PUZZLE (obj);
	self->priv->symbols = (g_free (self->priv->symbols), NULL);
	self->priv->needed = (g_free (self->priv->needed), NULL);
	self->priv->unknown = (g_free (self->priv->unknown), NULL);
	self->priv->have_guessed = (g_free (self->priv->have_guessed), NULL);
	self->priv->x = (g_free (self->priv->x), NULL);
	self->priv->y = (g_free (self->priv->y), NULL);
	self->priv->z = (g_free (self->priv->z), NULL);
	self->priv->addends = (_vala_array_free (self->priv->addends, self->priv->addends_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (mult_puzzle_parent_class)->finalize (obj);
}


GType mult_puzzle_get_type (void) {
	static GType mult_puzzle_type_id = 0;
	if (mult_puzzle_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MultPuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mult_puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultPuzzle), 0, (GInstanceInitFunc) mult_puzzle_instance_init, NULL };
		mult_puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "MultPuzzle", &g_define_type_info, 0);
	}
	return mult_puzzle_type_id;
}


static void mult_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MultPuzzle * self;
	gpointer boxed;
	self = MULT_PUZZLE (object);
	switch (property_id) {
		case MULT_PUZZLE_NUM_X_DIGITS:
		g_value_set_int (value, mult_puzzle_get_num_x_digits (self));
		break;
		case MULT_PUZZLE_NUM_Y_DIGITS:
		g_value_set_int (value, mult_puzzle_get_num_y_digits (self));
		break;
		case MULT_PUZZLE_TOTAL_GUESSES:
		g_value_set_int (value, mult_puzzle_get_total_guesses (self));
		break;
		case MULT_PUZZLE_WRONG_GUESSES:
		g_value_set_int (value, mult_puzzle_get_wrong_guesses (self));
		break;
		case MULT_PUZZLE_CORRECT_GUESSES:
		g_value_set_int (value, mult_puzzle_get_correct_guesses (self));
		break;
		case MULT_PUZZLE_IS_DONE:
		g_value_set_boolean (value, mult_puzzle_get_is_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void mult_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MultPuzzle * self;
	self = MULT_PUZZLE (object);
	switch (property_id) {
		case MULT_PUZZLE_NUM_X_DIGITS:
		mult_puzzle_set_num_x_digits (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_NUM_Y_DIGITS:
		mult_puzzle_set_num_y_digits (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_TOTAL_GUESSES:
		mult_puzzle_set_total_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_WRONG_GUESSES:
		mult_puzzle_set_wrong_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_CORRECT_GUESSES:
		mult_puzzle_set_correct_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_IS_DONE:
		mult_puzzle_set_is_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__INT_ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_ENUM_ENUM) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_ENUM_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_ENUM_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_enum (param_values + 3), data2);
}



