/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_CANVAS_MODE (canvas_mode_get_type ())

#define TYPE_ARRAY_BOX (array_box_get_type ())

#define TYPE_CHAR_BOX (char_box_get_type ())
#define CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHAR_BOX, CharBox))
#define CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHAR_BOX, CharBoxClass))
#define IS_CHAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHAR_BOX))
#define IS_CHAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHAR_BOX))
#define CHAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHAR_BOX, CharBoxClass))

typedef struct _CharBox CharBox;
typedef struct _CharBoxClass CharBoxClass;
typedef struct _ArrayBox ArrayBox;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
typedef struct _CanvasPrivate CanvasPrivate;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_GTK_MULT (gtk_mult_get_type ())
#define GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_MULT, GtkMult))
#define GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_MULT, GtkMultClass))
#define IS_GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_MULT))
#define IS_GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_MULT))
#define GTK_MULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_MULT, GtkMultClass))

typedef struct _GtkMult GtkMult;
typedef struct _GtkMultClass GtkMultClass;

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())

#define TYPE_TABLE_BOX (table_box_get_type ())
#define TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TABLE_BOX, TableBox))
#define TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TABLE_BOX, TableBoxClass))
#define IS_TABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TABLE_BOX))
#define IS_TABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TABLE_BOX))
#define TABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TABLE_BOX, TableBoxClass))

typedef struct _TableBox TableBox;
typedef struct _TableBoxClass TableBoxClass;

#define TYPE_DIGIT_BOX (digit_box_get_type ())
#define DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGIT_BOX, DigitBox))
#define DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGIT_BOX, DigitBoxClass))
#define IS_DIGIT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGIT_BOX))
#define IS_DIGIT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGIT_BOX))
#define DIGIT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGIT_BOX, DigitBoxClass))

typedef struct _DigitBox DigitBox;
typedef struct _DigitBoxClass DigitBoxClass;

/*
    Multiplication Puzzle
    Copyright (C) 2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef enum  {
	CANVAS_MODE_NONE,
	CANVAS_MODE_DIGIT,
	CANVAS_MODE_CHAR
} CanvasMode;

/* This is a stupid little construction that vala needs to get lengths right*/
struct _ArrayBox {
	CharBox** array;
	gint array_length1;
	gint array_size;
};

struct _Canvas {
	GtkEventBox parent_instance;
	CanvasPrivate * priv;
};

struct _CanvasClass {
	GtkEventBoxClass parent_class;
};

struct _CanvasPrivate {
	MultPuzzle* _puzzle;
	GtkMult* _mult;
	char* mode_letter;
	CanvasMode mode;
	gint min_box_request;
	gint num_box_rows;
	gint num_box_cols;
	gint min_width;
	gint min_height;
	GtkFixed* fixed;
	GtkWidget* vsep;
	GtkWidget* hsep1;
	GtkWidget* hsep2;
	GList* mult_boxes;
	GList* digit_boxes;
	CharBox** xboxes;
	gint xboxes_length1;
	gint xboxes_size;
	CharBox** yboxes;
	gint yboxes_length1;
	gint yboxes_size;
	CharBox** zboxes;
	gint zboxes_length1;
	gint zboxes_size;
	ArrayBox* addboxes;
	gint addboxes_length1;
	gint addboxes_size;
	CharBox** digitboxes;
	gint digitboxes_length1;
	gint digitboxes_size;
	CharBox* plusbox;
	CharBox* timesbox;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;



GType canvas_mode_get_type (void);
GType array_box_get_type (void);
GType char_box_get_type (void);
void array_box_copy (const ArrayBox* self, ArrayBox* dest);
static CharBox** _vala_array_dup1 (CharBox** self, int length);
void array_box_destroy (ArrayBox* self);
ArrayBox* array_box_dup (const ArrayBox* self);
void array_box_free (ArrayBox* self);
GType canvas_get_type (void);
GType mult_puzzle_get_type (void);
GType gtk_mult_get_type (void);
#define CANVAS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANVAS, CanvasPrivate))
enum  {
	CANVAS_DUMMY_PROPERTY,
	CANVAS_PUZZLE,
	CANVAS_MULT
};
static void _g_list_free_g_object_unref (GList* self);
#define CANVAS_SPACING 6
static void canvas_set_mult (Canvas* self, GtkMult* value);
Canvas* canvas_new (GtkMult* mult);
Canvas* canvas_construct (GType object_type, GtkMult* mult);
Canvas* canvas_new (GtkMult* mult);
void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box);
void canvas_clear_mode (Canvas* self);
const char* char_box_get_letter (CharBox* self);
void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all);
GtkMult* canvas_get_mult (Canvas* self);
GtkStatusbar* gtk_mult_get_status (GtkMult* self);
void gtk_mult_clear_guess_feedback (GtkMult* self);
void canvas_start_digit_choice (Canvas* self, CharBox* b);
void canvas_start_char_choice (Canvas* self, CharBox* b);
void canvas_start_choice (Canvas* self, gchar ch);
GtkStateType char_box_get_highlight (CharBox* self);
MultPuzzle* canvas_get_puzzle (Canvas* self);
GType mult_puzzle_char_get_type (void);
GType mult_puzzle_guess_status_get_type (void);
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
static void canvas_allocate_box (Canvas* self, CharBox* b, const GdkRectangle* rect);
static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset);
extern gint gtk_mult_dpi;
void char_box_set_points (CharBox* self, gint value);
guint mult_puzzle_get_num_addends (MultPuzzle* self);
static void canvas_handle_size_allocate (Canvas* self, GtkFixed* box, const GdkRectangle* rect);
CharBox* char_box_new (const char* letter, GtkShadowType border);
CharBox* char_box_construct (GType object_type, const char* letter, GtkShadowType border);
TableBox* table_box_new (gchar c, Canvas* can);
TableBox* table_box_construct (GType object_type, gchar c, Canvas* can);
GType table_box_get_type (void);
static gboolean canvas_handle_char_release (Canvas* self, CharBox* box, const GdkEventButton* event);
static gboolean _canvas_handle_char_release_gtk_widget_button_release_event (CharBox* _sender, const GdkEventButton* event, gpointer self);
static gboolean canvas_handle_mult_enter_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event);
static gboolean _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self);
static gboolean canvas_handle_mult_leave_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event);
static gboolean _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self);
static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch);
DigitBox* digit_box_new (Canvas* canvas, const char* letter);
DigitBox* digit_box_construct (GType object_type, Canvas* canvas, const char* letter);
GType digit_box_get_type (void);
static gboolean canvas_handle_digit_release (Canvas* self, CharBox* box, const GdkEventButton* event);
static gboolean _canvas_handle_digit_release_gtk_widget_button_release_event (CharBox* _sender, const GdkEventButton* event, gpointer self);
static gboolean canvas_handle_digit_enter_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event);
static gboolean _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self);
static gboolean canvas_handle_digit_leave_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event);
static gboolean _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self);
static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i);
char* mult_puzzle_get_multiplicand (MultPuzzle* self);
char* mult_puzzle_get_multiplier (MultPuzzle* self);
char* mult_puzzle_get_addend (MultPuzzle* self, gint n);
char* mult_puzzle_get_answer (MultPuzzle* self);
gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
void char_box_set_highlight (CharBox* self, GtkStateType value);
static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
static gboolean canvas_handle_release (Canvas* self, CharBox* box, const GdkEventButton* event, gboolean digit_box);
static gboolean canvas_handle_none_release (Canvas* self, Canvas* canvas, const GdkEventButton* event);
static void canvas_set_puzzle (Canvas* self, MultPuzzle* value);
MultPuzzle* gtk_mult_get_puzzle (GtkMult* self);
static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (Canvas* _sender, const GdkEventButton* event, gpointer self);
static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkFixed* _sender, const GdkRectangle* allocation, gpointer self);
static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self);
static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer canvas_parent_class = NULL;
static void canvas_finalize (GObject* obj);
static void canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType canvas_mode_get_type (void) {
	static GType canvas_mode_type_id = 0;
	if (G_UNLIKELY (canvas_mode_type_id == 0)) {
		static const GEnumValue values[] = {{CANVAS_MODE_NONE, "CANVAS_MODE_NONE", "none"}, {CANVAS_MODE_DIGIT, "CANVAS_MODE_DIGIT", "digit"}, {CANVAS_MODE_CHAR, "CANVAS_MODE_CHAR", "char"}, {0, NULL, NULL}};
		canvas_mode_type_id = g_enum_register_static ("CanvasMode", values);
	}
	return canvas_mode_type_id;
}


static CharBox** _vala_array_dup1 (CharBox** self, int length) {
	CharBox** result;
	int i;
	CharBox* _tmp0_;
	result = g_new0 (CharBox*, length);
	for (i = 0; i < length; i++) {
		result[i] = (_tmp0_ = self[i], (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
	}
	return result;
}


void array_box_copy (const ArrayBox* self, ArrayBox* dest) {
	CharBox** _tmp1_;
	CharBox* _tmp0_;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	dest->array = (_tmp1_ = self->array, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, (*self).array_length1));
	dest->array_length1 = self->array_length1;
}


void array_box_destroy (ArrayBox* self) {
	self->array = (_vala_array_free (self->array, (*self).array_length1, (GDestroyNotify) g_object_unref), NULL);
}


ArrayBox* array_box_dup (const ArrayBox* self) {
	ArrayBox* dup;
	dup = g_new0 (ArrayBox, 1);
	array_box_copy (self, dup);
	return dup;
}


void array_box_free (ArrayBox* self) {
	array_box_destroy (self);
	g_free (self);
}


GType array_box_get_type (void) {
	static GType array_box_type_id = 0;
	if (array_box_type_id == 0) {
		array_box_type_id = g_boxed_type_register_static ("ArrayBox", (GBoxedCopyFunc) array_box_dup, (GBoxedFreeFunc) array_box_free);
	}
	return array_box_type_id;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


Canvas* canvas_construct (GType object_type, GtkMult* mult) {
	GParameter * __params;
	GParameter * __params_it;
	Canvas * self;
	g_return_val_if_fail (mult != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "mult";
	g_value_init (&__params_it->value, TYPE_GTK_MULT);
	g_value_set_object (&__params_it->value, mult);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


Canvas* canvas_new (GtkMult* mult) {
	return canvas_construct (TYPE_CANVAS, mult);
}


void canvas_clear_mode (Canvas* self) {
	g_return_if_fail (self != NULL);
	canvas_set_mode (self, CANVAS_MODE_NONE, NULL);
}


void canvas_set_mode (Canvas* self, CanvasMode m, CharBox* box) {
	const char* _tmp0_;
	char* _tmp2_;
	const char* _tmp1_;
	guint context_id;
	g_return_if_fail (self != NULL);
	self->priv->mode = m;
	_tmp0_ = NULL;
	if (box == NULL) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = char_box_get_letter (box);
	}
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->mode_letter = (_tmp2_ = (_tmp1_ = _tmp0_, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_)), self->priv->mode_letter = (g_free (self->priv->mode_letter), NULL), _tmp2_);
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->mult_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp3_;
			CharBox* b;
			_tmp3_ = NULL;
			b = (_tmp3_ = (CharBox*) b_it->data, (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
			{
				canvas_highlight_box (self, b, FALSE, FALSE, FALSE);
				(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
			}
		}
	}
	{
		GList* b_collection;
		GList* b_it;
		b_collection = self->priv->digit_boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp4_;
			CharBox* b;
			_tmp4_ = NULL;
			b = (_tmp4_ = (CharBox*) b_it->data, (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_));
			{
				canvas_highlight_box (self, b, TRUE, FALSE, FALSE);
				(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
			}
		}
	}
	context_id = gtk_statusbar_get_context_id (gtk_mult_get_status (self->priv->_mult), "guess-prompt");
	gtk_statusbar_pop (gtk_mult_get_status (self->priv->_mult), context_id);
	/* There might be an existing prompt
*/
	if (self->priv->mode != CANVAS_MODE_NONE) {
		char* _tmp5_;
		gtk_mult_clear_guess_feedback (self->priv->_mult);
		_tmp5_ = NULL;
		gtk_statusbar_push (gtk_mult_get_status (self->priv->_mult), context_id, _tmp5_ = g_strdup_printf ("%s = ?", _ (self->priv->mode_letter)));
		_tmp5_ = (g_free (_tmp5_), NULL);
	}
}


void canvas_start_choice (Canvas* self, gchar ch) {
	GList* _tmp0_;
	GList* boxes;
	char* str;
	g_return_if_fail (self != NULL);
	_tmp0_ = NULL;
	if (g_ascii_isdigit (ch)) {
		_tmp0_ = self->priv->digit_boxes;
	} else {
		_tmp0_ = self->priv->mult_boxes;
	}
	/* First, see if digit or letter, then find box*/
	boxes = _tmp0_;
	str = g_strdup_printf ("%c", (gint) ch);
	{
		GList* b_collection;
		GList* b_it;
		b_collection = boxes;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			CharBox* _tmp1_;
			CharBox* b;
			_tmp1_ = NULL;
			b = (_tmp1_ = (CharBox*) b_it->data, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
			{
				if (_vala_strcmp0 (str, char_box_get_letter (b)) == 0) {
					if (g_ascii_isdigit (ch)) {
						canvas_start_digit_choice (self, b);
					} else {
						canvas_start_char_choice (self, b);
					}
					(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
					break;
				}
				(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
			}
		}
	}
	str = (g_free (str), NULL);
}


void canvas_start_digit_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_CHAR) {
		/* this is really an end-char-choice, not a start-digit-choice*/
		if (char_box_get_highlight (b) != GTK_STATE_INSENSITIVE) {
			mult_puzzle_guess (self->priv->_puzzle, g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (b), 0))), (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)));
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_DIGIT, b);
	}
}


void canvas_start_char_choice (Canvas* self, CharBox* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (self->priv->mode == CANVAS_MODE_DIGIT) {
		/* this is really an end-digit-choice, not a start-char-choice*/
		if (char_box_get_highlight (b) != GTK_STATE_INSENSITIVE) {
			mult_puzzle_guess (self->priv->_puzzle, g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0))), (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (b), 0)));
		}
		canvas_clear_mode (self);
	} else {
		canvas_set_mode (self, CANVAS_MODE_CHAR, b);
	}
}


static void canvas_layout_mult_string (Canvas* self, CharBox** boxes, int boxes_length1, gint row, gint indent, gint w, gint mult_x_offset, gint mult_y_offset) {
	gint x;
	gint y;
	g_return_if_fail (self != NULL);
	indent = self->priv->num_box_cols - indent;
	x = mult_x_offset + (indent * (w + CANVAS_SPACING));
	y = mult_y_offset + (row * (w + CANVAS_SPACING));
	if (row >= 2) {
		y = y + (self->priv->hsep1->requisition.height + CANVAS_SPACING);
	}
	if (row == (self->priv->num_box_rows - 1)) {
		y = y + (self->priv->hsep2->requisition.height + CANVAS_SPACING);
	}
	{
		CharBox** b_collection;
		int b_collection_length1;
		int b_it;
		b_collection = boxes;
		b_collection_length1 = boxes_length1;
		for (b_it = 0; b_it < boxes_length1; b_it = b_it + 1) {
			CharBox* _tmp0_;
			CharBox* b;
			_tmp0_ = NULL;
			b = (_tmp0_ = b_collection[b_it], (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_));
			{
				GdkRectangle alloc = {x, y, w, w};
				canvas_allocate_box (self, b, &alloc);
				x = x + (w + CANVAS_SPACING);
				(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
			}
		}
	}
}


static void canvas_allocate_box (Canvas* self, CharBox* b, const GdkRectangle* rect) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_widget_size_allocate ((GtkWidget*) b, &(*rect));
	char_box_set_points (b, (gint) ((*rect).height * (72.0 / gtk_mult_dpi)));
}


static void canvas_handle_size_allocate (Canvas* self, GtkFixed* box, const GdkRectangle* rect) {
	gint w;
	gint h;
	gint _tmp0_;
	gint mult_x_offset;
	gint mult_y_offset;
	gint _tmp1_;
	gint _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GdkRectangle rec;
	gint digit_y_offset;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	((GtkWidget*) box)->allocation.x = (*rect).x;
	((GtkWidget*) box)->allocation.y = (*rect).y;
	((GtkWidget*) box)->allocation.width = (*rect).width;
	((GtkWidget*) box)->allocation.height = (*rect).height;
	w = (gint) (((*rect).width - self->priv->min_width) / (self->priv->num_box_cols + 2));
	h = (gint) (((*rect).height - self->priv->min_height) / self->priv->num_box_rows);
	_tmp0_ = 0;
	if (w > h) {
		_tmp0_ = h;
	} else {
		_tmp0_ = w;
	}
	/* From here on, we only use 'w' because we want a square box*/
	w = _tmp0_;
	mult_x_offset = (((GtkWidget*) box)->allocation.x + 12) + (((((GtkWidget*) box)->allocation.width - self->priv->min_width) - (w * (self->priv->num_box_cols + 2))) / 2);
	mult_y_offset = (((GtkWidget*) box)->allocation.y + 12) + (((((GtkWidget*) box)->allocation.height - self->priv->min_height) - (w * self->priv->num_box_rows)) / 2);
	_tmp1_ = 0;
	if (mult_x_offset > (((GtkWidget*) box)->allocation.width / 2)) {
		_tmp1_ = ((GtkWidget*) box)->allocation.width / 2;
	} else {
		_tmp1_ = mult_x_offset;
	}
	mult_x_offset = _tmp1_;
	_tmp2_ = 0;
	if (mult_y_offset > (((GtkWidget*) box)->allocation.height / 2)) {
		_tmp2_ = ((GtkWidget*) box)->allocation.height / 2;
	} else {
		_tmp2_ = mult_y_offset;
	}
	mult_y_offset = _tmp2_;
	canvas_layout_mult_string (self, self->priv->xboxes, self->priv->xboxes_length1, 0, self->priv->xboxes_length1, w, mult_x_offset, mult_y_offset);
	canvas_layout_mult_string (self, self->priv->yboxes, self->priv->yboxes_length1, 1, self->priv->yboxes_length1, w, mult_x_offset, mult_y_offset);
	{
		gint i;
		i = 0;
		for (; i < self->priv->addboxes_length1; i = i + 1) {
			canvas_layout_mult_string (self, self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, 2 + i, self->priv->addboxes[i].array_length1 + i, w, mult_x_offset, mult_y_offset);
		}
	}
	canvas_layout_mult_string (self, self->priv->zboxes, self->priv->zboxes_length1, self->priv->num_box_rows - 1, self->priv->zboxes_length1, w, mult_x_offset, mult_y_offset);
	/* *** Horizontal separators ****/
	rec = (memset (&_tmp3_, 0, sizeof (GdkRectangle)), _tmp3_);
	rec.x = mult_x_offset;
	rec.y = mult_y_offset + (2 * (w + CANVAS_SPACING));
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = self->priv->hsep1->requisition.height;
	gtk_widget_size_allocate (self->priv->hsep1, &rec);
	rec.x = mult_x_offset;
	rec.y = ((mult_y_offset + (((gint) (2 + mult_puzzle_get_num_addends (self->priv->_puzzle))) * (w + CANVAS_SPACING))) + self->priv->hsep1->requisition.height) + CANVAS_SPACING;
	rec.width = (self->priv->num_box_cols * w) + ((self->priv->num_box_cols - 1) * CANVAS_SPACING);
	rec.height = self->priv->hsep2->requisition.height;
	gtk_widget_size_allocate (self->priv->hsep2, &rec);
	/* *** Symbols *****/
	rec.x = mult_x_offset;
	rec.y = (mult_y_offset + w) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->timesbox, &rec);
	rec.x = mult_x_offset;
	rec.y = ((mult_y_offset + (((gint) (1 + mult_puzzle_get_num_addends (self->priv->_puzzle))) * (w + CANVAS_SPACING))) + self->priv->hsep1->requisition.height) + CANVAS_SPACING;
	rec.width = w;
	rec.height = w;
	canvas_allocate_box (self, self->priv->plusbox, &rec);
	/* *** Vertical separator ****/
	rec.x = (mult_x_offset + (self->priv->num_box_cols * (w + CANVAS_SPACING))) + CANVAS_SPACING;
	rec.y = mult_y_offset;
	rec.width = self->priv->vsep->requisition.width;
	rec.height = ((GtkWidget*) box)->allocation.height - ((mult_y_offset - ((GtkWidget*) box)->allocation.y) * 2);
	gtk_widget_size_allocate (self->priv->vsep, &rec);
	/* *** Digits ****/
	digit_y_offset = (((GtkWidget*) box)->allocation.y + 12) + ((((((*rect).height - 12) - 12) - (5 * w)) - (4 * CANVAS_SPACING)) / 2);
	rec.width = w;
	rec.height = w;
	rec.x = rec.x + (CANVAS_SPACING * 2);
	{
		gint i;
		i = 0;
		for (; i < 5; i = i + 1) {
			rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
			canvas_allocate_box (self, self->priv->digitboxes[i * 2], &rec);
		}
	}
	rec.x = (rec.x + w) + CANVAS_SPACING;
	{
		gint i;
		i = 0;
		for (; i < 5; i = i + 1) {
			rec.y = digit_y_offset + (i * (w + CANVAS_SPACING));
			canvas_allocate_box (self, self->priv->digitboxes[(i * 2) + 1], &rec);
		}
	}
}


static gboolean _canvas_handle_char_release_gtk_widget_button_release_event (CharBox* _sender, const GdkEventButton* event, gpointer self) {
	return canvas_handle_char_release (self, _sender, event);
}


static gboolean _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self) {
	return canvas_handle_mult_enter_notify (self, _sender, event);
}


static gboolean _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self) {
	return canvas_handle_mult_leave_notify (self, _sender, event);
}


static CharBox* canvas_create_mult_box (Canvas* self, gunichar ch) {
	CharBox* b;
	g_return_val_if_fail (self != NULL, NULL);
	b = NULL;
	if (g_unichar_isdigit (ch)) {
		CharBox* _tmp1_;
		char* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		b = (_tmp1_ = g_object_ref_sink (char_box_new (_tmp0_ = g_strdup_printf ("%c", (gint) ((gchar) ch)), GTK_SHADOW_NONE)), (b == NULL) ? NULL : (b = (g_object_unref (b), NULL)), _tmp1_);
		_tmp0_ = (g_free (_tmp0_), NULL);
	} else {
		CharBox* _tmp2_;
		CharBox* _tmp3_;
		_tmp2_ = NULL;
		b = (_tmp2_ = (CharBox*) g_object_ref_sink (table_box_new ((gchar) ch, self)), (b == NULL) ? NULL : (b = (g_object_unref (b), NULL)), _tmp2_);
		gtk_widget_add_events ((GtkWidget*) b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_object ((GtkWidget*) b, "button-release-event", (GCallback) _canvas_handle_char_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "enter-notify-event", (GCallback) _canvas_handle_mult_enter_notify_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "leave-notify-event", (GCallback) _canvas_handle_mult_leave_notify_gtk_widget_leave_notify_event, self, 0);
		_tmp3_ = NULL;
		self->priv->mult_boxes = g_list_append (self->priv->mult_boxes, (_tmp3_ = b, (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_)));
	}
	return b;
}


static gboolean _canvas_handle_digit_release_gtk_widget_button_release_event (CharBox* _sender, const GdkEventButton* event, gpointer self) {
	return canvas_handle_digit_release (self, _sender, event);
}


static gboolean _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self) {
	return canvas_handle_digit_enter_notify (self, _sender, event);
}


static gboolean _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event (CharBox* _sender, const GdkEventCrossing* event, gpointer self) {
	return canvas_handle_digit_leave_notify (self, _sender, event);
}


static CharBox* canvas_create_digit_box (Canvas* self, gboolean* unknown, int unknown_length1, gint i) {
	CharBox* b;
	g_return_val_if_fail (self != NULL, NULL);
	b = NULL;
	if (unknown[i] == TRUE) {
		char* digit_str;
		CharBox* _tmp0_;
		CharBox* _tmp1_;
		digit_str = g_strdup_printf ("%i", i);
		_tmp0_ = NULL;
		b = (_tmp0_ = (CharBox*) g_object_ref_sink (digit_box_new (self, digit_str)), (b == NULL) ? NULL : (b = (g_object_unref (b), NULL)), _tmp0_);
		gtk_widget_add_events ((GtkWidget*) b, (gint) ((GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
		g_signal_connect_object ((GtkWidget*) b, "button-release-event", (GCallback) _canvas_handle_digit_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "enter-notify-event", (GCallback) _canvas_handle_digit_enter_notify_gtk_widget_enter_notify_event, self, 0);
		g_signal_connect_object ((GtkWidget*) b, "leave-notify-event", (GCallback) _canvas_handle_digit_leave_notify_gtk_widget_leave_notify_event, self, 0);
		_tmp1_ = NULL;
		self->priv->digit_boxes = g_list_append (self->priv->digit_boxes, (_tmp1_ = b, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)));
		digit_str = (g_free (digit_str), NULL);
	} else {
		CharBox* _tmp2_;
		_tmp2_ = NULL;
		b = (_tmp2_ = g_object_ref_sink (char_box_new (" ", GTK_SHADOW_NONE)), (b == NULL) ? NULL : (b = (g_object_unref (b), NULL)), _tmp2_);
	}
	return b;
}


static void canvas_handle_puzzle_change (Canvas* self, MultPuzzle* p) {
	GList* _tmp0_;
	GList* _tmp1_;
	char* multiplicand;
	char* multiplier;
	char* answer;
	gboolean* _tmp7_;
	gint unknown_size;
	gint unknown_length1;
	gint _tmp6_;
	gboolean* unknown;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	/* Create CharBoxes for all the pieces of the puzzle.*/
	_tmp0_ = NULL;
	self->priv->mult_boxes = (_tmp0_ = NULL, (self->priv->mult_boxes == NULL) ? NULL : (self->priv->mult_boxes = (_g_list_free_g_object_unref (self->priv->mult_boxes), NULL)), _tmp0_);
	_tmp1_ = NULL;
	self->priv->digit_boxes = (_tmp1_ = NULL, (self->priv->digit_boxes == NULL) ? NULL : (self->priv->digit_boxes = (_g_list_free_g_object_unref (self->priv->digit_boxes), NULL)), _tmp1_);
	multiplicand = mult_puzzle_get_multiplicand (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		for (; i < strlen (multiplicand); i = i + 1) {
			CharBox* _tmp2_;
			_tmp2_ = NULL;
			self->priv->xboxes[i] = (_tmp2_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (multiplicand, i))), (self->priv->xboxes[i] == NULL) ? NULL : (self->priv->xboxes[i] = (g_object_unref (self->priv->xboxes[i]), NULL)), _tmp2_);
			gtk_widget_show_all ((GtkWidget*) self->priv->xboxes[i]);
			gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->xboxes[i]);
		}
	}
	multiplier = mult_puzzle_get_multiplier (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		for (; i < strlen (multiplier); i = i + 1) {
			CharBox* _tmp3_;
			_tmp3_ = NULL;
			self->priv->yboxes[i] = (_tmp3_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (multiplier, i))), (self->priv->yboxes[i] == NULL) ? NULL : (self->priv->yboxes[i] = (g_object_unref (self->priv->yboxes[i]), NULL)), _tmp3_);
			gtk_widget_show_all ((GtkWidget*) self->priv->yboxes[i]);
			gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->yboxes[i]);
		}
	}
	{
		gint i;
		i = 0;
		for (; i < mult_puzzle_get_num_addends (self->priv->_puzzle); i = i + 1) {
			char* addend;
			addend = mult_puzzle_get_addend (self->priv->_puzzle, i);
			{
				gint j;
				j = 0;
				for (; j < strlen (addend); j = j + 1) {
					CharBox* _tmp4_;
					_tmp4_ = NULL;
					self->priv->addboxes[i].array[j] = (_tmp4_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (addend, j))), (self->priv->addboxes[i].array[j] == NULL) ? NULL : (self->priv->addboxes[i].array[j] = (g_object_unref (self->priv->addboxes[i].array[j]), NULL)), _tmp4_);
					gtk_widget_show_all ((GtkWidget*) self->priv->addboxes[i].array[j]);
					gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->addboxes[i].array[j]);
				}
			}
			addend = (g_free (addend), NULL);
		}
	}
	answer = mult_puzzle_get_answer (self->priv->_puzzle);
	{
		gint i;
		i = 0;
		for (; i < strlen (answer); i = i + 1) {
			CharBox* _tmp5_;
			_tmp5_ = NULL;
			self->priv->zboxes[i] = (_tmp5_ = canvas_create_mult_box (self, g_utf8_get_char (g_utf8_offset_to_pointer (answer, i))), (self->priv->zboxes[i] == NULL) ? NULL : (self->priv->zboxes[i] = (g_object_unref (self->priv->zboxes[i]), NULL)), _tmp5_);
			gtk_widget_show_all ((GtkWidget*) self->priv->zboxes[i]);
			gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->zboxes[i]);
		}
	}
	_tmp7_ = NULL;
	unknown = (_tmp7_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp6_), unknown_length1 = _tmp6_, unknown_size = unknown_length1, _tmp7_);
	{
		gint i;
		i = 0;
		for (; i < 10; i++) {
			CharBox* _tmp8_;
			_tmp8_ = NULL;
			self->priv->digitboxes[i] = (_tmp8_ = canvas_create_digit_box (self, unknown, unknown_length1, i), (self->priv->digitboxes[i] == NULL) ? NULL : (self->priv->digitboxes[i] = (g_object_unref (self->priv->digitboxes[i]), NULL)), _tmp8_);
			gtk_widget_show_all ((GtkWidget*) self->priv->digitboxes[i]);
			gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->digitboxes[i]);
		}
	}
	if (mult_puzzle_get_is_done (p)) {
		g_object_set ((GtkWidget*) self, "sensitive", FALSE, NULL);
		{
			gint i;
			i = 0;
			for (; i < 10; i++) {
				char_box_set_highlight (self->priv->digitboxes[i], GTK_STATE_INSENSITIVE);
			}
		}
	}
	multiplicand = (g_free (multiplicand), NULL);
	multiplier = (g_free (multiplier), NULL);
	answer = (g_free (answer), NULL);
	unknown = (g_free (unknown), NULL);
}


void canvas_highlight_box (Canvas* self, CharBox* box, gboolean digit_box, gboolean hover, gboolean all) {
	CanvasMode _tmp3_;
	CanvasMode native_mode;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	if (all) {
		GList* _tmp0_;
		GList* boxes;
		_tmp0_ = NULL;
		if (digit_box) {
			_tmp0_ = self->priv->digit_boxes;
		} else {
			_tmp0_ = self->priv->mult_boxes;
		}
		boxes = _tmp0_;
		{
			GList* b_collection;
			GList* b_it;
			b_collection = boxes;
			for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
				CharBox* _tmp2_;
				CharBox* b;
				_tmp2_ = NULL;
				b = (_tmp2_ = (CharBox*) b_it->data, (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_));
				{
					gboolean _tmp1_;
					_tmp1_ = FALSE;
					if (b != box) {
						_tmp1_ = _vala_strcmp0 (char_box_get_letter (b), char_box_get_letter (box)) == 0;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						canvas_highlight_box (self, b, digit_box, hover, FALSE);
					}
					(b == NULL) ? NULL : (b = (g_object_unref (b), NULL));
				}
			}
		}
	}
	_tmp3_ = 0;
	if (digit_box) {
		_tmp3_ = CANVAS_MODE_DIGIT;
	} else {
		_tmp3_ = CANVAS_MODE_CHAR;
	}
	native_mode = _tmp3_;
	if (self->priv->mode == native_mode) {
		if (_vala_strcmp0 (self->priv->mode_letter, char_box_get_letter (box)) == 0) {
			char_box_set_highlight (box, GTK_STATE_ACTIVE);
			return;
		}
	} else {
		if (self->priv->mode != CANVAS_MODE_NONE) {
			if (digit_box) {
				gboolean* _tmp5_;
				gint unknowns_size;
				gint unknowns_length1;
				gint _tmp4_;
				gboolean* unknowns;
				gboolean* _tmp7_;
				gint guesses_size;
				gint guesses_length1;
				gint _tmp6_;
				gboolean* guesses;
				gint digit;
				gboolean _tmp8_;
				_tmp5_ = NULL;
				unknowns = (_tmp5_ = mult_puzzle_get_unknown_digits (self->priv->_puzzle, &_tmp4_), unknowns_length1 = _tmp4_, unknowns_size = unknowns_length1, _tmp5_);
				_tmp7_ = NULL;
				guesses = (_tmp7_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)), &_tmp6_), guesses_length1 = _tmp6_, guesses_size = guesses_length1, _tmp7_);
				digit = g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (box), 0)));
				_tmp8_ = FALSE;
				if (!unknowns[digit]) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = guesses[digit];
				}
				if (_tmp8_) {
					char_box_set_highlight (box, GTK_STATE_INSENSITIVE);
					unknowns = (g_free (unknowns), NULL);
					guesses = (g_free (guesses), NULL);
					return;
				}
				unknowns = (g_free (unknowns), NULL);
				guesses = (g_free (guesses), NULL);
			} else {
				gint digit;
				gint _tmp10__length1;
				gboolean* _tmp10_;
				gint _tmp9_;
				gboolean _tmp11_;
				digit = g_unichar_digit_value (g_utf8_get_char (g_utf8_offset_to_pointer (self->priv->mode_letter, 0)));
				_tmp10_ = NULL;
				if ((_tmp11_ = (_tmp10_ = mult_puzzle_get_letter_guesses (self->priv->_puzzle, (MultPuzzleChar) g_utf8_get_char (g_utf8_offset_to_pointer (char_box_get_letter (box), 0)), &_tmp9_), _tmp10__length1 = _tmp9_, _tmp10_)[digit], _tmp10_ = (g_free (_tmp10_), NULL), _tmp11_)) {
					char_box_set_highlight (box, GTK_STATE_INSENSITIVE);
					return;
				}
			}
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_PRELIGHT);
				return;
			}
		} else {
			if (hover) {
				char_box_set_highlight (box, GTK_STATE_PRELIGHT);
				return;
			}
		}
	}
	char_box_set_highlight (box, GTK_STATE_NORMAL);
}


static gboolean canvas_handle_digit_enter_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, TRUE, TRUE, TRUE);
	return FALSE;
}


static gboolean canvas_handle_mult_enter_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, FALSE, TRUE, TRUE);
	return FALSE;
}


static gboolean canvas_handle_digit_leave_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, TRUE, FALSE, TRUE);
	return FALSE;
}


static gboolean canvas_handle_mult_leave_notify (Canvas* self, CharBox* box, const GdkEventCrossing* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	canvas_highlight_box (self, box, FALSE, FALSE, TRUE);
	return FALSE;
}


static gboolean canvas_handle_release (Canvas* self, CharBox* box, const GdkEventButton* event, gboolean digit_box) {
	gboolean _tmp0_;
	gint x;
	gint y;
	gint w;
	gint h;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	if (!(g_object_get ((GtkWidget*) box, "visible", &_tmp0_, NULL), _tmp0_)) {
		return FALSE;
	}
	/* Make sure pointer is still in our box.  This ignores trying to grab
	 when the widget doesn't support it.*/
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	gtk_widget_get_pointer ((GtkWidget*) box, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) gtk_widget_get_window ((GtkWidget*) box), &w, &h);
	_tmp2_ = FALSE;
	if (CLAMP (x, 0, w) != x) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = CLAMP (y, 0, h) != y;
	}
	if (_tmp2_) {
		return FALSE;
	}
	if ((*event).button == 1) {
		if (digit_box) {
			canvas_start_digit_choice (self, box);
		} else {
			canvas_start_char_choice (self, box);
		}
		return TRUE;
	}
	return FALSE;
}


static gboolean canvas_handle_char_release (Canvas* self, CharBox* box, const GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	return canvas_handle_release (self, box, &(*event), FALSE);
}


static gboolean canvas_handle_digit_release (Canvas* self, CharBox* box, const GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (box != NULL, FALSE);
	return canvas_handle_release (self, box, &(*event), TRUE);
}


static gboolean canvas_handle_none_release (Canvas* self, Canvas* canvas, const GdkEventButton* event) {
	gint x;
	gint y;
	gint w;
	gint h;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (canvas != NULL, FALSE);
	/* Make sure pointer is still in our box.  This ignores trying to grab
	 when the widget doesn't support it.*/
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	gtk_widget_get_pointer ((GtkWidget*) canvas, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) gtk_widget_get_window ((GtkWidget*) canvas), &w, &h);
	_tmp0_ = FALSE;
	if (CLAMP (x, 0, w) != x) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = CLAMP (y, 0, h) != y;
	}
	if (_tmp0_) {
		return FALSE;
	}
	if ((*event).button == 1) {
		canvas_clear_mode (self);
	}
	return TRUE;
}


MultPuzzle* canvas_get_puzzle (Canvas* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_puzzle;
}


static void canvas_set_puzzle (Canvas* self, MultPuzzle* value) {
	MultPuzzle* _tmp2_;
	MultPuzzle* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_puzzle = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)), (self->priv->_puzzle == NULL) ? NULL : (self->priv->_puzzle = (g_object_unref (self->priv->_puzzle), NULL)), _tmp2_);
	g_object_notify ((GObject *) self, "puzzle");
}


GtkMult* canvas_get_mult (Canvas* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_mult;
}


static void canvas_set_mult (Canvas* self, GtkMult* value) {
	GtkMult* _tmp2_;
	GtkMult* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_mult = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_)), (self->priv->_mult == NULL) ? NULL : (self->priv->_mult = (g_object_unref (self->priv->_mult), NULL)), _tmp2_);
	g_object_notify ((GObject *) self, "mult");
}


static gboolean _canvas_handle_none_release_gtk_widget_button_release_event (Canvas* _sender, const GdkEventButton* event, gpointer self) {
	return canvas_handle_none_release (self, _sender, event);
}


static void _canvas_handle_size_allocate_gtk_widget_size_allocate (GtkFixed* _sender, const GdkRectangle* allocation, gpointer self) {
	canvas_handle_size_allocate (self, _sender, allocation);
}


static void _canvas_handle_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self) {
	canvas_handle_puzzle_change (self, _sender);
}


static GObject * canvas_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	CanvasClass * klass;
	GObjectClass * parent_class;
	Canvas * self;
	klass = CANVAS_CLASS (g_type_class_peek (TYPE_CANVAS));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CANVAS (obj);
	{
		char* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		GtkFixed* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		CharBox* _tmp9_;
		CharBox* _tmp10_;
		char* x;
		char* y;
		char* z;
		CharBox** _tmp12_;
		gint _tmp11_;
		CharBox** _tmp14_;
		gint _tmp13_;
		CharBox** _tmp16_;
		gint _tmp15_;
		CharBox** _tmp17_;
		ArrayBox* _tmp19_;
		gint _tmp18_;
		canvas_set_puzzle (self, gtk_mult_get_puzzle (self->priv->_mult));
		self->priv->mode = CANVAS_MODE_NONE;
		_tmp2_ = NULL;
		self->priv->mode_letter = (_tmp2_ = NULL, self->priv->mode_letter = (g_free (self->priv->mode_letter), NULL), _tmp2_);
		self->priv->min_box_request = -1;
		_tmp3_ = NULL;
		self->priv->mult_boxes = (_tmp3_ = NULL, (self->priv->mult_boxes == NULL) ? NULL : (self->priv->mult_boxes = (_g_list_free_g_object_unref (self->priv->mult_boxes), NULL)), _tmp3_);
		_tmp4_ = NULL;
		self->priv->digit_boxes = (_tmp4_ = NULL, (self->priv->digit_boxes == NULL) ? NULL : (self->priv->digit_boxes = (_g_list_free_g_object_unref (self->priv->digit_boxes), NULL)), _tmp4_);
		_tmp5_ = NULL;
		self->priv->fixed = (_tmp5_ = g_object_ref_sink ((GtkFixed*) gtk_fixed_new ()), (self->priv->fixed == NULL) ? NULL : (self->priv->fixed = (g_object_unref (self->priv->fixed), NULL)), _tmp5_);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->fixed);
		_tmp6_ = NULL;
		self->priv->vsep = (_tmp6_ = (GtkWidget*) g_object_ref_sink ((GtkVSeparator*) gtk_vseparator_new ()), (self->priv->vsep == NULL) ? NULL : (self->priv->vsep = (g_object_unref (self->priv->vsep), NULL)), _tmp6_);
		_tmp7_ = NULL;
		self->priv->hsep1 = (_tmp7_ = (GtkWidget*) g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), (self->priv->hsep1 == NULL) ? NULL : (self->priv->hsep1 = (g_object_unref (self->priv->hsep1), NULL)), _tmp7_);
		_tmp8_ = NULL;
		self->priv->hsep2 = (_tmp8_ = (GtkWidget*) g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), (self->priv->hsep2 == NULL) ? NULL : (self->priv->hsep2 = (g_object_unref (self->priv->hsep2), NULL)), _tmp8_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->vsep);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep1);
		gtk_container_add ((GtkContainer*) self->priv->fixed, self->priv->hsep2);
		_tmp9_ = NULL;
		self->priv->plusbox = (_tmp9_ = g_object_ref_sink (char_box_new ("+", GTK_SHADOW_NONE)), (self->priv->plusbox == NULL) ? NULL : (self->priv->plusbox = (g_object_unref (self->priv->plusbox), NULL)), _tmp9_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->plusbox);
		_tmp10_ = NULL;
		self->priv->timesbox = (_tmp10_ = g_object_ref_sink (char_box_new ("×", GTK_SHADOW_NONE)), (self->priv->timesbox == NULL) ? NULL : (self->priv->timesbox = (g_object_unref (self->priv->timesbox), NULL)), _tmp10_);
		gtk_container_add ((GtkContainer*) self->priv->fixed, (GtkWidget*) self->priv->timesbox);
		x = mult_puzzle_get_multiplicand (self->priv->_puzzle);
		y = mult_puzzle_get_multiplier (self->priv->_puzzle);
		z = mult_puzzle_get_answer (self->priv->_puzzle);
		self->priv->num_box_rows = 3 + ((gint) strlen (y));
		self->priv->num_box_cols = 1 + ((gint) strlen (z));
		_tmp12_ = NULL;
		self->priv->xboxes = (_tmp12_ = g_new0 (CharBox*, (_tmp11_ = strlen (x)) + 1), self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->xboxes_length1 = _tmp11_, self->priv->xboxes_size = self->priv->xboxes_length1, _tmp12_);
		_tmp14_ = NULL;
		self->priv->yboxes = (_tmp14_ = g_new0 (CharBox*, (_tmp13_ = strlen (y)) + 1), self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->yboxes_length1 = _tmp13_, self->priv->yboxes_size = self->priv->yboxes_length1, _tmp14_);
		_tmp16_ = NULL;
		self->priv->zboxes = (_tmp16_ = g_new0 (CharBox*, (_tmp15_ = strlen (z)) + 1), self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->zboxes_length1 = _tmp15_, self->priv->zboxes_size = self->priv->zboxes_length1, _tmp16_);
		_tmp17_ = NULL;
		self->priv->digitboxes = (_tmp17_ = g_new0 (CharBox*, 10 + 1), self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->digitboxes_length1 = 10, self->priv->digitboxes_size = self->priv->digitboxes_length1, _tmp17_);
		_tmp19_ = NULL;
		self->priv->addboxes = (_tmp19_ = g_new0 (ArrayBox, _tmp18_ = mult_puzzle_get_num_addends (self->priv->_puzzle)), self->priv->addboxes = (g_free (self->priv->addboxes), NULL), self->priv->addboxes_length1 = _tmp18_, self->priv->addboxes_size = self->priv->addboxes_length1, _tmp19_);
		{
			gint i;
			i = 0;
			for (; i < self->priv->addboxes_length1; i = i + 1) {
				CharBox** _tmp22_;
				gint _tmp21_;
				char* _tmp20_;
				_tmp22_ = NULL;
				_tmp20_ = NULL;
				self->priv->addboxes[i].array = (_tmp22_ = g_new0 (CharBox*, (_tmp21_ = strlen (_tmp20_ = mult_puzzle_get_addend (self->priv->_puzzle, i))) + 1), self->priv->addboxes[i].array = (_vala_array_free (self->priv->addboxes[i].array, self->priv->addboxes[i].array_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->addboxes[i].array_length1 = _tmp21_, self->priv->addboxes[i].array_size = self->priv->addboxes[i].array_length1, _tmp22_);
				_tmp20_ = (g_free (_tmp20_), NULL);
			}
		}
		/* Calculate minimum amount of space needed.*/
		self->priv->min_width = ((((12 + ((self->priv->num_box_cols - 1) * CANVAS_SPACING)) + CANVAS_SPACING) + self->priv->vsep->requisition.width) + (CANVAS_SPACING * 4)) + 12;
		self->priv->min_height = ((12 + ((self->priv->num_box_rows + 1) * CANVAS_SPACING)) + (self->priv->hsep1->requisition.height * 2)) + 12;
		gtk_widget_set_size_request ((GtkWidget*) self, self->priv->min_width, self->priv->min_height);
		/*
		    Gtk.TargetEntry[] entries = new Gtk.TargetEntry[1];
		    entries[0].target = "STRING";
		    entries[0].flags = Gtk.TargetFlags.SAME_APP;
		    entries[0].info = 0;
		    Gtk.drag_dest_set (this, 0, entries, Gdk.DragAction.MOVE);
		    */
		gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_RELEASE_MASK);
		g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _canvas_handle_none_release_gtk_widget_button_release_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->fixed, "size-allocate", (GCallback) _canvas_handle_size_allocate_gtk_widget_size_allocate, self, 0);
		canvas_handle_puzzle_change (self, self->priv->_puzzle);
		g_signal_connect_object (self->priv->_puzzle, "changed", (GCallback) _canvas_handle_puzzle_change_mult_puzzle_changed, self, 0);
		x = (g_free (x), NULL);
		y = (g_free (y), NULL);
		z = (g_free (z), NULL);
	}
	return obj;
}


static void canvas_class_init (CanvasClass * klass) {
	canvas_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CanvasPrivate));
	G_OBJECT_CLASS (klass)->get_property = canvas_get_property;
	G_OBJECT_CLASS (klass)->set_property = canvas_set_property;
	G_OBJECT_CLASS (klass)->constructor = canvas_constructor;
	G_OBJECT_CLASS (klass)->finalize = canvas_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_MULT_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_MULT, g_param_spec_object ("mult", "mult", "mult", TYPE_GTK_MULT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void canvas_instance_init (Canvas * self) {
	self->priv = CANVAS_GET_PRIVATE (self);
}


static void canvas_finalize (GObject* obj) {
	Canvas * self;
	self = CANVAS (obj);
	(self->priv->_puzzle == NULL) ? NULL : (self->priv->_puzzle = (g_object_unref (self->priv->_puzzle), NULL));
	(self->priv->_mult == NULL) ? NULL : (self->priv->_mult = (g_object_unref (self->priv->_mult), NULL));
	self->priv->mode_letter = (g_free (self->priv->mode_letter), NULL);
	(self->priv->fixed == NULL) ? NULL : (self->priv->fixed = (g_object_unref (self->priv->fixed), NULL));
	(self->priv->vsep == NULL) ? NULL : (self->priv->vsep = (g_object_unref (self->priv->vsep), NULL));
	(self->priv->hsep1 == NULL) ? NULL : (self->priv->hsep1 = (g_object_unref (self->priv->hsep1), NULL));
	(self->priv->hsep2 == NULL) ? NULL : (self->priv->hsep2 = (g_object_unref (self->priv->hsep2), NULL));
	(self->priv->mult_boxes == NULL) ? NULL : (self->priv->mult_boxes = (_g_list_free_g_object_unref (self->priv->mult_boxes), NULL));
	(self->priv->digit_boxes == NULL) ? NULL : (self->priv->digit_boxes = (_g_list_free_g_object_unref (self->priv->digit_boxes), NULL));
	self->priv->xboxes = (_vala_array_free (self->priv->xboxes, self->priv->xboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->yboxes = (_vala_array_free (self->priv->yboxes, self->priv->yboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->zboxes = (_vala_array_free (self->priv->zboxes, self->priv->zboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->addboxes = (g_free (self->priv->addboxes), NULL);
	self->priv->digitboxes = (_vala_array_free (self->priv->digitboxes, self->priv->digitboxes_length1, (GDestroyNotify) g_object_unref), NULL);
	(self->priv->plusbox == NULL) ? NULL : (self->priv->plusbox = (g_object_unref (self->priv->plusbox), NULL));
	(self->priv->timesbox == NULL) ? NULL : (self->priv->timesbox = (g_object_unref (self->priv->timesbox), NULL));
	G_OBJECT_CLASS (canvas_parent_class)->finalize (obj);
}


GType canvas_get_type (void) {
	static GType canvas_type_id = 0;
	if (canvas_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (CanvasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) canvas_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Canvas), 0, (GInstanceInitFunc) canvas_instance_init, NULL };
		canvas_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "Canvas", &g_define_type_info, 0);
	}
	return canvas_type_id;
}


static void canvas_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Canvas * self;
	gpointer boxed;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		g_value_set_object (value, canvas_get_puzzle (self));
		break;
		case CANVAS_MULT:
		g_value_set_object (value, canvas_get_mult (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void canvas_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Canvas * self;
	self = CANVAS (object);
	switch (property_id) {
		case CANVAS_PUZZLE:
		canvas_set_puzzle (self, g_value_get_object (value));
		break;
		case CANVAS_MULT:
		canvas_set_mult (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




