/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __DIGIT_CHOOSER_H__
#define __DIGIT_CHOOSER_H__

#include <gtkmm.h>
#include "CharBox.h"
#include "MultPuzzle.h"

class DigitChooser
	: public Gtk::Dialog
{
	public:
	
	DigitChooser (Gtk::Window &parent, MultPuzzle &puzzle, char letter);
	~DigitChooser (void);
	
	protected:
	
	class DigitBox
		: public Gtk::Button
	{
		public:
		
		DigitBox (char digit, DigitChooser *d);
		
		protected:
		
		void on_clicked (void);
		DigitChooser *dc;
		char character;
	};
};

#endif /* __DIGIT_CHOOSER_H__ */
