#!/bin/sh
#
#	$Id: do_animations.sh,v 1.3 2009/01/11 06:18:43 guru Exp $
#
# Bourne script to test all GMT animations.
# If no argument is given we only make a single PS frame
# If any argument is used we do the full animation
# See each animation subdirectory for the results

# Temporary change LANG to C
LANG=C

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then	# awk is rotten
	if [ `type nawk | grep "not found" | wc -l` -eq 1 ]; then
		AWK=gawk
	else
		AWK=nawk
	fi
else
	AWK=awk
fi
export AWK

# Extend executable and library path if requested

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	PATH=$1:$PATH
	export PATH
	if [ $# = 2 ]; then
		LD_LIBRARY_PATH=$2:${LD_LIBRARY_PATH:-/usr/lib}
		export LD_LIBRARY_PATH
	fi
fi

# Loop over all animations and run each script

for ex in anim??/anim*.sh
do
	printf "Doing animation %s ... " $ex
	cd `dirname $ex`
	gmtdefaults -Du > .gmtdefaults4
	sh `basename $ex`
	cd ..
	echo "done"
done

echo "Completed all animations"
