.TH PSWIGGLE l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
pswiggle \- Plot anomaly along track on a map
.SH SYNOPSIS
\fBpswiggle\fP \fIxyz_files\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
\fB\-Z\fP\fIscale\fP [ \fB\-A\fP\fIazimuth\fP ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcenter\fP ] [ \fB\-D\fP\fIgap\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ]
[ \fB\-G\fP\fIfillrgb\fP ] [ \fB\-H\fP[\fInrec\fP] ]
[ \fB\-I\fP\fIfix_az\fP ] [ \fB\-K\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ]
[ \fB\-S\fP[\fBx\fP]\fIlon0/lat0/length\fP[\fIunits\fP] ] [ \fB\-T\fP\fItrack_pen\fP ]
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-W\fP\fIwiggle_pen\fP ] [ \fB\-X\fP\fIx-shift\fP ]
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpswiggle\fP reads (x,y,z) triplets from files [or standard input] and plots z as a function of
distance along track. This means that two consecutive (x,y) points define the local distance axis,
and the local z axis is then perpendicular to the distance axis. The user may set a preferred
positive anomaly plot direction, and if the positive normal is outside
the plus/minus 90 degree window around the preferred direction, then 180 degrees are added to the
direction. Either the positive or the negative wiggle may be shaded. The resulting \fIPostScript\fP
code is written to standard output.
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpswiggle\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-Z
Gives anomaly scale in data-units/distance-unit.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Sets the preferred positive azimuth. Positive wiggles will "gravitate" towards that
direction.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Subtract \fIcenter\fP from the data set before plotting [0].
.TP
.B \-D
Means there is a data gap if 2 consecutive points are more than \fIgap\fP distance
units apart. For longitude/latitude data \fIgap\fP is in km, else it is in the
user's units.\"'
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90].\"'
.TP
.B \-G
Set fill of positive wiggles. [Default is black]
Specify the shade (0\-255) or color (r/g/b, each in 0\-255, h/s/v, with
h in 0\-360, s, and v in 0\-1, and set \fBCOLOR_MODEL\fP = hsv, or
c/m/y/k, each in 0\-100 %).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIr/g/b\fP[\fBB\fP[\fIr/g/b\fP]] to specify fore- and background
colors (use \fIr/g/b\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Set a fixed azimuth projection for wiggles [Default uses track azimuth, but see \fB\-A\fP].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Multiple segment file. Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Paint negative wiggles instead of positive [Default].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Draws a simple vertical scale centered on \fIlon0/lat0\fP. Use \fB\-Sx\fP to specify cartesian coordinates instead.
\fIlength\fP is in z units, append unit name for labeling
.TP
.B \-T
Draw track [Default is no track]. Append pen attributes to use [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Draw wiggle outline [Default is no outline]. Append pen attributes to use
[Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 3 input columns].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To plot the magnetic anomaly stored in the file track.xym along track @ 1000 nTesla/cm (after removing a mean value of 32000 Tesla),
using a 15 -cm-wide Polar Stereographic map ticked
every 5 degrees in Portrait mode, with positive anomalies in red on a blue track of width 0.25 points, use
.br
.sp
\fBpswiggle\fP track.xym \fB\-R\fP-20/10/-80/-60 \fB\-JS\fP0/90/15\fBc\fP \fB\-Z\fP1000 \fB\-B\fP5 \fB\-P \-G\fP255/0/0 \fB\-T\fP0.25\fBp\fP/0/0/255 \fB\-S\fP1000 \fB\-V\fP > track_xym.ps
.SH BUGS
Sometimes the (x,y) coordinates are not printed with enough significant
digits, so the local perpendicular to the track swings around a lot. To
see if this is the problem, you should do this:
.br
.sp
awk '{ if (NR > 1) print atan2(y-$1, x-$2); y=$1; x=$2; }' yourdata.xyz | more
.br
.sp
(note that output is in radians; on some machines you need "nawk" to do this).
Then if these numbers jump around a lot, you may do this:
.br
.sp
\fBgmtset\fP D_FORMAT %.12lg
.br
awk '{ print NR, $0 }' yourdata.xyz | \fBfilter1d\fP \fB\-Fb\fP5 \fB\-N\fP4/0 > smoothed.xyz
.br
.sp
and plot this data set instead.
.SH "SEE ALSO"
.IR gmt (l),
.IR filter1d (l),
.IR psbasemap (l),
.IR splitxyz (l)
