.TH GRDEDIT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdedit \- Modifying the header in a 2-D grdfile
.SH SYNOPSIS
\fBgrdedit\fP \fIgrdfile\fP [ \fB\-A\fP ] [ \fB\-D\fP\fIxunit/yunit/zunit/scale/offset/title/remark\fP ]
[ \fB\-N\fP\fIxyzfile\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ] [ \fB\-S\fP ] [ \fB\-V\fP ]
 [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdedit\fP reads the header information in a binary 2-D grdfile and replaces
the information with values provided on the command line [if any]. As an option,
global, geographical grids (with 360 degrees longitude range) can be rotated in
the east-west direction, and individual nodal values can be replaced from a
table of \fIx, y, z\fP values. \fBgrdedit\fP only operates on files containing a grdheader.
.br
        No space between the option flag and the associated arguments. Use upper case for the
option flags and lower case for modifiers.
.TP
\fIgrdfile\fP
Name of the 2-D grdfile to modify
.sp
.SH OPTIONS
.TP
.B \-A
If necessary, adjust the file's \fIx_inc, y_inc\fP to be compatible with\"'
its domain (or a new domain set with \fB\-R\fP). Older gridfiles (i.e., created
prior to GMT 3.1) often had excessive slop in
\fIx_inc, y_inc\fP and an adjustment is necessary. Newer files are created correctly.
.TP
.B \-D
Give new values for \fIxunit, yunit, zunit, scale, offset, title,\fP and \fIremark\fP.
To leave some of the values untouched, specify = as the new value.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-N
Read the ascii (or binary; see \fB\-bi\fP) file \fIxyzfile\fP and replace the corresponding
nodal values in the grid with these \fIz\fP values.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
The new w/e/s/n values will replace those in the grid, and the \fIx_inc, y_inc\fP
values are adjusted, if necessary.
.TP
.B \-S
For global, geographical grids only. Grid values will be shifted laterally according to
the new borders given in \fB\-R\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 3 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
Let us assume the file data.grd covers the area 300/310/10/30. We want
to change the boundaries from geodetic longitudes to geographic and put a new title in
the header. We accomplish this by
.br
.sp
\fBgrdedit\fP data.grd \fB\-R\fP-60/-50/10/30 \fB\-D\fP=/=/=/=/=/"Gravity Anomalies"/=
.br
.sp
The grid world.grd has the limits 0/360/-72/72. To shift the
data so that the limits would be -180/180/-72/72, use
.br
.sp
\fBgrdedit\fP world.grd \fB\-R\fP-180/180/-72/72 \fB\-S\fP
.br
.sp
The file junk.grd was created prior to GMT 3.1 with incompatible
\fB\-R\fP and \fB\-I\fP arguments. To reset the x- and y-increments
we run
.br
.sp
\fBgrdedit\fP junk.grd \fB\-A\fP
.SH "SEE ALSO"
.IR gmt (l),
.IR grd2xyz (l),
.IR xyz2grd (l)
