.TH GRDCONTOUR l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdcontour \- contouring of 2-D gridded data sets
.SH SYNOPSIS
\fBgrdcontour\fP \fIgrdfile\fP \fB\-C\fP\fIcont_int\fP \fB\-J\fP\fIparameters\fP [ \fB\-A\fP[\fB-\fP|\fIannot_int\fP][\fIlabelinfo\fP] ]
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP[d|f|n|l|L|x|X]\fIinfo\fP ]
[ \fB\-K\fP ] [ \fB\-L\fP\fIlow/high\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP\fIcut\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ]
[ \fB\-S\fP\fIsmoothfactor\fP ] [ \fB\-T\fP[\fB+|-\fP][\fIgap/length\fP][\fB:\fP\fILH\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-W\fP[\fB+\fP][\fItype\fP]\fIpen\fP ]
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP[\fIfactor\fP[/\fIshift\fP]][\fBp\fP] ] [ \fB\-c\fP\fIcopies\fP ]
[ \fB\-bo\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBgrdcontour\fP reads a 2-D gridded file and produces a contour map by tracing
each contour through the grid. As an option, the x/y/z positions of the contour lines may be dumped to
a single multisegment file or many separate files. \fIPostScript\fP code is generated and sent to standard output. Various options
that affect the plotting are available.
.br
        No space between the option flag and the associated arguments. Use upper case for the
option flags and lower case for modifiers.
.TP
\fIgrdfile\fP
2-D gridded data set to be contoured
.TP
.B \-C
The contours to be drawn may be specified in one of three possible ways:
.br
If \fIcont_int\fP has the suffix ".cpt" and can be opened as a file, it is assumed
to be a color palette table. The color boundaries are then used as contour levels.
If the cpt-file has annotation flags in the last column then those contours will be
annotated. By default all contours are labeled; use \fB\-A\-\fP to disable all annotations.
.br
If \fIcont_int\fP is a file but not a cpt-file, it is expected to contain contour levels
in column 1 and a C(ontour) OR A(nnotate) in col 2. The levels marked C (or c) are contoured,
the levels marked A (or a) are contoured and annotated. Optionally, a third column may be
present and contain the fixed annotation angle for this contour level.
.br
If no file is found, then \fIcont_int\fP is
interpreted as a constant contour interval. If \fB\-A\fP is set and \fB\-C\fP is not, then
the contour interval is set equal to the specified annotation interval.
.br
If a file is given and \fB\-T\fP is set,
then only contours marked with upper case C or A will have tickmarks. In all cases the contour
values have the same units as the grid.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
\fIannot_int\fP is annotation interval in data units. Ignored if contour levels are given in a file.
[Default is no annotations]. Give \fB-\fP to disable all annotations implied by \fB\-C\fP.
The optional \fIlabelinfo\fP controls the specifics of the label formatting and consists of a concatenated string
made up of any of the following control arguments:
.br
.br
\fB+a\fP\fIangle\fP for annotations at a fixed angle, \fB+an\fP for line-normal, or \fB+ap\fP for line-parallel [Default].
.br
\fB+c\fP\fIdx\fP[/\fIdy\fP] sets the clearance between label and optional text box. Append \fBc|i|m|p\fP to specify
the unit or % to indicate a percentage of the label font size [15%].
.br
\fB+f\fP\fIfont\fP sets the desired font [Default \fBANNOT_FONT_PRIMARY\fP].
.br
\fB+g\fP[\fIcolor\fP] selects opaque text boxes [Default is transparent]; optionally specify the color [Default is \fBPAGE_COLOR\fP].
.br
\fB+j\fP\fIjust\fP sets label justification [Default is CM].
.br
\fB+k\fP\fIcolor\fP sets color of text labels [Default is \fBCOLOR_BACKGROUND\fP].
.br
\fB+l\fP\fIlabel\fP sets the constant label text.
.br
\fB+L\fP\fIlflag\fP sets the label text according to the specified flag:
.br
\fIflag\fP is \fBh\fP: Take the label from the current multisegment header (first scan for an embedded
\fB\-L\fP\fIlabel\fP option, if not use the first word following the segment flag).
.br
\fIflag\fP is \fBd\fP: Take the Cartesian plot distances along the line as the label; append \fBc|i|m|p\fP
as the unit [Default is \fBMEASURE_UNIT\fP].
.br
\fIflag\fP is \fBD\fP: Calculate actual map distances; append \fBd|e|k|m|n\fP as the unit [Default is \fBd\fP(egrees),
unless label placement was based on map distances along the lines in which case we use the same unit specified for that algorithm].
Requires a map projection to be used.
.br
\fIflag\fP is \fBf\fP: Use text after the 2nd column in the fixed label location file as the label. Requires the fixed label
location setting.
.br
\fIflag\fP is \fBx\fP: As \fBh\fP but use the headers in the \fIxfile.d\fP instead. Requires the crossing file option.
.br
\fB+o\fP selects rounded rectangular text box [Default is rectangular]. Not applicable for curved text (\fB+v\fP) and
only makes sense for opaque text boxes.
.br
\fB+p\fP[\fIpen\fP] draws the outline of text boxsets [Default is no outline]; optionally specify pen for outline [Default is width = 0.25p, color = black, texture = solid].
.br
\fB+r\fP\fImin_rad\fP will not place labels where the line's radius of curvature is less than \fImin_rad\fP [Default is 0].\"'
.br
\fB+s\fP\fIsize\fP sets the desired font size in points [Default is 9].
.br
\fB+u\fP\fIunit\fP appends \fIunit\fP to all line labels. If \fIunit\fP starts with a leading hypen (-) then there will be no space
between label value and the unit.
[Default is no unit].
.br
\fB+v\fP specifies curved labels following the path [Default is straight labels].
.br
\fB+w\fP specifies how many (\fIx, y\fP) points will be used to estimate label angles [Default is 10].
.br
\fB+=\fP\fIprefix\fP prepends \fIprefix\fP to all line labels. If \fIprefix\fP starts with a leading hypen (-) then there will be no space
between label value and the prefix. [Default is no prefix].
If no name is specified, the unit given in the \fIgrdfile\fP will be used.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz (or \fI.b\fP is \fB\-b\fP is selected), where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.) If the prefix is given as '-'
the file names are instead \fIC#_i\fP (interior) or \fIC#_e\fP (external) plus extension, and # is just a running number. This allows us to
make short file names that will work with GNU utilities under DOS.
However, when \fB\-M\fP
is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective view [180/90].\"'
.TP
.B \-G
Controls the placement of labels along the contours. Choose among five controlling algorithms:
.br
\fB\-G\fP\fBd\fP\fIdist\fP[c|i|m|p] or \fB\-G\fP\fBD\fP\fIdist\fP[d|e|k|m|n].
For lower case \fBd\fP, give distances between labels on the plot in your preferred measurement unit
\fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points), while for upper case \fBD\fP, specify
distances in map units and append the unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP
(nautical mile), or \fBd\fP (spherical degree). [Default is 10\fBc\fP or 4\fBi\fP].
.br
\fB\-G\fP\fBf\fP\fIffile.d\fP reads the ascii file \fIffile.d\fP and places labels at locations in the file
that matches locations along the contours. Inexact mathces and points outside the region are skipped.
.br
\fB\-G\fP\fBl|L\fP\fIline1\fP[,\fIline2\fP,...] Give \fIstart\fP and \fIstop\fP coordinates for one or
more comma-separated straight line segments. Labels will be placed where these lines intersect the
contours. The format of each \fIline\fP specification is \fIstart/stop\fP, where \fIstart\fP and \fIstop\fP
are either a specified point \fIlon/lat\fP or a 2-character \fBXY\fP key that uses the justification
format employed in \fBpstext\fP to indicate a point on the map, given as [LCR][BMT].
In addition, you may use Z+ and Z- which correspond to the locations of the global max and min locations in
the grid, respectively.
\fB\-G\fP\fBL\fP will interpret the point pairs as defining great circles [Default is straight line].
.br
\fB\-G\fP\fBn\fP\fIn_label\fP specifies the number of equidistant labels for contours line [1].
Upper case \fB\-G\fP\fBN\fP starts labeling exactly at the start of the line [Default centers them along the line].
\fB\-G\fP\fBN\fP-1 places one justified label at start, while \fB\-G\fP\fBN\fP+1 places one justified label at the end of contours.
Optionally, append /\fImin_dist\fP[c|i|m|p] to enforce that a minimum distance separation between successive labels is enforced.
.br
\fB\-G\fP\fBx|X\fP\fIxfile.d\fP reads the multi-segment file \fIxfile.d\fP and places labels at the intersections
between the contours and the lines in\fIxfile.d\fP. \fB\-G\fP\fBX\fP will resample the lines first along
great-circle arcs.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Limit range: Do not draw contours for data values below \fIlow\fP or above \fIhigh\fP.
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceeded by a header record whose first column is \fIflag\fP
followed by the contour level.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Do not draw contours with less than \fIcut\fP number of points [Draw all contours].
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
[Default is region defined in the grd file].
.TP
.B \-S
Used to resample the contour lines at roughly every (gridbox_size/\fIsmoothfactor\fP) interval.
.TP
.B \-T
Will draw tickmarks pointing in the downward direction every \fIgap\fP along the innermost closed contours.
Append \fIgap\fP and tickmark length or use defaults [0.5\fBc\fP/0.1c or 0.2\fBi\fP/0.04i].
User may choose to tick only local highs or local lows by specifying \fB\-T+\fP or \fB\-T-\fP, respectively.
Appending :LH will plot the characters L and H at the center of closed
innermost contours (local lows and highs). L and H can be any single character (e.g., LH, -+, etc.)
If a file is given by \fB\-C\fP and \fB\-T\fP is set,
then only contours marked with upper case C or A will have tickmarks [and annotation].
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
\fItype\fP, if present, can be 'a' for annotated contours or 'c' for regular contours [Default].
\fIpen\fP sets the attributes for the particular line. Default values for annotated contours:
width = 3, color = black, texture = solid. Regular contours have default width = 1. If the
\fB+\fP flag is specified then the color of the contour lines are taken from the cpt file (see \fB\-C\fP).
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-Z
Use to subtract \fIshift\fP from the data and multiply the results by \fIfactor\fP before contouring starts [1/0].
(Numbers in \fB\-A, \-C, \-L\fP refer to values after this scaling has occurred.)
Append \fBp\fP to indicate
that this grid file contains z-values that are periodic in 360 degrees (e.g.,
phase data, angular distributions) and that
special precautions must be taken when determining 0-contours.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
.SH EXAMPLES
To contour the file hawaii_grav.grd every 25 mGal on a Mercator map at 0.5 inch/degree, annotate
every 50 mGal (using fontsize = 10), using 1 degree tickmarks, and draw 30 minute gridlines:
.br
.sp
\fBgrdcontour\fP hawaii_grav.grd \fB\-Jm\fP0.5\fBi\fP \fB\-C\fP25 \fB\-A\fP50\fB+f\fP10 \fB\-B\fP1\fBg\fP30\fBm\fP > hawaii_grav.ps
.br
.sp
To contour the file image.grd using the levels in the file cont.d on a linear projection at 0.1 cm/x-unit
and 50 cm/y-unit, using 20 (x) and 0.1 (y) tickmarks, smooth the contours a bit, use "RMS Misfit" as
plot-title, use a thick red pen for annotated contours, and a thin, dashed, blue pen for the rest, and send the output to the default printer:
.br
.sp
\fBgrdcontour\fP image.grd \fB\-Jx\fP0.1\fBc\fP/50.0\fBc\fP \fB\-C\fPcont.d \fB\-S\fP4 \fB\-B\fP20/0.1:."RMS Misfit":
\fB\-Wa\fP5/255/0/0 \fB\-Wc\fP1/0/0/255\fBta\fP | lp
The labeling of local highs and lows may plot outside the innermost contour since only the mean value
of the contour coordinates is used to position the label.
.SH "SEE ALSO"
.IR gmt (l),
.IR gmtdefaults (l),
.IR psbasemap (l),
.IR grdimage (l),
.IR grdview (l),
.IR pscontour (l)
