/*--------------------------------------------------------------------
 *	$Id: mgd77path.c,v 1.1 2004/08/27 17:43:26 pwessel Exp $
 *
 *    Copyright (c) 2004 by P. Wessel
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * mgd77path accepts MGD77 cruise names and returns the full system
 * path to the file(s).
 *
 * Author:	Paul Wessel
 * Date:	26-AUG-2004
 * Version:	1.0 Based on the old gmtpath.c
 *
 *
 */
 
#include "mgd77.h"

main (int argc, char **argv)
{
	int i;
	
	BOOLEAN error = FALSE;
	
	char path[BUFSIZ];
	
	struct MGD77_CONTROL M;

	argc = GMT_begin (argc, argv);		/* Initialize GMT Machinery */
	
	MGD77_Init (&M, TRUE);			/* Initialize MGD77 Machinery */

	for (i = 1; !error && i < argc; i++) {	/* Process each cruise */
		if (argv[i][0] == '-') {
			error = TRUE;
			continue;
		}
		
 		if (MGD77_Get_Path (path, argv[i], &M))
   			fprintf (stderr, "%s : Cannot find leg %s\n", argv[i], GMT_program);
		else
			printf ("%s\n", path);
	}
	
	if (error || argc == 1) {	/* Display usage */
		fprintf(stderr,"usage: mgd77path cruise1 cruise1 cruise3 ...\n\n");
       		exit(EXIT_FAILURE);
	}

	GMT_end (argc, argv);
}
