close all;
clear all;

%% l2 [Order][Mesh]

%% f = Sin(10x) +  Sin(10y)

h = [1, 1/2, 1/4, 1/8, 1/16];
p = [1:8];

l2 = ...
    [...
        +1.347995e+00 , +7.637785e-01 , +2.676831e-01 , +6.571013e-02 , +1.436486e-02 ; ...
        +1.191675e+00 , +2.755181e-01 , +5.277309e-02 , +8.809107e-03 , +1.323267e-03 ; ...
        +7.184410e-01 , +1.033056e-01 , +7.820192e-03 , +4.841527e-04 , +2.638048e-05 ; ...
        +3.117339e-01 , +2.155022e-02 , +9.971840e-04 , +3.813997e-05 , +1.319923e-06 ; ...
        +2.184741e-01 , +5.804139e-03 , +1.012503e-04 , +1.542529e-06 , +2.342482e-08 ; ...
        +5.286329e-02 , +8.238067e-04 , +9.233377e-06 , +8.532929e-08 , +7.864971e-10 ; ...
        +2.803778e-02 , +1.661450e-04 , +7.238937e-07 , +2.690113e-09 , +8.850496e-12 ; ...
        +4.148550e-03 , +1.836555e-05 , +4.900105e-08 , +1.182243e-10 , +2.679212e-13 ; ...
    ];

P = size(p, 2);
H = size(h, 2);

delta = zeros(P, H - 1);

for i = 1:H-1
    delta(:, i) = ...
        (log10(l2(:, i + 1)) - log10(l2(:, i))) / ...
        (log10(1/h(i + 1))   - log10(1/h(i)));
end

delta

figure;
loglog(1./h, l2, '-*');
grid;
