/*
  Copyright 2013 Siemens Product Lifecycle Management Software Inc. All rights reserved.
  This software and related documentation are proprietary to 
  Siemens Product Lifecycle Management Software Inc.
*/

#ifndef PARASOLID_KERNEL_H_INCLUDED
#define PARASOLID_KERNEL_H_INCLUDED


#include <stddef.h>
#include "parasolid_ifails.h"
#include "parasolid_tokens.h"


/*********************************************************************/
/* TYPEDEFS */
/*********************************************************************/

typedef int PK_enclosure_t;
typedef int PK_ATTDEF_class_t;
typedef int PK_ATTRIB_field_t;
typedef int PK_boolean_function_t;
typedef int PK_boolean_region_t;
typedef int PK_BODY_type_t;
typedef int PK_VERTEX_type_t;
typedef int PK_LOOP_type_t;
typedef int PK_intersect_vector_t;
typedef int PK_intersect_curve_t;
typedef int PK_intersect_fc_t;
typedef int PK_reset_prec_t;
typedef int PK_mass_t;
typedef int PK_mass_periphery_t;
typedef int PK_mass_bound_t;
typedef int PK_check_state_t;
typedef int PK_FACE_trim_confine_t;
typedef int PK_FACE_trim_degen_t;
typedef int PK_BB_status_t;
typedef int PK_BB_event_t;
typedef int PK_blend_trim_t;
typedef int PK_fxf_fault_t;
typedef int PK_BODY_fault_t;
typedef int PK_abort_reason_t;
typedef int PK_BODY_knit_status_t;
typedef int PK_SHELL_type_t;
typedef int PK_SHELL_sign_t;
typedef int PK_FIN_type_t;
typedef int PK_EDGE_vertex_type_t;
typedef int PK_EDGE_fins_type_t;
typedef int PK_neutral_error_t;
typedef int PK_knot_type_t;
typedef int PK_self_intersect_t;
typedef int PK_convexity_t;
typedef int PK_BCURVE_form_t;
typedef int PK_BSURF_form_t;
typedef int PK_HAND_t;
typedef int PK_PARAM_bound_t;
typedef int PK_PARAM_periodic_t;
typedef int PK_PARAM_form_t;
typedef int PK_BODY_sewing_problem_t;
typedef int PK_BODY_sewing_type_t;
typedef int PK_BODY_sewing_removal_t;
typedef int PK_FACE_heal_t;
typedef int PK_local_check_t;
typedef int PK_section_fence_t;
typedef int PK_boolean_fence_t;
typedef int PK_transmit_format_t;
typedef int PK_PARTITION_xmt_deltas_t;
typedef int PK_PARTITION_rcv_deltas_t;
typedef int PK_boolean_match_t;
typedef int PK_range_guess_type_t;
typedef int PK_range_result_t;
typedef int PK_check_geom_t;
typedef int PK_check_bgeom_t;
typedef int PK_check_top_geo_t;
typedef int PK_check_size_box_t;
typedef int PK_check_fa_X_t;
typedef int PK_check_loops_t;
typedef int PK_check_fa_fa_t;
typedef int PK_check_sh_t;
typedef int PK_check_corrupt_t;
typedef int PK_FACE_trim_surf_t;
typedef int PK_blend_check_t;
typedef int PK_blend_fault_t;
typedef int PK_blend_type_t;
typedef int PK_blend_propagate_t;
typedef int PK_blend_vary_t;
typedef int PK_blend_render_rib_t;
typedef int PK_blend_ov_smooth_t;
typedef int PK_blend_ov_cliff_t;
typedef int PK_blend_ov_cliff_end_t;
typedef int PK_blend_ov_notch_t;
typedef int PK_blend_walls_t;
typedef int PK_blend_cs_t;
typedef int PK_blend_xs_plane_t;
typedef int PK_piecewise_rep_t;
typedef int PK_PARAM_end_t;
typedef int PK_PARAM_knot_t;
typedef int PK_PARAM_twist_t;
typedef int PK_TOPOL_sense_t;
typedef int PK_PARAM_degen_t;
typedef int PK_render_edge_t;
typedef int PK_render_silhouette_t;
typedef int PK_render_planar_t;
typedef int PK_render_radial_t;
typedef int PK_render_param_t;
typedef int PK_render_unfix_t;
typedef int PK_render_boundary_t;
typedef int PK_render_transparent_t;
typedef int PK_render_transp_hid_t;
typedef int PK_render_vis_t;
typedef int PK_render_smooth_t;
typedef int PK_render_internal_t;
typedef int PK_render_region_t;
typedef int PK_render_hierarch_t;
typedef int PK_render_bcurve_t;
typedef int PK_render_viewport_t;
typedef int PK_render_invisible_t;
typedef int PK_render_drafting_t;
typedef int PK_render_self_hidden_t;
typedef int PK_render_viewport_clip_t;
typedef int PK_render_viewport_type_t;
typedef int PK_render_line_t;
typedef int PK_facet_shape_t;
typedef int PK_facet_match_t;
typedef int PK_facet_density_t;
typedef int PK_facet_cull_t;
typedef int PK_facet_degen_t;
typedef int PK_facet_go_normals_t;
typedef int PK_facet_go_parameters_t;
typedef int PK_facet_go_edges_t;
typedef int PK_facet_go_strips_t;
typedef int PK_facet_go_interleaved_t;
typedef int PK_facet_fault_t;
typedef int PK_BODY_pick_method_t;
typedef int PK_boolean_select_t;
typedef int PK_thread_t;
typedef int PK_blend_output_rib_t;
typedef int PK_blend_group_rib_t;
typedef int PK_blend_check_su_X_t;
typedef int PK_blend_check_fa_t;
typedef int PK_blend_check_fa_fa_t;
typedef int PK_blend_update_t;
typedef int PK_BCURVE_fit_eval_type_t;
typedef int PK_BCURVE_fit_err_method_t;
typedef int PK_BCURVE_fit_t;
typedef int PK_BODY_curve_nmnl_t;
typedef int PK_LOOP_opl_gap_fill_t;
typedef int PK_BODY_owb_gap_fill_t;
typedef int PK_pattern_check_fa_fa_t;
typedef int PK_pattern_check_loops_t;
typedef int PK_pattern_status_t;
typedef int PK_pattern_same_face_t;
typedef int PK_pattern_coi_face_t;
typedef int PK_pattern_result_t;
typedef int PK_pattern_reblend_t;
typedef int PK_pattern_collision_t;
typedef int PK_local_check_su_X_t;
typedef int PK_local_check_topol_t;
typedef int PK_local_change_topol_t;
typedef int PK_local_status_t;
typedef int PK_TOPOL_track_t;
typedef int PK_BODY_simplify_t;
typedef int PK_BODY_loft_curvature_t;
typedef int PK_BODY_loft_clamp_type_t;
typedef int PK_BODY_loft_fault_t;
typedef int PK_BODY_sweep_alignment_t;
typedef int PK_BODY_sweep_law_type_t;
typedef int PK_BODY_sweep_fault_t;
typedef int PK_boolean_report_t;
typedef int PK_boolean_result_t;
typedef int PK_section_report_t;
typedef int PK_section_result_t;
typedef int PK_blend_transfer_topol_t;
typedef int PK_local_check_fa_fa_t;
typedef int PK_boolean_check_fa_t;
typedef int PK_section_check_fa_t;
typedef int PK_render_ignore_t;
typedef int PK_BODY_topology_t;
typedef int PK_step_surf_t;
typedef int PK_taper_method_t;
typedef int PK_bound_t;
typedef int PK_render_overlap_t;
typedef int PK_FACE_coi_t;
typedef int PK_DEBUG_global_res_t;
typedef int PK_DEBUG_local_res_t;
typedef int PK_DEBUG_diff_t;
typedef int PK_boolean_match_style_t;
typedef int PK_SURF_extend_status_t;
typedef int PK_SURF_extension_t;
typedef int PK_thicken_method_t;
typedef int PK_ATTDEF_callback_type_t;
typedef int PK_FACE_change_type_t;
typedef int PK_PARAM_direction_t;
typedef int PK_fill_hole_fault_t;
typedef int PK_fill_hole_method_t;
typedef int PK_facet_ignore_t;
typedef int PK_CURVE_approx_t;
typedef int PK_facet_ignore_scope_t;
typedef int PK_facet_wire_edges_t;
typedef int PK_offset_method_t;
typedef int PK_render_memory_target_t;
typedef int PK_outline_project_t;
typedef int PK_pick_approximate_t;
typedef int PK_blend_edge_update_t;
typedef int PK_blend_xs_shape_t;
typedef int PK_BODY_sweep_fair_t;
typedef int PK_comparison_t;
typedef int PK_blend_identify_t;
typedef int PK_detail_t;
typedef int PK_replace_merge_t;
typedef int PK_offset_step_t;
typedef int PK_blend_orientation_t;
typedef int PK_3_face_blend_t;
typedef int PK_FACE_simplify_t;
typedef int PK_blend_convexity_t;
typedef int PK_fill_hole_preference_t;
typedef int PK_blend_set_tol_t;
typedef int PK_hole_blended_t;
typedef int PK_taper_corner_type_t;
typedef int PK_VERTEX_optimise_result_t;
typedef int PK_VERTEX_max_dev_t;
typedef int PK_taper_smooth_step_t;
typedef int PK_hole_update_t;
typedef int PK_TOPOL_fctab_t;
typedef int PK_facet_split_strip_t;
typedef int PK_facet_consistent_parms_t;
typedef int PK_BODY_loft_update_t;
typedef int PK_taper_miter_type_t;
typedef int PK_BODY_sweep_scale_type_t;
typedef int PK_facet_vx_data_type_t;
typedef int PK_facet_incr_t;
typedef int PK_facet_incr_refine_t;
typedef int PK_facet_incr_report_t;
typedef int PK_hole_const_rad_t;
typedef int PK_hole_ortho_t;
typedef int PK_fill_hole_update_t;
typedef int PK_FACE_change_bend_type_t;
typedef int PK_bend_merge_t;
typedef int PK_EDGE_offset_blend_t;
typedef int PK_replace_adjust_t;
typedef int PK_replace_use_t;
typedef int PK_hole_comp_t;
typedef int PK_detail_type_t;
typedef int PK_blend_repair_su_X_t;
typedef int PK_blend_output_sheet_t;
typedef int PK_local_ops_update_t;
typedef PK_local_ops_update_t PK_replace_update_t;
typedef int PK_fill_hole_topol_t;
typedef int PK_extension_shape_t;
typedef int PK_BODY_extension_t;
typedef int PK_BODY_loft_deriv_mag_t;
typedef int PK_imprint_complete_t;
typedef int PK_imprint_extend_t;
typedef int PK_facet_inflect_t;
typedef int PK_imprint_connect_t;
typedef int PK_range_type_t;
typedef int PK_boolean_material_t;
typedef int PK_DEBUG_roll_direction_t;
typedef int PK_blend_rho_t;
typedef int PK_taper_undercut_t;
typedef int PK_EDGE_optimise_result_t;
typedef int PK_EDGE_max_dev_t;
typedef int PK_extension_smoothness_t;
typedef int PK_boolean_prefer_t;
typedef int PK_emboss_sidewall_t;
typedef int PK_emboss_profile_on_t;
typedef int PK_emboss_convexity_t;
typedef int PK_bound_side_t;
typedef int PK_blend_inside_tight_t;
typedef int PK_imprint_face_hidden_t;
typedef int PK_taper_concave_type_t;
typedef int PK_BODY_smoothness_t;
typedef int PK_ATTDEF_cb_on_t;
typedef int PK_taper_step_face_t;
typedef int PK_facet_quality_t;
typedef int PK_emboss_overflow_t;
typedef int PK_BCURVE_extend_status_t;
typedef int PK_BCURVE_extension_t;
typedef int PK_BCURVE_spline_t;
typedef int PK_BCURVE_overdefined_t;
typedef int PK_blend_order_t;
typedef int PK_blend_setback_shape_t;
typedef int PK_DEBUG_output_session_t;
typedef int PK_continuity_t;
typedef int PK_boolean_no_effect_t;
typedef int PK_taper_laminar_edge_t;
typedef int PK_offset_on_body_t;
typedef int PK_CURVE_general_type_t;
typedef int PK_BCURVE_fitted_t;
typedef int PK_SURF_general_type_t;
typedef int PK_BSURF_fitted_t;
typedef int PK_sweep_guide_method_t;
typedef int PK_sweep_guide_clamp_type_t;
typedef int PK_replace_variation_t;
typedef int PK_sweep_guide_scale_t;
typedef int PK_sweep_clamp_type_t;
typedef int PK_PARTITION_copy_deltas_t;
typedef PK_local_ops_update_t PK_thicken_update_t;
typedef int PK_imprint_tracking_t;
typedef int PK_blend_repair_fa_X_t;
typedef int PK_replace_patch_t;
typedef int PK_facet_sing_topol_t;
typedef int PK_detail_perforated_t;
typedef int PK_detail_open_t;
typedef int PK_boolean_match_update_t;
typedef int PK_sweep_tool_fault_t;
typedef int PK_imprint_proj_dist_t;
typedef int PK_ATTDEF_mismatch_t;
typedef int PK_extend_closed_t;
typedef int PK_CURVE_sequential_t;
typedef int PK_nm_edge_repair_t;
typedef int PK_SESSION_binding_t;
typedef int PK_blend_ov_exp_cliff_t;
typedef int PK_PARTITION_type_t;
typedef int PK_taper_keep_material_t;
typedef int PK_emboss_unite_sidewall_t;
typedef int PK_boolean_track_type_t;
typedef int PK_set_precision_method_t;
typedef int PK_PMARK_new_at_mark_t;
typedef int PK_extend_track_type_t;
typedef int PK_extend_track_internal_t;
typedef int PK_EDGE_convexity_t;
typedef int PK_sweep_lock_t;
typedef int PK_force_continuity_t;
typedef int PK_SURF_make_bsurf_t;
typedef int PK_achieved_cont_t;
typedef int PK_make_spcurves_method_t;
typedef int PK_check_nmnl_geom_t;
typedef int PK_check_returns_t;
typedef int PK_make_spcurves_degen_t;
typedef int PK_LOOP_3_space_gap_t;
typedef int PK_LOOP_2_space_gap_t;
typedef int PK_sweep_output_xsect_t;
typedef int PK_sweep_group_xsect_t;
typedef PK_local_ops_update_t PK_FACE_change_update_t;
typedef int PK_set_precision_report_t;
typedef int PK_FACE_overflow_t;
typedef int PK_render_ske_missing_t;
typedef int PK_range_opt_t;
typedef int PK_general_t;
typedef int PK_self_int_type_t;
typedef int PK_blend_prevent_sharp_t;
typedef int PK_extension_limit_t;
typedef int PK_GEOM_transform_t;
typedef int PK_hollow_local_t;
typedef int PK_FACE_prefer_adj_t;
typedef int PK_REPORT_record_type_t;
typedef int PK_REPORT_1_t;
typedef int PK_sweep_repair_t;
typedef int PK_track_edges_t;
typedef int PK_track_vertices_t;
typedef int PK_BSURF_constrained_t;
typedef int PK_BCURVE_clamp_t;
typedef int PK_fix_method_t;
typedef int PK_SURF_fix_fault_t;
typedef int PK_CURVE_fix_fault_t;
typedef int PK_SURF_split_t;
typedef int PK_fix_status_t;
typedef int PK_DEBUG_try_smp_t;
typedef int PK_transform_step_t;
typedef int PK_blend_track_edges_t;
typedef int PK_blend_delete_cap_t;
typedef int PK_facet_smp_t;
typedef int PK_FACE_grow_t;
typedef int PK_blend_tolerance_t;
typedef int PK_offset_track_del_t;
typedef int PK_extend_create_t;
typedef int PK_blend_follow_branch_t;
typedef int PK_BCURVE_spline_stat_t;
typedef int PK_spline_method_t;
typedef int PK_BODY_sewing_assy_t;
typedef int PK_LOOP_trim_geom_t;
typedef int PK_blend_track_type_t;
typedef int PK_ENTITY_track_t;
typedef int PK_BODY_sewing_gen_t;
typedef int PK_blend_delete_keep_t;
typedef int PK_REPORT_2_t;
typedef int PK_extension_boundary_t;
typedef int PK_VERTEX_limit_t;
typedef int PK_FACE_grow_cb_t;
typedef int PK_spline_update_t;
typedef int PK_sweep_profile_law_t;
typedef int PK_EDGE_limit_t;
typedef int PK_TOPOL_dimension_t;
typedef int PK_redundant_merge_t;
typedef int PK_repair_fa_fa_t;
typedef int PK_neutral_ignore_fa_t;
typedef int PK_blend_trim_extent_t;
typedef int PK_redundant_propagate_t;
typedef int PK_REPORT_3_t;
typedef int PK_FACE_trim_cb_t;
typedef int PK_patch_mobility_t;
typedef int PK_deform_uv_t;
typedef int PK_BODY_sweep_update_t;
typedef int PK_instance_repair_fa_fa_t;
typedef int PK_instance_track_type_t;
typedef int PK_instance_merge_t;
typedef int PK_DEBUG_report_cb_t;
typedef int PK_neutral_trim_method_t;
typedef int PK_fill_hole_body_type_t;
typedef int PK_instance_track_edges_t;
typedef int PK_outline_update_t;
typedef int PK_neutral_overlap_t;
typedef int PK_isoparam_prefer_t;
typedef int PK_THREAD_exclusion_t;
typedef int PK_facet_pt_report_t;
typedef int PK_imprint_intersect_t;
typedef int PK_SHELL_repair_tracking_t;
typedef int PK_SHELL_repair_stat_t;
typedef int PK_SURF_degen_type_t;
typedef int PK_check_extra_faults_t;
typedef int PK_extend_side_t;
typedef int PK_blend_laminar_trim_t;
typedef int PK_blend_run_out_t;
typedef int PK_check_vx_on_cu_t;
typedef int PK_GEOM_copy_t;
typedef int PK_GROUP_split_empty_t;
typedef int PK_GROUP_merge_empty_t;
typedef int PK_SURF_extend_update_t;
typedef int PK_change_track_edges_t;
typedef int PK_imprint_dir_t;
typedef int PK_blend_suggest_limit_t;
typedef int PK_fix_degens_t;
typedef int PK_constrained_update_t;
typedef int PK_constrained_opt_t;
typedef int PK_measure_t;
typedef int PK_CURVE_find_vectors_t;
typedef int PK_CURVE_make_bcurve_t;
typedef int PK_fill_hole_patch_eds_t;
typedef int PK_THREAD_chain_type_t;
typedef int PK_blend_limit_type_t;
typedef int PK_boolean_update_t;
typedef int PK_ERROR_on_fail_t;
typedef int PK_fill_hole_opt_t;
typedef int PK_make_bsurf_update_t;
typedef int PK_fill_hole_imprint_t;
typedef int PK_range_param_entity_t;
typedef int PK_results_output_t;
typedef int PK_CURVE_degen_type_t;
typedef int PK_neutral_method_t;
typedef int PK_blend_report_repaired_t;
typedef int PK_blend_limit_patch_t;
typedef int PK_EDGE_attach_update_t;
typedef int PK_FACE_cover_output_t;
typedef int PK_FACE_cover_smooth_t;
typedef int PK_mass_local_density_t;
typedef int PK_reset_prec_method_t;
typedef int PK_receive_compound_t;
typedef int PK_fill_hole_clamp_t;
typedef int PK_selector_split_t;
typedef int PK_proj_connect_t;
typedef int PK_proj_face_hidden_t;
typedef int PK_proj_max_dist_t;
typedef int PK_proj_split_clash_t;
typedef int PK_proj_to_points_t;
typedef int PK_ref_alignment_t;
typedef int PK_BODY_config_t;
typedef int PK_selector_type_t;
typedef int PK_compound_geom_attr_t;
typedef int PK_check_attribs_t;
typedef int PK_EDGE_curve_dir_t;
typedef int PK_GEOM_soft_extended_t;
typedef int PK_chain_optimise_t;
typedef int PK_swept_tool_update_t;
typedef int PK_matrix_type_t;
typedef int PK_TRANSF_diagnostics_t;
typedef int PK_blend_cap_type_t;
typedef int PK_CURVE_is_isoparam_t;
typedef int PK_isoparam_alignment_t;
typedef int PK_proj_complete_t;
typedef int PK_proj_nominal_t;
typedef int PK_proj_function_t;
typedef int PK_proj_update_t;
typedef int PK_imprint_precision_t;
typedef int PK_neutral_face_overlap_t;
typedef int PK_facet_respect_t;
typedef int PK_FUNCTION_run_t;
typedef int PK_track_bodies_t;
typedef int PK_outline_edge_on_t;
typedef int PK_fill_hole_non_smooth_t;
typedef int PK_blend_params_t;
typedef int PK_blend_report_blends_t;
typedef int PK_blend_distant_unders_t;
typedef int PK_repair_fa_t;
typedef int PK_LOOP_sew_up_t;
typedef int PK_shadow_check_fa_t;
typedef int PK_proj_tracking_t;
typedef int PK_render_report_line_t;
typedef int PK_blend_use_master_faces_t;
typedef int PK_FACE_cover_update_t;
typedef int PK_make_bcurve_update_t;


struct PK_EDGE_types_s {
 PK_EDGE_vertex_type_t vertex_type;
 PK_enclosure_t enclosure;
 PK_EDGE_fins_type_t fins_type;
};
typedef struct PK_EDGE_types_s PK_EDGE_ask_type_t;
typedef int PK_CLASS_t;
typedef int PK_MARK_t;
typedef int PK_PMARK_t;
typedef int PK_SESSION_t;
typedef int PK_ERROR_t;
typedef int PK_PRIMITIVE_t;
typedef int PK_MEMORY_t;
typedef int PK_PARTITION_t;
typedef int PK_BB_t;
typedef int PK_APPITEM_t;
typedef int PK_ERROR_code_t;
typedef int PK_ERROR_severity_t;
typedef unsigned PK_DELTA_t;
typedef int PK_ASSEMBLY_t;
typedef int PK_ATTDEF_t;
typedef int PK_ATTRIB_t;
typedef int PK_BODY_t;
typedef int PK_BCURVE_t;
typedef int PK_BLENDSF_t;
typedef int PK_BSURF_t;
typedef int PK_CIRCLE_t;
typedef int PK_CONE_t;
typedef int PK_CPCURVE_t;
typedef int PK_CYL_t;
typedef int PK_EDGE_t;
typedef int PK_ELLIPSE_t;
typedef int PK_FACE_t;
typedef int PK_FCURVE_t;
typedef int PK_FIN_t;
typedef int PK_FSURF_t;
typedef int PK_GROUP_t;
typedef int PK_ICURVE_t;
typedef int PK_INSTANCE_t;
typedef int PK_KI_LIST_t;
typedef int PK_LINE_t;
typedef int PK_LOOP_t;
typedef int PK_OFFSET_t;
typedef int PK_POINT_t;
typedef int PK_PLANE_t;
typedef int PK_REGION_t;
typedef int PK_SHELL_t;
typedef int PK_SPCURVE_t;
typedef int PK_SPHERE_t;
typedef int PK_SPUN_t;
typedef int PK_SWEPT_t;
typedef int PK_TORUS_t;
typedef int PK_TRANSF_t;
typedef int PK_TRCURVE_t;
typedef int PK_VERTEX_t;
typedef int PK_CURVE_t;
typedef int PK_ENTITY_t;
typedef int PK_GEOM_t;
typedef int PK_PART_t;
typedef int PK_SURF_t;
typedef int PK_TOPOL_t;
typedef struct PK_ASSEMBLY_array_s {
 PK_ASSEMBLY_t *array;
 int length;
} PK_ASSEMBLY_array_t;
typedef struct PK_ATTDEF_array_s {
 PK_ATTDEF_t *array;
 int length;
} PK_ATTDEF_array_t;
typedef struct PK_ATTRIB_array_s {
 PK_ATTRIB_t *array;
 int length;
} PK_ATTRIB_array_t;
typedef struct PK_BODY_array_s {
 PK_BODY_t *array;
 int length;
} PK_BODY_array_t;
typedef struct PK_BCURVE_array_s {
 PK_BCURVE_t *array;
 int length;
} PK_BCURVE_array_t;
typedef struct PK_BLENDSF_array_s {
 PK_BLENDSF_t *array;
 int length;
} PK_BLENDSF_array_t;
typedef struct PK_BSURF_array_s {
 PK_BSURF_t *array;
 int length;
} PK_BSURF_array_t;
typedef struct PK_CIRCLE_array_s {
 PK_CIRCLE_t *array;
 int length;
} PK_CIRCLE_array_t;
typedef struct PK_CONE_array_s {
 PK_CONE_t *array;
 int length;
} PK_CONE_array_t;
typedef struct PK_CPCURVE_array_s {
 PK_CPCURVE_t *array;
 int length;
} PK_CPCURVE_array_t;
typedef struct PK_CYL_array_s {
 PK_CYL_t *array;
 int length;
} PK_CYL_array_t;
typedef struct PK_EDGE_array_s {
 PK_EDGE_t *array;
 int length;
} PK_EDGE_array_t;
typedef struct PK_ELLIPSE_array_s {
 PK_ELLIPSE_t *array;
 int length;
} PK_ELLIPSE_array_t;
typedef struct PK_FACE_array_s {
 PK_FACE_t *array;
 int length;
} PK_FACE_array_t;
typedef struct PK_FCURVE_array_s {
 PK_FCURVE_t *array;
 int length;
} PK_FCURVE_array_t;
typedef struct PK_FIN_array_s {
 PK_FIN_t *array;
 int length;
} PK_FIN_array_t;
typedef struct PK_FSURF_array_s {
 PK_FSURF_t *array;
 int length;
} PK_FSURF_array_t;
typedef struct PK_GROUP_array_s {
 PK_GROUP_t *array;
 int length;
} PK_GROUP_array_t;
typedef struct PK_ICURVE_array_s {
 PK_ICURVE_t *array;
 int length;
} PK_ICURVE_array_t;
typedef struct PK_INSTANCE_array_s {
 PK_INSTANCE_t *array;
 int length;
} PK_INSTANCE_array_t;
typedef struct PK_KI_LIST_array_s {
 PK_KI_LIST_t *array;
 int length;
} PK_KI_LIST_array_t;
typedef struct PK_LINE_array_s {
 PK_LINE_t *array;
 int length;
} PK_LINE_array_t;
typedef struct PK_LOOP_array_s {
 PK_LOOP_t *array;
 int length;
} PK_LOOP_array_t;
typedef struct PK_OFFSET_array_s {
 PK_OFFSET_t *array;
 int length;
} PK_OFFSET_array_t;
typedef struct PK_POINT_array_s {
 PK_POINT_t *array;
 int length;
} PK_POINT_array_t;
typedef struct PK_PLANE_array_s {
 PK_PLANE_t *array;
 int length;
} PK_PLANE_array_t;
typedef struct PK_REGION_array_s {
 PK_REGION_t *array;
 int length;
} PK_REGION_array_t;
typedef struct PK_SHELL_array_s {
 PK_SHELL_t *array;
 int length;
} PK_SHELL_array_t;
typedef struct PK_SPCURVE_array_s {
 PK_SPCURVE_t *array;
 int length;
} PK_SPCURVE_array_t;
typedef struct PK_SPHERE_array_s {
 PK_SPHERE_t *array;
 int length;
} PK_SPHERE_array_t;
typedef struct PK_SPUN_array_s {
 PK_SPUN_t *array;
 int length;
} PK_SPUN_array_t;
typedef struct PK_SWEPT_array_s {
 PK_SWEPT_t *array;
 int length;
} PK_SWEPT_array_t;
typedef struct PK_TORUS_array_s {
 PK_TORUS_t *array;
 int length;
} PK_TORUS_array_t;
typedef struct PK_TRANSF_array_s {
 PK_TRANSF_t *array;
 int length;
} PK_TRANSF_array_t;
typedef struct PK_TRCURVE_array_s {
 PK_TRCURVE_t *array;
 int length;
} PK_TRCURVE_array_t;
typedef struct PK_VERTEX_array_s {
 PK_VERTEX_t *array;
 int length;
} PK_VERTEX_array_t;
typedef struct PK_CURVE_array_s {
 PK_CURVE_t *array;
 int length;
} PK_CURVE_array_t;
typedef struct PK_ENTITY_array_s {
 PK_ENTITY_t *array;
 int length;
} PK_ENTITY_array_t;
typedef struct PK_GEOM_array_s {
 PK_GEOM_t *array;
 int length;
} PK_GEOM_array_t;
typedef struct PK_PART_array_s {
 PK_PART_t *array;
 int length;
} PK_PART_array_t;
typedef struct PK_SURF_array_s {
 PK_SURF_t *array;
 int length;
} PK_SURF_array_t;
typedef struct PK_TOPOL_array_s {
 PK_TOPOL_t *array;
 int length;
} PK_TOPOL_array_t;
typedef struct PK_CLASS_array_s {
 PK_CLASS_t *array;
 int length;
} PK_CLASS_array_t;
typedef struct PK_PMARK_array_s {
 PK_PMARK_t *array;
 int length;
} PK_PMARK_array_t;
typedef int PK_ITEM_t;
typedef struct PK_ITEM_array_s {
 PK_ITEM_t *array;
 int length;
} PK_ITEM_array_t;
typedef unsigned char PK_LOGICAL_t;


struct PK_VECTOR_s {
 double coord[3];
};
typedef struct PK_VECTOR_s PK_VECTOR_t;
typedef struct PK_VECTOR_s PK_VECTOR1_t;


struct PK_INTERVAL_s {
 double value[2];
};
typedef struct PK_INTERVAL_s PK_INTERVAL_t;


struct PK_BOX_s {
 double coord[6];
};
typedef struct PK_BOX_s PK_BOX_t;


struct PK_UVBOX_s {
 double param[4];
};
typedef struct PK_UVBOX_s PK_UVBOX_t;


struct PK_UV_s {
 double param[2];
};
typedef struct PK_UV_s PK_UV_t;
typedef void *PK_POINTER_t;
typedef unsigned short PK_UCHAR_t;
typedef struct PK_int_array_s {
 int *array;
 int length;
} PK_int_array_t;


struct PK_double_array_s {
 double *array;
 int length;
};
typedef struct PK_double_array_s PK_double_array_t;
typedef int PK_REPORT_t;
typedef int PK_FUNCTION_t;


struct PK_AXIS1_sf_s {
 PK_VECTOR_t location;
 PK_VECTOR1_t axis;
};
typedef struct PK_AXIS1_sf_s PK_AXIS1_sf_t;


struct PK_AXIS2_sf_s {
 PK_VECTOR_t location;
 PK_VECTOR1_t axis;
 PK_VECTOR1_t ref_direction;
};
typedef struct PK_AXIS2_sf_s PK_AXIS2_sf_t;


struct PK_NABOX_sf_s {
 PK_AXIS2_sf_t basis_set;
 PK_BOX_t box;
};
typedef struct PK_NABOX_sf_s PK_NABOX_sf_t;


struct PK_ERROR_sf {
 char function[32];
 PK_ERROR_code_t code;
 char code_token[32];
 PK_ERROR_severity_t severity;
 int argument_number;
 char argument_name[32];
 int argument_index;
 PK_ENTITY_t entity;
};
typedef struct PK_ERROR_sf PK_ERROR_sf_t;


struct PK_PARAM_sf_s {
 PK_INTERVAL_t range;
 PK_PARAM_bound_t bound[2];
 PK_PARAM_periodic_t periodic;
 PK_PARAM_form_t form;
 PK_LOGICAL_t continuous;
};
typedef struct PK_PARAM_sf_s PK_PARAM_sf_t;


struct PK_LAW_sf_s {
 int degree;
 int n_vertices;
 int vertex_dim;
 PK_LOGICAL_t is_rational;
 double *vertex;
 int n_knots;
 int *knot_mult;
 double *knot;
 PK_knot_type_t knot_type;
 PK_LOGICAL_t is_periodic;
 PK_LOGICAL_t is_closed;
};
typedef struct PK_LAW_sf_s PK_LAW_sf_t;


struct PK_TRANSF_sf_s {
 double matrix[4][4];
};
typedef struct PK_TRANSF_sf_s PK_TRANSF_sf_t;


struct PK_REPORT_record_1_s {
 PK_REPORT_1_t status;
 int n_old_items;
 int *old_items;
 PK_CLASS_t *old_classes;
 int n_new_items;
 PK_ITEM_t *new_items;
};
typedef struct PK_REPORT_record_1_s PK_REPORT_record_1_t;


struct PK_REPORT_record_2_s {
 PK_REPORT_2_t status;
 int n_old_item_arrays;
 PK_int_array_t *old_item_arrays;
 PK_CLASS_array_t *old_class_arrays;
 int n_new_item_arrays;
 PK_ITEM_array_t *new_item_arrays;
};
typedef struct PK_REPORT_record_2_s PK_REPORT_record_2_t;


struct PK_REPORT_record_3_s {
 PK_REPORT_3_t status;
 int n_int_arrays;
 PK_int_array_t *int_arrays;
 int n_double_arrays;
 PK_double_array_t *double_arrays;
 int n_strings;
 char **strings;
 int n_old_item_arrays;
 PK_int_array_t *old_item_arrays;
 PK_CLASS_array_t *old_class_arrays;
 int n_item_arrays;
 PK_ITEM_array_t *item_arrays;
};
typedef struct PK_REPORT_record_3_s PK_REPORT_record_3_t;


struct PK_REPORT_record_s {
 char function[32];
 PK_REPORT_record_type_t type;
 union {
  PK_REPORT_record_1_t *type_1;
  PK_REPORT_record_2_t *type_2;
  PK_REPORT_record_3_t *type_3;
 } record;
};
typedef struct PK_REPORT_record_s PK_REPORT_record_t;


struct PK_REPORT_r_s {
 char function[32];
 int n_report_records;
 PK_REPORT_record_t *report_records;
};
typedef struct PK_REPORT_r_s PK_REPORT_r_t;


struct PK_MEMORY_block_s {
 struct PK_MEMORY_block_s *next;
 size_t n_bytes;
 const char *bytes;
};
typedef struct PK_MEMORY_block_s PK_MEMORY_block_t;
typedef PK_ERROR_code_t(*PK_ERROR_handler_f_t)(struct PK_ERROR_sf *);


struct PK_ERROR_frustrum_s {
 PK_ERROR_handler_f_t handler_fn;
};
typedef struct PK_ERROR_frustrum_s PK_ERROR_frustrum_t;
typedef void(*PK_FSTART_f_t)(int *);
typedef void(*PK_FABORT_f_t)(int *);
typedef void(*PK_FSTOP_f_t)(int *);
typedef void(*PK_FMALLO_f_t)(int *, char **, int *);
typedef void(*PK_FMFREE_f_t)(int *, char **, int *);
typedef void(*PK_GOSGMT_f_t)(const int *, const int *, const int *, const int *, 
const double *, const int *, const int *, int *);
typedef void(*PK_GOOPSG_f_t)(const int *, const int *, const int *, const int *, 
const double *, const int *, const int *, int *);
typedef void(*PK_GOCLSG_f_t)(const int *, const int *, const int *, const int *, 
const double *, const int *, const int *, int *);
typedef void(*PK_GOPIXL_f_t)(const int *, const double *, const int *, const int *, 
int *);
typedef void(*PK_GOOPPX_f_t)(const int *, const double *, const int *, const int *, 
int *);
typedef void(*PK_GOCLPX_f_t)(const int *, const double *, const int *, const int *, 
int *);
typedef void(*PK_FFOPRD_f_t)(const int *, const int *, const char *, const int *, 
const int *, int *, int *);
typedef void(*PK_FFOPWR_f_t)(const int *, const int *, const char *, const int *, 
const char *, const int *, int *, int *);
typedef int(*PK_UCOPRD_f_t)(const int, const int, const PK_UCHAR_t *, const PK_LOGICAL_t
, int *);
typedef int(*PK_UCOPWR_f_t)(const int, const int, const PK_UCHAR_t *, const char *, int 
*);
typedef void(*PK_FFCLOS_f_t)(const int *, const int *, const int *, int *);
typedef void(*PK_FFREAD_f_t)(const int *, const int *, const int *, char *, int *, 
int *);
typedef void(*PK_FFWRIT_f_t)(const int *, const int *, const int *, const char *, 
int *);
typedef void(*PK_FFOPRB_f_t)(const int *, const int *, const int *, int *, int *, 
int *);
typedef void(*PK_FFSEEK_f_t)(const int *, const int *, const int *, int *);
typedef void(*PK_FFTELL_f_t)(const int *, const int *, int *, int *);
typedef void(*PK_FGCRCU_f_t)(const char *, int *, int *, int *, int *, double *, int
*, double *, int *);
typedef void(*PK_FGCRSU_f_t)(const char *, int *, int *, int *, int *, double *, int
*, double *, int *);
typedef void(*PK_FGEVCU_f_t)(int *, double *, double *, double *, int *, double *, 
int *);
typedef void(*PK_FGEVSU_f_t)(int *, double *, double *, double *, double *, int *, 
int *, int *, double *, int *);
typedef void(*PK_FGPRCU_f_t)(int *, double *, double *, double[2], int *, int *);
typedef void(*PK_FGPRSU_f_t)(int *, double *, double *, double[4], int[2], int *);
typedef struct PK_SESSION_frustrum_s {
 PK_FSTART_f_t fstart;
 PK_FABORT_f_t fabort;
 PK_FSTOP_f_t fstop;
 PK_FMALLO_f_t fmallo;
 PK_FMFREE_f_t fmfree;
 PK_GOSGMT_f_t gosgmt;
 PK_GOOPSG_f_t goopsg;
 PK_GOCLSG_f_t goclsg;
 PK_GOPIXL_f_t gopixl;
 PK_GOOPPX_f_t gooppx;
 PK_GOCLPX_f_t goclpx;
 PK_FFOPRD_f_t ffoprd;
 PK_FFOPWR_f_t ffopwr;
 PK_FFCLOS_f_t ffclos;
 PK_FFREAD_f_t ffread;
 PK_FFWRIT_f_t ffwrit;
 PK_FFOPRB_f_t ffoprb;
 PK_FFSEEK_f_t ffseek;
 PK_FFTELL_f_t fftell;
 PK_FGCRCU_f_t fgcrcu;
 PK_FGCRSU_f_t fgcrsu;
 PK_FGEVCU_f_t fgevcu;
 PK_FGEVSU_f_t fgevsu;
 PK_FGPRCU_f_t fgprcu;
 PK_FGPRSU_f_t fgprsu;
 PK_UCOPRD_f_t ucoprd;
 PK_UCOPWR_f_t ucopwr;
} PK_SESSION_frustrum_t;
typedef unsigned char PK_imprint_face_list_t;
typedef unsigned char PK_FACE_heal_loops_t;


struct PK_TOPOL_fcstr_facet_fin_s {
 int facet;
 int fin;
};
typedef struct PK_TOPOL_fcstr_facet_fin_s PK_TOPOL_fcstr_facet_fin_t;


struct PK_TOPOL_fctab_facet_fin_s {
 PK_TOPOL_fcstr_facet_fin_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_facet_fin_s PK_TOPOL_fctab_facet_fin_t;


struct PK_TOPOL_fcstr_strip_boundary_s {
 int strip;
 int fin;
};
typedef struct PK_TOPOL_fcstr_strip_boundary_s PK_TOPOL_fcstr_strip_boundary_t;


struct PK_TOPOL_fctab_strip_boundary_s {
 PK_TOPOL_fcstr_strip_boundary_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_strip_boundary_s PK_TOPOL_fctab_strip_boundary_t;


struct PK_TOPOL_fcstr_strip_zigzag_s {
 int strip;
 int fin;
};
typedef struct PK_TOPOL_fcstr_strip_zigzag_s PK_TOPOL_fcstr_strip_zigzag_t;


struct PK_TOPOL_fctab_strip_zigzag_s {
 PK_TOPOL_fcstr_strip_zigzag_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_strip_zigzag_s PK_TOPOL_fctab_strip_zigzag_t;


struct PK_TOPOL_fctab_fin_fin_s {
 int *fin;
 int length;
};
typedef struct PK_TOPOL_fctab_fin_fin_s PK_TOPOL_fctab_fin_fin_t;


struct PK_TOPOL_fctab_fin_vertex_s {
 int *vertex;
 int length;
};
typedef struct PK_TOPOL_fctab_fin_vertex_s PK_TOPOL_fctab_fin_vertex_t;


struct PK_TOPOL_fctab_fin_data_s {
 int *data;
 int length;
};
typedef struct PK_TOPOL_fctab_fin_data_s PK_TOPOL_fctab_fin_data_t;


struct PK_TOPOL_fctab_data_point_s {
 int *point;
 int length;
};
typedef struct PK_TOPOL_fctab_data_point_s PK_TOPOL_fctab_data_point_t;


struct PK_TOPOL_fctab_data_normal_s {
 int *normal;
 int length;
};
typedef struct PK_TOPOL_fctab_data_normal_s PK_TOPOL_fctab_data_normal_t;


struct PK_TOPOL_fctab_data_param_s {
 int *param;
 int length;
};
typedef struct PK_TOPOL_fctab_data_param_s PK_TOPOL_fctab_data_param_t;


struct PK_TOPOL_fctab_data_deriv_s {
 int *deriv;
 int length;
};
typedef struct PK_TOPOL_fctab_data_deriv_s PK_TOPOL_fctab_data_deriv_t;


struct PK_TOPOL_fctab_vertex_point_s {
 int *point;
 int length;
};
typedef struct PK_TOPOL_fctab_vertex_point_s PK_TOPOL_fctab_vertex_point_t;


struct PK_TOPOL_fctab_vertex_normal_s {
 int *normal;
 int length;
};
typedef struct PK_TOPOL_fctab_vertex_normal_s PK_TOPOL_fctab_vertex_normal_t;


struct PK_TOPOL_fctab_vertex_param_s {
 int *param;
 int length;
};
typedef struct PK_TOPOL_fctab_vertex_param_s PK_TOPOL_fctab_vertex_param_t;


struct PK_TOPOL_fctab_point_vec_s {
 PK_VECTOR_t *vec;
 int length;
};
typedef struct PK_TOPOL_fctab_point_vec_s PK_TOPOL_fctab_point_vec_t;


struct PK_TOPOL_fctab_normal_vec_s {
 PK_VECTOR_t *vec;
 int length;
};
typedef struct PK_TOPOL_fctab_normal_vec_s PK_TOPOL_fctab_normal_vec_t;


struct PK_TOPOL_fcstr_param_uv_s {
 double u;
 double v;
};
typedef struct PK_TOPOL_fcstr_param_uv_s PK_TOPOL_fcstr_param_uv_t;


struct PK_TOPOL_fctab_param_uv_s {
 PK_TOPOL_fcstr_param_uv_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_param_uv_s PK_TOPOL_fctab_param_uv_t;


struct PK_TOPOL_fcstr_param_dp_s {
 PK_VECTOR_t du;
 PK_VECTOR_t dv;
};
typedef struct PK_TOPOL_fcstr_param_dp_s PK_TOPOL_fcstr_param_dp_t;


struct PK_TOPOL_fctab_param_dp_s {
 PK_TOPOL_fcstr_param_dp_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_param_dp_s PK_TOPOL_fctab_param_dp_t;


struct PK_TOPOL_fcstr_deriv_dp_s {
 PK_VECTOR_t du;
 PK_VECTOR_t dv;
};
typedef struct PK_TOPOL_fcstr_deriv_dp_s PK_TOPOL_fcstr_deriv_dp_t;


struct PK_TOPOL_fctab_deriv_dp_s {
 PK_TOPOL_fcstr_deriv_dp_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_deriv_dp_s PK_TOPOL_fctab_deriv_dp_t;


struct PK_TOPOL_fcstr_param_d2p_s {
 PK_VECTOR_t du2;
 PK_VECTOR_t dudv;
 PK_VECTOR_t dv2;
};
typedef struct PK_TOPOL_fcstr_param_d2p_s PK_TOPOL_fcstr_param_d2p_t;


struct PK_TOPOL_fctab_param_d2p_s {
 PK_TOPOL_fcstr_param_d2p_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_param_d2p_s PK_TOPOL_fctab_param_d2p_t;


struct PK_TOPOL_fcstr_deriv_d2p_s {
 PK_VECTOR_t du2;
 PK_VECTOR_t dudv;
 PK_VECTOR_t dv2;
};
typedef struct PK_TOPOL_fcstr_deriv_d2p_s PK_TOPOL_fcstr_deriv_d2p_t;


struct PK_TOPOL_fctab_deriv_d2p_s {
 PK_TOPOL_fcstr_deriv_d2p_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_deriv_d2p_s PK_TOPOL_fctab_deriv_d2p_t;


struct PK_TOPOL_fctab_facet_face_s {
 PK_FACE_t *face;
 int length;
};
typedef struct PK_TOPOL_fctab_facet_face_s PK_TOPOL_fctab_facet_face_t;


struct PK_TOPOL_fctab_strip_face_s {
 PK_FACE_t *face;
 int length;
};
typedef struct PK_TOPOL_fctab_strip_face_s PK_TOPOL_fctab_strip_face_t;


struct PK_TOPOL_fctab_facet_occ_s {
 int *occ;
 int length;
};
typedef struct PK_TOPOL_fctab_facet_occ_s PK_TOPOL_fctab_facet_occ_t;


struct PK_TOPOL_fcstr_edge_fin_s {
 PK_EDGE_t edge;
 int fin;
};
typedef struct PK_TOPOL_fcstr_edge_fin_s PK_TOPOL_fcstr_edge_fin_t;


struct PK_TOPOL_fctab_edge_fin_s {
 PK_TOPOL_fcstr_edge_fin_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_edge_fin_s PK_TOPOL_fctab_edge_fin_t;


struct PK_TOPOL_fcstr_fin_edge_s {
 int fin;
 PK_EDGE_t edge;
};
typedef struct PK_TOPOL_fcstr_fin_edge_s PK_TOPOL_fcstr_fin_edge_t;


struct PK_TOPOL_fctab_fin_edge_s {
 PK_TOPOL_fcstr_fin_edge_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_fin_edge_s PK_TOPOL_fctab_fin_edge_t;


struct PK_TOPOL_fcstr_edge_occ_s {
 int edge;
 int occ;
};
typedef struct PK_TOPOL_fcstr_edge_occ_s PK_TOPOL_fcstr_edge_occ_t;


struct PK_TOPOL_fctab_edge_occ_s {
 PK_TOPOL_fcstr_edge_occ_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_edge_occ_s PK_TOPOL_fctab_edge_occ_t;


struct PK_TOPOL_fctab_error_facet_s {
 int *facet;
 int length;
};
typedef struct PK_TOPOL_fctab_error_facet_s PK_TOPOL_fctab_error_facet_t;


struct PK_TOPOL_fcstr_error_object_s {
 PK_facet_fault_t error;
 int object;
};
typedef struct PK_TOPOL_fcstr_error_object_s PK_TOPOL_fcstr_error_object_t;


struct PK_TOPOL_fctab_error_object_s {
 PK_TOPOL_fcstr_error_object_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_error_object_s PK_TOPOL_fctab_error_object_t;


struct PK_TOPOL_facet_r_s {
 int number_of_facets;
 int number_of_fins;
 int number_of_vertices;
 PK_TOPOL_fctab_facet_fin_t facet_fin;
 PK_TOPOL_fctab_fin_fin_t fin_fin;
 PK_TOPOL_fctab_fin_vertex_t fin_vertex;
 PK_TOPOL_fctab_vertex_point_t vertex_point;
 PK_TOPOL_fctab_vertex_normal_t vertex_normal;
 PK_TOPOL_fctab_vertex_param_t vertex_param;
 PK_TOPOL_fctab_point_vec_t point_vec;
 PK_TOPOL_fctab_normal_vec_t normal_vec;
 PK_TOPOL_fctab_param_uv_t param_uv;
 PK_TOPOL_fctab_param_dp_t param_dp;
 PK_TOPOL_fctab_param_d2p_t param_d2p;
 PK_TOPOL_fctab_facet_face_t facet_face;
 PK_TOPOL_fctab_facet_occ_t facet_occ;
 PK_TOPOL_fctab_edge_fin_t edge_fin;
 PK_TOPOL_fctab_edge_occ_t edge_occ;
 PK_TOPOL_fctab_error_facet_t error_facet;
};
typedef struct PK_TOPOL_facet_r_s PK_TOPOL_facet_r_t;


struct PK_TOPOL_fcstr_point_topol_s {
 int point;
 PK_TOPOL_t topol;
};
typedef struct PK_TOPOL_fcstr_point_topol_s PK_TOPOL_fcstr_point_topol_t;


struct PK_TOPOL_fctab_point_topol_s {
 PK_TOPOL_fcstr_point_topol_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_point_topol_s PK_TOPOL_fctab_point_topol_t;


struct PK_TOPOL_fcstr_fin_topol_s {
 int fin;
 PK_TOPOL_t topol;
};
typedef struct PK_TOPOL_fcstr_fin_topol_s PK_TOPOL_fcstr_fin_topol_t;


struct PK_TOPOL_fctab_fin_topol_s {
 PK_TOPOL_fcstr_fin_topol_t *data;
 int length;
};
typedef struct PK_TOPOL_fctab_fin_topol_s PK_TOPOL_fctab_fin_topol_t;


struct PK_TOPOL_facet_table_s {
 PK_TOPOL_fctab_t fctab;
 union {
  PK_TOPOL_fctab_facet_fin_t *facet_fin;
  PK_TOPOL_fctab_strip_boundary_t *strip_boundary;
  PK_TOPOL_fctab_strip_zigzag_t *strip_zigzag;
  PK_TOPOL_fctab_fin_fin_t *fin_fin;
  PK_TOPOL_fctab_fin_data_t *fin_data;
  PK_TOPOL_fctab_data_point_t *data_point_idx;
  PK_TOPOL_fctab_data_normal_t *data_normal_idx;
  PK_TOPOL_fctab_data_param_t *data_param_idx;
  PK_TOPOL_fctab_data_deriv_t *data_deriv_idx;
  PK_TOPOL_fctab_point_vec_t *point_vec;
  PK_TOPOL_fctab_normal_vec_t *normal_vec;
  PK_TOPOL_fctab_param_uv_t *param_uv;
  PK_TOPOL_fctab_deriv_dp_t *deriv_dp;
  PK_TOPOL_fctab_deriv_d2p_t *deriv_d2p;
  PK_TOPOL_fctab_facet_face_t *facet_face;
  PK_TOPOL_fctab_strip_face_t *strip_face;
  PK_TOPOL_fctab_fin_edge_t *fin_edge;
  PK_TOPOL_fctab_point_topol_t *point_topol;
  PK_TOPOL_fctab_fin_topol_t *fin_topol;
  PK_TOPOL_fctab_error_object_t *error_object;
 } table;
};
typedef struct PK_TOPOL_facet_table_s PK_TOPOL_facet_table_t;


struct PK_TOPOL_facet_2_r_s {
 int number_of_facets;
 int number_of_strips;
 int number_of_fins;
 int number_of_tables;
 PK_TOPOL_facet_table_t *tables;
};
typedef struct PK_TOPOL_facet_2_r_s PK_TOPOL_facet_2_r_t;


struct PK_TOPOL_track_record_r_s {
 PK_TOPOL_track_t track;
 int n_original_topols;
 int *original_topols;
 PK_CLASS_t *original_classes;
 int n_product_topols;
 PK_TOPOL_t *product_topols;
};
typedef struct PK_TOPOL_track_record_r_s PK_TOPOL_track_record_r_t;


struct PK_TOPOL_track_r_s {
 int n_track_records;
 PK_TOPOL_track_record_r_t *track_records;
 int *internal_origs;
 PK_CLASS_t *internal_classes;
 int *internal_prods;
};
typedef struct PK_TOPOL_track_r_s PK_TOPOL_track_r_t;


struct PK_TOPOL_local_r_s {
 PK_local_status_t status;
 int n_error_entities;
 PK_ENTITY_t *error_entities;
};
typedef struct PK_TOPOL_local_r_s PK_TOPOL_local_r_t;


struct PK_ENTITY_track_record_r_s {
 PK_ENTITY_track_t track;
 int n_original_entities;
 int *original_entities;
 PK_CLASS_t *original_classes;
 int n_product_entities;
 PK_ENTITY_t *product_entities;
};
typedef struct PK_ENTITY_track_record_r_s PK_ENTITY_track_record_r_t;


struct PK_ENTITY_track_r_s {
 int n_track_records;
 PK_ENTITY_track_record_r_t *track_records;
 int *internal_origs;
 PK_CLASS_t *internal_classes;
 int *internal_prods;
};
typedef struct PK_ENTITY_track_r_s PK_ENTITY_track_r_t;


/* PK_double_constraint_t */

struct PK_double_constraint_s
    {
    PK_comparison_t comparison;
    PK_INTERVAL_t   interval;
    };
typedef struct PK_double_constraint_s PK_double_constraint_t;



/* PK_double_constraint_m */

#define PK_double_constraint_m( constraint )             \
    (                                                    \
        (constraint).comparison = PK_comparison_never_c, \
        (constraint).interval.value[0] = 0.0,            \
        (constraint).interval.value[1] = 0.0             \
    )


/* PK_SESSION_polling_cb_t */

typedef void (*PK_SESSION_polling_cb_t)(void);



/* PK_SESSION_applio_t */

typedef struct PK_SESSION_applio_s
    {
    int (*open_rd)   (int keylen, const char* key, int *strid);
    int (*open_wr)   (int keylen, const char* key, int *strid);

    int (*rd_chars)  (int strid, int n, char                *data);
    int (*rd_bytes)  (int strid, int n, unsigned char       *data);
    int (*rd_shorts) (int strid, int n, short               *data);
    int (*rd_ints)   (int strid, int n, int                 *data);
    int (*rd_doubles)(int strid, int n, double              *data);

    int (*wr_chars)  (int strid, int n, const char          *data);
    int (*wr_bytes)  (int strid, int n, const unsigned char *data);
    int (*wr_shorts) (int strid, int n, const short         *data);
    int (*wr_ints)   (int strid, int n, const int           *data);
    int (*wr_doubles)(int strid, int n, const double        *data);

    int (*close)     (int strid, int abort);

    int (*open_uc_rd)(const PK_UCHAR_t *key, int *strid);
    int (*open_uc_wr)(const PK_UCHAR_t *key, int *strid);

    int (*open_rd_2)   (int guise, int keylen, const char* key, int *strid);
    int (*open_wr_2)   (int guise, int keylen, const char* key, int *strid);
    int (*open_uc_rd_2)(int guise, const PK_UCHAR_t *key, int *strid);
    int (*open_uc_wr_2)(int guise, const PK_UCHAR_t *key, int *strid);
    }
    PK_SESSION_applio_t;



/* PK_SESSION_indexio_t */

struct PK_SESSION_indexio_s
    {
    int   (*ffoprd)(int guise, const char name[], void *context);
    int   (*ffopwr)(int guise, const char name[],
                    const char pr2[], void *context);
    int   (*ucoprd)(int guise, const PK_UCHAR_t name[], void *context);
    int   (*ucopwr)(int guise, const PK_UCHAR_t name[],
                    const char pr2[], void *context);
    int   (*ffread)(int nmax, char buffer[], int *nactual, void *context);
    int   (*ffwrit)(int nchars, const char buffer[], void *context);
    int   (*ffseek)(size_t pos, void *context);
    int   (*ffclos)(int action, void *context);
    };

typedef struct PK_SESSION_indexio_s PK_SESSION_indexio_t;


/* PK_SESSION_kernel_version_t */


typedef struct
    {
    int major_revision;      /* 7 */
    int minor_revision;      /* 1 */
    int build_number;        /* 110 */
    int year;                /* 1996 */
    int month;               /* 3 */
    int day;                 /* 5 */
    int hour;                /* 22 */
    int minute;              /* 1 */
    int second;              /* 40 */
    } PK_SESSION_kernel_version_t;



/* PK_check_fault_t */

typedef struct PK_check_fault_s
    {
    PK_check_state_t   state;       /* token indicating fault state */
    PK_ENTITY_t        entity_1;    /* fault entity always present */
    PK_ENTITY_t        entity_2;    /* secondary fault entity */
    PK_VECTOR_t        position;    /* position within faulty volume */
    } PK_check_fault_t;



/* PK_check_fault_m */

#define PK_check_fault_m(options)                               \
    (                                                           \
       (options).state             = PK_ENTITY_state_invalid_c, \
       (options).entity_1          = PK_ENTITY_null,            \
       (options).entity_2          = PK_ENTITY_null,            \
       (options).position.coord[0] = 0.0,                       \
       (options).position.coord[1] = 0.0,                       \
       (options).position.coord[2] = 0.0                        \
    )



/* PK_blend_properties_t */

struct PK_blend_properties_s
    {
    PK_blend_propagate_t    propagate;      /* whether to progagate */
    PK_blend_vary_t         vary;           /* form of variation */
    PK_blend_render_rib_t   render_rib;     /* enable rendering of ribs */
    PK_LOGICAL_t            draw_fix;       /* whether blend will be drawn */
    PK_blend_ov_smooth_t    ov_smooth;      /* enable smooth overflow */
    PK_blend_ov_cliff_t     ov_cliff;       /* enable cliff edge overflow */
    PK_blend_ov_cliff_end_t ov_cliff_end;   /* enable cliff edge end overflow */
    PK_blend_ov_notch_t     ov_notch;       /* enable notch overflow */
    double                  tolerance;      /* tolerance for blended edge */
    double                  ribspace;       /* approx separation of rib lines */
    };
typedef struct PK_blend_properties_s PK_blend_properties_t;




/* PK_blend_properties_m */

#define PK_blend_properties_m(options)                         \
    (                                                          \
       (options).propagate      = PK_blend_propagate_no_c,     \
       (options).vary           = PK_blend_vary_smooth_c,      \
       (options).render_rib     = PK_blend_render_rib_no_c,    \
       (options).draw_fix       = PK_LOGICAL_true,             \
       (options).ov_smooth      = PK_blend_ov_smooth_diff_c,   \
       (options).ov_cliff       = PK_blend_ov_cliff_diff_c,    \
       (options).ov_cliff_end   = PK_blend_ov_cliff_end_no_c,  \
       (options).ov_notch       = PK_blend_ov_notch_yes_c,     \
       (options).tolerance      = 1.0e-5,                      \
       (options).ribspace       = 0.0                          \
    )


/* PK_blend_setback_data_t */

struct PK_blend_setback_data_s
    {
    int                  n_edges;    /* number of edges (0) */
    const PK_EDGE_t    * edges;      /* edge (NULL) */
    const PK_LOGICAL_t * which_end;  /* whether setback is on */
    const double       * distances;  /* setback distance (NULL) */
    };
typedef struct PK_blend_setback_data_s PK_blend_setback_data_t;




/* PK_blend_setback_data_m */

#define PK_blend_setback_data_m(options)                       \
    (                                                          \
       (options).n_edges        = 0,                           \
       (options).edges          = NULL,                        \
       (options).which_end      = NULL,                        \
       (options).distances      = NULL                         \
    )


/* PK_blend_limit_data_t */

struct PK_blend_limit_data_s
    {
    int                          n_limits;          /* number of limits (0) */
    const PK_VECTOR_t           *limit_points;      /* limit points (NULL) */
    const PK_VECTOR_t           *limit_directions;  /* limit directions (NULL) */
    const PK_EDGE_t             *edges;             /* edges (NULL) */
    const PK_blend_limit_type_t *limit_types;       /* limit types (NULL) */
    const PK_blend_limit_patch_t
                                *limit_patch;       /* controls whether to try */
    int                          n_vertices;        /* number of vertices (0) */
    const PK_VERTEX_t           *vertices;          /* vertices (NULL) */
    };
typedef struct PK_blend_limit_data_s PK_blend_limit_data_t;




/* PK_blend_limit_data_m */

#define PK_blend_limit_data_m(options)                         \
    (                                                          \
       (options).n_limits         = 0,                         \
       (options).limit_points     = NULL,                      \
       (options).limit_directions = NULL,                      \
       (options).edges            = NULL,                      \
       (options).limit_types      = NULL,                      \
       (options).limit_patch      = NULL,                      \
       (options).n_vertices       = 0,                         \
       (options).vertices         = NULL                       \
    )


/* PK_blend_limit_patch_array_t */

struct PK_blend_limit_patch_array_s
    {
    int                           length;
    const PK_blend_limit_patch_t *limit_topol_patch;
    };
typedef struct PK_blend_limit_patch_array_s PK_blend_limit_patch_array_t;


/* PK_blend_vx_order_data_t */

struct PK_blend_vx_order_data_s
    {
    PK_blend_order_t        default_vx_order;  /* default order to apply blends */
    int                     n_vertices;        /* number of vertices (0) */
    const PK_VERTEX_t      *vertices;          /* vertices (NULL) */
    const PK_blend_order_t *vx_order;          /* order to apply blends at */
    };
typedef struct PK_blend_vx_order_data_s PK_blend_vx_order_data_t;




/* PK_blend_vx_order_data_m */

#define PK_blend_vx_order_data_m(options)                    \
    (                                                        \
       (options).default_vx_order = PK_blend_order_unset_c,  \
       (options).n_vertices       = 0,                       \
       (options).vertices         = NULL,                    \
       (options).vx_order         = NULL                     \
    )


/* PK_blend_vx_blend_data_t */

struct PK_blend_vx_blend_data_s
    {
    PK_LOGICAL_t         vertex_blend;  /* whether to vertex blend */
    int                  n_vertices;    /* number of vertices (0) */
    const PK_VERTEX_t   *vertices;      /* array of vertices to blend (NULL) */
    };
typedef struct PK_blend_vx_blend_data_s PK_blend_vx_blend_data_t;




/* PK_blend_vx_blend_data_m */

#define PK_blend_vx_blend_data_m(options)                  \
    (                                                          \
       (options).vertex_blend      = PK_LOGICAL_false,                        \
       (options).n_vertices        = 0,                        \
       (options).vertices          = NULL                      \
    )


/* PK_blend_y_blend_data_t */

struct PK_blend_y_blend_data_s
    {
    PK_LOGICAL_t         y_blend;       /* whether to y blend */
    int                  n_vertices;    /* number of vertices (0) */
    const PK_VERTEX_t   *vertices;      /* array of vertices to blend (NULL) */
    };
typedef struct PK_blend_y_blend_data_s PK_blend_y_blend_data_t;




/* PK_blend_y_blend_data_m */

#define PK_blend_y_blend_data_m(options)                       \
    (                                                          \
       (options).y_blend           = PK_LOGICAL_false,         \
       (options).n_vertices        = 0,                        \
       (options).vertices          = NULL                      \
    )


/* PK_blend_local_check_t */

struct PK_blend_local_check_s
    {
    PK_blend_check_su_X_t  check_su_X;       /* check for self-intersecting */
    PK_blend_check_fa_t    check_fa;         /* check individual faces */
    PK_blend_check_fa_fa_t check_fa_fa;      /* check for face-face */
    };
typedef struct PK_blend_local_check_s PK_blend_local_check_t;



/* PK_blend_local_check_m */

#define PK_blend_local_check_m(options)                             \
    (                                                               \
       (options).check_su_X          = PK_blend_check_su_X_no_c,    \
       (options).check_fa            = PK_blend_check_fa_no_c,      \
       (options).check_fa_fa         = PK_blend_check_fa_fa_no_c    \
    )


/* PK_BODY_blend_propagate_f_t */

typedef PK_LOGICAL_t (*PK_BODY_blend_propagate_f_t)
(
/* received */
PK_EDGE_t        /*edge*/,                /* potential propagation edge */
PK_POINTER_t     /*external_data*/        /* external application data */
);



/* PK_blend_fix_propagate_t */

struct PK_blend_fix_propagate_s
    {
    PK_LOGICAL_t     propagate;             /* whether to propagate */
    double           tolerance;             /* propagation angular tolerance */
    PK_BODY_blend_propagate_f_t function;   /* user propagation function (NULL) */
    PK_POINTER_t     data;                  /* user data for callback function */
    };
typedef struct PK_blend_fix_propagate_s PK_blend_fix_propagate_t;



/* PK_blend_fix_propagate_m */

#define PK_blend_fix_propagate_m(options)                           \
    (                                                               \
       (options).propagate           = PK_LOGICAL_true,             \
       (options).tolerance           = 3.14159265358979323846/36.0, \
       (options).function            = NULL,                        \
       (options).data                = NULL                         \
    )


/* PK_blend_delete_cap_data_t */

struct PK_blend_delete_cap_data_s
    {
    int                  n_blends;    /* number */
    const PK_FACE_t     *blends;      /* blend faces */
    const PK_ENTITY_t   *end_idents;  /* topologies */
    const PK_blend_delete_keep_t
                        *keep;        /* flag indicating */
    const PK_blend_cap_type_t
                        *type;        /* type of capping to be used. */
    };
typedef struct PK_blend_delete_cap_data_s PK_blend_delete_cap_data_t;




/* PK_blend_delete_cap_data_m */

#define PK_blend_delete_cap_data_m(options)                            \
    (                                                              \
       (options).n_blends             = 0,                         \
       (options).blends               = NULL,                      \
       (options).end_idents           = NULL,                      \
       (options).keep                 = NULL,                      \
       (options).type                 = NULL                       \
    )


/* PK_blend_constraint_t */

struct PK_blend_constraint_s
    {
    PK_EDGE_array_t     cliff_edges;        /* cliff edges */
    PK_EDGE_array_t     tangent_edges;      /* tangent holdline edges */
    PK_EDGE_array_t     conic_edges;        /* conic holdline edges */
    PK_EDGE_array_t     inv_tangent_edges;  /* inverse tangent holdline edges */
    PK_EDGE_array_t     inv_conic_edges;    /* inverse conic holdline edges */
    PK_PLANE_t          limit_1;            /* first limit plane */
    PK_PLANE_t          limit_2;            /* second limit plane */
    int                 n_caps;             /* number of caps (0) */
    const PK_ENTITY_t  *caps;               /* entities for capping */
    const PK_LOGICAL_t *reverse_cap;        /* whether cap orientation */
    PK_LOGICAL_t        localise_limit_planes;
    PK_TOPOL_array_t    limit_topols;       /* limit faces/fins */
    };
typedef struct PK_blend_constraint_s PK_blend_constraint_t;




/* PK_blend_constraint_m */

#define PK_blend_constraint_m(options)                             \
    (                                                              \
       (options).cliff_edges.length   = 0,                         \
       (options).tangent_edges.length = 0,                         \
       (options).conic_edges.length   = 0,                         \
       (options).inv_tangent_edges.length = 0,                     \
       (options).inv_conic_edges.length   = 0,                     \
       (options).limit_1              = PK_ENTITY_null,            \
       (options).limit_2              = PK_ENTITY_null,            \
       (options).n_caps               = 0,                         \
       (options).caps                 = NULL,                      \
       (options).reverse_cap           = NULL,                     \
       (options).localise_limit_planes = PK_LOGICAL_false,         \
       (options).limit_topols.length = 0                           \
    )


/* PK_blend_edge_shape_t */

struct PK_blend_edge_shape_s
    {
    int                   n_ranges;    /* number of ranges (0) */
    double               *ranges_1;    /* first ranges (0.0) */
    double               *ranges_2;    /* second ranges (0.0) */
    double               *rhos;        /* ranges (0.0) */
    PK_VECTOR_t          *positions;   /* positions where ranges apply */
    };
typedef struct PK_blend_edge_shape_s PK_blend_edge_shape_t;




/* PK_blend_law_t */

typedef PK_LAW_sf_t PK_blend_law_t;




/* PK_blend_shape_t */

struct PK_blend_shape_s
    {
    PK_blend_xs_plane_t xsection;      /* cross section plane */
    double              radius;        /* constant radius */
    PK_CURVE_t          parameter;     /* 3D parameter curve */
    PK_LAW_sf_t         range1;        /* 1D law function; */
    PK_LAW_sf_t         range2;        /* 1D law function; */
    PK_LAW_sf_t         rho;           /* 1D law function; */
    PK_BCURVE_t         depth;         /* 2D law curve; curvature cts blends */
    double              width;         /* width of blend for Constant Width */
    double              ratio;         /* ratio of blend ranges for Constant */
    PK_blend_xs_shape_t xs_shape;      /* cross section shape */
    double              softness;      /* controls softness of curvature */
    PK_blend_rho_t      rho_type;      /* whether to use absolute, relative or */
    double              range1_const;  /* Constant range off left wall (0.0) */
    double              range2_const;  /* Constant range off right wall (0.0) */
    double              rho_const;     /* Constant rho for general conics (0.0) */
    PK_LAW_sf_t         var_width;     /* 1D law function; */
    PK_LAW_sf_t         var_ratio;     /* 1D law function; */

    };
typedef struct PK_blend_shape_s PK_blend_shape_t;



/* PK_blend_shape_m */

#define PK_blend_shape_m(options)                              \
    (                                                          \
       (options).xsection       = PK_blend_xs_rolling_ball_c,  \
       (options).radius         = 0.0,                         \
       (options).parameter      = PK_ENTITY_null,              \
        PK_LAW_sf_m((options).range1),                         \
        PK_LAW_sf_m((options).range2),                         \
        PK_LAW_sf_m((options).rho),                            \
       (options).depth          = PK_ENTITY_null,              \
       (options).width          = 0.0,                         \
       (options).ratio          = 1.0,                         \
       (options).xs_shape       = PK_blend_xs_shape_unset_c,   \
       (options).softness       = 1.0,                         \
       (options).rho_type       = PK_blend_rho_absolute_c,     \
       (options).range1_const   = 0.0,                         \
       (options).range2_const   = 0.0,                         \
       (options).rho_const      = 0.0,                         \
        PK_LAW_sf_m((options).var_width),                      \
        PK_LAW_sf_m((options).var_ratio)                       \
    )


/* PK_blend_rib_control_t */

struct PK_blend_rib_control_s
    {
    PK_blend_output_rib_t output_rib;        /* whether and how ribs are made */
    PK_blend_group_rib_t  group_rib;         /* how to group ribs */
    int                   max_n_ribs;        /* limit ribs made per group (0) */
    int                   n_interval_parms;  /* number of parameters (0) */
    double               *interval_parms;    /* parameters dividing the spine */
    };
typedef struct PK_blend_rib_control_s PK_blend_rib_control_t;




/* PK_blend_rib_control_m */

#define PK_blend_rib_control_m(options)                            \
    (                                                              \
       (options).output_rib         = PK_blend_output_rib_no_c,    \
       (options).group_rib          = PK_blend_group_rib_no_c,     \
       (options).max_n_ribs         = 0,                           \
       (options).n_interval_parms   = 0,                           \
       (options).interval_parms     = NULL                         \
    )


/* PK_blend_rib_r_t */

struct PK_blend_rib_r_s
    {
    int                   n_ribs;        /* number of ribs */
    int                  *rib_indices;   /* unique integer ids for each rib */
    double               *rib_parms;     /* parameter of each rib */
    PK_GEOM_t            *ribs;          /* ribs */
    };
typedef struct PK_blend_rib_r_s PK_blend_rib_r_t;



/* PK_fxf_error_t */

struct PK_fxf_error_s
    {
    PK_fxf_fault_t        fault;         /* blend fault */
    int                   n_topols;      /* number of topols */
    PK_TOPOL_t           *topols;        /* associated topology */
    int                   n_points;      /* number of points */
    PK_VECTOR_t          *points;        /* error points */
    int                   n_dists;       /* number of lengths */
    double               *dists;         /* error lengths */
    };
typedef struct PK_fxf_error_s PK_fxf_error_t;



/* PK_blend_setback_shape_data_t */

struct PK_blend_setback_shape_data_s
    {
    PK_blend_setback_shape_t
                              default_shape;  /* the default */
    int                       n_vertices;     /* number of vertices at which */
    const PK_VERTEX_t        *vertices;       /* array of vertices at which the */
    const PK_blend_setback_shape_t
                             *shapes;         /* configurations of blend vertex */
    };
typedef struct PK_blend_setback_shape_data_s PK_blend_setback_shape_data_t;




/* PK_blend_setback_shape_data_m */

#define PK_blend_setback_shape_data_m(options)                      \
    (                                                               \
       (options).default_shape     = PK_blend_setback_collar_all_c, \
       (options).n_vertices        = 0,                             \
       (options).vertices          = NULL,                          \
       (options).shapes            = NULL                           \
    )


/* PK_blend_cap_data_t */

struct PK_blend_cap_data_s
    {
    int                 n_caps;        /* number of caps (0) */
    const PK_ENTITY_t  *caps;          /* entities for capping blend (NULL) */
    const PK_LOGICAL_t *reverse_cap;   /* whether cap orientation should be */
    };
typedef struct PK_blend_cap_data_s PK_blend_cap_data_t;




/* PK_blend_cap_data_m */

#define PK_blend_cap_data_m(options)                            \
    (                                                           \
       (options).n_caps              = 0,                       \
       (options).caps                = NULL,                    \
       (options).reverse_cap         = NULL                     \
    )


/* PK_blend_delete_unders_data_t */

struct PK_blend_delete_unders_data_s
    {
    int                      n_blends;  /* number of blend faces ( 0 ) */
    const PK_FACE_t         *blends;    /* blend faces ( NULL ) */
    const PK_ENTITY_array_t *unders;    /* underlying faces for each of the */
    };
typedef struct PK_blend_delete_unders_data_s PK_blend_delete_unders_data_t;




/* PK_blend_delete_unders_data_m */

#define PK_blend_delete_unders_data_m(options)                            \
    (                                                              \
       (options).n_blends             = 0,                         \
       (options).blends               = NULL,                      \
       (options).unders               = NULL                       \
    )


/* PK_range_end_t */

struct PK_range_end_s
    {
    PK_ENTITY_t   entity;          /* entity at end of separation */
    PK_ENTITY_t   sub_entity;      /* sub entity at end of separation */
    PK_VECTOR_t   vector;          /* end position              (0.0, 0.0, 0.0) */
    double        parameters[2];   /* parameter(s) at end position   (0.0, 0.0) */
    PK_LOGICAL_t  region;          /* whether solution is regional */
    PK_LOGICAL_t  negative;        /* whether other end is inside body */
    };
typedef struct PK_range_end_s PK_range_end_t;




/* PK_range_end_m */

#define PK_range_end_m(end)                             \
    (                                                       \
       (end).entity          = PK_ENTITY_null,          \
       (end).sub_entity      = PK_ENTITY_null,          \
       (end).vector.coord[0] = 0.0,                     \
       (end).vector.coord[1] = 0.0,                     \
       (end).vector.coord[2] = 0.0,                     \
       (end).parameters[0]   = 0.0,                     \
       (end).parameters[1]   = 0.0,                     \
       (end).region          = PK_LOGICAL_false,        \
       (end).negative        = PK_LOGICAL_false         \
    )


/* PK_range_1_r_t */

struct PK_range_1_r_s
    {
    double          distance;    /* separation between entity and position */
    PK_range_end_t  end;         /* end of line of separation on entity */
    };
typedef struct PK_range_1_r_s PK_range_1_r_t;



/* PK_range_1_r_array_t */

struct PK_range_1_r_array_s
    {
    PK_range_1_r_t  *array;
    int              length;
    };
typedef struct PK_range_1_r_array_s PK_range_1_r_array_t;



/* PK_range_2_r_t */

struct PK_range_2_r_s
    {
    double          distance;    /* separation between entities */
    PK_range_end_t  ends[2];     /* ends of line of separation on entities */
    };
typedef struct PK_range_2_r_s PK_range_2_r_t;




/* PK_range_2_r_array_t */

struct PK_range_2_r_array_s
    {
    PK_range_2_r_t  *array;
    int              length;
    };
typedef struct PK_range_2_r_array_s PK_range_2_r_array_t;



/* PK_range_guess_t */

struct PK_range_guess_s
    {
    PK_range_guess_type_t  type;             /* form of guess */
    double                 parameters[2];    /* parameters        (0.0, 0.0) */
    PK_VECTOR_t            vector;           /* end position (0.0, 0.0, 0.0) */
    };
typedef struct PK_range_guess_s PK_range_guess_t;




/* PK_range_guess_m */

#define PK_range_guess_m(guess)                              \
    (                                                          \
       (guess).type            = PK_range_guess_no_c,        \
       (guess).parameters[0]   = 0.0,                        \
       (guess).parameters[1]   = 0.0,                        \
       (guess).vector.coord[0] = 0.0,                        \
       (guess).vector.coord[1] = 0.0,                        \
       (guess).vector.coord[2] = 0.0                         \
    )


/* PK_range_bound_t */

struct PK_range_bound_s
    {
    PK_LOGICAL_t        have_upper_bound;  /* (PK_LOGICAL_false) */
    double              upper_bound;       /* upper bound on min/max separation */
    PK_LOGICAL_t        have_lower_bound;  /* (PK_LOGICAL_false) */
    double              lower_bound;       /* lower bound on min/max separation */
    };
typedef struct PK_range_bound_s PK_range_bound_t;




/* PK_range_bound_m */

#define PK_range_bound_m(bounds)                              \
    (                                                          \
       (bounds).have_upper_bound = PK_LOGICAL_false,          \
       (bounds).upper_bound      = 0.0,                       \
       (bounds).have_lower_bound = PK_LOGICAL_false,          \
       (bounds).lower_bound      = 0.0                        \
    )


/* PK_range_param_bound_t */

struct PK_range_param_bound_s
    {
    PK_LOGICAL_t      have_param_bound;
    PK_CLASS_t        param_bound_class;
    union
        {
        PK_INTERVAL_t interval;
        PK_UVBOX_t    uvbox;
        }             param_bound;
    };

typedef struct PK_range_param_bound_s PK_range_param_bound_t;




/* PK_range_param_bound_m */

#define PK_range_param_bound_m(params)                      \
    (                                                        \
    (params).have_param_bound           = PK_LOGICAL_false, \
    (params).param_bound_class          = PK_CLASS_null,    \
    (params).param_bound.uvbox.param[0] = 0.0,              \
    (params).param_bound.uvbox.param[1] = 0.0,              \
    (params).param_bound.uvbox.param[2] = 0.0,              \
    (params).param_bound.uvbox.param[3] = 0.0               \
    )


/* PK_SURF_trim_data_t */

struct PK_SURF_trim_data_s
    {
    int                n_spcurves;   /* number of trimming curves */
    PK_CURVE_t        *spcurves;     /* trim curves */
    PK_INTERVAL_t     *intervals;    /* trim curve intervals */
    int               *trim_loop;    /* which trim loop */
    int               *trim_set;     /* which trim set */
    };
typedef struct PK_SURF_trim_data_s PK_SURF_trim_data_t;




/* PK_BODY_one_vertex_match_t */

struct PK_BODY_one_vertex_match_s
    {
    PK_VERTEX_t profile_vertex;
    PK_VERTEX_t matched_vertex;
    };

typedef struct PK_BODY_one_vertex_match_s PK_BODY_one_vertex_match_t;



/* PK_BODY_one_vertex_match_m */

#define PK_BODY_one_vertex_match_m(one_match)                   \
    (                                                           \
       (one_match).profile_vertex  = PK_ENTITY_null,            \
       (one_match).matched_vertex = PK_ENTITY_null              \
    )


/* PK_BODY_vertex_match_t */

struct PK_BODY_vertex_match_s
    {
    PK_BODY_t                   profile;
    int                         n_matches;
    PK_BODY_one_vertex_match_t *matches;
    };

typedef struct PK_BODY_vertex_match_s PK_BODY_vertex_match_t;



/* PK_BODY_vertex_match_m */

#define PK_BODY_vertex_match_m(match)                           \
    (                                                           \
       (match).profile   = PK_ENTITY_null,                      \
       (match).n_matches = 0,                                   \
       (match).matches   = NULL                                 \
    )


/* PK_BODY_vertex_matches_t */

struct PK_BODY_vertex_matches_s
    {
    int                     n_mappings;
    PK_BODY_vertex_match_t *mappings;
    };

typedef struct PK_BODY_vertex_matches_s PK_BODY_vertex_matches_t;



/* PK_BODY_vertex_matches_m */

#define PK_BODY_vertex_matches_m(matches)                       \
    (                                                           \
       (matches).n_mappings = 0,                                \
       (matches).mappings   = NULL                              \
    )


/* PK_boolean_config_o_m */

#define PK_boolean_config_o_m(options)                      \
       ((options).o_t_version         = 1,                  \
        (options).no_tool_intersect   = PK_LOGICAL_false,   \
        (options).no_loop_intersect   = PK_LOGICAL_false,   \
        (options).identical_intersect = PK_LOGICAL_true,    \
        (options).one_in_all_in       = PK_LOGICAL_true)



/* PK_boolean_region_select_o_m */

#define PK_boolean_region_select_o_m(options)                 \
       ((options).o_t_version         = 4,                    \
        (options).select_type         = PK_boolean_include_c, \
        (options).n_region_selectors  = 0,                    \
        (options).selectors           = NULL,                 \
        (options).selector_types      = NULL,                 \
        (options).n_help_points       = 0,                    \
        (options).help_points         = NULL,                 \
        (options).region_types        = NULL                    )


/* PK_boolean_select_topolset_o_m */

#define PK_boolean_select_topolset_o_m(options)                    \
       ((options).o_t_version         = 1,                         \
        (options).n_selectors         = 0,                         \
        (options).selectors           = NULL,                      \
        (options).n_help_points       = 0,                         \
        (options).help_points         = NULL,                      \
        (options).target_select       = PK_selector_type_off_c,    \
        (options).tool_select         = PK_selector_type_off_c,    \
        (options).split_action        = PK_selector_split_fail_c     )


/* PK_boolean_match_region_o_m */


#define PK_boolean_match_region_o_m(options)                        \
       ((options).o_t_version            = 1,                       \
        (options).regions[0]             = PK_ENTITY_null,          \
        (options).regions[1]             = PK_ENTITY_null,          \
        (options).match_type             = PK_boolean_match_exact_c,\
        (options).tolerance              = 0.0)



/* PK_boolean_match_o_m */


#define PK_boolean_match_o_m(options)                                      \
       ((options).o_t_version            = 5,                              \
        (options).n_match_regions        = 0,                              \
        (options).match_regions          = NULL,                           \
        (options).auto_match             = PK_LOGICAL_false,               \
        (options).auto_match_tol         = 0.0,                            \
        (options).match_style            = PK_boolean_match_style_basic_c, \
        (options).update                 = PK_boolean_match_update_dflt_c)



/* PK_FACE_overflow_data_o_m */

#define PK_FACE_overflow_data_o_m(options)                                  \
      ((options).o_t_version               = 2,                             \
       (options).laminar_overflow          = PK_FACE_overflow_tangent_c,    \
       (options).interior_overflow         = PK_FACE_overflow_none_c,       \
       (options).sweep_direction.coord[0]  = 0.0,                           \
       (options).sweep_direction.coord[1]  = 0.0,                           \
       (options).sweep_direction.coord[2]  = 1.0,                           \
       (options).laminar_walled            = PK_LOGICAL_false               \
      )


/* PK_FACE_instance_bodies_o_m */

#define PK_FACE_instance_bodies_o_m(options)                             \
       ((options).o_t_version            = 2,                            \
        (options).function               = PK_boolean_unite_c,           \
        (options).configuration          = NULL,                         \
        (options).extend_face_list       = PK_imprint_face_list_no_c,    \
        (options).repair_fa_fa           = PK_instance_repair_fa_fa_yes_c,\
        (options).merge_imprinted        = PK_instance_merge_new_c,      \
        (options).allow_disjoint         = PK_LOGICAL_false,             \
        (options).check_fa               = PK_boolean_check_fa_yes_c,    \
        (options).default_tol            = 1.0E-5,                       \
        (options).max_tol                = 0.0,                          \
        (options).imprint_complete_targ  = PK_imprint_complete_no_c,     \
        (options).imprint_complete_tool  = PK_imprint_complete_no_c,     \
        (options).target_material_side   = PK_boolean_material_default_c,\
        (options).tool_material_side     = PK_boolean_material_default_c,\
        (options).limit_target_faces     = PK_LOGICAL_false,             \
        (options).tracking_type          = PK_instance_track_type_both_c,\
        (options).track_edges            = PK_instance_track_edges_new_c,\
        (options).resulting_body_type    = PK_boolean_prefer_original_c, \
        (options).update                 = PK_boolean_update_default_c   \
        )


/* PK_FACE_boolean_o_m */

#define PK_FACE_boolean_o_m(options)                                     \
       ((options).o_t_version            = 17,                           \
        (options).function               = PK_boolean_unite_c,           \
        (options).configuration          = NULL,                         \
        (options).select_region          = NULL,                         \
        (options).matched_region         = NULL,                         \
        (options).extend_face_list       = PK_imprint_face_list_no_c,    \
        (options).stop_self_intersection = PK_LOGICAL_false,             \
        (options).tracking               = PK_LOGICAL_false,             \
        (options).merge_imprinted        = PK_LOGICAL_false,             \
        (options).fence                  = PK_boolean_fence_none_c,      \
        (options).allow_disjoint         = PK_LOGICAL_false,             \
        (options).selective_merge        = PK_LOGICAL_false,             \
        (options).check_fa               = PK_boolean_check_fa_yes_c,    \
        (options).default_tol            = 1.0E-5,                       \
        (options).max_tol                = 0.0,                          \
        (options).merge_attributes       = PK_LOGICAL_false,             \
        (options).keep_target_edges      = PK_LOGICAL_false,             \
        (options).imprint_complete_targ  = PK_imprint_complete_no_c,     \
        (options).imprint_complete_tool  = PK_imprint_complete_no_c,     \
        (options).target_material_side   = PK_boolean_material_default_c,\
        (options).tool_material_side     = PK_boolean_material_default_c,\
        (options).resulting_body_type    = PK_boolean_prefer_original_c, \
        (options).limit_target_faces     = PK_LOGICAL_false,             \
        (options).flag_no_effect         = PK_boolean_no_effect_basic_c, \
        (options).limit_tool_faces       = PK_LOGICAL_false,             \
        (options).tracking_type          = PK_boolean_track_type_basic_c,\
        (options).target_face_overflow   = NULL,                         \
        (options).tool_face_overflow     = NULL,                         \
        (options).update                 = PK_boolean_update_default_c   \
        )


/* PK_BODY_boolean_o_m */


#define PK_BODY_boolean_o_m(options)                                         \
       ((options).o_t_version              = 17,                             \
        (options).function                 = PK_boolean_unite_c,             \
        (options).configuration            = NULL,                           \
        (options).selected_topolset        = NULL,                           \
        (options).matched_region           = NULL,                           \
        (options).merge_imprinted          = PK_LOGICAL_false,               \
        (options).prune_in_solid           = PK_LOGICAL_false,               \
        (options).prune_in_void            = PK_LOGICAL_false,               \
        (options).fence                    = PK_boolean_fence_none_c,        \
        (options).allow_disjoint           = PK_LOGICAL_false,               \
        (options).selective_merge          = PK_LOGICAL_false,               \
        (options).check_fa                 = PK_boolean_check_fa_yes_c,      \
        (options).default_tol              = 1.0E-5,                         \
        (options).max_tol                  = 0.0,                            \
        (options).tracking                 = PK_LOGICAL_false,               \
        (options).merge_attributes         = PK_LOGICAL_false,               \
        (options).keep_target_edges        = PK_LOGICAL_false,               \
        (options).imprint_complete_targ    = PK_imprint_complete_no_c,       \
        (options).imprint_complete_tool    = PK_imprint_complete_no_c,       \
        (options).target_material_side     = PK_boolean_material_default_c,  \
        (options).tool_material_side       = PK_boolean_material_default_c,  \
        (options).resulting_body_type      = PK_boolean_prefer_original_c,   \
        (options).flag_no_effect           = PK_boolean_no_effect_basic_c,   \
        (options).nm_edge_repair           = PK_nm_edge_repair_no_c,         \
        (options).blend_radius             = 1.0E-5,                         \
        (options).tracking_type            = PK_boolean_track_type_basic_c,  \
        (options).target_face_overflow     = NULL,                           \
        (options).tool_face_overflow       = NULL,                           \
        (options).imprint_overlapping      = PK_LOGICAL_false,               \
        (options).update                   = PK_boolean_update_default_c,    \
        (options).merge_in_solid           = PK_LOGICAL_false,               \
        (options).merge_in_solid_dimension = PK_TOPOL_dimension_any_c,       \
        (options).merge_in_face            = PK_LOGICAL_false,               \
        (options).merge_in_face_dimension  = PK_TOPOL_dimension_any_c,       \
        (options).merge_in_edge            = PK_LOGICAL_false                \
        )


/* PK_boolean_report_r_t */

struct PK_boolean_report_r_s
    {
    PK_boolean_report_t        report;
    int                        n_entities;
    PK_ENTITY_t               *entities;
    };
typedef struct PK_boolean_report_r_s PK_boolean_report_r_t;



/* PK_boolean_r_t */

struct PK_boolean_r_s
    {
    PK_boolean_result_t        result;
    int                        n_bodies;
    PK_BODY_t                 *bodies;
    int                        n_reports;
    PK_boolean_report_r_t     *reports;
    };
typedef struct PK_boolean_r_s PK_boolean_r_t;



/* PK_boolean_config_o_t */

struct PK_boolean_config_o_s
    {
    int             o_t_version;         /* version number */
    PK_LOGICAL_t    no_tool_intersect;   /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    no_loop_intersect;   /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    identical_intersect; /* (PK_LOGICAL_true) */
    PK_LOGICAL_t    one_in_all_in;       /* (PK_LOGICAL_true) */
    };
typedef struct PK_boolean_config_o_s PK_boolean_config_o_t;




/* PK_boolean_region_select_o_t */

struct PK_boolean_region_select_o_s
    {
    int                          o_t_version;        /* version number */
    PK_boolean_region_t          select_type;        /* (PK_boolean_include_c) */
    int                          n_region_selectors; /* (0) */
    const PK_TOPOL_t            *selectors;          /* (NULL) */
    const PK_boolean_select_t   *selector_types;     /* (NULL) */
    int                          n_help_points;      /* (0) */
    const PK_VECTOR_t           *help_points;        /* (NULL) */
    const PK_boolean_region_t   *region_types;       /* (NULL) */
    };
typedef struct PK_boolean_region_select_o_s PK_boolean_region_select_o_t;




/* PK_boolean_select_topolset_o_t */

struct PK_boolean_select_topolset_o_s
    {
    int                         o_t_version;    /* version number */
    int                         n_selectors;    /* (0) */
    const PK_TOPOL_t           *selectors;      /* (NULL) */
    int                         n_help_points;  /* (0) */
    const PK_VECTOR_t          *help_points;    /* (NULL) */
    PK_selector_type_t          target_select;  /* (PK_selector_type_off_c) */
    PK_selector_type_t          tool_select;    /* (PK_selector_type_off_c) */
    PK_selector_split_t         split_action;   /* (PK_selector_split_fail_c) */
    };
typedef struct PK_boolean_select_topolset_o_s
    PK_boolean_select_topolset_o_t;



/* PK_boolean_match_region_o_t */

struct PK_boolean_match_region_o_s
    {
    int                    o_t_version;  /* version number */
    PK_TOPOL_t             regions[2];   /* (PK_ENTITY_null, PK_ENTITY_null) */
    PK_boolean_match_t     match_type;   /* (PK_boolean_match_exact_c) */
    double                 tolerance;    /* (0.0) */
    };
typedef struct PK_boolean_match_region_o_s PK_boolean_match_region_o_t;




/* PK_boolean_match_o_t */

struct PK_boolean_match_o_s
    {
    int                 o_t_version;      /* version number */
    PK_boolean_match_style_t
                        match_style;      /* (PK_boolean_match_style_basic_c) */
    PK_LOGICAL_t        auto_match;       /* (PK_LOGICAL_false) */
    double              auto_match_tol;   /* (0.0) */
    int                 n_match_regions;  /* (0) */
    const PK_boolean_match_region_o_t
                       *match_regions;    /* (NULL) */
    PK_boolean_match_update_t
                        update;           /* (PK_boolean_match_update_dflt_c) */
    };
typedef struct PK_boolean_match_o_s PK_boolean_match_o_t;




/* PK_FACE_overflow_data_o_t */

struct PK_FACE_overflow_data_o_s
    {
    int                   o_t_version;       /* version number */
    PK_FACE_overflow_t    interior_overflow; /* how to overflow across */
    PK_FACE_overflow_t    laminar_overflow;  /* how to overflow across */
    PK_VECTOR1_t          sweep_direction;   /* sweep direction */
    PK_LOGICAL_t          laminar_walled;    /* whether to add side faces */
    };
typedef struct PK_FACE_overflow_data_o_s PK_FACE_overflow_data_o_t;


/* PK_FACE_instance_bodies_o_t */

struct PK_FACE_instance_bodies_o_s
    {
    int                   o_t_version;      /* version number */
    PK_boolean_function_t function;         /* boolean operation */
    const PK_boolean_config_o_t
                         *configuration;    /* target and tool */
    PK_imprint_face_list_t
                          extend_face_list;
    PK_instance_repair_fa_fa_t
                          repair_fa_fa;     /* prevent self intersections */
    PK_instance_merge_t   merge_imprinted;  /* merge imprinted edges where */
    PK_LOGICAL_t          allow_disjoint;   /* allow disjoint body */
    PK_boolean_check_fa_t check_fa;         /* face check options */
    double                default_tol;      /* default tolerance */
    double                max_tol;          /* max tolerance */
    PK_imprint_complete_t imprint_complete_targ;
    PK_imprint_complete_t imprint_complete_tool;
    PK_boolean_material_t target_material_side;
    PK_boolean_material_t tool_material_side;
    PK_LOGICAL_t          limit_target_faces;
    PK_instance_track_type_t
                          tracking_type;    /* level of tracking reporting */
    PK_instance_track_edges_t
                          track_edges;      /* level of edge tracking */

    PK_boolean_prefer_t   resulting_body_type;
    PK_boolean_update_t   update;           /* update switch */
    };
typedef struct PK_FACE_instance_bodies_o_s PK_FACE_instance_bodies_o_t;




/* PK_FACE_boolean_o_t */

struct PK_FACE_boolean_o_s
    {
    int                   o_t_version;       /* version number */
    PK_boolean_function_t function;          /* boolean operation */
    const PK_boolean_config_o_t
                         *configuration;     /* target and tool */
    const PK_boolean_region_select_o_t
                         *select_region;     /* region selection (NULL) */
    const PK_boolean_match_o_t
                         *matched_region;    /* regions to match (NULL) */
    PK_imprint_face_list_t
                          extend_face_list;  /* whether to use additional */
    PK_LOGICAL_t          stop_self_intersection;
    PK_LOGICAL_t          tracking;          /* include tracking */
    PK_LOGICAL_t          merge_imprinted;   /* merge imprinted edges where */
    PK_boolean_fence_t    fence;             /* fencing options */
    PK_LOGICAL_t          allow_disjoint;    /* allow disjoint body */
    PK_LOGICAL_t          selective_merge;   /* selective merge */
    PK_boolean_check_fa_t check_fa;          /* face check options */
    double                default_tol;       /* default tolerance */
    double                max_tol;           /* max tolerance */
    PK_LOGICAL_t          merge_attributes;  /* merge attributes */
    PK_LOGICAL_t          keep_target_edges; /* handle coi edges */
    PK_imprint_complete_t imprint_complete_targ;
    PK_imprint_complete_t imprint_complete_tool;
    PK_boolean_material_t target_material_side;
    PK_boolean_material_t tool_material_side;
    PK_boolean_prefer_t   resulting_body_type;
    PK_LOGICAL_t          limit_target_faces;
    PK_boolean_no_effect_t
                          flag_no_effect;    /* level of reporting of */
    PK_LOGICAL_t          limit_tool_faces;
    PK_boolean_track_type_t
                          tracking_type;     /* level of tracking reporting */
    const PK_FACE_overflow_data_o_t
                         *target_face_overflow;
    const PK_FACE_overflow_data_o_t
                         *tool_face_overflow;
    PK_boolean_update_t   update;            /* update switch */
    };
typedef struct PK_FACE_boolean_o_s PK_FACE_boolean_o_t;




/* PK_BODY_boolean_o_t */

struct PK_BODY_boolean_o_s
    {
    int                   o_t_version;       /* version number */
    PK_boolean_function_t function;          /* which boolean operation */
    const PK_boolean_config_o_t
                         *configuration;     /* target and tool */
    const PK_boolean_select_topolset_o_t
                         *selected_topolset; /* topolsets to select (NULL) */
    const PK_boolean_match_o_t
                         *matched_region;    /* regions to match (NULL) */
    PK_LOGICAL_t          merge_imprinted;   /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          prune_in_solid;    /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          prune_in_void;     /* (PK_LOGICAL_false) */
    PK_boolean_fence_t    fence;             /* (PK_boolean_fence_none_c) */
    PK_LOGICAL_t          allow_disjoint;    /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          selective_merge;   /* (PK_LOGICAL_false) */
    PK_boolean_check_fa_t check_fa;          /* (PK_boolean_check_fa_yes_c) */
    double                default_tol;       /* (1.0E-5) */
    double                max_tol;           /* (0.0) */
    PK_LOGICAL_t          tracking;          /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          merge_attributes;  /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          keep_target_edges; /* (PK_LOGICAL_false) */
    PK_imprint_complete_t imprint_complete_targ;
    PK_imprint_complete_t imprint_complete_tool;
    PK_boolean_material_t target_material_side;
    PK_boolean_material_t tool_material_side;
    PK_boolean_prefer_t   resulting_body_type;
    PK_boolean_no_effect_t
                          flag_no_effect;    /* level of reporting of */
    PK_nm_edge_repair_t   nm_edge_repair;    /* whether to ignore non-manifold */
    double                blend_radius;      /* blend radius associated with */
    PK_boolean_track_type_t
                          tracking_type;     /* level of tracking reporting */
    const PK_FACE_overflow_data_o_t
                         *target_face_overflow;
    const PK_FACE_overflow_data_o_t
                         *tool_face_overflow;
    PK_LOGICAL_t          imprint_overlapping;
    PK_boolean_update_t   update;            /* update switch */
    PK_LOGICAL_t          merge_in_solid;    /* whether any topologies which */
    PK_TOPOL_dimension_t  merge_in_solid_dimension;
    PK_LOGICAL_t          merge_in_face;     /* whether any redundant */
    PK_TOPOL_dimension_t  merge_in_face_dimension;
    PK_LOGICAL_t          merge_in_edge;     /* whether any redundant */
    };
typedef struct PK_BODY_boolean_o_s PK_BODY_boolean_o_t;




/* PK_FACE_section_o_m */


#define PK_FACE_section_o_m(options)                                     \
       (                                                                 \
           (options).o_t_version            = 4,                         \
           (options).fence                  = PK_section_fence_both_c,   \
           (options).configuration          = NULL,                      \
           (options).select_region          = NULL,                      \
           (options).matched_region         = NULL,                      \
           (options).extend_face_list       = PK_LOGICAL_false,          \
           (options).merge_imprinted        = PK_LOGICAL_false,          \
           (options).merge_new_faces        = PK_LOGICAL_false,          \
           (options).selective_merge        = PK_LOGICAL_false,          \
           (options).check_fa               = PK_section_check_fa_yes_c, \
           (options).default_tol            = 1.0E-5,                    \
           (options).max_tol                = 0.0,                       \
           (options).tracking               = PK_LOGICAL_false,          \
           (options).keep_target_edges      = PK_LOGICAL_false           \
       )



/* PK_BODY_section_o_m */


#define PK_BODY_section_o_m(options)                                     \
       (                                                                 \
           (options).o_t_version            = 4,                         \
           (options).fence                  = PK_section_fence_both_c,   \
           (options).matched_region         = NULL,                      \
           (options).merge_imprinted        = PK_LOGICAL_false,          \
           (options).merge_new_faces        = PK_LOGICAL_false,          \
           (options).selective_merge        = PK_LOGICAL_false,          \
           (options).check_fa               = PK_section_check_fa_yes_c, \
           (options).default_tol            = 1.0E-5,                    \
           (options).max_tol                = 0.0,                       \
           (options).tracking               = PK_LOGICAL_false,          \
           (options).keep_target_edges      = PK_LOGICAL_false           \
       )



/* PK_BODY_make_section_o_m */


#define PK_BODY_make_section_o_m(options)                                \
       (                                                                 \
           (options).o_t_version            = 1,                         \
           (options).default_tol            = 1.0E-5,                    \
           (options).max_tol                = 0.0,                       \
           (options).tracking               = PK_LOGICAL_false,          \
           (options).allow_disjoint         = PK_LOGICAL_false,          \
           (options).result_body_type       = PK_BODY_type_sheet_c       \
       )



/* PK_FACE_make_sect_with_sfs_o_m */


#define PK_FACE_make_sect_with_sfs_o_m(options)                          \
       (                                                                 \
           (options).o_t_version            = 1,                         \
           (options).tracking               = PK_LOGICAL_false,          \
           (options).allow_disjoint         = PK_LOGICAL_false,          \
           (options).extend_face_list       = PK_LOGICAL_false           \
       )



/* PK_section_report_r_t */

struct PK_section_report_r_s
    {
    PK_section_report_t        report;
    int                        n_entities;
    PK_ENTITY_t               *entities;
    };
typedef struct PK_section_report_r_s PK_section_report_r_t;



/* PK_BODY_make_section_r_t */

struct PK_BODY_make_section_r_s
    {
    int                     n_bodies;        /* number of bodies */
    PK_BODY_t              *bodies;          /* bodies */
    int                     n_reports;       /* number of reports */
    PK_section_report_r_t  *reports;         /* array of report structures */
    };
typedef struct PK_BODY_make_section_r_s PK_BODY_make_section_r_t;




/* PK_FACE_make_sect_with_sfs_r_t */

struct PK_FACE_make_sect_with_sfs_r_s
    {
    int                     n_bodies;        /* number of bodies */
    PK_BODY_t              *bodies;          /* bodies */
    int                     n_reports;       /* number of reports */
    PK_section_report_r_t  *reports;         /* array of report structures */
    };
typedef struct PK_FACE_make_sect_with_sfs_r_s PK_FACE_make_sect_with_sfs_r_t;




/* PK_section_2_r_t */

struct PK_section_2_r_s
    {
    PK_section_result_t     result;          /* result of sectioning operation */
    int                     n_front_bodies;  /* number of front bodies */
    PK_BODY_t              *front_bodies;    /* bodies in front of section */
    int                     n_back_bodies;   /* number of back bodies */
    PK_BODY_t              *back_bodies;     /* bodies behind section */
    int                     n_front_faces;   /* number of front faces */
    PK_FACE_t              *front_faces;     /* faces in front of section */
    int                     n_back_faces;    /* number of back faces */
    PK_FACE_t              *back_faces;      /* faces behind section */
    int                     n_reports;       /* number of reports */
    PK_section_report_r_t  *reports;         /* array of report structures */
    };
typedef struct PK_section_2_r_s PK_section_2_r_t;




/* PK_section_r_t */

struct PK_section_r_s
    {
    PK_BODY_array_t front_bodies;   /* Bodies in front of section */
    PK_BODY_array_t back_bodies;    /* Bodies behind section */
    PK_FACE_array_t front_faces;    /* Faces in front of section */
    PK_FACE_array_t back_faces;     /* Faces behind section */
    };
typedef struct PK_section_r_s PK_section_r_t;




/* PK_FACE_section_o_t */


struct PK_FACE_section_o_s
    {
    int                       o_t_version;       /* version number */
    PK_section_fence_t        fence;             /* (PK_section_fence_both_c) */
    const PK_boolean_config_o_t
                             *configuration;     /* (NULL) */
    const PK_boolean_region_select_o_t
                             *select_region;     /* (NULL) */
    const PK_boolean_match_o_t
                             *matched_region;    /* (NULL) */
    PK_LOGICAL_t              extend_face_list;  /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              merge_imprinted;   /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              merge_new_faces;   /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              selective_merge;   /* (PK_LOGICAL_false) */
    PK_section_check_fa_t     check_fa;          /* (PK_section_check_fa_yes_c) */
    double                    default_tol;       /* (1.0E-5) */
    double                    max_tol;           /* (0.0) */
    PK_LOGICAL_t              tracking;          /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              keep_target_edges;   /* (PK_LOGICAL_false) */
    };
typedef struct PK_FACE_section_o_s PK_FACE_section_o_t;




/* PK_BODY_section_o_t */

struct PK_BODY_section_o_s
    {
    int                       o_t_version;      /* version number */
    PK_section_fence_t        fence;            /* (PK_section_fence_both_c) */
    const PK_boolean_match_o_t
                             *matched_region;   /* (NULL) */
    PK_LOGICAL_t              merge_imprinted;  /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              merge_new_faces;  /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              selective_merge;  /* (PK_LOGICAL_false) */
    PK_section_check_fa_t     check_fa;         /* (PK_section_check_fa_yes_c) */
    double                    default_tol;      /* (1.0E-5) */
    double                    max_tol;          /* (0.0) */
    PK_LOGICAL_t              tracking;         /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              keep_target_edges;   /* (PK_LOGICAL_false) */
    };
typedef struct PK_BODY_section_o_s  PK_BODY_section_o_t;




/* PK_BODY_make_section_o_t */

struct PK_BODY_make_section_o_s
    {
    int                       o_t_version;       /* version number */
    double                    default_tol;       /* (1.0E-5) */
    double                    max_tol;           /* (0.0) */
    PK_LOGICAL_t              tracking;          /* (PK_LOGICAL_false) */
    PK_LOGICAL_t              allow_disjoint;    /* (PK_LOGICAL_false) */
    PK_BODY_type_t            result_body_type;  /* (PK_BODY_type_sheet_c) */
    };
typedef struct PK_BODY_make_section_o_s  PK_BODY_make_section_o_t;




/* PK_FACE_make_sect_with_sfs_o_t */

struct PK_FACE_make_sect_with_sfs_o_s
    {
    int                       o_t_version;       /* Version number */
    PK_LOGICAL_t              tracking;          /* Whether the tracking */
    PK_LOGICAL_t              allow_disjoint;    /* Whether a disjoint body */
    PK_LOGICAL_t              extend_face_list;  /* Whether to use additional */
    };
typedef struct PK_FACE_make_sect_with_sfs_o_s
            PK_FACE_make_sect_with_sfs_o_t;




/* PK_FACE_imprint_faces_o_m */

#define PK_FACE_imprint_faces_o_m(options)                            \
    (                                                                 \
       (options).o_t_version           = 3,                           \
       (options).imprint_tool          = PK_LOGICAL_true,             \
       (options).imprint_overlapping   = PK_LOGICAL_false,            \
       (options).extend_face_list      = PK_imprint_face_list_no_c,   \
       (options).matched_region        = NULL,                        \
       (options).imprint_complete_targ = PK_imprint_complete_no_c,    \
       (options).imprint_extend_targ   = PK_imprint_extend_tangent_c, \
       (options).imprint_complete_tool = PK_imprint_complete_no_c,    \
       (options).imprint_extend_tool   = PK_imprint_extend_tangent_c, \
       (options).imprint_dir           = PK_imprint_dir_no_check_c,   \
       (options).update                = PK_boolean_update_default_c  \
    )


/* PK_FACE_imprint_o_m */

#define PK_FACE_imprint_o_m(options)                                  \
    (                                                                 \
       (options).o_t_version           = 3,                           \
       (options).imprint_tool          = PK_LOGICAL_true,             \
       (options).imprint_overlapping   = PK_LOGICAL_false,            \
       (options).extend_face_list      = PK_imprint_face_list_no_c,   \
       (options).matched_region        = NULL,                        \
       (options).imprint_complete_targ = PK_imprint_complete_no_c,    \
       (options).imprint_extend_targ   = PK_imprint_extend_tangent_c, \
       (options).imprint_complete_tool = PK_imprint_complete_no_c,    \
       (options).imprint_extend_tool   = PK_imprint_extend_tangent_c  \
    )


/* PK_BODY_imprint_faces_o_m */

#define PK_BODY_imprint_faces_o_m(options)                            \
    (                                                                 \
       (options).o_t_version           = 3,                           \
       (options).imprint_tool          = PK_LOGICAL_true,             \
       (options).imprint_overlapping   = PK_LOGICAL_false,            \
       (options).extend_face_list      = PK_imprint_face_list_no_c,   \
       (options).matched_region        = NULL,                        \
       (options).imprint_complete_targ = PK_imprint_complete_no_c,    \
       (options).imprint_extend_targ   = PK_imprint_extend_tangent_c, \
       (options).imprint_complete_tool = PK_imprint_complete_no_c,    \
       (options).imprint_extend_tool   = PK_imprint_extend_tangent_c, \
       (options).imprint_dir           = PK_imprint_dir_no_check_c,   \
       (options).update                = PK_boolean_update_default_c  \
    )


/* PK_BODY_imprint_o_m */

#define PK_BODY_imprint_o_m(options)                                  \
    (                                                                 \
       (options).o_t_version           = 4,                           \
       (options).imprint_tool          = PK_LOGICAL_true,             \
       (options).imprint_overlapping   = PK_LOGICAL_false,            \
       (options).matched_region        = NULL,                        \
       (options).imprint_complete_targ = PK_imprint_complete_no_c,    \
       (options).imprint_extend_targ   = PK_imprint_extend_tangent_c, \
       (options).imprint_complete_tool = PK_imprint_complete_no_c,    \
       (options).imprint_extend_tool   = PK_imprint_extend_tangent_c, \
       (options).update                = PK_boolean_update_default_c  \
    )


/* PK_BODY_imprint_plane_o_m */

#define PK_BODY_imprint_plane_o_m(options)                            \
    (                                                                 \
       (options).o_t_version           = 1,                           \
       (options).have_tolerance        = PK_LOGICAL_false,            \
       (options).tolerance             = 0.0,                         \
       (options).imprint_dir           = PK_imprint_dir_no_check_c    \
    )


/* PK_FACE_imprint_faces_o_t */

struct PK_FACE_imprint_faces_o_s
    {
    int           o_t_version;            /* version number of option structure */
    PK_LOGICAL_t  imprint_tool;           /* whether to imprint on tool */
    PK_LOGICAL_t  imprint_overlapping;    /* whether to imprint boundaries of */
    PK_imprint_face_list_t
                  extend_face_list;       /* whether to extend list of faces */
    const PK_boolean_match_o_t
                  *matched_region;        /* regions to match (NULL) */
    PK_imprint_complete_t
                  imprint_complete_targ;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_targ;    /* direction in which to complete */
    PK_imprint_complete_t
                  imprint_complete_tool;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_tool;    /* direction in which to complete */
    PK_imprint_dir_t
                  imprint_dir;            /* whether imprinted edges should */
    PK_boolean_update_t
                  update;                 /* update switch */
    };

typedef struct PK_FACE_imprint_faces_o_s PK_FACE_imprint_faces_o_t;



/* PK_FACE_imprint_o_t */

struct PK_FACE_imprint_o_s
    {
    int           o_t_version;            /* version number of option structure */
    PK_LOGICAL_t  imprint_tool;           /* whether to imprint on tool */
    PK_LOGICAL_t  imprint_overlapping;    /* whether to imprint boundaries of */
    PK_imprint_face_list_t
                  extend_face_list;       /* whether to extend list of faces */
    const PK_boolean_match_o_t
                  *matched_region;        /* regions to match (NULL) */
    PK_imprint_complete_t
                  imprint_complete_targ;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_targ;    /* direction in which to complete */
    PK_imprint_complete_t
                  imprint_complete_tool;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_tool;    /* direction in which to complete */
    };

typedef struct PK_FACE_imprint_o_s PK_FACE_imprint_o_t;



/* PK_BODY_imprint_faces_o_t */

struct PK_BODY_imprint_faces_o_s
    {
    int           o_t_version;            /* version number of option structure */
    PK_LOGICAL_t  imprint_tool;           /* whether to imprint on tool */
    PK_LOGICAL_t  imprint_overlapping;    /* whether to imprint boundaries of */
    PK_imprint_face_list_t
                  extend_face_list;       /* whether to extend list of faces */
    const PK_boolean_match_o_t
                 *matched_region;         /* regions to match (NULL) */
    PK_imprint_complete_t
                  imprint_complete_targ;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_targ;    /* direction in which to complete */
    PK_imprint_complete_t
                  imprint_complete_tool;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_tool;    /* direction in which to complete */
    PK_imprint_dir_t
                  imprint_dir;            /* whether imprinted edges should */
    PK_boolean_update_t
                  update;                 /* update switch */
    };

typedef struct PK_BODY_imprint_faces_o_s PK_BODY_imprint_faces_o_t;



/* PK_BODY_imprint_o_t */

struct PK_BODY_imprint_o_s
    {
    int           o_t_version;            /* version number of option structure */
    PK_LOGICAL_t  imprint_tool;           /* whether to imprint on tool */
    PK_LOGICAL_t  imprint_overlapping;    /* whether to imprint boundaries of */
    const PK_boolean_match_o_t
                  *matched_region;        /* regions to match (NULL) */
    PK_imprint_complete_t
                  imprint_complete_targ;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_targ;    /* direction in which to complete */
    PK_imprint_complete_t
                  imprint_complete_tool;  /* whether to complete imprint on */
    PK_imprint_extend_t
                  imprint_extend_tool;    /* direction in which to complete */
    PK_boolean_update_t
                  update;                 /* update switch */
    };

typedef struct PK_BODY_imprint_o_s PK_BODY_imprint_o_t;



/* PK_BODY_imprint_plane_o_t */

struct PK_BODY_imprint_plane_o_s
    {
    int               o_t_version;        /* version number of option structure */
    PK_LOGICAL_t      have_tolerance;     /* whether a tolerance is provided */
    double            tolerance;          /* operation tolerance (0.0) */
    PK_imprint_dir_t  imprint_dir;        /* whether imprinted edges should */
    };

typedef struct PK_BODY_imprint_plane_o_s PK_BODY_imprint_plane_o_t;



/* PK_imprint_r_t */

struct PK_imprint_r_s
    {
    PK_EDGE_array_t    target_edges;      /* corresponding edges on target */
    PK_EDGE_array_t    tool_edges;        /* corresponding edges on tool */
    PK_VERTEX_array_t  target_vertices;   /* corresponding vertices on target */
    PK_VERTEX_array_t  tool_vertices;     /* corresponding vertices on tool */
    };
typedef struct PK_imprint_r_s PK_imprint_r_t;




/* PK_ENTITY_ask_description_o_m */


#define PK_ENTITY_ask_description_o_m(options)                       \
       ((options).o_t_version            = 1                         )



/* PK_ENTITY_ask_description_o_t */


struct PK_ENTITY_ask_description_o_s
    {
    int                        o_t_version;  /* version number */
    };
typedef struct PK_ENTITY_ask_description_o_s PK_ENTITY_ask_description_o_t;




/* PK_ENTITY_check_attribs_o_t */

struct PK_ENTITY_check_attribs_o_s
    {
    int                 o_t_version;       /* version number */
    PK_LOGICAL_t        return_faults;     /* return fault information */
    PK_LOGICAL_t        check_sub;         /* check sub-entities of that given */
    };
typedef struct PK_ENTITY_check_attribs_o_s PK_ENTITY_check_attribs_o_t;


/* PK_ENTITY_check_attribs_o_m */

#define PK_ENTITY_check_attribs_o_m(options)                            \
    (                                                                   \
        (options).o_t_version       = 1,                                \
        (options).return_faults     = PK_LOGICAL_true,                  \
        (options).check_sub         = PK_LOGICAL_true                   \
    )


/* PK_ENTITY_copy_o_t */

struct PK_ENTITY_copy_o_s
    {
    int                 o_t_version;       /* version number */
    PK_LOGICAL_t        want_user_fields;  /* copy user fields */
    PK_LOGICAL_t        want_attribs;      /* copy attributes */
    PK_LOGICAL_t        want_groups;       /* copy groups */
    PK_LOGICAL_t        want_tracking;     /* create tracking information */
    PK_CLASS_array_t    track_classes;     /* classes to track */
    };
typedef struct PK_ENTITY_copy_o_s PK_ENTITY_copy_o_t;


/* PK_ENTITY_copy_o_m */


#define PK_ENTITY_copy_o_m(options)                                 \
       ((options).o_t_version          = 1,                         \
        (options).want_user_fields     = PK_LOGICAL_false,          \
        (options).want_attribs         = PK_LOGICAL_false,          \
        (options).want_groups          = PK_LOGICAL_false,          \
        (options).want_tracking        = PK_LOGICAL_false,          \
        (options).track_classes.array  = NULL,                      \
        (options).track_classes.length = 0                          )



/* PK_ATTDEF_sf_t */

struct PK_ATTDEF_sf
    {
    char                *name;              /* name of attribute type */
    PK_ATTDEF_class_t    attdef_class;      /* transform characteristics */
    int                  n_owner_types;     /* number of legal owners (>0) */
    PK_CLASS_t          *owner_types;       /* legal owner types */
    int                  n_fields;          /* number of fields (>= 0) */
    PK_ATTRIB_field_t   *field_types;       /* types of above fields */
    };
typedef struct PK_ATTDEF_sf PK_ATTDEF_sf_t;



/* PK_field_names_t */

typedef union PK_field_names_u
    {
    char       **names;
    PK_UCHAR_t **unames;
    }
    PK_field_names_t;



/* PK_ATTDEF_sf_2_t */

struct PK_ATTDEF_sf_2
    {
    char                *name;              /* name of attribute type */
    PK_ATTDEF_class_t    attdef_class;      /* transform characteristics */
    int                  n_owner_types;     /* number of legal owners (>0) */
    PK_CLASS_t          *owner_types;       /* legal owner types */
    int                  n_fields;          /* number of fields (>= 0) */
    PK_ATTRIB_field_t   *field_types;       /* types of above fields */
    PK_LOGICAL_t         unicode_names;     /* Unicode or char names */
    PK_field_names_t     field_names;       /* names of above fields */
    int                 *field_sizes;       /* for future use */
    };
typedef struct PK_ATTDEF_sf_2 PK_ATTDEF_sf_2_t;



/* PK_ATTDEF_split_callback_f_t */

typedef void    (*PK_ATTDEF_split_callback_f_t)
(
PK_ENTITY_t       old_entity,         /* the pre-existing entity */
int               n_attribs,          /* number of attribs on `old_entity' */
const PK_ATTRIB_t attribs[],          /* attribs on `old_entity' */
PK_ENTITY_t       new_entity          /* the new entity split from `old_entity' */
);


/* PK_ATTDEF_merge_callback_f_t */

typedef void    (*PK_ATTDEF_merge_callback_f_t)
(
PK_ENTITY_t       live_entity,        /* the entity that will survive the merge */
int               n_live_attribs,     /* number of attribs on `live_entity' */
const PK_ATTRIB_t live_attribs[],     /* attribs on `live_entity' */
PK_ENTITY_t       doomed_entity,      /* the entity that will not survive the */
int               n_doomed_attribs,   /* number of attribs on `doomed_entity' */
const PK_ATTRIB_t doomed_attribs[]    /* attribs on `doomed_entity' */
);


/* PK_ATTDEF_delete_callback_f_t */

typedef void    (*PK_ATTDEF_delete_callback_f_t)
(
PK_ENTITY_t       entity,             /* entity to be deleted */
int               n_attribs,          /* number of attribs on `entity' */
const PK_ATTRIB_t attribs[]           /* attribs on `entity' */
);


/* PK_ATTDEF_copy_callback_f_t */

typedef void    (*PK_ATTDEF_copy_callback_f_t)
(
PK_ENTITY_t       old_entity,         /* pre-existing entity */
int               n_attribs,          /* number of attribs on `old_entity' */
const PK_ATTRIB_t attribs[],          /* attribs on `old_entity' */
PK_ENTITY_t       new_entity          /* the new copy of `old_entity' */
);


/* PK_ATTDEF_transmit_callback_f_t */

typedef void    (*PK_ATTDEF_transmit_callback_f_t)
(
PK_ENTITY_t       entity,             /* entity to be transmitted */
int               n_attribs,          /* number of attribs on `entity */
const PK_ATTRIB_t attribs[]           /* attribs on `entity' */
);


/* PK_ATTDEF_receive_callback_f_t */

typedef void    (*PK_ATTDEF_receive_callback_f_t)
(
PK_ENTITY_t       entity,             /* entity which has been received */
int               n_attribs,          /* number of attribs on `entity' */
const PK_ATTRIB_t attribs[]           /* attribs on `entity' */
);


/* PK_ATTDEF_callback_fns_t */

typedef struct PK_ATTDEF_callback_fns_s
    {
    PK_ATTDEF_split_callback_f_t    split_fn;     /* split callback function */
    PK_ATTDEF_merge_callback_f_t    merge_fn;     /* merge callback function */
    PK_ATTDEF_delete_callback_f_t   delete_fn;    /* delete callback function */
    PK_ATTDEF_copy_callback_f_t     copy_fn;      /* copy callback function */
    PK_ATTDEF_transmit_callback_f_t transmit_fn;  /* transmit callback function */
    PK_ATTDEF_receive_callback_f_t  receive_fn;   /* receive callback function */
    }
    PK_ATTDEF_callback_fns_t;



/* PK_ATTDEF_callback_flags_t */


typedef struct PK_ATTDEF_callback_flags_s
    {
    PK_LOGICAL_t split_callback_on;
    PK_LOGICAL_t merge_callback_on;
    PK_LOGICAL_t delete_callback_on;
    PK_LOGICAL_t copy_callback_on;
    PK_LOGICAL_t transmit_callback_on;
    PK_LOGICAL_t receive_callback_on;
    }
    PK_ATTDEF_callback_flags_t;



/* PK_ATTDEF_name_cb_f_t */

typedef const char   *(*PK_ATTDEF_name_cb_f_t)
(
/* received */
const PK_ATTDEF_sf_2_t * /*attdef_sf*/, /* attribute definition standard form */
PK_POINTER_t             /*context*/    /* context */
);



/* PK_ATTDEF_name_cb_t */

typedef PK_ATTDEF_name_cb_f_t PK_ATTDEF_name_cb_t;


/* PK_ATTDEF_register_cb_o_t */

struct PK_ATTDEF_register_cb_o_s
    {
    int                       o_t_version;
    PK_ATTDEF_callback_type_t callback_type;    /* normal or read_only */
    };

typedef struct PK_ATTDEF_register_cb_o_s
               PK_ATTDEF_register_cb_o_t;



/* PK_ATTDEF_register_cb_o_m */

#define PK_ATTDEF_register_cb_o_m(options)                   \
    (                                                        \
       (options).o_t_version = 1,                            \
       (options).callback_type = PK_ATTDEF_callback_normal_c \
    )


/* PK_GROUP_find_entities_o_t */

struct PK_GROUP_find_entities_o_s
    {
    int          o_t_version;        /* version number */
    PK_LOGICAL_t want_entities;      /* return entities (PK_LOGICAL_true) */
    PK_LOGICAL_t have_entity_label;  /* whether entity label provided */
    int          entity_label;       /* only find entities with this label (0) */
    };
typedef struct PK_GROUP_find_entities_o_s PK_GROUP_find_entities_o_t;



/* PK_GROUP_find_entities_o_m */

#define PK_GROUP_find_entities_o_m(options)             \
    ((options).o_t_version       = 1,                   \
     (options).want_entities     = PK_LOGICAL_true,     \
     (options).have_entity_label = PK_LOGICAL_false,    \
     (options).entity_label      = 0)


/* PK_FACE_grow_cb_f_t */

typedef void     (*PK_FACE_grow_cb_f_t)
(
/* received */
int                 /*n_faces1*/,     /* number of faces1 */
const PK_FACE_t     /*faces1*/[],     /* first set of clashing faces */
int                 /*n_faces2*/,     /* number of faces2 */
const PK_FACE_t     /*faces2*/[],     /* second set of clashing faces */
int                 /*n_site*/,       /* number of site faces */
const PK_FACE_t     /*site*/[],       /* faces where the clash occurs */
PK_POINTER_t        /*context*/,      /* context for callback */
/* returned */
PK_FACE_grow_cb_t * /*grow*/            /* grow option */
);


/* PK_FACE_trim_cb_f_t */

typedef void     (*PK_FACE_trim_cb_f_t)
(
/* received */
int                 /*n_faces1*/,     /* number of faces1 */
const PK_FACE_t     /*faces1*/[],     /* first set of clashing faces */
int                 /*n_faces2*/,     /* number of faces2 */
const PK_FACE_t     /*faces2*/[],     /* second set of clashing faces */
int                 /*n_site*/,       /* number of site faces */
const PK_FACE_t     /*site*/[],       /* faces where the clash occurs */

PK_POINTER_t        /*context*/,      /* context for callback */
/* returned */
PK_FACE_trim_cb_t * /*trim*/          /* trim option */
);


/* PK_BODY_add_to_compound_o_t */

struct PK_BODY_add_to_compound_o_s
    {
    int                     o_t_version;   /* version number */
    PK_compound_geom_attr_t geom_attr;     /* controls behaviour with regard */
    PK_LOGICAL_t            report_shared_geometry;
    };
typedef struct PK_BODY_add_to_compound_o_s PK_BODY_add_to_compound_o_t;



/* PK_BODY_add_to_compound_o_m */

#define PK_BODY_add_to_compound_o_m(options)                  \
    (                                                         \
       (options).o_t_version = 1,                             \
       (options).geom_attr   = PK_compound_geom_attr_keep_c,  \
       (options).report_shared_geometry = PK_LOGICAL_false    \
    )


/* PK_BODY_copy_topology_o_t */

struct PK_BODY_copy_topology_o_s
    {
    int                    o_t_version;         /* version number */
    PK_CLASS_array_t       tracked_classes;     /* which topological classes */
    PK_LOGICAL_t           retain_tolerances;   /* whether to retain tolerances */
    PK_LOGICAL_t           retain_attributes;   /* whether to retain attributes */
    PK_LOGICAL_t           retain_groups;       /* whether to retain groups */

    };
typedef struct PK_BODY_copy_topology_o_s PK_BODY_copy_topology_o_t;



/* PK_BODY_copy_topology_o_m */

#define PK_BODY_copy_topology_o_m(options)                                \
    (                                                                     \
       (options).o_t_version             = 1,                             \
       (options).tracked_classes.length  = 0,                             \
       (options).tracked_classes.array   = NULL,                          \
       (options).retain_tolerances       = PK_LOGICAL_false,              \
       (options).retain_attributes       = PK_LOGICAL_false,              \
       (options).retain_groups           = PK_LOGICAL_false               \
    )


/* PK_BODY_repair_shells_o_t */

struct PK_BODY_repair_shells_o_s
    {
    int                        o_t_version;  /* version number */
    PK_BODY_type_t             body_type;    /* preferred body type */
    PK_SHELL_repair_tracking_t tracking;     /* whether to return tracking */
    };
typedef struct PK_BODY_repair_shells_o_s PK_BODY_repair_shells_o_t;



/* PK_BODY_repair_shells_o_m */

#define PK_BODY_repair_shells_o_m(options)                            \
    (                                                                 \
       (options).o_t_version       = 1,                               \
       (options).body_type         = PK_BODY_type_unspecified_c,      \
       (options).tracking          = PK_SHELL_repair_tracking_no_c    \
    )


/* PK_BODY_remove_from_parents_o_t */

struct PK_BODY_remove_from_parents_o_s
    {
    int                    o_t_version;         /* version number */
    };
typedef struct PK_BODY_remove_from_parents_o_s PK_BODY_remove_from_parents_o_t;



/* PK_BODY_remove_from_parents_o_m */

#define PK_BODY_remove_from_parents_o_m(options)                          \
    (                                                                     \
       (options).o_t_version             = 1                              \
    )


/* PK_BODY_make_compound_o_t */

struct PK_BODY_make_compound_o_s
    {
    int                     o_t_version;   /* version number */
    PK_compound_geom_attr_t geom_attr;     /* controls behaviour with regard */
    PK_LOGICAL_t            report_shared_geometry;
    };
typedef struct PK_BODY_make_compound_o_s PK_BODY_make_compound_o_t;



/* PK_BODY_make_compound_o_m */

#define PK_BODY_make_compound_o_m(options)                    \
    (                                                         \
       (options).o_t_version = 3,                             \
       (options).geom_attr   = PK_compound_geom_attr_keep_c,  \
       (options).report_shared_geometry = PK_LOGICAL_false    \
    )


/* PK_BODY_ask_parent_o_t */

struct PK_BODY_ask_parent_o_s
    {
    int                    o_t_version;         /* version number */
    };
typedef struct PK_BODY_ask_parent_o_s PK_BODY_ask_parent_o_t;



/* PK_BODY_ask_parent_o_m */

#define PK_BODY_ask_parent_o_m(options)                    \
    (                                                      \
    (options).o_t_version = 1                              \
    )


/* PK_BODY_ask_children_o_t */

struct PK_BODY_ask_children_o_s
    {
    int                    o_t_version;         /* version number */
    };
typedef struct PK_BODY_ask_children_o_s PK_BODY_ask_children_o_t;



/* PK_BODY_ask_children_o_m */

#define PK_BODY_ask_children_o_m(options)                  \
    (                                                      \
    (options).o_t_version = 1                              \
    )


/* PK_BODY_fix_blends_o_t */

struct PK_BODY_fix_blends_o_s
    {
    int                    o_t_version;     /* version number of option */
    PK_LOGICAL_t           local_check;     /* whether to perform local */
    PK_LOGICAL_t           vx_twin;         /* return vertex tag for vertex */
    PK_blend_local_check_t checks;          /* which local checks to perform */
    PK_blend_setback_data_t
                           setback_data;    /* data defining any setbacks */
    PK_blend_transfer_topol_t
                           transfer;        /* whether to move topology to */
    PK_blend_fix_propagate_t
                           propagate;       /* whether to propagate */
    PK_blend_vx_blend_data_t
                           vx_blend_data;   /* data defining any vertex */
    PK_blend_y_blend_data_t
                           y_blend_data;    /* data defining any y-shaped */
    PK_LOGICAL_t           preserve_notch;  /* retain notch shape */
    PK_blend_edge_update_t update;          /* update flag */
    double                 tolerance;       /* maximum allowed tolerance for */
    PK_blend_set_tol_t     set_tol;         /* controls when a tolerance is */
    PK_blend_repair_su_X_t repair_su_X;     /* whether to attempt to repair */
    PK_blend_output_sheet_t
                           output_sheet;    /* whether to create a blend */
    PK_blend_inside_tight_t
                           inside_tight;    /* whether to blend on the inside */
    PK_blend_vx_order_data_t
                           vx_order_data;   /* order to apply blends at */
    PK_blend_setback_shape_data_t
                           setback_shape_data;
    PK_blend_ov_smooth_t    ov_smooth;      /* allow smooth overlap between */
    PK_blend_ov_notch_t     ov_notch;       /* allow notch overlap between */
    PK_blend_order_t        ov_order;       /* order to apply non-adjacent */
    PK_blend_repair_fa_X_t  repair_fa_X;    /* whether to attempt to repair */
    int                     n_explicit_cliff_edges;
    PK_EDGE_t              *explicit_cliff_edges;
    PK_blend_ov_exp_cliff_t
                           *explicit_cliff_edges_type;
    PK_PARTITION_t          partition;      /* a partition */
    PK_blend_cap_data_t     cap_data;       /* controls how a blend will be */
    PK_blend_tolerance_t    improve_tolerance;
    PK_blend_track_type_t   tracking_type;  /* controls the type of tracking */
    PK_blend_laminar_trim_t laminar_trim;   /* controls how the blend will be */
    PK_blend_limit_data_t    limit_data;    /* data defining any limits */
    PK_TOPOL_array_t         limit_topols;  /* limit faces/fins */
    PK_blend_limit_patch_t  *limit_topols_patch;
    const PK_TOPOL_array_t  *limit_topols_unders;
    PK_blend_suggest_limit_t suggest_limit; /* controls whether or not */
    PK_blend_report_repaired_t
                             report;        /* whether to report any repaired */
    PK_extension_shape_t     extension_shape;

    };

typedef struct PK_BODY_fix_blends_o_s PK_BODY_fix_blends_o_t;



/* PK_BODY_fix_blends_o_m */

#define PK_BODY_fix_blends_o_m(options)                                 \
    (                                                                   \
       (options).o_t_version = 30,                                      \
       (options).local_check = PK_LOGICAL_false,                        \
       (options).vx_twin     = PK_LOGICAL_false,                        \
       PK_blend_local_check_m((options).checks),                        \
       PK_blend_setback_data_m((options).setback_data),                 \
       (options).transfer    = PK_blend_transfer_topol_no_c,            \
       PK_blend_fix_propagate_m((options).propagate),                   \
       PK_blend_vx_blend_data_m((options).vx_blend_data),               \
       PK_blend_y_blend_data_m((options).y_blend_data),                 \
       (options).preserve_notch     = PK_LOGICAL_false,                 \
       (options).update             = PK_blend_edge_update_default_c,   \
       (options).tolerance          = 1.0e-05,                          \
       (options).set_tol       = PK_blend_set_tol_yes_c,                \
       (options).repair_su_X   = PK_blend_repair_su_X_no_c,             \
       (options).output_sheet  = PK_blend_output_sheet_no_c,            \
       (options).inside_tight = PK_blend_inside_tight_blends_c,         \
       PK_blend_vx_order_data_m((options).vx_order_data),               \
       PK_blend_setback_shape_data_m((options).setback_shape_data),     \
       (options).ov_smooth   = PK_blend_ov_smooth_no_c,                 \
       (options).ov_notch    = PK_blend_ov_notch_yes_c,                 \
       (options).ov_order    = PK_blend_order_convex_concave_c,         \
       (options).repair_fa_X = PK_blend_repair_fa_X_no_c,               \
       (options).n_explicit_cliff_edges = 0,                            \
       (options).explicit_cliff_edges = NULL,                           \
       (options).explicit_cliff_edges_type = NULL,                      \
       (options).partition   = PK_PARTITION_null,                       \
       PK_blend_cap_data_m((options).cap_data),                         \
       (options).improve_tolerance = PK_blend_tolerance_standard_c,     \
       (options).tracking_type = PK_blend_track_type_basic_c,           \
       (options).laminar_trim = PK_blend_laminar_trim_edges_c,          \
       PK_blend_limit_data_m((options).limit_data),                     \
       (options).limit_topols.length = 0,                               \
       (options).limit_topols.array = NULL,                             \
       (options).limit_topols_patch = NULL,                             \
       (options).limit_topols_unders = NULL,                            \
       (options).suggest_limit = PK_blend_suggest_limit_no_c,           \
       (options).report = PK_blend_report_repaired_no_c,                \
       (options).extension_shape      = PK_extension_shape_linear_c     \
    )


/* PK_BODY_check_o_t */

struct PK_BODY_check_o_s
    {
    int                       o_t_version;  /* version number of option */
    int                       max_faults;   /* limit on fault numbers (10) */
    PK_check_geom_t           geom;         /* bad geometry */
    PK_check_bgeom_t          bgeom;        /* bad B geometry */
    PK_check_top_geo_t        top_geo;      /* topology/geometry inconsistency */
    PK_check_size_box_t       size_box;     /* size box violation */
    PK_check_fa_X_t           fa_X;         /* face self intersection */
    PK_check_loops_t          loops;        /* loop checks */
    PK_check_fa_fa_t          fa_fa;        /* face face inconsistency */
    PK_check_sh_t             sh;           /* negated or inconsistent shells */
    PK_check_corrupt_t        corrupt;      /* corrupt data or identifiers */
    PK_check_nmnl_geom_t      nmnl_geom;    /* bad nominal geometry */
    PK_check_returns_t        returns;      /* return version of fault info */
    PK_check_extra_faults_t   extra_faults; /* expand PK_BODY_state_corrupt_c */
    PK_check_attribs_t        attribs;      /* check for validity of system */
    };

typedef struct PK_BODY_check_o_s PK_BODY_check_o_t;



/* PK_BODY_check_o_m */

#define PK_BODY_check_o_m(options)                             \
    (                                                          \
       (options).o_t_version    = 4,                           \
       (options).max_faults     = 10,                          \
       (options).geom           = PK_check_geom_yes_c,         \
       (options).bgeom          = PK_check_bgeom_yes_c,        \
       (options).top_geo        = PK_check_top_geo_yes_c,      \
       (options).size_box       = PK_check_size_box_yes_c,     \
       (options).fa_X           = PK_check_fa_X_yes_c,         \
       (options).loops          = PK_check_loops_yes_c,        \
       (options).fa_fa          = PK_check_fa_fa_yes_c,        \
       (options).sh             = PK_check_sh_yes_c,           \
       (options).corrupt        = PK_check_corrupt_yes_c,      \
       (options).nmnl_geom      = PK_check_nmnl_geom_yes_c,    \
       (options).returns        = PK_check_returns_0_c,        \
       (options).extra_faults   = PK_check_extra_faults_0_c,   \
       (options).attribs        = PK_check_attribs_no_c       \
    )


/* PK_BODY_create_sheet_planar_o_t */

struct PK_BODY_create_sheet_planar_o_s
    {
    int                    o_t_version;     /* version number (1) */
    const int             *loops;           /* loop numbers (NULL) */
    PK_AXIS1_sf_t          plane;           /* plane (XY plane) */
    PK_AXIS2_sf_t          basis_set;       /* local coordinate system */
    };
typedef struct PK_BODY_create_sheet_planar_o_s PK_BODY_create_sheet_planar_o_t;



/* PK_BODY_create_sheet_planar_o_m */

#define PK_BODY_create_sheet_planar_o_m(options)          \
    (                                                     \
        (options).o_t_version = 1,                        \
        (options).loops = NULL,                           \
        (options).plane.location.coord[0] = 0.0,          \
        (options).plane.location.coord[1] = 0.0,          \
        (options).plane.location.coord[2] = 0.0,          \
        (options).plane.axis.coord[0] = 0.0,              \
        (options).plane.axis.coord[1] = 0.0,              \
        (options).plane.axis.coord[2] = 1.0,              \
        (options).basis_set.location.coord[0] = 0.0,      \
        (options).basis_set.location.coord[1] = 0.0,      \
        (options).basis_set.location.coord[2] = 0.0,      \
        (options).basis_set.axis.coord[0] = 0.0,          \
        (options).basis_set.axis.coord[1] = 0.0,          \
        (options).basis_set.axis.coord[2] = 1.0,          \
        (options).basis_set.ref_direction.coord[0] = 1.0, \
        (options).basis_set.ref_direction.coord[1] = 0.0, \
        (options).basis_set.ref_direction.coord[2] = 0.0  \
    )


/* PK_emboss_sidewall_data_t */

struct PK_emboss_sidewall_data_s
    {
    PK_emboss_sidewall_t        sidewall;    /* how to construct sidewall */
    PK_taper_method_t           taper_method;
    PK_VECTOR1_t                draw_direction;
    double                      taper_angle; /* taper angle of tapered sidewall */
    double                      offset;      /* value for offset taper */
    PK_SURF_t                   top_surface; /* top surface for offset taper */
    PK_BODY_t                   sidewall_body;
    int                         n_multi_taper_edges;
    const PK_EDGE_t             *multi_taper_edges;
    const double                *multi_taper_angles;

    };
typedef struct PK_emboss_sidewall_data_s PK_emboss_sidewall_data_t;


/* PK_emboss_sidewall_data_m */

#define PK_emboss_sidewall_data_m(data)                                     \
      ((data).sidewall                  = PK_emboss_sidewall_swept_c,       \
       (data).taper_method              = PK_taper_method_isocline_c,       \
       (data).draw_direction.coord[0]   = 0.0,                              \
       (data).draw_direction.coord[1]   = 0.0,                              \
       (data).draw_direction.coord[2]   = 1.0,                              \
       (data).taper_angle               = 0.0,                              \
       (data).offset                    = 0.0,                              \
       (data).top_surface               = PK_ENTITY_null,                   \
       (data).sidewall_body             = PK_ENTITY_null,                   \
       (data).n_multi_taper_edges       = 0,                                \
       (data).multi_taper_edges         = NULL,                             \
       (data).multi_taper_angles        = NULL                              \
      )


/* PK_emboss_overflow_data_t */

struct PK_emboss_overflow_data_s
    {
    PK_emboss_overflow_t        interior_overflow;
    PK_emboss_overflow_t        laminar_overflow;
    PK_VECTOR1_t                sweep_direction;
    PK_LOGICAL_t                laminar_walled;
    };
typedef struct PK_emboss_overflow_data_s PK_emboss_overflow_data_t;


/* PK_emboss_overflow_data_m */

#define PK_emboss_overflow_data_m(data)                                     \
      ((data).interior_overflow         = PK_emboss_overflow_added_c,       \
       (data).laminar_overflow          = PK_emboss_overflow_swept_c,       \
       (data).sweep_direction.coord[0]  = 0.0,                              \
       (data).sweep_direction.coord[1]  = 0.0,                              \
       (data).sweep_direction.coord[2]  = 1.0,                              \
       (data).laminar_walled            = PK_LOGICAL_false                  \
      )


/* PK_BODY_emboss_o_t */

struct PK_BODY_emboss_o_s
    {
    int                        o_t_version; /* version number of options */
    double                     tolerance;   /* operation tolerance */
    PK_emboss_convexity_t      convexity;   /* convexity of emboss to be */
    PK_emboss_profile_on_t     profile_on;  /* where profile lives */
    PK_emboss_sidewall_data_t  sidewall_data;
    PK_emboss_overflow_data_t  overflow_data;
    PK_emboss_unite_sidewall_t unite;       /* whether to unite sidewall faces */
    PK_local_ops_update_t      update;      /* update flag */
    };
typedef struct PK_BODY_emboss_o_s PK_BODY_emboss_o_t;


/* PK_BODY_emboss_o_m */

#define PK_BODY_emboss_o_m(options)                                         \
       ((options).o_t_version       = 4,                                    \
        (options).tolerance         = 1.0e-5,                               \
        (options).convexity         = PK_emboss_convexity_both_c,           \
        (options).profile_on        = PK_emboss_profile_on_any_c,           \
        PK_emboss_sidewall_data_m((options).sidewall_data),                 \
        PK_emboss_overflow_data_m((options).overflow_data),                 \
        (options).unite             = PK_emboss_unite_sidewall_yes_c,       \
        (options).update            = PK_local_ops_update_default_c         \
       )


/* PK_extend_side_data_t */

struct PK_extend_side_data_s
    {
    int                 n_vertices;    /* number of vertices */
    const PK_VERTEX_t  *vertices;      /* terminal vertices of the */
    const PK_extend_side_t
                       *extend_sides;
};

typedef struct PK_extend_side_data_s PK_extend_side_data_t;



/* PK_extend_side_data_m */

#define PK_extend_side_data_m(extend_side_data)                        \
     (                                                                 \
       (extend_side_data).n_vertices          = 0,                     \
       (extend_side_data).vertices            = NULL,                  \
       (extend_side_data).extend_sides        = NULL                   \
      )


/* PK_BODY_extend_o_t */

struct PK_BODY_extend_o_s
    {
    int                  o_t_version;    /* version number */
    PK_LOGICAL_t         modify;         /* whether to modify the original */
    PK_extension_shape_t extension_shape;
    PK_BODY_extension_t  extension_type; /* the type of the extension */
    double               extension_distance;
    PK_ENTITY_t          target;         /* target body or surface to define */
    PK_extension_limit_t target_limit;   /* defines how the target controls */
    PK_extension_smoothness_t
                         preserve_internal_smoothness;
    PK_extend_track_type_t
                         track_type;     /* how to track new laminar edges */
    PK_extend_track_internal_t
                         track_internal; /* whether to track new internal edges */
    PK_extend_create_t   extend_create;  /* how extension topology is created */
    PK_extension_boundary_t
                         extension_boundary;
    PK_extend_side_data_t
                         extend_side_data;
    PK_extend_side_t     extend_side;    /* How to create side edges at any */
    PK_local_ops_update_t
                         update;         /* update flag */

    };
typedef struct PK_BODY_extend_o_s PK_BODY_extend_o_t;



/* PK_BODY_extend_o_m */

#define PK_BODY_extend_o_m(options)                                           \
  (                                                                           \
     (options).o_t_version                  = 9,                              \
     (options).modify                       = PK_LOGICAL_false,               \
     (options).extension_shape              = PK_extension_shape_linear_c,    \
     (options).extension_type               = PK_BODY_extension_distance_c,   \
     (options).extension_distance           = 0,                              \
     (options).preserve_internal_smoothness = PK_extension_smoothness_g0_c,   \
     (options).track_type                   = PK_extend_track_type_basic_c,   \
     (options).track_internal               = PK_extend_track_internal_no_c,  \
     (options).target                       = PK_ENTITY_null,                 \
     (options).target_limit                 = PK_extension_limit_minimal_c,   \
     (options).extend_create                = PK_extend_create_new_c,         \
     (options).extension_boundary           = PK_extension_boundary_precise_c,\
      PK_extend_side_data_m( (options).extend_side_data),                     \
     (options).extend_side                  = PK_extend_side_default_c,       \
     (options).update                       = PK_local_ops_update_default_c   \
  )


/* PK_bound_def_t */

struct PK_bound_def_s
    {
    PK_bound_t        bound;         /* method of defining bound */
    PK_LOGICAL_t      forward;       /* whether bound in positive sense of path */
    double            distance;      /* extrusion distance */
    PK_ENTITY_t       entity;        /* bounding entity */
    PK_LOGICAL_t      nearest;       /* whether divisions are numbered from */
    int               nth_division;  /* select nth division */
    PK_bound_side_t   side;          /* which side is the first division if */
    };
typedef struct PK_bound_def_s PK_bound_def_t;



/* PK_BODY_extrude_o_t */

struct PK_BODY_extrude_o_s
    {
    int            o_t_version;      /* options structure version number */
    PK_bound_def_t start_bound;      /* starting bound of swept body */
    PK_bound_def_t end_bound;        /* ending bound of swept body */
    PK_BODY_t      extruded_body;    /* body to use instead of swept profile */
    PK_LOGICAL_t   allow_disjoint;   /* swept body can have a disjoint division */
    };
typedef struct PK_BODY_extrude_o_s PK_BODY_extrude_o_t;



/* PK_BODY_extrude_o_m */

#define PK_BODY_extrude_o_m(options)                                          \
    (                                                                         \
       (options).o_t_version              = 4,                                \
       (options).start_bound.bound        = PK_bound_distance_c,              \
       (options).start_bound.forward      = PK_LOGICAL_true,                  \
       (options).start_bound.distance     = 0.0,                              \
       (options).start_bound.entity       = PK_ENTITY_null,                   \
       (options).start_bound.nearest      = PK_LOGICAL_true,                  \
       (options).start_bound.nth_division = 1,                                \
       (options).start_bound.side         = PK_bound_side_both_c,             \
       (options).end_bound  .bound        = PK_bound_distance_c,              \
       (options).end_bound  .forward      = PK_LOGICAL_true,                  \
       (options).end_bound  .distance     = 1.0,                              \
       (options).end_bound  .entity       = PK_ENTITY_null,                   \
       (options).end_bound  .nearest      = PK_LOGICAL_true,                  \
       (options).end_bound  .nth_division = 1,                                \
       (options).end_bound  .side         = PK_bound_side_both_c,             \
       (options).extruded_body            = PK_ENTITY_null,                   \
       (options).allow_disjoint           = PK_LOGICAL_false                  \
    )


/* PK_fill_hole_clamp_planar_t */

struct PK_fill_hole_clamp_planar_s
    {
    PK_LOGICAL_t    have_normal;
    PK_VECTOR1_t    normal;
    };

typedef struct PK_fill_hole_clamp_planar_s PK_fill_hole_clamp_planar_t;



/* PK_fill_hole_clamp_planar_m */

#define PK_fill_hole_clamp_planar_m(planar_clamp)           \
    (                                                       \
        (planar_clamp).have_normal      = PK_LOGICAL_false, \
        (planar_clamp).normal.coord[0]  = 0.0,              \
        (planar_clamp).normal.coord[1]  = 0.0,              \
        (planar_clamp).normal.coord[2]  = 0.0               \
    )


/* PK_fill_hole_deriv_conds_t */

struct PK_fill_hole_deriv_conds_s
    {
    PK_fill_hole_clamp_t        type;
    PK_fill_hole_clamp_planar_t planar_clamp;
    };

typedef struct PK_fill_hole_deriv_conds_s PK_fill_hole_deriv_conds_t;



/* PK_fill_hole_deriv_conds_m */

#define PK_fill_hole_deriv_conds_m(deriv_conds)                     \
    (                                                               \
        (deriv_conds).type = PK_fill_hole_clamp_no_c,               \
        PK_fill_hole_clamp_planar_m( (deriv_conds).planar_clamp )   \
    )


/* PK_fill_hole_point_data_t */

struct PK_fill_hole_point_data_s
    {
    int                     n_points;
    PK_VECTOR_t            *points;
    PK_VECTOR_t            *normals;
    double                  points_tolerance;
    };

typedef struct PK_fill_hole_point_data_s PK_fill_hole_point_data_t;



/* PK_fill_hole_point_data_m */

#define PK_fill_hole_point_data_m(point_data)                       \
    (                                                               \
        (point_data).n_points = 0,                                  \
        (point_data).points = NULL,                                 \
        (point_data).normals = NULL,                                \
        (point_data).points_tolerance = 0.0                         \
    )


/* PK_BODY_fill_hole_o_t */

struct PK_BODY_fill_hole_o_s
    {
    int                       o_t_version;
    PK_fill_hole_method_t     method;     /* method to use to fill hole */
    PK_BODY_t                 fill_sheet; /* sheet body to patch hole */
    PK_check_fa_fa_t          check_fa_fa;
    PK_LOGICAL_t              attach_sheet;
    PK_fill_hole_preference_t fill_preference;
    PK_continuity_t           smoothness; /* allows control over the level of */
    PK_EDGE_array_t           non_smooth_edges;
    PK_EDGE_array_t           non_g2_smooth_edges;
    PK_fill_hole_non_smooth_t non_g2_behaviour;
    PK_fill_hole_update_t     update;     /* update version */
    PK_fill_hole_topol_t      patch_topology;
    PK_fill_hole_body_type_t  body_type;  /* preferred type of resulting body */
    PK_BODY_array_t           supporting_bodies;
    PK_fill_hole_imprint_t    imprint_supporting_bodies;
    int                       n_clamps;   /* number of clamps to be applied to */
    const PK_fill_hole_deriv_conds_t
                             *clamps;     /* array of clamps to be applied to */
    const int                *clamp_indices;
    PK_fill_hole_patch_eds_t  internal_smoothness;
    PK_fill_hole_opt_t        optimise;   /* how to optimise the algorithm */
    int                       n_supporting_point_sets;
    PK_fill_hole_point_data_t
                             *supporting_point_sets;
    };
typedef struct PK_BODY_fill_hole_o_s PK_BODY_fill_hole_o_t;



/* PK_BODY_fill_hole_o_m */

#define PK_BODY_fill_hole_o_m(options)                                      \
    (                                                                       \
       (options).o_t_version               = 12,                            \
       (options).method                    = PK_fill_hole_trim_to_hole_c,   \
       (options).fill_sheet                = PK_ENTITY_null,                \
       (options).check_fa_fa               = PK_check_fa_fa_yes_c,          \
       (options).attach_sheet              = PK_LOGICAL_true,               \
       (options).fill_preference           = PK_fill_hole_smooth_c,         \
       (options).smoothness                = PK_continuity_g1_c,            \
       (options).non_smooth_edges.length   = 0,                             \
       (options).non_smooth_edges.array    = NULL,                          \
       (options).non_g2_smooth_edges.length= 0,                             \
       (options).non_g2_smooth_edges.array = NULL,                          \
       (options).non_g2_behaviour          = PK_fill_hole_non_smooth_fail_c,\
       (options).update                    = PK_fill_hole_update_default_c, \
       (options).patch_topology            = PK_fill_hole_topol_multiple_c, \
       (options).body_type                 = PK_fill_hole_body_type_orig_c, \
       (options).supporting_bodies.length  = 0,                             \
       (options).supporting_bodies.array   = NULL,                          \
       (options).imprint_supporting_bodies = PK_fill_hole_imprint_sharp_c,  \
       (options).n_clamps                  = 0,                             \
       (options).clamps                    = NULL,                          \
       (options).clamp_indices             = NULL,                          \
       (options).internal_smoothness       = PK_fill_hole_patch_eds_sharp_c,\
       (options).optimise                  = PK_fill_hole_opt_quality_c,    \
       (options).n_supporting_point_sets   = 0,                             \
       (options).supporting_point_sets     = NULL                           \
    )


/* PK_BODY_hollow_o_t */

struct PK_BODY_hollow_o_s
    {
    int                o_t_version;     /* version number of option structure */
    int                n_pierce_faces;  /* number of faces in `pierce_faces' */
    const PK_FACE_t   *pierce_faces;    /* faces to be pierced (not offset) */
    PK_check_fa_fa_t   check_fa_fa;     /* check for face-face inconsistencies */
    int                n_offset_faces;  /* number of elements in `offset_faces' */
    const PK_FACE_t   *offset_faces;    /* faces to be offset by a different */
    const double      *offset_values;   /* offset values for corresponding */
    PK_LOGICAL_t       pierce_tangent;  /* DEPRECATED (PK_LOGICAL_false) */
    PK_offset_method_t offset_method;   /* offset method */
    PK_LOGICAL_t       report_sx;       /* whether to report faces that have */
    PK_fix_degens_t    fix_degens;      /* control on repairing surface */
    PK_LOGICAL_t       report_fix_degens;
    PK_offset_step_t   offset_step;     /* whether to create a step offset */
    PK_hollow_local_t  hollow_local;    /* method of local hollowing */
    int                n_local_faces;   /* number of faces for local hollowing */
    const PK_FACE_t   *local_faces;     /* faces for local hollowing */
    PK_EDGE_offset_blend_t
                       blend_edges;     /* Offset edges as blend faces */
    double             blend_radius;    /* Radius of blend faces created if */
    PK_FACE_grow_t     grow;            /* controls which faces to grow */
    PK_FACE_grow_cb_f_t
                       grow_cb;         /* user callback function for */
    PK_POINTER_t       grow_data;       /* user data for callback function */
    PK_local_ops_update_t
                       update;          /* update flag */
    };
typedef struct PK_BODY_hollow_o_s PK_BODY_hollow_o_t;


/* PK_BODY_hollow_o_m */

#define PK_BODY_hollow_o_m(options)                                   \
       ((options).o_t_version       = 11,                             \
        (options).n_pierce_faces    = 0,                              \
        (options).pierce_faces      = NULL,                           \
        (options).check_fa_fa       = PK_check_fa_fa_yes_c,           \
        (options).n_offset_faces    = 0,                              \
        (options).offset_faces      = NULL,                           \
        (options).offset_values     = NULL,                           \
        (options).pierce_tangent    = PK_LOGICAL_false,               \
        (options).offset_method     = PK_offset_method_sx_trim_c,     \
        (options).fix_degens        = PK_fix_degens_no_c,             \
        (options).report_sx         = PK_LOGICAL_false,               \
        (options).report_fix_degens = PK_LOGICAL_false,               \
        (options).offset_step       = PK_offset_step_no_c,            \
        (options).n_local_faces     = 0,                              \
        (options).local_faces       = NULL,                           \
        (options).hollow_local      = PK_hollow_local_none_c,         \
        (options).blend_edges       = PK_EDGE_offset_blend_no_c,      \
        (options).blend_radius      = 0.0,                            \
        (options).grow              = PK_FACE_grow_update_c,          \
        (options).grow_cb           = NULL,                           \
        (options).grow_data         = NULL,                           \
        (options).update            = PK_local_ops_update_default_c   \
       )


/* PK_BODY_identify_facesets_o_t */

struct PK_BODY_identify_facesets_o_s
    {
    int                     o_t_version;     /* version number of option struct */
    PK_boolean_function_t   function;        /* (PK_boolean_unite_c) */
    PK_boolean_fence_t      fence;           /* (PK_boolean_fence_none_c) */
    PK_LOGICAL_t            check_manifold;  /* (PK_LOGICAL_true) */
    };

typedef struct PK_BODY_identify_facesets_o_s PK_BODY_identify_facesets_o_t;



/* PK_BODY_identify_facesets_o_m */

#define PK_BODY_identify_facesets_o_m(options)            \
    (                                                     \
       (options).o_t_version    = 2,                      \
       (options).function       = PK_boolean_unite_c,     \
       (options).fence          = PK_boolean_fence_none_c,\
       (options).check_manifold = PK_LOGICAL_true         \
    )


/* PK_identify_facesets_r_t */

struct PK_identify_facesets_r_s
    {
    int                n_survive_target_faces;  /* number of surviving */
    PK_FACE_array_t   *survive_target_faces;    /* surviving facesets */
    int                n_survive_tool_faces;    /* number of surviving */
    PK_FACE_array_t   *survive_tool_faces;      /* surviving facesets */
    int                n_reject_target_faces;   /* number of rejected */
    PK_FACE_array_t   *reject_target_faces;     /* rejected facesets */
    int                n_reject_tool_faces;     /* number of rejected */
    PK_FACE_array_t   *reject_tool_faces;       /* rejected facesets */
    PK_EDGE_array_t    bound_target_edges;      /* bounds of facesets */
    PK_EDGE_array_t    bound_tool_edges;        /* bounds of facesets */
    };
typedef struct PK_identify_facesets_r_s PK_identify_facesets_r_t;




/* PK_BODY_identify_details_o_t */

struct PK_BODY_identify_details_o_s
    {
    int                    o_t_version;        /* version number of opt struct */
    PK_double_constraint_t hole_cyl_radius;    /* radius constraint for */
    PK_hole_blended_t      hole_blended;       /* whether to include blend */
    PK_double_constraint_t hole_blend_radius;  /* radius constraint for blends */
    PK_hole_update_t       hole_update;        /* update version */
    PK_hole_const_rad_t    hole_const_rad;     /* whether holes must have a */
    PK_hole_ortho_t        hole_ortho;         /* whether hole components must */
    PK_detail_perforated_t hole_perforated;    /* whether holes can be */
    PK_detail_open_t       hole_open;          /* whether holes can be open */
    double                 tolerance;          /* distance tolerance */
    double                 angle_tolerance;    /* angle tolerance ( radians ) */
    };

typedef struct PK_BODY_identify_details_o_s PK_BODY_identify_details_o_t;



/* PK_BODY_identify_details_o_m */

#define PK_BODY_identify_details_o_m(options)                     \
    (                                                             \
       (options).o_t_version      = 5,                            \
        PK_double_constraint_m( (options).hole_cyl_radius ),      \
       (options).hole_blended     = PK_hole_blended_no_c,         \
        PK_double_constraint_m( (options).hole_blend_radius ),    \
       (options).hole_update      = PK_hole_update_default_c,     \
       (options).hole_const_rad   = PK_hole_const_rad_no_c,       \
       (options).hole_ortho       = PK_hole_ortho_no_c,           \
       (options).hole_perforated  = PK_detail_perforated_no_c,    \
       (options).hole_open        = PK_detail_open_no_c,          \
       (options).tolerance        = 0.00000001,                   \
       (options).angle_tolerance  = 0.00000000001                 \
    )


/* PK_identify_details_r_t */

struct PK_identify_details_r_s
    {
    int                n_facesets;  /* number of facesets */
    PK_FACE_array_t   *facesets;    /* facesets */
    PK_detail_t       *details;     /* detail type of each faceset */
    };
typedef struct PK_identify_details_r_s PK_identify_details_r_t;



/* PK_BODY_identify_general_o_t */

struct PK_BODY_identify_general_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BODY_identify_general_o_s PK_BODY_identify_general_o_t;



/* PK_BODY_identify_general_o_m */

#define PK_BODY_identify_general_o_m(options)                              \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_identify_general_r_t */

struct PK_identify_general_r_s
    {
    int                n_general;   /* number of general characteristics */
    PK_general_t      *type;        /* type of each general characteristic */
    PK_TOPOL_t        *topol;       /* associated topology */
    };
typedef struct PK_identify_general_r_s PK_identify_general_r_t;



/* PK_BODY_find_facesets_o_t */

struct PK_BODY_find_facesets_o_s
    {
    int                  o_t_version;        /* version number of option struct */
    PK_boolean_region_t  selector;           /* faceset selector */
    PK_LOGICAL_t         alternate;          /* whether to return alternating */
    int                  n_selecting_topol;  /* no of selecting topologies (0) */
    PK_TOPOL_t          *selecting_topol;    /* selecting topologies (NULL) */
    PK_LOGICAL_t         want_bounds;        /* whether to return bounding */
    };

typedef struct PK_BODY_find_facesets_o_s PK_BODY_find_facesets_o_t;



/* PK_BODY_find_facesets_o_m */

#define PK_BODY_find_facesets_o_m(options)                        \
    (                                                             \
       (options).o_t_version       = 1,                           \
       (options).selector          = PK_boolean_off_c,            \
       (options).alternate         = PK_LOGICAL_false,            \
       (options).n_selecting_topol = 0,                           \
       (options).selecting_topol   = NULL,                        \
       (options).want_bounds       = PK_LOGICAL_false             \
    )


/* PK_BODY_find_facesets_r_t */

struct PK_BODY_find_facesets_r_s
    {
    int               n_selected_facesets;       /* number of returned facesets */
    PK_FACE_array_t  *selected_facesets;         /* returned facesets */
    PK_EDGE_array_t  *bound_edgesets;            /* edgesets bounding every */
    };
typedef struct PK_BODY_find_facesets_r_s PK_BODY_find_facesets_r_t;



/* PK_BODY_find_extreme_o_t */

struct PK_BODY_find_extreme_o_s
    {
    int                  o_t_version;        /* version number of option struct */
    };

typedef struct PK_BODY_find_extreme_o_s PK_BODY_find_extreme_o_t;



/* PK_BODY_find_extreme_o_m */

#define PK_BODY_find_extreme_o_m(options)                         \
    (                                                             \
       (options).o_t_version       = 1                            \
    )


/* PK_BODY_imprint_cus_normal_o_t */

struct PK_BODY_imprint_cus_normal_o_s
    {
    int           o_t_version;              /* version number */
    PK_imprint_complete_t
                  imprint_complete;         /* whether to complete imprint on */
    PK_imprint_tracking_t
                  tracking_type;            /* format of returned tracking */
    PK_imprint_proj_dist_t
                  use_max_projection_dist;  /* whether and how to limit */
    double        max_projection_dist;      /* ( 0.0 ) */
    PK_LOGICAL_t  imprint_coi_exactly;      /* whether to imprint curves */
    PK_continuity_t
                  preferred_continuity;     /* level of continuity to impose */


    };
typedef struct PK_BODY_imprint_cus_normal_o_s
               PK_BODY_imprint_cus_normal_o_t;



/* PK_BODY_imprint_cus_normal_o_m */

#define PK_BODY_imprint_cus_normal_o_m(options)                        \
    (                                                                  \
       (options).o_t_version             = 6,                          \
       (options).imprint_complete        = PK_imprint_complete_no_c,   \
       (options).tracking_type           = PK_imprint_tracking_basic_c,\
       (options).use_max_projection_dist = PK_imprint_proj_dist_no_c,  \
       (options).max_projection_dist     = 0.0,                        \
       (options).imprint_coi_exactly     = PK_LOGICAL_false,           \
       (options).preferred_continuity    = PK_continuity_g1_c          \
    )


/* PK_BODY_imprint_cus_vector_o_t */

struct PK_BODY_imprint_cus_vector_o_s
    {
    int                 o_t_version;   /* version number of option structure */
    };
typedef struct PK_BODY_imprint_cus_vector_o_s
               PK_BODY_imprint_cus_vector_o_t;



/* PK_BODY_imprint_cus_vector_o_m */

#define PK_BODY_imprint_cus_vector_o_m(options)                      \
    (                                                                \
       (options).o_t_version           = 1                           \
    )


/* PK_BODY_imprint_cus_vec_o_t */

struct PK_BODY_imprint_cus_vec_o_s
    {
    int                    o_t_version;      /* version number */
    PK_imprint_connect_t   connect;          /* How to connect disjoint */
    PK_imprint_complete_t  imprint_complete; /* whether to complete imprint */
    PK_LOGICAL_t           imprint_coi_exactly;
    PK_LOGICAL_t           imprint_exactly;  /* whether to imprint curves */
    PK_LOGICAL_t           bidirectional;    /* whether to imprint curves */
    PK_imprint_intersect_t process_intersections;
    };
typedef struct PK_BODY_imprint_cus_vec_o_s
               PK_BODY_imprint_cus_vec_o_t;



/* PK_BODY_imprint_cus_vec_o_m */

#define PK_BODY_imprint_cus_vec_o_m(options)                            \
    (                                                                   \
       (options).o_t_version            = 6,                            \
       (options).connect                = PK_imprint_connect_none_c,    \
       (options).imprint_complete       = PK_imprint_complete_no_c,     \
       (options).imprint_coi_exactly    = PK_LOGICAL_false,             \
       (options).imprint_exactly        = PK_LOGICAL_false,             \
       (options).bidirectional          = PK_LOGICAL_false,             \
       (options).process_intersections  = PK_imprint_intersect_update_c \
    )


/* PK_BODY_imprint_cus_shadow_o_t */

struct PK_BODY_imprint_cus_shadow_o_s
    {
    int                   o_t_version;         /* version number */
    double                tolerance;           /* curve tolerance (1.0e-5) */
    PK_LOGICAL_t          want_edges;          /* whether to return new edges */
    PK_LOGICAL_t          want_visible_faces;  /* whether to return visible */
    PK_shadow_check_fa_t  check_faces;         /* check modified faces for */
    };
typedef struct PK_BODY_imprint_cus_shadow_o_s
               PK_BODY_imprint_cus_shadow_o_t;



/* PK_BODY_imprint_cus_shadow_o_m */

#define PK_BODY_imprint_cus_shadow_o_m( opt )                           \
    (   (opt).o_t_version               = 2,                            \
        (opt).want_edges                = PK_LOGICAL_false,             \
        (opt).want_visible_faces        = PK_LOGICAL_false,             \
        (opt).tolerance                 = 0.00001,                      \
        (opt).check_faces               = PK_shadow_check_fa_no_c)


/* PK_BODY_loft_one_match_t */

#define PK_BODY_loft_one_match_t PK_BODY_one_vertex_match_t



/* PK_BODY_loft_one_match_m */

#define PK_BODY_loft_one_match_m PK_BODY_one_vertex_match_m



/* PK_BODY_profile_match_t */

#define PK_BODY_profile_match_t PK_BODY_vertex_match_t



/* PK_BODY_profile_match_m */

#define PK_BODY_profile_match_m PK_BODY_vertex_match_m



/* PK_BODY_loft_matches_t */

#define PK_BODY_loft_matches_t PK_BODY_vertex_matches_t



/* PK_BODY_loft_matches_m */

#define PK_BODY_loft_matches_m PK_BODY_vertex_matches_m



/* PK_BODY_loft_vector_clamp_t */

struct PK_BODY_loft_vector_clamp_s
    {
    int                n_tangents;    /* number of derivative vectors (0) */
    const PK_VECTOR_t *tangents;      /* array of derivative vectors (NULL) */
    int                n_vertices;    /* number of vertices to be clamped (0) */
    const PK_VERTEX_t *vertices;      /* array of vertices to be clamped (NULL) */
    int                n_magnitudes;  /* number of vector magnitudes (0) */
    const double      *magnitudes;    /* array of vector magnitudes (NULL) */
    };

typedef struct PK_BODY_loft_vector_clamp_s PK_BODY_loft_vector_clamp_t;



/* PK_BODY_loft_vector_clamp_m */

#define PK_BODY_loft_vector_clamp_m(vector_clamp)                        \
    (                                                                    \
       (vector_clamp).n_tangents   = 0,                                  \
       (vector_clamp).tangents     = NULL,                               \
       (vector_clamp).n_vertices   = 0,                                  \
       (vector_clamp).vertices     = NULL,                               \
       (vector_clamp).n_magnitudes = 0,                                  \
       (vector_clamp).magnitudes   = NULL                                \
    )


/* PK_BODY_loft_face_clamp_t */

struct PK_BODY_loft_face_clamp_s
    {
    int                n_faces;      /* number of clamping faces and clamped */
    const PK_FACE_t   *faces;        /* array of clamping faces (NULL) */
    const PK_EDGE_t   *edges;        /* array of clamped edges (NULL) */
    int                n_magnitudes; /* number of magnitudes for scaling loft */
    const double      *magnitudes;   /* array of magnitudes for scaling loft */
    int                n_vertices;   /* number of vertices with scaling (0) */
    const PK_VERTEX_t *vertices;     /* array of vertices with scaling (NULL) */
    };

typedef struct PK_BODY_loft_face_clamp_s PK_BODY_loft_face_clamp_t;



/* PK_BODY_loft_face_clamp_m */

#define PK_BODY_loft_face_clamp_m(face_clamp)                       \
    (                                                               \
       (face_clamp).n_faces         = 0,                            \
       (face_clamp).faces           = NULL,                         \
       (face_clamp).edges           = NULL,                         \
       (face_clamp).n_magnitudes    = 0,                            \
       (face_clamp).magnitudes      = NULL,                         \
       (face_clamp).n_vertices      = 0,                            \
       (face_clamp).vertices        = NULL                          \
    )


/* PK_BODY_loft_planar_clamp_t */

struct PK_BODY_loft_planar_clamp_s
    {
    PK_VECTOR1_t    normal;
    double          magnitude;
    };

typedef struct PK_BODY_loft_planar_clamp_s PK_BODY_loft_planar_clamp_t;



/* PK_BODY_loft_planar_clamp_m */

#define PK_BODY_loft_planar_clamp_m(planar_clamp)                   \
    (                                                               \
       (planar_clamp).normal.coord[0] = 0.0,                        \
       (planar_clamp).normal.coord[1] = 0.0,                        \
       (planar_clamp).normal.coord[2] = 0.0,                        \
       (planar_clamp).magnitude       = 0.0                         \
    )


/* PK_BODY_loft_deriv_conds_t */

struct PK_BODY_loft_deriv_conds_s
    {
    PK_BODY_loft_curvature_t          curvature_condition;
    PK_BODY_loft_clamp_type_t         type;
    PK_BODY_loft_vector_clamp_t       vector_clamp;
    PK_BODY_loft_face_clamp_t         face_clamp;
    PK_BODY_loft_planar_clamp_t       planar_clamp;
    };

typedef struct PK_BODY_loft_deriv_conds_s PK_BODY_loft_deriv_conds_t;



/* PK_BODY_loft_deriv_conds_m */

#define PK_BODY_loft_deriv_conds_m(deriv_conds)                          \
    (                                                                    \
       (deriv_conds).curvature_condition = PK_BODY_loft_unconstrained_c, \
       (deriv_conds).type                = PK_BODY_loft_clamp_no_c,      \
       PK_BODY_loft_vector_clamp_m( (deriv_conds).vector_clamp ),        \
       PK_BODY_loft_face_clamp_m( (deriv_conds).face_clamp ),            \
       PK_BODY_loft_planar_clamp_m( (deriv_conds).planar_clamp )         \
    )


/* PK_BODY_loft_end_conds_t */

struct PK_BODY_loft_end_conds_s
    {
    PK_PARAM_periodic_t         periodic;
    PK_BODY_loft_deriv_conds_t  start,
                                end;
    };

typedef struct PK_BODY_loft_end_conds_s PK_BODY_loft_end_conds_t;



/* PK_BODY_loft_end_conds_m */

#define PK_BODY_loft_end_conds_m(end_conds)                          \
    (                                                                \
       (end_conds).periodic = PK_PARAM_periodic_no_c,                \
       PK_BODY_loft_deriv_conds_m( (end_conds).start ),              \
       PK_BODY_loft_deriv_conds_m( (end_conds).end )                 \
    )


/* PK_BODY_make_lofted_body_o_t */

struct PK_BODY_make_lofted_body_o_s
    {
    int                               o_t_version;
    PK_BODY_loft_end_conds_t          end_conditions;

    int                               n_guide_wires;

    const PK_BODY_t                  *guide_wires;

    PK_BODY_simplify_t                simplify;
    PK_BODY_topology_t                topology_form;
    PK_BODY_vertex_matches_t          matches;

    int                               n_intermediate_derivs;
    const PK_BODY_loft_deriv_conds_t *intermediate_derivs;
    const int                        *intermediate_profiles;

    int                               n_guide_derivs;
    const PK_BODY_loft_deriv_conds_t *guide_derivs;
    const int                        *guide_indices;
    double                            tolerance;
    PK_LOGICAL_t                      minimise_tolerance;
    PK_BODY_loft_update_t             update;
    PK_BODY_loft_deriv_mag_t          deriv_mag;
    PK_LOGICAL_t                      want_edge_tracking;
    PK_BODY_smoothness_t              profile_smoothness;
    PK_LOGICAL_t                      create_construction_topol;
    PK_LOGICAL_t                      label_profiles;
    };

typedef struct PK_BODY_make_lofted_body_o_s PK_BODY_make_lofted_body_o_t;



/* PK_BODY_make_lofted_body_o_m */

#define PK_BODY_make_lofted_body_o_m(options)                                 \
    (                                                                         \
       (options).o_t_version               = 15,                              \
       PK_BODY_loft_end_conds_m( (options).end_conditions ),                  \
       (options).n_guide_wires             = 0,                               \
       (options).guide_wires               = NULL,                            \
       (options).simplify                  = PK_BODY_simplify_analytic_c,     \
       (options).topology_form             = PK_BODY_topology_minimal_c,      \
       PK_BODY_vertex_matches_m( (options).matches ),                         \
       (options).n_intermediate_derivs     = 0,                               \
       (options).intermediate_derivs       = NULL,                            \
       (options).intermediate_profiles     = NULL,                            \
       (options).n_guide_derivs            = 0,                               \
       (options).guide_derivs              = NULL,                            \
       (options).guide_indices             = NULL,                            \
       (options).tolerance                 = 1.0e-5,                          \
       (options).minimise_tolerance        = PK_LOGICAL_false,                \
       (options).update                    = PK_BODY_loft_update_default_c,   \
       (options).deriv_mag                 = PK_BODY_loft_deriv_mag_single_c, \
       (options).want_edge_tracking        = PK_LOGICAL_false,                \
       (options).profile_smoothness        = PK_BODY_smoothness_exact_c,      \
       (options).create_construction_topol = PK_LOGICAL_false,                \
       (options).label_profiles            = PK_LOGICAL_false                 \
    )


/* PK_BODY_loft_status_r_t */

struct PK_BODY_loft_status_r_s
    {
    PK_BODY_loft_fault_t         fault;
    PK_VECTOR_t                  fault_location;
    PK_TOPOL_t                   fault_topol;
    };

typedef struct PK_BODY_loft_status_r_s PK_BODY_loft_status_r_t;



/* PK_BODY_tracked_loft_r_t */

struct PK_BODY_tracked_loft_s
    {
    PK_BODY_loft_status_r_t      status;
    PK_BODY_t                    body;
    PK_TOPOL_track_r_t           tracking_info;
    };

typedef struct PK_BODY_tracked_loft_s PK_BODY_tracked_loft_r_t;



/* PK_BODY_make_curves_outline_o_t */

struct PK_BODY_make_curves_outline_o_s
    {
    int                   o_t_version;      /* version number */
    PK_outline_project_t  project;          /* whether to project the curves */
    PK_VECTOR_t           project_position; /* position of plane if projecting */
    double                tolerance;        /* curve tolerance (1.0e-6) */
    PK_LOGICAL_t          want_topols;      /* whether to return edges or faces */
    PK_outline_update_t   update;           /* update flag */
    PK_LOGICAL_t          want_body;        /* whether to create a body from */
    PK_TOPOL_dimension_t  body_dimension;   /* whether to request a body of */
    PK_outline_edge_on_t  edge_on;          /* whether an outline is created */
    };
typedef struct PK_BODY_make_curves_outline_o_s PK_BODY_make_curves_outline_o_t;



/* PK_BODY_make_curves_outline_o_m */



#define PK_BODY_make_curves_outline_o_m( opt)                          \
    (   (opt).o_t_version               = 4,                           \
        (opt).project                   = PK_outline_project_no_c,     \
        (opt).project_position.coord[0] = 0.0,                         \
        (opt).project_position.coord[1] = 0.0,                         \
        (opt).project_position.coord[2] = 0.0,                         \
        (opt).tolerance                 = 1.0e-6,                      \
        (opt).want_topols               = PK_LOGICAL_false,            \
        (opt).update                    = PK_outline_update_default_c, \
        (opt).want_body                 = PK_LOGICAL_false,            \
        (opt).body_dimension            = PK_TOPOL_dimension_1_c,      \
        (opt).edge_on                   = PK_outline_edge_on_none_c )


/* PK_BODY_make_spun_outline_o_t */

struct PK_BODY_make_spun_outline_o_s
    {
    int                   o_t_version;      /* version number */
    PK_outline_project_t  project;           /* whether to project the curves */
    PK_VECTOR_t           project_position;  /* position of plane if projecting */
    double                tolerance;         /* curve tolerance (1.0e-6) */
    PK_LOGICAL_t          want_topols;       /* (PK_LOGICAL_t) */
    PK_outline_update_t   update;            /* update flag */
    PK_LOGICAL_t          want_body;         /* whether to create a body from */
    PK_TOPOL_dimension_t  body_dimension;    /* whether to request a body of */
    };
typedef struct PK_BODY_make_spun_outline_o_s PK_BODY_make_spun_outline_o_t;



/* PK_BODY_make_spun_outline_o_m */


#define PK_BODY_make_spun_outline_o_m( opt)                            \
    (   (opt).o_t_version               = 3,                           \
        (opt).project                   = PK_outline_project_no_c,     \
        (opt).project_position.coord[0] = 0.0,                         \
        (opt).project_position.coord[1] = 0.0,                         \
        (opt).project_position.coord[2] = 0.0,                         \
        (opt).tolerance                 = 1.0e-6,                      \
        (opt).want_topols               = PK_LOGICAL_false,            \
        (opt).update                    = PK_outline_update_default_c, \
        (opt).want_body                 = PK_LOGICAL_false,            \
        (opt).body_dimension            = PK_TOPOL_dimension_1_c )


/* PK_BODY_taper_o_t */

struct PK_BODY_taper_o_s
    {
    int                      o_t_version;    /* version number of option */
    double                   tolerance;      /* max. tol. for applying */
    PK_LOGICAL_t             miter_at_parting;
    PK_LOGICAL_t             merge_face;     /* whether tapered faces */
    PK_check_fa_fa_t         check_fa_fa;    /* check for face-face */
    PK_taper_method_t        default_method; /* default tapering method */
    int                      n_methods;      /* number of non-default */
    const PK_taper_method_t *methods;        /* non-default tapering */
    const PK_ENTITY_t       *method_refs;    /* reference entities to use */
    PK_taper_corner_type_t   corner_type;    /* how to fill the gap at the */
    int                      n_parting_edges;
    const PK_ENTITY_t       *parting_edges;  /* all the edges lying on the */
    PK_taper_miter_type_t    miter_type;     /* how to miter the halves */
    int                      n_non_miter_edges;
    const PK_EDGE_t         *non_miter_edges;
    int                      n_replace_edges;
    const PK_EDGE_t         *replace_edges;  /* edges to be removed to allow */
    PK_taper_undercut_t      undercut;       /* how to cope with undercut */
    int                      n_upper_faces;  /* number of upper faces (0) */
    const PK_FACE_t         *upper_faces;    /* faces to be tapered from */
    int                      n_lower_faces;  /* number of lower faces (0) */
    const PK_FACE_t         *lower_faces;    /* faces to be tapered from */
    PK_taper_concave_type_t  concave_type;   /* how to replace the concave */
    double                   concave_radius; /* radius of the cylinder for */
    PK_taper_keep_material_t keep_material;  /* how to process regions */
    PK_local_ops_update_t    update;         /* update flag */
    };
typedef struct PK_BODY_taper_o_s PK_BODY_taper_o_t;


/* PK_BODY_taper_o_m */

#define PK_BODY_taper_o_m(options)                                      \
       ((options).o_t_version          = 11,                            \
        (options).tolerance            = 1.0e-5,                        \
        (options).miter_at_parting     = PK_LOGICAL_true,               \
        (options).merge_face           = PK_LOGICAL_true,               \
        (options).check_fa_fa          = PK_check_fa_fa_yes_c,          \
        (options).default_method       = PK_taper_method_isocline_c,    \
        (options).n_methods            = 0,                             \
        (options).methods              = NULL,                          \
        (options).method_refs          = NULL,                          \
        (options).corner_type          = PK_taper_corner_extend_c,      \
        (options).n_parting_edges      = 0,                             \
        (options).parting_edges        = NULL,                          \
        (options).miter_type           = PK_taper_miter_on_ref_c,       \
        (options).n_non_miter_edges    = 0,                             \
        (options).non_miter_edges      = NULL,                          \
        (options).n_replace_edges      = 0,                             \
        (options).replace_edges        = NULL,                          \
        (options).undercut             = PK_taper_undercut_ref_no_c,    \
        (options).n_upper_faces        = 0,                             \
        (options).upper_faces          = NULL,                          \
        (options).n_lower_faces        = 0,                             \
        (options).lower_faces          = NULL,                          \
        (options).concave_type         = PK_taper_concave_none_c,       \
        (options).concave_radius       = 0.0,                           \
        (options).keep_material        = PK_taper_keep_material_no_c,   \
        (options).update               = PK_local_ops_update_default_c  \
       )


/* PK_BODY_trim_neutral_sheets_o_t */

struct PK_BODY_trim_neutral_sheets_o_s
    {
    int                      o_t_version;
    PK_neutral_ignore_fa_t   ignore;       /* whether to ignore faces in */
    PK_neutral_trim_method_t trim_method;  /* method of trimming neutral */
    PK_neutral_overlap_t     overlap;      /* how to deal with overlaps in */
    PK_LOGICAL_t             extend_and_fill_holes;
    PK_local_ops_update_t    update;       /* update flag */
    };

typedef struct PK_BODY_trim_neutral_sheets_o_s
    PK_BODY_trim_neutral_sheets_o_t;




/* PK_BODY_trim_neutral_sheets_o_m */

#define PK_BODY_trim_neutral_sheets_o_m(options) \
    (                                   \
       (options).o_t_version = 5,        \
       (options).ignore = PK_neutral_ignore_fa_default_c,        \
       (options).trim_method = PK_neutral_trim_method_sheets_c,      \
       (options).overlap = PK_neutral_overlap_no_c,      \
       (options).extend_and_fill_holes = PK_LOGICAL_false,      \
       (options).update = PK_local_ops_update_default_c       \
    )


/* PK_FACE_neutral_causes_t */


struct PK_FACE_neutral_causes_s
    {
    PK_FACE_t    neutral_face;    /* Face in neutral sheet. */
    int          n_faces_back;    /* Number of faces compressed onto */
    PK_FACE_t   *faces_back;      /* Set of faces compressed onto */
    int          n_faces_front;   /* Number of faces compressed onto */
    PK_FACE_t   *faces_front;     /* Set of faces compressed onto */
    };
typedef struct PK_FACE_neutral_causes_s PK_FACE_neutral_causes_t;




/* PK_FACE_neutral_causes_array_t */


struct PK_FACE_neutral_causes_array_s
    {
    int          n_causes;     /* Number of face causes in array */
    PK_FACE_neutral_causes_t
                *face_causes;  /* Set of face causes */
    };
typedef struct PK_FACE_neutral_causes_array_s PK_FACE_neutral_causes_array_t;




/* PK_FACE_set_pair_t */


struct PK_FACE_set_pair_s
    {
    int          n_faces1;    /* Number of faces in first set */
    PK_FACE_t   *faces1;      /* First set of faces */
    int          n_faces2;    /* Number of faces in second set */
    PK_FACE_t   *faces2;      /* Second set of faces */
    PK_BODY_t    sheet;       /* Sheet to be trimmed */
    PK_LOGICAL_t sheet_pretrimmed;
    };
typedef struct PK_FACE_set_pair_s PK_FACE_set_pair_t;




/* PK_BODY_offset_o_t */

struct PK_BODY_offset_o_s
    {
    int                o_t_version;     /* version number of option structure */
    PK_LOGICAL_t       allow_disjoint;  /* whether disjoint body can be */
    PK_check_fa_fa_t   check_fa_fa;     /* check for face-face inconsistencies */
    int                n_offset_faces;  /* number of elements in `offset_faces' */
    const PK_FACE_t   *offset_faces;    /* faces to be offset by a different */
    const double      *offset_values;   /* offset values for corresponding */
    PK_offset_method_t offset_method;   /* offset method */
    PK_LOGICAL_t       report_sx;       /* whether to report faces that have */
    PK_fix_degens_t    fix_degens;      /* control on repairing surface */
    PK_LOGICAL_t       report_fix_degens;
    PK_offset_step_t   offset_step;     /* whether to create a step offset */
    PK_LOGICAL_t       ortho_vx_split;  /* Split laminar vertices during offset */
    PK_offset_track_del_t
                       track_del;       /* How to track deleted faces */
    PK_EDGE_offset_blend_t
                       blend_edges;     /* Offset edges as blend faces */
    double             blend_radius;    /* Radius of blend faces created if */
    PK_FACE_grow_t     grow;            /* controls which faces to grow */
    PK_VERTEX_limit_t  vertex_limit;    /* How to constrain the maximum */
    PK_EDGE_limit_t    edge_limit;      /* How to constrain the maximum */
    PK_local_ops_update_t
                       update;          /* update flag */
    };
typedef struct PK_BODY_offset_o_s PK_BODY_offset_o_t;


/* PK_BODY_offset_o_m */

#define PK_BODY_offset_o_m(options)                                   \
       ((options).o_t_version       = 12,                             \
        (options).allow_disjoint    = PK_LOGICAL_false,               \
        (options).check_fa_fa       = PK_check_fa_fa_yes_c,           \
        (options).n_offset_faces    = 0,                              \
        (options).offset_faces      = NULL,                           \
        (options).offset_values     = NULL,                           \
        (options).offset_method     = PK_offset_method_sx_trim_c,     \
        (options).fix_degens        = PK_fix_degens_no_c,             \
        (options).report_sx         = PK_LOGICAL_false,               \
        (options).report_fix_degens = PK_LOGICAL_false,               \
        (options).offset_step       = PK_offset_step_no_c,            \
        (options).ortho_vx_split    = PK_LOGICAL_false,               \
        (options).track_del         = PK_offset_track_del_no_c,       \
        (options).blend_edges       = PK_EDGE_offset_blend_no_c,      \
        (options).blend_radius      = 0.0,                            \
        (options).grow              = PK_FACE_grow_update_c,          \
        (options).vertex_limit      = PK_VERTEX_limit_no_c,           \
        (options).edge_limit        = PK_EDGE_limit_no_c,             \
        (options).update            = PK_local_ops_update_default_c   \
       )


/* PK_BODY_offset_planar_wire_o_t */

struct PK_BODY_offset_planar_wire_o_s
    {
    int             o_t_version;      /* version number */
    PK_BODY_owb_gap_fill_t            /* how gaps at vertices are filled */
                    gap_fill;         /* (PK_BODY_owb_gap_fill_round_c) */
    PK_LOGICAL_t    local_check;      /* whether to perform local checks */
    double          tolerance;        /* tolerance for curve conversion (0) */
    PK_double_constraint_t
                    gap_fill_angle;   /* angular constraint to determine */
    PK_BODY_owb_gap_fill_t            /* how gaps at vertices are filled */
                    constrained_gap_fill;
    PK_LOGICAL_t    repair_self_int;  /* whether to repair self */
    PK_LOGICAL_t    allow_disjoint;   /* whether the returned body can be */

    };

typedef struct PK_BODY_offset_planar_wire_o_s PK_BODY_offset_planar_wire_o_t;



/* PK_BODY_offset_planar_wire_o_m */

#define PK_BODY_offset_planar_wire_o_m(options)                            \
    (                                                                      \
    (options).o_t_version                  = 2,                            \
    (options).gap_fill                     = PK_BODY_owb_gap_fill_round_c, \
    (options).local_check                  = PK_LOGICAL_false,             \
    (options).tolerance                    = 0,                            \
    (options).gap_fill_angle.comparison    = PK_comparison_never_c,        \
    (options).gap_fill_angle.interval.value[0] = 0,                        \
    (options).gap_fill_angle.interval.value[1] = 0,                        \
    (options).constrained_gap_fill         = PK_BODY_owb_gap_fill_round_c, \
    (options).repair_self_int              = PK_LOGICAL_false,             \
    (options).allow_disjoint               = PK_LOGICAL_false              \
    )


/* PK_BODY_pick_topols_o_t */

struct PK_BODY_pick_topols_o_s
    {
    int                        o_t_version;  /* version number */

    int                          max_faces;  /* max number of faces required */
    int                          max_edges;  /* max number of edges required */
    int                       max_vertices;  /* max number of vertices required */

    PK_LOGICAL_t                near_plane;  /* whether set */
    PK_LOGICAL_t                 far_plane;  /* whether set */

    PK_LOGICAL_t        is_curve_chord_tol;
    double                 curve_chord_tol;
    PK_LOGICAL_t        is_curve_chord_max;
    double                 curve_chord_max;
    PK_LOGICAL_t        is_curve_chord_ang;
    double                 curve_chord_ang;
    PK_LOGICAL_t         ignore_back_faces;  /* face picking optimisation */

    PK_LOGICAL_t    ignore_excess_entities;  /* face picking optimisation */

    double                   max_edge_dist;  /* max distance between ray/edges */

    double                 max_vertex_dist;  /* max dist between ray/vertices */

    PK_VECTOR_t                 near_point;  /* point on near_plane */
    PK_VECTOR_t                  far_point;  /* point on far_plane */

    PK_BODY_pick_method_t           method;  /* method of measuring pick dist */

    double                           ratio;  /* bias when measuring pick dist */

    int                     n_geom_classes;  /* specify the number of */

    PK_CLASS_t               *geom_classes;  /* specify the geometry classes */

    PK_pick_approximate_t      pick_approx;  /* approximate curves */
    };
typedef struct PK_BODY_pick_topols_o_s PK_BODY_pick_topols_o_t;



/* PK_BODY_pick_topols_o_m */


#define PK_BODY_pick_topols_o_m( opt)                                   \
    (   (opt).o_t_version         = 4,                                  \
        (opt).max_faces           = 1,                                  \
        (opt).max_edges           = 0,                                  \
        (opt).max_vertices        = 0,                                  \
        (opt).near_plane          = PK_LOGICAL_false,                   \
        (opt).far_plane           = PK_LOGICAL_false,                   \
        (opt).is_curve_chord_tol  = PK_LOGICAL_false,                   \
        (opt).curve_chord_tol     = 0.0,                                \
        (opt).is_curve_chord_max  = PK_LOGICAL_false,                   \
        (opt).curve_chord_max     = 0.0,                                \
        (opt).is_curve_chord_ang  = PK_LOGICAL_false,                   \
        (opt).curve_chord_ang     = 0.0,                                \
        (opt).ignore_back_faces   = PK_LOGICAL_true,                    \
        (opt).ignore_excess_entities   = PK_LOGICAL_false,              \
        (opt).max_edge_dist       = 0.0,                                \
        (opt).max_vertex_dist     = 0.0,                                \
        (opt).near_point.coord[0] =                                     \
        (opt).near_point.coord[1] =                                     \
        (opt).near_point.coord[2] = 0.0,                                \
        (opt).far_point.coord[0]  =                                     \
        (opt).far_point.coord[1]  =                                     \
        (opt).far_point.coord[2]  = 0.0,                                \
        (opt).method              = PK_BODY_pick_axial_c,               \
        (opt).ratio               = 0.0,                                \
        (opt).n_geom_classes      = 0,                                  \
        (opt).geom_classes        = NULL,                               \
        (opt).pick_approx         = PK_pick_approximate_yes_c           \
    )


/* PK_BODY_pick_topol_r_t */

struct PK_BODY_pick_topol_r_s
       {
       PK_ENTITY_t  entity;
       int          occurence;
       PK_VECTOR_t  intersect;
       double       distance;
       };
typedef struct PK_BODY_pick_topol_r_s
               PK_BODY_pick_topol_r_t;


/* PK_BODY_pick_topols_r_t */

struct PK_BODY_pick_topols_r_s
    {
    int                     n_faces;
    PK_BODY_pick_topol_r_t *faces;
    int                     e_faces;

    int                     n_edges;
    PK_BODY_pick_topol_r_t *edges;
    int                     e_edges;

    int                     n_vertices;
    PK_BODY_pick_topol_r_t *vertices;
    int                     e_vertices;
    };
typedef struct PK_BODY_pick_topols_r_s PK_BODY_pick_topols_r_t;



/* PK_BODY_problem_group_t */

struct PK_BODY_problem_group_s
    {
    PK_BODY_sewing_problem_t     type;
    PK_EDGE_t                   *edges;
    int                          n_edges;
    };

typedef struct PK_BODY_problem_group_s PK_BODY_problem_group_t;




/* PK_BODY_problem_group_array_t */

struct PK_BODY_problem_group_array_s
    {
    PK_BODY_problem_group_t  *array;
    int                       length;
    };

typedef struct PK_BODY_problem_group_array_s PK_BODY_problem_group_array_t;




/* PK_BODY_sew_bodies_o_t */

struct PK_BODY_sew_bodies_o_s
    {
    int                   o_t_version;
    PK_LOGICAL_t          set_global_tolerance;  /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          allow_disjoint_result; /* (PK_LOGICAL_false) */
    PK_LOGICAL_t          treat_as_manifold;     /* (PK_LOGICAL_true) */
    PK_BODY_sewing_type_t prefered_body_type;    /* (PK_BODY_sewing_any_c) */
    PK_BODY_sewing_removal_t
                          duplicate_removal;  /* (PK_BODY_sewing_remove_none_c) */
    int                   number_of_iterations;  /* (1) */
    double               *iteration_bounds;      /* (NULL) */
    PK_BODY_sewing_assy_t assembly_sewing;       /* (PK_BODY_sewing_assy_no_c) */
    PK_BODY_sewing_gen_t  general_sewing;        /* (PK_BODY_sewing_gen_no_c) */
    PK_LOOP_sew_up_t      sew_up_inner_loops;    /* (PK_LOOP_sew_up_loop_c) */
    };

typedef struct PK_BODY_sew_bodies_o_s PK_BODY_sew_bodies_o_t;



/* PK_BODY_sew_bodies_o_m */

#define PK_BODY_sew_bodies_o_m(options)                                \
    (                                                                  \
       (options).o_t_version           = 7,                            \
       (options).set_global_tolerance  = PK_LOGICAL_false,             \
       (options).allow_disjoint_result = PK_LOGICAL_false,             \
       (options).treat_as_manifold     = PK_LOGICAL_true,              \
       (options).prefered_body_type    = PK_BODY_sewing_any_c,         \
       (options).duplicate_removal     = PK_BODY_sewing_remove_none_c, \
       (options).number_of_iterations  = 1,                            \
       (options).iteration_bounds      = NULL,                         \
       (options).assembly_sewing       = PK_BODY_sewing_assy_no_c,     \
       (options).general_sewing        = PK_BODY_sewing_gen_no_c,      \
       (options).sew_up_inner_loops    = PK_LOOP_sew_up_loop_c  \
    )


/* PK_BODY_knit_pattern_t */

struct PK_BODY_knit_pattern_s
    {
    int                          n_edges;
    PK_EDGE_t                   *edges;
    PK_EDGE_t                   *matches;
    int                          n_reversals;
    PK_BODY_t                   *reversals;
    };

typedef struct PK_BODY_knit_pattern_s PK_BODY_knit_pattern_t;



/* PK_BODY_knit_result_t */

struct PK_BODY_knit_result_s
    {
    int                          n_unknit_edges;
    PK_EDGE_t                   *unknit_edges;
    PK_BODY_knit_status_t        status;
    };

typedef struct PK_BODY_knit_result_s PK_BODY_knit_result_t;



/* PK_BODY_find_knit_pattern_o_t */

struct PK_BODY_find_knit_pattern_o_s
    {
    int                      o_t_version;
    };

typedef struct PK_BODY_find_knit_pattern_o_s PK_BODY_find_knit_pattern_o_t;



/* PK_BODY_find_knit_pattern_o_m */

#define PK_BODY_find_knit_pattern_o_m(options)                         \
    (                                                                  \
       (options).o_t_version           = 1                             \
    )


/* PK_BODY_apply_knit_pattern_o_t */

struct PK_BODY_apply_knit_pattern_o_s
    {
    int                      o_t_version;
    PK_BODY_sewing_type_t    body_type;              /* (PK_BODY_sewing_any_c) */
    PK_LOGICAL_t             sort_face_shells;       /* (PK_LOGICAL_true) */
    PK_LOGICAL_t             close_marginal_gaps;    /* (PK_LOGICAL_true) */
    };

typedef struct PK_BODY_apply_knit_pattern_o_s PK_BODY_apply_knit_pattern_o_t;



/* PK_BODY_apply_knit_pattern_o_m */

#define PK_BODY_apply_knit_pattern_o_m(options)                        \
    (                                                                  \
       (options).o_t_version           = 2,                            \
       (options).body_type             = PK_BODY_sewing_any_c,         \
       (options).sort_face_shells      = PK_LOGICAL_true,               \
       (options).close_marginal_gaps   = PK_LOGICAL_true               \
    )


/* PK_BODY_knit_o_t */

struct PK_BODY_knit_o_s
    {
    int                        o_t_version;  /* version number */
    };
typedef struct PK_BODY_knit_o_s PK_BODY_knit_o_t;



/* PK_BODY_knit_o_m */

#define PK_BODY_knit_o_m(options)                                     \
    (                                                                 \
       (options).o_t_version       = 1                                \
    )


/* PK_BODY_sweep_law_discrete_t */

struct PK_BODY_sweep_law_discrete_s
    {
    int              n_vertices;
    PK_VERTEX_t     *vertices;
    double          *values;
    };

typedef struct PK_BODY_sweep_law_discrete_s PK_BODY_sweep_law_discrete_t;



/* PK_BODY_sweep_law_discrete_m */

#define PK_BODY_sweep_law_discrete_m(law) \
    (                                     \
        (law.n_vertices) = 0,             \
        (law.vertices)   = NULL,          \
        (law.values)     = NULL           \
    )


/* PK_BODY_sweep_law_t */

struct PK_BODY_sweep_law_s
    {
    PK_BODY_sweep_law_type_t        law_type;
    PK_BODY_sweep_law_discrete_t    law_set;
    PK_LAW_sf_t                     law_curve;
    };

typedef struct PK_BODY_sweep_law_s PK_BODY_sweep_law_t;



/* PK_BODY_sweep_law_m */

#define PK_BODY_sweep_law_m(options)                      \
    (                                                     \
       (options).law_type     = PK_BODY_sweep_law_none_c, \
       PK_BODY_sweep_law_discrete_m( (options).law_set ), \
       PK_LAW_sf_m( (options).law_curve )                 \
    )


/* PK_sweep_guide_clamp_dirn_t */

struct PK_sweep_guide_clamp_dirn_s
    {
    int                 n_directions;  /* the number of clamp directions (0) */
    const PK_VECTOR1_t *directions;    /* the direction of each clamp (NULL) */
    int                 n_vertices;    /* the number of guide wire vertices for */
    const PK_VERTEX_t  *vertices;      /* the guide wire vertices (NULL) */
    };

typedef struct PK_sweep_guide_clamp_dirn_s PK_sweep_guide_clamp_dirn_t;



/* PK_sweep_guide_clamp_dirn_m */

#define PK_sweep_guide_clamp_dirn_m(options)                            \
    (                                                                   \
       (options).n_directions             = 0,                          \
       (options).directions               = NULL,                       \
       (options).n_vertices               = 0,                          \
       (options).vertices                 = NULL                        \
    )


/* PK_sweep_guide_control_t */

struct PK_sweep_guide_control_s
    {
    PK_VERTEX_array_t             profile_matches;
    PK_sweep_guide_clamp_type_t   clamp_type;  /* clamp type */
    PK_sweep_guide_clamp_dirn_t   dirn_clamp;  /* direction clamp */
    };

typedef struct PK_sweep_guide_control_s PK_sweep_guide_control_t;



/* PK_sweep_guide_control_m */

#define PK_sweep_guide_control_m(options)                               \
    (                                                                   \
       (options).profile_matches.array    = NULL,                       \
       (options).profile_matches.length   = 0,                          \
       (options).clamp_type               = PK_sweep_guide_clamp_none_c,\
       PK_sweep_guide_clamp_dirn_m((options).dirn_clamp)                \
    )


/* PK_sweep_const_profile_clamp_t */

struct PK_sweep_const_profile_clamp_s
    {
    double magnitude;  /* magnitude of the clamp (1.0) */
    };

typedef struct PK_sweep_const_profile_clamp_s PK_sweep_const_profile_clamp_t;



/* PK_sweep_const_profile_clamp_m */

#define PK_sweep_const_profile_clamp_m(options)                         \
    (                                                                   \
       (options).magnitude = 1.0                                        \
    )


/* PK_sweep_face_clamp_t */

struct PK_sweep_face_clamp_s
    {
    int                 n_edges;         /* number of clamping faces and */
    const PK_EDGE_t    *edges;           /* array of clamped profile edges */
    const PK_FACE_t    *faces;           /* array of clamping faces (NULL) */
    int                 n_magnitudes;    /* number of magnitudes for scaling */
    const double       *magnitudes;      /* array of magnitudes for scaling */
    const PK_VERTEX_t  *vertices;        /* array of clamped profile vertices */
    };

typedef struct PK_sweep_face_clamp_s PK_sweep_face_clamp_t;



/* PK_sweep_face_clamp_m */

#define PK_sweep_face_clamp_m(options)                                  \
    (                                                                   \
       (options).n_edges        = 0,                                    \
       (options).edges          = NULL,                                 \
       (options).faces          = NULL,                                 \
       (options).n_magnitudes   = 0,                                    \
       (options).magnitudes     = NULL,                                 \
       (options).vertices       = NULL                                  \
    )


/* PK_sweep_deriv_conds_t */

struct PK_sweep_deriv_conds_s
    {
    PK_sweep_clamp_type_t          clamp_type;  /* clamp type */
    PK_sweep_const_profile_clamp_t const_profile_clamp;
    PK_sweep_face_clamp_t          face_clamp;
    };

typedef struct PK_sweep_deriv_conds_s PK_sweep_deriv_conds_t;



/* PK_sweep_deriv_conds_m */

#define PK_sweep_deriv_conds_m(options)                                 \
    (                                                                   \
       (options).clamp_type               = PK_sweep_clamp_none_c,      \
       PK_sweep_const_profile_clamp_m( (options).const_profile_clamp ), \
       PK_sweep_face_clamp_m( (options).face_clamp )                    \
    )


/* PK_BODY_make_swept_body_o_t */

struct PK_BODY_make_swept_body_o_s
    {
    int                        o_t_version;
    PK_BODY_sweep_alignment_t  alignment;     /* alignment of profile */
    PK_BODY_simplify_t         simplify;      /* simplify lofted surfaces */
    PK_BODY_topology_t         topology_form; /* topology of resultant body */
    PK_BODY_sweep_law_t        twist;         /* twist of sweep path */
    PK_BODY_sweep_law_t        scale;         /* scale of sweep path */
    PK_BODY_sweep_fair_t       fair;          /* method to use for improving */
    double                     tolerance;     /* tolerance (1.0e-5) */
    PK_LOGICAL_t               minimise_tolerance;
    PK_LOGICAL_t               allow_rationals;
    PK_BODY_sweep_scale_type_t scale_type;    /* how any scaling should be */
    PK_VECTOR_t                scale_point;   /* defining point for scale */
    int                        n_ignorable_vertices;
    const PK_VERTEX_t         *ignorable_vertices;
    };

typedef struct PK_BODY_make_swept_body_o_s PK_BODY_make_swept_body_o_t;



/* PK_BODY_make_swept_body_o_m */

#define PK_BODY_make_swept_body_o_m(options)                         \
    (                                                                  \
       (options).o_t_version           = 8,                            \
       (options).alignment             = PK_BODY_sweep_align_normal_c, \
       (options).simplify              = PK_BODY_simplify_analytic_c,  \
       (options).topology_form         = PK_BODY_topology_minimal_c,   \
       PK_BODY_sweep_law_m( (options).twist ),                         \
       PK_BODY_sweep_law_m( (options).scale ),                         \
       (options).fair                  = PK_BODY_sweep_fair_default_c, \
       (options).tolerance             = 1.0e-5,                       \
       (options).minimise_tolerance    = PK_LOGICAL_false,             \
       (options).allow_rationals       = PK_LOGICAL_true,              \
       (options).scale_type            = PK_BODY_sweep_scale_both_c,   \
       (options).scale_point.coord[0]  = 0.0,                          \
       (options).scale_point.coord[1]  = 0.0,                          \
       (options).scale_point.coord[2]  = 0.0,                          \
       (options).n_ignorable_vertices  = 0,                            \
       (options).ignorable_vertices    = NULL                          \
    )


/* PK_BODY_make_swept_body_2_o_t */

struct PK_BODY_make_swept_body_2_o_s
    {
    int                        o_t_version;
    PK_BODY_sweep_alignment_t  alignment;   /* alignment of profile */
    PK_BODY_simplify_t         simplify;    /* simplify swept surfaces */
    PK_BODY_topology_t         topology_form;
    int                        n_ignorable_vertices;
    const PK_VERTEX_t         *ignorable_vertices;
    PK_BODY_vertex_matches_t   matches;     /* how to match vertices on */
    PK_BODY_sweep_law_t        twist;       /* twist of sweep path */
    PK_LOGICAL_t               have_twist_direction;
    PK_VECTOR1_t               twist_direction;
    PK_BODY_sweep_law_t        scale;       /* scale of sweep path */
    PK_BODY_sweep_scale_type_t scale_type;  /* how any scaling should be */
    PK_VECTOR_t                scale_point; /* defining point for scale laws of */
    PK_sweep_profile_law_t     profile_law; /* whether profiles should be */
    double                     tolerance;   /* tolerance (1.0e-5) */
    PK_LOGICAL_t               minimise_tolerance;
    PK_LOGICAL_t               allow_rationals;
    PK_LOGICAL_t               want_edge_tracking;
    PK_LOGICAL_t               have_lock_direction;
    PK_VECTOR1_t               lock_direction;
    PK_sweep_lock_t            lock_type;   /* behaviour of the */
    int                        n_lock_faces;
    const PK_FACE_t           *lock_faces;  /* the lock faces (NULL) */
    PK_continuity_t            preferred_continuity;
    int                        n_guides;    /* the number of guides (0) */
    const PK_BODY_t           *guides;      /* the guides (NULL) */
    const PK_sweep_guide_control_t
                              *guide_controls;
    PK_sweep_guide_method_t    guide_method;
    PK_sweep_guide_scale_t     guide_scale; /* scaling for sweep with guides */
    int                        fixed_guide_index;
    PK_LOGICAL_t               trim_to_guides;
    PK_LOGICAL_t               have_trim_point;
    PK_VECTOR_t                trim_point;  /* a point used to control how */
    int                        n_profile_derivs;
    const PK_sweep_deriv_conds_t
                              *profile_derivs;
    const int                 *profile_indices;
    PK_sweep_output_xsect_t    output_xsect;
    PK_sweep_group_xsect_t     group_xsect; /* how to group cross-sections */
    int                        n_xsects;    /* the number of cross-sections per */
    PK_sweep_repair_t          repair;      /* whether to attempt self- */
    PK_BODY_sweep_update_t     update;      /* update flag */
    };

typedef struct PK_BODY_make_swept_body_2_o_s PK_BODY_make_swept_body_2_o_t;



/* PK_BODY_make_swept_body_2_o_m */

#define PK_BODY_make_swept_body_2_o_m(options)                          \
    (                                                                   \
       (options).o_t_version           = 15,                            \
       (options).alignment             = PK_BODY_sweep_align_normal_c,  \
       (options).simplify              = PK_BODY_simplify_analytic_c,   \
       (options).topology_form         = PK_BODY_topology_minimal_c,    \
       (options).n_ignorable_vertices  = 0,                             \
       (options).ignorable_vertices    = NULL,                          \
       PK_BODY_vertex_matches_m( (options).matches ),                   \
       PK_BODY_sweep_law_m( (options).twist ),                          \
       (options).have_twist_direction = PK_LOGICAL_false,               \
       (options).twist_direction.coord[0] = 0.0,                        \
       (options).twist_direction.coord[1] = 0.0,                        \
       (options).twist_direction.coord[2] = 0.0,                        \
       PK_BODY_sweep_law_m( (options).scale ),                          \
       (options).scale_type            = PK_BODY_sweep_scale_both_c,    \
       (options).scale_point.coord[0]  = 0.0,                           \
       (options).scale_point.coord[1]  = 0.0,                           \
       (options).scale_point.coord[2]  = 0.0,                           \
       (options).profile_law           = PK_sweep_profile_law_no_c,     \
       (options).tolerance             = 1.0e-5,                        \
       (options).minimise_tolerance    = PK_LOGICAL_true,               \
       (options).allow_rationals       = PK_LOGICAL_true,               \
       (options).want_edge_tracking    = PK_LOGICAL_false,              \
       (options).have_lock_direction   = PK_LOGICAL_false,              \
       (options).lock_direction.coord[0]  = 0.0,                        \
       (options).lock_direction.coord[1]  = 0.0,                        \
       (options).lock_direction.coord[2]  = 0.0,                        \
       (options).lock_type             = PK_sweep_lock_path_and_dir_c,  \
       (options).n_lock_faces          = 0,                             \
       (options).lock_faces            = NULL,                          \
       (options).preferred_continuity  = PK_continuity_c1_c,            \
       (options).n_guides              = 0,                             \
       (options).guides                = NULL,                          \
       (options).guide_controls        = NULL,                          \
       (options).guide_method          = PK_sweep_guide_point_c,        \
       (options).guide_scale           = PK_sweep_guide_uniform_c,      \
       (options).fixed_guide_index     = 0,                             \
       (options).trim_to_guides        = PK_LOGICAL_false,              \
       (options).have_trim_point       = PK_LOGICAL_false,              \
       (options).trim_point.coord[0]   = 0.0,                           \
       (options).trim_point.coord[1]   = 0.0,                           \
       (options).trim_point.coord[2]   = 0.0,                           \
       (options).n_profile_derivs      = 0,                             \
       (options).profile_derivs        = NULL,                          \
       (options).profile_indices       = NULL,                          \
       (options).output_xsect          = PK_sweep_output_xsect_no_c,    \
       (options).group_xsect           = PK_sweep_group_xsect_per_vx_c, \
       (options).n_xsects              = 0,                             \
       (options).repair                = PK_sweep_repair_no_c,          \
       (options).update                = PK_BODY_sweep_update_default_c \
    )


/* PK_BODY_make_swept_profiles_o_t */

struct PK_BODY_make_swept_profiles_o_s
    {
    int                         o_t_version;
    PK_BODY_sweep_alignment_t   alignment;
    PK_BODY_simplify_t          simplify;

    PK_BODY_sweep_law_t         twist;
    PK_BODY_sweep_law_t         scale;
    };

typedef struct PK_BODY_make_swept_profiles_o_s PK_BODY_make_swept_profiles_o_t;



/* PK_BODY_make_swept_profiles_o_m */

#define PK_BODY_make_swept_profiles_o_m(options)               \
    (                                                          \
       (options).o_t_version   = 2,                            \
       (options).alignment     = PK_BODY_sweep_align_normal_c, \
       (options).simplify      = PK_BODY_simplify_analytic_c,  \
       PK_BODY_sweep_law_m( (options).twist ),                 \
       PK_BODY_sweep_law_m( (options).scale )                  \
    )


/* PK_BODY_make_swept_tool_o_t */

struct PK_BODY_make_swept_tool_o_s
    {
    int                    o_t_version;
    double                 tolerance;       /* tolerance (1.0e-5) */
    PK_LOGICAL_t           allow_rationals;
    PK_LOGICAL_t           want_edge_tracking;
    PK_swept_tool_update_t update;          /* update flag */
    PK_LOGICAL_t           have_lock_direction;
    PK_VECTOR1_t           lock_direction;  /* lock direction */
    PK_VERTEX_t            tool_site;       /* vertex on the path where the */
    };

typedef struct PK_BODY_make_swept_tool_o_s PK_BODY_make_swept_tool_o_t;



/* PK_BODY_make_swept_tool_o_m */

#define PK_BODY_make_swept_tool_o_m(options)                                \
    (                                                                       \
       (options).o_t_version             = 4,                               \
       (options).tolerance               = 1.0e-5,                          \
       (options).allow_rationals         = PK_LOGICAL_true,                 \
       (options).want_edge_tracking      = PK_LOGICAL_false,                \
       (options).update                  = PK_swept_tool_update_default_c,  \
       (options).have_lock_direction     = PK_LOGICAL_false,                \
       (options).lock_direction.coord[0] = 0.0,                             \
       (options).lock_direction.coord[1] = 0.0,                             \
       (options).lock_direction.coord[2] = 0.0,                             \
       (options).tool_site               = PK_ENTITY_null                   \
    )


/* PK_BODY_sweep_status_r_t */

struct PK_BODY_sweep_status_s
    {
    PK_BODY_sweep_fault_t        fault;
    PK_VECTOR_t                  fault_location;
    PK_TOPOL_t                   fault_topol;
    };

typedef struct PK_BODY_sweep_status_s PK_BODY_sweep_status_r_t;



/* PK_BODY_tracked_sweep_r_t */

struct PK_BODY_tracked_sweep_r_s
    {
    PK_BODY_sweep_status_r_t     status;
    PK_BODY_t                    body;
    PK_TOPOL_track_r_t           tracking_info;
    };

typedef struct PK_BODY_tracked_sweep_r_s PK_BODY_tracked_sweep_r_t;



/* PK_BODY_sweep_status_2_r_t */

struct PK_BODY_sweep_status_2_s
    {
    PK_BODY_sweep_fault_t        fault;
    int                          n_fault_entities;
    PK_ENTITY_t                 *fault_entities;
    PK_VECTOR_t                 *fault_locations;
    };

typedef struct PK_BODY_sweep_status_2_s PK_BODY_sweep_status_2_r_t;



/* PK_BODY_tracked_sweep_2_r_t */

struct PK_BODY_tracked_sweep_2_r_s
    {
    PK_BODY_sweep_status_2_r_t   status;
    PK_BODY_t                    body;
    PK_TOPOL_track_r_t           tracking_info;
    };

typedef struct PK_BODY_tracked_sweep_2_r_s PK_BODY_tracked_sweep_2_r_t;



/* PK_BODY_sweep_tool_status_r_t */

struct PK_BODY_sweep_tool_status_s
    {
    int                     n_faults;
    PK_sweep_tool_fault_t  *faults;
    PK_ENTITY_t            *fault_entities;
    PK_VECTOR_t            *fault_locations;
    };

typedef struct PK_BODY_sweep_tool_status_s PK_BODY_sweep_tool_status_r_t;



/* PK_BODY_sweep_tool_r_t */

struct PK_BODY_sweep_tool_r_s
    {
    PK_BODY_sweep_tool_status_r_t status;
    PK_BODY_t                     body;
    };

typedef struct PK_BODY_sweep_tool_r_s PK_BODY_sweep_tool_r_t;



/* PK_BODY_thicken_o_t */

struct PK_BODY_thicken_o_s
    {
    int                     o_t_version;     /* version number */
    int                     n_faces;         /* number of non-default faces */
    const PK_FACE_t        *faces;           /* faces without default offsets */
    const double           *front_offsets;   /* front offsets */
    const double           *back_offsets;    /* back offsets */
    PK_check_fa_fa_t        check_fa_fa;     /* check for face-face */
    PK_thicken_method_t     method;          /* thickening method */
    PK_VECTOR1_t            punch_dir;       /* punch direction */
    PK_offset_method_t      offset_method;   /* offset method */
    PK_LOGICAL_t            report_sx;       /* whether to report faces that */
    PK_fix_degens_t         fix_degens;      /* control on repairing surface */
    PK_LOGICAL_t            report_fix_degens;
    int                     n_edges;         /* number of edges with user */
    const PK_EDGE_t        *edges;           /* edges with user supplied side */
    int                     n_surfaces;      /* number of user supplied side */
    const PK_SURF_t        *surfaces;        /* user supplied side surfaces */
    PK_EDGE_offset_blend_t  blend_edges;     /* Offset edges as blend faces */
    double                  blend_radius;    /* Radius of resulting blends. */
    PK_LOGICAL_t            ortho_vx_split;  /* Split laminar vertices */
    PK_local_ops_update_t   update;          /* update flag */
    PK_offset_step_t        offset_step;     /* whether to create a step */
    int                     n_pierce_faces;  /* number of faces in */
    const PK_FACE_t        *pierce_faces;    /* faces to be pierced */
    PK_FACE_grow_t          grow;            /* controls which faces to grow */
    };

typedef struct PK_BODY_thicken_o_s PK_BODY_thicken_o_t;



/* PK_BODY_thicken_o_m */

#define PK_BODY_thicken_o_m(options)                                    \
       ((options).o_t_version        = 10,                              \
        (options).n_faces            = 0,                               \
        (options).faces              = NULL,                            \
        (options).front_offsets      = NULL,                            \
        (options).back_offsets       = NULL,                            \
        (options).check_fa_fa        = PK_check_fa_fa_yes_c,            \
        (options).method             = PK_thicken_method_offset_c,      \
        (options).punch_dir.coord[0] = 0.0,                             \
        (options).punch_dir.coord[1] = 0.0,                             \
        (options).punch_dir.coord[2] = 0.0,                             \
        (options).offset_method      = PK_offset_method_sx_trim_c,      \
        (options).fix_degens         = PK_fix_degens_no_c,              \
        (options).report_sx          = PK_LOGICAL_false,                \
        (options).report_fix_degens  = PK_LOGICAL_false,                \
        (options).n_edges            = 0,                               \
        (options).edges              = NULL,                            \
        (options).n_surfaces         = 0,                               \
        (options).surfaces           = NULL,                            \
        (options).blend_edges        = PK_EDGE_offset_blend_no_c,       \
        (options).blend_radius       = 0.0,                             \
        (options).ortho_vx_split     = PK_LOGICAL_false,                \
        (options).update             = PK_local_ops_update_default_c,   \
        (options).offset_step        = PK_offset_step_no_c,             \
        (options).n_pierce_faces     = 0,                               \
        (options).pierce_faces       = NULL,                            \
        (options).grow               = PK_FACE_grow_update_c            \
      )


/* PK_BODY_thicken_r_t */

typedef PK_TOPOL_local_r_t PK_BODY_thicken_r_t;


/* PK_BODY_transform_o_t */

struct PK_BODY_transform_o_s
    {
    int              o_t_version;   /* version number of option structure */
    PK_LOGICAL_t     merge_face;    /* whether transformed faces are to be */
    PK_check_fa_fa_t check_fa_fa;   /* check for face-face inconsistencies */
    PK_local_ops_update_t
                     update;        /* update flag */
    };
typedef struct PK_BODY_transform_o_s PK_BODY_transform_o_t;


/* PK_BODY_transform_o_m */

#define PK_BODY_transform_o_m(options)                              \
       ((options).o_t_version     = 2,                              \
        (options).merge_face      = PK_LOGICAL_true,                \
        (options).check_fa_fa     = PK_check_fa_fa_yes_c,           \
        (options).update          = PK_local_ops_update_default_c   \
       )


/* PK_BODY_ask_topology_o_t */

struct PK_BODY_ask_topology_o_s
    {
    int          o_t_version;      /* version number */
    PK_LOGICAL_t want_fins;        /* whether fins required in output */
    };
typedef struct PK_BODY_ask_topology_o_s PK_BODY_ask_topology_o_t;



/* PK_BODY_ask_topology_o_m */

#define PK_BODY_ask_topology_o_m(options)                                 \
    (                                                                         \
        (options).o_t_version         = 1,                                    \
        (options).want_fins           = PK_LOGICAL_false                      \
    )


/* PK_BODY_create_topology_o_t */

struct PK_BODY_create_topology_o_s
    {
    int              o_t_version;     /* version number */
    PK_BODY_type_t   body_type;       /* preferred result body type */
    int              n_extra_faults;  /* number of extra faults to return (0) */
    PK_BODY_fault_t *extra_faults;    /* extra faults to return (NULL) */
    };
typedef struct PK_BODY_create_topology_o_s
               PK_BODY_create_topology_o_t;



/* PK_BODY_create_topology_o_m */

#define PK_BODY_create_topology_o_m(options)                                  \
    (                                                                         \
        (options).o_t_version         = 2,                                    \
        (options).body_type           = PK_BODY_type_general_c,               \
        (options).n_extra_faults      = 0,                                    \
        (options).extra_faults        = NULL                                  \
    )


/* PK_create_fault_t */

struct PK_create_fault_s
    {
    PK_check_state_t    state;
    int                 n_indices;
    int                *indices;
    };

typedef struct PK_create_fault_s
PK_create_fault_t;




/* PK_BODY_create_topology_2_r_t */

struct PK_BODY_create_topology_2_r_s
    {
    PK_BODY_t          body;
    int                n_topols;
    PK_TOPOL_t        *topols;
    int                n_create_faults;
    PK_create_fault_t *create_faults;

    int               *internal_indices;
    };
typedef struct PK_BODY_create_topology_2_r_s
PK_BODY_create_topology_2_r_t;






/* PK_BODY_create_topology_2_o_t */

struct PK_BODY_create_topology_2_o_s
    {
    int              o_t_version;     /* version number */
    PK_BODY_type_t   body_type;       /* preferred result body type */
    };
typedef struct PK_BODY_create_topology_2_o_s
               PK_BODY_create_topology_2_o_t;



/* PK_BODY_create_topology_2_o_m */

#define PK_BODY_create_topology_2_o_m(options)                                \
    (                                                                         \
        (options).o_t_version         = 1,                                    \
        (options).body_type           = PK_BODY_type_general_c                \
    )


/* PK_BODY_set_type_o_t */

struct PK_BODY_set_type_o_s
    {
    int                    o_t_version;     /* version number of option */
    };

typedef struct PK_BODY_set_type_o_s PK_BODY_set_type_o_t;



/* PK_BODY_set_type_o_m */

#define PK_BODY_set_type_o_m(options)                                 \
    (                                                                 \
       (options).o_t_version = 1                                      \
    )


/* PK_FACE_close_gaps_o_t */

struct PK_FACE_close_gaps_o_s
    {
    int                    o_t_version;      /* options structure version. */
    PK_LOOP_3_space_gap_t  gap_in_3_space;   /* controls model space gaps at */
    PK_LOOP_2_space_gap_t  gap_in_2_space;   /* controls parameter space gaps */
    double                 tol_in_2_space;   /* tolerance value for */
    PK_LOOP_trim_geom_t    trim_fin_geom;    /* shorten the SP-curve geometry */

    };

typedef struct PK_FACE_close_gaps_o_s PK_FACE_close_gaps_o_t;



/* PK_FACE_close_gaps_o_m */

#define PK_FACE_close_gaps_o_m(options)                           \
    (                                                             \
       (options).o_t_version    = 3,                              \
       (options).gap_in_3_space = PK_LOOP_3_space_gap_close_c,    \
       (options).gap_in_2_space = PK_LOOP_2_space_gap_no_c,       \
       (options).tol_in_2_space = 1.0e-06,                        \
       (options).trim_fin_geom  = PK_LOOP_trim_geom_no_c          \
    )


/* PK_FACE_contains_vectors_o_t */

struct PK_FACE_contains_vectors_o_s
    {
    int          o_t_version;        /* version number of options structure */
    int          n_uvs;              /* number of uv positions (0) */
    PK_UV_t     *uvs;                /* uv positions (NULL) */
    int          n_vectors;          /* number of xyz positions (0) */
    PK_VECTOR_t *vectors;            /* xyz positions (NULL) */
    int          n_loops;            /* number of loops (0) */
    PK_LOOP_t   *loops;              /* loops (NULL) */
    PK_LOGICAL_t is_on_surf;         /* whether position vector is assumed */
    };
typedef struct PK_FACE_contains_vectors_o_s PK_FACE_contains_vectors_o_t;


/* PK_FACE_contains_vectors_o_m */

#define PK_FACE_contains_vectors_o_m(options)                 \
       ((options).o_t_version = 2,                            \
        (options).n_uvs       = 0,                            \
        (options).uvs         = NULL,                         \
        (options).n_vectors   = 0,                            \
        (options).vectors     = NULL,                         \
        (options).n_loops     = 0,                            \
        (options).loops       = NULL,                         \
        (options).is_on_surf  = PK_LOGICAL_true               \
       )


/* PK_FACE_make_sheet_bodies_o_t */

struct PK_FACE_make_sheet_bodies_o_s
    {
    int                 o_t_version;      /* version number of option structure */
    PK_LOGICAL_t        allow_disjoint;   /* Allow disjoint bodies */
    PK_LOGICAL_t        transfer_attribs; /* Transfer topology attributes */
    PK_track_edges_t    track_edges;      /* return edges in tracking data */
    PK_track_vertices_t track_vertices;   /* return vertices in tracking data */
    };
typedef struct PK_FACE_make_sheet_bodies_o_s PK_FACE_make_sheet_bodies_o_t;



/* PK_FACE_make_sheet_bodies_o_m */

#define PK_FACE_make_sheet_bodies_o_m( options )            \
    (                                                       \
       (options).o_t_version       = 2,                     \
       (options).allow_disjoint    = PK_LOGICAL_false,      \
       (options).transfer_attribs  = PK_LOGICAL_true,       \
       (options).track_edges       = PK_track_edges_no_c,   \
       (options).track_vertices    = PK_track_vertices_no_c \
    )


/* PK_FACE_make_neutral_sheet_o_t */

struct PK_FACE_make_neutral_sheet_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    extend_and_fill_holes;
    PK_LOGICAL_t    have_tolerance;  /* whether tolerance value is provided */
    double          tolerance;       /* tolerance on surface offsets */
    int             n_methods;       /* number of construction methods */
    const PK_neutral_method_t
                   *methods;         /* array of construction methods */
    PK_LOGICAL_t    make_sheet;      /* whether to create a neutral sheet */
    PK_neutral_face_overlap_t
                    overlap;         /* whether to enforce face overlaps */
    PK_local_ops_update_t
                    update;          /* update flag */
    };

typedef struct PK_FACE_make_neutral_sheet_o_s PK_FACE_make_neutral_sheet_o_t;



/* PK_FACE_make_neutral_sheet_o_m */

#define PK_FACE_make_neutral_sheet_o_m( options )           \
    (                                                       \
       (options).o_t_version            = 6,                \
       (options).extend_and_fill_holes  = PK_LOGICAL_true,  \
       (options).have_tolerance         = PK_LOGICAL_false, \
       (options).tolerance              = 0.0,              \
       (options).n_methods              = 0,                \
       (options).methods                = NULL,             \
       (options).make_sheet             = PK_LOGICAL_true,  \
       (options).overlap                = PK_neutral_face_overlap_no_c,  \
       (options).update                 = PK_local_ops_update_default_c  \
    )


/* PK_FACE_repair_o_t */

struct PK_FACE_repair_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        split_g1;        /* split at G1 discontinuities */
    PK_LOGICAL_t        split_self_int;  /* split to avoid self-intersections */
    };

typedef struct PK_FACE_repair_o_s PK_FACE_repair_o_t;



/* PK_FACE_repair_o_m */

#define PK_FACE_repair_o_m( options )         \
    (                                                      \
       (options).o_t_version    = 1,                       \
       (options).split_g1       = PK_LOGICAL_true,         \
       (options).split_self_int = PK_LOGICAL_true          \
    )


/* PK_FACE_simplify_geom_o_t */

struct PK_FACE_simplify_geom_o_s
    {
    int           o_t_version;   /* version number of option structure */
    PK_LOGICAL_t  want_geoms;    /* user requires new geoms to be returned */
    };

typedef struct PK_FACE_simplify_geom_o_s PK_FACE_simplify_geom_o_t;



/* PK_FACE_simplify_geom_o_m */

#define PK_FACE_simplify_geom_o_m( options )                        \
    (                                                       \
       (options).o_t_version    = 1,                        \
       (options).want_geoms     = PK_LOGICAL_false          \
    )


/* PK_FACE_reverse_o_t */

struct PK_FACE_reverse_o_s
    {
    int     o_t_version;  /*version number of options structure */
    };

typedef struct PK_FACE_reverse_o_s PK_FACE_reverse_o_t;



/* PK_FACE_reverse_o_m */

#define PK_FACE_reverse_o_m( options ) \
    (                                  \
       (options).o_t_version    = 1    \
    )


/* PK_FACE_ask_faces_adjacent_o_t */

struct PK_FACE_ask_faces_adjacent_o_s
    {
    int                   o_t_version;               /* version number of */
    PK_LOGICAL_t          include_vertex_connected;  /* Whether vertex- */
    };
typedef struct PK_FACE_ask_faces_adjacent_o_s PK_FACE_ask_faces_adjacent_o_t;


/* PK_FACE_ask_faces_adjacent_o_m */

#define PK_FACE_ask_faces_adjacent_o_m(options)                   \
    (                                                             \
    (options).o_t_version  = 1,                                   \
    (options).include_vertex_connected = PK_LOGICAL_false         \
    )


/* PK_FACE_check_o_t */

struct PK_FACE_check_o_s
    {
    int                  o_t_version;  /* version number of option structure */
    int                  max_faults;   /* limit on fault numbers (5) */
    PK_check_geom_t      geom;         /* bad geometry (PK_check_geom_yes_c) */
    PK_check_bgeom_t     bgeom;        /* bad B geometry (PK_check_bgeom_yes_c) */
    PK_check_top_geo_t   top_geo;      /* topology/geometry inconsistency */
    PK_check_size_box_t  size_box;     /* size box violation */
    PK_check_fa_X_t      fa_X;         /* face self intersection */
    PK_check_loops_t     loops;        /* loop checks (PK_check_loops_yes_c) */
    PK_check_nmnl_geom_t nmnl_geom;    /* bad nominal geometry */
    PK_check_returns_t   returns;      /* return version of fault information */
    PK_check_attribs_t   attribs;      /* system attribute validity checks */
    };

typedef struct PK_FACE_check_o_s PK_FACE_check_o_t;



/* PK_FACE_check_o_m */

#define PK_FACE_check_o_m(options)                          \
    (                                                       \
       (options).o_t_version = 3,                           \
       (options).max_faults  = 5,                           \
       (options).geom        = PK_check_geom_yes_c,         \
       (options).bgeom       = PK_check_bgeom_yes_c,        \
       (options).top_geo     = PK_check_top_geo_yes_c,      \
       (options).size_box    = PK_check_size_box_yes_c,     \
       (options).fa_X        = PK_check_fa_X_yes_c,         \
       (options).loops       = PK_check_loops_yes_c,        \
       (options).nmnl_geom   = PK_check_nmnl_geom_yes_c,    \
       (options).returns     = PK_check_returns_0_c,        \
       (options).attribs     = PK_check_attribs_no_c       \
    )


/* PK_FACE_check_pair_o_t */

struct PK_FACE_check_pair_o_s
    {
    int                 o_t_version;   /* version number of option structure */
    int                 max_faults;    /* limit on fault numbers (1) */
    };

typedef struct PK_FACE_check_pair_o_s PK_FACE_check_pair_o_t;



/* PK_FACE_check_pair_o_m */

#define PK_FACE_check_pair_o_m(options)                 \
    (                                                   \
       (options).o_t_version = 1,                       \
       (options).max_faults  = 1                        \
    )


/* PK_FACE_delete_o_t */

struct PK_FACE_delete_o_s
    {
    int                   o_t_version;   /* version number of option structure */
    PK_local_ops_update_t update;        /* update flag */
    PK_FACE_heal_t        heal_action;   /* how to heal wounds */
    PK_FACE_heal_loops_t  heal_loops;    /* how to process the loops of */
    PK_LOGICAL_t          local_check;   /* whether to perform local checking */
    PK_LOGICAL_t          allow_disjoint;
    PK_repair_fa_fa_t     repair_fa_fa;  /* whether to repair face-face */
    };
typedef struct PK_FACE_delete_o_s PK_FACE_delete_o_t;


/* PK_FACE_delete_o_m */

#define PK_FACE_delete_o_m(options)                                 \
       ((options).o_t_version     = 2,                              \
        (options).update          = PK_local_ops_update_default_c,  \
        (options).heal_action     = PK_FACE_heal_shrink_c,          \
        (options).heal_loops      = PK_FACE_heal_loops_auto_c,      \
        (options).local_check     = PK_LOGICAL_true,                \
        (options).allow_disjoint  = PK_LOGICAL_false,               \
        (options).repair_fa_fa    = PK_repair_fa_fa_no_c            \
       )


/* PK_FACE_delete_from_sheet_o_t */

struct PK_FACE_delete_from_sheet_o_s
    {
    int                o_t_version;     /* version number of option structure */
    PK_LOGICAL_t       allow_disjoint;  /* Whether to allow a disjoint body to */
    };
typedef struct PK_FACE_delete_from_sheet_o_s PK_FACE_delete_from_sheet_o_t;


/* PK_FACE_delete_from_sheet_o_m */

#define PK_FACE_delete_from_sheet_o_m(opt)  \
    (                                       \
    (opt).o_t_version    = 1,               \
    (opt).allow_disjoint = PK_LOGICAL_false \
    )


/* PK_FACE_delete_blends_o_t */

struct PK_FACE_delete_blends_o_s
    {
    int                   o_t_version;   /* version number of option structure */
    PK_check_fa_fa_t      check_fa_fa;   /* check for face-face inconsistencies */
    PK_FACE_simplify_t    simplify;      /* whether to simplify the surfaces of */
    PK_blend_delete_cap_t cap;           /* how to cap blends */
    PK_blend_delete_cap_data_t
                          cap_data;      /* definition of caps */
    PK_local_ops_update_t update;        /* update flag */
    PK_blend_delete_unders_data_t
                          unders_data;   /* blend faces with user supplied */
    };
typedef struct PK_FACE_delete_blends_o_s PK_FACE_delete_blends_o_t;


/* PK_FACE_delete_blends_o_m */

#define PK_FACE_delete_blends_o_m(options)                          \
       ((options).o_t_version     = 7,                              \
        (options).check_fa_fa     = PK_check_fa_fa_yes_c,           \
        (options).simplify        = PK_FACE_simplify_no_c,          \
        (options).cap             = PK_blend_delete_cap_no_c,       \
        PK_blend_delete_cap_data_m((options).cap_data),             \
        (options).update          = PK_local_ops_update_default_c,  \
        PK_blend_delete_unders_data_m((options).unders_data)        \
       )


/* PK_FACE_delete_facesets_o_t */

struct PK_FACE_delete_facesets_o_s
    {
    int            o_t_version;     /* options structure version number */
    PK_LOGICAL_t   allow_disjoint;  /* allow function to produce disjoint */
    PK_FACE_heal_t heal_action;     /* healing action (PK_FACE_heal_yes_c) */
    int            n_details;       /* number of details (0) */
    PK_detail_t   *details;         /* array of details (NULL) */
    double         tolerance;       /* tolerance (1.0e-6) */
    PK_local_ops_update_t
                   update;          /* update flag */
    };
typedef struct PK_FACE_delete_facesets_o_s PK_FACE_delete_facesets_o_t;


/* PK_FACE_delete_facesets_o_m */

#define PK_FACE_delete_facesets_o_m(options)                        \
       ((options).o_t_version     = 3,                              \
        (options).allow_disjoint  = PK_LOGICAL_false,               \
        (options).heal_action     = PK_FACE_heal_yes_c,             \
        (options).n_details       = 0,                              \
        (options).details         = NULL,                           \
        (options).tolerance       = 1.0e-6,                         \
        (options).update          = PK_local_ops_update_default_c   \
       )


/* PK_FACE_emboss_o_t */

struct PK_FACE_emboss_o_s
    {
    int                        o_t_version; /* version number of options */
    double                     tolerance;   /* operation tolerance */
    PK_emboss_convexity_t      convexity;   /* convexity of emboss to be */
    PK_emboss_profile_on_t     profile_on;  /* where profile lives */
    PK_emboss_sidewall_data_t  sidewall_data;
    PK_emboss_overflow_data_t  overflow_data;
    PK_emboss_unite_sidewall_t unite;       /* whether to unite sidewall faces */
    PK_local_ops_update_t      update;      /* update flag */
    };
typedef struct PK_FACE_emboss_o_s PK_FACE_emboss_o_t;


/* PK_FACE_emboss_o_m */

#define PK_FACE_emboss_o_m(options)                                         \
       ((options).o_t_version       = 3,                                    \
        (options).tolerance         = 1.0e-5,                               \
        (options).convexity         = PK_emboss_convexity_both_c,           \
        (options).profile_on        = PK_emboss_profile_on_any_c,           \
        PK_emboss_sidewall_data_m((options).sidewall_data),                 \
        PK_emboss_overflow_data_m((options).overflow_data),                 \
        (options).unite             = PK_emboss_unite_sidewall_yes_c,       \
        (options).update            = PK_local_ops_update_default_c         \
       )


/* PK_FACE_find_outer_loop_o_t */

struct PK_FACE_find_outer_loop_o_s
    {
    int             o_t_version;             /* version number of option */
    };

typedef struct PK_FACE_find_outer_loop_o_s PK_FACE_find_outer_loop_o_t;



/* PK_EDGE_ask_convexity_o_m */

#define PK_FACE_find_outer_loop_o_m(options)                         \
    (                                                                \
       (options).o_t_version                = 1                      \
    )


/* PK_FACE_find_interior_vec_o_t */

struct PK_FACE_find_interior_vec_o_s
    {
    int         o_t_version;         /* version number of option structure */
    };

typedef struct PK_FACE_find_interior_vec_o_s PK_FACE_find_interior_vec_o_t;



/* PK_FACE_find_interior_vec_o_m */

#define PK_FACE_find_interior_vec_o_m(options)                       \
    (                                                                \
       (options).o_t_version                = 1                      \
    )


/* PK_FACE_hollow_o_t */

struct PK_FACE_hollow_o_s
    {
    int                o_t_version;     /* version number of option structure */
    PK_check_fa_fa_t   check_fa_fa;     /* check for face-face */
    PK_LOGICAL_t       pierce_tangent;  /* DEPRECATED (PK_LOGICAL_false) */
    PK_offset_method_t offset_method;   /* offset method */
    PK_LOGICAL_t       report_sx;       /* whether to report faces that have */
    PK_fix_degens_t    fix_degens;      /* control on repairing surface */
    PK_LOGICAL_t       report_fix_degens;
    PK_offset_step_t   offset_step;     /* whether to create a step offset */
    PK_EDGE_offset_blend_t
                       blend_edges;     /* Offset edges as blend faces */
    double             blend_radius;    /* Radius of blend faces created if */
    PK_FACE_grow_t     grow;            /* controls which faces to grow */
    PK_local_ops_update_t
                       update;          /* update flag */
    };
typedef struct PK_FACE_hollow_o_s PK_FACE_hollow_o_t;


/* PK_FACE_hollow_o_m */

#define PK_FACE_hollow_o_m(options)                                   \
       ((options).o_t_version       = 8,                              \
        (options).check_fa_fa       = PK_check_fa_fa_yes_c,           \
        (options).pierce_tangent    = PK_LOGICAL_false,               \
        (options).offset_method     = PK_offset_method_sx_trim_c,     \
        (options).fix_degens        = PK_fix_degens_no_c,             \
        (options).report_sx         = PK_LOGICAL_false,               \
        (options).report_fix_degens = PK_LOGICAL_false,               \
        (options).offset_step       = PK_offset_step_no_c,            \
        (options).blend_edges       = PK_EDGE_offset_blend_no_c,      \
        (options).blend_radius      = 0.0,                            \
        (options).grow              = PK_FACE_grow_update_c,          \
        (options).update            = PK_local_ops_update_default_c   \
       )


/* PK_FACE_identify_blends_o_t */

struct PK_FACE_identify_blends_o_s
    {
    int                    o_t_version;      /* version number of options */
    PK_double_constraint_t limit_radii;      /* only return blends with radii */
    PK_blend_convexity_t   convexity;        /* only blends of the */
    PK_LOGICAL_t           allow_pi;         /* whether to return blends */
    double                 tolerance;        /* tolerance (1.0e-6) */
    PK_LOGICAL_t           want_radii;       /* whether to return the blends */
    PK_LOGICAL_t           want_convexities; /* whether to return the blends */
    PK_blend_follow_branch_t
                           follow_branch;    /* whether to follow all possible */
    PK_LOGICAL_t           have_propagation_angle;
    double                 propagation_angle;
    PK_local_ops_update_t  update;           /* update flag */
    PK_chain_optimise_t    optimise_chains;  /* how the blend chains are to be */
    PK_blend_report_blends_t
                           report_blends;    /* whether to create Parasolid */
    PK_blend_distant_unders_t
                           distant_unders;
    };
typedef struct PK_FACE_identify_blends_o_s PK_FACE_identify_blends_o_t;


/* PK_FACE_identify_blends_o_m */

#define PK_FACE_identify_blends_o_m(options)                                 \
    (                                                                        \
        (options).o_t_version                   = 6,                         \
        (options).limit_radii.comparison        = PK_comparison_always_c,    \
        (options).limit_radii.interval.value[0] = 0,                         \
        (options).limit_radii.interval.value[1] = 0,                         \
        (options).convexity                  = PK_blend_convexity_any_c,     \
        (options).allow_pi                   = PK_LOGICAL_true,              \
        (options).tolerance                  = 1.0e-6,                       \
        (options).want_radii                 = PK_LOGICAL_false,             \
        (options).want_convexities           = PK_LOGICAL_false,             \
        (options).follow_branch              = PK_blend_follow_branch_yes_c, \
        (options).have_propagation_angle     = PK_LOGICAL_false,             \
        (options).propagation_angle          = 0.0,                          \
        (options).update                     = PK_local_ops_update_default_c,\
        (options).optimise_chains            = PK_chain_optimise_none_c,     \
        (options).report_blends              = PK_blend_report_blends_no_c,  \
        (options).distant_unders             = PK_blend_distant_unders_no_c  \
    )


/* PK_FACE_identify_blends_r_t */

struct PK_FACE_identify_blends_r_s
    {
    int                     n_blend_facesets;    /* number of blend facesets */
    PK_FACE_array_t        *blend_facesets;      /* faces classified as blends */
    double                 *blend_radii;         /* radii of blend facesets */
    PK_blend_convexity_t   *blend_convexities;   /* convexities of blend */
    };
typedef struct PK_FACE_identify_blends_r_s PK_FACE_identify_blends_r_t;


/* PK_FACE_find_blend_unders_o_t */


struct PK_FACE_find_blend_unders_o_s
    {
    int                     o_t_version;     /* version number of options */
    double                  tolerance;       /* tolerance (1e-6) */
    PK_local_ops_update_t   update;          /* update flag */
    };
typedef struct PK_FACE_find_blend_unders_o_s PK_FACE_find_blend_unders_o_t;







/* PK_FACE_find_blend_unders_o_m */

#define PK_FACE_find_blend_unders_o_m(options)                               \
    (                                                                        \
        (options).o_t_version                   = 2,                         \
        (options).tolerance                     = 1.0e-6,                    \
        (options).update                     = PK_local_ops_update_default_c \
    )


/* PK_FACE_find_blend_unders_r_t */

struct PK_FACE_find_blend_unders_r_s
    {
    int                     n_unders;    /* number of underlying */
    PK_FACE_array_t        *unders;      /* sets of faces underlying */
    };
typedef struct PK_FACE_find_blend_unders_r_s PK_FACE_find_blend_unders_r_t;


/* PK_FACE_identify_blends_4_m */

#define PK_FACE_identify_blends_4_m(options)                                 \
    (                                                                        \
        (options).o_t_version                   = 4,                         \
        (options).limit_radii.comparison        = PK_comparison_always_c,    \
        (options).limit_radii.interval.value[0] = 0,                         \
        (options).limit_radii.interval.value[1] = 0,                         \
        (options).convexity                  = PK_blend_convexity_any_c,     \
        (options).allow_pi                   = PK_LOGICAL_true,              \
        (options).tolerance                  = 1.0e-6,                       \
        (options).want_radii                 = PK_LOGICAL_false,             \
        (options).want_convexities           = PK_LOGICAL_false,             \
        (options).follow_branch              = PK_blend_follow_branch_yes_c, \
        (options).have_propagation_angle     = PK_LOGICAL_false,             \
        (options).propagation_angle          = 0.0,                          \
        (options).update                     = PK_local_ops_update_default_c \
    )


/* PK_FACE_identify_blends_5_m */

#define PK_FACE_identify_blends_5_m(options)                                 \
    (                                                                        \
        (options).o_t_version                   = 5,                         \
        (options).limit_radii.comparison        = PK_comparison_always_c,    \
        (options).limit_radii.interval.value[0] = 0,                         \
        (options).limit_radii.interval.value[1] = 0,                         \
        (options).convexity                  = PK_blend_convexity_any_c,     \
        (options).allow_pi                   = PK_LOGICAL_true,              \
        (options).tolerance                  = 1.0e-6,                       \
        (options).want_radii                 = PK_LOGICAL_false,             \
        (options).want_convexities           = PK_LOGICAL_false,             \
        (options).follow_branch              = PK_blend_follow_branch_yes_c, \
        (options).have_propagation_angle     = PK_LOGICAL_false,             \
        (options).propagation_angle          = 0.0,                          \
        (options).update                     = PK_local_ops_update_default_c,\
        (options).optimise_chains            = PK_chain_optimise_none_c      \
    )


/* PK_FACE_imprint_cus_normal_o_t */

struct PK_FACE_imprint_cus_normal_o_s
    {
     int           o_t_version;              /* version number */
     PK_imprint_complete_t
                   imprint_complete;         /* whether to complete imprint */
     PK_imprint_tracking_t
                   tracking_type;            /* format of returned tracking */
     PK_imprint_proj_dist_t
                   use_max_projection_dist;  /* whether and how to limit */
     double        max_projection_dist;      /* (0.0) */
     PK_LOGICAL_t  imprint_coi_exactly;      /* whether to imprint curves */
     PK_continuity_t
                   preferred_continuity;     /* level of continuity to impose */

    };
typedef struct PK_FACE_imprint_cus_normal_o_s PK_FACE_imprint_cus_normal_o_t;



/* PK_FACE_imprint_cus_normal_o_m */

#define PK_FACE_imprint_cus_normal_o_m(options)                         \
    (                                                                   \
       (options).o_t_version             = 6,                           \
       (options).imprint_complete        = PK_imprint_complete_no_c,    \
       (options).tracking_type           = PK_imprint_tracking_basic_c, \
       (options).use_max_projection_dist = PK_imprint_proj_dist_no_c,   \
       (options).max_projection_dist     = 0.0,                         \
       (options).imprint_coi_exactly     = PK_LOGICAL_false,            \
       (options).preferred_continuity    = PK_continuity_g1_c           \
    )


/* PK_FACE_imprint_cus_vector_o_t */

struct PK_FACE_imprint_cus_vector_o_s
    {
     int                 o_t_version;   /* version number of option structure */
    };
typedef struct PK_FACE_imprint_cus_vector_o_s PK_FACE_imprint_cus_vector_o_t;



/* PK_FACE_imprint_cus_vector_o_m */

#define PK_FACE_imprint_cus_vector_o_m(options)                      \
    (                                                                \
       (options).o_t_version           = 1                           \
    )


/* PK_FACE_imprint_cus_vec_o_t */

struct PK_FACE_imprint_cus_vec_o_s
    {
    int                      o_t_version;    /* version number of option */
    PK_imprint_connect_t     connect;        /* How to connect disjoint */
    PK_imprint_face_hidden_t hidden;         /* How imprint is affected by */
    PK_imprint_complete_t    imprint_complete;
    PK_LOGICAL_t             imprint_coi_exactly;
    PK_LOGICAL_t             imprint_exactly;
    PK_LOGICAL_t             bidirectional;  /* whether to imprint curves */
    PK_imprint_intersect_t   process_intersections;
    };
typedef struct PK_FACE_imprint_cus_vec_o_s PK_FACE_imprint_cus_vec_o_t;



/* PK_FACE_imprint_cus_vec_o_m */

#define PK_FACE_imprint_cus_vec_o_m(options)                           \
    (                                                                  \
       (options).o_t_version           = 5,                            \
       (options).connect               = PK_imprint_connect_none_c,    \
       (options).hidden                = PK_imprint_face_hidden_body_c,\
       (options).imprint_complete      = PK_imprint_complete_no_c,     \
       (options).imprint_coi_exactly   = PK_LOGICAL_false,             \
       (options).imprint_exactly       = PK_LOGICAL_false,             \
       (options).bidirectional         = PK_LOGICAL_false,             \
       (options).process_intersections = PK_imprint_intersect_update_c \
    )


/* PK_FACE_tracking_r_t */

struct PK_FACE_tracking_r_s
    {
    PK_FACE_t   original_face;
    int         n_times_instanced;
    PK_FACE_t  *instanced_faces;
    int        *instance_index;
    };
typedef struct PK_FACE_tracking_r_s PK_FACE_tracking_r_t;



/* PK_FACE_inst_tools_r_t */

struct PK_FACE_inst_tools_r_s
    {
    int                     n_instances;
    int                    *instance_indices;
    int                     n_tracked_faces;
    PK_FACE_tracking_r_t   *tracked_faces;
    };
typedef struct PK_FACE_inst_tools_r_s PK_FACE_inst_tools_r_t;



/* PK_FACE_intersect_face_o_t */

struct PK_FACE_intersect_face_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    PK_LOGICAL_t    have_uvbox_1;    /* whether box provided for face_1 */
    PK_UVBOX_t      uvbox_1;         /* uvbox for face_1 */
    PK_LOGICAL_t    have_uvbox_2;    /* whether box provided for face_2 */
    PK_UVBOX_t      uvbox_2;         /* uvbox for face_2 */
    PK_LOGICAL_t    have_vector;     /* whether seed vector provided */
    PK_VECTOR_t     vector;          /* only return branch containing the seed */
    };

typedef struct PK_FACE_intersect_face_o_s PK_FACE_intersect_face_o_t;



/* PK_FACE_intersect_face_o_m */

#define PK_FACE_intersect_face_o_m(options)                   \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0,                 \
       (options).have_uvbox_1          = PK_LOGICAL_false,    \
       (options).uvbox_1.param[0]      = 0.0,                 \
       (options).uvbox_1.param[1]      = 0.0,                 \
       (options).uvbox_1.param[2]      = 0.0,                 \
       (options).uvbox_1.param[3]      = 0.0,                 \
       (options).have_uvbox_2          = PK_LOGICAL_false,    \
       (options).uvbox_2.param[0]      = 0.0,                 \
       (options).uvbox_2.param[1]      = 0.0,                 \
       (options).uvbox_2.param[2]      = 0.0,                 \
       (options).uvbox_2.param[3]      = 0.0,                 \
       (options).have_vector           = PK_LOGICAL_false,    \
       (options).vector.coord[0]       = 0.0,                 \
       (options).vector.coord[1]       = 0.0,                 \
       (options).vector.coord[2]       = 0.0                  \
    )


/* PK_FACE_intersect_surf_o_t */

struct PK_FACE_intersect_surf_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    PK_LOGICAL_t    have_uvbox_1;    /* whether box provided for face */
    PK_UVBOX_t      uvbox_1;         /* uvbox for face */
    PK_LOGICAL_t    have_uvbox_2;    /* whether box provided for surf */
    PK_UVBOX_t      uvbox_2;         /* uvbox for surf */
    PK_LOGICAL_t    have_vector;     /* whether seed vector provided */
    PK_VECTOR_t     vector;          /* only return branch containing the seed */
    };

typedef struct PK_FACE_intersect_surf_o_s PK_FACE_intersect_surf_o_t;



/* PK_FACE_intersect_surf_o_m */

#define PK_FACE_intersect_surf_o_m(options)                   \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0,                 \
       (options).have_uvbox_1          = PK_LOGICAL_false,    \
       (options).uvbox_1.param[0]      = 0.0,                 \
       (options).uvbox_1.param[1]      = 0.0,                 \
       (options).uvbox_1.param[2]      = 0.0,                 \
       (options).uvbox_1.param[3]      = 0.0,                 \
       (options).have_uvbox_2          = PK_LOGICAL_false,    \
       (options).uvbox_2.param[0]      = 0.0,                 \
       (options).uvbox_2.param[1]      = 0.0,                 \
       (options).uvbox_2.param[2]      = 0.0,                 \
       (options).uvbox_2.param[3]      = 0.0,                 \
       (options).have_vector           = PK_LOGICAL_false,    \
       (options).vector.coord[0]       = 0.0,                 \
       (options).vector.coord[1]       = 0.0,                 \
       (options).vector.coord[2]       = 0.0                  \
    )


/* PK_FACE_is_coincident_o_t */

struct PK_FACE_is_coincident_o_s
    {
    int             o_t_version;
    PK_TRANSF_t     transf1;     /* transform applied to face1 */
    PK_TRANSF_t     transf2;     /* transform applied to face2 */
    };

typedef struct PK_FACE_is_coincident_o_s PK_FACE_is_coincident_o_t;




/* PK_FACE_is_coincident_o_m */

#define PK_FACE_is_coincident_o_m(options) \
    (                                   \
       (options).o_t_version = 2,        \
       (options).transf1 = PK_ENTITY_null,        \
       (options).transf2 = PK_ENTITY_null        \
    )


/* PK_FACE_make_3_face_blend_r_t */

struct PK_FACE_make_3_face_blend_r_s
    {
    PK_3_face_blend_t       status;        /* blend status */
    PK_blend_orientation_t  left_orientation;
    PK_blend_orientation_t  right_orientation;
    PK_blend_orientation_t  centre_orientation;
    int                     n_sheets;      /* number of sheets */
    PK_TOPOL_t             *sheets;        /* associated sheets */
    int                     n_topols;      /* number of topols */
    PK_TOPOL_t             *topols;        /* error topology */
    int                     n_points;      /* number of points */
    PK_VECTOR_t            *points;        /* error points */
    int                     n_dists;       /* number of lengths */
    double                 *dists;         /* error lengths */
    };
typedef struct PK_FACE_make_3_face_blend_r_s PK_FACE_make_3_face_blend_r_t;



/* PK_FACE_make_3_face_blend_o_t */

struct PK_FACE_make_3_face_blend_o_s
    {
    int                     o_t_version;    /* version number of options */
    double                  blend_tolerance;
    PK_LOGICAL_t            have_propagation_tolerance;
    double                  propagation_tolerance;
    PK_blend_propagate_t    propagate;      /* whether to propagate */
    PK_blend_orientation_t  left_orientation;
    PK_blend_orientation_t  right_orientation;
    PK_blend_orientation_t  centre_orientation;
    PK_blend_trim_t         trim;           /* blend trimming option */
    PK_blend_walls_t        walls;          /* wall trimming option */
    PK_blend_repair_fa_X_t  repair_fa_X;    /* whether to attempt to repair */
    PK_blend_xs_plane_t     xsection;       /* cross section shape */
    PK_PARTITION_t          partition;      /* a partition */
    int                     n_limits;       /* number of limit entities (0) */
    const PK_ENTITY_t      *limits;         /* entities limiting the blend */
    int                     n_caps;         /* number of caps (0) */
    const PK_ENTITY_t      *caps;           /* entities for capping */
    const PK_LOGICAL_t     *reverse_cap;    /* whether cap orientation */
    PK_blend_update_t       update;         /* disable changes for updates */
    PK_blend_check_fa_fa_t  check_fa_fa;    /* check for face-face */
    PK_blend_track_edges_t  track_edges;    /* whether to provide laminar */
    PK_blend_trim_extent_t  trim_extent;    /* additional controls upon */
    PK_LOGICAL_t            have_help_point;
    PK_VECTOR_t             help_point;     /* help point */

    };

typedef struct PK_FACE_make_3_face_blend_o_s PK_FACE_make_3_face_blend_o_t;



/* PK_FACE_make_3_face_blend_o_m */

#define PK_FACE_make_3_face_blend_o_m(options)                                \
    (                                                                         \
       (options).o_t_version                = 11,                             \
       (options).blend_tolerance            = 1.0e-05,                        \
       (options).have_propagation_tolerance = PK_LOGICAL_true,                \
       (options).propagation_tolerance      = 0.05,                           \
       (options).propagate                  = PK_blend_propagate_yes_c,       \
       (options).left_orientation           = PK_blend_orientation_unknown_c, \
       (options).right_orientation          = PK_blend_orientation_unknown_c, \
       (options).centre_orientation         = PK_blend_orientation_unknown_c, \
       (options).trim                       = PK_blend_trim_to_walls_c,       \
       (options).walls                      = PK_blend_walls_attach_c,        \
       (options).repair_fa_X                = PK_blend_repair_fa_X_no_c,      \
       (options).xsection                   = PK_blend_xs_disc_c,             \
       (options).partition                  = PK_PARTITION_null,              \
       (options).n_limits                   = 0,                              \
       (options).limits                     = NULL,                           \
       (options).n_caps                     = 0,                              \
       (options).caps                       = NULL,                           \
       (options).reverse_cap                = NULL,                           \
       (options).update                     = PK_blend_update_default_c,      \
       (options).check_fa_fa                = PK_blend_check_fa_fa_yes_c,     \
       (options).track_edges                = PK_blend_track_edges_no_c,      \
       (options).trim_extent                = PK_blend_trim_extent_all_c,     \
       (options).have_help_point            = PK_LOGICAL_false,               \
       (options).help_point.coord[0]        = 0.0,                            \
       (options).help_point.coord[1]        = 0.0,                            \
       (options).help_point.coord[2]        = 0.0                             \
    )


/* PK_FACE_make_blend_o_t */

struct PK_FACE_make_blend_o_s
    {
    int                      o_t_version;   /* version number of options */
    PK_blend_trim_t          trim;          /* blend trimming option */
    PK_blend_walls_t         walls;         /* wall trimming option */
    PK_blend_shape_t         shape;         /* shape of blend */
    PK_blend_constraint_t    constraints;   /* constraints on blend */
    PK_blend_rib_control_t   rib_control;   /* blend section requests */
    double                   tolerance;     /* tolerance (1.0e-05) */
    PK_LOGICAL_t             have_help_point;
    PK_VECTOR_t              help_point;    /* help point */
    PK_LOGICAL_t             multiple;      /* create multiple blend sheets */
    PK_blend_propagate_t     propagate;     /* whether to propagate */
    PK_LOGICAL_t             notch;         /* enable blends to notch */
    PK_LOGICAL_t             local_check;   /* whether local checks required */
    PK_blend_local_check_t   checks;        /* which local checks to perform */
    PK_blend_update_t        update;        /* disable changes for updates */
    PK_SURF_t                user_surface;  /* user supplied blend surface */
    PK_blend_repair_su_X_t   repair_su_X;   /* whether to attempt to repair */
    PK_blend_inside_tight_t  inside_tight;  /* blend on the inside of tightly */
    PK_LOGICAL_t             have_propagation_angle;
    double                   propagation_angle;
    PK_blend_repair_fa_X_t   repair_fa_X;   /* whether to attempt to repair */
    PK_PARTITION_t           partition;     /*  a partition */
    PK_blend_prevent_sharp_t prevent_sharp; /* whether to attempt to prevent */
    PK_blend_track_edges_t   track_edges;   /* whether to provide laminar */
    PK_blend_tolerance_t     improve_tolerance;
    PK_blend_run_out_t       run_out;       /* whether to stop the blend when */
    double                   run_out_angle; /* the angle of normals used for */
    PK_blend_report_repaired_t
                             report;        /* whether to report any repaired */

    PK_extension_shape_t     extension_shape;
    PK_blend_use_master_faces_t
                             master_faces;

    PK_imprint_complete_t    imprint_complete;
    };

typedef struct PK_FACE_make_blend_o_s PK_FACE_make_blend_o_t;



/* PK_FACE_make_blend_o_m */

#define PK_FACE_make_blend_o_m(options)                                 \
    (                                                                   \
       (options).o_t_version          = 24,                             \
       (options).trim                 = PK_blend_trim_to_walls_c,       \
       (options).walls                = PK_blend_walls_attach_c,        \
       PK_blend_shape_m((options).shape),                               \
       PK_blend_constraint_m((options).constraints),                    \
       (options).tolerance            = 1.0e-05,                        \
       (options).have_help_point      = PK_LOGICAL_false,               \
       (options).help_point.coord[0]  = 0.0,                            \
       (options).help_point.coord[1]  = 0.0,                            \
       (options).help_point.coord[2]  = 0.0,                            \
       (options).multiple             = PK_LOGICAL_false,               \
       (options).propagate            = PK_blend_propagate_no_c,        \
       (options).notch                = PK_LOGICAL_false,               \
       (options).local_check          = PK_LOGICAL_false,               \
       PK_blend_rib_control_m((options).rib_control),                   \
       PK_blend_local_check_m((options).checks),                        \
       (options).update               = PK_blend_update_default_c,      \
       (options).user_surface         = PK_ENTITY_null,                 \
       (options).repair_su_X          = PK_blend_repair_su_X_no_c,      \
       (options).inside_tight         = PK_blend_inside_tight_no_c,     \
       (options).have_propagation_angle = PK_LOGICAL_false,             \
       (options).propagation_angle    = 0.0,                            \
       (options).repair_fa_X          = PK_blend_repair_fa_X_no_c,      \
       (options).partition            = PK_PARTITION_null,              \
       (options).prevent_sharp        = PK_blend_prevent_sharp_no_c,    \
       (options).track_edges          = PK_blend_track_edges_no_c,      \
       (options).improve_tolerance    = PK_blend_tolerance_standard_c,  \
       (options).run_out              = PK_blend_run_out_no_c,          \
       (options).run_out_angle        = 0.1,                            \
       (options).report               = PK_blend_report_repaired_no_c,  \
       (options).extension_shape      = PK_extension_shape_linear_c,    \
       (options).master_faces         = PK_blend_use_master_faces_yes_c,\
       (options).imprint_complete     = PK_imprint_complete_no_c        \
    )


/* PK_FACE_imprint_cus_isoclin_o_t */

struct PK_FACE_imprint_cus_isoclin_o_s
    {
    int            o_t_version;     /* version number of option structure */
    PK_LOGICAL_t   old_iso;         /* whether former isocline curves are */
    PK_LOGICAL_t   all_points;      /* whether curves using all the control */
    PK_LOGICAL_t   want_ret_faces;  /* whether returned faces are required */
    PK_LOGICAL_t   want_is_steep;   /* whether steepness data are required */
    PK_LOGICAL_t   want_new_edges;  /* whether new edges are required */
    };
typedef struct PK_FACE_imprint_cus_isoclin_o_s PK_FACE_imprint_cus_isoclin_o_t;


/* PK_FACE_imprint_cus_isoclin_o_m */

#define PK_FACE_imprint_cus_isoclin_o_m(options)             \
    (                                                        \
        (options).o_t_version     = 1,                       \
        (options).old_iso         = PK_LOGICAL_false,        \
        (options).all_points      = PK_LOGICAL_true,         \
        (options).want_ret_faces  = PK_LOGICAL_true,         \
        (options).want_is_steep   = PK_LOGICAL_true,         \
        (options).want_new_edges  = PK_LOGICAL_true          \
    )


/* PK_FACE_taper_o_t */

struct PK_FACE_taper_o_s
    {
    int                     o_t_version;    /* version number of option */
    PK_LOGICAL_t            merge_face;     /* whether tapered faces are to */
    PK_check_fa_fa_t        check_fa_fa;    /* check for face-face */
    PK_EDGE_array_t         tapered_edges;  /* tapered step edges */
    PK_EDGE_array_t         normal_edges;   /* normal step edges */
    PK_taper_method_t       method;         /* main face taper method */
    double                  offset;         /* offset value (0.0) */
    PK_SURF_t               top_surface;    /* top surface (PK_ENTITY_null) */
    PK_taper_smooth_step_t  taper_smooth_step;
    PK_taper_step_face_t    taper_step_face;
    int                     n_faces;        /* number of faces, which are */
    const PK_FACE_t        *taper_faces;    /* faces which are tapered with */
    const double           *angles;         /* different taper angles. Size */
    PK_taper_laminar_edge_t position;       /* defines to how process */
    PK_FACE_grow_t          grow;           /* controls which faces to grow */
    PK_local_ops_update_t   update;         /* update flag */
    int                     n_parting_edges;
    const PK_ENTITY_t      *parting_edges;  /* parting body step edges (NULL) */
    PK_BODY_t               parting_body;   /* parting body (PK_ENTITY_null) */
    };
typedef struct PK_FACE_taper_o_s PK_FACE_taper_o_t;


/* PK_FACE_taper_o_m */

#define PK_FACE_taper_o_m(options)                                       \
       ((options).o_t_version          = 10,                             \
        (options).merge_face           = PK_LOGICAL_true,                \
        (options).check_fa_fa          = PK_check_fa_fa_yes_c,           \
        (options).tapered_edges.length = 0,                              \
        (options).tapered_edges.array  = NULL,                           \
        (options).normal_edges.length  = 0,                              \
        (options).normal_edges.array   = NULL,                           \
        (options).method               = PK_taper_method_isocline_c,     \
        (options).offset               = 0.0,                            \
        (options).top_surface          = PK_ENTITY_null,                 \
        (options).taper_smooth_step    = PK_taper_smooth_step_no_c,      \
        (options).taper_step_face      = PK_taper_step_face_no_c,        \
        (options).n_faces              = 0,                              \
        (options).taper_faces          = NULL,                           \
        (options).angles               = NULL,                           \
        (options).position             = PK_taper_laminar_edge_normal_c, \
        (options).grow                 = PK_FACE_grow_update_c,          \
        (options).update               = PK_local_ops_update_default_c,  \
        (options).n_parting_edges      = 0,                              \
        (options).parting_edges        = NULL,                           \
        (options).parting_body         = PK_ENTITY_null                  \
       )


/* PK_FACE_offset_o_t */

struct PK_FACE_offset_o_s
    {
    int                o_t_version;      /* version number of option structure */
    PK_LOGICAL_t       allow_disjoint;   /* whether disjoint body can be */
    PK_check_fa_fa_t   check_fa_fa;      /* check for face-face inconsistencies */
    PK_offset_method_t offset_method;    /* offset method */
    PK_LOGICAL_t       report_sx;        /* whether to report faces that have */
    PK_fix_degens_t    fix_degens;       /* control on repairing surface */
    PK_LOGICAL_t       report_fix_degens;
    PK_offset_step_t   offset_step;      /* whether to create a step offset */
    PK_LOGICAL_t       ortho_vx_split;   /* Split laminar vertices during */
    PK_offset_track_del_t
                       track_del;        /* How to track deleted faces */
    PK_EDGE_offset_blend_t
                       blend_edges;      /* Offset edges as blend faces */
    double             blend_radius;     /* Radius of blend faces created if */
    PK_FACE_grow_t     grow;             /* controls which faces to grow */
    PK_VERTEX_limit_t  vertex_limit;     /* How to constrain the maximum */
    PK_EDGE_limit_t    edge_limit;       /* How to constrain the maximum */
    PK_local_ops_update_t
                       update;           /* update flag */
    };
typedef struct PK_FACE_offset_o_s PK_FACE_offset_o_t;


/* PK_FACE_offset_o_m */

#define PK_FACE_offset_o_m(options)                                   \
       ((options).o_t_version       = 11,                             \
        (options).allow_disjoint    = PK_LOGICAL_false,               \
        (options).check_fa_fa       = PK_check_fa_fa_yes_c,           \
        (options).offset_method     = PK_offset_method_sx_trim_c,     \
        (options).report_sx         = PK_LOGICAL_false,               \
        (options).fix_degens        = PK_fix_degens_no_c,             \
        (options).report_fix_degens = PK_LOGICAL_false,               \
        (options).offset_step       = PK_offset_step_no_c,            \
        (options).ortho_vx_split    = PK_LOGICAL_false,               \
        (options).track_del         = PK_offset_track_del_no_c,       \
        (options).blend_edges       = PK_EDGE_offset_blend_no_c,      \
        (options).blend_radius      = 0.0,                            \
        (options).grow              = PK_FACE_grow_update_c,          \
        (options).vertex_limit      = PK_VERTEX_limit_no_c,           \
        (options).edge_limit        = PK_EDGE_limit_no_c,             \
        (options).update            = PK_local_ops_update_default_c   \
       )


/* PK_FACE_output_surf_trimmed_o_t */

struct PK_FACE_output_surf_trimmed_o_s
    {
    int                    o_t_version;      /* option structure version */
    PK_FACE_trim_surf_t    trim_surf;        /* what surface to use */
    PK_LOGICAL_t           cubic;            /* bsurf to be cubic */
    PK_LOGICAL_t           non_rational;     /* bsurf to be non-rational */
    double                 surf_tolerance;   /* tolerance for creating bsurf */
    PK_LOGICAL_t           extend_surf;      /* is surface extension allowed */
    PK_FACE_trim_confine_t confine;          /* confinement */
    double                 curve_tolerance;  /* tolerance for creating spcurves */
    PK_FACE_trim_degen_t   degen;            /* in/exclude degeneracies */
    PK_LOGICAL_t           want_geoms;       /* whether geometry required */
    PK_LOGICAL_t           want_topols;      /* whether topology required */
    };

typedef struct PK_FACE_output_surf_trimmed_o_s
               PK_FACE_output_surf_trimmed_o_t;



/* PK_FACE_output_surf_trimmed_o_m */

#define PK_FACE_output_surf_trimmed_o_m(options)                   \
    (                                                              \
       (options).o_t_version     = 1,                              \
       (options).trim_surf       = PK_FACE_trim_surf_own_c,        \
       (options).cubic           = PK_LOGICAL_false,               \
       (options).non_rational    = PK_LOGICAL_false,               \
       (options).surf_tolerance  = 0.00001,                        \
       (options).extend_surf     = PK_LOGICAL_true,                \
       (options).confine         = PK_FACE_trim_confine_closed_c,  \
       (options).curve_tolerance = 0.0001,                         \
       (options).degen           = PK_FACE_trim_degen_no_c,        \
       (options).want_geoms      = PK_LOGICAL_false,               \
       (options).want_topols     = PK_LOGICAL_false                \
    )


/* PK_pattern_face_map_t */

struct PK_pattern_face_map_s
    {
    int                      n_loops;        /* number of boundary loops which */
    const PK_LOOP_t         *base_loops;     /* boundary loops defining the */
    const PK_FACE_t         *target_faces;   /* For each boundary loop, the */
    };
typedef struct PK_pattern_face_map_s PK_pattern_face_map_t;


/* PK_pattern_face_map_m */

#define PK_pattern_face_map_m(map)                                  \
      ((map).n_loops               = 0,                             \
       (map).base_loops            = NULL,                          \
       (map).target_faces          = NULL                           \
      )


/* PK_FACE_pattern_o_t */

struct PK_FACE_pattern_o_s
    {
    int                       o_t_version;   /* version number */
    PK_pattern_check_loops_t  check_loops;   /* (PK_pattern_check_loops_no_c) */
    PK_pattern_check_fa_fa_t  check_fa_fa;   /* (PK_pattern_check_fa_fa_no_c) */
    PK_pattern_same_face_t    same_face;     /* (PK_pattern_same_face_yes_c) */
    PK_pattern_coi_face_t     coi_face;      /* (PK_pattern_coi_face_yes_c) */
    PK_pattern_reblend_t      reblend;       /* (PK_pattern_reblend_no_c) */
    PK_pattern_face_map_t    *face_maps;     /* array of face maps for pattern */
    PK_pattern_collision_t    collision;     /* whether to output errors */
    };
typedef struct PK_FACE_pattern_o_s PK_FACE_pattern_o_t;



/* PK_FACE_pattern_o_m */


#define PK_FACE_pattern_o_m(options)                                \
       ((options).o_t_version      = 6,                             \
        (options).check_loops      = PK_pattern_check_loops_no_c,   \
        (options).check_fa_fa      = PK_pattern_check_fa_fa_no_c,   \
        (options).same_face        = PK_pattern_same_face_yes_c,    \
        (options).coi_face         = PK_pattern_coi_face_yes_c,     \
        (options).reblend          = PK_pattern_reblend_no_c,       \
        (options).face_maps        = NULL,                          \
        (options).collision        = PK_pattern_collision_no_c      \
       )


/* PK_FACE_pattern_data_r_t */

struct PK_FACE_pattern_data_r_s
    {
    PK_pattern_status_t        status;
    int                        n_pattern_faces;
    PK_FACE_t                 *pattern_faces;
    int                        n_error_topols;
    PK_TOPOL_t                *error_topols;
    };
typedef struct PK_FACE_pattern_data_r_s PK_FACE_pattern_data_r_t;



/* PK_FACE_pattern_r_t */

struct PK_FACE_pattern_r_s
    {
    PK_pattern_result_t        result;
    int                        n_patterns;
    PK_FACE_pattern_data_r_t  *patterns;
    int                        n_error_topols;
    PK_TOPOL_t                *error_topols;
    };
typedef struct PK_FACE_pattern_r_s PK_FACE_pattern_r_t;



/* PK_replace_edge_data_t */

struct PK_replace_edge_data_s
    {
    int                          n_edges;  /* number of edges (0) */
    const PK_EDGE_t               *edges;  /* edges to have curves replaced */
    const PK_CURVE_t             *curves;  /* replacement curves (NULL) */
    const double             *tolerances;  /* desired edge tolerances (NULL) */
    PK_replace_use_t         replace_use;  /* whether new geometry may be */
    };

typedef struct PK_replace_edge_data_s PK_replace_edge_data_t;



/* PK_replace_edge_data_m */

#define PK_replace_edge_data_m(edge_data)                         \
      ((edge_data).n_edges        = 0,                            \
       (edge_data).edges          = NULL,                         \
       (edge_data).curves         = NULL,                         \
       (edge_data).tolerances     = NULL,                         \
       (edge_data).replace_use    = PK_replace_use_attempt_c      \
      )


/* PK_change_edge_geom_data_t */

struct PK_change_edge_geom_data_s
    {
    int                     n_edge_arrays;  /* number of arrays of edges with */
    const PK_EDGE_array_t  *edge_arrays;    /* arrays of edges for which the */
    const PK_ENTITY_t      *entities;       /* array containing the entity to */
    const PK_LOGICAL_t     *reversals;      /* array of logicals indicating */
    const double           *offsets;        /* array of signed distances by */
    const PK_TRANSF_t      *transforms;     /* array of transforms to be */
    const double           *tolerances;     /* array of tolerances desired for */
    const PK_replace_use_t *replace_uses;   /* array of controls on how the */
    };

typedef struct PK_change_edge_geom_data_s PK_change_edge_geom_data_t;



/* PK_change_edge_geom_data_m */

#define PK_change_edge_geom_data_m(edge_geom_data)                       \
      ((edge_geom_data).n_edge_arrays        = 0,                        \
       (edge_geom_data).edge_arrays          = NULL,                     \
       (edge_geom_data).entities             = NULL,                     \
       (edge_geom_data).reversals            = NULL,                     \
       (edge_geom_data).offsets              = NULL,                     \
       (edge_geom_data).transforms           = NULL,                     \
       (edge_geom_data).tolerances           = NULL,                     \
       (edge_geom_data).replace_uses         = NULL                      \
      )


/* PK_replace_vertex_data_t */

struct PK_replace_vertex_data_s
    {
    int                n_vertices;    /* number of vertices (0) */
    const PK_VERTEX_t *vertices;      /* vertices to have positions */
    const PK_VECTOR_t *positions;     /* vertices replacement positions (NULL) */
    const double      *tolerances;    /* desired vertex tolerances (NULL) */
    };

typedef struct PK_replace_vertex_data_s PK_replace_vertex_data_t;



/* PK_replace_vertex_data_m */

#define PK_replace_vertex_data_m(vertex_data)                       \
      ((vertex_data).n_vertices     = 0,                            \
       (vertex_data).vertices       = NULL,                         \
       (vertex_data).positions      = NULL,                         \
       (vertex_data).tolerances     = NULL                          \
      )


/* PK_replace_help_points_t */

struct PK_replace_help_points_s
    {
    int                n_topologies;  /* number of topologies (0) */
    const PK_TOPOL_t  *topologies;    /* topologies needing help points (NULL) */
    const PK_VECTOR_t *positions;     /* help point positions (NULL) */
    };

typedef struct PK_replace_help_points_s PK_replace_help_points_t;



/* PK_replace_help_points_m */

#define PK_replace_help_points_m(help_points)                       \
      ((help_points).n_topologies   = 0,                            \
       (help_points).topologies     = NULL,                         \
       (help_points).positions      = NULL                          \
      )


/* PK_replace_variation_data_t */

struct PK_replace_variation_data_s
    {
    PK_replace_variation_t     variation;  /* whether the surfaces are replaced */
    int                n_variation_faces;  /* number of faces (0) */
    const PK_FACE_t     *variation_faces;  /* faces to have surfaces replaced */
    };

typedef struct PK_replace_variation_data_s PK_replace_variation_data_t;



/* PK_replace_variation_data_m */

#define PK_replace_variation_data_m(variation_data)                          \
      ((variation_data).variation           = PK_replace_variation_no_c,     \
       (variation_data).n_variation_faces   = 0,                             \
       (variation_data).variation_faces     = NULL                           \
      )


/* PK_FACE_replace_surfs_o_t */

struct PK_FACE_replace_surfs_o_s
    {
    int                       o_t_version;   /* version number */
    PK_check_fa_fa_t          check_fa_fa;   /* check for face-face */
    PK_replace_edge_data_t    edge_data;     /* replace data for edges */
    PK_replace_vertex_data_t  vertex_data;   /* replace data for vertices */
    PK_replace_help_points_t  edge_help;     /* edge help points */
    PK_replace_help_points_t  vertex_help;   /* vertex help points */
    PK_replace_merge_t        merge;         /* whether changed faces are to */
    PK_replace_adjust_t       adjust;        /* whether topology of the part */
    PK_local_ops_update_t     update;        /* update flag */
    PK_replace_variation_data_t
                              variation_data;
    };

typedef struct PK_FACE_replace_surfs_o_s PK_FACE_replace_surfs_o_t;



/* PK_FACE_replace_surfs_o_m */


#define PK_FACE_replace_surfs_o_m(options)                                \
       ((options).o_t_version            = 6,                             \
        (options).check_fa_fa            = PK_check_fa_fa_yes_c,          \
        PK_replace_edge_data_m((options).edge_data),                      \
        PK_replace_vertex_data_m((options).vertex_data),                  \
        PK_replace_help_points_m((options).edge_help),                    \
        PK_replace_help_points_m((options).vertex_help),                  \
        (options).merge                  = PK_replace_merge_no_c,         \
        (options).adjust                 = PK_replace_adjust_yes_c,       \
        (options).update                 = PK_local_ops_update_default_c, \
        PK_replace_variation_data_m((options).variation_data)             \
       )



/* PK_FACE_replace_surfs_r_t */

struct PK_FACE_replace_surfs_r_s
    {
    PK_local_status_t          status;
    int                        n_error_entities;
    PK_ENTITY_t                *error_entities;
    };
typedef struct PK_FACE_replace_surfs_r_s PK_FACE_replace_surfs_r_t;



/* PK_replace_patch_data_t */

struct PK_replace_patch_data_s
    {
    PK_replace_patch_t  patch_type;      /* whether target faces are replaced */
    int                 n_matches;       /* number of matched faces (0) */
    const PK_FACE_t    *tool_patches;    /* the tool faces to replace the */
    const PK_FACE_t    *target_patches;  /* the target faces to be replaced by */
    int                 n_patch_edges;   /* number of patch edges (0) */
    const PK_EDGE_t    *patch_edges;     /* boundary edges of patch tool */
    };

typedef struct PK_replace_patch_data_s PK_replace_patch_data_t;



/* PK_replace_patch_data_m */

#define PK_replace_patch_data_m(patch_data)                          \
      ((patch_data).patch_type           = PK_replace_patch_no_c,    \
       (patch_data).n_matches            = 0,                        \
       (patch_data).tool_patches         = NULL,                     \
       (patch_data).target_patches       = NULL,                     \
       (patch_data).n_patch_edges        = 0,                        \
       (patch_data).patch_edges          = NULL                      \
      )


/* PK_FACE_replace_with_sheet_o_t */

struct PK_FACE_replace_with_sheet_o_s
    {
    int                       o_t_version;  /* version number */
    double                    tolerance;    /* tolerance for operation */
    PK_check_fa_fa_t          check_fa_fa;  /* check for face-face */
    PK_replace_patch_data_t   patch_data;   /* patch data for faces */
    };

typedef struct PK_FACE_replace_with_sheet_o_s PK_FACE_replace_with_sheet_o_t;



/* PK_FACE_replace_with_sheet_o_m */


#define PK_FACE_replace_with_sheet_o_m(options)                     \
       ((options).o_t_version      = 3,                             \
        (options).tolerance        = 1.0e-06,                       \
        (options).check_fa_fa      = PK_check_fa_fa_yes_c,          \
        PK_replace_patch_data_m((options).patch_data)               \
       )



/* PK_FACE_cover_o_t */

struct PK_FACE_cover_o_s
    {
    int                    o_t_version;     /* version number */
    double                 fitting_tolerance;
    PK_LOGICAL_t           have_bdry_tolerance;
    double                 bdry_tolerance;  /* optional distance tolerance to */
    PK_FACE_cover_smooth_t maintain_bdry_smoothness;
    PK_FACE_cover_output_t output;          /* the form in which to output the */
    PK_FACE_cover_update_t update;          /* update version */
    };

typedef struct PK_FACE_cover_o_s PK_FACE_cover_o_t;



/* PK_FACE_cover_o_m */


#define PK_FACE_cover_o_m(options)                                          \
       ((options).o_t_version              = 2,                             \
        (options).fitting_tolerance        = 1.0e-5,                        \
        (options).have_bdry_tolerance      = PK_LOGICAL_false,              \
        (options).bdry_tolerance           = 0.0,                           \
        (options).maintain_bdry_smoothness = PK_FACE_cover_smooth_no_c,     \
        (options).output                   = PK_FACE_cover_output_replace_c,\
        (options).update                   = PK_FACE_cover_update_default_c \
       )



/* PK_FACE_change_data_offset_t */

struct PK_FACE_change_data_offset_s
    {
    double   distance;               /* offset distance */
    };
typedef struct PK_FACE_change_data_offset_s PK_FACE_change_data_offset_t;


/* PK_FACE_change_data_taper_t */

struct PK_FACE_change_data_taper_s
    {
    PK_VECTOR_t         direction;         /* taper direction */
    double              angle;             /* taper angle (radian) */
    int                 n_refs;            /* number of reference entities */
    const PK_ENTITY_t  *references;        /* taper reference entities */
    };
typedef struct PK_FACE_change_data_taper_s PK_FACE_change_data_taper_t;


/* PK_FACE_change_data_transform_t */

struct PK_FACE_change_data_transform_s
    {
    PK_TRANSF_t  transform;         /* transform */
    };
typedef struct PK_FACE_change_data_transform_s PK_FACE_change_data_transform_t;


/* PK_FACE_change_data_replace_t */

struct PK_FACE_change_data_replace_s
    {
    PK_SURF_t     surface;           /* replace surface */
    PK_LOGICAL_t  sense;             /* replace surface orientation */
    };
typedef struct PK_FACE_change_data_replace_s PK_FACE_change_data_replace_t;


/* PK_FACE_change_data_blend_t */

typedef void* PK_FACE_change_data_blend_t;


/* PK_FACE_change_data_bend_t */

struct PK_FACE_change_data_bend_s
    {
    PK_FACE_change_bend_type_t type;             /* the type of this bend face */
    PK_ENTITY_t                tool_entity;      /* entity used to construct */
    double                     offset;           /* forward offset distance */
    double                     backward_offset;  /* backward offset distance */
    };
typedef struct PK_FACE_change_data_bend_s PK_FACE_change_data_bend_t;


/* PK_FACE_change_data_patch_t */

struct PK_FACE_change_data_patch_s
    {
    PK_TOPOL_t                 sheet;            /* replacement topology used */
    };
typedef struct PK_FACE_change_data_patch_s PK_FACE_change_data_patch_t;


/* PK_FACE_change_deform_eval_f_t */

typedef PK_ERROR_code_t(*PK_FACE_change_deform_eval_f_t)
(
/* received */
PK_VECTOR_t               /*position*/,          /* input position */
PK_FACE_t                 /*face*/,              /* face for this operation */
PK_LOGICAL_t              /*have_params*/,       /* whether surface parameters are */
PK_UV_t                   /*params*/,            /* parameters on the surface of the */
PK_POINTER_t              /*external_data*/,     /* external application data */
/* returned */
PK_VECTOR_t       *const  /*deformed_position*/  /* deformed position */
);



/* PK_FACE_change_data_deform_t */

struct PK_FACE_change_data_deform_s
    {
    PK_FACE_change_deform_eval_f_t eval_fn;      /* user evaluator */
    PK_POINTER_t                   eval_data;    /* evaluator data */
    };
typedef struct PK_FACE_change_data_deform_s PK_FACE_change_data_deform_t;


/* PK_FACE_change_data_t */

union PK_FACE_change_data_u
    {
    PK_FACE_change_data_offset_t    offset;     /* offset parameters */
    PK_FACE_change_data_taper_t     taper;      /* taper parameters */
    PK_FACE_change_data_transform_t transform;  /* transform parameters */
    PK_FACE_change_data_replace_t   replace;    /* replace parameters */
    PK_FACE_change_data_blend_t     blend;      /* blend parameters */
    PK_FACE_change_data_bend_t      bend;       /* bend parameters */
    PK_FACE_change_data_patch_t     patch;      /* patch parameters */
    PK_FACE_change_data_deform_t    deform;     /* deform parameters */
    };
typedef union PK_FACE_change_data_u PK_FACE_change_data_t;


/* PK_FACE_change_taper_o_t */

struct PK_FACE_change_taper_o_s
    {
    int                     o_t_version;    /* version number of option */
    PK_EDGE_array_t         tapered_edges;  /* tapered step edges */
    PK_EDGE_array_t         normal_edges;   /* normal step edges */
    PK_taper_method_t       method;         /* main face taper method */
    PK_taper_smooth_step_t  taper_smooth_step;
    PK_taper_step_face_t    taper_step_face;
    PK_taper_laminar_edge_t position;       /* defines to how process */
    int                     n_parting_edges;
    const PK_ENTITY_t      *parting_edges;  /* parting body step edges (NULL) */
    PK_BODY_t               parting_body;   /* parting body (PK_ENTITY_null) */
    };
typedef struct PK_FACE_change_taper_o_s PK_FACE_change_taper_o_t;


/* PK_FACE_change_taper_o_m */

#define PK_FACE_change_taper_o_m(options)                               \
       ((options).o_t_version          = 5,                             \
        (options).tapered_edges.length = 0,                             \
        (options).tapered_edges.array  = NULL,                          \
        (options).normal_edges.length  = 0,                             \
        (options).normal_edges.array   = NULL,                          \
        (options).method               = PK_taper_method_curve_c,       \
        (options).taper_smooth_step    = PK_taper_smooth_step_no_c,     \
        (options).taper_step_face      = PK_taper_step_face_no_c,       \
        (options).position             = PK_taper_laminar_edge_normal_c,\
        (options).n_parting_edges      = 0,                             \
        (options).parting_edges        = NULL,                          \
        (options).parting_body         = PK_ENTITY_null                 \
       )


/* PK_FACE_change_offset_o_t */

struct PK_FACE_change_offset_o_s
    {
    int                o_t_version;
    PK_offset_method_t offset_method;    /* offset method */
    PK_LOGICAL_t       report_sx;        /* whether to report faces that have */
    PK_fix_degens_t    fix_degens;       /* control on repairing surface */
    PK_LOGICAL_t       report_fix_degens;
    PK_offset_step_t   offset_step;      /* whether to create a step offset */
    PK_FACE_t          reference;        /* reference face (PK_ENTITY_null) */
    PK_ref_alignment_t ref_alignment;    /* alignment for reference face */
    };
typedef struct PK_FACE_change_offset_o_s PK_FACE_change_offset_o_t;


/* PK_FACE_change_offset_o_m */

#define PK_FACE_change_offset_o_m(opt)                         \
    ((opt).o_t_version       = 5,                              \
     (opt).offset_method     = PK_offset_method_sx_trim_c,     \
     (opt).report_sx         = PK_LOGICAL_false,               \
     (opt).fix_degens        = PK_fix_degens_no_c,             \
     (opt).report_fix_degens = PK_LOGICAL_false,               \
     (opt).offset_step       = PK_offset_step_no_c,            \
     (opt).reference         = PK_ENTITY_null,                 \
     (opt).ref_alignment     = PK_ref_alignment_opposed_c      \
    )


/* PK_FACE_change_transform_o_t */

struct PK_FACE_change_transform_o_s
    {
    int                      o_t_version;
    int                      n_loops;       /* number of boundary loops of the */
    const PK_LOOP_t         *base_loops;    /* boundary loops of the faces */
    const PK_FACE_t         *target_faces;  /* For each boundary loop, the */
    PK_transform_step_t      transform_step;


    };
typedef struct PK_FACE_change_transform_o_s PK_FACE_change_transform_o_t;


/* PK_FACE_change_transform_o_m */

#define PK_FACE_change_transform_o_m(opt)               \
    ((opt).o_t_version = 3,                             \
     (opt).n_loops     = 0,                             \
     (opt).base_loops  = NULL,                          \
     (opt).target_faces = NULL,                         \
     (opt).transform_step = PK_transform_step_no_c      \
    )


/* PK_FACE_change_replace_o_t */

struct PK_FACE_change_replace_o_s
    {
    int                    o_t_version;  /* version number of option structure */
    PK_replace_merge_t     merge;        /* whether changed faces are to be */
    PK_replace_variation_t variation;    /* whether the surface of the face is */
    };
typedef struct PK_FACE_change_replace_o_s PK_FACE_change_replace_o_t;


/* PK_FACE_change_replace_o_m */

#define PK_FACE_change_replace_o_m(opt)                         \
    ((opt).o_t_version = 3,                                     \
     (opt).merge       = PK_replace_merge_no_c,                 \
     (opt).variation   = PK_replace_variation_no_c              \
    )


/* PK_FACE_change_blend_o_t */

struct PK_FACE_change_blend_o_s
    {
    int                     o_t_version;     /* version number of option */
    PK_blend_xs_shape_t     xs_shape;        /* cross-section shape */
    double                  radius;          /* radius of blend when reapplied */
    int                     n_unders;        /* number of underlying faces of */
    const PK_ENTITY_t      *unders;          /* faces used to define the blend */
    const PK_blend_orientation_t
                           *orientations;    /* which side of each of the */
    const double           *ranges;          /* ranges on each of the unders */
    PK_blend_ov_smooth_t    ov_smooth;       /* control smooth overflow */
    };
typedef struct PK_FACE_change_blend_o_s PK_FACE_change_blend_o_t;


/* PK_FACE_change_blend_o_m */

#define PK_FACE_change_blend_o_m(opt)                           \
    ((opt).o_t_version    = 5,                                     \
     (opt).xs_shape       = PK_blend_xs_shape_conic_c,             \
     (opt).radius         = 0.0,                                   \
     (opt).n_unders       = 0,                                     \
     (opt).unders         = NULL,                                  \
     (opt).orientations   = NULL,                                  \
     (opt).ranges         = NULL,                                  \
     (opt).ov_smooth      = PK_blend_ov_smooth_diff_c              \
    )


/* PK_FACE_change_bend_o_t */

struct PK_FACE_change_bend_o_s
    {
    int                o_t_version;      /* version number of option structure */
    PK_bend_merge_t    merge;            /* whether changed faces are to be */
    };
typedef struct PK_FACE_change_bend_o_s PK_FACE_change_bend_o_t;


/* PK_FACE_change_bend_o_m */

#define PK_FACE_change_bend_o_m(opt) \
    ((opt).o_t_version = 1,                                     \
     (opt).merge       = PK_bend_merge_no_c                     \
    )


/* PK_FACE_change_patch_o_t */

struct PK_FACE_change_patch_o_s
    {
    int                     o_t_version;  /* version number of option structure */
    PK_replace_patch_data_t patch_data;   /* patch data for faces */
    PK_patch_mobility_t     mobility;     /* mobility of patch */
    };
typedef struct PK_FACE_change_patch_o_s PK_FACE_change_patch_o_t;


/* PK_FACE_change_patch_o_m */

#define PK_FACE_change_patch_o_m(opt)                           \
    ((opt).o_t_version = 3,                                     \
     PK_replace_patch_data_m((opt).patch_data),                 \
     (opt).mobility = PK_patch_mobility_fixed_c                 \
    )


/* PK_FACE_change_deform_o_t */

struct PK_FACE_change_deform_o_s
    {
    int              o_t_version;      /* version number of option structure */
    int              n_matched_edges;  /* number of matched edges (0) */
    const PK_EDGE_t *matched_edges;    /* matched edges (NULL) */
    PK_deform_uv_t   deform_uv;        /* control uvboxes of resultant deformed */
    PK_LOGICAL_t     thread_safe;      /* whether the external evaluator */
    };
typedef struct PK_FACE_change_deform_o_s PK_FACE_change_deform_o_t;


/* PK_FACE_change_deform_o_m */

#define PK_FACE_change_deform_o_m(opt)                \
    ((opt).o_t_version     = 1,                       \
     (opt).n_matched_edges = 0,                       \
     (opt).matched_edges   = NULL,                    \
     (opt).deform_uv       = PK_deform_uv_face_box_c, \
     (opt).thread_safe     = PK_LOGICAL_false         \
    )


/* PK_FACE_change_opts_t */

union PK_FACE_change_opts_u
    {
    const PK_FACE_change_offset_o_t    *offset;     /* offset specific options */
    const PK_FACE_change_taper_o_t     *taper;      /* taper specific options */
    const PK_FACE_change_transform_o_t *transform;  /* transform specific opts */
    const PK_FACE_change_replace_o_t   *replace;    /* replace specific options */
    const PK_FACE_change_blend_o_t     *blend;      /* blend specific options */
    const PK_FACE_change_bend_o_t      *bend;       /* bend specific options */
    const PK_FACE_change_patch_o_t     *patch;      /* patch specific options */
    const PK_FACE_change_deform_o_t    *deform;     /* deform specific options */
    };
typedef union PK_FACE_change_opts_u PK_FACE_change_opts_t;


/* PK_FACE_change_t */

struct PK_FACE_change_s
    {
    PK_FACE_change_type_t  op_type;     /* change operation type */
    PK_FACE_change_data_t  op_param;    /* change operation parameters */
    PK_FACE_change_opts_t  op_opts;     /* change operation options */
    };
typedef struct PK_FACE_change_s PK_FACE_change_t;


/* PK_FACE_change_o_t */

struct PK_FACE_change_o_s
    {
    int                       o_t_version;
    PK_LOGICAL_t              merge_face;
    PK_LOGICAL_t              allow_disjoint;
    PK_check_fa_fa_t          check_fa_fa;
    PK_change_edge_geom_data_t
                              edge_geom_data;
    PK_replace_edge_data_t    edge_data;   /* replace data for edges */
    PK_replace_vertex_data_t  vertex_data; /* replace data for vertices */
    PK_replace_help_points_t  edge_help;   /* edge help points */
    PK_replace_help_points_t  vertex_help; /* vertex help points */
    PK_replace_update_t       replace_update;
    PK_local_ops_update_t     update;      /* update flag */
    PK_FACE_prefer_adj_t      adjacency;   /* specifies how to control the */
    PK_FACE_grow_t            grow;        /* controls which faces to grow when */
    PK_FACE_grow_cb_f_t       grow_cb;     /* user callback function for */
    PK_POINTER_t              grow_data;   /* user data for callback function */
    PK_VERTEX_limit_t         vertex_limit;
    PK_EDGE_limit_t           edge_limit;
    PK_repair_fa_fa_t         repair_fa_fa;
    PK_FACE_trim_cb_f_t       trim_cb;     /* user callback function for */
    PK_POINTER_t              trim_data;   /* user data for callback function */
    PK_LOGICAL_t              report_surf_extension;
    PK_change_track_edges_t   track_edges; /* which edges to return tracking */
    PK_results_output_t       results_output;
    PK_repair_fa_t            repair_fa;   /* whether invalid faces should be */
    };
typedef struct PK_FACE_change_o_s PK_FACE_change_o_t;


/* PK_FACE_change_o_m */

#define PK_FACE_change_o_m(options)                                   \
       ((options).o_t_version      = 14,                              \
        (options).merge_face       = PK_LOGICAL_true,                 \
        (options).allow_disjoint   = PK_LOGICAL_false,                \
        (options).check_fa_fa      = PK_check_fa_fa_yes_c,            \
        PK_change_edge_geom_data_m((options).edge_geom_data),        \
        PK_replace_edge_data_m((options).edge_data),                  \
        PK_replace_vertex_data_m((options).vertex_data),              \
        PK_replace_help_points_m((options).edge_help),                \
        PK_replace_help_points_m((options).vertex_help),              \
        (options).replace_update   = PK_replace_update_default_c,     \
        (options).update           = PK_local_ops_update_default_c,   \
        (options).adjacency        = PK_FACE_prefer_adj_keep_c,       \
        (options).grow             = PK_FACE_grow_update_c,           \
        (options).grow_cb          = NULL,                            \
        (options).grow_data        = NULL,                            \
        (options).vertex_limit     = PK_VERTEX_limit_no_c,            \
        (options).edge_limit       = PK_EDGE_limit_no_c,              \
        (options).repair_fa_fa     = PK_repair_fa_fa_no_c,            \
        (options).trim_cb          = NULL,                            \
        (options).trim_data        = NULL,                            \
        (options).report_surf_extension = PK_LOGICAL_false,           \
        (options).track_edges      = PK_change_track_edges_no_c,      \
        (options).results_output   = PK_results_output_return_c,      \
        (options).repair_fa        = PK_repair_fa_yes_c               \
       )


/* PK_FACE_transform_o_t */

struct PK_FACE_transform_o_s
    {
    int                   o_t_version;   /* version number of option structure */
    PK_LOGICAL_t          merge_face;    /* whether transformed faces are to be */
    PK_check_fa_fa_t      check_fa_fa;   /* check for face-face inconsistencies */
    PK_FACE_prefer_adj_t  adjacency;     /* specifies how to control the */
    PK_transform_step_t   transform_step;
    PK_FACE_grow_t        grow;          /* controls which faces to grow */
    PK_local_ops_update_t update;        /* update flag */
    };
typedef struct PK_FACE_transform_o_s PK_FACE_transform_o_t;


/* PK_FACE_transform_o_m */

#define PK_FACE_transform_o_m(options)                              \
       ((options).o_t_version     = 5,                              \
        (options).merge_face      = PK_LOGICAL_true,                \
        (options).check_fa_fa     = PK_check_fa_fa_yes_c,           \
        (options).adjacency       = PK_FACE_prefer_adj_keep_c,      \
        (options).transform_step  = PK_transform_step_no_c,         \
        (options).grow            = PK_FACE_grow_update_c,          \
        (options).update          = PK_local_ops_update_default_c   \
       )


/* PK_hole_component_t */

struct PK_hole_component_s
    {
    PK_hole_comp_t hole_comp;   /* type of hole component */
    double         depth;       /* depth at bottom of component */
    double         data;        /* a parameter of component (eg radius) */
    PK_ENTITY_t    entity;      /* entity associated with component */
    };
typedef struct PK_hole_component_s PK_hole_component_t;



/* PK_detail_def_hole_t */

struct PK_detail_def_hole_s
    {
    PK_AXIS2_sf_t        origin;          /* hole's position and orientation */
    double               total_depth;     /* total depth of hole */
    double               smallest_radius; /* smallest radius of hole */
    PK_BODY_t            profile;         /* wire body profile */
    int                  cb_result;       /* result of callback function */
    int                  n_components;    /* number of hole components */
    PK_hole_component_t *components;      /* hole components */
    };
typedef struct PK_detail_def_hole_s PK_detail_def_hole_t;



/* PK_detail_hole_cb_f_t */

typedef int        (*PK_detail_hole_cb_f_t)
(
/* received */
int                   /*n_faces*/,    /* number of faces in hole detail */
const PK_FACE_t       /*faces*/[],    /* faces in hole detail */
PK_detail_def_hole_t  /*hole_def*/,   /* hole detail definition */
PK_POINTER_t          /*context*/     /* context */
);


/* PK_detail_hole_cb_t */

typedef PK_detail_hole_cb_f_t PK_detail_hole_cb_t;


/* PK_FACE_details_hole_o_t */

struct PK_FACE_details_hole_o_s
    {
    int                 o_t_version;        /* options structure version number */
    PK_VECTOR_t         up;                 /* up vector for through holes */
    PK_LOGICAL_t        include_zero_depth; /* whether zero depth components */
    PK_LOGICAL_t        want_profiles;      /* whether wire body profiles are */
    PK_LOGICAL_t        simplify_geom;      /* whether simplified geometry is */
    PK_detail_hole_cb_f_t
                        cb;                 /* callback function ( NULL ) */
    PK_POINTER_t        cb_context;         /* context for callback function */
    PK_LOGICAL_t        face_tracking;      /* whether extra face tracking */
    };
typedef struct PK_FACE_details_hole_o_s PK_FACE_details_hole_o_t;



/* PK_FACE_details_hole_o_m */

#define PK_FACE_details_hole_o_m(options)                  \
       ((options).o_t_version        = 2,                  \
        (options).up.coord[0]        = 0.0,                \
        (options).up.coord[1]        = 0.0,                \
        (options).up.coord[2]        = 1.0,                \
        (options).include_zero_depth = PK_LOGICAL_true,    \
        (options).want_profiles      = PK_LOGICAL_false,   \
        (options).simplify_geom      = PK_LOGICAL_false,   \
        (options).cb                 = NULL,               \
        (options).cb_context         = NULL,               \
        (options).face_tracking      = PK_LOGICAL_false    \
       )


/* PK_FACE_classify_details_o_t */

struct PK_FACE_classify_details_o_s
    {
    int                             o_t_version;  /* options structure version */
    const PK_FACE_details_hole_o_t *hole;         /* hole options ( NULL ) */
    };
typedef struct PK_FACE_classify_details_o_s PK_FACE_classify_details_o_t;



/* PK_FACE_classify_details_o_m */

#define PK_FACE_classify_details_o_m(options)              \
       ((options).o_t_version     = 1,                     \
        (options).hole            = NULL                   \
       )


/* PK_detail_def_t */

struct PK_detail_def_s
    {
    PK_detail_type_t              detail_type;  /* detail type */
    PK_FACE_array_t               faces;        /* faces comprising the detail */
    union {
            PK_detail_def_hole_t *hole;         /* hole detail definition */
            void                 *unknown;
          } detail;                             /* detail */
    };
typedef struct PK_detail_def_s PK_detail_def_t;



/* PK_FACE_classify_details_r_t */

struct PK_FACE_classify_details_r_s
    {
    int              n_detail_defs;  /* number of detail definitions */
    PK_detail_def_t *detail_defs;    /* array of detail definitions */
    };
typedef struct PK_FACE_classify_details_r_s PK_FACE_classify_details_r_t;



/* PK_INSTANCE_sf_t */


struct PK_INSTANCE_sf_s
    {
    PK_ASSEMBLY_t   assembly;    /* owning assembly */
    PK_TRANSF_t     transf;      /* transform (must be a rigid motion, or */
    PK_PART_t       part;        /* instanced part */
    };

typedef struct PK_INSTANCE_sf_s PK_INSTANCE_sf_t;


/* PK_LOOP_close_gaps_o_t */

struct PK_LOOP_close_gaps_o_s
    {
    int                    o_t_version;      /* options structure version. */
    PK_LOOP_3_space_gap_t  gap_in_3_space;   /* controls model space gaps at */
    PK_LOOP_2_space_gap_t  gap_in_2_space;   /* controls parameter space gaps */
    double                 tol_in_2_space;   /* tolerance value for */
    PK_LOOP_trim_geom_t    trim_fin_geom;    /* shorten the SP-curve geometry */
    };

typedef struct PK_LOOP_close_gaps_o_s PK_LOOP_close_gaps_o_t;



/* PK_LOOP_close_gaps_o_m */

#define PK_LOOP_close_gaps_o_m(options)                           \
    (                                                             \
       (options).o_t_version    = 4,                              \
       (options).gap_in_3_space = PK_LOOP_3_space_gap_close_c,    \
       (options).gap_in_2_space = PK_LOOP_2_space_gap_no_c,       \
       (options).tol_in_2_space = 1.0e-06,                        \
       (options).trim_fin_geom  = PK_LOOP_trim_geom_no_c          \
    )


/* PK_LOOP_offset_planar_o_t */

struct PK_LOOP_offset_planar_o_s
    {
    int             o_t_version;     /* version number */
    PK_LOOP_opl_gap_fill_t           /* how gaps at vertices are filled */
                    gap_fill;        /* (PK_LOOP_opl_gap_fill_round_c) */
    PK_LOGICAL_t    local_check;     /* local checks? (PK_LOGICAL_false) */
    double          tolerance;       /* tolerance for curve conversion (0) */
    };

typedef struct PK_LOOP_offset_planar_o_s PK_LOOP_offset_planar_o_t;



/* PK_LOOP_offset_planar_o_m */

#define PK_LOOP_offset_planar_o_m(options)                      \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).gap_fill       = PK_LOOP_opl_gap_fill_round_c, \
       (options).local_check    = PK_LOGICAL_false,             \
       (options).tolerance      = 0                             \
    )


/* PK_EDGE_ask_convexity_o_t */

struct PK_EDGE_ask_convexity_o_s
    {
    int             o_t_version;             /* version number of option */
    PK_LOGICAL_t    have_angular_tolerance;  /* whether angular tolerance */
    double          angular_tolerance;       /* angular tolerance */
    };

typedef struct PK_EDGE_ask_convexity_o_s PK_EDGE_ask_convexity_o_t;



/* PK_EDGE_ask_convexity_o_m */

#define PK_EDGE_ask_convexity_o_m(options)                            \
    (                                                                 \
       (options).o_t_version                = 1,                      \
       (options).have_angular_tolerance     = PK_LOGICAL_false,       \
       (options).angular_tolerance          = 0.0                     \
    )


/* PK_EDGE_attach_curves_o_t */

struct PK_EDGE_attach_curves_o_s
    {
    int                  o_t_version;    /* version number of options structure */
    int                  n_intervals;    /* the number of curve intervals */
    const PK_INTERVAL_t *intervals;      /* parametric intervals of curves */
    const int           *interval_map;   /* curve-interval mapping (NULL) */
    PK_LOGICAL_t         have_senses;    /* the senses array is set */
    const PK_LOGICAL_t  *senses;         /* the orientations of curves with */
    PK_GEOM_copy_t       copy_curves;    /* whether to copy curves before */
    PK_check_vx_on_cu_t  vx_checking;    /* how to enforce vertex checking */
    PK_check_geom_t      geom_checking;  /* whether to enforce geometry */
    PK_EDGE_attach_update_t
                         update;         /* update switch */
    };

typedef struct PK_EDGE_attach_curves_o_s PK_EDGE_attach_curves_o_t;



/* PK_EDGE_attach_curves_o_m */

#define PK_EDGE_attach_curves_o_m(options)                              \
    (                                                                   \
       (options).o_t_version         = 2,                               \
       (options).n_intervals         = 0,                               \
       (options).intervals           = NULL,                            \
       (options).interval_map        = NULL,                            \
       (options).have_senses         = PK_LOGICAL_false,                \
       (options).senses              = NULL,                            \
       (options).copy_curves         = PK_GEOM_copy_auto_c,             \
       (options).vx_checking         = PK_check_vx_on_cu_all_c,         \
       (options).geom_checking       = PK_check_geom_yes_c,             \
       (options).update              = PK_EDGE_attach_update_default_c  \
    )


/* PK_EDGE_attach_curve_nmnl_o_t */

struct PK_EDGE_attach_curve_nmnl_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_interval;   /* t_int is set (PK_LOGICAL_false) */
    PK_INTERVAL_t       t_int;           /* Parametric interval of edge (0,1) */
    };

typedef struct PK_EDGE_attach_curve_nmnl_o_s PK_EDGE_attach_curve_nmnl_o_t;



/* PK_EDGE_attach_curve_nmnl_o_m */

#define PK_EDGE_attach_curve_nmnl_o_m(options)          \
    (                                                   \
       (options).o_t_version = 1,                       \
       (options).have_interval = PK_LOGICAL_false,      \
       (options).t_int.value[0] = 0.0,                  \
       (options).t_int.value[1] = 1.0                   \
    )


/* PK_EDGE_delete_o_t */

struct PK_EDGE_delete_o_s
    {
    int                   o_t_version;   /* version number of option structure */
    PK_local_ops_update_t update;        /* update flag */
    };

typedef struct PK_EDGE_delete_o_s PK_EDGE_delete_o_t;



/* PK_EDGE_delete_o_m */

#define PK_EDGE_delete_o_m(options)                         \
    (                                                       \
      (options).o_t_version = 2,                            \
      (options).update      = PK_local_ops_update_default_c \
    )


/* PK_EDGE_find_deviation_t */

struct PK_EDGE_find_deviation_s
    {
    int                n_distances;      /* number of distances returned */
    double            *distances;        /* distances */
    PK_VECTOR_t       *edge1_vecs;       /* points on `edge1' */
    PK_VECTOR_t       *edge2_vecs;       /* corresponding points on`edge2' */
    PK_INTERVAL_t      interval1;        /* interval on `edge1' */
    PK_INTERVAL_t      interval2;        /* interval on `edge2' */
    };
typedef struct PK_EDGE_find_deviation_s PK_EDGE_find_deviation_t;


/* PK_EDGE_find_deviation_r_t */

struct PK_EDGE_find_deviation_r_s
    {
    int                             n_regions;  /* number of regions */
    PK_EDGE_find_deviation_t       *regions;    /* regions returned */
    };
typedef struct PK_EDGE_find_deviation_r_s PK_EDGE_find_deviation_r_t;


/* PK_EDGE_find_deviation_o_t */

struct PK_EDGE_find_deviation_o_s
    {
    int             o_t_version;             /* Version number of option */

    int             max_samples;             /* How many distances to find(0) */

    PK_LOGICAL_t    bound_at_split_vertex;   /* Whether vertices of split ring */

    PK_LOGICAL_t    have_upper_bound;        /* An upper bound is provided */

    double          upper_bound;             /* Upper bound for deviation(0.0) */

    };

typedef struct PK_EDGE_find_deviation_o_s PK_EDGE_find_deviation_o_t;


/* PK_EDGE_find_deviation_o_m */

#define PK_EDGE_find_deviation_o_m( options )                 \
    (                                                         \
       (options).o_t_version        = 1,                      \
       (options).max_samples        = 0,                      \
       (options).bound_at_split_vertex = PK_LOGICAL_false,    \
       (options).have_upper_bound      = PK_LOGICAL_false,    \
       (options).upper_bound  = 0.0                           \
    )


/* PK_EDGE_offset_on_body_r_t */

struct PK_EDGE_offset_on_body_r_s
    {
    PK_offset_on_body_t      status;             /* the status of the offset */
    int                      n_fault_entities;   /* number of entities */
    PK_ENTITY_t             *fault_entities;     /* associated entities */
    };

typedef struct PK_EDGE_offset_on_body_r_s PK_EDGE_offset_on_body_r_t;


/* PK_EDGE_offset_on_body_o_t */

struct PK_EDGE_offset_on_body_o_s
    {
    int     o_t_version;             /* version number of option structure */
    double  offset_distance;         /* distance to offset */
    double  tolerance;               /* tolerance for offset (1.0e-06) */
    };

typedef struct PK_EDGE_offset_on_body_o_s PK_EDGE_offset_on_body_o_t;



/* PK_EDGE_offset_on_body_o_m */

#define PK_EDGE_offset_on_body_o_m( options )                        \
    (                                                                \
       (options).o_t_version        = 1,                             \
       (options).offset_distance    = 0.0,                           \
       (options).tolerance          = 0.000001                       \
    )


/* PK_EDGE_optimise_o_t */

struct PK_EDGE_optimise_o_s
    {
    int                 o_t_version;  /* version number of option structure */
    double              max_dev;      /* the desired maximum deviation (0) */
    PK_EDGE_max_dev_t   set_max_dev;  /* whether or not `max_dev' is set by */
    };

typedef struct PK_EDGE_optimise_o_s PK_EDGE_optimise_o_t;



/* PK_EDGE_optimise_o_m */

#define PK_EDGE_optimise_o_m( options )                            \
    (                                                                \
       (options).o_t_version        = 1,                             \
       (options).max_dev            = 0,                             \
       (options).set_max_dev        = PK_EDGE_max_dev_edge_tol_c \
    )


/* PK_EDGE_remove_to_bodies_o_t */

struct PK_EDGE_remove_to_bodies_o_s
    {
    int                 o_t_version;           /* version number of option */
    PK_LOGICAL_t        allow_disjoint;        /* Whether disjoint bodies can */
    PK_track_bodies_t   track_bodies;          /* return bodies in tracking */
    };
typedef struct PK_EDGE_remove_to_bodies_o_s PK_EDGE_remove_to_bodies_o_t;


/* PK_EDGE_remove_to_bodies_o_m */

#define PK_EDGE_remove_to_bodies_o_m(options)               \
    (                                                       \
    (options).o_t_version          = 1,                     \
    (options).allow_disjoint       = PK_LOGICAL_true,       \
    (options).track_bodies         = PK_track_bodies_no_c   \
    )


/* PK_EDGE_repair_o_t */

struct PK_EDGE_repair_o_s
    {
    int                 o_t_version;      /* version number of option structure */
    PK_LOGICAL_t        ensure_on_surfs;  /* ensure edges lie on surfaces */
    double              max_tolerance;    /* maximum tolerance allowed for */
    PK_LOGICAL_t        intersect;        /* intersect face surfaces */
    PK_LOGICAL_t        check_tols;       /* check for clashing vertex */
    };

typedef struct PK_EDGE_repair_o_s PK_EDGE_repair_o_t;



/* PK_EDGE_repair_o_m */

#define PK_EDGE_repair_o_m(options)            \
    (                                                   \
       (options).o_t_version = 3,                       \
       (options).ensure_on_surfs = PK_LOGICAL_true,     \
       (options).max_tolerance = 0.00001,               \
       (options).intersect = PK_LOGICAL_false,          \
       (options).check_tols = PK_LOGICAL_true           \
    )


/* PK_EDGE_reset_precision_o_t */

struct PK_EDGE_reset_precision_o_s
    {
    int                    o_t_version;  /* version number of option */
    PK_reset_prec_method_t method;       /* method how the edge geometry */
    };

typedef struct PK_EDGE_reset_precision_o_s PK_EDGE_reset_precision_o_t;



/* PK_EDGE_reset_precision_o_m */

#define PK_EDGE_reset_precision_o_m( options )                      \
    (                                                               \
       (options).o_t_version   = 1,                                 \
       (options).method        = PK_reset_prec_method_any_c         \
    )


/* PK_EDGE_reverse_2_o_t */

struct PK_EDGE_reverse_2_o_s
    {
    int o_t_version;     /* version number of option structure */
    };

typedef struct PK_EDGE_reverse_2_o_s PK_EDGE_reverse_2_o_t;



/* PK_EDGE_reverse_2_o_m */

#define PK_EDGE_reverse_2_o_m(options)          \
    (                                           \
       (options).o_t_version = 1                \
    )


/* PK_EDGE_set_precision_o_t */

struct PK_EDGE_set_precision_o_s
    {
    int                       o_t_version;    /* options structure version */
    PK_set_precision_method_t sp_method;      /* method used for generating */
    PK_set_precision_report_t report_short_edges;
    };

typedef struct PK_EDGE_set_precision_o_s PK_EDGE_set_precision_o_t;



/* PK_EDGE_set_precision_o_m */

#define PK_EDGE_set_precision_o_m(options)                                 \
    (                                                                      \
       (options).o_t_version           = 2,                                \
       (options).sp_method             = PK_set_precision_default_c,       \
       (options).report_short_edges    = PK_set_precision_report_no_c      \
    )


/* PK_EDGE_check_o_t */

struct PK_EDGE_check_o_s
    {
    int                  o_t_version;  /* version number of option structure */
    int                  max_faults;   /* limit on fault numbers (5) */
    PK_check_geom_t      geom;         /* bad geometry (PK_check_geom_yes_c) */
    PK_check_bgeom_t     bgeom;        /* bad B geometry (PK_check_bgeom_yes_c) */
    PK_check_top_geo_t   top_geo;      /* topology/geometry inconsistency */
    PK_check_size_box_t  size_box;     /* size box violation */
    PK_check_nmnl_geom_t nmnl_geom;    /* bad nominal geometry */
    PK_check_returns_t   returns;      /* return version of fault information */
    PK_check_attribs_t   attribs;      /* system attribute validity checks */
    };

typedef struct PK_EDGE_check_o_s PK_EDGE_check_o_t;



/* PK_EDGE_check_o_m */

#define PK_EDGE_check_o_m(options)                          \
    (                                                       \
       (options).o_t_version = 3,                           \
       (options).max_faults  = 5,                           \
       (options).geom        = PK_check_geom_yes_c,         \
       (options).bgeom       = PK_check_bgeom_yes_c,        \
       (options).top_geo     = PK_check_top_geo_edge_c,     \
       (options).size_box    = PK_check_size_box_yes_c,     \
       (options).nmnl_geom   = PK_check_nmnl_geom_yes_c,    \
       (options).returns     = PK_check_returns_0_c,        \
       (options).attribs     = PK_check_attribs_no_c       \
    )


/* PK_EDGE_make_wire_body_o_t */

struct PK_EDGE_make_wire_body_o_s
    {
    int            o_t_version;     /* version number of option structure */
    PK_LOGICAL_t   allow_disjoint;  /* the operation may return disjoint */
    PK_LOGICAL_t   copy_dep_geom;   /* copy curves with dependent geometry */
    PK_LOGICAL_t   use_nmnl_geom;   /* use existing nominal geometry where */
    double         tolerance;       /* curve approximation tolerance */
    };

typedef struct PK_EDGE_make_wire_body_o_s PK_EDGE_make_wire_body_o_t;



/* PK_EDGE_make_wire_body_o_m */

#define PK_EDGE_make_wire_body_o_m( options )               \
    (                                                       \
       (options).o_t_version    = 1,                        \
       (options).allow_disjoint = PK_LOGICAL_false,         \
       (options).copy_dep_geom  = PK_LOGICAL_true,          \
       (options).use_nmnl_geom  = PK_LOGICAL_false,         \
       (options).tolerance      = 0.00001                   \
    )


/* PK_EDGE_curve_direction_t */

struct PK_EDGE_curve_direction_s
    {
    PK_EDGE_curve_dir_t       type;        /* type of method used */
    PK_EDGE_t                 edge;        /* Edge we want to orient with */
    PK_FIN_t                  fin;         /* fin sets direction */
    PK_VERTEX_t               end_vertex;  /* vertex sets direction */
    PK_VECTOR_t               point;       /* point to be used with direction */
    PK_VECTOR1_t              direction;   /* direction to be used with point */
    };

typedef struct PK_EDGE_curve_direction_s PK_EDGE_curve_direction_t;




/* PK_EDGE_curve_direction_m */

#define PK_EDGE_curve_direction_m( cu_dir )                             \
    (                                                                   \
    (cu_dir).type                       = PK_EDGE_curve_dir_none_c,     \
    (cu_dir).edge                       = PK_ENTITY_null,               \
    (cu_dir).fin                        = PK_ENTITY_null,               \
    (cu_dir).end_vertex                 = PK_ENTITY_null,               \
    (cu_dir).point.coord[0]             = 0.0,                          \
    (cu_dir).point.coord[0]             = 0.0,                          \
    (cu_dir).point.coord[0]             = 0.0,                          \
    (cu_dir).direction.coord[0]         = 1.0,                          \
    (cu_dir).direction.coord[1]         = 0.0,                          \
    (cu_dir).direction.coord[2]         = 0.0                           \
    )


/* PK_EDGE_make_curve_o_t */

struct PK_EDGE_make_curve_o_s
    {
    int                       o_t_version;   /* version of option structure */
    PK_EDGE_curve_direction_t curve_dir;     /* structure to set curve dir */
    };

typedef struct PK_EDGE_make_curve_o_s PK_EDGE_make_curve_o_t;



/* PK_EDGE_make_curve_o_m */

#define PK_EDGE_make_curve_o_m(options)                                   \
    (                                                                     \
       (options).o_t_version               = 2,                           \
       PK_EDGE_curve_direction_m( (options).curve_dir )                   \
    )


/* PK_EDGE_set_blend_chamfer_o_t */

struct PK_EDGE_set_blend_chamfer_o_s
    {
    int                    o_t_version;   /* version number of option structure */
    PK_blend_properties_t  properties;    /* properties of blend */
    };

typedef struct PK_EDGE_set_blend_chamfer_o_s PK_EDGE_set_blend_chamfer_o_t;



/* PK_EDGE_set_blend_chamfer_o_m */

#define PK_EDGE_set_blend_chamfer_o_m(options)                            \
    (                                                                     \
       (options).o_t_version               = 1,                           \
       PK_blend_properties_m((options).properties)                        \
    )


/* PK_EDGE_set_blend_constant_o_t */

struct PK_EDGE_set_blend_constant_o_s
    {
    int                    o_t_version;   /* version number of option structure */
    PK_EDGE_t              cliff_edge;    /* top of cliff (PK_ENTITY_null) */
    PK_blend_properties_t  properties;    /* properties of blend */
    PK_blend_xs_shape_t    xs_shape;      /* cross section shape */
    };

typedef struct PK_EDGE_set_blend_constant_o_s PK_EDGE_set_blend_constant_o_t;



/* PK_EDGE_set_blend_constant_o_m */

#define PK_EDGE_set_blend_constant_o_m(options)                           \
    (                                                                     \
       (options).o_t_version               = 2,                           \
       (options).cliff_edge                = PK_ENTITY_null,              \
       PK_blend_properties_m((options).properties),                       \
       (options).xs_shape                  = PK_blend_xs_shape_conic_c    \
    )


/* PK_EDGE_set_blend_variable_o_t */

struct PK_EDGE_set_blend_variable_o_s
    {
    int                    o_t_version;   /* version number of option structure */
    PK_blend_properties_t  properties;    /* properties of blend */
    PK_blend_rho_t         rho_type;      /* whether to use absolute, */
    PK_blend_xs_shape_t    xs_shape;      /* cross section shape */
    };

typedef struct PK_EDGE_set_blend_variable_o_s PK_EDGE_set_blend_variable_o_t;



/* PK_EDGE_set_blend_variable_o_m */

#define PK_EDGE_set_blend_variable_o_m(options)                           \
    (                                                                     \
       (options).o_t_version               = 3,                           \
       PK_blend_properties_m((options).properties),                       \
       (options).rho_type                  = PK_blend_rho_absolute_c,     \
       (options).xs_shape                  = PK_blend_xs_shape_conic_c    \
    )


/* PK_EDGE_set_blend_constant_1_m */

#define PK_EDGE_set_blend_constant_1_m(options)                           \
    (                                                                     \
       (options).o_t_version               = 1,                           \
       (options).cliff_edge                = PK_ENTITY_null,              \
       PK_blend_properties_m((options).properties)                        \
    )


/* PK_VERTEX_optimise_o_t */

struct PK_VERTEX_optimise_o_s
    {
    int                    o_t_version;  /* version number of option structure */
    double                 max_dev;      /* the desired maximum deviation */
    PK_VERTEX_max_dev_t    set_max_dev;  /* whether or not `max_dev' is set by */
     PK_local_ops_update_t update;       /* update flag */
    };

typedef struct PK_VERTEX_optimise_o_s PK_VERTEX_optimise_o_t;



/* PK_VERTEX_optimise_o_m */

#define PK_VERTEX_optimise_o_m( options )                             \
    (                                                                 \
       (options).o_t_version        = 2,                              \
       (options).max_dev            = 0,                              \
       (options).set_max_dev        = PK_VERTEX_max_dev_vertex_tol_c, \
       (options).update             = PK_local_ops_update_default_c   \
    )


/* PK_FACE_split_at_param_o_t */

struct PK_FACE_split_at_param_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    };

typedef struct PK_FACE_split_at_param_o_s PK_FACE_split_at_param_o_t;



/* PK_FACE_split_at_param_o_m */

#define PK_FACE_split_at_param_o_m( options )                        \
    (                                                       \
       (options).o_t_version    = 1                         \
    )


/* PK_ATTRIB_filter_f_t */

typedef PK_LOGICAL_t (*PK_ATTRIB_filter_f_t)( const int *, void *);


/* PK_ATTRIB_field_values_t */

union PK_ATTRIB_field_values_u
    {
    const int           *ints;
    const double        *doubles;
    const char          *chars;
    const PK_UCHAR_t    *uchars;
    const PK_VECTOR_t   *vectors;
    const PK_AXIS1_sf_t *axes;
    const PK_POINTER_t  *pointers;
    };

typedef union PK_ATTRIB_field_values_u PK_ATTRIB_field_values_t;



/* PK_ATTRIB_cb_f_t */

typedef PK_LOGICAL_t         (*PK_ATTRIB_cb_f_t)
(
/* received */
const PK_ATTDEF_sf_2_t        * /*attdef_sf*/,  /* attribute definition standard */
const int                       /*lengths*/[],  /* attribute field lengths */
const PK_ATTRIB_field_values_t  /*values*/[],   /* attribute field values */
PK_POINTER_t                    /*context*/     /* context */
);


/* PK_ATTRIB_cb_t */

typedef PK_ATTRIB_cb_f_t PK_ATTRIB_cb_t;


/* PK_PART_ask_attribs_cb_o_t */

struct PK_PART_ask_attribs_cb_o_s
    {
    int             o_t_version;     /* version number of options structure */
    PK_ATTDEF_t     attdef;          /* attribute definition (PK_ENTITY_null) */
    PK_LOGICAL_t    want_attribs;    /* return attributes (PK_LOGICAL_true) */
    PK_LOGICAL_t    want_owners;     /* return owners (PK_LOGICAL_true) */
    };

typedef struct PK_PART_ask_attribs_cb_o_s PK_PART_ask_attribs_cb_o_t;



/* PK_PART_ask_attribs_cb_o_m */

#define PK_PART_ask_attribs_cb_o_m(options)         \
    (                                               \
        (options).o_t_version  = 1,                 \
        (options).attdef       = PK_ENTITY_null,    \
        (options).want_attribs = PK_LOGICAL_true,   \
        (options).want_owners  = PK_LOGICAL_true    \
    )


/* PK_PART_delete_attribs_o_t */

struct PK_PART_delete_attribs_o_s
    {
    int        o_t_version;    /* version number of option structure */
    PK_CLASS_t entity_class;   /* class of entity from which to delete */
    };

typedef struct PK_PART_delete_attribs_o_s PK_PART_delete_attribs_o_t;



/* PK_PART_delete_attribs_o_m */

#define PK_PART_delete_attribs_o_m(options)         \
    (                                               \
        (options).o_t_version  = 1,                 \
        (options).entity_class = PK_CLASS_entity    \
    )


/* PK_PART_receive_o_m */

#define PK_PART_receive_o_m(options)                                        \
       ((options).o_t_version             = 6,                              \
        (options).transmit_format         = PK_transmit_format_neutral_c,   \
        (options).receive_user_fields     = PK_LOGICAL_false,               \
        (options).attdef_mismatch         = PK_ATTDEF_mismatch_fail_c,      \
        (options).part_index              = 0,                              \
        (options).n_part_indices          = 0,                              \
        (options).part_indices            = NULL,                           \
        (options).n_identifiers           = 0,                              \
        (options).identifiers             = NULL,                           \
        (options).receive_indexed_context = NULL,                           \
        (options).key_is_partition        = PK_LOGICAL_false,               \
        (options).receive_compound        = PK_receive_compound_split_c )


/* PK_PART_receive_o_t */

struct PK_PART_receive_o_s
    {
    int                     o_t_version;
    PK_transmit_format_t    transmit_format;
    PK_LOGICAL_t            receive_user_fields;
    PK_ATTDEF_mismatch_t    attdef_mismatch;
    int                     part_index;
    int                     n_part_indices;
    const int              *part_indices;
    int                     n_identifiers;
    const int              *identifiers;
    PK_POINTER_t            receive_indexed_context;
    PK_LOGICAL_t            key_is_partition;
    PK_receive_compound_t   receive_compound;
    };
typedef struct PK_PART_receive_o_s PK_PART_receive_o_t;


/* PK_PART_transmit_o_m */

#define PK_PART_transmit_o_m(options)                                       \
      ((options).o_t_version              = 3,                              \
       (options).transmit_format          = PK_transmit_format_neutral_c,   \
       (options).transmit_user_fields     = PK_LOGICAL_true,                \
       (options).transmit_version         = 0,                              \
       (options).transmit_nmnl_geometry   = PK_LOGICAL_false,               \
       (options).transmit_indexed_context = NULL)


/* PK_PART_transmit_o_t */

struct PK_PART_transmit_o_s
    {
    int                     o_t_version;
    PK_transmit_format_t    transmit_format;
    PK_LOGICAL_t            transmit_user_fields;
    int                     transmit_version;
    PK_LOGICAL_t            transmit_nmnl_geometry;
    PK_POINTER_t            transmit_indexed_context;
    };

typedef struct PK_PART_transmit_o_s PK_PART_transmit_o_t;


/* PK_TOPOL_delete_redundant_2_o_t */

struct PK_TOPOL_delete_redundant_2_o_s
{
int                  o_t_version;          /* version number of options */
PK_TOPOL_dimension_t max_topol_dimension;  /* controls which topologies or */
PK_redundant_merge_t scope;                /* controls the scope of the search */
int                  n_protected_topols;   /* number of protected topologies */
const PK_TOPOL_t    *protected_topols;     /* protected topology array */
};

typedef struct PK_TOPOL_delete_redundant_2_o_s
                        PK_TOPOL_delete_redundant_2_o_t;



/* PK_TOPOL_delete_redundant_2_o_m */

#define PK_TOPOL_delete_redundant_2_o_m(options)                 \
    (                                                            \
       (options).o_t_version = 1,                                \
       (options).max_topol_dimension = PK_TOPOL_dimension_any_c, \
       (options).scope               = PK_redundant_merge_on_c,  \
       (options).n_protected_topols  = 0,                        \
       (options).protected_topols    = NULL                      \
    )


/* PK_TOPOL_identify_redundant_o_t */

struct PK_TOPOL_identify_redundant_o_s
{
int                  o_t_version;            /* version number of options */
PK_TOPOL_dimension_t max_topol_dimension;    /* controls which topologies or */
PK_redundant_merge_t scope;                  /* controls the scope of the */
PK_LOGICAL_t         want_redundant_topols;  /* whether redundant topols */
PK_redundant_propagate_t
                     propagate_redundancy;   /* whether redundancy */
};

typedef struct PK_TOPOL_identify_redundant_o_s
               PK_TOPOL_identify_redundant_o_t;



/* PK_TOPOL_delete_identify_o_m */

#define PK_TOPOL_identify_redundant_o_m(options)                      \
    (                                                                 \
       (options).o_t_version           = 2,                           \
       (options).max_topol_dimension   = PK_TOPOL_dimension_any_c,    \
       (options).scope                 = PK_redundant_merge_on_c,     \
       (options).want_redundant_topols = PK_LOGICAL_true,             \
       (options).propagate_redundancy  = PK_redundant_propagate_no_c  \
    )


/* PK_TOPOL_make_new_o_t */

struct PK_TOPOL_make_new_o_s
    {
    int         o_t_version;         /* version number of option structure */
    };

typedef struct PK_TOPOL_make_new_o_s PK_TOPOL_make_new_o_t;



/* PK_TOPOL_make_new_o_m */

#define PK_TOPOL_make_new_o_m(options)                               \
    (                                                                \
       (options).o_t_version                = 1                      \
    )


/* PK_TOPOL_clash_type_t */


typedef int PK_TOPOL_clash_type_t;




/* PK_TOPOL_clash_type_t */


#define PK_TOPOL_clash_none                 ((PK_TOPOL_clash_type_t) 0)
#define PK_TOPOL_clash_a_in_b               ((PK_TOPOL_clash_type_t) 1)
#define PK_TOPOL_clash_b_in_a               ((PK_TOPOL_clash_type_t) 2)
#define PK_TOPOL_clash_exists               ((PK_TOPOL_clash_type_t) 3)
#define PK_TOPOL_clash_abut_no_class        ((PK_TOPOL_clash_type_t) 4)
#define PK_TOPOL_clash_abut_b_in_a          ((PK_TOPOL_clash_type_t) 5)
#define PK_TOPOL_clash_abut_b_out_a         ((PK_TOPOL_clash_type_t) 6)
#define PK_TOPOL_clash_interfere            ((PK_TOPOL_clash_type_t) 7)



/* PK_TOPOL_clash_t */


struct PK_TOPOL_clash_s
    {
    PK_TOPOL_t              target;          /* Face or Body (aka 'A') */
    int                     target_index;    /* Index of owner in input */
    PK_TOPOL_t              tool;            /* Face or Body ('B') */
    int                     tool_index;      /* Index of owner in input */
    PK_TOPOL_clash_type_t   clash_type;      /* Type of clash being reported */
    };

typedef struct PK_TOPOL_clash_s PK_TOPOL_clash_t;




/* PK_TOPOL_clash_o_t */


struct PK_TOPOL_clash_o_s
    {
    int          o_t_version;    /* Version of this PK option structure */
    int          n_op_ex;        /* Number of entity pairs that may be ignored */
    PK_TOPOL_t  *op_ex1;         /* First half of pairs that may be ignored */
    PK_TOPOL_t  *op_ex2;         /* Second half of pairs that may be ignored */
    PK_LOGICAL_t find_all;       /* Find all clashes, not just the first */
    PK_LOGICAL_t find_intersect; /* Examine clashes for true interference */
    PK_LOGICAL_t mul_target_tf;  /* There is one transform in tf1 for each */
    PK_LOGICAL_t mul_tool_tf;    /* One transform in tf2 for each tool, as */
    PK_TOPOL_t   target_owner;   /* Owning topology of target entities */
    PK_TOPOL_t   tool_owner;     /* Owning topology of tool entities */
    };

typedef struct PK_TOPOL_clash_o_s PK_TOPOL_clash_o_t;



/* PK_TOPOL_clash_o_m */


#define PK_TOPOL_clash_o_m( opt)                                        \
    (   (opt).o_t_version = 2,                                          \
        (opt).n_op_ex = 0,                                              \
        (opt).op_ex1 = (opt).op_ex2 = NULL,                             \
        (opt).find_all = (opt).find_intersect = PK_LOGICAL_false,       \
        (opt).mul_target_tf = (opt).mul_tool_tf = PK_LOGICAL_false,     \
        (opt).target_owner = (opt).tool_owner = PK_ENTITY_null)


/* PK_TOPOL_find_nabox_o_t */

struct PK_TOPOL_find_nabox_o_s
    {
    int            o_t_version;   /* options structure version number */
    PK_LOGICAL_t   have_axis2;    /* whether axis2 supplied */
    PK_AXIS2_sf_t  axis2;         /* local coordinate system for nabox */
    };
typedef struct PK_TOPOL_find_nabox_o_s PK_TOPOL_find_nabox_o_t;


/* PK_TOPOL_find_nabox_o_m */

#define PK_TOPOL_find_nabox_o_m(options)                                      \
    (                                                                         \
        (options).o_t_version = 1,                                            \
        (options).have_axis2  = PK_LOGICAL_false,                             \
        (options).axis2.location.coord[0] = 0.0,                              \
        (options).axis2.location.coord[1] = 0.0,                              \
        (options).axis2.location.coord[2] = 0.0,                              \
        (options).axis2.axis.coord[0] = 0.0,                                  \
        (options).axis2.axis.coord[1] = 0.0,                                  \
        (options).axis2.axis.coord[2] = 1.0,                                  \
        (options).axis2.ref_direction.coord[0] = 1.0,                         \
        (options).axis2.ref_direction.coord[1] = 0.0,                         \
        (options).axis2.ref_direction.coord[2] = 0.0                          \
    )


/* PK_facet_local_tolerances_t */

struct PK_facet_local_tolerances_s
    {
    double             curve_chord_tol;
    double             curve_chord_max;
    double             curve_chord_ang;
    double             surface_plane_tol;
    double             surface_plane_ang;
    };
typedef struct PK_facet_local_tolerances_s PK_facet_local_tolerances_t;


/* PK_facet_local_tolerances_m */

#define PK_facet_local_tolerances_m( opt )                               \
    (   (opt).curve_chord_tol           = 0.0,                           \
        (opt).curve_chord_max           = 0.0,                           \
        (opt).curve_chord_ang           = 0.0,                           \
        (opt).surface_plane_tol         = 0.0,                           \
        (opt).surface_plane_ang         = 0.0                            )



/* PK_TOPOL_facet_mesh_o_t */

struct PK_TOPOL_facet_mesh_o_s
    {
    int                o_t_version;       /* version of this PK option struct */
    PK_facet_shape_t   shape;             /* constraints on facet generation */
    PK_facet_match_t   match;             /* vertex matching strategy at edges */
    PK_facet_density_t density;           /* increased facet density */
    PK_facet_cull_t    cull;              /* culling of view dependent facets */
    int                n_loops;           /* array of loops in sheet bodies to */
    PK_LOOP_t         *loops;             /* be ignored when facetting(0,NULL) */
    int                max_facet_sides;   /* max number of sides on a facet (3) */
    PK_LOGICAL_t    is_min_facet_width;   /* whether min_facet_width is set */
    double             min_facet_width;   /* minimum facet width */
    PK_LOGICAL_t    is_max_facet_width;   /* whether max_facet_width is set */
    double             max_facet_width;   /* maximum facet width */
    PK_LOGICAL_t    is_curve_chord_tol;   /* whether curve_chord_tol is set */
    double             curve_chord_tol;   /* chordal tolerance between a curve */
    PK_LOGICAL_t    is_curve_chord_max;   /* whether curve_chord_max is set */
    double             curve_chord_max;   /* max length of chord in model units */
    PK_LOGICAL_t    is_curve_chord_ang;   /* whether curve_chord_ang is set */
    double             curve_chord_ang;   /* max angle between curve and chord */
    PK_LOGICAL_t    is_surface_plane_tol; /* whether surface_plane_tol is set */
    double             surface_plane_tol; /* distance tolerance between surface */
    PK_LOGICAL_t    is_surface_plane_ang; /* whether surface_plane_ang is set */
    double             surface_plane_ang; /* angular tolerance between surface */
    PK_LOGICAL_t    is_facet_plane_tol;   /* whether facet_plane_tol is set */
    double             facet_plane_tol;   /* max dist from facet to mid-plane */
    PK_LOGICAL_t    is_facet_plane_ang;   /* whether facet_plane_ang is set */
    double             facet_plane_ang;   /* facet_plane_tol : max_facet_width */
    PK_LOGICAL_t   is_local_density_tol;  /* whether local_density_tol is set */
    double            local_density_tol;  /* local value of surface_plane_tol */
    PK_LOGICAL_t   is_local_density_ang;  /* whether local_density_ang is set */
    double            local_density_ang;  /* local value of surface_plane_ang */
    PK_facet_degen_t  degen;              /* whether to output multiple */
    int               n_view_directions;  /* array of view directions used */
    PK_VECTOR1_t                          /* when increasing the facet density */
                     *view_directions;    /* (0, NULL) */
    int               n_local_tols;       /* array of sets of local tolerances */
    PK_facet_local_tolerances_t
                     *local_tols;         /* (0, NULL) */
    int               n_topols_with_local_tols;
    PK_TOPOL_t       *topols_with_local_tols;
    int              *local_tols_for_topols;
    PK_facet_ignore_t ignore;             /* whether to ignore small features */
    double            ignore_value;       /* features smaller than this will be */
    PK_facet_ignore_scope_t
                      ignore_scope;       /* whether to treat a face */
    PK_facet_wire_edges_t
                      wire_edges;         /* whether to take wire edges into */
    PK_facet_incr_t
                      incremental_facetting;
    PK_facet_incr_refine_t
                      incremental_refinement;
    PK_facet_incr_report_t
                      incremental_report;
    PK_facet_inflect_t
                      inflect;            /* Whether facets around points of */
    PK_facet_quality_t
                      quality;            /* Whether to perform extra checks */
    PK_LOGICAL_t      vertices_on_planar;
    PK_facet_respect_t
                      respect_offset;     /* Whether to take into account faces */
    };
typedef struct PK_TOPOL_facet_mesh_o_s PK_TOPOL_facet_mesh_o_t;



/* PK_TOPOL_facet_mesh_o_m */

#define PK_TOPOL_facet_mesh_o_m( opt)                                     \
    (   (opt).o_t_version               = 11,                              \
        (opt).shape                     = PK_facet_shape_convex_c,        \
        (opt).match                     = PK_facet_match_topol_c,         \
        (opt).density                   = PK_facet_density_no_view_c,     \
        (opt).cull                      = PK_facet_cull_none_c,           \
        (opt).n_loops                   = 0,                              \
        (opt).loops                     = NULL,                           \
        (opt).max_facet_sides           = 3,                              \
        (opt).is_min_facet_width        = PK_LOGICAL_false,               \
        (opt).min_facet_width           = 0.0,                            \
        (opt).is_max_facet_width        = PK_LOGICAL_false,               \
        (opt).max_facet_width           = 0.0,                            \
        (opt).is_curve_chord_tol        = PK_LOGICAL_false,               \
        (opt).curve_chord_tol           = 0.0,                            \
        (opt).is_curve_chord_max        = PK_LOGICAL_false,               \
        (opt).curve_chord_max           = 0.0,                            \
        (opt).is_curve_chord_ang        = PK_LOGICAL_false,               \
        (opt).curve_chord_ang           = 0.0,                            \
        (opt).is_surface_plane_tol      = PK_LOGICAL_false,               \
        (opt).surface_plane_tol         = 0.0,                            \
        (opt).is_surface_plane_ang      = PK_LOGICAL_false,               \
        (opt).surface_plane_ang         = 0.0,                            \
        (opt).is_facet_plane_tol        = PK_LOGICAL_false,               \
        (opt).facet_plane_tol           = 0.0,                            \
        (opt).is_facet_plane_ang        = PK_LOGICAL_false,               \
        (opt).facet_plane_ang           = 0.0,                            \
        (opt).is_local_density_tol      = PK_LOGICAL_false,               \
        (opt).local_density_tol         = 0.0,                            \
        (opt).is_local_density_ang      = PK_LOGICAL_false,               \
        (opt).local_density_ang         = 0.0,                            \
        (opt).degen                     = PK_facet_degen_multiple_vxs_c,  \
        (opt).n_view_directions         = 0,                              \
        (opt).view_directions           = NULL,                           \
        (opt).n_local_tols              = 0,                              \
        (opt).local_tols                = NULL,                           \
        (opt).n_topols_with_local_tols  = 0,                              \
        (opt).topols_with_local_tols    = NULL,                           \
        (opt).local_tols_for_topols     = NULL,                           \
        (opt).ignore                    = PK_facet_ignore_no_c,           \
        (opt).ignore_value              = 0.0,                            \
        (opt).ignore_scope              = PK_facet_ignore_scope_global_c, \
        (opt).wire_edges                = PK_facet_wire_edges_no_c,       \
        (opt).incremental_facetting     = PK_facet_incr_no_c,             \
        (opt).incremental_refinement    = PK_facet_incr_refine_no_c,      \
        (opt).incremental_report        = PK_facet_incr_report_no_c,      \
        (opt).inflect                   = PK_facet_inflect_no_c,          \
        (opt).quality                   = PK_facet_quality_standard_c,    \
        (opt).vertices_on_planar        = PK_LOGICAL_false,               \
        (opt).respect_offset            = PK_facet_respect_no_c           )



/* PK_TOPOL_facet_mesh_2_o_t */

struct PK_TOPOL_facet_mesh_2_o_s
    {
    int                o_t_version;       /* version of this PK option struct */
    PK_facet_shape_t   shape;             /* constraints on facet generation */
    PK_facet_match_t   match;             /* vertex matching strategy at edges */
    PK_facet_density_t density;           /* increased facet density */
    int                n_view_directions; /* array of view directions in which */
    PK_VECTOR1_t      *view_directions;   /* (0, NULL) */
    PK_facet_cull_t    cull;              /* culling of view dependent facets */
    int                n_cull_transfs;    /* array of view transformations in */
    PK_TRANSF_t       *cull_transfs;      /* (0, NULL) */
    int                n_loops;           /* array of loops in sheet bodies to */
    PK_LOOP_t         *loops;             /* be ignored when facetting(0,NULL) */
    int                max_facet_sides;   /* max number of sides on a facet (3) */
    PK_LOGICAL_t    is_min_facet_width;   /* whether min_facet_width is set */
    double             min_facet_width;   /* minimum facet width */
    PK_LOGICAL_t    is_max_facet_width;   /* whether max_facet_width is set */
    double             max_facet_width;   /* maximum facet width */
    PK_LOGICAL_t    is_curve_chord_tol;   /* whether curve_chord_tol is set */
    double             curve_chord_tol;   /* chordal tolerance between a curve */
    PK_LOGICAL_t    is_curve_chord_max;   /* whether curve_chord_max is set */
    double             curve_chord_max;   /* max length of chord in model units */
    PK_LOGICAL_t    is_curve_chord_ang;   /* whether curve_chord_ang is set */
    double             curve_chord_ang;   /* max angle between curve and chord */
    PK_LOGICAL_t    is_surface_plane_tol; /* whether surface_plane_tol is set */
    double             surface_plane_tol; /* distance tolerance between surface */
    PK_LOGICAL_t    is_surface_plane_ang; /* whether surface_plane_ang is set */
    double             surface_plane_ang; /* angular tolerance between surface */
    PK_LOGICAL_t    is_facet_plane_tol;   /* whether facet_plane_tol is set */
    double             facet_plane_tol;   /* max dist from facet to mid-plane */
    PK_LOGICAL_t    is_facet_plane_ang;   /* whether facet_plane_ang is set */
    double             facet_plane_ang;   /* facet_plane_tol : max_facet_width */
    PK_LOGICAL_t    is_local_density_tol; /* whether local_density_tol is set */
    double             local_density_tol; /* local value of surface_plane_tol */
    PK_LOGICAL_t    is_local_density_ang; /* whether local_density_ang is set */
    double             local_density_ang; /* local value of surface_plane_ang */
    int                n_local_tols;      /* array of sets of local tolerances */
    PK_facet_local_tolerances_t
                      *local_tols;        /* (0, NULL) */
    int                n_topols_with_local_tols;
    PK_TOPOL_t        *topols_with_local_tols;
    int               *local_tols_for_topols;
    PK_facet_ignore_t  ignore;            /* whether to ignore small features */
    double             ignore_value;      /* features smaller than this will be */
    PK_facet_ignore_scope_t
                       ignore_scope;      /* whether to treat a face */
    PK_facet_wire_edges_t
                       wire_edges;        /* whether to take wire edges into */
    PK_facet_incr_t
                       incremental_facetting;
    PK_facet_incr_refine_t
                       incremental_refinement;
    PK_facet_incr_report_t
                       incremental_report;
    PK_facet_inflect_t inflect;           /* Whether facets around points of */
    PK_facet_quality_t quality;           /* Whether to perform extra checks */
    PK_LOGICAL_t       vertices_on_planar;
    PK_facet_sing_topol_t
                       sing_topol;        /* facet topology required around a */
    PK_facet_respect_t
                       respect_offset;    /* Whether to take into account faces */
    };
typedef struct PK_TOPOL_facet_mesh_2_o_s PK_TOPOL_facet_mesh_2_o_t;



/* PK_TOPOL_facet_mesh_2_o_m */

#define PK_TOPOL_facet_mesh_2_o_m( opt)                                   \
    (   (opt).o_t_version               = 17,                             \
        (opt).shape                     = PK_facet_shape_convex_c,        \
        (opt).match                     = PK_facet_match_topol_c,         \
        (opt).density                   = PK_facet_density_no_view_c,     \
        (opt).n_view_directions         = 0,                              \
        (opt).view_directions           = NULL,                           \
        (opt).cull                      = PK_facet_cull_none_c,           \
        (opt).n_cull_transfs            = 0,                              \
        (opt).cull_transfs              = NULL,                           \
        (opt).n_loops                   = 0,                              \
        (opt).loops                     = NULL,                           \
        (opt).max_facet_sides           = 3,                              \
        (opt).is_min_facet_width        = PK_LOGICAL_false,               \
        (opt).min_facet_width           = 0.0,                            \
        (opt).is_max_facet_width        = PK_LOGICAL_false,               \
        (opt).max_facet_width           = 0.0,                            \
        (opt).is_curve_chord_tol        = PK_LOGICAL_false,               \
        (opt).curve_chord_tol           = 0.0,                            \
        (opt).is_curve_chord_max        = PK_LOGICAL_false,               \
        (opt).curve_chord_max           = 0.0,                            \
        (opt).is_curve_chord_ang        = PK_LOGICAL_false,               \
        (opt).curve_chord_ang           = 0.0,                            \
        (opt).is_surface_plane_tol      = PK_LOGICAL_false,               \
        (opt).surface_plane_tol         = 0.0,                            \
        (opt).is_surface_plane_ang      = PK_LOGICAL_false,               \
        (opt).surface_plane_ang         = 0.0,                            \
        (opt).is_facet_plane_tol        = PK_LOGICAL_false,               \
        (opt).facet_plane_tol           = 0.0,                            \
        (opt).is_facet_plane_ang        = PK_LOGICAL_false,               \
        (opt).facet_plane_ang           = 0.0,                            \
        (opt).is_local_density_tol      = PK_LOGICAL_false,               \
        (opt).local_density_tol         = 0.0,                            \
        (opt).is_local_density_ang      = PK_LOGICAL_false,               \
        (opt).local_density_ang         = 0.0,                            \
        (opt).n_local_tols              = 0,                              \
        (opt).local_tols                = NULL,                           \
        (opt).n_topols_with_local_tols  = 0,                              \
        (opt).topols_with_local_tols    = NULL,                           \
        (opt).local_tols_for_topols     = NULL,                           \
        (opt).ignore                    = PK_facet_ignore_no_c,           \
        (opt).ignore_value              = 0.0,                            \
        (opt).ignore_scope              = PK_facet_ignore_scope_global_c, \
        (opt).wire_edges                = PK_facet_wire_edges_no_c,       \
        (opt).incremental_facetting     = PK_facet_incr_no_c,             \
        (opt).incremental_refinement    = PK_facet_incr_refine_no_c,      \
        (opt).incremental_report        = PK_facet_incr_report_no_c,      \
        (opt).inflect                   = PK_facet_inflect_no_c,          \
        (opt).quality                   = PK_facet_quality_standard_c,    \
        (opt).vertices_on_planar        = PK_LOGICAL_false,               \
        (opt).sing_topol                = PK_facet_sing_topol_default_c,  \
        (opt).respect_offset            = PK_facet_respect_no_c           )



/* PK_TOPOL_facet_tables_cb_f_t */

typedef  PK_ERROR_code_t  (*PK_TOPOL_facet_tables_cb_f_t)
(
/* received */
PK_TOPOL_t                   /*topol*/,      /* body that facets belong to */
PK_TRANSF_t                  /*transform*/,  /* transform associated with body */
PK_TOPOL_facet_2_r_t *const  /*tables*/,     /* returned facet tables */
PK_POINTER_t                 /*context*/     /* context */
);


/* PK_TOPOL_facet_choice_o_t */

struct PK_TOPOL_facet_choice_o_s
    {
    int        o_t_version;               /* version of this PK option struct */
    PK_LOGICAL_t facet_fin;
    PK_LOGICAL_t fin_fin;
    PK_LOGICAL_t fin_vertex;
    PK_LOGICAL_t vertex_point;
    PK_LOGICAL_t vertex_normal;
    PK_LOGICAL_t vertex_param;
    PK_LOGICAL_t point_vec;
    PK_LOGICAL_t normal_vec;
    PK_LOGICAL_t param_uv;
    PK_LOGICAL_t param_dp;
    PK_LOGICAL_t param_d2p;
    PK_LOGICAL_t facet_face;
    PK_LOGICAL_t facet_occ;
    PK_LOGICAL_t edge_fin;
    PK_LOGICAL_t edge_occ;
    PK_LOGICAL_t error_facet;
    };
    typedef struct PK_TOPOL_facet_choice_o_s PK_TOPOL_facet_choice_o_t;



/* PK_TOPOL_facet_choice_o_m */

#define PK_TOPOL_facet_choice_o_m( opt )                                \
    (   (opt).o_t_version                = 11,                          \
        (opt).facet_fin                  = PK_LOGICAL_true,             \
        (opt).fin_fin                    = PK_LOGICAL_true,             \
        (opt).fin_vertex                 = PK_LOGICAL_true,             \
        (opt).vertex_point               = PK_LOGICAL_true,             \
        (opt).vertex_normal              = PK_LOGICAL_false,            \
        (opt).vertex_param               = PK_LOGICAL_false,            \
        (opt).point_vec                  = PK_LOGICAL_true,             \
        (opt).normal_vec                 = PK_LOGICAL_false,            \
        (opt).param_uv                   = PK_LOGICAL_false,            \
        (opt).param_dp                   = PK_LOGICAL_false,            \
        (opt).param_d2p                  = PK_LOGICAL_false,            \
        (opt).facet_face                 = PK_LOGICAL_false,            \
        (opt).facet_occ                  = PK_LOGICAL_false,            \
        (opt).edge_fin                   = PK_LOGICAL_false,            \
        (opt).edge_occ                   = PK_LOGICAL_false,            \
        (opt).error_facet                = PK_LOGICAL_false             )


/* PK_TOPOL_facet_choice_2_o_t */

struct PK_TOPOL_facet_choice_2_o_s
    {
    int             o_t_version;            /* version of this PK option struct */
    int             max_facets_per_strip;   /* (10000) */
    PK_facet_split_strip_t                  /* whether to split strips so that */
                    split_strips;           /* no strip spans more than a */
    PK_facet_consistent_parms_t             /* whether to force surface */
                    consistent_parms;       /* parameters for facet vertices */
    PK_facet_smp_t  smp;                    /* whether to multi-thread */
    PK_TOPOL_facet_tables_cb_f_t            /* callback function for returning */
                    facet_tables_cb;        /* facet tables (NULL) */
    PK_POINTER_t    facet_tables_context;   /* context for callback (NULL) */
    PK_LOGICAL_t    thread_safe;            /* whether the callback function is */
    PK_facet_pt_report_t
                    report_pts_off_topol;   /* whether to report facet points */
    PK_LOGICAL_t    facet_fin;              /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    strip_boundary;         /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    strip_zigzag;           /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    fin_fin;                /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    fin_data;               /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    data_point_idx;         /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    data_normal_idx;        /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    data_param_idx;         /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    data_deriv_idx;         /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    point_vec;              /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    normal_vec;             /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    param_uv;               /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    deriv_dp;               /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    deriv_d2p;              /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    facet_face;             /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    strip_face;             /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    fin_edge;               /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    point_topol;            /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    fin_topol;              /* (PK_LOGICAL_false) */
    PK_LOGICAL_t    error_object;           /* (PK_LOGICAL_false) */
    };
    typedef struct PK_TOPOL_facet_choice_2_o_s PK_TOPOL_facet_choice_2_o_t;



/* PK_TOPOL_facet_choice_2_o_m */

#define PK_TOPOL_facet_choice_2_o_m( opt )                                 \
    (   (opt).o_t_version                = 17,                             \
        (opt).max_facets_per_strip       = 10000,                          \
        (opt).split_strips               = PK_facet_split_strip_no_c,      \
        (opt).consistent_parms           = PK_facet_consistent_parms_no_c, \
        (opt).smp                        = PK_facet_smp_no_c,              \
        (opt).facet_tables_cb            = NULL,                           \
        (opt).facet_tables_context       = NULL,                           \
        (opt).thread_safe                = PK_LOGICAL_false,               \
        (opt).report_pts_off_topol       = PK_facet_pt_report_no_c,        \
        (opt).facet_fin                  = PK_LOGICAL_false,               \
        (opt).strip_boundary             = PK_LOGICAL_false,               \
        (opt).strip_zigzag               = PK_LOGICAL_false,               \
        (opt).fin_fin                    = PK_LOGICAL_false,               \
        (opt).fin_data                   = PK_LOGICAL_false,               \
        (opt).data_point_idx             = PK_LOGICAL_false,               \
        (opt).data_normal_idx            = PK_LOGICAL_false,               \
        (opt).data_param_idx             = PK_LOGICAL_false,               \
        (opt).data_deriv_idx             = PK_LOGICAL_false,               \
        (opt).point_vec                  = PK_LOGICAL_false,               \
        (opt).normal_vec                 = PK_LOGICAL_false,               \
        (opt).param_uv                   = PK_LOGICAL_false,               \
        (opt).deriv_dp                   = PK_LOGICAL_false,               \
        (opt).deriv_d2p                  = PK_LOGICAL_false,               \
        (opt).facet_face                 = PK_LOGICAL_false,               \
        (opt).strip_face                 = PK_LOGICAL_false,               \
        (opt).fin_edge                   = PK_LOGICAL_false,               \
        (opt).point_topol                = PK_LOGICAL_false,               \
        (opt).fin_topol                  = PK_LOGICAL_false,               \
        (opt).error_object               = PK_LOGICAL_false                )


/* PK_TOPOL_facet_o_t */

struct PK_TOPOL_facet_o_s
    {
    PK_TOPOL_facet_mesh_o_t       control;
    PK_TOPOL_facet_choice_o_t      choice;
    };
typedef struct PK_TOPOL_facet_o_s PK_TOPOL_facet_o_t;



/* PK_TOPOL_facet_o_m */

#define PK_TOPOL_facet_o_m(opt)                 \
    (                                           \
    PK_TOPOL_facet_mesh_o_m( (opt).control ),   \
    PK_TOPOL_facet_choice_o_m( (opt).choice )   \
    )


/* PK_TOPOL_facet_2_o_t */

struct PK_TOPOL_facet_2_o_s
    {
    PK_TOPOL_facet_mesh_2_o_t      control;
    PK_TOPOL_facet_choice_2_o_t    choice;
    };
typedef struct PK_TOPOL_facet_2_o_s PK_TOPOL_facet_2_o_t;



/* PK_TOPOL_facet_2_o_m */

#define PK_TOPOL_facet_2_o_m(opt)               \
    (                                           \
    PK_TOPOL_facet_mesh_2_o_m( (opt).control ), \
    PK_TOPOL_facet_choice_2_o_m( (opt).choice ) \
    )


/* PK_TOPOL_render_facet_go_o_t */

struct PK_TOPOL_render_facet_go_o_s
    {
    int                       o_t_version;    /* version of PK option struct */
    PK_facet_go_normals_t     go_normals;     /* whether to output GO surface */
    PK_facet_go_parameters_t  go_parameters;  /* whether to output GO surf */
    PK_facet_go_edges_t       go_edges;       /* whether to output GO edge */
    PK_facet_go_strips_t      go_strips;      /* whether to output facets in */
    int                       go_max_facets_per_strip;
    PK_facet_go_interleaved_t go_interleaved; /* whether to interleave the */
    PK_facet_split_strip_t    split_strips;   /* whether to split facet strips */
    PK_facet_consistent_parms_t consistent_parms;

    };
typedef struct PK_TOPOL_render_facet_go_o_s PK_TOPOL_render_facet_go_o_t;



/* PK_TOPOL_render_facet_go_o_m */

#define PK_TOPOL_render_facet_go_o_m( opt )                                \
    (   (opt).o_t_version                = 11,                             \
        (opt).go_normals                 = PK_facet_go_normals_no_c,       \
        (opt).go_parameters              = PK_facet_go_parameters_no_c,    \
        (opt).go_edges                   = PK_facet_go_edges_no_c,         \
        (opt).go_strips                  = PK_facet_go_strips_no_c,        \
        (opt).go_max_facets_per_strip    = 0,                              \
        (opt).go_interleaved             = PK_facet_go_interleaved_no_c,   \
        (opt).split_strips               = PK_facet_split_strip_no_c,      \
        (opt).consistent_parms           = PK_facet_consistent_parms_no_c  )


/* PK_TOPOL_render_facet_o_t */

struct PK_TOPOL_render_facet_o_s
    {
    PK_TOPOL_facet_mesh_o_t       control;
    PK_TOPOL_render_facet_go_o_t  go_option;
    };
typedef struct PK_TOPOL_render_facet_o_s PK_TOPOL_render_facet_o_t;




/* PK_TOPOL_render_facet_o_m */

#define PK_TOPOL_render_facet_o_m(opt)              \
    (                                               \
    PK_TOPOL_facet_mesh_o_m( (opt).control ),       \
    PK_TOPOL_render_facet_go_o_m( (opt).go_option ) \
    )


/* PK_TOPOL_eval_mass_props_o_t */

struct PK_TOPOL_eval_mass_props_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_mass_t           mass;            /* required mass properties */
    PK_mass_periphery_t periphery;       /* periphery required */
    PK_mass_bound_t     bound;           /* bounds on results required */
    PK_LOGICAL_t        single;          /* whether to treat topols as */
    PK_LOGICAL_t        use_facets;      /* whether to use alternative facetted */
    double              facet_tol;       /* chordal tolerance to use for facets */
    PK_mass_local_density_t
                        same_dim_density;
    PK_mass_local_density_t
                        lower_dim_density;
    };

typedef struct PK_TOPOL_eval_mass_props_o_s PK_TOPOL_eval_mass_props_o_t;



/* PK_TOPOL_eval_mass_props_o_m */

#define PK_TOPOL_eval_mass_props_o_m(options)            \
    (                                                    \
       (options).o_t_version = 3,                        \
       (options).mass        = PK_mass_m_of_i_c,         \
       (options).periphery   = PK_mass_periphery_yes_c,  \
       (options).bound       = PK_mass_bound_no_c,       \
       (options).single      = PK_LOGICAL_false,         \
       (options).use_facets  = PK_LOGICAL_false,         \
       (options).facet_tol   = 0.0,                      \
       (options).same_dim_density = PK_mass_local_density_unset_c, \
       (options).lower_dim_density = PK_mass_local_density_unset_c \
    )


/* PK_TOPOL_range_o_t */

struct PK_TOPOL_range_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* whether tolerance value is provided */
    double              tolerance;       /* tolerance on accuracy of distance */
    PK_range_bound_t    bound;           /* bounds on the minimum/maximum */
    PK_range_guess_t    guesses[2];      /* guesses for each end */
    PK_range_type_t     range_type;      /* whether to find the global minimum */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_TOPOL_range_o_s PK_TOPOL_range_o_t;



/* PK_TOPOL_range_o_m */

#define PK_TOPOL_range_o_m(options)                                      \
    (                                                                    \
       (options).o_t_version                = 3,                         \
       (options).have_tolerance             = PK_LOGICAL_false,          \
       (options).tolerance                  = 0.0,                       \
       PK_range_bound_m( (options).bound ),                              \
       PK_range_guess_m( (options).guesses[0] ),                         \
       PK_range_guess_m( (options).guesses[1] ),                         \
       (options).range_type                 = PK_range_type_minimum_c,   \
       (options).opt_level                  = PK_range_opt_performance_c \
    )


/* PK_TOPOL_range_local_o_t */

struct PK_TOPOL_range_local_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_TOPOL_range_local_o_s PK_TOPOL_range_local_o_t;



/* PK_TOPOL_range_local_o_m */

#define PK_TOPOL_range_local_o_m(options)                            \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_TOPOL_range_array_o_t */

struct PK_TOPOL_range_array_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_bound_t    bound;           /* bounds on min/max separation */
    PK_range_type_t     range_type;      /* whether to find the global minimum */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_TOPOL_range_array_o_s PK_TOPOL_range_array_o_t;



/* PK_TOPOL_range_array_o_m */

#define PK_TOPOL_range_array_o_m(options)                            \
    (                                                                \
       (options).o_t_version            = 3,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).range_type             = PK_range_type_minimum_c,   \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_TOPOL_range_vector_o_t */

struct PK_TOPOL_range_vector_o_s
    {
    int                     o_t_version;     /* version number of option */
    PK_LOGICAL_t            have_tolerance;  /* (PK_LOGICAL_false) */
    double                  tolerance;       /* tolerance */
    PK_range_bound_t        bound;           /* bounds on min separation */
    PK_range_guess_t        guess;           /* guess for end on `topol' */
    PK_range_opt_t          opt_level;       /* the level of analysis */
    PK_range_param_entity_t param_entity;    /* option to return a vector and */
   };

typedef struct PK_TOPOL_range_vector_o_s PK_TOPOL_range_vector_o_t;



/* PK_TOPOL_range_vector_o_m */

#define PK_TOPOL_range_vector_o_m(options)                           \
    (                                                                \
       (options).o_t_version            = 3,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       PK_range_guess_m( (options).guess ),                          \
       (options).opt_level              = PK_range_opt_performance_c,\
       (options).param_entity           = PK_range_param_entity_topol_c  \
    )


/* PK_TOPOL_range_local_vector_o_t */

struct PK_TOPOL_range_local_vector_o_s
    {
    int                 o_t_version;      /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;   /* (PK_LOGICAL_false) */
    double              tolerance;        /* tolerance */
    PK_range_type_t     range_type;       /* whether to find local minima */
    PK_LOGICAL_t        orthogonal_only;  /* whether to find only */
    PK_range_opt_t      opt_level;        /* the level of analysis */
    PK_range_param_entity_t param_entity; /* option to return a vector and */
    };

typedef struct PK_TOPOL_range_local_vector_o_s PK_TOPOL_range_local_vector_o_t;



/* PK_TOPOL_range_local_vector_o_m */

#define PK_TOPOL_range_local_vector_o_m(options)                     \
    (                                                                \
       (options).o_t_version            = 4,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       (options).range_type             = PK_range_type_minimum_c,   \
       (options).orthogonal_only        = PK_LOGICAL_false,          \
       (options).opt_level              = PK_range_opt_performance_c,\
       (options).param_entity           = PK_range_param_entity_topol_c  \
    )


/* PK_TOPOL_range_array_vector_o_t */

struct PK_TOPOL_range_array_vector_o_s
    {
    int                     o_t_version;     /* version number of */
    PK_LOGICAL_t            have_tolerance;  /* (PK_LOGICAL_false) */
    double                  tolerance;       /* tolerance */
    PK_range_bound_t        bound;           /* bounds on min separation */
    PK_range_opt_t          opt_level;       /* the level of analysis */
    PK_range_param_entity_t param_entity;    /* option to return a vector and */
    };

typedef struct PK_TOPOL_range_array_vector_o_s PK_TOPOL_range_array_vector_o_t;



/* PK_TOPOL_range_array_vector_o_m */

#define PK_TOPOL_range_array_vector_o_m(options)                     \
    (                                                                \
       (options).o_t_version            = 3,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).opt_level              = PK_range_opt_performance_c,\
       (options).param_entity           = PK_range_param_entity_topol_c  \
    )


/* PK_TOPOL_range_geom_o_t */

struct PK_TOPOL_range_geom_o_s
    {
    int                    o_t_version;     /* version number of option */
    PK_LOGICAL_t           have_tolerance;  /* whether tolerance value is */
    double                 tolerance;       /* tolerance on accuracy of */
    PK_range_bound_t       bound;           /* bounds on the minimum/maximum */
    PK_range_guess_t       guesses[2];      /* guesses for each end */
    PK_range_type_t        range_type;      /* whether to find the global */
    PK_range_param_bound_t param_bound;     /* parameter range for the */
    PK_range_opt_t         opt_level;       /* the level of analysis */
    };

typedef struct PK_TOPOL_range_geom_o_s PK_TOPOL_range_geom_o_t;



/* PK_TOPOL_range_geom_o_m */

#define PK_TOPOL_range_geom_o_m(options)                                 \
    (                                                                    \
       (options).o_t_version                = 2,                         \
       (options).have_tolerance             = PK_LOGICAL_false,          \
       (options).tolerance                  = 0.0,                       \
       PK_range_bound_m( (options).bound ),                              \
       PK_range_guess_m( (options).guesses[0] ),                         \
       PK_range_guess_m( (options).guesses[1] ),                         \
       (options).range_type                 = PK_range_type_minimum_c,   \
       PK_range_param_bound_m( (options).param_bound ),                  \
       (options).opt_level                  = PK_range_opt_performance_c \
    )


/* PK_TOPOL_range_geom_array_o_t */

struct PK_TOPOL_range_geom_array_o_s
    {
    int                     o_t_version;     /* version number of option */
    PK_LOGICAL_t            have_tolerance;  /* whether tolerance value is */
    double                  tolerance;       /* tolerance on accuracy of */
    PK_range_bound_t        bound;           /* bounds on min/max separation */
    PK_range_type_t         range_type;      /* whether to find the global */
    PK_range_param_bound_t *param_bounds;    /* parameter ranges for */
    PK_range_opt_t           opt_level;      /* the level of analysis */
    };

typedef struct PK_TOPOL_range_geom_array_o_s PK_TOPOL_range_geom_array_o_t;




/* PK_TOPOL_range_geom_array_o_m */

#define PK_TOPOL_range_geom_array_o_m(options)                       \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).range_type             = PK_range_type_minimum_c,   \
       (options).param_bounds           = NULL,                      \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_TOPOL_render_line_o_t */

struct PK_TOPOL_render_line_o_s
    {
    int                      o_t_version; /* version of this PK option struct */
    PK_render_edge_t         edge;        /* whether to draw edges */
    PK_render_silhouette_t   silhouette;  /* whether to draw silhouettes */
    PK_render_planar_t       planar;      /* whether to draw planar hatching */
    PK_render_radial_t       radial;      /* whether to draw radial hatching */
    PK_render_param_t        param;       /* whether to draw parametric hatch */
    PK_render_unfix_t        unfix;       /* whether to draw unfixed blends */
    PK_render_vis_t          visibility;  /* whether to determine visibility */
    PK_render_smooth_t       smooth;      /* whether to indicate smooth edges */
    PK_render_internal_t     internal;    /* whether to indicate internal edges */
    PK_render_region_t       region;      /* whether to produce regional data */
    PK_render_hierarch_t     hierarch;    /* whether to produce hierarchical */
    PK_render_bcurve_t       bcurve;      /* method for rendering bcurves */
    PK_render_viewport_t     viewport;    /* whether to use viewport(s) */
    PK_render_invisible_t    invisible;   /* whether to output invisible lines */
    PK_render_drafting_t     drafting;    /* whether to distinguish lines */
    PK_render_self_hidden_t  self_hidden; /* whether to distinguish lines */
    PK_LOGICAL_t             is_curve_chord_tol;
    double                   curve_chord_tol;
    PK_LOGICAL_t             is_curve_chord_max;
    double                   curve_chord_max;
    PK_LOGICAL_t             is_curve_chord_ang;
    double                   curve_chord_ang;
    double                   planar_spacing;
    PK_AXIS1_sf_t            planar_axis;
    double                   radial_around;
    double                   radial_along;
    double                   radial_about;
    double                   param_u;
    double                   param_v;
    double                   unfix_spacing;
    PK_NABOX_sf_t            viewport_sf;
    double                   radial_around_start;
    double                   radial_along_start;
    double                   radial_about_start;
    double                   param_u_start;
    double                   param_v_start;
    PK_render_ignore_t       ignore;
    double                   ignore_value;
    PK_render_overlap_t      overlap;
    PK_render_memory_target_t   memory_target;
    size_t                   memory_target_value;
    PK_LOGICAL_t             is_edge_smooth_tol;
    double                   edge_smooth_tol;
    int                      n_viewports;
    const PK_NABOX_sf_t     *viewports;
    PK_render_transparent_t transparent;  /* whether to draw transparent bodies */
    int                     n_transparent_indices;
    const int              *transparent_indices;
    PK_render_transp_hid_t  transparent_hid;
    int                     n_overlap_indices;
    const int              *overlap_indices1;
    const int              *overlap_indices2;
    int                     n_overlap_indices2;
    int                     n_suppressed_indices;
    const int              *suppressed_indices;
    PK_render_ske_missing_t ske_missing;  /* whether to draw bodies with */
    PK_render_viewport_type_t viewport_type;
    PK_render_viewport_clip_t viewport_clipping;
    PK_render_report_line_t report_lines;  /* whether to report line fit */
    };
typedef struct PK_TOPOL_render_line_o_s PK_TOPOL_render_line_o_t;



/* PK_TOPOL_render_null_g */

#define PK_TOPOL_render_null_g -1.0E36


/* PK_TOPOL_render_line_o_m */



#define PK_TOPOL_render_line_o_m( opt)                                  \
    (   (opt).o_t_version = 18,                                         \
        (opt).edge        = PK_render_edge_yes_c,                       \
        (opt).silhouette  = PK_render_silhouette_no_c,                  \
        (opt).planar      = PK_render_planar_no_c,                      \
        (opt).radial      = PK_render_radial_no_c,                      \
        (opt).param       = PK_render_param_no_c,                       \
        (opt).unfix       = PK_render_unfix_no_c,                       \
        (opt).visibility  = PK_render_vis_no_c,                         \
        (opt).smooth      = PK_render_smooth_no_c,                      \
        (opt).internal    = PK_render_internal_no_c,                    \
        (opt).region      = PK_render_region_no_c,                      \
        (opt).hierarch    = PK_render_hierarch_no_c,                    \
        (opt).bcurve      = PK_render_bcurve_polyline_c,                \
        (opt).viewport    = PK_render_viewport_no_c,                    \
        (opt).invisible   = PK_render_invisible_no_c,                   \
        (opt).drafting    = PK_render_drafting_no_c,                    \
        (opt).self_hidden = PK_render_self_hidden_no_c,                 \
        (opt).is_curve_chord_tol            = PK_LOGICAL_false,         \
        (opt).curve_chord_tol               = 0.0,                      \
        (opt).is_curve_chord_max            = PK_LOGICAL_false,         \
        (opt).curve_chord_max               = 0.0,                      \
        (opt).is_curve_chord_ang            = PK_LOGICAL_false,         \
        (opt).curve_chord_ang               = 0.0,                      \
        (opt).planar_spacing                = 0.0,                      \
        (opt).planar_axis.location.coord[0] = 0.0,                      \
        (opt).planar_axis.location.coord[1] = 0.0,                      \
        (opt).planar_axis.location.coord[2] = 0.0,                      \
        (opt).planar_axis.axis.coord[0]     = 0.0,                      \
        (opt).planar_axis.axis.coord[1]     = 0.0,                      \
        (opt).planar_axis.axis.coord[2]     = 0.0,                      \
        (opt).radial_around                 = 0.0,                      \
        (opt).radial_along                  = 0.0,                      \
        (opt).radial_about                  = 0.0,                      \
        (opt).param_u                       = 0.0,                      \
        (opt).param_v                       = 0.0,                      \
        (opt).unfix_spacing                 = 0.0,                      \
        (opt).radial_around_start           = PK_TOPOL_render_null_g,   \
        (opt).radial_along_start            = PK_TOPOL_render_null_g,   \
        (opt).radial_about_start            = PK_TOPOL_render_null_g,   \
        (opt).param_u_start                 = PK_TOPOL_render_null_g,   \
        (opt).param_v_start                 = PK_TOPOL_render_null_g,   \
        (opt).ignore_value                  = 0.0,                      \
        (opt).ignore                        = PK_render_ignore_no_c,    \
        (opt).overlap                       = PK_render_overlap_no_c,   \
        (opt).memory_target                 = PK_render_memory_target_no_c,\
        (opt).memory_target_value           = 0,                        \
        (opt).is_edge_smooth_tol            = PK_LOGICAL_false,         \
        (opt).edge_smooth_tol               = 0.0,                      \
        (opt).viewports                     = NULL,                     \
        (opt).n_viewports                   = 0,                        \
        (opt).transparent                   = PK_render_transparent_no_c,\
        (opt).n_transparent_indices         = 0,                        \
        (opt).transparent_indices           = NULL,                     \
        (opt).transparent_hid               = PK_render_transp_hid_no_c,\
        (opt).n_overlap_indices             = 0,                        \
        (opt).overlap_indices1              = NULL,                     \
        (opt).overlap_indices2              = NULL,                     \
        (opt).n_overlap_indices2            = 0,                        \
        (opt).n_suppressed_indices          = 0,                        \
        (opt).suppressed_indices            = NULL,                     \
        (opt).ske_missing                   = PK_render_ske_missing_no_c,   \
        (opt).viewport_type                 = PK_render_viewport_type_3D_c, \
        (opt).viewport_clipping             = PK_render_viewport_clip_no_c, \
        (opt).report_lines                  = PK_render_report_line_no_c    \
    )


/* PK_CURVE_make_approx_o_t */

struct PK_CURVE_make_approx_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_CURVE_approx_t   approx_type;     /* approximation type */
    double              tolerance;       /* tolerance ( 0.00001 ) */
    };

typedef struct PK_CURVE_make_approx_o_s PK_CURVE_make_approx_o_t;



/* PK_CURVE_make_approx_o_m */

#define PK_CURVE_make_approx_o_m( options )                     \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).approx_type    = PK_CURVE_approx_arclength_c,  \
       (options).tolerance      = 0.00001                       \
    )


/* PK_CURVE_embed_in_surf_o_t */

struct PK_CURVE_embed_in_surf_o_s
    {
    int             o_t_version;          /* option structure version */
    PK_LOGICAL_t    have_curve_interval;  /* whether have interval */
    PK_INTERVAL_t   curve_interval;       /* parameteric interval of curve */
    };
typedef struct PK_CURVE_embed_in_surf_o_s PK_CURVE_embed_in_surf_o_t;


/* PK_CURVE_embed_in_surf_o_m */

#define PK_CURVE_embed_in_surf_o_m(options)                             \
    (                                                                   \
       (options).o_t_version                = 1,                        \
       (options).have_curve_interval        = PK_LOGICAL_false,         \
       (options).curve_interval.value[0]    = 0.0,                      \
       (options).curve_interval.value[1]    = 1.0                       \
    )


/* PK_CURVE_find_discontinuity_o_t */

struct PK_CURVE_find_discontinuity_o_s
    {
    int             o_t_version;    /* option structure version */
    PK_continuity_t level;          /* indicates level and type of query */
    PK_LOGICAL_t    have_interval;  /* whether to query a curve portion */
    PK_INTERVAL_t   interval;       /* curve portion to query */
    };
typedef struct PK_CURVE_find_discontinuity_o_s
   PK_CURVE_find_discontinuity_o_t;


/* PK_CURVE_find_discontinuity_o_m */

#define PK_CURVE_find_discontinuity_o_m(options)                           \
    (                                                                      \
       (options).o_t_version              = 1,                             \
       (options).level                    = PK_continuity_c3_c,            \
       (options).have_interval            = PK_LOGICAL_false,              \
       (options).interval.value[0]        = 0,                             \
       (options).interval.value[1]        = 1                              \
    )


/* PK_CURVE_find_vectors_r_t */

struct PK_CURVE_find_vectors_r_s
    {
    int                          n_entries;
    int                         *indices;
    PK_CURVE_find_vectors_t     *statuses;
    PK_VECTOR_t                 *vectors;
    double                      *parms;
    };
typedef struct PK_CURVE_find_vectors_r_s PK_CURVE_find_vectors_r_t;



/* PK_CURVE_find_vectors_o_t */

struct PK_CURVE_find_vectors_o_s
    {
    int                 o_t_version;         /* option structure version */
    int                 n_measurements;      /* number of measurements */
    double             *measurements;        /* values of the measurements */
    PK_measure_t        measurement_method;  /* what `measurements' measure */
    PK_ERROR_on_fail_t  error_on_failure;    /* when to return error */
    };
typedef struct PK_CURVE_find_vectors_o_s PK_CURVE_find_vectors_o_t;


/* PK_CURVE_find_vectors_o_m */

#define PK_CURVE_find_vectors_o_m(options)                            \
    (                                                                 \
        (options).o_t_version           = 1,                          \
        (options).n_measurements        = 0,                          \
        (options).measurements          = NULL,                       \
        (options).measurement_method    = PK_measure_chord_ratio_c,   \
        (options).error_on_failure      = PK_ERROR_on_fail_no_c       \
    )


/* PK_CURVE_degen_t */

struct PK_CURVE_degen_s
    {
    PK_CURVE_degen_type_t type;
    PK_LOGICAL_t          have_position;
    PK_VECTOR_t           position;
    PK_INTERVAL_t         range;
    PK_GEOM_t             geom;
    };

typedef struct PK_CURVE_degen_s PK_CURVE_degen_t;



/* PK_CURVE_degens_t */

struct PK_CURVE_degens_s
    {
    int               n_degen;  /* number of degeneracies */
    PK_CURVE_degen_t *degen;    /* details of degeneracies */
    };

typedef struct PK_CURVE_degens_s PK_CURVE_degens_t;



/* PK_CURVE_find_degens_o_t */

struct PK_CURVE_find_degens_o_s
    {
    int              o_t_version;     /* version number of option structure */
    };

typedef struct PK_CURVE_find_degens_o_s PK_CURVE_find_degens_o_t;



/* PK_CURVE_find_degens_o_m */

#define PK_CURVE_find_degens_o_m(options)               \
    (                                                   \
       (options).o_t_version = 1                        \
    )


/* PK_CURVE_fix_degens_o_t */

struct PK_CURVE_fix_degens_o_s
    {
    int                  o_t_version;      /* version number of option */
    double               tolerance;        /* tolerance for approximating */
    double               target_radius;    /* lower bounds for the radius of */
    };

typedef struct PK_CURVE_fix_degens_o_s PK_CURVE_fix_degens_o_t;



/* PK_CURVE_fix_degens_o_m */

#define PK_CURVE_fix_degens_o_m(options)                      \
    (                                                         \
       (options).o_t_version     = 1,                         \
       (options).tolerance       = 1.0e-5,                    \
       (options).target_radius   = 0.0                        \
    )


/* PK_CURVE_fix_degens_cu_t */

struct PK_CURVE_fix_degens_cu_s
    {
    PK_CURVE_t      res_curve;
    PK_fix_status_t status;
    double          achieved_tol;
    double          achieved_radius;
    };

typedef struct PK_CURVE_fix_degens_cu_s PK_CURVE_fix_degens_cu_t;



/* PK_CURVE_fix_degens_r_t */

struct PK_CURVE_fix_degens_r_s
    {
    int                       n_curves;
    PK_CURVE_fix_degens_cu_t *curves;
    };

typedef struct PK_CURVE_fix_degens_r_s PK_CURVE_fix_degens_r_t;



/* PK_CURVE_self_int_t */

struct PK_CURVE_self_int_s
    {
    PK_self_int_type_t type;
    int                n_positions;
    PK_VECTOR_t       *positions;
    int                n_intervals;
    PK_INTERVAL_t     *intervals;
    int                n_entities;
    PK_ENTITY_t       *entities;
    };

typedef struct PK_CURVE_self_int_s PK_CURVE_self_int_t;



/* PK_CURVE_self_ints_t */

struct PK_CURVE_self_ints_s
    {
    int                  n_self_int;  /* number of self-intersections */
    PK_CURVE_self_int_t *self_int;    /* details of self-intersections */
    };

typedef struct PK_CURVE_self_ints_s PK_CURVE_self_ints_t;



/* PK_CURVE_find_self_int_o_t */

struct PK_CURVE_find_self_int_o_s
    {
    int              o_t_version;     /* version number of option structure */
    };

typedef struct PK_CURVE_find_self_int_o_s PK_CURVE_find_self_int_o_t;



/* PK_CURVE_find_self_int_o_m */

#define PK_CURVE_find_self_int_o_m(options)             \
    (                                                   \
       (options).o_t_version = 1                        \
    )


/* PK_CURVE_fix_self_int_o_t */

struct PK_CURVE_fix_self_int_o_s
    {
    int                  o_t_version;     /* version number of option structure */
    PK_fix_method_t      fix_method;      /* method used to generate new curves */
    PK_LOGICAL_t         allow_multiple;  /* whether to allow multiple curves */
    double               tolerance;       /* tolerance for approximating */
    PK_LOGICAL_t         have_param;      /* whether a parameter is supplied */
    double               param;           /* a parameter used to select the */
    };

typedef struct PK_CURVE_fix_self_int_o_s PK_CURVE_fix_self_int_o_t;



/* PK_CURVE_fix_self_int_o_m */

#define PK_CURVE_fix_self_int_o_m(options)                      \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).fix_method     = PK_fix_method_extract_c,      \
       (options).allow_multiple = PK_LOGICAL_true,              \
       (options).tolerance      = 1.0e-5,                       \
       (options).have_param     = PK_LOGICAL_false,             \
       (options).param          = 0.0                           \
    )


/* PK_CURVE_fix_self_int_cu_t */

struct PK_CURVE_fix_self_int_cu_s
    {
    PK_CURVE_t      res_curve;
    PK_fix_status_t status;
    double          achieved_tol;
    };

typedef struct PK_CURVE_fix_self_int_cu_s PK_CURVE_fix_self_int_cu_t;



/* PK_CURVE_fix_self_int_r_t */

struct PK_CURVE_fix_self_int_r_s
    {
    int                         n_curves;
    PK_CURVE_fix_self_int_cu_t *curves;
    PK_CURVE_fix_fault_t        fault;
    };

typedef struct PK_CURVE_fix_self_int_r_s PK_CURVE_fix_self_int_r_t;



/* PK_CURVE_intersect_curve_o_t */

struct PK_CURVE_intersect_curve_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    PK_SURF_t       common_surf;     /* surf containing curves or */
    };

typedef struct PK_CURVE_intersect_curve_o_s PK_CURVE_intersect_curve_o_t;



/* PK_CURVE_intersect_curve_o_m */

#define PK_CURVE_intersect_curve_o_m(options)                 \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0,                 \
       (options).common_surf           = PK_ENTITY_null       \
    )


/* PK_CURVE_make_bcurve_o_t */

struct PK_CURVE_make_bcurve_o_s
    {
    int                     o_t_version;   /* option structure version */
    double                  tolerance;     /* max deviation of `curve' */
    PK_LOGICAL_t            have_degree;   /* whether a degree is */
    int                     degree;        /* degree of `bcurve' */
    PK_force_continuity_t   force_continuity;
    PK_continuity_t         continuity;    /* level of continuity */
    PK_LOGICAL_t            force_non_rational;
    PK_LOGICAL_t            force_bezier;  /* whether `bcurve' should be */
    PK_make_bcurve_update_t update;        /* update flag */
    };

typedef struct PK_CURVE_make_bcurve_o_s PK_CURVE_make_bcurve_o_t;


/* PK_CURVE_make_bcurve_o_m */

#define PK_CURVE_make_bcurve_o_m(options)                                   \
    (                                                                       \
       (options).o_t_version               = 2,                             \
       (options).tolerance                 = 1.0e-5,                        \
       (options).have_degree               = PK_LOGICAL_false,              \
       (options).degree                    = 3,                             \
       (options).force_continuity          = PK_force_continuity_no_c,      \
       (options).continuity                = PK_continuity_c1_c,            \
       (options).force_non_rational        = PK_LOGICAL_false,              \
       (options).force_bezier              = PK_LOGICAL_false,              \
       (options).update                    = PK_make_bcurve_update_default_c\
    )


/* PK_CURVE_make_spcurves_o_t */

struct PK_CURVE_make_spcurves_o_s
    {
    int                       o_t_version;  /* option structure version */
    PK_make_spcurves_degen_t  degenerate;   /* create degenerate SP-curves */
    PK_LOGICAL_t              sense;        /* SP-curves in same direction */
    PK_make_spcurves_method_t sp_method;    /* method used for generating */
    };
typedef struct PK_CURVE_make_spcurves_o_s PK_CURVE_make_spcurves_o_t;


/* PK_CURVE_make_spcurves_o_m */

#define PK_CURVE_make_spcurves_o_m(options)                             \
    (                                                                   \
       (options).o_t_version       = 1,                                 \
       (options).degenerate        = PK_make_spcurves_degen_no_c,       \
       (options).sense             = PK_LOGICAL_true,                   \
       (options).sp_method         = PK_make_spcurves_method_dflt_c     \
    )


/* PK_CURVE_make_wire_body_o_t */

struct PK_CURVE_make_wire_body_o_s
    {
    int             o_t_version;     /* version number of option structure */
    double          tolerance;       /* max separation between any two curve */
    PK_LOGICAL_t    allow_disjoint;  /* is the wire body allowed to be */
    PK_LOGICAL_t    check;           /* check the body for errors? */
    PK_LOGICAL_t    want_edges;      /* return the new edges in new_edges? */
    PK_LOGICAL_t    want_indices;    /* return the edge indices in edge_index? */
    PK_CURVE_sequential_t
                    sequential;      /* whether the curves are supplied in the */
    };

typedef struct PK_CURVE_make_wire_body_o_s PK_CURVE_make_wire_body_o_t;


/* PK_CURVE_make_wire_body_o_m */

#define PK_CURVE_make_wire_body_o_m(options)                         \
    (                                                                \
       (options).o_t_version           = 2,                          \
       (options).tolerance             = 0.000001,                   \
       (options).allow_disjoint        = PK_LOGICAL_true,            \
       (options).check                 = PK_LOGICAL_true,            \
       (options).want_edges            = PK_LOGICAL_false,           \
       (options).want_indices          = PK_LOGICAL_false,           \
       (options).sequential            = PK_CURVE_sequential_no_c    \
    )


/* PK_CURVE_is_isoparam_o_t */

struct PK_CURVE_is_isoparam_o_s
    {
    int           o_t_version;      /* version number of option structure */
    PK_LOGICAL_t  want_interval;    /* whether range on surface is wanted */
    PK_LOGICAL_t  want_alignment;   /* whether to compute how the non-constant */
    };

typedef struct PK_CURVE_is_isoparam_o_s PK_CURVE_is_isoparam_o_t;




/* PK_CURVE_is_isoparam_o_m */

#define PK_CURVE_is_isoparam_o_m(options)                       \
    (                                                           \
        (options).o_t_version           = 1,                    \
        (options).want_interval         = PK_LOGICAL_false,     \
        (options).want_alignment        = PK_LOGICAL_false      \
    )


/* PK_proj_geom_t */

struct PK_proj_geom_s
    {
    PK_GEOM_t            geom;
    PK_INTERVAL_t        range;
    double               achieved_tol;
    };

typedef struct PK_proj_geom_s PK_proj_geom_t;



/* PK_CURVE_project_r_t */

struct PK_CURVE_project_r_s
    {
    int                  n_geoms;
    PK_proj_geom_t      *geoms;
    };

typedef struct PK_CURVE_project_r_s PK_CURVE_project_r_t;



/* PK_CURVE_project_o_t */

struct PK_CURVE_project_o_s
    {
    int                   o_t_version;     /* version number of options */
    PK_LOGICAL_t          have_direction;  /* whether `direction' is set */
    PK_VECTOR1_t          direction;       /* the direction of projection */
    PK_LOGICAL_t          bidirectional;   /* bidirectional projection */
    PK_proj_max_dist_t    use_max_dist;    /* how to limit projection */
    double                max_dist;        /* limiting projection distance */
    PK_proj_face_hidden_t hidden;          /* how to project to hidden faces */
    PK_proj_connect_t     connect;         /* how to connect disjoint outputs */
    PK_CLASS_array_t      banned_classes;  /* array of curve classes which are */
    PK_proj_split_clash_t split_clash;     /* how to split resulting clashes */
    PK_proj_to_points_t   create_points;   /* how to project curves to points */
    PK_LOGICAL_t          construction;    /* whether to add as construction */
    double                tolerance;       /* operation tolerance */
    PK_proj_function_t    function;        /* whether to project or imprint */
    PK_imprint_precision_t
                          imprint_precision;
    PK_proj_nominal_t     nominal;         /* whether to attach as nominal */
    PK_proj_complete_t    complete;        /* how to complete imprints */
    PK_proj_update_t      update;          /* update switch */
    PK_proj_tracking_t    tracking;        /* format of track records */
    };

typedef struct PK_CURVE_project_o_s PK_CURVE_project_o_t;



/* PK_CURVE_project_o_m */

#define PK_CURVE_project_o_m(options)                                    \
    (                                                                    \
       (options).o_t_version            = 3,                             \
       (options).have_direction         = PK_LOGICAL_false,              \
       (options).direction.coord[0]     = 0.0,                           \
       (options).direction.coord[1]     = 0.0,                           \
       (options).direction.coord[2]     = 0.0,                           \
       (options).bidirectional          = PK_LOGICAL_false,              \
       (options).use_max_dist           = PK_proj_max_dist_no_c,         \
       (options).max_dist               = 0.0,                           \
       (options).hidden                 = PK_proj_face_hidden_body_c,    \
       (options).connect                = PK_proj_connect_none_c,        \
       (options).banned_classes.length  = 0,                             \
       (options).banned_classes.array   = NULL,                          \
       (options).split_clash            = PK_proj_split_clash_all_c,     \
       (options).create_points          = PK_proj_to_points_no_c,        \
       (options).construction           = PK_LOGICAL_true,               \
       (options).tolerance              = 1.0e-6,                        \
       (options).function               = PK_proj_function_project_c,    \
       (options).imprint_precision      = PK_imprint_precision_auto_c,   \
       (options).nominal                = PK_proj_nominal_no_c,          \
       (options).complete               = PK_proj_complete_no_c,         \
       (options).update                 = PK_proj_update_default_c,      \
       (options).tracking               = PK_proj_tracking_basic_c       \
    )


/* PK_CURVE_spin_o_t */

struct PK_CURVE_spin_o_s
    {
    int                      o_t_version;
    PK_LOGICAL_t             simplify;              /* (PK_LOGICAL_false) */
    PK_LOGICAL_t             confine;               /* (PK_LOGICAL_false) */
    PK_INTERVAL_t            interval;              /* ((0,0)) */
    };

typedef struct PK_CURVE_spin_o_s PK_CURVE_spin_o_t;



/* PK_CURVE_spin_o_m */

#define PK_CURVE_spin_o_m(options)                                     \
    (                                                                  \
       (options).o_t_version           = 1,                            \
       (options).simplify              = PK_LOGICAL_false,             \
       (options).confine               = PK_LOGICAL_false,             \
       (options).interval.value[0]     = 0,                            \
       (options).interval.value[1]     = 0                             \
    )


/* PK_BCURVE_clamp_knots_o_t */

struct PK_BCURVE_clamp_knots_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BCURVE_clamp_knots_o_s PK_BCURVE_clamp_knots_o_t;



/* PK_BCURVE_clamp_knots_o_m */

#define PK_BCURVE_clamp_knots_o_m(options)                                 \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_BCURVE_join_o_t */

struct PK_BCURVE_join_o_s
    {
    int         o_t_version;         /* version of options structure (1) */
    int         n_knots;             /* number of knot values (0) */
    double     *knots;               /* acceptable values to snap to (NULL) */
    double      snap_tolerance;      /* tolerance for snapping to knots (0.0) */
    };

typedef struct PK_BCURVE_join_o_s PK_BCURVE_join_o_t;



/* PK_BCURVE_join_o_m */

#define PK_BCURVE_join_o_m(options)                         \
    (                                                       \
       (options).o_t_version        = 1,                    \
       (options).n_knots            = 0,                    \
       (options).knots              = NULL,                 \
       (options).snap_tolerance     = 0.0                   \
    )


/* PK_BCURVE_lower_degree_o_t */

struct PK_BCURVE_lower_degree_o_s
    {
    int          o_t_version;        /* options structure version */
    PK_LOGICAL_t have_tolerance;     /* whether tolerance was supplied */
    double       tolerance;          /* distance tolerance */
    };

typedef struct PK_BCURVE_lower_degree_o_s PK_BCURVE_lower_degree_o_t;



/* PK_BCURVE_lower_degree_o_m */

#define PK_BCURVE_lower_degree_o_m(options)                                \
    (                                                                      \
       (options).o_t_version           = 1,                                \
       (options).have_tolerance        = PK_LOGICAL_false,                 \
       (options).tolerance             = 1.0e-08                           \
    )


/* PK_BCURVE_raise_degree_o_t */

struct PK_BCURVE_raise_degree_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BCURVE_raise_degree_o_s PK_BCURVE_raise_degree_o_t;



/* PK_BCURVE_raise_degree_o_m */

#define PK_BCURVE_raise_degree_o_m(options)                                \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_BCURVE_reparameterise_o_t */

struct PK_BCURVE_reparameterise_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BCURVE_reparameterise_o_s PK_BCURVE_reparameterise_o_t;



/* PK_BCURVE_reparameterise_o_m */

#define PK_BCURVE_reparameterise_o_m(options)                              \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_BCURVE_remove_knots_o_t */

struct PK_BCURVE_remove_knots_o_s
    {
    int          o_t_version;        /* options structure version */
    PK_LOGICAL_t have_tolerance;     /* whether tolerance is set */
    double       tolerance;          /* tolerance for knot removal */
    int          n_knot_indices;     /* number of knot indices (0) */
    const int   *knot_indices;       /* indices of knots to be removed (NULL) */
    const int   *remove_multiplicities;
    };

typedef struct PK_BCURVE_remove_knots_o_s PK_BCURVE_remove_knots_o_t;



/* PK_BCURVE_remove_knots_o_m */

#define PK_BCURVE_remove_knots_o_m(options)                        \
    (                                                              \
       (options).o_t_version           = 1,                        \
       (options).have_tolerance        = PK_LOGICAL_false,         \
       (options).tolerance             = 0.0,                      \
       (options).n_knot_indices        = 0,                        \
       (options).knot_indices          = NULL,                     \
       (options).remove_multiplicities = NULL                      \
    )


/* PK_BCURVE_sf_t */

struct PK_BCURVE_sf_s
    {
    int degree;                              /* The degree = order-1. */
    int n_vertices;                          /* The number of vertices. */
    int vertex_dim;                          /* The dimension of each vertex. */
    PK_LOGICAL_t is_rational;                /* True if the curve is rational. */
    double *vertex;                          /* The vertices. */
    PK_BCURVE_form_t form;                   /* The curve shape. */
    int n_knots;                             /* The number of distinct knot */
    int *knot_mult;                          /* The multiplicity of each knot. */
    double *knot;                            /* The distinct knot values. */
    PK_knot_type_t knot_type;                /* Enum describing the knot set. */
    PK_LOGICAL_t is_periodic;                /* True if the curve is periodic. */
    PK_LOGICAL_t is_closed;                  /* True if the curve is closed. */
    PK_self_intersect_t self_intersecting;   /* Yes no or maybe. */
    };
typedef struct PK_BCURVE_sf_s PK_BCURVE_sf_t;


/* PK_BCURVE_ask_knots_o_t */

struct PK_BCURVE_ask_knots_o_s
    {
    int            o_t_version;           /* option structure version */
    PK_LOGICAL_t   want_expanded_knots;   /* whether to return expanded knot */
    };
typedef struct PK_BCURVE_ask_knots_o_s
   PK_BCURVE_ask_knots_o_t;


/* PK_BCURVE_ask_knots_o_m */

#define PK_BCURVE_ask_knots_o_m(options)                                    \
    (                                                                       \
       (options).o_t_version              = 1,                              \
       (options).want_expanded_knots      = PK_LOGICAL_false                \
    )


/* PK_extend_control_t */

struct PK_extend_control_s
    {
    PK_extension_shape_t  extension_shape;  /* The extension method */
    PK_BCURVE_extension_t extension_type;   /* How to measure how far to extend */
    double                value;            /* How far to extend. */
    };

typedef struct PK_extend_control_s PK_extend_control_t;



/* PK_extend_control_m */

#define PK_extend_control_m(control)                                     \
    (                                                                    \
       (control).extension_shape = PK_extension_shape_linear_c,          \
       (control).extension_type  = PK_BCURVE_extension_none_c,           \
       (control).value           = 0.0                                   \
    )


/* PK_BCURVE_extend_o_t */

struct PK_BCURVE_extend_o_s
    {
    int                       o_t_version;    /* options structure version. */
    PK_extend_control_t       low_control;    /* extension required at lower t */
    PK_extend_control_t       high_control;   /* extension required at higher t */
    PK_extend_closed_t        extend_closed;  /* whether to extend closed or */
    };

typedef struct PK_BCURVE_extend_o_s PK_BCURVE_extend_o_t;



/* PK_BCURVE_extend_o_m */

#define PK_BCURVE_extend_o_m(options)                                      \
    (                                                                      \
       (options).o_t_version = 2,                                          \
       PK_extend_control_m( (options).low_control ),                       \
       PK_extend_control_m( (options).high_control ),                      \
       (options).extend_closed = PK_extend_closed_no_c                     \
    )


/* PK_BCURVE_extend_r_t */

struct PK_BCURVE_extend_r_s
    {
    PK_BCURVE_extend_status_t status;
    PK_BCURVE_t               res_bcurve;
    int                       n_values;
    double                   *values;
    };
typedef struct PK_BCURVE_extend_r_s PK_BCURVE_extend_r_t;



/* PK_BCURVE_fit_eval_f_t */

typedef PK_ERROR_code_t(*PK_BCURVE_fit_eval_f_t)
(
/* received */
double                    /*parameter*/,       /* parameter at which to evaluate */
PK_LOGICAL_t              /*calculate_deriv*/, /* whether the evaluator should */
PK_POINTER_t              /*external_data*/,   /* external application data */
/* returned */
PK_VECTOR_t       *const  /*point*/,           /* sample point at `parameter' */
double            *const  /*weight*/,          /* weight of this point */
PK_VECTOR_t       *const  /*deriv*/            /* 1st derivative at `parameter' */
);



/* PK_BCURVE_fit_chain_t */

struct PK_BCURVE_fit_chain_s
    {
    int              n_curves_in_chain;  /* number of curves in this chain (0) */
    PK_CURVE_t      *curves_in_chain;    /* curves in the chain (NULL) */
    PK_INTERVAL_t   *curve_intervals;    /* parameter intervals for each */
    double          *fit_parameters;     /* parameters for bcurve at ends */
    };

typedef struct PK_BCURVE_fit_chain_s PK_BCURVE_fit_chain_t;



/* PK_BCURVE_fit_chain_m */

#define PK_BCURVE_fit_chain_m(chain)                             \
    (                                                            \
       (chain).n_curves_in_chain    = 0,                         \
       (chain).curves_in_chain      = NULL,                      \
       (chain).curve_intervals      = NULL,                      \
       (chain).fit_parameters       = NULL                       \
    )


/* PK_BCURVE_fit_eval_data_t */

struct PK_BCURVE_fit_eval_data_s
    {
    PK_POINTER_t            external_data; /* for external evaluator (NULL) */

    PK_BCURVE_fit_chain_t   chain_data;    /* for internal chain-of-curves */
    };

typedef struct PK_BCURVE_fit_eval_data_s PK_BCURVE_fit_eval_data_t;



/* PK_BCURVE_fit_eval_data_m */

#define PK_BCURVE_fit_eval_data_m(eval_data)                         \
    (                                                                \
       (eval_data).external_data        = NULL,                      \
       PK_BCURVE_fit_chain_m( (eval_data).chain_data )               \
    )


/* PK_BCURVE_fit_data_t */

struct PK_BCURVE_fit_data_s
    {
    PK_BCURVE_fit_eval_type_t    eval_type;  /* what evaluator to use */
    PK_BCURVE_fit_eval_f_t       eval_fn;    /* user evaluator (NULL) */
    PK_BCURVE_fit_eval_data_t    eval_data;  /* evaluator data */
    PK_BCURVE_fit_err_method_t   err_method; /* error method for bcurve */
    PK_LOGICAL_t                 rational;   /* if bcurve is to be rational */
    };

typedef struct PK_BCURVE_fit_data_s  PK_BCURVE_fit_data_t;



/* PK_BCURVE_fit_data_m */

#define PK_BCURVE_fit_data_m(fit_data)                         \
    (                                                          \
       (fit_data).eval_type  = PK_BCURVE_fit_eval_chain_c,     \
       (fit_data).eval_fn    = NULL,                           \
       PK_BCURVE_fit_eval_data_m( (fit_data).eval_data ),      \
       (fit_data).err_method = PK_BCURVE_fit_err_parm_c,       \
       (fit_data).rational   = PK_LOGICAL_false                \
    )


/* PK_BCURVE_fit_fault_t */

struct PK_BCURVE_fit_fault_s
    {
    PK_LOGICAL_t     no_faults;           /* true if the fit succeeded */
    PK_BCURVE_fit_t *status;              /* status for each bcurve */
    double          *distance_errors;     /* final maximum distance errors */
    double          *angular_errors;      /* final maximum angular errors */
    double          *error_parameters;    /* parameters at which the */
    };

typedef struct PK_BCURVE_fit_fault_s PK_BCURVE_fit_fault_t;



/* PK_BCURVE_create_by_fitting_o_t */

struct PK_BCURVE_create_by_fitting_o_s
{
int                           o_t_version;  /* option structure version number */
int                           n_curves;     /* number of bcurves to create (0) */
PK_BCURVE_fit_data_t         *fit_data;     /* array of fitting data (NULL) */
PK_INTERVAL_t                 range;        /* parameter range for bcurves */
double                        tolerance;    /* distance tolerance (0.00001) */
double                        angular_tolerance;  /* angular tolerance (0.0) */
int                           n_break_parms;      /* number of break parms (0) */
double                       *break_parms;        /* break-parameters (NULL) */
};

typedef struct PK_BCURVE_create_by_fitting_o_s PK_BCURVE_create_by_fitting_o_t;



/* PK_BCURVE_create_by_fitting_o_m */

#define PK_BCURVE_create_by_fitting_o_m(options)                        \
    (                                                                   \
       (options).o_t_version          = 1,                              \
       (options).n_curves             = 0,                              \
       (options).fit_data             = NULL,                           \
       (options).range.value[0]       = 0,                              \
       (options).range.value[1]       = 1,                              \
       (options).tolerance            = 1.0e-05,                        \
       (options).angular_tolerance    = 0.0,                            \
       (options).n_break_parms        = 0,                              \
       (options).break_parms          = NULL                            \
    )


/* PK_CURVE_general_eval_f_t */

typedef PK_ERROR_code_t(*PK_CURVE_general_eval_f_t)
(
/* received */
double                    /*parameter*/,       /* parameter at which to evaluate */
int                       /*n_deriv*/,         /* number of derivatives requested */
PK_HAND_t                 /*hand_direction*/,  /* evaluation direction */
PK_POINTER_t              /*external_data*/,   /* external application data */
/* returned */
double            *const  /*derivs*/           /* point and derivatives */
);



/* PK_CURVE_general_user_t */

struct PK_CURVE_general_user_s
    {
    PK_CURVE_general_eval_f_t  eval_fn;            /* user evaluator */
    PK_POINTER_t               eval_data;          /* evaluator data */
    int                        dimension;          /* curve dimension */
    int                        highest_deriv;      /* highest derivative that */
    PK_LOGICAL_t               is_closed;          /* closure of curve */
    PK_LOGICAL_t               is_periodic;        /* periodicity of curve */
    int                        n_discontinuities;  /* size of `discontinuities' */
    double                    *discontinuities;    /* array of parameters at */
    };

typedef struct PK_CURVE_general_user_s  PK_CURVE_general_user_t;



/* PK_CURVE_general_t */

struct PK_CURVE_general_s
    {
    PK_CURVE_general_type_t type;
    union
        {
        PK_CURVE_t              parasolid_curve;
        PK_CURVE_general_user_t user_curve;
        } curve;
    };

typedef struct PK_CURVE_general_s  PK_CURVE_general_t;



/* PK_CURVE_general_m */

#define PK_CURVE_general_m(general_curve)                           \
    (                                                               \
       (general_curve).type             = PK_CURVE_general_curve_c, \
       (general_curve).curve.parasolid_curve  = PK_ENTITY_null      \
    )


/* PK_BCURVE_fitted_fault_t */

struct PK_BCURVE_fitted_fault_s
    {
    PK_BCURVE_fitted_t status;           /* status for the fit */
    double             distance_error;   /* final maximum distance error */
    double             angular_error;    /* final maximum angular error */
    double             error_parameter;  /* parameter at which the */
    };

typedef struct PK_BCURVE_fitted_fault_s PK_BCURVE_fitted_fault_t;



/* PK_BCURVE_create_fitted_o_t */

struct PK_BCURVE_create_fitted_o_s
{
int                 o_t_version;                  /* option structure version */
PK_CURVE_general_t  curve;                        /* curve to be fit */
PK_INTERVAL_t       range;                        /* parameter range for */
double              tolerance;                    /* distance tolerance */
double              angular_tolerance;            /* angular tolerance (0.0) */
int                 n_interpolation_parms;        /* number of parameters at */
double             *interpolation_parms;          /* parameters at which to */
PK_LOGICAL_t        preserve_parameterisation;    /* whether or not the fitted */
};

typedef struct PK_BCURVE_create_fitted_o_s
               PK_BCURVE_create_fitted_o_t;



/* PK_BCURVE_create_fitted_o_m */

#define PK_BCURVE_create_fitted_o_m(options)                        \
    (                                                               \
       (options).o_t_version                = 2,                    \
       (options).range.value[0]             = 0,                    \
       (options).range.value[1]             = 1,                    \
       (options).tolerance                  = 1.0e-06,              \
       (options).angular_tolerance          = 0.0,                  \
       (options).n_interpolation_parms      = 0,                    \
       (options).interpolation_parms        = NULL,                 \
       (options).preserve_parameterisation  = PK_LOGICAL_true       \
    )


/* PK_BCURVE_make_bsurf_lofted_o_t */

struct PK_BCURVE_make_bsurf_lofted_o_s
    {
    int              o_t_version;      /* version number of option structure(1) */
    PK_PARAM_end_t   v_end;            /* end condition at lower v end */
    PK_PARAM_end_t   V_end;            /* end condition at upper V end */
    int              n_v_derivs;       /* number of doubles in v_derivs (0) */
    int              n_V_derivs;       /* number of doubles in V_derivs (0) */
    double          *v_derivs;         /* derivative data at lower v (NULL) */
    double          *V_derivs;         /* derivative data at upper V (NULL) */
    PK_PARAM_twist_t u_v;              /* how lower u lower v twist vector */
    PK_PARAM_twist_t u_V;              /* how lower u upper V twist vector */
    PK_PARAM_twist_t U_v;              /* how upper U lower v twist vector */
    PK_PARAM_twist_t U_V;              /* how upper U upper V twist vector */
    PK_VECTOR_t      u_v_twist;        /* lower u lower v twist vector (0,0,0) */
    PK_VECTOR_t      u_V_twist;        /* lower u upper V twist vector (0,0,0) */
    PK_VECTOR_t      U_v_twist;        /* upper U lower v twist vector (0,0,0) */
    PK_VECTOR_t      U_V_twist;        /* upper U upper V twist vector (0,0,0) */
    PK_PARAM_degen_t v_degen;          /* degeneracy beyond lower v */
    PK_PARAM_degen_t V_degen;          /* degeneracy beyond upper V */
    PK_VECTOR_t      v_degen_vector;   /* position vector of point degeneracy */
    PK_VECTOR_t      V_degen_vector;   /* position vector of point degeneracy */
    int              n_v_degen_bcurve; /* number of doubles in v_degen_bcurve */
    int              n_V_degen_bcurve; /* number of doubles in V_degen_bcurve */
    double          *v_degen_bcurve;   /* vertices of degenerate bcurve (NULL) */
    double          *V_degen_bcurve;   /* vertices of degenerate bcurve (NULL) */
    PK_PARAM_knot_t  how_knot;         /* how knot vector defined */
    double          *knot;             /* knot vector (NULL) */
    PK_LOGICAL_t     amalgamate;       /* whether to amalgamate knot vectors */
    int              n_v_degen_segs;   /* number of degenerate segments to add */
    int              n_V_degen_segs;   /* number of degenerate segments to add */
    int             *v_degen_segs;     /* degenerate segment positions on lower */
    int             *V_degen_segs;     /* degenerate segment positions on upper */
    PK_LOGICAL_t     force_cubic;      /* make result cubic in v even if it is */
    };

typedef struct PK_BCURVE_make_bsurf_lofted_o_s PK_BCURVE_make_bsurf_lofted_o_t;



/* PK_BCURVE_make_bsurf_lofted_o_m */

#define PK_BCURVE_make_bsurf_lofted_o_m(options)                    \
    (                                                               \
       (options).o_t_version             = 1,                       \
       (options).v_end                   = PK_PARAM_end_natural_c,  \
       (options).V_end                   = PK_PARAM_end_natural_c,  \
       (options).n_v_derivs              = 0,                       \
       (options).n_V_derivs              = 0,                       \
       (options).v_derivs                = NULL,                    \
       (options).V_derivs                = NULL,                    \
       (options).u_v                     = PK_PARAM_twist_no_c,     \
       (options).u_V                     = PK_PARAM_twist_no_c,     \
       (options).U_v                     = PK_PARAM_twist_no_c,     \
       (options).U_V                     = PK_PARAM_twist_no_c,     \
       (options).u_v_twist.coord[0]      = 0.0,                     \
       (options).u_v_twist.coord[1]      = 0.0,                     \
       (options).u_v_twist.coord[2]      = 0.0,                     \
       (options).u_V_twist.coord[0]      = 0.0,                     \
       (options).u_V_twist.coord[1]      = 0.0,                     \
       (options).u_V_twist.coord[2]      = 0.0,                     \
       (options).U_v_twist.coord[0]      = 0.0,                     \
       (options).U_v_twist.coord[1]      = 0.0,                     \
       (options).U_v_twist.coord[2]      = 0.0,                     \
       (options).U_V_twist.coord[0]      = 0.0,                     \
       (options).U_V_twist.coord[1]      = 0.0,                     \
       (options).U_V_twist.coord[2]      = 0.0,                     \
       (options).v_degen                 = PK_PARAM_degen_no_c,     \
       (options).V_degen                 = PK_PARAM_degen_no_c,     \
       (options).v_degen_vector.coord[0] = 0.0,                     \
       (options).v_degen_vector.coord[1] = 0.0,                     \
       (options).v_degen_vector.coord[2] = 0.0,                     \
       (options).V_degen_vector.coord[0] = 0.0,                     \
       (options).V_degen_vector.coord[1] = 0.0,                     \
       (options).V_degen_vector.coord[2] = 0.0,                     \
       (options).n_v_degen_bcurve        = 0,                       \
       (options).n_V_degen_bcurve        = 0,                       \
       (options).v_degen_bcurve          = NULL,                    \
       (options).V_degen_bcurve          = NULL,                    \
       (options).how_knot                = PK_PARAM_knot_auto_c,    \
       (options).knot                    = NULL,                    \
       (options).amalgamate              = PK_LOGICAL_false,        \
       (options).n_v_degen_segs          = 0,                       \
       (options).n_V_degen_segs          = 0,                       \
       (options).v_degen_segs            = NULL,                    \
       (options).V_degen_segs            = NULL,                    \
       (options).force_cubic             = PK_LOGICAL_false         \
    )


/* PK_BCURVE_make_matched_o_t */

struct PK_BCURVE_make_matched_o_s
    {
    int             o_t_version;
    };

typedef struct PK_BCURVE_make_matched_o_s PK_BCURVE_make_matched_o_t;



/* PK_BCURVE_make_matched_o_m */

#define PK_BCURVE_make_matched_o_m(options)                 \
    (                                                       \
       (options).o_t_version           = 1                  \
    )


/* PK_BCURVE_piecewise_sf_t */

struct PK_BCURVE_piecewise_sf_s
    {
    int                   degree;            /* The degree = order-1. */
    int                   n_segments;        /* The number of curve segments */
    int                   dim;               /* Dimension of coefficient vecs */
    PK_LOGICAL_t          is_rational;       /* True if the curve is rational. */
    PK_piecewise_rep_t    rep;               /* Representation method. */
    double               *coeffs;            /* Coefficient vectors */
    };
typedef struct PK_BCURVE_piecewise_sf_s PK_BCURVE_piecewise_sf_t;


/* PK_BCURVE_splinewise_sf_t */

struct PK_BCURVE_splinewise_sf_s
    {
    int                   degree;            /* The degree = order-1. */
    int                   n_positions;       /* The number of positions */
    PK_VECTOR_t          *positions;         /* The positions */
    PK_PARAM_end_t        t_end;             /* End condition at lower t */
    PK_PARAM_end_t        T_end;             /* End condition at upper T */
    PK_VECTOR_t           t_deriv;           /* Derivative at lower t */
    PK_VECTOR_t           T_deriv;           /* Derivative at upper T */
    PK_PARAM_knot_t       how_knot;          /* How knot vector defined */
    double               *knot;              /* Knot vector */
    };
typedef struct PK_BCURVE_splinewise_sf_s PK_BCURVE_splinewise_sf_t;


/* PK_BCURVE_create_spline_o_t */

struct PK_BCURVE_create_spline_o_s
    {
    int                     o_t_version;      /* options structure version */

    PK_INTERVAL_t           param_interval;   /* parameter range for the */

    int                     n_parameters;     /* number of parameters (0) */
    const double           *parameters;       /* parameters for `positions' */
    const int              *param_indices;    /* indices linking `parameters' */

    int                     n_derivs;         /* number of derivatives (0) */
    const PK_VECTOR_t      *derivs;           /* derivatives at `positions' */
    const int              *deriv_orders;     /* order of each derivative */
    const int              *deriv_indices;    /* indices linking `derivs' to */

    int                     degree;           /* degree for B-curve (0) */
    PK_LOGICAL_t            is_periodic;      /* whether B-curve is periodic */

    int                     n_knots;          /* number of knots supplied (0) */
    const double           *knots;            /* the knots (NULL) */
    const int              *knot_mults;       /* multiplicities of the knots */
    PK_BCURVE_overdefined_t overdefined;      /* behaviour if overdefined */
    PK_BCURVE_clamp_t       clamp;            /* clamp to apply to the B-curve */
    PK_LOGICAL_t            have_clamp_axes;  /* whether `clamp_axes' are */
    PK_AXIS2_sf_t           clamp_axes;       /* clamp axes */
    };

typedef struct PK_BCURVE_create_spline_o_s PK_BCURVE_create_spline_o_t;



/* PK_BCURVE_create_spline_o_m */

#define PK_BCURVE_create_spline_o_m(options)                                  \
    (                                                                         \
       (options).o_t_version                  = 3,                            \
       (options).param_interval.value[0]      = 0.0,                          \
       (options).param_interval.value[1]      = 1.0,                          \
       (options).n_parameters                 = 0,                            \
       (options).parameters                   = NULL,                         \
       (options).param_indices                = NULL,                         \
       (options).n_derivs                     = 0,                            \
       (options).derivs                       = NULL,                         \
       (options).deriv_orders                 = NULL,                         \
       (options).deriv_indices                = NULL,                         \
       (options).degree                       = 0,                            \
       (options).is_periodic                  = PK_LOGICAL_false,             \
       (options).n_knots                      = 0,                            \
       (options).knots                        = NULL,                         \
       (options).knot_mults                   = NULL,                         \
       (options).overdefined                  = PK_BCURVE_overdefined_fail_c, \
       (options).clamp                        = PK_BCURVE_clamp_no_c,         \
       (options).have_clamp_axes              = PK_LOGICAL_false,             \
       (options).clamp_axes.location.coord[0] = 0.0,                          \
       (options).clamp_axes.location.coord[1] = 0.0,                          \
       (options).clamp_axes.location.coord[2] = 0.0,                          \
       (options).clamp_axes.axis.coord[0]     = 0.0,                          \
       (options).clamp_axes.axis.coord[1]     = 0.0,                          \
       (options).clamp_axes.axis.coord[2]     = 0.0,                          \
       (options).clamp_axes.ref_direction.coord[0] = 0.0,                     \
       (options).clamp_axes.ref_direction.coord[1] = 0.0,                     \
       (options).clamp_axes.ref_direction.coord[2] = 0.0                      \
    )


/* PK_BCURVE_create_spline_2_o_t */

struct PK_BCURVE_create_spline_2_o_s
    {
    int                     o_t_version;    /* options structure version */

    PK_INTERVAL_t           param_interval; /* parameter range for the */

    int                     n_parameters;   /* number of parameters (0) */
    const double           *parameters;     /* parameters for `positions' */
    const int              *param_indices;  /* indices linking `parameters' to */

    int                     n_derivs;       /* number of derivatives (0) */
    const PK_VECTOR_t      *derivs;         /* derivatives at `positions' */
    const int              *deriv_orders;   /* order of each derivative (NULL) */
    const int              *deriv_indices;  /* indices linking `derivs' to */

    PK_spline_method_t      spline_method;  /* the default behaviour for each */
    int                     n_special;      /* number of `positions' to have */
    const int              *special_indices;
    PK_LOGICAL_t            have_fit_tol;   /* whether a fitted tolerance is */
    double                  fit_tol;        /* fit tolerance */
    PK_LOGICAL_t            have_chordal_tol;
    double                  chordal_tol;    /* the maximum distance between a */
    int                     n_breaks;       /* number of break points (0) */
    const int              *break_indices;  /* indices of `positions' that are */

    int                     degree;         /* degree for B-curve(s) (0) */
    PK_LOGICAL_t            is_periodic;    /* whether spline is periodic */

    int                     n_knots;        /* number of knots supplied (0) */
    const double           *knots;          /* the knots (NULL) */
    const int              *knot_mults;     /* multiplicities of the knots */
    PK_BCURVE_overdefined_t overdefined;    /* behaviour if overdefined */
    PK_BCURVE_clamp_t       clamp;          /* clamp to apply to the */
    PK_LOGICAL_t            have_clamp_axes;
    PK_AXIS2_sf_t           clamp_axes;     /* clamp axes */
    PK_spline_update_t      update;         /* update flag */
    };

typedef struct PK_BCURVE_create_spline_2_o_s PK_BCURVE_create_spline_2_o_t;



/* PK_BCURVE_create_spline_2_o_m */

#define PK_BCURVE_create_spline_2_o_m(options)                                \
    (                                                                         \
       (options).o_t_version                  = 2,                            \
       (options).param_interval.value[0]      = 0.0,                          \
       (options).param_interval.value[1]      = 1.0,                          \
       (options).n_parameters                 = 0,                            \
       (options).parameters                   = NULL,                         \
       (options).param_indices                = NULL,                         \
       (options).n_derivs                     = 0,                            \
       (options).derivs                       = NULL,                         \
       (options).deriv_orders                 = NULL,                         \
       (options).deriv_indices                = NULL,                         \
       (options).spline_method               = PK_spline_method_interpolate_c,\
       (options).n_special                    = 0,                            \
       (options).special_indices              = NULL,                         \
       (options).have_fit_tol                 = PK_LOGICAL_false,             \
       (options).fit_tol                      = 0.0,                          \
       (options).have_chordal_tol             = PK_LOGICAL_false,             \
       (options).chordal_tol                  = 0.0,                          \
       (options).n_breaks                     = 0,                            \
       (options).break_indices                = NULL,                         \
       (options).degree                       = 0,                            \
       (options).is_periodic                  = PK_LOGICAL_false,             \
       (options).n_knots                      = 0,                            \
       (options).knots                        = NULL,                         \
       (options).knot_mults                   = NULL,                         \
       (options).overdefined                  = PK_BCURVE_overdefined_fail_c, \
       (options).clamp                        = PK_BCURVE_clamp_no_c,         \
       (options).have_clamp_axes              = PK_LOGICAL_false,             \
       (options).clamp_axes.location.coord[0] = 0.0,                          \
       (options).clamp_axes.location.coord[1] = 0.0,                          \
       (options).clamp_axes.location.coord[2] = 0.0,                          \
       (options).clamp_axes.axis.coord[0]     = 0.0,                          \
       (options).clamp_axes.axis.coord[1]     = 0.0,                          \
       (options).clamp_axes.axis.coord[2]     = 0.0,                          \
       (options).clamp_axes.ref_direction.coord[0] = 0.0,                     \
       (options).clamp_axes.ref_direction.coord[1] = 0.0,                     \
       (options).clamp_axes.ref_direction.coord[2] = 0.0,                     \
       (options).update                       = PK_spline_update_default_c    \
    )


/* PK_BCURVE_spline_cu_t */

struct PK_BCURVE_spline_cu_s
    {
    PK_BCURVE_t             bcurve;          /* the resultant B-curve */
    PK_BCURVE_spline_stat_t status;          /* the status of this B-curve */
    double                  distance_error;  /* the maximum distance error */
    double                  distance_t;      /* the parameter at which the */
    double                  chordal_error;   /* the maximum deviation from the */
    double                  chordal_t;       /* the parameter at which the */
    double                  angular_error;   /* unused */
    double                  angular_t;       /* unused */
    };

typedef struct PK_BCURVE_spline_cu_s PK_BCURVE_spline_cu_t;



/* PK_BCURVE_spline_r_t */

struct PK_BCURVE_spline_r_s
    {
    int                    n_bcurves;       /* number of returned B-curves */
    PK_BCURVE_spline_cu_t *bcurves;         /* information for each returned */
    PK_BCURVE_spline_t     fault;           /* fault */
    int                    n_fault_values;  /* number of fault_values */
    int                   *fault_values;    /* fault values */
    };

typedef struct PK_BCURVE_spline_r_s PK_BCURVE_spline_r_t;



/* PK_SURF_find_discontinuity_o_t */

struct PK_SURF_find_discontinuity_o_s
    {
    int             o_t_version;   /* option structure version */
    PK_continuity_t level;         /* level and type of continuity to calculate */
    PK_LOGICAL_t    have_uvbox;    /* true if sub-domain is to be used */
    PK_UVBOX_t      uvbox;         /* sub-domain of surface */
    };
typedef struct PK_SURF_find_discontinuity_o_s PK_SURF_find_discontinuity_o_t;



/* PK_SURF_find_discontinuity_o_m */

#define PK_SURF_find_discontinuity_o_m(options)                 \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).level          = PK_continuity_c3_c,           \
       (options).have_uvbox     = PK_LOGICAL_false,             \
       (options).uvbox.param[0] = 0.0,                          \
       (options).uvbox.param[1] = 0.0,                          \
       (options).uvbox.param[2] = 0.0,                          \
       (options).uvbox.param[3] = 0.0                           \
    )


/* PK_SURF_self_int_t */

struct PK_SURF_self_int_s
    {
    PK_self_int_type_t type;
    int                n_positions;
    PK_VECTOR_t       *positions;
    int                n_uvboxes;
    PK_UVBOX_t        *uvboxes;
    int                n_entities;
    PK_ENTITY_t       *entities;
    };

typedef struct PK_SURF_self_int_s PK_SURF_self_int_t;



/* PK_SURF_self_ints_t */

struct PK_SURF_self_ints_s
    {
    int                 n_self_int;  /* number of self-intersections */
    PK_SURF_self_int_t *self_int;    /* details of self-intersections */
    };

typedef struct PK_SURF_self_ints_s PK_SURF_self_ints_t;



/* PK_SURF_find_self_int_o_t */

struct PK_SURF_find_self_int_o_s
    {
    int              o_t_version;     /* version number of option structure */
    };

typedef struct PK_SURF_find_self_int_o_s PK_SURF_find_self_int_o_t;



/* PK_SURF_find_self_int_o_m */

#define PK_SURF_find_self_int_o_m(options)              \
    (                                                   \
       (options).o_t_version = 1                        \
    )


/* PK_SURF_fix_self_int_o_t */

struct PK_SURF_fix_self_int_o_s
    {
    int                  o_t_version;     /* version number of option structure */
    PK_fix_method_t      fix_method;      /* method used to generate new */
    PK_LOGICAL_t         allow_multiple;  /* whether to allow multiple surfaces */
    PK_SURF_split_t      split;           /* whether to prefer splitting the */
    double               tolerance;       /* tolerance for approximating */
    PK_LOGICAL_t         have_uv_param;   /* whether uv parameters are supplied */
    PK_UV_t              uv_param;        /* uv parameters used to select the */
    };

typedef struct PK_SURF_fix_self_int_o_s PK_SURF_fix_self_int_o_t;



/* PK_SURF_fix_self_int_o_m */

#define PK_SURF_fix_self_int_o_m(options)                       \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).fix_method     = PK_fix_method_extract_c,      \
       (options).allow_multiple = PK_LOGICAL_true,              \
       (options).split          = PK_SURF_split_prefer_u_c,     \
       (options).tolerance      = 1.0e-5,                       \
       (options).have_uv_param  = PK_LOGICAL_false,             \
       (options).uv_param.param[0] = 0.0,                       \
       (options).uv_param.param[1] = 0.0                        \
    )


/* PK_SURF_fix_self_int_surf_t */

struct PK_SURF_fix_self_int_surf_s
    {
    PK_SURF_t       res_surf;
    PK_fix_status_t status;
    double          achieved_tol;
    };

typedef struct PK_SURF_fix_self_int_surf_s PK_SURF_fix_self_int_surf_t;



/* PK_SURF_fix_self_int_r_t */

struct PK_SURF_fix_self_int_r_s
    {
    int                          n_surfs;
    PK_SURF_fix_self_int_surf_t *surfs;
    PK_SURF_fix_fault_t          fault;
    };

typedef struct PK_SURF_fix_self_int_r_s PK_SURF_fix_self_int_r_t;



/* PK_SURF_degen_t */

struct PK_SURF_degen_s
    {
    PK_SURF_degen_type_t type;
    PK_LOGICAL_t         have_position;
    PK_VECTOR_t          position;
    PK_LOGICAL_t         have_normal;
    PK_VECTOR1_t         normal;
    PK_UVBOX_t           uvbox;
    };

typedef struct PK_SURF_degen_s PK_SURF_degen_t;



/* PK_SURF_degens_t */

struct PK_SURF_degens_s
    {
    int              n_degen;  /* number of degeneracies */
    PK_SURF_degen_t *degen;    /* details of degeneracies */
    };

typedef struct PK_SURF_degens_s PK_SURF_degens_t;



/* PK_SURF_find_degens_o_t */

struct PK_SURF_find_degens_o_s
    {
    int              o_t_version;     /* version number of option structure */
    };

typedef struct PK_SURF_find_degens_o_s PK_SURF_find_degens_o_t;



/* PK_SURF_find_degens_o_m */

#define PK_SURF_find_degens_o_m(options)                \
    (                                                   \
       (options).o_t_version = 1                        \
    )


/* PK_SURF_fix_degens_o_t */

struct PK_SURF_fix_degens_o_s
    {
    int                  o_t_version;      /* version number of option */
    double               tolerance;        /* tolerance for approximating */
    double               target_radii[2];  /* lower bounds for the radius of */
    int                  n_normals;        /* number of normals (0) */
    const PK_VECTOR1_t  *normals;          /* normals of the degeneracies */
    const int           *normal_indices;   /* indices linking `normals' to each */
    };

typedef struct PK_SURF_fix_degens_o_s PK_SURF_fix_degens_o_t;



/* PK_SURF_fix_degens_o_m */

#define PK_SURF_fix_degens_o_m(options)                       \
    (                                                         \
       (options).o_t_version     = 1,                         \
       (options).tolerance       = 1.0e-5,                    \
       (options).target_radii[0] = 0.0,                       \
       (options).target_radii[1] = 0.0,                       \
       (options).n_normals       = 0,                         \
       (options).normals         = NULL,                      \
       (options).normal_indices  = NULL                       \
    )


/* PK_SURF_fix_degens_r_t */

struct PK_SURF_fix_degens_r_s
    {
    PK_SURF_t       res_surf;
    PK_fix_status_t status;
    double          achieved_tol;
    double          achieved_radii[2];
    };

typedef struct PK_SURF_fix_degens_r_s PK_SURF_fix_degens_r_t;



/* PK_SURF_create_blend_o_t */

struct PK_SURF_create_blend_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_help;       /* (PK_LOGICAL_false) */
    PK_VECTOR_t     help;            /* help vector */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    };

typedef struct PK_SURF_create_blend_o_s PK_SURF_create_blend_o_t;



/* PK_SURF_create_blend_o_m */

#define PK_SURF_create_blend_o_m(options)                 \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_help             = PK_LOGICAL_false,    \
       (options).help.coord[0]         = 0.0,                 \
       (options).help.coord[1]         = 0.0,                 \
       (options).help.coord[2]         = 0.0,                 \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0                  \
    )


/* PK_SURF_extend_o_t */

struct PK_SURF_extend_o_s
    {
    int                  o_t_version;      /* option structure version */
    PK_SURF_extension_t  extension_type;   /* the type of the extension */
    PK_VECTOR_t          extension_point;  /* point to extend to */
    PK_BOX_t             extension_box;    /* box to extend to */
    PK_UVBOX_t           extension_uvbox;  /* uv box to extend to */
    double               u_ratio;          /* ratio of the u parameter */
    double               U_ratio;          /* ratio of the u parameter */
    double               v_ratio;          /* ratio of the v parameter */
    double               V_ratio;          /* ratio of the v parameter */
    PK_LOGICAL_t         allow_partial_extension;
    PK_extension_shape_t extension_shape;  /* the method for extending */
    PK_SURF_extend_update_t
                         update;           /* update flag */
    };

typedef struct PK_SURF_extend_o_s PK_SURF_extend_o_t;



/* PK_SURF_extend_o_m */

#define PK_SURF_extend_o_m(options)                                         \
    (                                                                       \
       (options).o_t_version              = 3,                              \
       (options).extension_type           = PK_SURF_extension_none_c,       \
       (options).extension_point.coord[0] =                                 \
       (options).extension_point.coord[1] =                                 \
       (options).extension_point.coord[2] = 0,                              \
       (options).extension_box.coord[0]   =                                 \
       (options).extension_box.coord[1]   =                                 \
       (options).extension_box.coord[2]   =                                 \
       (options).extension_box.coord[3]   =                                 \
       (options).extension_box.coord[4]   =                                 \
       (options).extension_box.coord[5]   = 0,                              \
       (options).extension_uvbox.param[0] =                                 \
       (options).extension_uvbox.param[1] =                                 \
       (options).extension_uvbox.param[2] =                                 \
       (options).extension_uvbox.param[3] = 0,                              \
       (options).u_ratio                  = 0,                              \
       (options).U_ratio                  = 0,                              \
       (options).v_ratio                  = 0,                              \
       (options).V_ratio                  = 0,                              \
       (options).allow_partial_extension  = PK_LOGICAL_false,               \
       (options).extension_shape          = PK_extension_shape_linear_c,    \
       (options).update                   = PK_SURF_extend_update_default_c \
    )


/* PK_SURF_intersect_curve_o_t */

struct PK_SURF_intersect_curve_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    };

typedef struct PK_SURF_intersect_curve_o_s PK_SURF_intersect_curve_o_t;



/* PK_SURF_intersect_curve_o_m */

#define PK_SURF_intersect_curve_o_m(options)                  \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0                  \
    )


/* PK_SURF_intersect_surf_o_t */

struct PK_SURF_intersect_surf_o_s
    {
    int             o_t_version;     /* version number of option structure */
    PK_LOGICAL_t    have_box;        /* whether box provided (PK_LOGICAL_false) */
    PK_BOX_t        box;             /* box of interest */
    PK_LOGICAL_t    have_uvbox_1;    /* whether box provided for surf_1 */
    PK_UVBOX_t      uvbox_1;         /* uvbox for surf_1 */
    PK_LOGICAL_t    have_uvbox_2;    /* whether box provided for surf_2 */
    PK_UVBOX_t      uvbox_2;         /* uvbox for surf_2 */
    PK_LOGICAL_t    have_vector;     /* whether seed vector provided */
    PK_VECTOR_t     vector;          /* only return branch containing the seed */
    };

typedef struct PK_SURF_intersect_surf_o_s PK_SURF_intersect_surf_o_t;



/* PK_SURF_intersect_surf_o_m */

#define PK_SURF_intersect_surf_o_m(options)                   \
    (                                                         \
       (options).o_t_version           = 1,                   \
       (options).have_box              = PK_LOGICAL_false,    \
       (options).box.coord[0]          = 0.0,                 \
       (options).box.coord[1]          = 0.0,                 \
       (options).box.coord[2]          = 0.0,                 \
       (options).box.coord[3]          = 0.0,                 \
       (options).box.coord[4]          = 0.0,                 \
       (options).box.coord[5]          = 0.0,                 \
       (options).have_uvbox_1          = PK_LOGICAL_false,    \
       (options).uvbox_1.param[0]      = 0.0,                 \
       (options).uvbox_1.param[1]      = 0.0,                 \
       (options).uvbox_1.param[2]      = 0.0,                 \
       (options).uvbox_1.param[3]      = 0.0,                 \
       (options).have_uvbox_2          = PK_LOGICAL_false,    \
       (options).uvbox_2.param[0]      = 0.0,                 \
       (options).uvbox_2.param[1]      = 0.0,                 \
       (options).uvbox_2.param[2]      = 0.0,                 \
       (options).uvbox_2.param[3]      = 0.0,                 \
       (options).have_vector           = PK_LOGICAL_false,    \
       (options).vector.coord[0]       = 0.0,                 \
       (options).vector.coord[1]       = 0.0,                 \
       (options).vector.coord[2]       = 0.0                  \
    )


/* PK_SURF_make_bsurf_o_t */

struct PK_SURF_make_bsurf_o_s
    {
    int                        o_t_version;
    double                     tolerance;  /* tolerance for */
    PK_LOGICAL_t               force_cubic;
    PK_LOGICAL_t               force_non_rational;
    PK_force_continuity_t      force_continuity;
    PK_continuity_t            continuity;
    PK_make_bsurf_update_t     update;     /* update flag */
    };

typedef struct PK_SURF_make_bsurf_o_s PK_SURF_make_bsurf_o_t;



/* PK_SURF_make_bsurf_o_m */

#define PK_SURF_make_bsurf_o_m(options)                                 \
    (                                                                   \
       (options).o_t_version           = 2,                             \
       (options).tolerance             = 1.0e-5,                        \
       (options).force_cubic           = PK_LOGICAL_false,              \
       (options).force_non_rational    = PK_LOGICAL_false,              \
       (options).force_continuity      = PK_force_continuity_no_c,      \
       (options).continuity            = PK_continuity_c1_c,            \
       (options).update                = PK_make_bsurf_update_default_c \
    )


/* PK_SURF_make_sheet_trimmed_o_t */

struct PK_SURF_make_sheet_trimmed_o_s
    {
    int                    o_t_version;      /* option structure version */
    PK_LOGICAL_t           check_wires;      /* identify wire topology */
    PK_LOGICAL_t           check_self_int;   /* check for topological */
    PK_LOGICAL_t           check_loops;      /* check for loop consistency */
    PK_LOGICAL_t           nominal_geom;     /* Enable nominal geometry */
    };

typedef struct PK_SURF_make_sheet_trimmed_o_s
               PK_SURF_make_sheet_trimmed_o_t;



/* PK_SURF_make_sheet_trimmed_o_m */

#define PK_SURF_make_sheet_trimmed_o_m(options)                    \
    (                                                              \
       (options).o_t_version     = 2,                              \
       (options).check_wires     = PK_LOGICAL_false,               \
       (options).check_self_int  = PK_LOGICAL_false,               \
       (options).check_loops     = PK_LOGICAL_false,               \
       (options).nominal_geom    = PK_LOGICAL_false                \
    )


/* PK_SURF_make_curve_isoparam_o_t */

struct PK_SURF_make_curve_isoparam_o_s
{
int                   o_t_version;            /* version number */
PK_isoparam_prefer_t  preferred_curve_type;   /* how to construct an */
PK_LOGICAL_t          want_interval;          /* whether to return the */
};

typedef struct PK_SURF_make_curve_isoparam_o_s
               PK_SURF_make_curve_isoparam_o_t;



/* PK_SURF_make_curve_isoparam_o_m */

#define PK_SURF_make_curve_isoparam_o_m(options)                     \
    (                                                                \
       (options).o_t_version          = 1,                           \
       (options).preferred_curve_type = PK_isoparam_prefer_simple_c, \
       (options).want_interval        = PK_LOGICAL_true              \
    )


/* PK_SURF_make_cus_isocline_o_m */

#define PK_SURF_make_cus_isocline_o_m(options)                \
    (                                                        \
        (options).o_t_version     = 1,                       \
        (options).old_iso         = PK_LOGICAL_false,        \
        (options).all_points      = PK_LOGICAL_true          \
    )


/* PK_SURF_make_cus_isocline_o_t */

struct PK_SURF_make_cus_isocline_o_s
    {
    int            o_t_version;    /* version number of option structure */
    PK_LOGICAL_t   old_iso;        /* whether former isocline curves are */
    PK_LOGICAL_t   all_points;     /* whether curves using all the control */
    };
typedef struct PK_SURF_make_cus_isocline_o_s PK_SURF_make_cus_isocline_o_t;



/* PK_BSURF_clamp_knots_o_t */

struct PK_BSURF_clamp_knots_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BSURF_clamp_knots_o_s PK_BSURF_clamp_knots_o_t;



/* PK_BSURF_clamp_knots_o_m */

#define PK_BSURF_clamp_knots_o_m(options)                                  \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_BSURF_lower_degree_o_t */

struct PK_BSURF_lower_degree_o_s
    {
    int          o_t_version;        /* options structure version */
    PK_LOGICAL_t have_tolerance;     /* whether tolerance was specified */
    double       tolerance;          /* distance tolerance */
    };

typedef struct PK_BSURF_lower_degree_o_s PK_BSURF_lower_degree_o_t;



/* PK_BSURF_lower_degree_o_m */

#define PK_BSURF_lower_degree_o_m(options)                                 \
    (                                                                      \
       (options).o_t_version           = 1,                                \
       (options).have_tolerance        = PK_LOGICAL_false,                 \
       (options).tolerance             = 0.0                               \
    )


/* PK_BSURF_raise_degree_o_t */

struct PK_BSURF_raise_degree_o_s
    {
    int          o_t_version;        /* options structure version */
    };

typedef struct PK_BSURF_raise_degree_o_s PK_BSURF_raise_degree_o_t;



/* PK_BSURF_raise_degree_o_m */

#define PK_BSURF_raise_degree_o_m(options)                                \
    (                                                                      \
       (options).o_t_version           = 1                                 \
    )


/* PK_BSURF_remove_knots_o_t */

struct PK_BSURF_remove_knots_o_s
    {
    int          o_t_version;        /* options structure version */
    PK_LOGICAL_t have_tolerance;     /* whether tolerance is set */
    double       tolerance;          /* tolerance for knot removal */
    int          n_knot_indices;     /* number of knot indices (0) */
    const int   *knot_indices;       /* indices of knots to be removed (NULL) */
    const int   *remove_multiplicities;
    };

typedef struct PK_BSURF_remove_knots_o_s PK_BSURF_remove_knots_o_t;



/* PK_BSURF_remove_knots_o_m */

#define PK_BSURF_remove_knots_o_m(options)                         \
    (                                                              \
       (options).o_t_version           = 1,                        \
       (options).have_tolerance        = PK_LOGICAL_false,         \
       (options).tolerance             = 0.0,                      \
       (options).n_knot_indices        = 0,                        \
       (options).knot_indices          = NULL,                     \
       (options).remove_multiplicities = NULL                      \
    )


/* PK_BSURF_reparameterise_o_t */

struct PK_BSURF_reparameterise_o_s
    {
    int            o_t_version;        /* options structure version */
    PK_LOGICAL_t   have_u_interval;    /* whether to reparameterise along U */
    PK_INTERVAL_t  u_interval;         /* new interval along U direction (0,0) */
    PK_LOGICAL_t   have_v_interval;    /* whether to reparameterise along V */
    PK_INTERVAL_t  v_interval;         /* new interval along V direction (0,0) */
    PK_LOGICAL_t   transpose;          /* whether to transpose U and V */
    PK_LOGICAL_t   reverse_u;          /* whether to reverse the U direction */
    PK_LOGICAL_t   reverse_v;          /* whether to reverse the V direction */
    };

typedef struct PK_BSURF_reparameterise_o_s PK_BSURF_reparameterise_o_t;



/* PK_BSURF_reparameterise_o_m */

#define PK_BSURF_reparameterise_o_m(options)                             \
    (                                                                    \
       (options).o_t_version           = 2,                              \
       (options).have_u_interval       = PK_LOGICAL_false,               \
       (options).u_interval.value[0]   = 0.0,                            \
       (options).u_interval.value[1]   = 0.0,                            \
       (options).have_v_interval       = PK_LOGICAL_false,               \
       (options).v_interval.value[0]   = 0.0,                            \
       (options).v_interval.value[1]   = 0.0,                            \
       (options).transpose             = PK_LOGICAL_false,               \
       (options).reverse_u             = PK_LOGICAL_false,               \
       (options).reverse_v             = PK_LOGICAL_false                \
    )


/* PK_BSURF_sf_t */

struct PK_BSURF_sf_s
    {
    int u_degree;                            /* The degree in u = order-1. */
    int v_degree;                            /* The degree in v = order-1. */
    int n_u_vertices;                        /* The number of vertices in u. */
    int n_v_vertices;                        /* The number of vertices in v. */
    int vertex_dim;                          /* The dimension of each vertex. */
    PK_LOGICAL_t is_rational;                /* True if the surface is rational */
    double *vertex;                          /* The vertices. */
    PK_BSURF_form_t form;                    /* The surface shape. */
    int n_u_knots;                           /* The number of distinct knot */
    int n_v_knots;                           /* The number of distinct knot */
    int *u_knot_mult;                        /* The multiplicities in u. */
    int *v_knot_mult;                        /* The multiplicities in v. */
    double *u_knot;                          /* The distinct knot values in u. */
    double *v_knot;                          /* The distinct knot values in v. */
    PK_knot_type_t u_knot_type;              /* Enum describing the u knot set. */
    PK_knot_type_t v_knot_type;              /* Enum describing the v knot set. */
    PK_LOGICAL_t is_u_periodic;              /* Periodic in u. */
    PK_LOGICAL_t is_v_periodic;              /* Periodic in v. */
    PK_LOGICAL_t is_u_closed;                /* Closed in u. */
    PK_LOGICAL_t is_v_closed;                /* Closed in v. */
    PK_self_intersect_t self_intersecting;   /* Yes no or maybe. */
    PK_convexity_t convexity;                /* Yes no or maybe. */
    };
typedef struct PK_BSURF_sf_s PK_BSURF_sf_t;


/* PK_BSURF_ask_knots_o_t */

struct PK_BSURF_ask_knots_o_s
    {
    int            o_t_version;           /* option structure version */
    PK_LOGICAL_t   want_expanded_knots;   /* whether to return expanded knots */
    };
typedef struct PK_BSURF_ask_knots_o_s
   PK_BSURF_ask_knots_o_t;


/* PK_BSURF_ask_knots_o_m */

#define PK_BSURF_ask_knots_o_m(options)                                     \
    (                                                                       \
       (options).o_t_version              = 1,                              \
       (options).want_expanded_knots      = PK_LOGICAL_false                \
    )


/* PK_SURF_general_eval_f_t */

typedef PK_ERROR_code_t(*PK_SURF_general_eval_f_t)
(
/* received */
PK_UV_t                   /*uv*/,             /* u and v parameter pair */
int                       /*n_u_derivs*/,     /* number of u derivatives */
int                       /*n_v_derivs*/,     /* number of v derivatives */
PK_HAND_t                 /*u_hand_dir*/,     /* u evaluation direction */
PK_HAND_t                 /*v_hand_dir*/,     /* v evaluation direction */
PK_POINTER_t              /*external_data*/,  /* external application data */
/* returned */
double            *const  /*p*/               /* point and derivatives */
);



/* PK_SURF_general_user_t */

struct PK_SURF_general_user_s
    {
    PK_SURF_general_eval_f_t eval_fn;              /* user evaluator */
    PK_POINTER_t             eval_data;            /* evaluator data */
    int                      highest_u_deriv;      /* highest u derivative that */
    int                      highest_v_deriv;      /* highest v derivative that */
    PK_LOGICAL_t             is_u_closed;          /* closure of surface in u */
    PK_LOGICAL_t             is_v_closed;          /* closure of surface in v */
    PK_LOGICAL_t             is_u_periodic;        /* periodicity of surface */
    PK_LOGICAL_t             is_v_periodic;        /* periodicity of surface */
    int                      n_u_discontinuities;  /* number of params in */
    double                  *u_discontinuities;    /* array of u parameters */
    int                      n_v_discontinuities;  /* number of params in */
    double                  *v_discontinuities;    /* array of v parameters */
    };

typedef struct PK_SURF_general_user_s  PK_SURF_general_user_t;



/* PK_SURF_general_t */

struct PK_SURF_general_s
    {
    PK_SURF_general_type_t type;
    union
        {
        PK_SURF_t              parasolid_surf;
        PK_SURF_general_user_t user_surf;
        } surf;
    };

typedef struct PK_SURF_general_s  PK_SURF_general_t;



/* PK_SURF_general_m */

#define PK_SURF_general_m(general_surf)                                \
    (                                                                  \
       (general_surf).type                  = PK_SURF_general_surf_c,  \
       (general_surf).surf.parasolid_surf   = PK_ENTITY_null           \
    )


/* PK_BSURF_fitted_fault_t */

struct PK_BSURF_fitted_fault_s
    {
    PK_BSURF_fitted_t  status;           /* status for the fit */
    double             distance_error;   /* final maximum distance error */
    double             angular_error;    /* final maximum angular error */
    PK_UV_t            error_uv;         /* parameters at which the */
    };

typedef struct PK_BSURF_fitted_fault_s PK_BSURF_fitted_fault_t;



/* PK_BSURF_create_fitted_o_t */

struct PK_BSURF_create_fitted_o_s
{
int                o_t_version;              /* option structure version number */
PK_SURF_general_t  surf;                     /* surface to be fitted */
PK_INTERVAL_t      u_range;                  /* u parameter range for B-surface */
PK_INTERVAL_t      v_range;                  /* v parameter range for B-surface */
double             tolerance;                /* distance tolerance (1.0e-5) */
double             angular_tolerance;        /* angular tolerance (0.0) */
int                n_u_interpolation_parms;  /* number of parameters at which */
const double      *u_interpolation_parms;    /* u parameters at which to */
int                n_v_interpolation_parms;  /* number of parameters at which */
const double      *v_interpolation_parms;    /* v parameters at which to */
};

typedef struct PK_BSURF_create_fitted_o_s
               PK_BSURF_create_fitted_o_t;



/* PK_BSURF_create_fitted_o_m */

#define PK_BSURF_create_fitted_o_m(options)                       \
    (                                                             \
       (options).o_t_version             = 1,                     \
       (options).u_range.value[0]        = 0,                     \
       (options).u_range.value[1]        = 1,                     \
       (options).v_range.value[0]        = 0,                     \
       (options).v_range.value[1]        = 1,                     \
       (options).tolerance               = 1.0e-05,               \
       (options).angular_tolerance       = 0.0,                   \
       (options).n_u_interpolation_parms = 0,                     \
       (options).u_interpolation_parms   = NULL,                  \
       (options).n_v_interpolation_parms = 0,                     \
       (options).v_interpolation_parms   = NULL                   \
    )


/* PK_BSURF_piecewise_sf_t */

struct PK_BSURF_piecewise_sf_s
    {
    int                 u_degree;            /* The degree in u = order-1. */
    int                 v_degree;            /* The degree in v = order-1. */
    int                 n_u_segments;        /* The number of segments in u. */
    int                 n_v_segments;        /* The number of segments in v. */
    int                 dim;                 /* Dimension of coefficient vecs */
    PK_LOGICAL_t        is_rational;         /* True if the surface is rational */
    PK_piecewise_rep_t  rep;                 /* Representation method */
    double             *coeffs;              /* Coefficient vectors */
    };
typedef struct PK_BSURF_piecewise_sf_s PK_BSURF_piecewise_sf_t;


/* PK_BSURF_splinewise_sf_t */

struct PK_BSURF_splinewise_sf_s
    {
    int                 u_degree;       /* The u degree = order -1 */
    int                 v_degree;       /* The u degree = order -1 */
    int                 n_u_positions;  /* The number of positions in u */
    int                 n_v_positions;  /* The number of positions in v */
    PK_VECTOR_t        *positions;      /* The positions */
    PK_PARAM_end_t      u_end;          /* End condition at lower u */
    PK_PARAM_end_t      v_end;          /* End condition at lower v */
    PK_PARAM_end_t      U_end;          /* End condition at upper U */
    PK_PARAM_end_t      V_end;          /* End condition at upper V */
    PK_VECTOR_t        *u_derivs;       /* Derivatives at lower u */
    PK_VECTOR_t        *v_derivs;       /* Derivatives at lower v */
    PK_VECTOR_t        *U_derivs;       /* Derivatives at upper U */
    PK_VECTOR_t        *V_derivs;       /* Derivatives at upper V */
    PK_PARAM_knot_t     u_how_knot;     /* How u knot vector defined */
    PK_PARAM_knot_t     v_how_knot;     /* How v knot vector defined */
    double             *u_knot;         /* u Knot vector */
    double             *v_knot;         /* v Knot vector */
    PK_PARAM_twist_t    u_v;            /* how lower u lower v */
    PK_PARAM_twist_t    u_V;            /* how lower u upper V */
    PK_PARAM_twist_t    U_v;            /* how upper U lower v */
    PK_PARAM_twist_t    U_V;            /* how upper U upper V */
    PK_VECTOR_t         u_v_twist;      /* lower u lower v twist vector */
    PK_VECTOR_t         u_V_twist;      /* lower u upper V twist vector */
    PK_VECTOR_t         U_v_twist;      /* upper U lower v twist vector */
    PK_VECTOR_t         U_V_twist;      /* upper U upper V twist vector */
    };
typedef struct PK_BSURF_splinewise_sf_s PK_BSURF_splinewise_sf_t;


/* PK_BSURF_constrained_fault_t */

struct PK_BSURF_constrained_fault_s
    {
    PK_BSURF_constrained_t  status;          /* status for the surface fit */
    double                  distance_error;  /* the maximum distance error */
    PK_UV_t                 distance_uv;     /* parameters at which the */
    double                  angular_error;   /* the maximum angular error */
    PK_UV_t                 angular_uv;      /* parameters at which the */
    };
typedef struct PK_BSURF_constrained_fault_s PK_BSURF_constrained_fault_t;



/* PK_BSURF_create_constrained_o_t */

struct PK_BSURF_create_constrained_o_s
    {
    int                     o_t_version;   /* version number of options */
    int                     n_positions;   /* number of position constraints */
    const PK_VECTOR_t      *positions;     /* position constraints (NULL) */
    const PK_UV_t          *uvs;           /* uv parameters of `positions' */
    PK_SURF_t               uv_surface;    /* surface for parameterising */
    int                     n_normals;     /* number of normal constraints */
    const PK_VECTOR1_t     *normals;       /* normal constraints (NULL) */
    const int              *normal_indices;
    double                  tolerance;     /* distance tolerance (1.0e-5) */
    double                  angular_tolerance;
    PK_constrained_opt_t    optimise;      /* how to optimise the algorithm */
    PK_constrained_update_t update;        /* update flag */
    };
typedef struct PK_BSURF_create_constrained_o_s PK_BSURF_create_constrained_o_t;



/* PK_BSURF_create_constrained_o_m */

#define PK_BSURF_create_constrained_o_m(options)                            \
       ((options).o_t_version       = 2,                                    \
        (options).n_positions       = 0,                                    \
        (options).positions         = NULL,                                 \
        (options).uvs               = NULL,                                 \
        (options).uv_surface        = PK_ENTITY_null,                       \
        (options).n_normals         = 0,                                    \
        (options).normals           = NULL,                                 \
        (options).normal_indices    = NULL,                                 \
        (options).tolerance         = 1.0e-5,                               \
        (options).angular_tolerance = 0.0,                                  \
        (options).optimise          = PK_constrained_opt_perf_c,            \
        (options).update            = PK_constrained_update_default_c       \
       )


/* PK_POINT_sf_t */


struct PK_POINT_sf_s
    {
    PK_VECTOR_t position;     /* cartesian position */
    };

typedef struct PK_POINT_sf_s PK_POINT_sf_t;



/* PK_GEOM_check_o_t */

struct PK_GEOM_check_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    int                 max_faults;      /* limit on fault numbers (1) */
    PK_check_geom_t     geom;            /* bad geometry (PK_check_geom_yes_c) */
    PK_check_attribs_t  attribs;         /* system attribute validity checks */
    };

typedef struct PK_GEOM_check_o_s PK_GEOM_check_o_t;



/* PK_GEOM_check_o_m */

#define PK_GEOM_check_o_m(options)                      \
    (                                                   \
       (options).o_t_version = 2,                       \
       (options).max_faults  = 1,                       \
       (options).geom        = PK_check_geom_yes_c,     \
       (options).attribs     = PK_check_attribs_no_c    \
    )


/* PK_GEOM_copy_r_t */

struct PK_GEOM_copy_r_s
    {
    int                  n_copied_geoms;
    PK_GEOM_t           *copied_geoms;
    PK_ENTITY_track_r_t  tracking;
    };
typedef struct PK_GEOM_copy_r_s PK_GEOM_copy_r_t;




/* PK_GEOM_copy_o_t */

struct PK_GEOM_copy_o_s
    {
    int                         o_t_version;         /* version number */
    PK_ITEM_t                   destination;         /* destination for copies */
    PK_GEOM_copy_t              copy_dependents;     /* which geometric */
    PK_GEOM_copy_t              copy_attributes;     /* copy attributes */
    };
typedef struct PK_GEOM_copy_o_s PK_GEOM_copy_o_t;



/* PK_GEOM_copy_o_m */

#define PK_GEOM_copy_o_m(options)                                           \
    (                                                                       \
        (options).o_t_version      = 1,                                     \
        (options).destination      = PK_ITEM_null,                          \
        (options).copy_dependents  = PK_GEOM_copy_always_c,                 \
        (options).copy_attributes  = PK_GEOM_copy_never_c                   \
    )


/* PK_GEOM_range_o_t */

struct PK_GEOM_range_o_s
    {
    int                    o_t_version;     /* version number of option struct. */
    PK_LOGICAL_t           have_tolerance;  /* whether tolerance value is */
    double                 tolerance;       /* tolerance on accuracy of */
    PK_range_bound_t       bound;           /* bounds on min separation */
    PK_range_guess_t       guesses[2];      /* guesses for each end */
    PK_range_type_t        range_type;      /* whether to find the global */
    PK_range_param_bound_t param_bound[2];  /* parameter bound for the */
    PK_range_opt_t         opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_o_s PK_GEOM_range_o_t;



/* PK_GEOM_range_o_m */

#define PK_GEOM_range_o_m(options)                                      \
    (                                                                   \
       (options).o_t_version                = 3,                        \
       (options).have_tolerance             = PK_LOGICAL_false,         \
       (options).tolerance                  = 0.0,                      \
       PK_range_bound_m( (options).bound ),                             \
       PK_range_guess_m( (options).guesses[0] ),                        \
       PK_range_guess_m( (options).guesses[1] ),                        \
       (options).range_type                 = PK_range_type_minimum_c,  \
       PK_range_param_bound_m( (options).param_bound[0] ),              \
       PK_range_param_bound_m( (options).param_bound[1] ),              \
       (options).opt_level               = PK_range_opt_performance_c   \
    )


/* PK_GEOM_range_local_o_t */

struct PK_GEOM_range_local_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_local_o_s PK_GEOM_range_local_o_t;



/* PK_GEOM_range_local_o_m */

#define PK_GEOM_range_local_o_m(options)                             \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_GEOM_range_array_o_t */

struct PK_GEOM_range_array_o_s
    {
    int                     o_t_version;      /* version number of option */
    PK_LOGICAL_t            have_tolerance;   /* (PK_LOGICAL_false) */
    double                  tolerance;        /* tolerance */
    PK_range_bound_t        bound;            /* bounds on min separation */
    PK_range_type_t         range_type;       /* whether to find the global */
    PK_range_param_bound_t *param_bounds[2];  /* parameter bound for the */
    PK_range_opt_t          opt_level;        /* the level of analysis */
   };

typedef struct PK_GEOM_range_array_o_s PK_GEOM_range_array_o_t;



/* PK_GEOM_range_array_o_m */

#define PK_GEOM_range_array_o_m(options)                             \
    (                                                                \
       (options).o_t_version            = 3,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).range_type             = PK_range_type_minimum_c,   \
       (options).param_bounds[0]        = NULL,                      \
       (options).param_bounds[1]        = NULL,                      \
       (options).opt_level              = PK_range_opt_performance_c \
   )


/* PK_GEOM_range_vector_o_t */

struct PK_GEOM_range_vector_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_bound_t    bound;           /* bounds on min separation */
    PK_range_guess_t    guess;           /* guess for end on `geom' */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_vector_o_s PK_GEOM_range_vector_o_t;



/* PK_GEOM_range_vector_o_m */

#define PK_GEOM_range_vector_o_m(options)                            \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       PK_range_guess_m( (options).guess ),                          \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_GEOM_range_local_vector_o_t */

struct PK_GEOM_range_local_vector_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_local_vector_o_s PK_GEOM_range_local_vector_o_t;



/* PK_GEOM_range_local_vector_o_m */

#define PK_GEOM_range_local_vector_o_m(options)                      \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_GEOM_range_array_vector_o_t */

struct PK_GEOM_range_array_vector_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* (PK_LOGICAL_false) */
    double              tolerance;       /* tolerance */
    PK_range_bound_t    bound;           /* bounds on min separation */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_array_vector_o_s PK_GEOM_range_array_vector_o_t;



/* PK_GEOM_range_array_vector_o_m */

#define PK_GEOM_range_array_vector_o_m(options)                      \
    (                                                                \
       (options).o_t_version            = 2,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_GEOM_range_vector_many_o_t */

struct PK_GEOM_range_vector_many_o_s
    {
    int                 o_t_version;     /* version number of option structure */
    PK_LOGICAL_t        have_tolerance;  /* whether tolerance value is */
    double              tolerance;       /* tolerance on accuracy of */
    PK_range_bound_t    bound;           /* bounds on minimum separation */
    PK_range_guess_t   *guesses;         /* guesses for end on `geom' (NULL) */
    PK_range_opt_t      opt_level;       /* the level of analysis */
    };

typedef struct PK_GEOM_range_vector_many_o_s PK_GEOM_range_vector_many_o_t;



/* PK_GEOM_range_vector_many_o_m */

#define PK_GEOM_range_vector_many_o_m(options)                        \
    (                                                                \
       (options).o_t_version            = 1,                         \
       (options).have_tolerance         = PK_LOGICAL_false,          \
       (options).tolerance              = 0.0,                       \
       PK_range_bound_m( (options).bound ),                          \
       (options).guesses                = NULL,                      \
       (options).opt_level              = PK_range_opt_performance_c \
    )


/* PK_GEOM_render_line_o_t */

struct PK_GEOM_render_line_o_s
    {
    int                    o_t_version;   /* version of this PK option struct */
    PK_render_param_t      param;         /* whether to draw parametric hatch */
    PK_render_boundary_t   boundary;      /* whether to draw surface boundaries */
    PK_render_bcurve_t     bcurve;        /* method for rendering bcurves */
    PK_LOGICAL_t             is_curve_chord_tol;
    double                   curve_chord_tol;
    PK_LOGICAL_t             is_curve_chord_max;
    double                   curve_chord_max;
    PK_LOGICAL_t             is_curve_chord_ang;
    double                   curve_chord_ang;
    double                 param_u;       /* hatch spacing in U direction (0.0) */
    double                 param_v;       /* hatch spacing in V direction (0.0) */
    };
typedef struct PK_GEOM_render_line_o_s PK_GEOM_render_line_o_t;



/* PK_GEOM_render_line_o_m */



#define PK_GEOM_render_line_o_m( opt)                                   \
    (   (opt).o_t_version = 2,                                          \
        (opt).param       = PK_render_param_no_c,                       \
        (opt).boundary    = PK_render_boundary_yes_c,                   \
        (opt).bcurve      = PK_render_bcurve_polyline_c,                \
        (opt).is_curve_chord_tol            = PK_LOGICAL_false,         \
        (opt).curve_chord_tol = 0.0,                                    \
        (opt).is_curve_chord_max            = PK_LOGICAL_false,         \
        (opt).curve_chord_max = 0.0,                                    \
        (opt).is_curve_chord_ang            = PK_LOGICAL_false,         \
        (opt).curve_chord_ang = 0.0,                                    \
        (opt).param_u  =                      0.0,                      \
        (opt).param_v  =                      0.0                       )



/* PK_GEOM_transform_o_t */

struct PK_GEOM_transform_o_s
{
int                   o_t_version;    /* version of options structure */
double                tolerance;      /* precision for replacing geometry (0.0) */
PK_GEOM_transform_t   modify;         /* modify geometry in-place or */
PK_LOGICAL_t          want_out_geoms; /* fill return array with new geom */
PK_LOGICAL_t          want_exact;     /* fill exact array (PK_LOGICAL_true) */
};
typedef struct PK_GEOM_transform_o_s PK_GEOM_transform_o_t;


/* PK_GEOM_transform_o_m */

#define PK_GEOM_transform_o_m(options)                         \
       ((options).o_t_version    = 1,                          \
        (options).tolerance      = 0.0,                        \
        (options).modify         = PK_GEOM_transform_new_c,    \
        (options).want_out_geoms = PK_LOGICAL_true,            \
        (options).want_exact     = PK_LOGICAL_true             \
       )


/* PK_LINE_sf_t */


struct PK_LINE_sf_s
    {
    PK_AXIS1_sf_t basis_set;  /* a cartesian point and a direction */
    };

typedef struct PK_LINE_sf_s PK_LINE_sf_t;



/* PK_CIRCLE_sf_t */


struct PK_CIRCLE_sf_s
    {
    PK_AXIS2_sf_t basis_set;  /* centre, plane normal, direction to t = 0 */
    double        radius;     /* the radius of the circle(>0) */
    };

typedef struct PK_CIRCLE_sf_s PK_CIRCLE_sf_t;



/* PK_ELLIPSE_sf_t */


struct PK_ELLIPSE_sf_s
    {
    PK_AXIS2_sf_t basis_set;     /* centre, plane normal, major axis */
    double        R1;            /* the larger radius of the ellipse(>0) */
    double        R2;            /* the smaller radius of the ellipse(>0) */
    };

typedef struct PK_ELLIPSE_sf_s PK_ELLIPSE_sf_t;



/* PK_PLANE_sf_t */


struct PK_PLANE_sf_s
    {
    PK_AXIS2_sf_t   basis_set;   /* point, normal, drn of constant v lines */
    };

typedef struct PK_PLANE_sf_s PK_PLANE_sf_t;


/* PK_CYL_sf_t */


struct PK_CYL_sf_s
    {
    PK_AXIS2_sf_t   basis_set;   /* location, cylinder axis, drn. to u = 0 */
    double          radius;      /* the radius of the cylinder */
    };

typedef struct PK_CYL_sf_s PK_CYL_sf_t;


/* PK_CONE_sf_t */


struct PK_CONE_sf_s
    {
    PK_AXIS2_sf_t   basis_set;   /* location, cone axis, drn. to u = 0 */
    double          radius;      /* the radius of a circle on the cone(>=0) */
    double          semi_angle;  /* the half angle of the cone in radians */
    };

typedef struct PK_CONE_sf_s PK_CONE_sf_t;


/* PK_SPHERE_sf_t */


struct PK_SPHERE_sf_s
    {
    PK_AXIS2_sf_t basis_set;  /*centre, drn. to north pole, drn. to u = 0 */
    double        radius;     /*the radius of the sphere(>0) */
    };

typedef struct PK_SPHERE_sf_s PK_SPHERE_sf_t;



/* PK_TORUS_sf_t */


struct PK_TORUS_sf_s
    {
    PK_AXIS2_sf_t basis_set;     /* centre, axis and a reference direction */
    double        major_radius;  /* the major radius of the torus(!=0) */
    double        minor_radius;  /* the minor radius of the torus(>0) */
    };

typedef struct PK_TORUS_sf_s PK_TORUS_sf_t;



/* PK_OFFSET_sf_t */


struct PK_OFFSET_sf_s
    {
    PK_SURF_t       underlying_surface;   /*underlying surface */
    double          offset_distance;      /*an offset distance */
    };

typedef struct PK_OFFSET_sf_s PK_OFFSET_sf_t;



/* PK_TRCURVE_sf_t */


struct PK_TRCURVE_sf_s
    {
    PK_CURVE_t      basis_curve;   /* basis curve */
    PK_INTERVAL_t   t_int;         /* interval on basis curve */
    };

typedef struct PK_TRCURVE_sf_s PK_TRCURVE_sf_t;



/* PK_SWEPT_sf_t */


struct PK_SWEPT_sf_s
    {
    PK_CURVE_t            curve;          /* curve to sweep */
    PK_VECTOR1_t          direction;      /* vector direction to sweep */
    };

typedef struct PK_SWEPT_sf_s PK_SWEPT_sf_t;




/* PK_SPUN_sf_t */


struct PK_SPUN_sf_s
    {
    PK_CURVE_t            curve;          /* curve to spin */
    PK_AXIS1_sf_t         axis;           /* axis defn for spin */
    };

typedef struct PK_SPUN_sf_s PK_SPUN_sf_t;




/* PK_SPCURVE_sf_t */


struct PK_SPCURVE_sf_s
    {
    PK_SURF_t             surf;           /* surface */
    PK_CURVE_t            curve;          /* curve */
    };

typedef struct PK_SPCURVE_sf_s PK_SPCURVE_sf_t;



/* PK_BLENDSF_sf_t */


    struct PK_BLENDSF_sf_s
        {
        PK_GEOM_t     geom_1;        /* first supporting geometry */
        PK_GEOM_t     geom_2;        /* second supporting geometry */
        double        radii[2];      /* blend surface radii */
        PK_CURVE_t    spine;         /* blend spine */
        PK_INTERVAL_t spine_extent;  /* parameter range of spine */
        };
    typedef struct PK_BLENDSF_sf_s PK_BLENDSF_sf_t;



/* PK_FCURVE_sf_t */


    struct PK_FCURVE_sf_s
        {
        char       *key;        /* curve key */
        int         n_ints;     /* number of integer values (>=0) */
        int        *ints;       /* integer values */
        int         n_doubles;  /* number of double values  (>=0) */
        double     *doubles;    /* double values */
        size_t      space;      /* data space required      (>=0) */
        PK_TRANSF_t transf;     /* transformation (may be PK_ENTITY_null) */
        };
    typedef struct PK_FCURVE_sf_s PK_FCURVE_sf_t;




/* PK_FSURF_sf_t */


    struct PK_FSURF_sf_s
        {
        char       *key;        /* surf key */
        int         n_ints;     /* number of integer values (>=0) */
        int        *ints;       /* integer values */
        int         n_doubles;  /* number of double values  (>=0) */
        double     *doubles;    /* double values */
        size_t      space;      /* data space required      (>=0) */
        PK_TRANSF_t transf;     /* transformation (may be PK_ENTITY_null) */
        };
    typedef struct PK_FSURF_sf_s PK_FSURF_sf_t;




/* PK_MARK_frustrum_t */

typedef PK_ERROR_code_t (*PK_MARK_open_f_t)(PK_MARK_t, PK_LOGICAL_t);
typedef PK_ERROR_code_t (*PK_MARK_close_f_t)(PK_MARK_t);
typedef PK_ERROR_code_t (*PK_MARK_write_f_t)(PK_MARK_t, int, const char*);
typedef PK_ERROR_code_t (*PK_MARK_read_f_t)(PK_MARK_t, int, char*);
typedef PK_ERROR_code_t (*PK_MARK_check_f_t)(PK_MARK_t, PK_LOGICAL_t *);
typedef PK_ERROR_code_t (*PK_MARK_delete_f_t)(PK_MARK_t);

struct PK_MARK_frustrum_s
    {
    PK_MARK_open_f_t   open_fn;      /* open a rollmark for read or write */
    PK_MARK_close_f_t  close_fn;     /* close a rollmark */
    PK_MARK_write_f_t  write_fn;     /* write data to a rollmark */
    PK_MARK_read_f_t   read_fn;      /* read data from a rollmark */
    PK_MARK_check_f_t  check_fn;     /* check if mark is still valid */
    PK_MARK_delete_f_t delete_fn;    /* delete a rollmark */
    };
typedef struct PK_MARK_frustrum_s PK_MARK_frustrum_t;




/* PK_MARK_start_o_t */

struct PK_MARK_start_o_s
    {
    PK_LOGICAL_t forward;  /* whether roll-forward is enabled (PK_LOGICAL_true) */
    };
typedef struct PK_MARK_start_o_s PK_MARK_start_o_t;



/* PK_MARK_start_o_m */


#define PK_MARK_start_o_m(val) (val).forward = PK_LOGICAL_true



/* PK_PMARK_ask_entities_o_t */

struct PK_PMARK_ask_entities_o_s
    {
    int                       o_t_version;        /* version number */
    PK_PMARK_t                from_pmark;         /* pmark to start from */
    PK_LOGICAL_t              want_new_entities;  /* return new entities */
    PK_LOGICAL_t              want_mod_entities;  /* return mod entities */
    PK_LOGICAL_t              want_del_entities;  /* return del entities */
    PK_LOGICAL_t              want_logged_mod;    /* return entities modified */
    PK_CLASS_array_t          new_entities_classes;
    PK_CLASS_array_t          mod_entities_classes;
    PK_CLASS_array_t          del_entities_classes;
    };
typedef struct PK_PMARK_ask_entities_o_s PK_PMARK_ask_entities_o_t;



/* PK_PMARK_ask_entities_o_m */

#define PK_PMARK_ask_entities_o_m(options)                      \
    ((options).o_t_version                 = 1,                 \
     (options).from_pmark                  = PK_PMARK_null,     \
     (options).want_new_entities           = PK_LOGICAL_true,   \
     (options).want_mod_entities           = PK_LOGICAL_true,   \
     (options).want_del_entities           = PK_LOGICAL_true,   \
     (options).want_logged_mod             = PK_LOGICAL_false,  \
     (options).new_entities_classes.array  = NULL,              \
     (options).new_entities_classes.length = 0,                 \
     (options).mod_entities_classes.array  = NULL,              \
     (options).mod_entities_classes.length = 0,                 \
     (options).del_entities_classes.array  = NULL,              \
     (options).del_entities_classes.length = 0)


/* PK_PMARK_goto_attrib_cb_f_t */

typedef void (*PK_PMARK_goto_attrib_cb_f_t)
(
/* received */
PK_ATTRIB_t     /*attrib*/,     /* attribute about to be deleted */
PK_ATTDEF_t     /*attdef*/,     /* attribute definition */
PK_POINTER_t    /*context*/     /* context */
);


/* PK_PMARK_goto_attrib_cb_t */

typedef PK_PMARK_goto_attrib_cb_f_t PK_PMARK_goto_attrib_cb_t;


/* PK_PMARK_goto_o_t */

struct PK_PMARK_goto_o_s
    {
    int                       o_t_version;        /* version number */
    PK_LOGICAL_t              want_attrib_mod;    /* return entities modified */
    PK_PMARK_goto_attrib_cb_f_t
                              del_attrib_cb;      /* deleted attribute callback */
    PK_POINTER_t              del_context;        /* context for callback */
    PK_ATTDEF_array_t         del_attdefs;        /* definitions of deleted */
    PK_LOGICAL_t              want_new_entities;  /* return new entities */
    PK_LOGICAL_t              want_mod_entities;  /* return mod entities */
    PK_LOGICAL_t              want_del_entities;  /* return del entities */
    PK_LOGICAL_t              want_logged_mod;    /* return entities modified */
    PK_CLASS_array_t          new_entities_classes;
    PK_CLASS_array_t          mod_entities_classes;
    PK_CLASS_array_t          del_entities_classes;
    };
typedef struct PK_PMARK_goto_o_s PK_PMARK_goto_o_t;



/* PK_PMARK_goto_o_m */

#define PK_PMARK_goto_o_m(options)                              \
    ((options).o_t_version                 = 4,                 \
     (options).want_attrib_mod             = PK_LOGICAL_true,   \
     (options).del_attrib_cb               = NULL,              \
     (options).del_context                 = NULL,              \
     (options).del_attdefs.array           = NULL,              \
     (options).del_attdefs.length          = 0,                 \
     (options).want_new_entities           = PK_LOGICAL_true,   \
     (options).want_mod_entities           = PK_LOGICAL_true,   \
     (options).want_del_entities           = PK_LOGICAL_true,   \
     (options).want_logged_mod             = PK_LOGICAL_false,  \
     (options).new_entities_classes.array  = NULL,              \
     (options).new_entities_classes.length = 0,                 \
     (options).mod_entities_classes.array  = NULL,              \
     (options).mod_entities_classes.length = 0,                 \
     (options).del_entities_classes.array  = NULL,              \
     (options).del_entities_classes.length = 0)


/* PK_PARTITION_advance_pmark_o_m */

#define PK_PARTITION_advance_pmark_o_m(options) \
    ((options).o_t_version = 1)


/* PK_PARTITION_advance_pmark_o_t */

struct PK_PARTITION_advance_pmark_o_s
    {
    int         o_t_version;     /* version number */
    };
typedef struct PK_PARTITION_advance_pmark_o_s PK_PARTITION_advance_pmark_o_t;



/* PK_PARTITION_copy_o_m */

#define PK_PARTITION_copy_o_m(options)                          \
    ((options).o_t_version = 1,                                 \
     (options).copy_deltas = PK_PARTITION_copy_deltas_none_c)


/* PK_PARTITION_copy_o_t */

struct PK_PARTITION_copy_o_s
    {
    int                        o_t_version;
    PK_PARTITION_copy_deltas_t copy_deltas;
    };
typedef struct PK_PARTITION_copy_o_s PK_PARTITION_copy_o_t;



/* PK_PARTITION_delete_o_m */

#define PK_PARTITION_delete_o_m(options)            \
    ((options).o_t_version      = 1,                \
     (options).delete_non_empty = PK_LOGICAL_false)


/* PK_PARTITION_delete_o_t */

struct PK_PARTITION_delete_o_s
    {
    int          o_t_version;        /* version number */
    PK_LOGICAL_t delete_non_empty;   /* forcibly delete non-empty partitions */
    };
typedef struct PK_PARTITION_delete_o_s PK_PARTITION_delete_o_t;



/*  */

#define PK_PARTITION_create_pmark PK_PARTITION_make_pmark


/* PK_PARTITION_make_pmark_o_t */

struct PK_PARTITION_make_pmark_o_s
    {
    int                       o_t_version;        /* structure version */
    PK_LOGICAL_t              want_attrib_mod;    /* return entities modified */
    PK_LOGICAL_t              want_new_entities;  /* return new entities */
    PK_LOGICAL_t              want_mod_entities;  /* return modified entities */
    PK_LOGICAL_t              want_del_entities;  /* return deleted entities */
    PK_LOGICAL_t              want_logged_mod;    /* return entities modified */
    PK_CLASS_array_t          new_entities_classes;
    PK_CLASS_array_t          mod_entities_classes;
    PK_CLASS_array_t          del_entities_classes;
    };
typedef struct PK_PARTITION_make_pmark_o_s PK_PARTITION_make_pmark_o_t;


/* PK_PARTITION_make_pmark_o_m */

#define PK_PARTITION_make_pmark_o_m(options)                    \
    ((options).o_t_version                 = 2,                 \
     (options).want_attrib_mod             = PK_LOGICAL_true,   \
     (options).want_new_entities           = PK_LOGICAL_true,   \
     (options).want_mod_entities           = PK_LOGICAL_true,   \
     (options).want_del_entities           = PK_LOGICAL_true,   \
     (options).want_logged_mod             = PK_LOGICAL_false,  \
     (options).new_entities_classes.array  = NULL,              \
     (options).new_entities_classes.length = 0,                 \
     (options).mod_entities_classes.array  = NULL,              \
     (options).mod_entities_classes.length = 0,                 \
     (options).del_entities_classes.array  = NULL,              \
     (options).del_entities_classes.length = 0)


/* PK_PARTITION_merge_o_m */

#define PK_PARTITION_merge_o_m(options) \
    ((options).o_t_version = 1)


/* PK_PARTITION_merge_o_t */

struct PK_PARTITION_merge_o_s
    {
    int         o_t_version;     /* version number */
    };
typedef struct PK_PARTITION_merge_o_s PK_PARTITION_merge_o_t;



/* PK_PARTITION_receive_o_m */


#define PK_PARTITION_receive_o_m(options)                                     \
       ((options).o_t_version                 = 8,                            \
        (options).transmit_format             = PK_transmit_format_neutral_c, \
        (options).receive_user_fields         = PK_LOGICAL_false,             \
        (options).receive_deltas              = PK_PARTITION_rcv_deltas_no_c, \
        (options).receive_prev_version_deltas = PK_LOGICAL_false,             \
        (options).attdef_callback             = NULL,                         \
        (options).attdef_context              = NULL,                         \
        (options).attdef_callback_on          = PK_ATTDEF_cb_on_mismatch_c,   \
        (options).deltas_block                = NULL,                         \
        (options).receive_all_attdefs         = PK_LOGICAL_true,              \
        (options).allow_missing_deltas        = PK_LOGICAL_false ,            \
        (options).receive_compound            = PK_receive_compound_split_c )


/* PK_PARTITION_receive_o_t */

struct PK_PARTITION_receive_o_s
    {
    int                       o_t_version;
    PK_transmit_format_t      transmit_format;
    PK_LOGICAL_t              receive_user_fields;
    PK_PARTITION_rcv_deltas_t receive_deltas;
    PK_LOGICAL_t              receive_prev_version_deltas;
    PK_ATTDEF_name_cb_f_t     attdef_callback;
    PK_POINTER_t              attdef_context;
    PK_ATTDEF_cb_on_t         attdef_callback_on;
    const PK_MEMORY_block_t  *deltas_block;
    PK_LOGICAL_t              receive_all_attdefs;
    PK_LOGICAL_t              allow_missing_deltas;
    PK_receive_compound_t     receive_compound;
    };
typedef struct PK_PARTITION_receive_o_s PK_PARTITION_receive_o_t;



/* PK_PARTITION_receive_deltas_o_m */


#define PK_PARTITION_receive_deltas_o_m(options)                              \
       ((options).o_t_version               = 3,                              \
        (options).attdef_callback           = NULL,                           \
        (options).attdef_context            = NULL,                           \
        (options).attdef_callback_on        = PK_ATTDEF_cb_on_mismatch_c,     \
        (options).new_at_mark               = PK_PMARK_new_at_current_mark_c, \
        (options).receive_compound          = PK_receive_compound_fail_c )


/* PK_PARTITION_receive_deltas_o_t */

struct PK_PARTITION_receive_deltas_o_s
    {
    int                       o_t_version;
    PK_ATTDEF_name_cb_f_t     attdef_callback;
    PK_POINTER_t              attdef_context;
    PK_ATTDEF_cb_on_t         attdef_callback_on;
    PK_PMARK_new_at_mark_t    new_at_mark;
    PK_receive_compound_t     receive_compound;
    };
typedef struct PK_PARTITION_receive_deltas_o_s PK_PARTITION_receive_deltas_o_t;



/* PK_PARTITION_transmit_o_m */

#define PK_PARTITION_transmit_o_m(options)                                    \
      ((options).o_t_version              = 5,                                \
       (options).transmit_format          = PK_transmit_format_neutral_c,     \
       (options).transmit_user_fields     = PK_LOGICAL_true,                  \
       (options).transmit_deltas          = PK_PARTITION_xmt_deltas_none_c,   \
       (options).transmit_version         = 0,                                \
       (options).transmit_all_attdefs     = PK_LOGICAL_true,                  \
       (options).pmarks.array             = NULL,                             \
       (options).pmarks.length            = 0,                                \
       (options).transmit_indexed_context = NULL)


/* PK_PARTITION_transmit_o_t */

struct PK_PARTITION_transmit_o_s
    {
    int                       o_t_version;
    PK_transmit_format_t      transmit_format;
    PK_LOGICAL_t              transmit_user_fields;
    PK_PARTITION_xmt_deltas_t transmit_deltas;
    int                       transmit_version;
    PK_LOGICAL_t              transmit_all_attdefs;
    PK_PMARK_array_t          pmarks;
    PK_POINTER_t              transmit_indexed_context;
    };
typedef struct PK_PARTITION_transmit_o_s PK_PARTITION_transmit_o_t;



/* PK_PARTITION_transmit_delta_o_m */

#define PK_PARTITION_transmit_delta_o_m(options)                           \
       ((options).o_t_version            = 2,                              \
        (options).transmit_deltas        = PK_PARTITION_xmt_deltas_all_c,  \
        (options).pmarks.array           = NULL,                           \
        (options).pmarks.length          = 0)


/* PK_PARTITION_transmit_delta_o_t */

struct PK_PARTITION_transmit_delta_o_s
    {
    int                       o_t_version;
    PK_PARTITION_xmt_deltas_t transmit_deltas;
    PK_PMARK_array_t          pmarks;
    };
typedef struct PK_PARTITION_transmit_delta_o_s PK_PARTITION_transmit_delta_o_t;



/* PK_SESSION_ask_attdefs_o_m */

#define PK_SESSION_ask_attdefs_o_m(options)     \
    ((options).o_t_version  = 1,                \
     (options).want_attdefs = PK_LOGICAL_true)


/* PK_SESSION_ask_attdefs_o_t */

struct PK_SESSION_ask_attdefs_o_s
    {
    int          o_t_version;        /* version number */
    PK_LOGICAL_t want_attdefs;       /* return attribute definitions */
    };
typedef struct PK_SESSION_ask_attdefs_o_s PK_SESSION_ask_attdefs_o_t;



/* PK_SESSION_smp_o_m */

#define PK_SESSION_smp_o_m(options)                                     \
      ((options).o_t_version            = 1,                            \
       (options).thread_format          = PK_thread_per_processor_c,    \
       (options).n_threads              = 1,                            \
       (options).on_single_processor    = PK_LOGICAL_false)


/* PK_SESSION_smp_o_t */

struct PK_SESSION_smp_o_s
    {
    int                 o_t_version;          /* version number */
    PK_thread_t         thread_format;        /* (PK_thread_per_processor_c) */
    int                 n_threads;            /* (1) */
    PK_LOGICAL_t        on_single_processor;  /* (PK_LOGICAL_false) */
    };
typedef struct PK_SESSION_smp_o_s PK_SESSION_smp_o_t;


/* PK_SESSION_smp_r_t */

struct PK_SESSION_smp_r_s
    {
    PK_thread_t         thread_format;
    int                 n_threads;
    PK_LOGICAL_t        on_single_processor;
    int                 n_processors;
    };
typedef struct PK_SESSION_smp_r_s PK_SESSION_smp_r_t;


/* PK_SESSION_watch_create_cb_t */

typedef void (*PK_SESSION_watch_create_cb_t)(int);



/* PK_SESSION_watch_destroy_cb_t */

typedef void (*PK_SESSION_watch_destroy_cb_t)(int);



/* PK_SESSION_software_option_t */

typedef int PK_SESSION_software_option_t;


/* PK_SESSION_software_option_t */

#define PK_SESSION_SURF_coincide_c      \
      ((PK_SESSION_software_option_t) 4201)
#define PK_SESSION_old_isoclines_c      \
      ((PK_SESSION_software_option_t) 4202)
#define PK_SESSION_old_blend_bounds_c   \
      ((PK_SESSION_software_option_t) 4203)
#define PK_SESSION_PLANE_exact_coi_c    \
      ((PK_SESSION_software_option_t) 4204)
#define PK_SESSION_FACE_old_uvbox_c     \
      ((PK_SESSION_software_option_t) 4205)
#define PK_SESSION_ENTITY_persist_alt_c \
      ((PK_SESSION_software_option_t) 4206)
#define PK_SESSION_check_pre_v140_c \
      ((PK_SESSION_software_option_t) 4207)
#define PK_SESSION_SURF_old_min_radii_c \
      ((PK_SESSION_software_option_t) 4208)
#define PK_SESSION_check_pre_v141_c \
      ((PK_SESSION_software_option_t) 4209)
#define PK_SESSION_old_helix_c \
      ((PK_SESSION_software_option_t) 4210)
#define PK_SESSION_boolean_pre_v141_c \
      ((PK_SESSION_software_option_t) 4211)
#define PK_SESSION_local_ops_pre_v132_c \
      ((PK_SESSION_software_option_t) 4212)
#define PK_SESSION_point_int_pre_v132_c \
      ((PK_SESSION_software_option_t) 4213)
#define PK_SESSION_region_gt_pre_v150_c \
      ((PK_SESSION_software_option_t) 4214)
#define PK_SESSION_pre_v150_switch_1_c \
      ((PK_SESSION_software_option_t) 4215)
#define PK_SESSION_pre_v150_switch_2_c \
      ((PK_SESSION_software_option_t) 4216)
#define PK_SESSION_check_transmit_c \
      ((PK_SESSION_software_option_t) 4217)
#define PK_SESSION_pre_v151_switch_1_c \
      ((PK_SESSION_software_option_t) 4218)
#define PK_SESSION_pre_v150_switch_3_c \
      ((PK_SESSION_software_option_t) 4219)
#define PK_SESSION_pre_v160_switch_1_c \
      ((PK_SESSION_software_option_t) 4220)
#define PK_SESSION_pre_v170_switch_1_c \
      ((PK_SESSION_software_option_t) 4221)
#define PK_SESSION_pre_v161_switch_1_c \
      ((PK_SESSION_software_option_t) 4222)
#define PK_SESSION_pre_v170_switch_2_c \
      ((PK_SESSION_software_option_t) 4223)
#define PK_SESSION_pre_v161_switch_2_c \
      ((PK_SESSION_software_option_t) 4224)
#define PK_SESSION_pre_v180_switch_1_c \
      ((PK_SESSION_software_option_t) 4225)
#define PK_SESSION_pre_v161_switch_3_c \
      ((PK_SESSION_software_option_t) 4226)
#define PK_SESSION_pre_v170_switch_3_c \
      ((PK_SESSION_software_option_t) 4228)
#define PK_SESSION_pre_v170_switch_4_c \
      ((PK_SESSION_software_option_t) 4230)
#define PK_SESSION_pre_v161_switch_4_c \
      ((PK_SESSION_software_option_t) 4229)
#define PK_SESSION_pre_v181_switch_1_c \
      ((PK_SESSION_software_option_t) 4250)
#define PK_SESSION_pre_v170_switch_5_c \
      ((PK_SESSION_software_option_t) 4231)
#define PK_SESSION_pre_v181_switch_2_c \
      ((PK_SESSION_software_option_t) 4251)
#define PK_SESSION_pre_v161_switch_5_c \
      ((PK_SESSION_software_option_t) 4280)
#define PK_SESSION_pre_v180_switch_2_c \
      ((PK_SESSION_software_option_t) 4236)
#define PK_SESSION_pre_v161_switch_6_c \
      ((PK_SESSION_software_option_t) 4281)
#define PK_SESSION_pre_v191_switch_1_c \
      ((PK_SESSION_software_option_t) 4300)
#define PK_SESSION_pre_v171_switch_2_c \
      ((PK_SESSION_software_option_t) 4232)
#define PK_SESSION_pre_v180_switch_3_c \
      ((PK_SESSION_software_option_t) 4237)
#define PK_SESSION_pre_v191_switch_2_c \
      ((PK_SESSION_software_option_t) 4301)
#define PK_SESSION_pre_v191_switch_3_c \
      ((PK_SESSION_software_option_t) 4302)
#define PK_SESSION_pre_v191_switch_4_c \
      ((PK_SESSION_software_option_t) 4303)
#define PK_SESSION_pre_v180_switch_4_c \
      ((PK_SESSION_software_option_t) 4238)
#define PK_SESSION_pre_v181_switch_3_c \
      ((PK_SESSION_software_option_t) 4252)
#define PK_SESSION_pre_v191_switch_5_c \
      ((PK_SESSION_software_option_t) 4304)
#define PK_SESSION_pre_v191_switch_6_c \
      ((PK_SESSION_software_option_t) 4305)
#define PK_SESSION_pre_v191_switch_7_c \
      ((PK_SESSION_software_option_t) 4306)
#define PK_SESSION_pre_v191_switch_8_c \
      ((PK_SESSION_software_option_t) 4307)
#define PK_SESSION_pre_v181_switch_4_c \
      ((PK_SESSION_software_option_t) 4253)
#define PK_SESSION_pre_v191_switch_9_c \
      ((PK_SESSION_software_option_t) 4308)
#define PK_SESSION_pre_v191_switch_10_c \
      ((PK_SESSION_software_option_t) 4309)
#define PK_SESSION_pre_v191_switch_11_c \
      ((PK_SESSION_software_option_t) 4310)
#define PK_SESSION_pre_v191_switch_12_c \
      ((PK_SESSION_software_option_t) 4311)
#define PK_SESSION_pre_v181_switch_5_c \
      ((PK_SESSION_software_option_t) 4254)
#define PK_SESSION_pre_v210_switch_1_c \
      ((PK_SESSION_software_option_t) 4401)
#define PK_SESSION_pre_v181_switch_6_c \
      ((PK_SESSION_software_option_t) 4255)
#define PK_SESSION_pre_v210_switch_2_c \
      ((PK_SESSION_software_option_t) 4402)
#define PK_SESSION_pre_v191_switch_13_c \
      ((PK_SESSION_software_option_t) 4312)
#define PK_SESSION_pre_v191_switch_14_c \
      ((PK_SESSION_software_option_t) 4313)
#define PK_SESSION_pre_v191_switch_15_c \
      ((PK_SESSION_software_option_t) 4314)
#define PK_SESSION_pre_v191_switch_16_c \
      ((PK_SESSION_software_option_t) 4315)
#define PK_SESSION_pre_v181_switch_7_c \
      ((PK_SESSION_software_option_t) 4256)
#define PK_SESSION_pre_v191_switch_17_c \
      ((PK_SESSION_software_option_t) 4316)
#define PK_SESSION_pre_v191_switch_18_c \
      ((PK_SESSION_software_option_t) 4317)
#define PK_SESSION_pre_v191_switch_19_c \
      ((PK_SESSION_software_option_t) 4318)
#define PK_SESSION_pre_v221_switch_1_c \
      ((PK_SESSION_software_option_t) 4501)
#define PK_SESSION_pre_v181_switch_8_c \
      ((PK_SESSION_software_option_t) 4257)
#define PK_SESSION_pre_v221_switch_2_c \
      ((PK_SESSION_software_option_t) 4502)
#define PK_SESSION_pre_v181_switch_9_c \
      ((PK_SESSION_software_option_t) 4258)
#define PK_SESSION_pre_v230_switch_1_c \
      ((PK_SESSION_software_option_t) 4551)
#define PK_SESSION_pre_v221_switch_3_c \
      ((PK_SESSION_software_option_t) 4503)
#define PK_SESSION_pre_v191_switch_20_c \
      ((PK_SESSION_software_option_t) 4319)
#define PK_SESSION_pre_v230_switch_2_c \
      ((PK_SESSION_software_option_t) 4552)
#define PK_SESSION_pre_v230_switch_3_c \
      ((PK_SESSION_software_option_t) 4553)
#define PK_SESSION_pre_v230_switch_4_c \
      ((PK_SESSION_software_option_t) 4554)
#define PK_SESSION_pre_v230_switch_5_c \
      ((PK_SESSION_software_option_t) 4555)
#define PK_SESSION_pre_v191_switch_21_c \
      ((PK_SESSION_software_option_t) 4320)
#define PK_SESSION_pre_v231_switch_1_c \
      ((PK_SESSION_software_option_t) 4601)
#define PK_SESSION_pre_v231_switch_2_c \
      ((PK_SESSION_software_option_t) 4602)
#define PK_SESSION_pre_v230_switch_6_c \
      ((PK_SESSION_software_option_t) 4556)
#define PK_SESSION_pre_v231_switch_3_c \
      ((PK_SESSION_software_option_t) 4603)
#define PK_SESSION_pre_v221_switch_4_c \
      ((PK_SESSION_software_option_t) 4504)
#define PK_SESSION_pre_v230_switch_7_c \
      ((PK_SESSION_software_option_t) 4557)
#define PK_SESSION_pre_v240_switch_1_c \
      ((PK_SESSION_software_option_t) 4651)
#define PK_SESSION_pre_v210_switch_3_c \
      ((PK_SESSION_software_option_t) 4403)
#define PK_SESSION_pre_v230_switch_8_c \
      ((PK_SESSION_software_option_t) 4558)
#define PK_SESSION_pre_v241_switch_1_c \
      ((PK_SESSION_software_option_t) 4701)
#define PK_SESSION_pre_v241_switch_2_c \
      ((PK_SESSION_software_option_t) 4702)
#define PK_SESSION_pre_v240_switch_2_c \
      ((PK_SESSION_software_option_t) 4652)
#define PK_SESSION_pre_v241_switch_3_c \
      ((PK_SESSION_software_option_t) 4703)
#define PK_SESSION_pre_v231_switch_4_c \
      ((PK_SESSION_software_option_t) 4604)
#define PK_SESSION_pre_v240_switch_3_c \
      ((PK_SESSION_software_option_t) 4653)
#define PK_SESSION_pre_v221_switch_6_c \
      ((PK_SESSION_software_option_t) 4506)
#define PK_SESSION_pre_v250_switch_0_c \
      ((PK_SESSION_software_option_t) 4750)
#define PK_SESSION_pre_v221_switch_5_c \
      ((PK_SESSION_software_option_t) 4505)
#define PK_SESSION_pre_v241_switch_4_c \
      ((PK_SESSION_software_option_t) 4704)
#define PK_SESSION_pre_v240_switch_4_c \
      ((PK_SESSION_software_option_t) 4654)
#define PK_SESSION_pre_v250_switch_1_c \
      ((PK_SESSION_software_option_t) 4751)
#define PK_SESSION_pre_v250_switch_2_c \
      ((PK_SESSION_software_option_t) 4752)
#define PK_SESSION_pre_v250_switch_3_c \
      ((PK_SESSION_software_option_t) 4753)
#define PK_SESSION_pre_v250_switch_4_c \
      ((PK_SESSION_software_option_t) 4754)
#define PK_SESSION_pre_v250_switch_5_c \
      ((PK_SESSION_software_option_t) 4755)
#define PK_SESSION_pre_v250_switch_6_c \
      ((PK_SESSION_software_option_t) 4756)
#define PK_SESSION_pre_v251_switch_0_c \
      ((PK_SESSION_software_option_t) 4800)
#define PK_SESSION_pre_v250_switch_7_c \
      ((PK_SESSION_software_option_t) 4757)
#define PK_SESSION_pre_v210_switch_4_c \
      ((PK_SESSION_software_option_t) 4404)
#define PK_SESSION_pre_v240_switch_5_c \
      ((PK_SESSION_software_option_t) 4655)
#define PK_SESSION_pre_v250_switch_8_c \
      ((PK_SESSION_software_option_t) 4758)
#define PK_SESSION_pre_v230_switch_9_c \
      ((PK_SESSION_software_option_t) 4559)
#define PK_SESSION_pre_v250_switch_9_c \
      ((PK_SESSION_software_option_t) 4759)
#define PK_SESSION_pre_v231_switch_5_c \
      ((PK_SESSION_software_option_t) 4605)
#define PK_SESSION_pre_v240_switch_6_c \
      ((PK_SESSION_software_option_t) 4656)
#define PK_SESSION_pre_v241_switch_5_c \
      ((PK_SESSION_software_option_t) 4705)
#define PK_SESSION_pre_v250_switch_10_c \
      ((PK_SESSION_software_option_t) 4760)
#define PK_SESSION_pre_v250_switch_11_c \
      ((PK_SESSION_software_option_t) 4761)
#define PK_SESSION_pre_v251_switch_1_c \
      ((PK_SESSION_software_option_t) 4801)
#define PK_SESSION_pre_v251_switch_2_c \
      ((PK_SESSION_software_option_t) 4802)
#define PK_SESSION_pre_v241_switch_6_c \
      ((PK_SESSION_software_option_t) 4706)
#define PK_SESSION_pre_v250_switch_12_c \
      ((PK_SESSION_software_option_t) 4762)
#define PK_SESSION_pre_v251_switch_3_c \
      ((PK_SESSION_software_option_t) 4803)
#define PK_SESSION_pre_v251_switch_4_c \
      ((PK_SESSION_software_option_t) 4804)
#define PK_SESSION_pre_v260_switch_0_c \
      ((PK_SESSION_software_option_t) 4850)
#define PK_SESSION_pre_v241_switch_7_c \
      ((PK_SESSION_software_option_t) 4707)
#define PK_SESSION_pre_v261_switch_0_c \
      ((PK_SESSION_software_option_t) 4900)
#define PK_SESSION_pre_v191_switch_22_c \
      ((PK_SESSION_software_option_t) 4321)
#define PK_SESSION_post_v260_switch_1_c \
      ((PK_SESSION_software_option_t) 4951)
#define PK_SESSION_pre_v230_switch_10_c \
      ((PK_SESSION_software_option_t) 4560)
#define PK_SESSION_pre_v231_switch_6_c \
      ((PK_SESSION_software_option_t) 4606)
#define PK_SESSION_pre_v260_switch_1_c \
      ((PK_SESSION_software_option_t) 4851)
#define PK_SESSION_pre_v250_switch_13_c \
      ((PK_SESSION_software_option_t) 4763)
#define PK_SESSION_pre_v241_switch_8_c \
      ((PK_SESSION_software_option_t) 4708)
#define PK_SESSION_pre_v230_switch_11_c \
      ((PK_SESSION_software_option_t) 4561)



/* PK_SESSION_frustrum_o_m */

#define PK_SESSION_frustrum_o_m(fr) (\
    (fr).fstart = NULL, \
    (fr).fabort = NULL, \
    (fr).fstop  = NULL, \
    (fr).fmallo = NULL, \
    (fr).fmfree = NULL, \
    (fr).gosgmt = NULL, \
    (fr).goopsg = NULL, \
    (fr).goclsg = NULL, \
    (fr).gopixl = NULL, \
    (fr).gooppx = NULL, \
    (fr).goclpx = NULL, \
    (fr).ffoprd = NULL, \
    (fr).ffopwr = NULL, \
    (fr).ffclos = NULL, \
    (fr).ffread = NULL, \
    (fr).ffwrit = NULL, \
    (fr).ffoprb = NULL, \
    (fr).ffseek = NULL, \
    (fr).fftell = NULL, \
    (fr).fgcrcu = NULL, \
    (fr).fgcrsu = NULL, \
    (fr).fgevcu = NULL, \
    (fr).fgevsu = NULL, \
    (fr).fgprcu = NULL, \
    (fr).fgprsu = NULL, \
    (fr).ucoprd = NULL, \
    (fr).ucopwr = NULL)


/* PK_SESSION_indexio_o_m */

#define PK_SESSION_indexio_o_m(fr) (\
    (fr).ffoprd = NULL, \
    (fr).ffopwr = NULL, \
    (fr).ucoprd = NULL, \
    (fr).ucopwr = NULL, \
    (fr).ffread = NULL, \
    (fr).ffwrit = NULL, \
    (fr).ffseek = NULL, \
    (fr).ffclos = NULL)


/* PK_SESSION_start_o_t */


struct PK_SESSION_start_o_s
    {
    int     o_t_version;   /* version number of this option structure */
    char   *journal_file;  /* name of journal file (NULL) */
    int     user_field;    /* size of user fields in integers (0) */
    int     reserved;      /* for future use (1) */
    };
typedef struct PK_SESSION_start_o_s PK_SESSION_start_o_t;


/* PK_SESSION_start_o_m */

#define PK_SESSION_start_o_m(options)                                     \
       ((options).o_t_version    = 1,                                     \
        (options).journal_file   = NULL,                                  \
        (options).user_field     = 0,                                     \
        (options).reserved       = 1)


/* PK_SESSION_receive_o_m */


#define PK_SESSION_receive_o_m(options)                                  \
       ((options).o_t_version            = 1,                            \
        (options).transmit_format        = PK_transmit_format_neutral_c, \
        (options).receive_user_fields    = PK_LOGICAL_false )



/* PK_SESSION_receive_o_t */

struct PK_SESSION_receive_o_s
    {
    int                             o_t_version;
    PK_transmit_format_t            transmit_format;
    PK_LOGICAL_t                    receive_user_fields;
    };
typedef struct PK_SESSION_receive_o_s PK_SESSION_receive_o_t;



/* PK_SESSION_transmit_o_m */

#define PK_SESSION_transmit_o_m(options)                                \
       ((options).o_t_version          = 2,                             \
        (options).transmit_format      = PK_transmit_format_neutral_c,  \
        (options).transmit_user_fields = PK_LOGICAL_true,               \
        (options).transmit_deltas      = PK_PARTITION_xmt_deltas_none_c)


/* PK_SESSION_transmit_o_t */

struct PK_SESSION_transmit_o_s
    {
    int                             o_t_version;
    PK_transmit_format_t            transmit_format;
    PK_LOGICAL_t                    transmit_user_fields;
    PK_PARTITION_xmt_deltas_t       transmit_deltas;
    };
typedef struct PK_SESSION_transmit_o_s PK_SESSION_transmit_o_t;


/* PK_MEMORY_alloc_f_t */

typedef void* (*PK_MEMORY_alloc_f_t)( size_t );    /* type for an allocator */


/* PK_MEMORY_free_f_t */

typedef void  (*PK_MEMORY_free_f_t) ( void * );    /* type for a free function */


/* PK_MEMORY_frustrum_t */


struct PK_MEMORY_frustrum_s
    {
    PK_MEMORY_alloc_f_t alloc_fn;                  /* registered allocator */
    PK_MEMORY_free_f_t free_fn;                    /* registered free function */
    };
typedef struct PK_MEMORY_frustrum_s PK_MEMORY_frustrum_t;



/* PK_THREAD_chain_start_o_m */

#define PK_THREAD_chain_start_o_m(options)  \
    ((options).o_t_version = 1,             \
     (options).length      = 0)


/* PK_THREAD_chain_start_o_t */

struct PK_THREAD_chain_start_o_s
    {
    int o_t_version;     /* version number */
    int length;          /* maximum length of chain links (0) */
    };
typedef struct PK_THREAD_chain_start_o_s PK_THREAD_chain_start_o_t;


/* PK_THREAD_chain_stop_o_m */

#define PK_THREAD_chain_stop_o_m(options)   \
    ((options).o_t_version = 1)


/* PK_THREAD_chain_stop_o_t */

struct PK_THREAD_chain_stop_o_s
    {
    int o_t_version;     /* version number */
    };
typedef struct PK_THREAD_chain_stop_o_s PK_THREAD_chain_stop_o_t;


/* PK_THREAD_ask_function_run_o_m */

#define PK_THREAD_ask_function_run_o_m(options) \
    ((options).o_t_version = 1)


/* PK_THREAD_ask_function_run_o_t */

struct PK_THREAD_ask_function_run_o_s
    {
    int o_t_version;     /* version number */
    };
typedef struct PK_THREAD_ask_function_run_o_s PK_THREAD_ask_function_run_o_t;


/* PK_THREAD_set_function_run_o_m */

#define PK_THREAD_set_function_run_o_m(options) \
    ((options).o_t_version = 1)


/* PK_THREAD_set_function_run_o_t */

struct PK_THREAD_set_function_run_o_s
    {
    int o_t_version;     /* version number */
    };
typedef struct PK_THREAD_set_function_run_o_s PK_THREAD_set_function_run_o_t;


/* PK_BB_sf_t */


    struct PK_BB_sf_s
        {
        PK_CLASS_array_t create;         /* creation classes */
        PK_CLASS_array_t deleet;         /* deletion classes */
        PK_CLASS_array_t copy;           /* copy classes */
        PK_CLASS_array_t transfer;       /* transfer classes */
        PK_CLASS_array_t merge;          /* merge classes */
        PK_CLASS_array_t split;          /* split classes */
        PK_CLASS_array_t transform;      /* transform classes */
        PK_CLASS_array_t change_attrib;  /* attribute classes */
        PK_CLASS_array_t change;         /* change classes */
        };
    typedef struct PK_BB_sf_s PK_BB_sf_t;



/* PK_VECTOR_make_lsq_plane_o_t */

struct PK_VECTOR_make_lsq_plane_o_s
    {
    int                o_t_version;      /* options structure version */
    };

typedef struct PK_VECTOR_make_lsq_plane_o_s PK_VECTOR_make_lsq_plane_o_t;



/* PK_VECTOR_make_lsq_plane_o_m */

#define PK_VECTOR_make_lsq_plane_o_m(options)                       \
    (                                                              \
       (options).o_t_version      = 1                              \
    )


/* PK_TRANSF_check_o_t */

struct PK_TRANSF_check_o_s
    {
    int        o_t_version;     /* version number of option structure */
    int        max_faults;      /* limit on fault numbers (1) */
    };

typedef struct PK_TRANSF_check_o_s PK_TRANSF_check_o_t;



/* PK_TRANSF_check_o_m */

#define PK_TRANSF_check_o_m(options)  \
    (                                 \
       (options).o_t_version = 1,     \
       (options).max_faults  = 1      \
    )


/* PK_TRANSF_create_view_o_t */

struct PK_TRANSF_create_view_o_s
    {
    int           o_t_version;         /* options structure version */
    PK_LOGICAL_t  have_eye_position;   /* whether a perspective vector exists */
    PK_VECTOR_t   eye_position;        /* perspective eye position */
    };
typedef struct PK_TRANSF_create_view_o_s PK_TRANSF_create_view_o_t;



/* PK_TRANSF_create_view_o_m */

#define PK_TRANSF_create_view_o_m(options)                              \
    (                                                                   \
       (options).o_t_version            = 1,                            \
       (options).have_eye_position      = PK_LOGICAL_false,             \
       (options).eye_position.coord[0]  = 0.0,                          \
       (options).eye_position.coord[1]  = 0.0,                          \
       (options).eye_position.coord[2]  = 0.0                           \
    )


/* PK_TRANSF_classify_o_t */

struct PK_TRANSF_classify_o_s
    {
    int                     o_t_version;  /* version number of option structure */
    PK_TRANSF_diagnostics_t diagnostics;  /* whether to return diagnostics as */
    };

typedef struct PK_TRANSF_classify_o_s PK_TRANSF_classify_o_t;



/* PK_TRANSF_classify_o_m */

#define PK_TRANSF_classify_o_m(options)                         \
    (                                                           \
       (options).o_t_version    = 1,                            \
       (options).diagnostics    = PK_TRANSF_diagnostics_none_c  \
    )


/* PK_TRANSF_classify_r_t */

struct PK_TRANSF_classify_r_s
    {
    PK_matrix_type_t             matrix_type;
    double                       determinant;
    PK_VECTOR_t                  unit_rows_deviations;
    PK_VECTOR_t                  orthog_rows_deviations;
    PK_VECTOR_t                  translation;
    PK_VECTOR_t                  perspective;
    double                       scale;
    };

typedef struct PK_TRANSF_classify_r_s PK_TRANSF_classify_r_t;



/* PK_DELTA_frustrum_t */

typedef PK_ERROR_code_t (*PK_DELTA_open_for_write_f_t)(PK_PMARK_t,
                                                       PK_DELTA_t *);
typedef PK_ERROR_code_t (*PK_DELTA_open_for_read_f_t)(PK_DELTA_t);
typedef PK_ERROR_code_t (*PK_DELTA_close_f_t)(PK_DELTA_t);
typedef PK_ERROR_code_t (*PK_DELTA_write_f_t)(PK_DELTA_t, unsigned int,
                                              const char*);
typedef PK_ERROR_code_t (*PK_DELTA_read_f_t)(PK_DELTA_t, unsigned int, char*);
typedef PK_ERROR_code_t (*PK_DELTA_delete_f_t)(PK_DELTA_t);

struct PK_DELTA_frustrum_s
    {
    PK_DELTA_open_for_write_f_t open_for_write_fn;
    PK_DELTA_open_for_read_f_t open_for_read_fn;
    PK_DELTA_close_f_t  close_fn;     /* close a rollmark */
    PK_DELTA_write_f_t  write_fn;     /* write data to a rollmark */
    PK_DELTA_read_f_t   read_fn;      /* read data from a rollmark */
    PK_DELTA_delete_f_t delete_fn;    /* delete a rollmark */
    };
typedef struct PK_DELTA_frustrum_s PK_DELTA_frustrum_t;




/* PK_FUNCTION_find_o_t */

struct PK_FUNCTION_find_o_s
    {
    int o_t_version;     /* version number of option structure */
    };

typedef struct PK_FUNCTION_find_o_s PK_FUNCTION_find_o_t;



/* PK_FUNCTION_find_o_m */

#define PK_FUNCTION_find_o_m(options)                     \
    (                                                     \
       (options).o_t_version = 1                          \
    )




/*********************************************************************/
/* #DEFINE's */
/*********************************************************************/

/* PK_enclosure_t */

#define   PK_enclosure_inside_c   ((PK_enclosure_t)ENCLIN)
#define   PK_enclosure_outside_c  ((PK_enclosure_t)ENCLOU)
#define   PK_enclosure_on_c       ((PK_enclosure_t)ENCLON)

/* PK_ATTDEF_class_t */

#define   PK_ATTDEF_class_internal_c ((PK_ATTDEF_class_t)RQAC00)
#define   PK_ATTDEF_class_01_c       ((PK_ATTDEF_class_t)RQAC01)
#define   PK_ATTDEF_class_02_c       ((PK_ATTDEF_class_t)RQAC02)
#define   PK_ATTDEF_class_03_c       ((PK_ATTDEF_class_t)RQAC03)
#define   PK_ATTDEF_class_04_c       ((PK_ATTDEF_class_t)RQAC04)
#define   PK_ATTDEF_class_05_c       ((PK_ATTDEF_class_t)RQAC05)
#define   PK_ATTDEF_class_06_c       ((PK_ATTDEF_class_t)RQAC06)
#define   PK_ATTDEF_class_07_c       ((PK_ATTDEF_class_t)RQAC07)

/* PK_ATTRIB_field_t */

#define   PK_ATTRIB_field_integer_c     ((PK_ATTRIB_field_t)RQAPIN)
#define   PK_ATTRIB_field_real_c        ((PK_ATTRIB_field_t)RQAPRL)
#define   PK_ATTRIB_field_string_c      ((PK_ATTRIB_field_t)RQAPCS)
#define   PK_ATTRIB_field_vector_c      ((PK_ATTRIB_field_t)RQAPVC)
#define   PK_ATTRIB_field_coordinate_c  ((PK_ATTRIB_field_t)RQAPCO)
#define   PK_ATTRIB_field_direction_c   ((PK_ATTRIB_field_t)RQAPDR)
#define   PK_ATTRIB_field_axis_c        ((PK_ATTRIB_field_t)RQAPAX)
#define   PK_ATTRIB_field_entity_c      ((PK_ATTRIB_field_t)  5908)
#define   PK_ATTRIB_field_pointer_c     ((PK_ATTRIB_field_t)  5909)
#define   PK_ATTRIB_field_ustring_c     ((PK_ATTRIB_field_t)  5910)

/* PK_boolean_function_t */

#define   PK_boolean_intersect    ((PK_boolean_function_t)BOOPIN)
#define   PK_boolean_subtract     ((PK_boolean_function_t)BOOPSU)
#define   PK_boolean_unite        ((PK_boolean_function_t)BOOPUN)

#define   PK_boolean_intersect_c  ((PK_boolean_function_t)BOOPIN)
#define   PK_boolean_subtract_c   ((PK_boolean_function_t)BOOPSU)
#define   PK_boolean_unite_c      ((PK_boolean_function_t)BOOPUN)

/* PK_boolean_region_t */

#define   PK_boolean_include    ((PK_boolean_region_t)BOOPIC)
#define   PK_boolean_exclude    ((PK_boolean_region_t)BOOPEC)

#define   PK_boolean_include_c          ((PK_boolean_region_t)BOOPIC)
#define   PK_boolean_exclude_c          ((PK_boolean_region_t)BOOPEC)
#define   PK_boolean_mixed_selection_c  ((PK_boolean_region_t)15948)
#define   PK_boolean_off_c              ((PK_boolean_region_t)15949)

/* PK_BODY_type_t */

#define PK_BODY_type_minimum_c     ((PK_BODY_type_t) ENBYMN)
#define PK_BODY_type_acorn_c       ((PK_BODY_type_t) 5606)
#define PK_BODY_type_wire_c        ((PK_BODY_type_t) ENBYWR)
#define PK_BODY_type_sheet_c       ((PK_BODY_type_t) ENBYSH)
#define PK_BODY_type_solid_c       ((PK_BODY_type_t) ENBYSO)
#define PK_BODY_type_general_c     ((PK_BODY_type_t) ENBYGN)
#define PK_BODY_type_unspecified_c ((PK_BODY_type_t) 5607)
#define PK_BODY_type_empty_c       ((PK_BODY_type_t) 5608)
#define PK_BODY_type_compound_c    ((PK_BODY_type_t) 5609)

/* PK_VERTEX_type_t */

#define PK_VERTEX_type_isolated_c   ((PK_VERTEX_type_t) ENVEIS)
#define PK_VERTEX_type_spur_c       ((PK_VERTEX_type_t) ENVESP)
#define PK_VERTEX_type_wire_c       ((PK_VERTEX_type_t) ENVEWR)
#define PK_VERTEX_type_normal_c     ((PK_VERTEX_type_t) ENVENO)

/* PK_LOOP_type_t */

#define PK_LOOP_type_hole_c         ((PK_LOOP_type_t) ENLOHO)
#define PK_LOOP_type_peripheral_c   ((PK_LOOP_type_t) ENLOPE)
#define PK_LOOP_type_other_c        ((PK_LOOP_type_t) ENLONA)

#define PK_LOOP_type_vertex_c       ((PK_LOOP_type_t) 5410)
#define PK_LOOP_type_wire_c         ((PK_LOOP_type_t) 5411)
#define PK_LOOP_type_outer_c        ((PK_LOOP_type_t) 5412)
#define PK_LOOP_type_inner_c        ((PK_LOOP_type_t) 5413)
#define PK_LOOP_type_winding_c      ((PK_LOOP_type_t) 5414)
#define PK_LOOP_type_inner_sing_c   ((PK_LOOP_type_t) 5415)
#define PK_LOOP_type_likely_outer_c ((PK_LOOP_type_t) 5416)
#define PK_LOOP_type_likely_inner_c ((PK_LOOP_type_t) 5417)
#define PK_LOOP_type_unclear_c      ((PK_LOOP_type_t) 5418)
#define PK_LOOP_type_error_c        ((PK_LOOP_type_t) 5419)

/* PK_intersect_vector_t */

#define PK_intersect_vector_simple_c   ((PK_intersect_vector_t) CICLSI)
#define PK_intersect_vector_start_c    ((PK_intersect_vector_t) CICLSC)
#define PK_intersect_vector_end_c      ((PK_intersect_vector_t) CICLEC)
#define PK_intersect_vector_tangent_c  ((PK_intersect_vector_t) CICLTG)

/* PK_intersect_curve_t */

#define PK_intersect_curve_simple_c    ((PK_intersect_curve_t) SICLSI)
#define PK_intersect_curve_tangent_c   ((PK_intersect_curve_t) SICLTG)

/* PK_intersect_fc_t */

#define PK_intersect_fc_simple_c       ((PK_intersect_fc_t) CFCLSI)
#define PK_intersect_fc_tangent_c      ((PK_intersect_fc_t) CFCLTG)
#define PK_intersect_fc_out_in_c       ((PK_intersect_fc_t) CFCLEF)
#define PK_intersect_fc_in_out_c       ((PK_intersect_fc_t) CFCLLF)
#define PK_intersect_fc_out_coi_c      ((PK_intersect_fc_t) CFCLEB)
#define PK_intersect_fc_coi_out_c      ((PK_intersect_fc_t) CFCLLB)
#define PK_intersect_fc_coi_in_c       ((PK_intersect_fc_t) CFCLEI)
#define PK_intersect_fc_in_coi_c       ((PK_intersect_fc_t) CFCLLI)
#define PK_intersect_fc_in_tangent_c   ((PK_intersect_fc_t) CFCLTI)
#define PK_intersect_fc_out_tangent_c  ((PK_intersect_fc_t) CFCLTO)
#define PK_intersect_fc_in_c           ((PK_intersect_fc_t) CFCLUC)
#define PK_intersect_fc_start_c        ((PK_intersect_fc_t) CFCLSC)
#define PK_intersect_fc_end_c          ((PK_intersect_fc_t) CFCLEC)

/* PK_reset_prec_t */

#define PK_reset_prec_ok_c             ((PK_reset_prec_t) RTTLOK)
#define PK_reset_prec_tangent_c        ((PK_reset_prec_t) RTTLNT)
#define PK_reset_prec_missing_geom_c   ((PK_reset_prec_t) RTTLMG)
#define PK_reset_prec_failure_c        ((PK_reset_prec_t) RTTLRF)

/* PK_mass_t */

#define PK_mass_no_c                   ((PK_mass_t) MAOPNA)
#define PK_mass_mass_c                 ((PK_mass_t) MAOPAM)
#define PK_mass_c_of_g_c               ((PK_mass_t) MAOPCG)
#define PK_mass_m_of_i_c               ((PK_mass_t) MAOPIN)

/* PK_mass_periphery_t */

#define PK_mass_periphery_no_c         ((PK_mass_periphery_t) MAOPNP)
#define PK_mass_periphery_yes_c        ((PK_mass_periphery_t) MAOPPE)

/* PK_mass_bound_t */

#define PK_mass_bound_no_c             ((PK_mass_bound_t) MAOPNE)
#define PK_mass_bound_modulus_c        ((PK_mass_bound_t) MAOPEM)
#define PK_mass_bound_interval_c       ((PK_mass_bound_t) MAOPEI)

/* PK_check_state_t */

#define PK_BODY_state_corrupt_c           ((PK_check_state_t) RTSTCR)
#define PK_BODY_state_invalid_ident_c     ((PK_check_state_t) RTSTID)
#define PK_BODY_state_inside_out_c        ((PK_check_state_t) RTSTNG)
#define PK_BODY_state_bad_regions_c       ((PK_check_state_t) RTSTRS)
#define PK_EDGE_state_open_c              ((PK_check_state_t) RTSTOC)
#define PK_EDGE_state_bad_vertex_c        ((PK_check_state_t) RTSTVC)
#define PK_EDGE_state_reversed_c          ((PK_check_state_t) RTSTER)
#define PK_EDGE_state_bad_spcurve_c       ((PK_check_state_t) RTSTSP)
#define PK_EDGE_state_vertices_touch_c    ((PK_check_state_t) RTSTVT)
#define PK_EDGE_state_bad_face_order_c    ((PK_check_state_t) RTSTFO)
#define PK_EDGE_state_bad_wire_ed_ed_c    ((PK_check_state_t) RTSTEE)
#define PK_EDGE_state_open_nmnl_c         ((PK_check_state_t) RTSTON)
#define PK_EDGE_state_bad_vertex_nmnl_c   ((PK_check_state_t) RTSTVN)
#define PK_EDGE_state_bad_sp_nmnl_c       ((PK_check_state_t) RTSTSN)
#define PK_EDGE_state_reversed_nmnl_c     ((PK_check_state_t) RTSTRN)
#define PK_ENTITY_state_invalid_c         ((PK_check_state_t) RTSTIG)
#define PK_FACE_state_bad_vertex_c        ((PK_check_state_t) RTSTVS)
#define PK_FACE_state_bad_edge_c          ((PK_check_state_t) RTSTES)
#define PK_FACE_state_bad_edge_order_c    ((PK_check_state_t) RTSTEO)
#define PK_FACE_state_no_vtx_at_sing_c    ((PK_check_state_t) RTSTMV)
#define PK_FACE_state_bad_loops_c         ((PK_check_state_t) RTSTLC)
#define PK_FACE_state_self_int_c          ((PK_check_state_t) RTSTSX)
#define PK_FACE_state_bad_wire_fa_ed_c    ((PK_check_state_t) RTSTEF)
#define PK_FACE_state_check_fail_c        ((PK_check_state_t) RTSTFC)
#define PK_FACE_state_bad_face_face_c     ((PK_check_state_t) RTSTFF)
#define PK_GEOM_state_self_int_c          ((PK_check_state_t) RTSTGX)
#define PK_GEOM_state_degenerate_c        ((PK_check_state_t) RTSTDG)
#define PK_REGION_state_bad_shells_c      ((PK_check_state_t) RTSTSH)
#define PK_SHELL_state_bad_topol_geom_c   ((PK_check_state_t) RTSTSG)
#define PK_SHELL_state_bad_sh_sh_c        ((PK_check_state_t) RTSTAC)
#define PK_TOPOL_state_not_G1_c           ((PK_check_state_t) RTSTGC)
#define PK_TOPOL_state_size_box_c         ((PK_check_state_t) RTSTBX)
#define PK_TOPOL_state_check_fail_c       ((PK_check_state_t) RTSTCF)
#define PK_TOPOL_state_no_geom_c          ((PK_check_state_t) RTSTMG)
#define PK_BODY_state_ok_c                ((PK_check_state_t) RTTSOK)
#define PK_FACE_state_redundant_c         ((PK_check_state_t) RTTSFR)
#define PK_CURVE_state_inconsistent_c     ((PK_check_state_t) RTTSCI)
#define PK_LOOP_state_invalid_c           ((PK_check_state_t) RTTSLI)
#define PK_EDGE_state_bad_order_c         ((PK_check_state_t) RTTSEO)
#define PK_ATTDEF_state_bad_name_c        ((PK_check_state_t) RTSTAN)
#define PK_ATTRIB_state_bad_string_c      ((PK_check_state_t) RTSTAS)
#define PK_ATTRIB_state_invalid_att_c     ((PK_check_state_t) RTSTAT)
#define PK_ATTRIB_state_bad_data_len_c    ((PK_check_state_t) RTSTDL)
#define PK_ATTRIB_state_bad_ustring_c     ((PK_check_state_t) RTSTBU)
#define PK_ATTRIB_state_byte_oor_c        ((PK_check_state_t) RTSTBB)
#define PK_ATTRIB_state_empty_field_c     ((PK_check_state_t) RTSTEM)
#define PK_ATTRIB_state_int_oor_c         ((PK_check_state_t) RTSTBI)
#define PK_ATTRIB_state_non_unit_vec_c    ((PK_check_state_t) RTSTNU)
#define PK_ATTRIB_state_real_oor_c        ((PK_check_state_t) RTSTBR)
#define PK_ATTRIB_state_short_oor_c       ((PK_check_state_t) RTSTSB)
#define PK_ATTRIB_state_p_vector_oor_c    ((PK_check_state_t) RTSTPV)

/* PK_FACE_trim_confine_t */

#define PK_FACE_trim_confine_no_c         ((PK_FACE_trim_confine_t) SROPCN)
#define PK_FACE_trim_confine_yes_c        ((PK_FACE_trim_confine_t) SROPCY)
#define PK_FACE_trim_confine_closed_c     ((PK_FACE_trim_confine_t) SROPCC)
#define PK_FACE_trim_confine_periph_c     ((PK_FACE_trim_confine_t) SROPCP)

/* PK_FACE_trim_degen_t */

#define PK_FACE_trim_degen_no_c           ((PK_FACE_trim_degen_t) SROPED)
#define PK_FACE_trim_degen_yes_c          ((PK_FACE_trim_degen_t) SROPID)

/* PK_BB_status_t */

#define PK_BB_status_off_c        ((PK_BB_status_t) BBOPOF)
#define PK_BB_status_on_c         ((PK_BB_status_t) BBOPON)
#define PK_BB_status_user_field_c ((PK_BB_status_t) BBOPUF)

/* PK_BB_event_t */

#define PK_BB_event_create_c        ((PK_BB_event_t) BBEVCR)
#define PK_BB_event_delete_c        ((PK_BB_event_t) BBEVDE)
#define PK_BB_event_copy_c          ((PK_BB_event_t) BBEVCO)
#define PK_BB_event_transfer_c      ((PK_BB_event_t) BBEVTR)
#define PK_BB_event_merge_c         ((PK_BB_event_t) BBEVME)
#define PK_BB_event_split_c         ((PK_BB_event_t) BBEVSP)
#define PK_BB_event_transform_c     ((PK_BB_event_t) BBEVTF)
#define PK_BB_event_change_attrib_c ((PK_BB_event_t) BBEVAC)
#define PK_BB_event_change_c        ((PK_BB_event_t) BBEVCH)

/* PK_blend_trim_t */

#define PK_blend_trim_no_c          ((PK_blend_trim_t) FXFTNT)
#define PK_blend_trim_short_c       ((PK_blend_trim_t) FXFTST)
#define PK_blend_trim_long_c        ((PK_blend_trim_t) FXFTLT)
#define PK_blend_trim_to_walls_c    ((PK_blend_trim_t) FXFTTB)

/* PK_fxf_fault_t */

#define PK_fxf_fault_no_fault_c         ((PK_fxf_fault_t) FXFEOK)
#define PK_fxf_fault_sheet_c            ((PK_fxf_fault_t) FXFEST)
#define PK_fxf_fault_unknown_c          ((PK_fxf_fault_t) FXFEER)
#define PK_fxf_fault_insufficient_c     ((PK_fxf_fault_t) FXFEID)
#define PK_fxf_fault_inconsistent_c     ((PK_fxf_fault_t) FXFEXD)
#define PK_fxf_fault_wall_c             ((PK_fxf_fault_t) FXFEIF)
#define PK_fxf_fault_range_c            ((PK_fxf_fault_t) FXFEIR)
#define PK_fxf_fault_cliff_c            ((PK_fxf_fault_t) FXFEIC)
#define PK_fxf_fault_thl_c              ((PK_fxf_fault_t) FXFEIH)
#define PK_fxf_fault_chl_c              ((PK_fxf_fault_t) FXFECL)
#define PK_fxf_fault_curved_c           ((PK_fxf_fault_t) FXFEFC)
#define PK_fxf_fault_small_c            ((PK_fxf_fault_t) FXFERS)
#define PK_fxf_fault_large_c            ((PK_fxf_fault_t) FXFERL)
#define PK_fxf_fault_left_c             ((PK_fxf_fault_t) FXFELN)
#define PK_fxf_fault_right_c            ((PK_fxf_fault_t) FXFERN)
#define PK_fxf_fault_both_c             ((PK_fxf_fault_t) FXFEBN)
#define PK_fxf_fault_sheet_clash_c      ((PK_fxf_fault_t) FXFESC)
#define PK_fxf_fault_wall_clash_c       ((PK_fxf_fault_t) FXFEWC)
#define PK_fxf_fault_face_face_c        ((PK_fxf_fault_t) FXFEFF)
#define PK_fxf_fault_self_int_c         ((PK_fxf_fault_t) FXFEGX)
#define PK_fxf_fault_rho_value_c        ((PK_fxf_fault_t) FXFERV)
#define PK_fxf_fault_asymmetric_c       ((PK_fxf_fault_t) FXFEAR)
#define PK_fxf_fault_bad_spine_c        ((PK_fxf_fault_t) FXFEIS)
#define PK_fxf_fault_bad_ribs_c         ((PK_fxf_fault_t) 17474)
#define PK_fxf_fault_repaired_c         ((PK_fxf_fault_t) 17475)
#define PK_fxf_fault_plane_origin_c     ((PK_fxf_fault_t) 17476)
#define PK_fxf_fault_plane_insuff_c     ((PK_fxf_fault_t) 17477)
#define PK_fxf_fault_preview_rib_c      ((PK_fxf_fault_t) 17478)
#define PK_fxf_fault_rho_too_large_c    ((PK_fxf_fault_t) 17479)

/* PK_BODY_fault_t */

#define PK_BODY_fault_no_fault_c        ((PK_BODY_fault_t) RTTOOK)
#define PK_BODY_fault_bad_body_c        ((PK_BODY_fault_t) RTTOBB)
#define PK_BODY_fault_unknown_c         ((PK_BODY_fault_t) RTTODE)
#define PK_BODY_fault_unknown_child_c   ((PK_BODY_fault_t) RTTOUC)
#define PK_BODY_fault_duplicate_child_c ((PK_BODY_fault_t) RTTODC)
#define PK_BODY_fault_wrong_child_c     ((PK_BODY_fault_t) RTTOWC)
#define PK_BODY_fault_missing_child_c   ((PK_BODY_fault_t) RTTOFC)
#define PK_BODY_fault_extra_child_c     ((PK_BODY_fault_t) RTTOMC)
#define PK_BODY_fault_wrong_parent_c    ((PK_BODY_fault_t) RTTOWP)
#define PK_BODY_fault_missing_parent_c  ((PK_BODY_fault_t) RTTOFP)
#define PK_BODY_fault_extra_parent_c    ((PK_BODY_fault_t) RTTOMP)
#define PK_BODY_fault_bad_wire_c        ((PK_BODY_fault_t) RTTODW)
#define PK_BODY_fault_bad_loop_c        ((PK_BODY_fault_t) RTTOIL)
#define PK_BODY_fault_bad_shells_c      ((PK_BODY_fault_t) RTTOCS)
#define PK_BODY_fault_disjoint_shell_c  ((PK_BODY_fault_t) RTTODS)
#define PK_BODY_fault_non_manifold_c    ((PK_BODY_fault_t) RTTONM)
#define PK_BODY_fault_bad_region_c      ((PK_BODY_fault_t) 15117 )
#define PK_BODY_fault_bad_fa_sh_rg_c    ((PK_BODY_fault_t) 15118 )
#define PK_BODY_fault_empty_region_c    ((PK_BODY_fault_t) 15119 )

/* PK_abort_reason_t */

#define PK_abort_user_interrupt_c     ((PK_abort_reason_t) SLABUI)
#define PK_abort_runtime_error_c      ((PK_abort_reason_t) SLABRE)
#define PK_abort_frustrum_error_c     ((PK_abort_reason_t) SLABFE)

/* PK_BODY_knit_status_t */

#define PK_BODY_knit_completed_c      ((PK_BODY_knit_status_t) RTKNOK)
#define PK_BODY_knit_not_completed_c  ((PK_BODY_knit_status_t) RTKNIN)

/* PK_SHELL_type_t */

#define PK_SHELL_type_acorn_c           ((PK_SHELL_type_t) 3500)
#define PK_SHELL_type_wireframe_c       ((PK_SHELL_type_t) 3501)
#define PK_SHELL_type_wireframe_free_c  ((PK_SHELL_type_t) 3502)
#define PK_SHELL_type_mixed_c           ((PK_SHELL_type_t) 3503)

/* PK_SHELL_sign_t */

#define PK_SHELL_sign_positive_c  ((PK_SHELL_sign_t) 3550)
#define PK_SHELL_sign_negative_c  ((PK_SHELL_sign_t) 3551)
#define PK_SHELL_sign_open_c      ((PK_SHELL_sign_t) 3552)

/* PK_FIN_type_t */

#define PK_FIN_type_wire_c    ((PK_FIN_type_t) 3600)
#define PK_FIN_type_biwire_c  ((PK_FIN_type_t) 3601)
#define PK_FIN_type_normal_c  ((PK_FIN_type_t) 3602)

/* PK_EDGE_vertex_type_t */

#define PK_EDGE_type_open_c    ((PK_EDGE_vertex_type_t) 3650)
#define PK_EDGE_type_closed_c  ((PK_EDGE_vertex_type_t) 3651)
#define PK_EDGE_type_ring_c    ((PK_EDGE_vertex_type_t) 3652)

/* PK_EDGE_fins_type_t */

#define PK_EDGE_type_wireframe_c  ((PK_EDGE_fins_type_t) 3700)
#define PK_EDGE_type_laminar_c    ((PK_EDGE_fins_type_t) 3701)
#define PK_EDGE_type_normal_c     ((PK_EDGE_fins_type_t) 3702)
#define PK_EDGE_type_general_c    ((PK_EDGE_fins_type_t) 3703)

/* PK_neutral_error_t */

#define PK_neutral_success_c            ((PK_neutral_error_t) 3800)
#define PK_neutral_illegal_input_c      ((PK_neutral_error_t) 3801)
#define PK_neutral_numerical_failure_c  ((PK_neutral_error_t) 3802)
#define PK_neutral_unknown_config_c     ((PK_neutral_error_t) 3803)
#define PK_neutral_imprint_failure_c    ((PK_neutral_error_t) 3804)
#define PK_neutral_extend_failure_c     ((PK_neutral_error_t) 3805)
#define PK_neutral_fill_hole_failure_c  ((PK_neutral_error_t) 3806)

/* PK_knot_type_t (8500-8549) */

#define PK_knot_unset_c            ((PK_knot_type_t) 8500)
#define PK_knot_non_uniform_c      ((PK_knot_type_t) 8501)
#define PK_knot_uniform_c          ((PK_knot_type_t) 8502)
#define PK_knot_quasi_uniform_c    ((PK_knot_type_t) 8503)
#define PK_knot_piecewise_bezier_c ((PK_knot_type_t) 8504)
#define PK_knot_bezier_ends_c      ((PK_knot_type_t) 8505)
#define PK_knot_smooth_seam_c      ((PK_knot_type_t) 8506)

/* PK_self_intersect_t (8550-8599) */

#define PK_self_intersect_unset_c ((PK_self_intersect_t) 8550)
#define PK_self_intersect_false_c ((PK_self_intersect_t) 8551)
#define PK_self_intersect_true_c  ((PK_self_intersect_t) 8552)

/* PK_convexity_t (8600-8649) */

#define PK_convexity_unset_c     ((PK_convexity_t) 8600)
#define PK_convexity_arbitrary_c ((PK_convexity_t) 8601)
#define PK_convexity_convex_c    ((PK_convexity_t) 8602)
#define PK_convexity_concave_c   ((PK_convexity_t) 8603)

/* PK_BCURVE_form_t (8650-8699) */

#define PK_BCURVE_form_unset_c      ((PK_BCURVE_form_t) 8650)
#define PK_BCURVE_form_arbitrary_c  ((PK_BCURVE_form_t) 8651)
#define PK_BCURVE_form_polyline_c   ((PK_BCURVE_form_t) 8652)
#define PK_BCURVE_form_circular_c   ((PK_BCURVE_form_t) 8653)
#define PK_BCURVE_form_elliptic_c   ((PK_BCURVE_form_t) 8654)
#define PK_BCURVE_form_parabolic_c  ((PK_BCURVE_form_t) 8655)
#define PK_BCURVE_form_hyperbolic_c ((PK_BCURVE_form_t) 8656)

/* PK_BSURF_form_t (8700-8749) */

#define PK_BSURF_form_unset_c       ((PK_BSURF_form_t) 8700)
#define PK_BSURF_form_arbitrary_c   ((PK_BSURF_form_t) 8701)
#define PK_BSURF_form_planar_c      ((PK_BSURF_form_t) 8702)
#define PK_BSURF_form_cylindrical_c ((PK_BSURF_form_t) 8703)
#define PK_BSURF_form_conical_c     ((PK_BSURF_form_t) 8704)
#define PK_BSURF_form_spherical_c   ((PK_BSURF_form_t) 8705)
#define PK_BSURF_form_toroidal_c    ((PK_BSURF_form_t) 8706)
#define PK_BSURF_form_revolved_c    ((PK_BSURF_form_t) 8707)
#define PK_BSURF_form_ruled_c       ((PK_BSURF_form_t) 8708)
#define PK_BSURF_form_gen_cone_c    ((PK_BSURF_form_t) 8709)
#define PK_BSURF_form_quadric_c     ((PK_BSURF_form_t) 8710)
#define PK_BSURF_form_swept_c       ((PK_BSURF_form_t) 8711)

/* PK_HAND_t */

#define PK_HAND_left_c                  ((PK_HAND_t) 32760)
#define PK_HAND_right_c                 ((PK_HAND_t) 32761)

/* PK_PARAM_bound_t    (18000-18019) */

#define PK_PARAM_bound_infinite_c                  ((PK_PARAM_bound_t) 18000)
#define PK_PARAM_bound_extendable_c                ((PK_PARAM_bound_t) 18001)
#define PK_PARAM_bound_bound_c                     ((PK_PARAM_bound_t) 18002)
#define PK_PARAM_bound_closed_c                    ((PK_PARAM_bound_t) 18003)
#define PK_PARAM_bound_degenerate_c                ((PK_PARAM_bound_t) 18004)

/* PK_PARAM_periodic_t (18020-18039) */

#define PK_PARAM_periodic_no_c                 ((PK_PARAM_periodic_t) 18020)
#define PK_PARAM_periodic_yes_c                ((PK_PARAM_periodic_t) 18021)
#define PK_PARAM_periodic_seamed_c             ((PK_PARAM_periodic_t) 18022)

/* PK_PARAM_form_t     (18040-18059) */

#define PK_PARAM_form_linear_c                  ((PK_PARAM_form_t) 18040)
#define PK_PARAM_form_circular_c                ((PK_PARAM_form_t) 18041)
#define PK_PARAM_form_any_c                     ((PK_PARAM_form_t) 18042)

/* PK_BODY_sewing_problem_t (18060-18069) */

#define PK_BODY_sewing_overlapping_c  (( PK_BODY_sewing_problem_t ) 18060)
#define PK_BODY_sewing_non_manifold_c (( PK_BODY_sewing_problem_t ) 18061)
#define PK_BODY_sewing_non_oriented_c (( PK_BODY_sewing_problem_t ) 18062)
#define PK_BODY_sewing_unspecified_c  (( PK_BODY_sewing_problem_t ) 18063)

/* PK_BODY_sewing_type_t    (18070-18075) */

#define PK_BODY_sewing_solid_c        (( PK_BODY_sewing_type_t ) 18070)
#define PK_BODY_sewing_sheet_c        (( PK_BODY_sewing_type_t ) 18071)
#define PK_BODY_sewing_general_c      (( PK_BODY_sewing_type_t ) 18072)
#define PK_BODY_sewing_any_c          (( PK_BODY_sewing_type_t ) 18073)

/* PK_BODY_sewing_removal_t (18076-18079) */

#define PK_BODY_sewing_remove_none_c   (( PK_BODY_sewing_removal_t ) 18076)
#define PK_BODY_sewing_remove_poss_c   (( PK_BODY_sewing_removal_t ) 18077)
#define PK_BODY_sewing_remove_cert_c   (( PK_BODY_sewing_removal_t ) 18078)

/* PK_FACE_heal_t (18080-18099) */

#define PK_FACE_heal_no_c               (( PK_FACE_heal_t ) 18080)
#define PK_FACE_heal_cap_c              (( PK_FACE_heal_t ) 18081)
#define PK_FACE_heal_grow_from_child_c  (( PK_FACE_heal_t ) 18082)
#define PK_FACE_heal_grow_from_parent_c (( PK_FACE_heal_t ) 18083)
#define PK_FACE_heal_shrink_c           (( PK_FACE_heal_t ) 18084)
#define PK_FACE_heal_yes_c              (( PK_FACE_heal_t ) 18085)

/* PK_local_check_t (18100-18119) */

#define PK_local_check_no_c      (( PK_local_check_t ) 18100)
#define PK_local_check_ok_c      (( PK_local_check_t ) 18101)
#define PK_local_check_negated_c (( PK_local_check_t ) 18102)
#define PK_local_check_failed_c  (( PK_local_check_t ) 18103)

/* PK_section_fence_t */

#define PK_section_fence_front_c        ((PK_section_fence_t) 18200)
#define PK_section_fence_back_c         ((PK_section_fence_t) 18201)
#define PK_section_fence_both_c         ((PK_section_fence_t) 18202)

/* PK_boolean_fence_t */

#define PK_boolean_fence_front_c        ((PK_boolean_fence_t) 18210)
#define PK_boolean_fence_back_c         ((PK_boolean_fence_t) 18211)
#define PK_boolean_fence_none_c         ((PK_boolean_fence_t) 18212)

/* PK_transmit_format_t */

#define PK_transmit_format_text_c           ((PK_transmit_format_t) 18220)
#define PK_transmit_format_binary_c         ((PK_transmit_format_t) 18221)
#define PK_transmit_format_neutral_c        ((PK_transmit_format_t) 18222)
#define PK_transmit_format_applio_c         ((PK_transmit_format_t) 18223)
#define PK_transmit_format_xml_c            ((PK_transmit_format_t) 18224)
#define PK_transmit_format_typed_binary_c   ((PK_transmit_format_t) 18225)
#define PK_transmit_format_indexio_c        ((PK_transmit_format_t) 18226)

/* PK_PARTITION_xmt_deltas_t */

#define PK_PARTITION_xmt_deltas_none_c   ((PK_PARTITION_xmt_deltas_t) 18230)
#define PK_PARTITION_xmt_deltas_all_c    ((PK_PARTITION_xmt_deltas_t) 18231)
#define PK_PARTITION_xmt_deltas_main_c   ((PK_PARTITION_xmt_deltas_t) 18232)
#define PK_PARTITION_xmt_deltas_later_c  ((PK_PARTITION_xmt_deltas_t) 18233)

/* PK_PARTITION_rcv_deltas_t */

#define PK_PARTITION_rcv_deltas_no_c     ((PK_PARTITION_rcv_deltas_t) 18240)
#define PK_PARTITION_rcv_deltas_later_c  ((PK_PARTITION_rcv_deltas_t) 18241)
#define PK_PARTITION_rcv_deltas_yes_c    ((PK_PARTITION_rcv_deltas_t) 18242)

/* PK_boolean_match_t */

#define PK_boolean_match_exact_c        ((PK_boolean_match_t) 18250)
#define PK_boolean_match_contains_c     ((PK_boolean_match_t) 18251)
#define PK_boolean_match_overlap_c      ((PK_boolean_match_t) 18252)
#define PK_boolean_match_imprinted_c    ((PK_boolean_match_t) 18253)

/* PK_range_guess_type_t */

#define PK_range_guess_no_c             ((PK_range_guess_type_t) 18260)
#define PK_range_guess_param_c          ((PK_range_guess_type_t) 18261)
#define PK_range_guess_vector_c         ((PK_range_guess_type_t) 18262)

/* PK_range_result_t */

#define PK_range_result_found_c         ((PK_range_result_t) 18270)
#define PK_range_result_lower_c         ((PK_range_result_t) 18271)
#define PK_range_result_upper_c         ((PK_range_result_t) 18272)
#define PK_range_result_not_found_c     ((PK_range_result_t) 18273)

/* PK_check_geom_t */

#define PK_check_geom_no_c              ((PK_check_geom_t) 18280)
#define PK_check_geom_basic_c           ((PK_check_geom_t) 18281)
#define PK_check_geom_lazy_c            ((PK_check_geom_t) 18282)
#define PK_check_geom_full_c            ((PK_check_geom_t) 18283)
#define PK_check_geom_yes_c             ((PK_check_geom_t) 18284)

/* PK_check_bgeom_t */

#define PK_check_bgeom_no_c             ((PK_check_bgeom_t) 18290)
#define PK_check_bgeom_yes_c            ((PK_check_bgeom_t) 18291)

/* PK_check_top_geo_t */

#define PK_check_top_geo_no_c           ((PK_check_top_geo_t) 18300)
#define PK_check_top_geo_edge_c         ((PK_check_top_geo_t) 18301)
#define PK_check_top_geo_face_c         ((PK_check_top_geo_t) 18302)
#define PK_check_top_geo_yes_c          ((PK_check_top_geo_t) 18303)

/* PK_check_size_box_t */

#define PK_check_size_box_no_c           ((PK_check_size_box_t) 18310)
#define PK_check_size_box_yes_c          ((PK_check_size_box_t) 18311)

/* PK_check_fa_X_t */

#define PK_check_fa_X_no_c           ((PK_check_fa_X_t) 18320)
#define PK_check_fa_X_yes_c          ((PK_check_fa_X_t) 18321)

/* PK_check_loops_t */

#define PK_check_loops_no_c           ((PK_check_loops_t) 18330)
#define PK_check_loops_yes_c          ((PK_check_loops_t) 18331)

/* PK_check_fa_fa_t */

#define PK_check_fa_fa_no_c           ((PK_check_fa_fa_t) 18340)
#define PK_check_fa_fa_yes_c          ((PK_check_fa_fa_t) 18341)

/* PK_check_sh_t */

#define PK_check_sh_no_c           ((PK_check_sh_t) 18350)
#define PK_check_sh_yes_c          ((PK_check_sh_t) 18351)

/* PK_check_corrupt_t */

#define PK_check_corrupt_no_c           ((PK_check_corrupt_t) 18360)
#define PK_check_corrupt_yes_c          ((PK_check_corrupt_t) 18361)

/* PK_FACE_trim_surf_t */

#define PK_FACE_trim_surf_own_c         ((PK_FACE_trim_surf_t) 18370)
#define PK_FACE_trim_surf_bsurf_c       ((PK_FACE_trim_surf_t) SROPBS)

/* PK_blend_check_t */

#define PK_blend_check_vertex_c         ((PK_blend_check_t) 18380)
#define PK_blend_check_full_c           ((PK_blend_check_t) 18381)

/* PK_blend_fault_t */

#define PK_blend_fault_no_blend_c       ((PK_blend_fault_t) 18390)
#define PK_blend_fault_no_fault_c       ((PK_blend_fault_t) 18391)
#define PK_blend_fault_self_int_c       ((PK_blend_fault_t) 18392)
#define PK_blend_fault_face_face_c      ((PK_blend_fault_t) 18393)
#define PK_blend_fault_conic_c          ((PK_blend_fault_t) 18394)
#define PK_blend_fault_repaired_c       ((PK_blend_fault_t) 18395)
#define PK_blend_fault_bad_cap_c        ((PK_blend_fault_t) 18396)
#define PK_blend_fault_rho_too_large_c  ((PK_blend_fault_t) 18397)
#define PK_blend_fault_tangent_c        ((PK_blend_fault_t) BLCCTN)
#define PK_blend_fault_singularity_c    ((PK_blend_fault_t) BLCCSN)
#define PK_blend_fault_obsolete_c       ((PK_blend_fault_t) BLCCOT)
#define PK_blend_fault_vertex_c         ((PK_blend_fault_t) BLCCMX)
#define PK_blend_fault_sheet_c          ((PK_blend_fault_t) BLCCRS)
#define PK_blend_fault_general_c        ((PK_blend_fault_t) BLCCRE)
#define PK_blend_fault_2_edge_c         ((PK_blend_fault_t) BLCCTV)
#define PK_blend_fault_chamfer_c        ((PK_blend_fault_t) BLCCHM)
#define PK_blend_fault_bsurf_c          ((PK_blend_fault_t) BLCCXT)
#define PK_blend_fault_range_c          ((PK_blend_fault_t) BLCCIR)
#define PK_blend_fault_type_c           ((PK_blend_fault_t) BLCCIT)
#define PK_blend_fault_edge_c           ((PK_blend_fault_t) BLCCAB)
#define PK_blend_fault_loop_c           ((PK_blend_fault_t) BLCCOL)
#define PK_blend_fault_overlap_c        ((PK_blend_fault_t) BLCCOB)
#define PK_blend_fault_overlap_edge_c   ((PK_blend_fault_t) BLCCOU)
#define PK_blend_fault_bad_end_c        ((PK_blend_fault_t) BLCCUE)
#define PK_blend_fault_face_c           ((PK_blend_fault_t) BLCCRL)
#define PK_blend_fault_overlap_end_c    ((PK_blend_fault_t) BLCCOE)
#define PK_blend_fault_end_c            ((PK_blend_fault_t) BLCCIE)
#define PK_blend_fault_chamfer_intsec_c ((PK_blend_fault_t) BLCCIX)
#define PK_blend_fault_edge_intsec_c    ((PK_blend_fault_t) BLCCEX)
#define PK_blend_fault_other_edge_c     ((PK_blend_fault_t) BLCCOI)
#define PK_blend_fault_cliffedge_c      ((PK_blend_fault_t) BLCCIP)
#define PK_blend_fault_unknown_c        ((PK_blend_fault_t) BLCCUN)
#define PK_blend_fault_g2_with_cliff_c  ((PK_blend_fault_t) 18398)
#define PK_blend_fault_g2_vx_blend_c    ((PK_blend_fault_t) 18399)

/* PK_blend_type_t */

#define PK_blend_type_no_c              ((PK_blend_type_t) 18400)
#define PK_blend_type_ball_constant_c   ((PK_blend_type_t) 18401)
#define PK_blend_type_ball_variable_c   ((PK_blend_type_t) 18402)
#define PK_blend_type_chamfer_c         ((PK_blend_type_t) 18403)

/* PK_blend_propagate_t */

#define PK_blend_propagate_no_c              ((PK_blend_propagate_t) 18410)
#define PK_blend_propagate_yes_c             ((PK_blend_propagate_t) 18411)

/* PK_blend_vary_t */

#define PK_blend_vary_smooth_c               ((PK_blend_vary_t) 18420)
#define PK_blend_vary_linear_c               ((PK_blend_vary_t) 18421)

/* PK_blend_render_rib_t */

#define PK_blend_render_rib_no_c             ((PK_blend_render_rib_t) 18430)
#define PK_blend_render_rib_yes_c            ((PK_blend_render_rib_t) 18431)

/* PK_blend_ov_smooth_t */

#define PK_blend_ov_smooth_no_c              ((PK_blend_ov_smooth_t) 18440)
#define PK_blend_ov_smooth_diff_c            ((PK_blend_ov_smooth_t) 18441)
#define PK_blend_ov_smooth_any_c             ((PK_blend_ov_smooth_t) 18442)

/* PK_blend_ov_cliff_t */

#define PK_blend_ov_cliff_no_c               ((PK_blend_ov_cliff_t) 18450)
#define PK_blend_ov_cliff_diff_c             ((PK_blend_ov_cliff_t) 18451)
#define PK_blend_ov_cliff_any_c              ((PK_blend_ov_cliff_t) 18452)

/* PK_blend_ov_cliff_end_t */

#define PK_blend_ov_cliff_end_no_c           ((PK_blend_ov_cliff_end_t) 18460)
#define PK_blend_ov_cliff_end_yes_c          ((PK_blend_ov_cliff_end_t) 18461)

/* PK_blend_ov_notch_t */

#define PK_blend_ov_notch_no_c               ((PK_blend_ov_notch_t) 18470)
#define PK_blend_ov_notch_yes_c              ((PK_blend_ov_notch_t) 18471)

/* PK_blend_walls_t */

#define PK_blend_walls_trim_no_c             ((PK_blend_walls_t) 18480)
#define PK_blend_walls_trim_both_c           ((PK_blend_walls_t) FXFTTW)
#define PK_blend_walls_attach_c              ((PK_blend_walls_t) FXFTAT)
#define PK_blend_walls_solid_c               ((PK_blend_walls_t) FXFTSO)

/* PK_blend_cs_t */

#define PK_blend_cs_rolling_ball_c       ((PK_blend_cs_t) 18490)
#define PK_blend_cs_disc_c               ((PK_blend_cs_t) 18491)
#define PK_blend_cs_isoparameter_c       ((PK_blend_cs_t) 18492)

/* PK_blend_xs_plane_t */

#define PK_blend_xs_rolling_ball_c       ((PK_blend_xs_plane_t) 18490)
#define PK_blend_xs_disc_c               ((PK_blend_xs_plane_t) 18491)
#define PK_blend_xs_isoparameter_c       ((PK_blend_xs_plane_t) 18492)

/* PK_piecewise_rep_t */

#define PK_piecewise_rep_bezier_c        ((PK_piecewise_rep_t) 18500)
#define PK_piecewise_rep_polynomial_c    ((PK_piecewise_rep_t) 18501)
#define PK_piecewise_rep_hermite_c       ((PK_piecewise_rep_t) 18502)
#define PK_piecewise_rep_taylor_c        ((PK_piecewise_rep_t) 18503)

/* PK_PARAM_end_t */

#define PK_PARAM_end_periodic_c          ((PK_PARAM_end_t) 18510)
#define PK_PARAM_end_natural_c           ((PK_PARAM_end_t) 18511)
#define PK_PARAM_end_clamped_vector_c    ((PK_PARAM_end_t) 18512)
#define PK_PARAM_end_clamped_bcurve_c    ((PK_PARAM_end_t) 18513)

/* PK_PARAM_knot_t */

#define PK_PARAM_knot_auto_c             ((PK_PARAM_knot_t) 18520)
#define PK_PARAM_knot_defined_c          ((PK_PARAM_knot_t) 18521)

/* PK_PARAM_twist_t */

#define PK_PARAM_twist_no_c              ((PK_PARAM_twist_t) 18530)
#define PK_PARAM_twist_yes_c             ((PK_PARAM_twist_t) 18531)

/* PK_TOPOL_sense_t */

#define PK_TOPOL_sense_none_c            ((PK_TOPOL_sense_t) 18540)
#define PK_TOPOL_sense_negative_c        ((PK_TOPOL_sense_t) 18541)
#define PK_TOPOL_sense_positive_c        ((PK_TOPOL_sense_t) 18542)

/* PK_PARAM_degen_t */

#define PK_PARAM_degen_no_c              ((PK_PARAM_degen_t) 18550)
#define PK_PARAM_degen_vector_c          ((PK_PARAM_degen_t) 18551)
#define PK_PARAM_degen_bcurve_c          ((PK_PARAM_degen_t) 18552)

/* PK_render_edge_t         (20100-20101 allocated) */

#define PK_render_edge_no_c             ((PK_render_edge_t) 20100)
#define PK_render_edge_yes_c            ((PK_render_edge_t) 20101)

/* PK_render_silhouette_t   (20120-20121) allocated */

#define PK_render_silhouette_no_c       ((PK_render_silhouette_t) 20120)
#define PK_render_silhouette_arcs_c     ((PK_render_silhouette_t) 20121)
#define PK_render_silhouette_yes_c      ((PK_render_silhouette_t) 20122)

/* PK_render_planar_t       (20140-20143 allocated) */

#define PK_render_planar_no_c           ((PK_render_planar_t) 20140)
#define PK_render_planar_attrib_c       ((PK_render_planar_t) 20141)
#define PK_render_planar_free_c         ((PK_render_planar_t) 20142)
#define PK_render_planar_yes_c          ((PK_render_planar_t) 20143)

/* PK_render_radial_t       (20160-20162) allocated */

#define PK_render_radial_no_c           ((PK_render_radial_t) 20160)
#define PK_render_radial_attrib_c       ((PK_render_radial_t) 20161)
#define PK_render_radial_yes_c          ((PK_render_radial_t) 20162)
#define PK_render_radial_free_c         ((PK_render_radial_t) 20163)

/* PK_render_param_t        (20180-20182) allocated */

#define PK_render_param_no_c            ((PK_render_param_t) 20180)
#define PK_render_param_attrib_c        ((PK_render_param_t) 20181)
#define PK_render_param_yes_c           ((PK_render_param_t) 20182)
#define PK_render_param_free_c          ((PK_render_param_t) 20183)

/* PK_render_unfix_t        (20200-20202) allocated */

#define PK_render_unfix_no_c            ((PK_render_unfix_t) 20200)
#define PK_render_unfix_attrib_c        ((PK_render_unfix_t) 20201)
#define PK_render_unfix_yes_c           ((PK_render_unfix_t) 20202)

/* PK_render_boundary_t     (20220-20221) allocated */

#define PK_render_boundary_no_c         ((PK_render_boundary_t) 20220)
#define PK_render_boundary_yes_c        ((PK_render_boundary_t) 20221)

/* PK_render_transparent_t  (20240-20242 allocated) */

#define PK_render_transparent_no_c      ((PK_render_transparent_t) 20240)
#define PK_render_transparent_yes_c     ((PK_render_transparent_t) 20241)
#define PK_render_transparent_index_c   ((PK_render_transparent_t) 20242)

/* PK_render_transp_hid_t   (20243-20244 allocated) */

#define PK_render_transp_hid_no_c       ((PK_render_transp_hid_t) 20243)
#define PK_render_transp_hid_yes_c      ((PK_render_transp_hid_t) 20244)

/* PK_render_vis_t          (20300-20305) allocated */

#define PK_render_vis_no_c              ((PK_render_vis_t) 20300)
#define PK_render_vis_hid_c             ((PK_render_vis_t) 20301)
#define PK_render_vis_inv_c             ((PK_render_vis_t) 20302)
#define PK_render_vis_hid_draft_c       ((PK_render_vis_t) 20303)
#define PK_render_vis_inv_draft_c       ((PK_render_vis_t) 20304)
#define PK_render_vis_extended_c        ((PK_render_vis_t) 20305)

/* PK_render_smooth_t       (20320-20322) allocated */

#define PK_render_smooth_no_c           ((PK_render_smooth_t) 20320)
#define PK_render_smooth_yes_c          ((PK_render_smooth_t) 20321)
#define PK_render_smooth_draft_c        ((PK_render_smooth_t) 20322)

/* PK_render_internal_t     (20340-20341) allocated */

#define PK_render_internal_no_c         ((PK_render_internal_t) 20340)
#define PK_render_internal_yes_c        ((PK_render_internal_t) 20341)

/* PK_render_region_t       (20360-20362) allocated */

#define PK_render_region_no_c           ((PK_render_region_t) 20360)
#define PK_render_region_attrib_c       ((PK_render_region_t) 20361)
#define PK_render_region_yes_c          ((PK_render_region_t) 20362)

/* PK_render_hierarch_t     (20380-20383) allocated */

#define PK_render_hierarch_no_c         ((PK_render_hierarch_t) 20380)
#define PK_render_hierarch_no_geom_c    ((PK_render_hierarch_t) 20381)
#define PK_render_hierarch_yes_c        ((PK_render_hierarch_t) 20382)
#define PK_render_hierarch_param_c      ((PK_render_hierarch_t) 20383)

/* PK_render_bcurve_t       (20400-20402) allocated */

#define PK_render_bcurve_polyline_c     ((PK_render_bcurve_t) 20400)
#define PK_render_bcurve_bezier_c       ((PK_render_bcurve_t) 20401)
#define PK_render_bcurve_nurbs_c        ((PK_render_bcurve_t) 20402)

/* PK_render_viewport_t     (20420-20422) allocated */

#define PK_render_viewport_no_c         ((PK_render_viewport_t) 20420)
#define PK_render_viewport_yes_c        ((PK_render_viewport_t) 20421)
#define PK_render_viewport_array_c      ((PK_render_viewport_t) 20422)

/* PK_render_invisible_t    (20440-20441) allocated */

#define PK_render_invisible_no_c        ((PK_render_invisible_t) 20440)
#define PK_render_invisible_yes_c       ((PK_render_invisible_t) 20441)

/* PK_render_drafting_t     (20450-20451) allocated */

#define PK_render_drafting_no_c         ((PK_render_drafting_t) 20450)
#define PK_render_drafting_yes_c        ((PK_render_drafting_t) 20451)

/* PK_render_self_hidden_t  (20460-20461) allocated */

#define PK_render_self_hidden_no_c      ((PK_render_self_hidden_t) 20460)
#define PK_render_self_hidden_yes_c     ((PK_render_self_hidden_t) 20461)

/* PK_render_viewport_clip_t (20470-20471) allocated */

#define PK_render_viewport_clip_no_c    ((PK_render_viewport_clip_t) 20470)
#define PK_render_viewport_clip_yes_c   ((PK_render_viewport_clip_t) 20471)

/* PK_render_viewport_type_t (20480-20481) allocated */

#define PK_render_viewport_type_3D_c   ((PK_render_viewport_type_t) 20480)
#define PK_render_viewport_type_2D_c   ((PK_render_viewport_type_t) 20481)

/* PK_render_line_t (20490-20499) allocated */

#define PK_render_line_edge_c     ((PK_render_line_t) 20490)
#define PK_render_line_silh_c     ((PK_render_line_t) 20491)
#define PK_render_line_hatch_c    ((PK_render_line_t) 20492)
#define PK_render_line_inter_c    ((PK_render_line_t) 20493)
#define PK_render_line_clip_c     ((PK_render_line_t) 20494)

/* PK_facet_shape_t         (20500-20502) allocated */

#define PK_facet_shape_any_c           ((PK_facet_shape_t) 20500)
#define PK_facet_shape_cut_c           ((PK_facet_shape_t) 20501)
#define PK_facet_shape_convex_c        ((PK_facet_shape_t) 20502)

/* PK_facet_match_t         (20520-20523) allocated */

#define PK_facet_match_no_c            ((PK_facet_match_t) 20520)
#define PK_facet_match_geom_c          ((PK_facet_match_t) 20521)
#define PK_facet_match_topol_c         ((PK_facet_match_t) 20522)
#define PK_facet_match_trimmed_c       ((PK_facet_match_t) 20523)

/* PK_facet_density_t       (20540-20543) allocated */

#define PK_facet_density_no_view_c     ((PK_facet_density_t) 20540)
#define PK_facet_density_use_view_c    ((PK_facet_density_t) 20541)
#define PK_facet_density_parallel_c    ((PK_facet_density_t) 20542)
#define PK_facet_density_sil_and_par_c ((PK_facet_density_t) 20543)

/* PK_facet_cull_t          (20560-20561) allocated */

#define PK_facet_cull_none_c           ((PK_facet_cull_t) 20560)
#define PK_facet_cull_back_c           ((PK_facet_cull_t) 20561)

/* PK_facet_degen_t         (20580-20582) allocated */

#define PK_facet_degen_multiple_vxs_c      ((PK_facet_degen_t) 20580)
#define PK_facet_degen_single_vx_c         ((PK_facet_degen_t) 20581)
#define PK_facet_degen_average_parms_c     ((PK_facet_degen_t) 20582)

/* PK_facet_go_normals_t    (20600-20601) allocated */

#define PK_facet_go_normals_no_c       ((PK_facet_go_normals_t) 20600)
#define PK_facet_go_normals_yes_c      ((PK_facet_go_normals_t) 20601)

/* PK_facet_go_parameters_t (20620-20623) allocated */

#define PK_facet_go_parameters_no_c    ((PK_facet_go_parameters_t) 20620)
#define PK_facet_go_parameters_d0_c    ((PK_facet_go_parameters_t) 20621)
#define PK_facet_go_parameters_d1_c    ((PK_facet_go_parameters_t) 20622)
#define PK_facet_go_parameters_d2_c    ((PK_facet_go_parameters_t) 20623)

/* PK_facet_go_edges_t      (20640-20659) allocated */

#define PK_facet_go_edges_no_c         ((PK_facet_go_edges_t)  20640)
#define PK_facet_go_edges_yes_c        ((PK_facet_go_edges_t)  20641)

/* PK_facet_go_strips_t     (20660-20661) allocated */

#define PK_facet_go_strips_no_c        ((PK_facet_go_strips_t) 20660)
#define PK_facet_go_strips_yes_c       ((PK_facet_go_strips_t) 20661)

/* PK_facet_go_interleaved_t(20680-20681) allocated */

#define PK_facet_go_interleaved_no_c   ((PK_facet_go_interleaved_t) 20680)
#define PK_facet_go_interleaved_yes_c  ((PK_facet_go_interleaved_t) 20681)

/* PK_facet_fault_t         (20700-20720) allocated */

#define PK_facet_fault_face_c          ((PK_facet_fault_t) 20700)
#define PK_facet_fault_facet_c         ((PK_facet_fault_t) 20701)
#define PK_facet_fault_vertex_point_c  ((PK_facet_fault_t) 20702)
#define PK_facet_fault_vertex_normal_c ((PK_facet_fault_t) 20703)
#define PK_facet_fault_vertex_param_c  ((PK_facet_fault_t) 20704)
#define PK_facet_fault_thin_face_c     ((PK_facet_fault_t) 20705)
#define PK_facet_fault_body_c          ((PK_facet_fault_t) 20706)
#define PK_facet_fault_data_normal_c   ((PK_facet_fault_t) 20707)
#define PK_facet_fault_data_param_c    ((PK_facet_fault_t) 20708)
#define PK_facet_fault_data_deriv_c    ((PK_facet_fault_t) 20709)
#define PK_facet_fault_mangled_facet_c ((PK_facet_fault_t) 20710)
#define PK_facet_fault_mangled_strip_c ((PK_facet_fault_t) 20711)
#define PK_facet_fault_missing_face_c  ((PK_facet_fault_t) 20712)
#define PK_facet_fault_refinement_c    ((PK_facet_fault_t) 20713)
#define PK_facet_fault_incr_facet_c    ((PK_facet_fault_t) 20714)
#define PK_facet_fault_pt_off_edge_0_c ((PK_facet_fault_t) 20715)
#define PK_facet_fault_pt_off_edge_1_c ((PK_facet_fault_t) 20716)
#define PK_facet_fault_pt_off_edge_2_c ((PK_facet_fault_t) 20717)
#define PK_facet_fault_pt_off_face_c   ((PK_facet_fault_t) 20718)
#define PK_facet_fault_topol_param_c   ((PK_facet_fault_t) 20719)
#define PK_facet_fault_topol_deriv_c   ((PK_facet_fault_t) 20720)

/* PK_BODY_pick_method_t */

#define PK_BODY_pick_radial_c        ((PK_BODY_pick_method_t) 20900)
#define PK_BODY_pick_axial_c         ((PK_BODY_pick_method_t) 20901)
#define PK_BODY_pick_ratio_c         ((PK_BODY_pick_method_t) 20902)
#define PK_BODY_pick_axial_location_c   ((PK_BODY_pick_method_t) 20903)

/* PK_boolean_select_t */

#define PK_boolean_select_specific_c    ((PK_boolean_select_t) 21000)
#define PK_boolean_select_adjacent_c    ((PK_boolean_select_t) 21001)
#define PK_boolean_select_propagate_c   ((PK_boolean_select_t) 21002)

/* PK_thread_t */

#define PK_thread_disabled_c         ((PK_thread_t) 21010)
#define PK_thread_per_processor_c    ((PK_thread_t) 21011)
#define PK_thread_absolute_c         ((PK_thread_t) 21012)

/* PK_blend_output_rib_t */

#define PK_blend_output_rib_no_c           ((PK_blend_output_rib_t) 21020)
#define PK_blend_output_rib_on_fail_c      ((PK_blend_output_rib_t) 21021)
#define PK_blend_output_rib_only_c         ((PK_blend_output_rib_t) 21022)
#define PK_blend_output_rib_also_c         ((PK_blend_output_rib_t) 21023)
#define PK_blend_output_rib_at_help_c      ((PK_blend_output_rib_t) 21024)

/* PK_blend_group_rib_t */

#define PK_blend_group_rib_no_c        ((PK_blend_group_rib_t) 21030)
#define PK_blend_group_rib_by_face_c   ((PK_blend_group_rib_t) 21031)
#define PK_blend_group_rib_by_parms_c  ((PK_blend_group_rib_t) 21032)

/* PK_blend_check_su_X_t */

#define PK_blend_check_su_X_no_c        ((PK_blend_check_su_X_t) 21040)
#define PK_blend_check_su_X_not_bsurf_c ((PK_blend_check_su_X_t) 21041)
#define PK_blend_check_su_X_yes_c       ((PK_blend_check_su_X_t) 21042)

/* PK_blend_check_fa_t */

#define PK_blend_check_fa_no_c    ((PK_blend_check_fa_t) 21050)
#define PK_blend_check_fa_yes_c   ((PK_blend_check_fa_t) 21051)

/* PK_blend_check_fa_fa_t */

#define PK_blend_check_fa_fa_no_c    ((PK_blend_check_fa_fa_t) 21060)
#define PK_blend_check_fa_fa_yes_c   ((PK_blend_check_fa_fa_t) 21061)

/* PK_blend_update_t */

#define PK_blend_update_0_c    ((PK_blend_update_t) 21070)
#define PK_blend_update_1_c    ((PK_blend_update_t) 21071)
#define PK_blend_update_2_c    ((PK_blend_update_t) 21073)
#define PK_blend_update_3_c    ((PK_blend_update_t) 21074)
#define PK_blend_update_4_c    ((PK_blend_update_t) 21075)
#define PK_blend_update_5_c    ((PK_blend_update_t) 21076)
#define PK_blend_update_6_c    ((PK_blend_update_t) 21077)
#define PK_blend_update_7_c    ((PK_blend_update_t) 21078)
#define PK_blend_update_8_c    ((PK_blend_update_t) 21079)
#define PK_blend_update_9_c    ((PK_blend_update_t) 24220)
#define PK_blend_update_10_c   ((PK_blend_update_t) 24221)
#define PK_blend_update_11_c   ((PK_blend_update_t) 24222)
#define PK_blend_update_12_c   ((PK_blend_update_t) 24223)
#define PK_blend_update_13_c   ((PK_blend_update_t) 24224)
#define PK_blend_update_14_c   ((PK_blend_update_t) 24225)
#define PK_blend_update_15_c   ((PK_blend_update_t) 24226)
#define PK_blend_update_16_c   ((PK_blend_update_t) 24227)
#define PK_blend_update_17_c   ((PK_blend_update_t) 24228)
#define PK_blend_update_18_c   ((PK_blend_update_t) 24229)
#define PK_blend_update_19_c   ((PK_blend_update_t) 24230)
#define PK_blend_update_default_c    ((PK_blend_update_t) 21072)

/* PK_BCURVE_fit_eval_type_t */

#define PK_BCURVE_fit_eval_user_c       ((PK_BCURVE_fit_eval_type_t) 21080)
#define PK_BCURVE_fit_eval_chain_c      ((PK_BCURVE_fit_eval_type_t) 21081)

/* PK_BCURVE_fit_err_method_t */

#define PK_BCURVE_fit_err_none_c      ((PK_BCURVE_fit_err_method_t) 21090)
#define PK_BCURVE_fit_err_parm_c      ((PK_BCURVE_fit_err_method_t) 21091)
#define PK_BCURVE_fit_err_closest_c   ((PK_BCURVE_fit_err_method_t) 21092)

/* PK_BCURVE_fit_t */

#define PK_BCURVE_fit_success_c             ((PK_BCURVE_fit_t) 21100)
#define PK_BCURVE_fit_failure_c             ((PK_BCURVE_fit_t) 21101)
#define PK_BCURVE_fit_other_failed_c        ((PK_BCURVE_fit_t) 21102)
#define PK_BCURVE_fit_eval_failure_c        ((PK_BCURVE_fit_t) 21103)
#define PK_BCURVE_fit_bad_n_curves_c        ((PK_BCURVE_fit_t) 21104)
#define PK_BCURVE_fit_bad_range_c           ((PK_BCURVE_fit_t) 21105)
#define PK_BCURVE_fit_bad_tolerance_c       ((PK_BCURVE_fit_t) 21106)
#define PK_BCURVE_fit_bad_err_method_c      ((PK_BCURVE_fit_t) 21107)
#define PK_BCURVE_fit_bad_eval_type_c       ((PK_BCURVE_fit_t) 21108)
#define PK_BCURVE_fit_bad_break_parm_c      ((PK_BCURVE_fit_t) 21109)
#define PK_BCURVE_fit_bad_chain_c           ((PK_BCURVE_fit_t) 21110)
#define PK_BCURVE_fit_bad_fit_parm_c        ((PK_BCURVE_fit_t) 21111)

/* PK_BODY_curve_nmnl_t */

#define PK_BODY_curve_nmnl_no_c         ((PK_BODY_curve_nmnl_t) 21200)
#define PK_BODY_curve_nmnl_yes_c        ((PK_BODY_curve_nmnl_t) 21201)

/* PK_LOOP_opl_gap_fill_t */

#define PK_LOOP_opl_gap_fill_round_c     ((PK_LOOP_opl_gap_fill_t) 21210)
#define PK_LOOP_opl_gap_fill_linear_c    ((PK_LOOP_opl_gap_fill_t) 21211)
#define PK_LOOP_opl_gap_fill_natural_c   ((PK_LOOP_opl_gap_fill_t) 21212)


/* PK_BODY_owb_gap_fill_t */

#define PK_BODY_owb_gap_fill_round_c     ((PK_BODY_owb_gap_fill_t) 21220)
#define PK_BODY_owb_gap_fill_linear_c    ((PK_BODY_owb_gap_fill_t) 21221)
#define PK_BODY_owb_gap_fill_natural_c   ((PK_BODY_owb_gap_fill_t) 21222)


/* PK_pattern_check_fa_fa_t */

#define PK_pattern_check_fa_fa_no_c    (( PK_pattern_check_fa_fa_t ) 21300)
#define PK_pattern_check_fa_fa_yes_c   (( PK_pattern_check_fa_fa_t ) 21301)

/* PK_pattern_check_loops_t */

#define PK_pattern_check_loops_no_c      (( PK_pattern_check_loops_t ) 21310)
#define PK_pattern_check_loops_yes_c     (( PK_pattern_check_loops_t ) 21311)
#define PK_pattern_check_loops_outside_c (( PK_pattern_check_loops_t ) 21312)

/* PK_pattern_status_t */

#define PK_pattern_status_ok_c          (( PK_pattern_status_t ) 21320)
#define PK_pattern_status_fail_c        (( PK_pattern_status_t ) 21321)
#define PK_pattern_status_outside_fa_c  (( PK_pattern_status_t ) 21322)
#define PK_pattern_status_outside_reg_c (( PK_pattern_status_t ) 21323)
#define PK_pattern_status_tf_failed_c   (( PK_pattern_status_t ) 21324)
#define PK_pattern_status_face_clash_c  (( PK_pattern_status_t ) 21325)
#define PK_pattern_status_colliding_c   (( PK_pattern_status_t ) 21326)

/* PK_pattern_same_face_t */

#define PK_pattern_same_face_no_c    (( PK_pattern_same_face_t ) 21340)
#define PK_pattern_same_face_yes_c   (( PK_pattern_same_face_t ) 21341)

/* PK_pattern_coi_face_t */

#define PK_pattern_coi_face_unknown_c (( PK_pattern_coi_face_t ) 21350)
#define PK_pattern_coi_face_yes_c     (( PK_pattern_coi_face_t ) 21351)

/* PK_pattern_result_t */

#define PK_pattern_result_ok_c             (( PK_pattern_result_t ) 21360)
#define PK_pattern_result_partial_c        (( PK_pattern_result_t ) 21361)
#define PK_pattern_result_fail_c           (( PK_pattern_result_t ) 21362)
#define PK_pattern_result_mixed_faces_c    (( PK_pattern_result_t ) 21363)
#define PK_pattern_result_instanced_c      (( PK_pattern_result_t ) 21364)
#define PK_pattern_result_invalid_set_c    (( PK_pattern_result_t ) 21365)
#define PK_pattern_result_miss_geom_c      (( PK_pattern_result_t ) 21366)

/* PK_pattern_reblend_t */

#define PK_pattern_reblend_no_c     (( PK_pattern_reblend_t ) 23270)
#define PK_pattern_reblend_yes_c    (( PK_pattern_reblend_t ) 23271)

/* PK_pattern_collision_t */

#define PK_pattern_collision_no_c   (( PK_pattern_collision_t ) 21370)
#define PK_pattern_collision_yes_c  (( PK_pattern_collision_t ) 21371)

/* PK_local_check_su_X_t */

#define PK_local_check_su_X_no_c        ((PK_local_check_su_X_t) 21400)
#define PK_local_check_su_X_yes_c       ((PK_local_check_su_X_t) 21401)

/* PK_local_check_topol_t */

#define PK_local_check_topol_no_c        ((PK_local_check_topol_t) 21410)
#define PK_local_check_topol_yes_c       ((PK_local_check_topol_t) 21411)

/* PK_local_change_topol_t */

#define PK_local_change_topol_no_c       ((PK_local_change_topol_t) 21420)
#define PK_local_change_topol_yes_c      ((PK_local_change_topol_t) 21421)

/* PK_local_status_t */

#define PK_local_status_ok_c             ((PK_local_status_t) 21450)
#define PK_local_status_nocheck_c        ((PK_local_status_t) 21451)
#define PK_local_status_fail_c           ((PK_local_status_t) 21452)
#define PK_local_status_cant_get_pt_c    ((PK_local_status_t) 21453)
#define PK_local_status_cant_get_cu_c    ((PK_local_status_t) 21454)
#define PK_local_status_cant_get_su_c    ((PK_local_status_t) 21455)
#define PK_local_status_cant_offset_c    ((PK_local_status_t) 21456)
#define PK_local_status_side_cu_fail_c   ((PK_local_status_t) 21457)
#define PK_local_status_side_su_fail_c   ((PK_local_status_t) 21458)
#define PK_local_status_not_same_by_c    ((PK_local_status_t) 21459)
#define PK_local_status_fa_fail_c        ((PK_local_status_t) 21460)
#define PK_local_status_fa_fa_fail_c     ((PK_local_status_t) 21461)
#define PK_local_status_ed_remains_c     ((PK_local_status_t) 21462)
#define PK_local_status_point_contact_c  ((PK_local_status_t) 21463)
#define PK_local_status_bad_reference_c  ((PK_local_status_t) 21464)
#define PK_local_status_not_supported_c  ((PK_local_status_t) 21465)
#define PK_local_status_cant_extend_c    ((PK_local_status_t) 21466)
#define PK_local_status_sheet_small_c    ((PK_local_status_t) 21467)
#define PK_local_status_cant_use_cu_c    ((PK_local_status_t) 21468)
#define PK_local_status_eds_unconnected_c ((PK_local_status_t) 21469)
#define PK_local_status_non_laminar_c    ((PK_local_status_t) 21470)
#define PK_local_status_reference_loop_c ((PK_local_status_t) 21471)
#define PK_local_status_lp_outside_fa_c  ((PK_local_status_t) 21472)
#define PK_local_status_target_missed_c  ((PK_local_status_t) 21473)
#define PK_local_status_wrong_side_c     ((PK_local_status_t) 21474)
#define PK_local_status_vx_large_tol_c   ((PK_local_status_t) 21475)
#define PK_local_status_ed_large_tol_c   ((PK_local_status_t) 21476)
#define PK_local_status_blend_too_tight_c ((PK_local_status_t) 21477)
#define PK_local_status_cant_make_blend_c ((PK_local_status_t) 21478)
#define PK_local_status_bad_chamfer_c    ((PK_local_status_t) 21479)
#define PK_local_status_bad_blend_c      ((PK_local_status_t) 21480)
#define PK_local_status_not_blend_surf_c ((PK_local_status_t) 21481)

/* PK_TOPOL_track_t */

#define PK_TOPOL_track_delete_c        (( PK_TOPOL_track_t ) 21500)
#define PK_TOPOL_track_merge_c         (( PK_TOPOL_track_t ) 21501)
#define PK_TOPOL_track_create_c        (( PK_TOPOL_track_t ) 21502)
#define PK_TOPOL_track_split_c         (( PK_TOPOL_track_t ) 21503)
#define PK_TOPOL_track_derive_c        (( PK_TOPOL_track_t ) 21504)

/* PK_BODY_simplify_t */

#define PK_BODY_simplify_analytic_c     (( PK_BODY_simplify_t ) 21520)
#define PK_BODY_simplify_no_c           (( PK_BODY_simplify_t ) 21521)
#define PK_BODY_simplify_swept_spun_c   (( PK_BODY_simplify_t ) 21522)

#define PK_BODY_simplify_yes_c          (( PK_BODY_simplify_t ) 21520)

/* PK_BODY_loft_curvature_t */

#define PK_BODY_loft_natural_c          (( PK_BODY_loft_curvature_t ) 21530)
#define PK_BODY_loft_unconstrained_c    (( PK_BODY_loft_curvature_t ) 21531)
#define PK_BODY_loft_clamped_c          (( PK_BODY_loft_curvature_t ) 21532)

/* PK_BODY_loft_clamp_type_t */

#define PK_BODY_loft_clamp_no_c         (( PK_BODY_loft_clamp_type_t ) 21540)
#define PK_BODY_loft_clamp_vector_c     (( PK_BODY_loft_clamp_type_t ) 21541)
#define PK_BODY_loft_clamp_face_c       (( PK_BODY_loft_clamp_type_t ) 21542)
#define PK_BODY_loft_clamp_planar_c     (( PK_BODY_loft_clamp_type_t ) 21543)

/* PK_BODY_loft_fault_t */

#define PK_BODY_loft_ok_c               (( PK_BODY_loft_fault_t ) 21550)
#define PK_BODY_loft_failure_c          (( PK_BODY_loft_fault_t ) 21551)
#define PK_BODY_loft_bad_profile_c      (( PK_BODY_loft_fault_t ) 21552)
#define PK_BODY_loft_surf_failure_c     (( PK_BODY_loft_fault_t ) 21553)
#define PK_BODY_loft_check_failure_c    (( PK_BODY_loft_fault_t ) 21554)
#define PK_BODY_loft_geom_self_int_c    (( PK_BODY_loft_fault_t ) 21555)
#define PK_BODY_loft_topol_self_int_c   (( PK_BODY_loft_fault_t ) 21556)
#define PK_BODY_loft_geom_degen_c       (( PK_BODY_loft_fault_t ) 21557)
#define PK_BODY_loft_small_profile_c    (( PK_BODY_loft_fault_t ) 21558)
#define PK_BODY_loft_bad_match_c        (( PK_BODY_loft_fault_t ) 21559)
#define PK_BODY_loft_bad_clamp_c        (( PK_BODY_loft_fault_t ) 22000)
#define PK_BODY_loft_bad_profile_type_c (( PK_BODY_loft_fault_t ) 22001)
#define PK_BODY_loft_bad_end_conds_c    (( PK_BODY_loft_fault_t ) 22002)
#define PK_BODY_loft_bad_guide_wire_c   (( PK_BODY_loft_fault_t ) 22003)
#define PK_BODY_loft_bad_guide_match_c  (( PK_BODY_loft_fault_t ) 22004)
#define PK_BODY_loft_bad_simplify_c     (( PK_BODY_loft_fault_t ) 22005)

/* PK_BODY_sweep_alignment_t */

#define PK_BODY_sweep_align_normal_c    (( PK_BODY_sweep_alignment_t ) 21560 )
#define PK_BODY_sweep_align_parallel_c  (( PK_BODY_sweep_alignment_t ) 21561 )
#define PK_BODY_sweep_align_parm_c      (( PK_BODY_sweep_alignment_t ) 21562 )
#define PK_BODY_sweep_align_arclength_c (( PK_BODY_sweep_alignment_t ) 21563 )

/* PK_BODY_sweep_law_type_t */

#define PK_BODY_sweep_law_none_c      (( PK_BODY_sweep_law_type_t ) 21570)
#define PK_BODY_sweep_law_discrete_c  (( PK_BODY_sweep_law_type_t ) 21571)
#define PK_BODY_sweep_law_curve_c     (( PK_BODY_sweep_law_type_t ) 21572)
#define PK_BODY_sweep_law_curve_inv_c (( PK_BODY_sweep_law_type_t ) 21573)

/* PK_BODY_sweep_fault_t */

#define PK_BODY_sweep_ok_c               (( PK_BODY_sweep_fault_t ) 21580)
#define PK_BODY_sweep_failure_c          (( PK_BODY_sweep_fault_t ) 21581)
#define PK_BODY_sweep_bad_path_c         (( PK_BODY_sweep_fault_t ) 21582)
#define PK_BODY_sweep_bad_profile_c      (( PK_BODY_sweep_fault_t ) 21583)
#define PK_BODY_sweep_surf_failure_c     (( PK_BODY_sweep_fault_t ) 21584)
#define PK_BODY_sweep_curve_failure_c    (( PK_BODY_sweep_fault_t ) 21585)
#define PK_BODY_sweep_check_failure_c    (( PK_BODY_sweep_fault_t ) 21586)
#define PK_BODY_sweep_geom_self_int_c    (( PK_BODY_sweep_fault_t ) 21587)
#define PK_BODY_sweep_topol_self_int_c   (( PK_BODY_sweep_fault_t ) 21588)
#define PK_BODY_sweep_geom_degen_c       (( PK_BODY_sweep_fault_t ) 21589)
#define PK_BODY_sweep_small_profile_c    (( PK_BODY_sweep_fault_t ) 21590)
#define PK_BODY_sweep_bad_vertex_c       (( PK_BODY_sweep_fault_t ) 21591)
#define PK_BODY_sweep_bad_lock_dir_c     (( PK_BODY_sweep_fault_t ) 21592)
#define PK_BODY_sweep_non_c2_c           (( PK_BODY_sweep_fault_t ) 21593)
#define PK_BODY_sweep_bad_guide_c        (( PK_BODY_sweep_fault_t ) 21594)
#define PK_BODY_sweep_bad_match_c        (( PK_BODY_sweep_fault_t ) 21595)
#define PK_BODY_sweep_bad_trim_point_c   (( PK_BODY_sweep_fault_t ) 21596)
#define PK_BODY_sweep_non_g1_failure_c   (( PK_BODY_sweep_fault_t ) 21597)
#define PK_BODY_sweep_repaired_c         (( PK_BODY_sweep_fault_t ) 21598)
#define PK_BODY_sweep_bad_lock_face_c    (( PK_BODY_sweep_fault_t ) 21599)

/* PK_boolean_report_t */

#define PK_boolean_report_failure_c        ((PK_boolean_report_t) 21600)
#define PK_boolean_report_opposed_sheets_c ((PK_boolean_report_t) 21601)
#define PK_boolean_report_solid_has_void_c ((PK_boolean_report_t) 21602)
#define PK_boolean_report_partial_coi_c    ((PK_boolean_report_t) 21603)
#define PK_boolean_report_t_sheet_c        ((PK_boolean_report_t) 21604)
#define PK_boolean_report_non_manifold_c   ((PK_boolean_report_t) 21605)
#define PK_boolean_report_invalid_match_c  ((PK_boolean_report_t) 21606)
#define PK_boolean_report_imprint_fail_c   ((PK_boolean_report_t) 21607)
#define PK_boolean_report_intersect_fail_c ((PK_boolean_report_t) 21608)
#define PK_boolean_report_invalid_face_c   ((PK_boolean_report_t) 21609)
#define PK_boolean_report_inside_out_c     ((PK_boolean_report_t) 21610)

/* PK_boolean_result_t */

#define PK_boolean_result_success_c     ((PK_boolean_result_t) 21650)
#define PK_boolean_result_no_clash_c    ((PK_boolean_result_t) 21651)
#define PK_boolean_result_no_effect_c   ((PK_boolean_result_t) 21652)
#define PK_boolean_result_failed_c      ((PK_boolean_result_t) 21653)
#define PK_boolean_result_not_solid_c   ((PK_boolean_result_t) 21654)
#define PK_boolean_result_is_tool_c     ((PK_boolean_result_t) 21655)
#define PK_boolean_result_imprint_c     ((PK_boolean_result_t) 21656)

/* PK_section_report_t */

#define PK_section_report_failure_c        ((PK_section_report_t) 21700)
#define PK_section_report_solid_has_void_c ((PK_section_report_t) 21701)
#define PK_section_report_partial_coi_c    ((PK_section_report_t) 21702)
#define PK_section_report_t_sheet_c        ((PK_section_report_t) 21703)
#define PK_section_report_non_manifold_c   ((PK_section_report_t) 21704)
#define PK_section_report_invalid_match_c  ((PK_section_report_t) 21705)
#define PK_section_report_imprint_fail_c   ((PK_section_report_t) 21606)
#define PK_section_report_intersect_fail_c ((PK_section_report_t) 21607)
#define PK_section_report_invalid_face_c   ((PK_section_report_t) 21608)

/* PK_section_result_t */

#define PK_section_result_success_c     ((PK_section_result_t) 21750)
#define PK_section_result_no_clash_c    ((PK_section_result_t) 21751)
#define PK_section_result_no_effect_c   ((PK_section_result_t) 21752)
#define PK_section_result_failed_c      ((PK_section_result_t) 21753)

/* PK_blend_transfer_topol_t */

#define PK_blend_transfer_topol_no_c     ((PK_blend_transfer_topol_t) 21770)
#define PK_blend_transfer_topol_yes_c    ((PK_blend_transfer_topol_t) 21771)

/* PK_local_check_fa_fa_t */

#define PK_local_check_fa_fa_no_c    ((PK_local_check_fa_fa_t) 21780)
#define PK_local_check_fa_fa_yes_c   ((PK_local_check_fa_fa_t) 21781)

/* PK_boolean_check_fa_t */

#define PK_boolean_check_fa_no_c        ((PK_boolean_check_fa_t) 21800)
#define PK_boolean_check_fa_yes_c       ((PK_boolean_check_fa_t) 21801)

/* PK_section_check_fa_t */

#define PK_section_check_fa_no_c        ((PK_section_check_fa_t) 21810)
#define PK_section_check_fa_yes_c       ((PK_section_check_fa_t) 21811)

/* PK_render_ignore_t */

#define PK_render_ignore_no_c          ((PK_render_ignore_t) 21820)
#define PK_render_ignore_absolute_c    ((PK_render_ignore_t) 21821)
#define PK_render_ignore_ratio_c       ((PK_render_ignore_t) 21822)
#define PK_render_ignore_body_ratio_c  ((PK_render_ignore_t) 21823)

/* PK_BODY_topology_t */

#define PK_BODY_topology_minimal_c (( PK_BODY_topology_t ) 21830)
#define PK_BODY_topology_columns_c (( PK_BODY_topology_t ) 21831)
#define PK_BODY_topology_grid_c    (( PK_BODY_topology_t ) 21832)

/* PK_step_surf_t */

#define PK_step_tapered_c (( PK_step_surf_t ) 21840)
#define PK_step_normal_c  (( PK_step_surf_t ) 21841)

/* PK_taper_method_t */

#define PK_taper_method_curve_c   (( PK_taper_method_t) 21845)
#define PK_taper_method_surface_c (( PK_taper_method_t) 21846)
#define PK_taper_method_isocline_c (( PK_taper_method_t) 21847)
#define PK_taper_method_offset_c (( PK_taper_method_t) 21848)  /***offset_draft */
#define PK_taper_method_normal_c  (( PK_taper_method_t) 21849)

/* PK_bound_t */

#define PK_bound_distance_c (( PK_bound_t ) 21850)
#define PK_bound_sheet_c    (( PK_bound_t ) 21851)
#define PK_bound_surf_c     (( PK_bound_t ) 21852)
#define PK_bound_face_c     (( PK_bound_t ) 21853)
#define PK_bound_body_c     (( PK_bound_t ) 21854)
#define PK_bound_none_c     (( PK_bound_t ) 21855)

/* PK_render_overlap_t */

#define PK_render_overlap_no_c          ((PK_render_overlap_t) 21871)
#define PK_render_overlap_yes_c         ((PK_render_overlap_t) 21872)
#define PK_render_overlap_intersect_c   ((PK_render_overlap_t) 21873)
#define PK_render_overlap_intsec_all_c  ((PK_render_overlap_t) 21874)
#define PK_render_overlap_intsec_pair_c ((PK_render_overlap_t) 21875)

/* PK_FACE_coi_t */

#define PK_FACE_coi_yes_c            ((PK_FACE_coi_t) 21880)
#define PK_FACE_coi_yes_reversed_c   ((PK_FACE_coi_t) 21881)
#define PK_FACE_coi_no_topol_c       ((PK_FACE_coi_t) 21882)
#define PK_FACE_coi_no_bound_1_c     ((PK_FACE_coi_t) 21883)
#define PK_FACE_coi_no_bound_2_c     ((PK_FACE_coi_t) 21884)
#define PK_FACE_coi_no_face_1_c      ((PK_FACE_coi_t) 21885)
#define PK_FACE_coi_no_face_2_c      ((PK_FACE_coi_t) 21886)
#define PK_FACE_coi_no_rubber_c      ((PK_FACE_coi_t) 21887)

/* PK_DEBUG_global_res_t */

#define PK_DEBUG_global_res_diffs_c     (( PK_DEBUG_global_res_t ) 21920)
#define PK_DEBUG_global_res_no_diffs_c  (( PK_DEBUG_global_res_t ) 21921)

/* PK_DEBUG_local_res_t */

#define PK_DEBUG_local_res_diffs_c       (( PK_DEBUG_local_res_t ) 21930)
#define PK_DEBUG_local_res_no_diffs_c    (( PK_DEBUG_local_res_t ) 21931)

/* PK_DEBUG_diff_t */

#define PK_DEBUG_diff_n_shells_c        (( PK_DEBUG_diff_t ) 21940)
#define PK_DEBUG_diff_n_faces_c         (( PK_DEBUG_diff_t ) 21941)
#define PK_DEBUG_diff_n_loops_c         (( PK_DEBUG_diff_t ) 21942)
#define PK_DEBUG_diff_n_acc_edges_c     (( PK_DEBUG_diff_t ) 21943)
#define PK_DEBUG_diff_n_tol_edges_c     (( PK_DEBUG_diff_t ) 21944)
#define PK_DEBUG_diff_n_fins_c          (( PK_DEBUG_diff_t ) 21945)
#define PK_DEBUG_diff_n_acc_vxs_c       (( PK_DEBUG_diff_t ) 21946)
#define PK_DEBUG_diff_n_tol_vxs_c       (( PK_DEBUG_diff_t ) 21947)
#define PK_DEBUG_diff_n_vxs_c           (( PK_DEBUG_diff_t ) 21948)
#define PK_DEBUG_diff_n_cht_pts_c       (( PK_DEBUG_diff_t ) 21949)
#define PK_DEBUG_diff_surf_dev_c        (( PK_DEBUG_diff_t ) 21950)
#define PK_DEBUG_diff_curve_dev_c       (( PK_DEBUG_diff_t ) 21951)
#define PK_DEBUG_diff_vx_dev_c          (( PK_DEBUG_diff_t ) 21952)
#define PK_DEBUG_diff_surf_class_c      (( PK_DEBUG_diff_t ) 21953)
#define PK_DEBUG_diff_curve_class_c     (( PK_DEBUG_diff_t ) 21954)
#define PK_DEBUG_diff_edge_tol_c        (( PK_DEBUG_diff_t ) 21955)
#define PK_DEBUG_diff_vx_tol_c          (( PK_DEBUG_diff_t ) 21956)
#define PK_DEBUG_diff_face_sense_c      (( PK_DEBUG_diff_t ) 21957)
#define PK_DEBUG_diff_surf_sense_c      (( PK_DEBUG_diff_t ) 21958)
#define PK_DEBUG_diff_curve_sense_c     (( PK_DEBUG_diff_t ) 21959)
#define PK_DEBUG_diff_vx_missing_c      (( PK_DEBUG_diff_t ) 21960)
#define PK_DEBUG_diff_face_match_c      (( PK_DEBUG_diff_t ) 21961)
#define PK_DEBUG_diff_fin_match_c       (( PK_DEBUG_diff_t ) 21962)
#define PK_DEBUG_diff_vx_match_c        (( PK_DEBUG_diff_t ) 21963)

/* PK_boolean_match_style_t */

#define PK_boolean_match_style_basic_c  ((PK_boolean_match_style_t) 21990)
#define PK_boolean_match_style_relax_c  ((PK_boolean_match_style_t) 21991)
#define PK_boolean_match_style_auto_c   ((PK_boolean_match_style_t) 21992)

/* PK_SURF_extend_status_t */

#define PK_SURF_extend_ok_c              (( PK_SURF_extend_status_t ) 22010)
#define PK_SURF_extend_unextended_c      (( PK_SURF_extend_status_t ) 22011)
#define PK_SURF_extend_partial_c         (( PK_SURF_extend_status_t ) 22012)
#define PK_SURF_extend_invalid_c         (( PK_SURF_extend_status_t ) 22013)
#define PK_SURF_extend_failure_c         (( PK_SURF_extend_status_t ) 22014)

/* PK_SURF_extension_t */

#define PK_SURF_extension_none_c        (( PK_SURF_extension_t ) 22030)
#define PK_SURF_extension_point_c       (( PK_SURF_extension_t ) 22031)
#define PK_SURF_extension_box_c         (( PK_SURF_extension_t ) 22032)
#define PK_SURF_extension_uvbox_c       (( PK_SURF_extension_t ) 22033)
#define PK_SURF_extension_ratio_c       (( PK_SURF_extension_t ) 22034)

/* PK_thicken_method_t */

#define PK_thicken_method_offset_c   (( PK_thicken_method_t ) 22040 )
#define PK_thicken_method_punch_c    (( PK_thicken_method_t ) 22041 )

/* PK_ATTDEF_callback_type_t */

#define PK_ATTDEF_callback_normal_c     (( PK_ATTDEF_callback_type_t ) 22050)
#define PK_ATTDEF_callback_read_only_c  (( PK_ATTDEF_callback_type_t ) 22051)

/* PK_FACE_change_type_t */

#define PK_FACE_change_type_none_c       ((PK_FACE_change_type_t) 22060)
#define PK_FACE_change_type_offset_c     ((PK_FACE_change_type_t) 22061)
#define PK_FACE_change_type_taper_c      ((PK_FACE_change_type_t) 22062)
#define PK_FACE_change_type_transform_c  ((PK_FACE_change_type_t) 22063)
#define PK_FACE_change_type_replace_c    ((PK_FACE_change_type_t) 22064)
#define PK_FACE_change_type_blend_c      ((PK_FACE_change_type_t) 22065)
#define PK_FACE_change_type_bend_c       ((PK_FACE_change_type_t) 22066)
#define PK_FACE_change_type_patch_c      ((PK_FACE_change_type_t) 22067)
#define PK_FACE_change_type_deform_c     ((PK_FACE_change_type_t) 22068)

/* PK_PARAM_direction_t */

#define PK_PARAM_direction_u_c   ((PK_PARAM_direction_t) 22070)
#define PK_PARAM_direction_v_c   ((PK_PARAM_direction_t) 22071)

/* PK_fill_hole_fault_t */

#define PK_fill_hole_ok_c                (( PK_fill_hole_fault_t ) 22080)
#define PK_fill_hole_bad_edge_c          (( PK_fill_hole_fault_t ) 22081)
#define PK_fill_hole_duplicate_c         (( PK_fill_hole_fault_t ) 22082)
#define PK_fill_hole_vertex_c            (( PK_fill_hole_fault_t ) 22083)
#define PK_fill_hole_too_many_loops_c    (( PK_fill_hole_fault_t ) 22084)
#define PK_fill_hole_gap_c               (( PK_fill_hole_fault_t ) 22085)
#define PK_fill_hole_no_edge_on_target_c (( PK_fill_hole_fault_t ) 22086)
#define PK_fill_hole_cant_match_body_c   (( PK_fill_hole_fault_t ) 22087)
#define PK_fill_hole_cant_match_edge_c   (( PK_fill_hole_fault_t ) 22088)
#define PK_fill_hole_too_small_c         (( PK_fill_hole_fault_t ) 22089)
#define PK_fill_hole_unknown_c           (( PK_fill_hole_fault_t ) 22090)
#define PK_fill_hole_face_c              (( PK_fill_hole_fault_t ) 22091)
#define PK_fill_hole_face_face_c         (( PK_fill_hole_fault_t ) 22092)
#define PK_fill_hole_not_smooth_c        (( PK_fill_hole_fault_t ) 22093)
#define PK_fill_hole_too_complex_c       (( PK_fill_hole_fault_t ) 22094)
#define PK_fill_hole_didnt_converge_c    (( PK_fill_hole_fault_t ) 22095)
#define PK_fill_hole_supp_not_smooth_c   (( PK_fill_hole_fault_t ) 22096)

/* PK_fill_hole_method_t */

#define PK_fill_hole_trim_to_hole_c      ((PK_fill_hole_method_t) 22100)
#define PK_fill_hole_trim_to_sheet_c     ((PK_fill_hole_method_t) 22101)
#define PK_fill_hole_create_patch_c      ((PK_fill_hole_method_t) 22102)
#define PK_fill_hole_extend_adjacent_c   ((PK_fill_hole_method_t) 22103)

/* PK_facet_ignore_t        (22111-22114) allocated */

#define PK_facet_ignore_no_c               ((PK_facet_ignore_t) 22111)
#define PK_facet_ignore_absolute_c         ((PK_facet_ignore_t) 22112)
#define PK_facet_ignore_ratio_c            ((PK_facet_ignore_t) 22113)
#define PK_facet_ignore_body_ratio_c       ((PK_facet_ignore_t) 22114)

/* PK_CURVE_approx_t */

#define PK_CURVE_approx_arclength_c   ((PK_CURVE_approx_t) 22120)
#define PK_CURVE_approx_even_c        ((PK_CURVE_approx_t) 22129)

/* PK_facet_ignore_scope_t  (22130-22131) allocated */

#define PK_facet_ignore_scope_local_c      ((PK_facet_ignore_scope_t) 22130)
#define PK_facet_ignore_scope_global_c     ((PK_facet_ignore_scope_t) 22131)

/* PK_facet_wire_edges_t    (22140-22141) allocated */

#define PK_facet_wire_edges_no_c               ((PK_facet_wire_edges_t) 22140)
#define PK_facet_wire_edges_yes_c              ((PK_facet_wire_edges_t) 22141)

/* PK_offset_method_t */

#define PK_offset_method_sx_trim_c       (( PK_offset_method_t ) 22150 )
#define PK_offset_method_sx_repair_1_c   (( PK_offset_method_t ) 22151 )
#define PK_offset_method_sx_repair_2_c   (( PK_offset_method_t ) 22152 )

#define PK_offset_method_accurate_c      (( PK_offset_method_t ) 22150 )
#define PK_offset_method_approximate_c   (( PK_offset_method_t ) 22151 )

/* PK_render_memory_target_t */

#define PK_render_memory_target_no_c     (( PK_render_memory_target_t ) 22160 )
#define PK_render_memory_target_yes_c    (( PK_render_memory_target_t ) 22161 )

/* PK_outline_project_t */

#define PK_outline_project_no_c      (( PK_outline_project_t ) 22170 )
#define PK_outline_project_plane_c   (( PK_outline_project_t ) 22171 )

/* PK_pick_approximate_t */

#define PK_pick_approximate_no_c   (( PK_pick_approximate_t ) 22180 )
#define PK_pick_approximate_yes_c  (( PK_pick_approximate_t ) 22181 )

/* PK_blend_edge_update_t */

#define PK_blend_edge_update_0_c        ((PK_blend_edge_update_t) 22190)
#define PK_blend_edge_update_1_c        ((PK_blend_edge_update_t) 22191)
#define PK_blend_edge_update_2_c        ((PK_blend_edge_update_t) 22193)
#define PK_blend_edge_update_3_c        ((PK_blend_edge_update_t) 22194)
#define PK_blend_edge_update_4_c        ((PK_blend_edge_update_t) 22195)
#define PK_blend_edge_update_5_c        ((PK_blend_edge_update_t) 22196)
#define PK_blend_edge_update_6_c        ((PK_blend_edge_update_t) 22197)
#define PK_blend_edge_update_7_c        ((PK_blend_edge_update_t) 22198)
#define PK_blend_edge_update_8_c        ((PK_blend_edge_update_t) 22199)
#define PK_blend_edge_update_9_c        ((PK_blend_edge_update_t) 23810)
#define PK_blend_edge_update_10_c       ((PK_blend_edge_update_t) 23811)
#define PK_blend_edge_update_11_c       ((PK_blend_edge_update_t) 23812)
#define PK_blend_edge_update_12_c       ((PK_blend_edge_update_t) 23813)
#define PK_blend_edge_update_13_c       ((PK_blend_edge_update_t) 23814)
#define PK_blend_edge_update_14_c       ((PK_blend_edge_update_t) 23815)
#define PK_blend_edge_update_15_c       ((PK_blend_edge_update_t) 23816)
#define PK_blend_edge_update_16_c       ((PK_blend_edge_update_t) 23817)
#define PK_blend_edge_update_17_c       ((PK_blend_edge_update_t) 23818)
#define PK_blend_edge_update_18_c       ((PK_blend_edge_update_t) 23819)
#define PK_blend_edge_update_19_c       ((PK_blend_edge_update_t) 23820)
#define PK_blend_edge_update_20_c       ((PK_blend_edge_update_t) 23821)
#define PK_blend_edge_update_default_c  ((PK_blend_edge_update_t) 22192)

/* PK_blend_xs_shape_t */

#define PK_blend_xs_shape_unset_c           ((PK_blend_xs_shape_t) 22200)
#define PK_blend_xs_shape_conic_c           ((PK_blend_xs_shape_t) 22201)
#define PK_blend_xs_shape_g2_c              ((PK_blend_xs_shape_t) 22202)
#define PK_blend_xs_shape_chamfer_c         ((PK_blend_xs_shape_t) 22203)


/* PK_BODY_sweep_fair_t */

#define PK_BODY_sweep_fair_no_c             (( PK_BODY_sweep_fair_t ) 22210 )
#define PK_BODY_sweep_fair_twist_c          (( PK_BODY_sweep_fair_t ) 22211 )
#define PK_BODY_sweep_fair_twist_2_c        (( PK_BODY_sweep_fair_t ) 22212 )
#define PK_BODY_sweep_fair_default_c        (( PK_BODY_sweep_fair_t ) 22213 )

/* PK_comparison_t */

#define PK_comparison_always_c         ((PK_comparison_t) 22220)
#define PK_comparison_less_c           ((PK_comparison_t) 22221)
#define PK_comparison_equal_c          ((PK_comparison_t) 22222)
#define PK_comparison_greater_c        ((PK_comparison_t) 22223)
#define PK_comparison_between_c        ((PK_comparison_t) 22224)
#define PK_comparison_outside_c        ((PK_comparison_t) 22225)
#define PK_comparison_never_c          ((PK_comparison_t) 22226)

/* PK_blend_identify_t */

#define PK_blend_identify_within_c           ((PK_blend_identify_t) 22240)
#define PK_blend_identify_exc_chain_c        ((PK_blend_identify_t) 22241)
#define PK_blend_identify_inc_chain_c        ((PK_blend_identify_t) 22242)
#define PK_blend_identify_max_chain_c        ((PK_blend_identify_t) 22243)
#define PK_blend_identify_dependent_c        ((PK_blend_identify_t) 22244)

/* PK_detail_t */

#define PK_detail_any_c                 ((PK_detail_t) 22250)
#define PK_detail_rubber_c              ((PK_detail_t) 22251)
#define PK_detail_hole_cyl_c            ((PK_detail_t) 22252)
#define PK_detail_hole_cyl_through_c    ((PK_detail_t) 22253)
#define PK_detail_hole_cyl_blind_c      ((PK_detail_t) 22254)
#define PK_detail_hole_cyl_closed_c     ((PK_detail_t) 22255)
#define PK_detail_blend_rb_const_r_c    ((PK_detail_t) 22256)

/* PK_replace_merge_t */

#define PK_replace_merge_no_c      ((PK_replace_merge_t) 22300)
#define PK_replace_merge_in_c      ((PK_replace_merge_t) 22301)
#define PK_replace_merge_out_c     ((PK_replace_merge_t) 22302)

/* PK_offset_step_t */

#define PK_offset_step_no_c         (( PK_offset_step_t ) 22310 )
#define PK_offset_step_pierce_c     (( PK_offset_step_t ) 22311 )
#define PK_offset_step_yes_c        ( PK_offset_step_pierce_c )
#define PK_offset_step_all_c        (( PK_offset_step_t ) 22312 )
#define PK_offset_step_site_c       (( PK_offset_step_t ) 22313 )

/* PK_blend_orientation_t */

#define PK_blend_orientation_before_c   (( PK_blend_orientation_t ) 22320 )
#define PK_blend_orientation_behind_c   (( PK_blend_orientation_t ) 22321 )
#define PK_blend_orientation_unknown_c  (( PK_blend_orientation_t ) 22322 )

/* PK_3_face_blend_t */

#define PK_3_face_blend_ok_c              (( PK_3_face_blend_t ) 22330 )
#define PK_3_face_blend_sheet_c           (( PK_3_face_blend_t ) 22331 )
#define PK_3_face_blend_fail_c            (( PK_3_face_blend_t ) 22332 )
#define PK_3_face_blend_bad_guide_c       (( PK_3_face_blend_t ) 22333 )
#define PK_3_face_blend_bad_wall_c        (( PK_3_face_blend_t ) 22334 )
#define PK_3_face_blend_bad_orient_c      (( PK_3_face_blend_t ) 22335 )
#define PK_3_face_blend_unoriented_c      (( PK_3_face_blend_t ) 22336 )
#define PK_3_face_blend_bad_blend_tol_c   (( PK_3_face_blend_t ) 22337 )
#define PK_3_face_blend_bad_prop_tol_c    (( PK_3_face_blend_t ) 22338 )
#define PK_3_face_blend_sheet_clash_c     (( PK_3_face_blend_t ) 22339 )
#define PK_3_face_blend_wall_clash_c      (( PK_3_face_blend_t ) 22340 )
#define PK_3_face_blend_face_face_c       (( PK_3_face_blend_t ) 22341 )
#define PK_3_face_blend_self_int_c        (( PK_3_face_blend_t ) 22342 )
#define PK_3_face_blend_inconsistent_c    (( PK_3_face_blend_t ) 22343 )
#define PK_3_face_blend_plane_origin_c    (( PK_3_face_blend_t ) 22344 )
#define PK_3_face_blend_plane_insuff_c    (( PK_3_face_blend_t ) 22345 )
#define PK_3_face_blend_bad_help_c        (( PK_3_face_blend_t ) 22346 )

/* PK_FACE_simplify_t */

#define PK_FACE_simplify_adj_blends_c       (( PK_FACE_simplify_t ) 22360)
#define PK_FACE_simplify_no_c               (( PK_FACE_simplify_t ) 22361)

/* PK_blend_convexity_t */

#define PK_blend_convexity_any_c        (( PK_blend_convexity_t ) 8600)
#define PK_blend_convexity_concave_c    (( PK_blend_convexity_t ) 8603)
#define PK_blend_convexity_convex_c     (( PK_blend_convexity_t ) 8602)

/* PK_fill_hole_preference_t */

#define PK_fill_hole_smooth_c       ((PK_fill_hole_preference_t) 22370)
#define PK_fill_hole_prefer_plane_c ((PK_fill_hole_preference_t) 22371)
#define PK_fill_hole_plane_only_c   ((PK_fill_hole_preference_t) 22372)
#define PK_fill_hole_non_smooth_c   ((PK_fill_hole_preference_t) 22373)

/* PK_blend_set_tol_t */

#define PK_blend_set_tol_yes_c      ((PK_blend_set_tol_t) 22380)
#define PK_blend_set_tol_no_c       ((PK_blend_set_tol_t) 22381)

/* PK_hole_blended_t */

#define PK_hole_blended_no_c            ((PK_hole_blended_t) 22390)
#define PK_hole_blended_in_c            ((PK_hole_blended_t) 22391)
#define PK_hole_blended_out_c           ((PK_hole_blended_t) 22392)
#define PK_hole_blended_trimmed_in_c    ((PK_hole_blended_t) 22393)
#define PK_hole_blended_trimmed_out_c   ((PK_hole_blended_t) 22394)

/* PK_taper_corner_type_t */

#define PK_taper_corner_extend_c    (( PK_taper_corner_type_t) 22400 )
#define PK_taper_corner_plane_c     (( PK_taper_corner_type_t) 22401 )

/* PK_VERTEX_optimise_result_t */

#define PK_VERTEX_optimise_success_c      ((PK_VERTEX_optimise_result_t) 22410)
#define PK_VERTEX_optimise_failure_c      ((PK_VERTEX_optimise_result_t) 22411)

/* PK_VERTEX_max_dev_t */

#define PK_VERTEX_max_dev_vertex_tol_c ((PK_VERTEX_max_dev_t) 22420)
#define PK_VERTEX_max_dev_supplied_c   ((PK_VERTEX_max_dev_t) 22421)

/* PK_taper_smooth_step_t */

#define PK_taper_smooth_step_yes_c    (( PK_taper_smooth_step_t) 22430 )
#define PK_taper_smooth_step_no_c     (( PK_taper_smooth_step_t) 22431 )

/* PK_hole_update_t */

#define PK_hole_update_0_c              ((PK_hole_update_t) 22440)
#define PK_hole_update_default_c        ((PK_hole_update_t) 22441)

/* PK_TOPOL_fctab_t (22450-22468) allocated */

#define PK_TOPOL_fctab_facet_fin_c             ((PK_TOPOL_fctab_t) 22450)
#define PK_TOPOL_fctab_strip_boundary_c        ((PK_TOPOL_fctab_t) 22451)
#define PK_TOPOL_fctab_strip_zigzag_c          ((PK_TOPOL_fctab_t) 22452)
#define PK_TOPOL_fctab_fin_fin_c               ((PK_TOPOL_fctab_t) 22453)
#define PK_TOPOL_fctab_fin_data_c              ((PK_TOPOL_fctab_t) 22454)
#define PK_TOPOL_fctab_data_point_c            ((PK_TOPOL_fctab_t) 22455)
#define PK_TOPOL_fctab_data_normal_c           ((PK_TOPOL_fctab_t) 22456)
#define PK_TOPOL_fctab_data_param_c            ((PK_TOPOL_fctab_t) 22457)
#define PK_TOPOL_fctab_data_deriv_c            ((PK_TOPOL_fctab_t) 22458)
#define PK_TOPOL_fctab_point_vec_c             ((PK_TOPOL_fctab_t) 22459)
#define PK_TOPOL_fctab_normal_vec_c            ((PK_TOPOL_fctab_t) 22460)
#define PK_TOPOL_fctab_param_uv_c              ((PK_TOPOL_fctab_t) 22461)
#define PK_TOPOL_fctab_deriv_dp_c              ((PK_TOPOL_fctab_t) 22462)
#define PK_TOPOL_fctab_deriv_d2p_c             ((PK_TOPOL_fctab_t) 22463)
#define PK_TOPOL_fctab_facet_face_c            ((PK_TOPOL_fctab_t) 22464)
#define PK_TOPOL_fctab_strip_face_c            ((PK_TOPOL_fctab_t) 22465)
#define PK_TOPOL_fctab_fin_edge_c              ((PK_TOPOL_fctab_t) 22466)
#define PK_TOPOL_fctab_error_object_c          ((PK_TOPOL_fctab_t) 22467)
#define PK_TOPOL_fctab_point_topol_c           ((PK_TOPOL_fctab_t) 22468)
#define PK_TOPOL_fctab_fin_topol_c             ((PK_TOPOL_fctab_t) 22469)

/* PK_facet_split_strip_t (22500-22501) allocated */

#define PK_facet_split_strip_no_c       ((PK_facet_split_strip_t) 22500)
#define PK_facet_split_strip_yes_c      ((PK_facet_split_strip_t) 22501)

/* PK_facet_consistent_parms_t (22510-22512) allocated */

#define PK_facet_consistent_parms_no_c  ((PK_facet_consistent_parms_t) 22510)
#define PK_facet_consistent_parms_su_c  ((PK_facet_consistent_parms_t) 22511)
#define PK_facet_consistent_parms_yes_c (PK_facet_consistent_parms_su_c)
#define PK_facet_consistent_parms_fa_c  ((PK_facet_consistent_parms_t) 22512)

/* PK_BODY_loft_update_t */

#define PK_BODY_loft_update_0_c          ((PK_BODY_loft_update_t) 22520)
#define PK_BODY_loft_update_1_c          ((PK_BODY_loft_update_t) 22521)
#define PK_BODY_loft_update_2_c          ((PK_BODY_loft_update_t) 22522)
#define PK_BODY_loft_update_default_c    ((PK_BODY_loft_update_t) 22523)
#define PK_BODY_loft_update_3_c          ((PK_BODY_loft_update_t) 22524)
#define PK_BODY_loft_update_4_c          ((PK_BODY_loft_update_t) 22525)

/* PK_taper_miter_type_t */

#define PK_taper_miter_on_ref_c         ((PK_taper_miter_type_t) 22530)
#define PK_taper_miter_to_face_c        ((PK_taper_miter_type_t) 22531)
#define PK_taper_miter_at_open_c        ((PK_taper_miter_type_t) 22532)

/* PK_BODY_sweep_scale_type_t */

#define PK_BODY_sweep_scale_posn_c      ((PK_BODY_sweep_scale_type_t) 22540)
#define PK_BODY_sweep_scale_size_c      ((PK_BODY_sweep_scale_type_t) 22541)
#define PK_BODY_sweep_scale_both_c      ((PK_BODY_sweep_scale_type_t) 22542)

/* PK_facet_vx_data_type_t (22550-22555) allocated */

#define PK_facet_vx_data_ordinary_c     ((PK_facet_vx_data_type_t) 22550)
#define PK_facet_vx_data_mixed_c        ((PK_facet_vx_data_type_t) 22551)
#define PK_facet_vx_data_spike_c        ((PK_facet_vx_data_type_t) 22552)
#define PK_facet_vx_data_fin_c          ((PK_facet_vx_data_type_t) 22553)
#define PK_facet_vx_data_start_spike_c  ((PK_facet_vx_data_type_t) 22554)
#define PK_facet_vx_data_end_spike_c    ((PK_facet_vx_data_type_t) 22555)

/* PK_facet_incr_t (22560-22563) allocated */

#define PK_facet_incr_no_c              ((PK_facet_incr_t) 22560)
#define PK_facet_incr_clear_c           ((PK_facet_incr_t) 22561)
#define PK_facet_incr_refresh_c         ((PK_facet_incr_t) 22562)
#define PK_facet_incr_yes_c             ((PK_facet_incr_t) 22563)

/* PK_facet_incr_refine_t (22570-22571) allocated */

#define PK_facet_incr_refine_no_c       ((PK_facet_incr_refine_t) 22570)
#define PK_facet_incr_refine_yes_c      ((PK_facet_incr_refine_t) 22571)

/* PK_facet_incr_report_t (22580-22583) allocated */

#define PK_facet_incr_report_no_c       ((PK_facet_incr_report_t) 22580)
#define PK_facet_incr_report_missing_c  ((PK_facet_incr_report_t) 22581)
#define PK_facet_incr_report_refine_c   ((PK_facet_incr_report_t) 22582)
#define PK_facet_incr_report_yes_c      ((PK_facet_incr_report_t) 22583)

/* PK_hole_const_rad_t */

#define PK_hole_const_rad_no_c          ((PK_hole_const_rad_t) 22590)
#define PK_hole_const_rad_yes_c         ((PK_hole_const_rad_t) 22591)

/* PK_hole_ortho_t */

#define PK_hole_ortho_no_c              ((PK_hole_ortho_t) 22600)
#define PK_hole_ortho_yes_c             ((PK_hole_ortho_t) 22601)

/* PK_fill_hole_update_t */

#define PK_fill_hole_update_0_c       (( PK_fill_hole_update_t) 22610 )
#define PK_fill_hole_update_1_c       (( PK_fill_hole_update_t) 22611 )
#define PK_fill_hole_update_2_c       (( PK_fill_hole_update_t) 22612 )
#define PK_fill_hole_update_3_c       (( PK_fill_hole_update_t) 22613 )
#define PK_fill_hole_update_4_c       (( PK_fill_hole_update_t) 22614 )
#define PK_fill_hole_update_default_c (( PK_fill_hole_update_t) 22615 )
#define PK_fill_hole_update_5_c       (( PK_fill_hole_update_t) 22616 )
#define PK_fill_hole_update_6_c       (( PK_fill_hole_update_t) 22617 )
#define PK_fill_hole_update_7_c       (( PK_fill_hole_update_t) 22618 )
#define PK_fill_hole_update_8_c       (( PK_fill_hole_update_t) 22619 )
#define PK_fill_hole_update_9_c       (( PK_fill_hole_update_t) 25330 )
#define PK_fill_hole_update_10_c      (( PK_fill_hole_update_t) 25331 )
#define PK_fill_hole_update_11_c      (( PK_fill_hole_update_t) 25332 )

/* PK_FACE_change_bend_type_t */

#define PK_FACE_change_bend_c           ((PK_FACE_change_bend_type_t) 22620)
#define PK_FACE_change_bend_side_c      ((PK_FACE_change_bend_type_t) 22621)

/* PK_bend_merge_t */

#define PK_bend_merge_no_c      ((PK_bend_merge_t) 22630)
#define PK_bend_merge_in_c      ((PK_bend_merge_t) 22631)
#define PK_bend_merge_out_c     ((PK_bend_merge_t) 22632)

/* PK_EDGE_offset_blend_t */

#define PK_EDGE_offset_blend_no_c           ((PK_EDGE_offset_blend_t) 22640)
#define PK_EDGE_offset_blend_convex_c       ((PK_EDGE_offset_blend_t) 22641)

/* PK_replace_adjust_t */

#define PK_replace_adjust_no_c          ((PK_replace_adjust_t) 22650)
#define PK_replace_adjust_yes_c         ((PK_replace_adjust_t) 22651)

/* PK_replace_use_t */

#define PK_replace_use_attempt_c          ((PK_replace_use_t) 22660)
#define PK_replace_use_yes_c              ((PK_replace_use_t) 22661)
#define PK_replace_use_existing_c         ((PK_replace_use_t) 22662)

/* PK_hole_comp_t */

#define PK_hole_comp_cyl_c              ((PK_hole_comp_t) 22670)
#define PK_hole_comp_cone_in_c          ((PK_hole_comp_t) 22671)
#define PK_hole_comp_cone_out_c         ((PK_hole_comp_t) 22672)
#define PK_hole_comp_blnd_in_concave_c  ((PK_hole_comp_t) 22673)
#define PK_hole_comp_blnd_out_concave_c ((PK_hole_comp_t) 22674)
#define PK_hole_comp_blnd_in_convex_c   ((PK_hole_comp_t) 22675)
#define PK_hole_comp_blnd_out_convex_c  ((PK_hole_comp_t) 22676)
#define PK_hole_comp_zero_depth_in_c    ((PK_hole_comp_t) 22677)
#define PK_hole_comp_zero_depth_out_c   ((PK_hole_comp_t) 22678)
#define PK_hole_comp_open_end_c         ((PK_hole_comp_t) 22679)
#define PK_hole_comp_closed_end_c       ((PK_hole_comp_t) 22680)
#define PK_hole_comp_unknown_c          ((PK_hole_comp_t) 22681)

/* PK_detail_type_t */

#define PK_detail_type_unknown_c        ((PK_detail_type_t) 22690)
#define PK_detail_type_hole_c           ((PK_detail_type_t) 22691)

/* PK_blend_repair_su_X_t */

#define PK_blend_repair_su_X_no_c         ((PK_blend_repair_su_X_t) 22710)
#define PK_blend_repair_su_X_yes_c        ((PK_blend_repair_su_X_t) 22711)
#define PK_blend_repair_su_X_report_c     ((PK_blend_repair_su_X_t) 22712)

/* PK_blend_output_sheet_t */

#define PK_blend_output_sheet_no_c      ((PK_blend_output_sheet_t) 22720)
#define PK_blend_output_sheet_yes_c     ((PK_blend_output_sheet_t) 22721)
#define PK_blend_output_sheet_on_fail_c ((PK_blend_output_sheet_t) 22722)

/* PK_local_ops_update_t */

#define PK_local_ops_update_0_c         ((PK_local_ops_update_t) 22730)
#define PK_local_ops_update_1_c         ((PK_local_ops_update_t) 23320)
#define PK_local_ops_update_2_c         ((PK_local_ops_update_t) 23720)
#define PK_local_ops_update_3_c         ((PK_local_ops_update_t) 24331)
#define PK_local_ops_update_4_c         ((PK_local_ops_update_t) 24332)
#define PK_local_ops_update_5_c         ((PK_local_ops_update_t) 24333)
#define PK_local_ops_update_6_c         ((PK_local_ops_update_t) 24334)
#define PK_local_ops_update_7_c         ((PK_local_ops_update_t) 24335)
#define PK_local_ops_update_8_c         ((PK_local_ops_update_t) 24336)
#define PK_local_ops_update_9_c         ((PK_local_ops_update_t) 24337)
#define PK_local_ops_update_10_c        ((PK_local_ops_update_t) 24338)
#define PK_local_ops_update_11_c        ((PK_local_ops_update_t) 24339)
#define PK_local_ops_update_12_c        ((PK_local_ops_update_t) 25540)
#define PK_local_ops_update_default_c   ((PK_local_ops_update_t) 24330)

/* PK_replace_update_t */

#define PK_replace_update_0_c          ((PK_replace_update_t) 22730)
#define PK_replace_update_default_c    ((PK_replace_update_t) 22731)

/* PK_fill_hole_topol_t */

#define PK_fill_hole_topol_multiple_c   ((PK_fill_hole_topol_t) 22740)
#define PK_fill_hole_topol_minimal_c    ((PK_fill_hole_topol_t) 22741)
#define PK_fill_hole_topol_single_c     ((PK_fill_hole_topol_t) 22742)

/* PK_extension_shape_t */

#define PK_extension_shape_linear_c       ((PK_extension_shape_t) 22750)
#define PK_extension_shape_soft_c         ((PK_extension_shape_t) 22751)
#define PK_extension_shape_reflective_c   ((PK_extension_shape_t) 22752)
#define PK_extension_shape_natural_c      ((PK_extension_shape_t) 22753)
#define PK_extension_shape_arc_c          ((PK_extension_shape_t) 22754)

/* PK_BODY_extension_t */

#define PK_BODY_extension_distance_c ((PK_BODY_extension_t) 22760)
#define PK_BODY_extension_target_c   ((PK_BODY_extension_t) 22761)

/* PK_BODY_loft_deriv_mag_t */

#define PK_BODY_loft_deriv_mag_single_c    ((PK_BODY_loft_deriv_mag_t) 22770)
#define PK_BODY_loft_deriv_mag_smooth_c    ((PK_BODY_loft_deriv_mag_t) 22771)

/* PK_imprint_complete_t */

#define PK_imprint_complete_no_c      (( PK_imprint_complete_t ) 22780)
#define PK_imprint_complete_edge_c    (( PK_imprint_complete_t ) 22781)
#define PK_imprint_complete_laminar_c (( PK_imprint_complete_t ) 22782)
#define PK_imprint_complete_faceset_c (( PK_imprint_complete_t ) 22783)

/* PK_imprint_extend_t */

#define PK_imprint_extend_tangent_c     (( PK_imprint_extend_t ) 22790)
#define PK_imprint_extend_orth_fwd_c    (( PK_imprint_extend_t ) 22791)
#define PK_imprint_extend_orth_back_c   (( PK_imprint_extend_t ) 22792)

/* PK_facet_inflect_t */

#define PK_facet_inflect_no_c           (( PK_facet_inflect_t ) 22800)
#define PK_facet_inflect_split_near_c   (( PK_facet_inflect_t ) 22801)

/* PK_imprint_connect_t */

#define PK_imprint_connect_none_c       (( PK_imprint_connect_t ) 22810)
#define PK_imprint_connect_side_c       (( PK_imprint_connect_t ) 22811)
#define PK_imprint_connect_all_c        (( PK_imprint_connect_t ) 22812)
#define PK_imprint_connect_side_all_c   (( PK_imprint_connect_t ) 22813)
#define PK_imprint_connect_hidden_all_c (( PK_imprint_connect_t ) 22814)

/* PK_range_type_t */

#define PK_range_type_minimum_c        (( PK_range_type_t ) 22820)
#define PK_range_type_maximum_c        (( PK_range_type_t ) 22821)

/* PK_boolean_material_t */

#define PK_boolean_material_none_c      ((PK_boolean_material_t) 22830)
#define PK_boolean_material_inside_c    ((PK_boolean_material_t) 22831)
#define PK_boolean_material_default_c   ((PK_boolean_material_t) 22832)
#define PK_boolean_material_outside_c   ((PK_boolean_material_t) 22833)

/* PK_DEBUG_roll_direction_t */

#define PK_DEBUG_roll_no_c         (( PK_DEBUG_roll_direction_t ) 22840)
#define PK_DEBUG_roll_back_main_c  (( PK_DEBUG_roll_direction_t ) 22841)
#define PK_DEBUG_roll_back_c       (( PK_DEBUG_roll_direction_t ) 22842)
#define PK_DEBUG_roll_fwd_c        (( PK_DEBUG_roll_direction_t ) 22843)
#define PK_DEBUG_roll_both_c       (( PK_DEBUG_roll_direction_t ) 22844)

/* PK_blend_rho_t */

#define PK_blend_rho_absolute_c         ((PK_blend_rho_t) 22850)
#define PK_blend_rho_relative_c         ((PK_blend_rho_t) 22851)
#define PK_blend_rho_centre_c           ((PK_blend_rho_t) 22852)

/* PK_taper_undercut_t */

#define PK_taper_undercut_ref_no_c      ((PK_taper_undercut_t) 22860)
#define PK_taper_undercut_ref_yes_c     ((PK_taper_undercut_t) 22861)

/* PK_EDGE_optimise_result_t */

#define PK_EDGE_optimise_success_c      ((PK_EDGE_optimise_result_t) 22870)
#define PK_EDGE_optimise_failure_c      ((PK_EDGE_optimise_result_t) 22871)

/* PK_EDGE_max_dev_t */

#define PK_EDGE_max_dev_edge_tol_c   ((PK_EDGE_max_dev_t) 22880)
#define PK_EDGE_max_dev_supplied_c   ((PK_EDGE_max_dev_t) 22881)

/* PK_check_state_t */

#define PK_SESSION_state_corrupt_c      ((PK_check_state_t) 22890)
#define PK_BB_state_corrupt_c           ((PK_check_state_t) 22891)
#define PK_KI_LIST_state_corrupt_c      ((PK_check_state_t) 22892)
#define PK_GEOM_state_corrupt_c         ((PK_check_state_t) 22893)
#define PK_TRANSF_state_corrupt_c       ((PK_check_state_t) 22894)
#define PK_ASSEMBLY_state_corrupt_c     ((PK_check_state_t) 22895)
#define PK_PARTITION_state_corrupt_c    ((PK_check_state_t) 22896)
#define PK_PARTITION_state_xref_c       ((PK_check_state_t) 22897)
#define PK_ITEM_state_unattached_c      ((PK_check_state_t) 22898)
#define PK_BCURVE_state_close_knots_c   ((PK_check_state_t) 22899)
#define PK_BSURF_state_close_u_knots_c  ((PK_check_state_t) 22900)
#define PK_BSURF_state_close_v_knots_c  ((PK_check_state_t) 22901)
#define PK_EDGE_state_touch_edge_c      ((PK_check_state_t) 22902)
#define PK_TOPOL_state_bad_closed_c     ((PK_check_state_t) 22903)
#define PK_TOPOL_state_u_parm_degen_c   ((PK_check_state_t) 22904)
#define PK_TOPOL_state_v_parm_degen_c   ((PK_check_state_t) 22905)
#define PK_TOPOL_state_parm_degen_c     ((PK_check_state_t) 22906)
#define PK_TOPOL_state_u_phys_degen_c   ((PK_check_state_t) 22907)
#define PK_TOPOL_state_v_phys_degen_c   ((PK_check_state_t) 22908)
#define PK_TOPOL_state_phys_degen_c     ((PK_check_state_t) 22909)

/* PK_extension_smoothness_t */

#define PK_extension_smoothness_g0_c ((PK_extension_smoothness_t) 22910)
#define PK_extension_smoothness_g1_c ((PK_extension_smoothness_t) 22911)

/* PK_boolean_prefer_t */

#define PK_boolean_prefer_solid_c         ((PK_boolean_prefer_t) 22920)
#define PK_boolean_prefer_sheet_c         ((PK_boolean_prefer_t) 22921)
#define PK_boolean_prefer_original_c      ((PK_boolean_prefer_t) 22922)
#define PK_boolean_prefer_wire_c          ((PK_boolean_prefer_t) 22923)
#define PK_boolean_prefer_general_c       ((PK_boolean_prefer_t) 22924)
#define PK_boolean_prefer_simplest_c      ((PK_boolean_prefer_t) 22925)

/* PK_emboss_sidewall_t */

#define PK_emboss_sidewall_tapered_c    ((PK_emboss_sidewall_t) 22930)
#define PK_emboss_sidewall_ruled_c      ((PK_emboss_sidewall_t) 22931)
#define PK_emboss_sidewall_swept_c      ((PK_emboss_sidewall_t) 22932)
#define PK_emboss_sidewall_supplied_c   ((PK_emboss_sidewall_t) 22933)

/* PK_emboss_profile_on_t */

#define PK_emboss_profile_on_endcap_c  ((PK_emboss_profile_on_t) 22940)
#define PK_emboss_profile_on_target_c  ((PK_emboss_profile_on_t) 22941)
#define PK_emboss_profile_on_any_c     ((PK_emboss_profile_on_t) 22942)

/* PK_emboss_convexity_t */

#define PK_emboss_convexity_both_c      ((PK_emboss_convexity_t) 22950)
#define PK_emboss_convexity_pad_c       ((PK_emboss_convexity_t) 22951)
#define PK_emboss_convexity_pocket_c    ((PK_emboss_convexity_t) 22952)

/* PK_bound_side_t */

#define PK_bound_side_both_c        ((PK_bound_side_t) 22980)
#define PK_bound_side_out_c         ((PK_bound_side_t) 22981)
#define PK_bound_side_in_c          ((PK_bound_side_t) 22982)

/* PK_blend_inside_tight_t */

#define PK_blend_inside_tight_no_c      ((PK_blend_inside_tight_t) 22990)
#define PK_blend_inside_tight_blends_c  ((PK_blend_inside_tight_t) 22991)
#define PK_blend_inside_tight_faces_c   ((PK_blend_inside_tight_t) 22992)
#define PK_blend_inside_tight_partial_c ((PK_blend_inside_tight_t) 22993)

/* PK_imprint_face_hidden_t */

#define PK_imprint_face_hidden_no_c     (( PK_imprint_face_hidden_t ) 23000)
#define PK_imprint_face_hidden_array_c  (( PK_imprint_face_hidden_t ) 23001)
#define PK_imprint_face_hidden_body_c   (( PK_imprint_face_hidden_t ) 23002)

/* PK_taper_concave_type_t */

#define PK_taper_concave_none_c      (( PK_taper_concave_type_t) 23010 )
#define PK_taper_concave_radius_c    (( PK_taper_concave_type_t) 23011 )
#define PK_taper_concave_plane_c     (( PK_taper_concave_type_t) 23012 )
#define PK_taper_concave_mix_c       (( PK_taper_concave_type_t) 23013 )

/* PK_BODY_smoothness_t */

#define PK_BODY_smoothness_exact_c    ((PK_BODY_smoothness_t) 23020)
#define PK_BODY_smoothness_relax_c    ((PK_BODY_smoothness_t) 23021)

/* PK_ATTDEF_cb_on_t */

#define PK_ATTDEF_cb_on_mismatch_c    ((PK_ATTDEF_cb_on_t) 23030)
#define PK_ATTDEF_cb_on_any_c         ((PK_ATTDEF_cb_on_t) 23031)

/* PK_taper_step_face_t */

#define PK_taper_step_face_yes_c    (( PK_taper_step_face_t) 23040 )
#define PK_taper_step_face_no_c     (( PK_taper_step_face_t) 23041 )
#define PK_taper_preserve_smooth_c  (( PK_taper_step_face_t) 23042 )

/* PK_facet_quality_t */

#define PK_facet_quality_standard_c    (( PK_facet_quality_t ) 23050)
#define PK_facet_quality_improved_c    (( PK_facet_quality_t ) 23051)

/* PK_emboss_overflow_t */

#define PK_emboss_overflow_added_c      ((PK_emboss_overflow_t) 23060)
#define PK_emboss_overflow_mixed_c      ((PK_emboss_overflow_t) 23061)
#define PK_emboss_overflow_ruled_c      ((PK_emboss_overflow_t) 23062)
#define PK_emboss_overflow_swept_c      ((PK_emboss_overflow_t) 23063)
#define PK_emboss_overflow_none_c       ((PK_emboss_overflow_t) 23064)
#define PK_emboss_overflow_laminar_c    ((PK_emboss_overflow_t) 23065)

/* PK_BCURVE_extend_status_t */

#define PK_BCURVE_extend_ok_c            (( PK_BCURVE_extend_status_t ) 23070)
#define PK_BCURVE_extend_unextended_c    (( PK_BCURVE_extend_status_t ) 23071)
#define PK_BCURVE_extend_partial_c       (( PK_BCURVE_extend_status_t ) 23072)
#define PK_BCURVE_extend_failure_c       (( PK_BCURVE_extend_status_t ) 23073)

/* PK_BCURVE_extension_t */

#define PK_BCURVE_extension_none_c          (( PK_BCURVE_extension_t ) 23080)
#define PK_BCURVE_extension_distance_c      (( PK_BCURVE_extension_t ) 23081)
#define PK_BCURVE_extension_to_parm_c       (( PK_BCURVE_extension_t ) 23082)
#define PK_BCURVE_extension_parm_ratio_c    (( PK_BCURVE_extension_t ) 23083)

/* PK_BCURVE_spline_t */

#define PK_BCURVE_spline_ok_c          (( PK_BCURVE_spline_t ) 23090)
#define PK_BCURVE_spline_failure_c     (( PK_BCURVE_spline_t ) 23091)
#define PK_BCURVE_spline_degree_c      (( PK_BCURVE_spline_t ) 23092)
#define PK_BCURVE_spline_bad_derivs_c  (( PK_BCURVE_spline_t ) 23093)
#define PK_BCURVE_spline_many_derivs_c (( PK_BCURVE_spline_t ) 23094)
#define PK_BCURVE_spline_bad_params_c  (( PK_BCURVE_spline_t ) 23095)
#define PK_BCURVE_spline_bad_knots_c   (( PK_BCURVE_spline_t ) 23096)
#define PK_BCURVE_spline_high_mult_c   (( PK_BCURVE_spline_t ) 23097)
#define PK_BCURVE_spline_overdefined_c (( PK_BCURVE_spline_t ) 23098)

/* PK_BCURVE_overdefined_t */

#define PK_BCURVE_overdefined_fail_c   (( PK_BCURVE_overdefined_t ) 23110)
#define PK_BCURVE_overdefined_insert_c (( PK_BCURVE_overdefined_t ) 23111)

/* PK_blend_order_t */

#define PK_blend_order_min_convexity_c      ((PK_blend_order_t) 23120)
#define PK_blend_order_maj_convexity_c      ((PK_blend_order_t) 23121)
#define PK_blend_order_concave_convex_c     ((PK_blend_order_t) 23122)
#define PK_blend_order_convex_concave_c     ((PK_blend_order_t) 23123)
#define PK_blend_order_unset_c              ((PK_blend_order_t) 23124)

/* PK_blend_setback_shape_t */

#define PK_blend_setback_collar_all_c  ((PK_blend_setback_shape_t) 23130)
#define PK_blend_setback_collar_none_c ((PK_blend_setback_shape_t) 23131)

/* PK_DEBUG_output_session_t */

#define PK_DEBUG_output_session_no_c (( PK_DEBUG_output_session_t ) 23140)
#define PK_DEBUG_output_session_bin_c (( PK_DEBUG_output_session_t ) 23141)

/* PK_continuity_t */

#define PK_continuity_c1_c (( PK_continuity_t ) 23150)
#define PK_continuity_c2_c (( PK_continuity_t ) 23151)
#define PK_continuity_c3_c (( PK_continuity_t ) 23152)
#define PK_continuity_g1_c (( PK_continuity_t ) 23153)
#define PK_continuity_g2_c (( PK_continuity_t ) 23154)
#define PK_continuity_g3_c (( PK_continuity_t ) 23155)

/* PK_boolean_no_effect_t */

#define PK_boolean_no_effect_basic_c     ((PK_boolean_no_effect_t) 23160)
#define PK_boolean_no_effect_advanced_c  ((PK_boolean_no_effect_t) 23161)

/* PK_taper_laminar_edge_t */

#define PK_taper_laminar_edge_normal_c ((PK_taper_laminar_edge_t) 23170)
#define PK_taper_laminar_edge_draw_c   ((PK_taper_laminar_edge_t) 23171)

/* PK_offset_on_body_t */

#define PK_offset_on_body_ok_c             ((PK_offset_on_body_t) 23180)
#define PK_offset_on_body_fail_c           ((PK_offset_on_body_t) 23181)
#define PK_offset_on_body_bad_dirn_c       ((PK_offset_on_body_t) 23182)
#define PK_offset_on_body_connected_c      ((PK_offset_on_body_t) 23183)
#define PK_offset_on_body_outside_c        ((PK_offset_on_body_t) 23184)

/* PK_CURVE_general_type_t */

#define PK_CURVE_general_user_c      ((PK_CURVE_general_type_t) 23190)
#define PK_CURVE_general_curve_c     ((PK_CURVE_general_type_t) 23191)

/* PK_BCURVE_fitted_t */

#define PK_BCURVE_fitted_success_c             ((PK_BCURVE_fitted_t) 23200)
#define PK_BCURVE_fitted_failure_c             ((PK_BCURVE_fitted_t) 23201)
#define PK_BCURVE_fitted_eval_failure_c        ((PK_BCURVE_fitted_t) 23202)
#define PK_BCURVE_fitted_bad_range_c           ((PK_BCURVE_fitted_t) 23203)
#define PK_BCURVE_fitted_bad_tolerance_c       ((PK_BCURVE_fitted_t) 23204)
#define PK_BCURVE_fitted_bad_eval_type_c       ((PK_BCURVE_fitted_t) 23205)
#define PK_BCURVE_fitted_bad_interp_parm_c     ((PK_BCURVE_fitted_t) 23206)

/* PK_SURF_general_type_t */

#define PK_SURF_general_user_c      ((PK_SURF_general_type_t) 23220)
#define PK_SURF_general_surf_c      ((PK_SURF_general_type_t) 23221)

/* PK_BSURF_fitted_t */

#define PK_BSURF_fitted_success_c             ((PK_BSURF_fitted_t) 23230)
#define PK_BSURF_fitted_failure_c             ((PK_BSURF_fitted_t) 23231)
#define PK_BSURF_fitted_eval_failure_c        ((PK_BSURF_fitted_t) 23232)
#define PK_BSURF_fitted_bad_range_c           ((PK_BSURF_fitted_t) 23233)
#define PK_BSURF_fitted_bad_tolerance_c       ((PK_BSURF_fitted_t) 23234)
#define PK_BSURF_fitted_bad_eval_type_c       ((PK_BSURF_fitted_t) 23235)
#define PK_BSURF_fitted_u_interp_parm_c       ((PK_BSURF_fitted_t) 23236)
#define PK_BSURF_fitted_v_interp_parm_c       ((PK_BSURF_fitted_t) 23237)

/* PK_sweep_guide_method_t */

#define PK_sweep_guide_point_c    ((PK_sweep_guide_method_t) 23250)
#define PK_sweep_guide_chord_c    ((PK_sweep_guide_method_t) 23251)
#define PK_sweep_guide_curve_c    ((PK_sweep_guide_method_t) 23252)
#define PK_sweep_guide_project_c  ((PK_sweep_guide_method_t) 23253)

/* PK_sweep_guide_clamp_type_t */

#define PK_sweep_guide_clamp_none_c   ((PK_sweep_guide_clamp_type_t) 23260)
#define PK_sweep_guide_clamp_dirn_c   ((PK_sweep_guide_clamp_type_t) 23261)
#define PK_sweep_guide_clamp_fixed_c  ((PK_sweep_guide_clamp_type_t) 23262)

/* PK_replace_variation_t */

#define PK_replace_variation_no_c     ((PK_replace_variation_t) 23280)
#define PK_replace_variation_yes_c    ((PK_replace_variation_t) 23281)

/* PK_sweep_guide_scale_t */

#define PK_sweep_guide_uniform_c  ((PK_sweep_guide_scale_t) 23290)
#define PK_sweep_guide_lateral_c  ((PK_sweep_guide_scale_t) 23291)

/* PK_sweep_clamp_type_t */

#define PK_sweep_clamp_none_c           ((PK_sweep_clamp_type_t) 23300)
#define PK_sweep_clamp_const_profile_c  ((PK_sweep_clamp_type_t) 23301)
#define PK_sweep_clamp_face_c           ((PK_sweep_clamp_type_t) 23302)

/* PK_PARTITION_copy_deltas_t */

#define PK_PARTITION_copy_deltas_none_c  ((PK_PARTITION_copy_deltas_t) 23310)
#define PK_PARTITION_copy_deltas_all_c   ((PK_PARTITION_copy_deltas_t) 23311)
#define PK_PARTITION_copy_deltas_main_c  ((PK_PARTITION_copy_deltas_t) 23312)
#define PK_PARTITION_copy_deltas_curr_c  ((PK_PARTITION_copy_deltas_t) 23313)

/* PK_thicken_update_t */

#define PK_thicken_update_0_c        ((PK_thicken_update_t) 23320)
#define PK_thicken_update_default_c  ((PK_thicken_update_t) 23321)

/* PK_imprint_tracking_t */

#define PK_imprint_tracking_basic_c     (( PK_imprint_tracking_t ) 23330)
#define PK_imprint_tracking_curves_c    (( PK_imprint_tracking_t ) 23331)

/* PK_blend_repair_fa_X_t */

#define PK_blend_repair_fa_X_no_c         ((PK_blend_repair_fa_X_t) 23340)
#define PK_blend_repair_fa_X_yes_c        ((PK_blend_repair_fa_X_t) 23341)

/* PK_replace_patch_t */

#define PK_replace_patch_no_c     ((PK_replace_patch_t) 23350)
#define PK_replace_patch_yes_c    ((PK_replace_patch_t) 23351)

/* PK_facet_sing_topol_t */

#define PK_facet_sing_topol_default_c   ((PK_facet_sing_topol_t) 23360)
#define PK_facet_sing_topol_degen_c     ((PK_facet_sing_topol_t) 23361)

/* PK_detail_perforated_t */

#define PK_detail_perforated_no_c       ((PK_detail_perforated_t) 23370)
#define PK_detail_perforated_yes_c      ((PK_detail_perforated_t) 23371)

/* PK_detail_open_t */

#define PK_detail_open_no_c             ((PK_detail_open_t) 23380)
#define PK_detail_open_yes_c            ((PK_detail_open_t) 23381)

/* PK_boolean_match_update_t */

#define PK_boolean_match_update_0_c        ((PK_boolean_match_update_t) 23390)
#define PK_boolean_match_update_dflt_c     ((PK_boolean_match_update_t) 23391)

/* PK_sweep_tool_fault_t */

#define PK_sweep_tool_bad_path_c         (( PK_sweep_tool_fault_t ) 23401)
#define PK_sweep_tool_bad_tool_c         (( PK_sweep_tool_fault_t ) 23402)
#define PK_sweep_tool_surf_failure_c     (( PK_sweep_tool_fault_t ) 23403)
#define PK_sweep_tool_check_failure_c    (( PK_sweep_tool_fault_t ) 23404)
#define PK_sweep_tool_geom_self_int_c    (( PK_sweep_tool_fault_t ) 23405)
#define PK_sweep_tool_topol_self_int_c   (( PK_sweep_tool_fault_t ) 23406)
#define PK_sweep_tool_geom_degen_c       (( PK_sweep_tool_fault_t ) 23407)
#define PK_sweep_tool_small_tool_c       (( PK_sweep_tool_fault_t ) 23408)
#define PK_sweep_tool_bad_lock_dir_c     (( PK_sweep_tool_fault_t ) 23409)
#define PK_sweep_tool_topol_change_c     (( PK_sweep_tool_fault_t ) 25530)

/* PK_imprint_proj_dist_t */

#define PK_imprint_proj_dist_no_c     (( PK_imprint_proj_dist_t ) 23430)
#define PK_imprint_proj_dist_whole_c  (( PK_imprint_proj_dist_t ) 23431)
#define PK_imprint_proj_dist_parts_c  (( PK_imprint_proj_dist_t ) 23432)

/* PK_ATTDEF_mismatch_t */

#define PK_ATTDEF_mismatch_fail_c       ((PK_ATTDEF_mismatch_t) 23440)
#define PK_ATTDEF_mismatch_ignore_c     ((PK_ATTDEF_mismatch_t) 23441)

/* PK_extend_closed_t */

#define PK_extend_closed_no_c            ((PK_extend_closed_t) 23450)
#define PK_extend_closed_non_periodic_c  ((PK_extend_closed_t) 23451)
#define PK_extend_closed_yes_c           ((PK_extend_closed_t) 23452)

/* PK_CURVE_sequential_t */

#define PK_CURVE_sequential_no_c   ((PK_CURVE_sequential_t) 23460)
#define PK_CURVE_sequential_yes_c  ((PK_CURVE_sequential_t) 23461)

/* PK_nm_edge_repair_t */

#define PK_nm_edge_repair_no_c     ((PK_nm_edge_repair_t) 23470)
#define PK_nm_edge_repair_blend_c  ((PK_nm_edge_repair_t) 23471)

/* PK_SESSION_binding_t */

#define PK_SESSION_binding_unknown_c        ((PK_SESSION_binding_t)23480)
#define PK_SESSION_binding_C_native_c       ((PK_SESSION_binding_t)23481)
#define PK_SESSION_binding_net_unsafe_c     ((PK_SESSION_binding_t)23482)
#define PK_SESSION_binding_net_safe_c       ((PK_SESSION_binding_t)23483)

/* PK_blend_ov_exp_cliff_t */

#define PK_blend_ov_exp_cliff_no_c  ((PK_blend_ov_exp_cliff_t) 23500)
#define PK_blend_ov_exp_cliff_yes_c ((PK_blend_ov_exp_cliff_t) 23501)

/* PK_PARTITION_type_t */

#define PK_PARTITION_type_standard_c        ((PK_PARTITION_type_t) 23510)
#define PK_PARTITION_type_light_c           ((PK_PARTITION_type_t) 23511)

/* PK_taper_keep_material_t */

#define PK_taper_keep_material_no_c        ((PK_taper_keep_material_t) 23520)
#define PK_taper_keep_material_yes_c       ((PK_taper_keep_material_t) 23521)

/* PK_emboss_unite_sidewall_t */

#define PK_emboss_unite_sidewall_yes_c   ((PK_emboss_unite_sidewall_t) 23530)
#define PK_emboss_unite_sidewall_no_c    ((PK_emboss_unite_sidewall_t) 23531)

/* PK_boolean_track_type_t */

#define PK_boolean_track_type_basic_c    ((PK_boolean_track_type_t) 23540)
#define PK_boolean_track_type_comp_c     ((PK_boolean_track_type_t) 23541)

/* PK_set_precision_method_t */

#define PK_set_precision_default_c         ((PK_set_precision_method_t) 23550)
#define PK_set_precision_c2_c              ((PK_set_precision_method_t) 23551)

/* PK_PMARK_new_at_mark_t */

#define PK_PMARK_new_at_current_mark_c      ((PK_PMARK_new_at_mark_t) 23560)
#define PK_PMARK_new_with_partition_c       ((PK_PMARK_new_at_mark_t) 23561)

/* PK_extend_track_type_t */

#define PK_extend_track_type_basic_c ((PK_extend_track_type_t) 23570 )
#define PK_extend_track_type_edges_c ((PK_extend_track_type_t) 23571 )

/* PK_extend_track_internal_t */

#define PK_extend_track_internal_no_c  ((PK_extend_track_internal_t) 23580)
#define PK_extend_track_internal_yes_c ((PK_extend_track_internal_t) 23581)

/* PK_EDGE_convexity_t */

#define PK_EDGE_convexity_smooth_flat_c  ((PK_EDGE_convexity_t) 23590)
#define PK_EDGE_convexity_smooth_cvx_c   ((PK_EDGE_convexity_t) 23591)
#define PK_EDGE_convexity_smooth_ccv_c   ((PK_EDGE_convexity_t) 23592)
#define PK_EDGE_convexity_smooth_inf_c   ((PK_EDGE_convexity_t) 23593)
#define PK_EDGE_convexity_smooth_var_c   ((PK_EDGE_convexity_t) 23594)
#define PK_EDGE_convexity_knife_cvx_c    ((PK_EDGE_convexity_t) 23595)
#define PK_EDGE_convexity_knife_ccv_c    ((PK_EDGE_convexity_t) 23596)
#define PK_EDGE_convexity_convex_c       ((PK_EDGE_convexity_t) 23597)
#define PK_EDGE_convexity_concave_c      ((PK_EDGE_convexity_t) 23598)
#define PK_EDGE_convexity_variable_c     ((PK_EDGE_convexity_t) 23599)

/* PK_sweep_lock_t */

#define PK_sweep_lock_path_and_dir_c ((PK_sweep_lock_t) 23600)
#define PK_sweep_lock_path_c         ((PK_sweep_lock_t) 23601)
#define PK_sweep_lock_rotation_c     ((PK_sweep_lock_t) 23602)

/* PK_force_continuity_t */

#define PK_force_continuity_no_c     ((PK_force_continuity_t) 23610)
#define PK_force_continuity_prefer_c ((PK_force_continuity_t) 23611)
#define PK_force_continuity_yes_c    ((PK_force_continuity_t) 23612)

/* PK_SURF_make_bsurf_t */

#define PK_SURF_make_bsurf_exact_c     ((PK_SURF_make_bsurf_t) 23620)
#define PK_SURF_make_bsurf_approx_c    ((PK_SURF_make_bsurf_t) 23621)
#define PK_SURF_make_bsurf_too_tight_c ((PK_SURF_make_bsurf_t) 23622)

/* PK_achieved_cont_t */

#define PK_achieved_cont_yes_c ((PK_achieved_cont_t) 23630)
#define PK_achieved_cont_no_c  ((PK_achieved_cont_t) 23631)

/* PK_make_spcurves_method_t */

#define PK_make_spcurves_method_dflt_c     ((PK_make_spcurves_method_t) 23640)
#define PK_make_spcurves_method_c2_c       ((PK_make_spcurves_method_t) 23641)

/* PK_check_nmnl_geom_t */

#define PK_check_nmnl_geom_no_c     ((PK_check_nmnl_geom_t) 23650)
#define PK_check_nmnl_geom_yes_c    ((PK_check_nmnl_geom_t) 23651)

/* PK_check_returns_t */

#define PK_check_returns_latest_c   ((PK_check_returns_t) 23660)
#define PK_check_returns_0_c        ((PK_check_returns_t) 23661)
#define PK_check_returns_1_c        ((PK_check_returns_t) 23662)
#define PK_check_returns_2_c        ((PK_check_returns_t) 23663)

/* PK_make_spcurves_degen_t */

#define PK_make_spcurves_degen_no_c     ((PK_make_spcurves_degen_t) 23670)
#define PK_make_spcurves_degen_join_c   ((PK_make_spcurves_degen_t) 23671)

/* PK_LOOP_3_space_gap_t */

#define PK_LOOP_3_space_gap_no_c        ((PK_LOOP_3_space_gap_t) 23680)
#define PK_LOOP_3_space_gap_close_c     ((PK_LOOP_3_space_gap_t) 23681)

/* PK_LOOP_2_space_gap_t */

#define PK_LOOP_2_space_gap_no_c        ((PK_LOOP_2_space_gap_t) 23690)
#define PK_LOOP_2_space_gap_minimise_c  ((PK_LOOP_2_space_gap_t) 23691)
#define PK_LOOP_2_space_gap_close_cu_c  ((PK_LOOP_2_space_gap_t) 23692)
#define PK_LOOP_2_space_gap_close_all_c ((PK_LOOP_2_space_gap_t) 23693)

/* PK_sweep_output_xsect_t */

#define PK_sweep_output_xsect_no_c      ((PK_sweep_output_xsect_t) 23700)
#define PK_sweep_output_xsect_yes_c     ((PK_sweep_output_xsect_t) 23701)
#define PK_sweep_output_xsect_on_fail_c ((PK_sweep_output_xsect_t) 23702)

/* PK_sweep_group_xsect_t */

#define PK_sweep_group_xsect_per_vx_c   ((PK_sweep_group_xsect_t) 23710)
#define PK_sweep_group_xsect_per_edge_c ((PK_sweep_group_xsect_t) 23711)
#define PK_sweep_group_xsect_no_c       ((PK_sweep_group_xsect_t) 23712)

/* PK_FACE_change_update_t */

#define PK_FACE_change_update_0_c          ((PK_FACE_change_update_t) 23720)
#define PK_FACE_change_update_default_c    ((PK_FACE_change_update_t) 23729)

/* PK_set_precision_report_t */

#define PK_set_precision_report_no_c       ((PK_set_precision_report_t) 23730)
#define PK_set_precision_report_yes_c      ((PK_set_precision_report_t) 23731)

/* PK_FACE_overflow_t */

#define PK_FACE_overflow_tangent_c    ((PK_FACE_overflow_t) 23740)
#define PK_FACE_overflow_ruled_c      ((PK_FACE_overflow_t) 23741)
#define PK_FACE_overflow_swept_c      ((PK_FACE_overflow_t) 23742)
#define PK_FACE_overflow_added_c      ((PK_FACE_overflow_t) 23743)
#define PK_FACE_overflow_mixed_c      ((PK_FACE_overflow_t) 23744)
#define PK_FACE_overflow_none_c       ((PK_FACE_overflow_t) 23745)

/* PK_render_ske_missing_t  (23750-23759 allocated) */

#define PK_render_ske_missing_no_c      ((PK_render_ske_missing_t) 23750)
#define PK_render_ske_missing_yes_c     ((PK_render_ske_missing_t) 23751)

/* PK_range_opt_t  (23760-23769 allocated) */

#define PK_range_opt_performance_c                 ((PK_range_opt_t) 23760)
#define PK_range_opt_accuracy_c                    ((PK_range_opt_t) 23761)

/* PK_general_t */

#define PK_general_nm_edge_c            ((PK_general_t) 23770)
#define PK_general_nm_vertex_c          ((PK_general_t) 23771)
#define PK_general_opposed_faces_c      ((PK_general_t) 23772)
#define PK_general_solid_internal_c     ((PK_general_t) 23773)
#define PK_general_mixed_dimension_c    ((PK_general_t) 23774)
#define PK_general_wire_in_solid_c      ((PK_general_t) 23775)

/* PK_self_int_type_t */

#define PK_self_int_type_general_c    ((PK_self_int_type_t) 23780)
#define PK_self_int_type_sing_c       ((PK_self_int_type_t) 23781)
#define PK_self_int_type_mixed_c      ((PK_self_int_type_t) 23782)

/* PK_blend_prevent_sharp_t */

#define PK_blend_prevent_sharp_no_c       ((PK_blend_prevent_sharp_t) 23790)
#define PK_blend_prevent_sharp_yes_c      ((PK_blend_prevent_sharp_t) 23791)
#define PK_blend_prevent_sharp_report_c   ((PK_blend_prevent_sharp_t) 23792)

/* PK_extension_limit_t */

#define PK_extension_limit_minimal_c      ((PK_extension_limit_t) 23800)
#define PK_extension_limit_inside_c       ((PK_extension_limit_t) 23801)
#define PK_extension_limit_outside_c      ((PK_extension_limit_t) 23802)

/* PK_GEOM_transform_t */

#define PK_GEOM_transform_modify_c     ((PK_GEOM_transform_t)23820)
#define PK_GEOM_transform_new_c        ((PK_GEOM_transform_t)23821)

/* PK_hollow_local_t */

#define PK_hollow_local_add_c     (( PK_hollow_local_t ) 23830 )
#define PK_hollow_local_exclude_c (( PK_hollow_local_t ) 23831 )
#define PK_hollow_local_none_c    (( PK_hollow_local_t ) 23832 )

/* PK_FACE_prefer_adj_t */

#define PK_FACE_prefer_adj_keep_c     ((PK_FACE_prefer_adj_t) 23840)
#define PK_FACE_prefer_adj_change_c   ((PK_FACE_prefer_adj_t) 23841)

/* PK_REPORT_record_type_t */

#define PK_REPORT_record_type_1_c  ((PK_REPORT_record_type_t) 23850)
#define PK_REPORT_record_type_2_c  ((PK_REPORT_record_type_t) 23851)
#define PK_REPORT_record_type_3_c  ((PK_REPORT_record_type_t) 23852)

/* PK_REPORT_1_t */

#define PK_REPORT_1_ok_c                ((PK_REPORT_1_t) 23870)
#define PK_REPORT_1_nocheck_c           ((PK_REPORT_1_t) 23871)
#define PK_REPORT_1_fail_c              ((PK_REPORT_1_t) 23872)
#define PK_REPORT_1_cant_get_pt_c       ((PK_REPORT_1_t) 23873)
#define PK_REPORT_1_cant_get_cu_c       ((PK_REPORT_1_t) 23874)
#define PK_REPORT_1_cant_get_su_c       ((PK_REPORT_1_t) 23875)
#define PK_REPORT_1_cant_offset_c       ((PK_REPORT_1_t) 23876)
#define PK_REPORT_1_side_cu_fail_c      ((PK_REPORT_1_t) 23877)
#define PK_REPORT_1_side_su_fail_c      ((PK_REPORT_1_t) 23878)
#define PK_REPORT_1_not_same_by_c       ((PK_REPORT_1_t) 23879)
#define PK_REPORT_1_fa_fail_c           ((PK_REPORT_1_t) 23880)
#define PK_REPORT_1_fa_fa_fail_c        ((PK_REPORT_1_t) 23881)
#define PK_REPORT_1_ed_remains_c        ((PK_REPORT_1_t) 23882)
#define PK_REPORT_1_point_contact_c     ((PK_REPORT_1_t) 23883)
#define PK_REPORT_1_bad_reference_c     ((PK_REPORT_1_t) 23884)
#define PK_REPORT_1_not_supported_c     ((PK_REPORT_1_t) 23885)
#define PK_REPORT_1_cant_extend_c       ((PK_REPORT_1_t) 23886)
#define PK_REPORT_1_sheet_small_c       ((PK_REPORT_1_t) 23887)
#define PK_REPORT_1_cant_use_cu_c       ((PK_REPORT_1_t) 23888)
#define PK_REPORT_1_eds_unconnected_c   ((PK_REPORT_1_t) 23889)
#define PK_REPORT_1_non_laminar_c       ((PK_REPORT_1_t) 23890)
#define PK_REPORT_1_reference_loop_c    ((PK_REPORT_1_t) 23891)
#define PK_REPORT_1_lp_outside_fa_c     ((PK_REPORT_1_t) 23892)
#define PK_REPORT_1_target_missed_c     ((PK_REPORT_1_t) 23893)
#define PK_REPORT_1_wrong_side_c        ((PK_REPORT_1_t) 23894)
#define PK_REPORT_1_ed_vxs_touch_c      ((PK_REPORT_1_t) 23895)
#define PK_REPORT_1_ed_large_tol_c      ((PK_REPORT_1_t) 23896)
#define PK_REPORT_1_vx_large_tol_c      ((PK_REPORT_1_t) 23897)
#define PK_REPORT_1_negated_c           ((PK_REPORT_1_t) 23898)
#define PK_REPORT_1_check_fail_c        ((PK_REPORT_1_t) 23899)
#define PK_REPORT_1_fa_overlap_c        ((PK_REPORT_1_t) 23900)
#define PK_REPORT_1_osthread_fail_c     ((PK_REPORT_1_t) 23901)
#define PK_REPORT_1_osthread_ok_c       ((PK_REPORT_1_t) 23902)
#define PK_REPORT_1_imp_dir_undef_c     ((PK_REPORT_1_t) 23903)
#define PK_REPORT_1_fa_fix_degens_c     ((PK_REPORT_1_t) 23904)
#define PK_REPORT_1_fa_sx_repair_c      ((PK_REPORT_1_t) 23905)
#define PK_REPORT_1_fa_not_offset_c     ((PK_REPORT_1_t) 23906)
#define PK_REPORT_1_fa_fa_repair_c      ((PK_REPORT_1_t) 23907)
#define PK_REPORT_1_rep_sx_faces_c      ((PK_REPORT_1_t) 23908)
#define PK_REPORT_1_rep_G2_faces_c      ((PK_REPORT_1_t) 23909)
#define PK_REPORT_1_deform_surf_c       ((PK_REPORT_1_t) 23910)
#define PK_REPORT_1_blend_too_tight_c   ((PK_REPORT_1_t) 23911)
#define PK_REPORT_1_cant_make_blend_c   ((PK_REPORT_1_t) 23912)
#define PK_REPORT_1_bad_chamfer_c       ((PK_REPORT_1_t) 23913)
#define PK_REPORT_1_bad_blend_c         ((PK_REPORT_1_t) 23914)
#define PK_REPORT_1_not_blend_surf_c    ((PK_REPORT_1_t) 23915)
#define PK_REPORT_1_cut_no_clash_c      ((PK_REPORT_1_t) 23916)
#define PK_REPORT_1_cut_incomplete_c    ((PK_REPORT_1_t) 23917)
#define PK_REPORT_1_cut_unclassed_c     ((PK_REPORT_1_t) 23918)
#define PK_REPORT_1_inconsistent_geom_c ((PK_REPORT_1_t) 23919)
#define PK_REPORT_1_region_type_undef_c ((PK_REPORT_1_t) 23920)

/* PK_sweep_repair_t */

#define PK_sweep_repair_no_c      ((PK_sweep_repair_t) 23970)
#define PK_sweep_repair_yes_c     ((PK_sweep_repair_t) 23971)
#define PK_sweep_repair_report_c  ((PK_sweep_repair_t) 23972)

/* PK_track_edges_t */

#define PK_track_edges_yes_c     ((PK_track_edges_t) 23980)
#define PK_track_edges_no_c      ((PK_track_edges_t) 23981)

/* PK_track_vertices_t */

#define PK_track_vertices_yes_c     ((PK_track_vertices_t) 23990)
#define PK_track_vertices_no_c      ((PK_track_vertices_t) 23991)

/* PK_BSURF_constrained_t */

#define PK_BSURF_constrained_success_c      ((PK_BSURF_constrained_t) 24000)
#define PK_BSURF_constrained_failure_c      ((PK_BSURF_constrained_t) 24001)
#define PK_BSURF_constrained_not_fit_c      ((PK_BSURF_constrained_t) 24002)

/* PK_BCURVE_clamp_t */

#define PK_BCURVE_clamp_no_c          ((PK_BCURVE_clamp_t) 24010)
#define PK_BCURVE_clamp_extreme_c     ((PK_BCURVE_clamp_t) 24011)
#define PK_BCURVE_clamp_constant_c    ((PK_BCURVE_clamp_t) 24012)

/* PK_fix_method_t */

#define PK_fix_method_extract_c    ((PK_fix_method_t) 24020)
#define PK_fix_method_approx_c     ((PK_fix_method_t) 24021)

/* PK_SURF_fix_fault_t */

#define PK_SURF_fix_fault_ok_c            ((PK_SURF_fix_fault_t) 24030)
#define PK_SURF_fix_fault_incomplete_c    ((PK_SURF_fix_fault_t) 24031)

/* PK_CURVE_fix_fault_t */

#define PK_CURVE_fix_fault_ok_c            ((PK_CURVE_fix_fault_t) 24040)
#define PK_CURVE_fix_fault_incomplete_c    ((PK_CURVE_fix_fault_t) 24041)

/* PK_SURF_split_t */

#define PK_SURF_split_prefer_u_c    ((PK_SURF_split_t) 24050)
#define PK_SURF_split_prefer_v_c    ((PK_SURF_split_t) 24051)
#define PK_SURF_split_only_u_c      ((PK_SURF_split_t) 24052)
#define PK_SURF_split_only_v_c      ((PK_SURF_split_t) 24053)

/* PK_fix_status_t */

#define PK_fix_status_exact_c        ((PK_fix_status_t) 24060)
#define PK_fix_status_approx_c       ((PK_fix_status_t) 24061)
#define PK_fix_status_too_tight_c    ((PK_fix_status_t) 24062)

/* PK_DEBUG_try_smp_t */

#define PK_DEBUG_try_smp_no_c       ((PK_DEBUG_try_smp_t) 24070)
#define PK_DEBUG_try_smp_A_c        ((PK_DEBUG_try_smp_t) 24071)
#define PK_DEBUG_try_smp_B_c        ((PK_DEBUG_try_smp_t) 24072)

/* PK_transform_step_t */

#define PK_transform_step_no_c          ((PK_transform_step_t) 24080)
#define PK_transform_step_smooth_c      ((PK_transform_step_t) 24081)
#define PK_transform_step_all_c         ((PK_transform_step_t) 24082)
#define PK_transform_step_not_coi_c     ((PK_transform_step_t) 24083)
#define PK_transform_step_smooth_site_c ((PK_transform_step_t) 24084)

/* PK_blend_track_edges_t  */

#define PK_blend_track_edges_no_c      ((PK_blend_track_edges_t) 24090)
#define PK_blend_track_edges_laminar_c ((PK_blend_track_edges_t) 24091)

/* PK_blend_delete_cap_t */

#define PK_blend_delete_cap_no_c      (( PK_blend_delete_cap_t ) 24100)
#define PK_blend_delete_cap_planar_c  (( PK_blend_delete_cap_t ) 24109)

/* PK_facet_smp_t (24110-24111) allocated */

#define PK_facet_smp_no_c   ((PK_facet_smp_t) 24110)
#define PK_facet_smp_body_c ((PK_facet_smp_t) 24111)

/* PK_FACE_grow_t */

#define PK_FACE_grow_update_c     ((PK_FACE_grow_t) 24120)
#define PK_FACE_grow_auto_c       ((PK_FACE_grow_t) 24121)
#define PK_FACE_grow_moving_c     ((PK_FACE_grow_t) 24122)
#define PK_FACE_grow_fixed_c      ((PK_FACE_grow_t) 24123)
#define PK_FACE_grow_no_c         ((PK_FACE_grow_t) 24124)
#define PK_FACE_grow_fail_c       ((PK_FACE_grow_t) 24125)

/* PK_blend_tolerance_t */

#define PK_blend_tolerance_standard_c ((PK_blend_tolerance_t) 24130)
#define PK_blend_tolerance_improved_c ((PK_blend_tolerance_t) 24131)

/* PK_offset_track_del_t */

#define PK_offset_track_del_no_c        ((PK_offset_track_del_t) 24140)
#define PK_offset_track_del_sx_repair_c ((PK_offset_track_del_t) 24141)

/* PK_extend_create_t */

#define PK_extend_create_new_c   ((PK_extend_create_t) 24150)
#define PK_extend_create_split_c ((PK_extend_create_t) 24151)

/* PK_blend_follow_branch_t */

#define PK_blend_follow_branch_yes_c   ((PK_blend_follow_branch_t) 24160)
#define PK_blend_follow_branch_no_c    ((PK_blend_follow_branch_t) 24161)

/* PK_BCURVE_spline_stat_t */

#define PK_BCURVE_spline_stat_exact_c      ((PK_BCURVE_spline_stat_t) 24170)
#define PK_BCURVE_spline_stat_approx_c     ((PK_BCURVE_spline_stat_t) 24171)
#define PK_BCURVE_spline_stat_not_fit_c    ((PK_BCURVE_spline_stat_t) 24172)

/* PK_spline_method_t */

#define PK_spline_method_interpolate_c    ((PK_spline_method_t) 24180)
#define PK_spline_method_fit_c            ((PK_spline_method_t) 24181)

/* PK_BODY_sewing_assy_t */

#define PK_BODY_sewing_assy_no_c         ((PK_BODY_sewing_assy_t) 24190)
#define PK_BODY_sewing_assy_orient_c     ((PK_BODY_sewing_assy_t) 24191)
#define PK_BODY_sewing_assy_extend_c     ((PK_BODY_sewing_assy_t) 24192)

/* PK_LOOP_trim_geom_t */

#define PK_LOOP_trim_geom_no_c       ((PK_LOOP_trim_geom_t) 24200)
#define PK_LOOP_trim_geom_yes_c      ((PK_LOOP_trim_geom_t) 24201)

/* PK_blend_track_type_t */

#define PK_blend_track_type_basic_c  ((PK_blend_track_type_t) 24210)
#define PK_blend_track_type_unders_c ((PK_blend_track_type_t) 24211)

/* PK_ENTITY_track_t */

#define PK_ENTITY_track_delete_c        (( PK_ENTITY_track_t ) 24230)
#define PK_ENTITY_track_merge_c         (( PK_ENTITY_track_t ) 24231)
#define PK_ENTITY_track_create_c        (( PK_ENTITY_track_t ) 24232)
#define PK_ENTITY_track_split_c         (( PK_ENTITY_track_t ) 24233)
#define PK_ENTITY_track_derive_c        (( PK_ENTITY_track_t ) 24234)

/* PK_BODY_sewing_gen_t */

#define PK_BODY_sewing_gen_no_c          ((PK_BODY_sewing_gen_t) 24240)
#define PK_BODY_sewing_gen_loc_manf_c    ((PK_BODY_sewing_gen_t) 24241)

/* PK_blend_delete_keep_t */

#define PK_blend_delete_keep_no_c    (( PK_blend_delete_keep_t ) 24250)
#define PK_blend_delete_keep_yes_c   (( PK_blend_delete_keep_t ) 24251)

/* PK_REPORT_2_t */

#define PK_REPORT_2_grow_fail_c     ((PK_REPORT_2_t) 24260)
#define PK_REPORT_2_grow_1_c        ((PK_REPORT_2_t) 24261)
#define PK_REPORT_2_grow_2_c        ((PK_REPORT_2_t) 24262)
#define PK_REPORT_2_grow_no_c       ((PK_REPORT_2_t) 24263)
#define PK_REPORT_2_shared_geometry_c    ((PK_REPORT_2_t) 24264)

/* PK_extension_boundary_t */

#define PK_extension_boundary_precise_c   ((PK_extension_boundary_t) 24270)
#define PK_extension_boundary_loose_c     ((PK_extension_boundary_t) 24271)

/* PK_VERTEX_limit_t */

#define PK_VERTEX_limit_no_c          ((PK_VERTEX_limit_t) 24280)
#define PK_VERTEX_limit_report_c      ((PK_VERTEX_limit_t) 24281)
#define PK_VERTEX_limit_yes_c         ((PK_VERTEX_limit_t) 24282)

/* PK_FACE_grow_cb_t */

#define PK_FACE_grow_cb_default_c    ((PK_FACE_grow_cb_t) 24290)
#define PK_FACE_grow_cb_auto_c       ((PK_FACE_grow_cb_t) 24291)
#define PK_FACE_grow_cb_faces1_c     ((PK_FACE_grow_cb_t) 24292)
#define PK_FACE_grow_cb_faces2_c     ((PK_FACE_grow_cb_t) 24293)
#define PK_FACE_grow_cb_no_c         ((PK_FACE_grow_cb_t) 24294)
#define PK_FACE_grow_cb_fail_c       ((PK_FACE_grow_cb_t) 24295)

/* PK_spline_update_t */

#define PK_spline_update_0_c       ((PK_spline_update_t) 24300)
#define PK_spline_update_1_c       ((PK_spline_update_t) 24301)
#define PK_spline_update_default_c ((PK_spline_update_t) 24302)

/* PK_sweep_profile_law_t */

#define PK_sweep_profile_law_no_c  ((PK_sweep_profile_law_t) 24310)
#define PK_sweep_profile_law_yes_c ((PK_sweep_profile_law_t) 24311)

/* PK_EDGE_limit_t */

#define PK_EDGE_limit_no_c          ((PK_EDGE_limit_t) 24320)
#define PK_EDGE_limit_report_c      ((PK_EDGE_limit_t) 24321)
#define PK_EDGE_limit_yes_c         ((PK_EDGE_limit_t) 24322)

/* PK_TOPOL_dimension_t */

#define PK_TOPOL_dimension_0_c   ((PK_TOPOL_dimension_t) 24340)
#define PK_TOPOL_dimension_1_c   ((PK_TOPOL_dimension_t) 24341)
#define PK_TOPOL_dimension_2_c   ((PK_TOPOL_dimension_t) 24342)
#define PK_TOPOL_dimension_any_c ((PK_TOPOL_dimension_t) 24343)

/* PK_redundant_merge_t */

#define PK_redundant_merge_in_c     ((PK_redundant_merge_t) 24350)
#define PK_redundant_merge_on_c     ((PK_redundant_merge_t) 24351)
#define PK_redundant_merge_out_c    ((PK_redundant_merge_t) 24352)

/* PK_repair_fa_fa_t */

#define PK_repair_fa_fa_no_c           ((PK_repair_fa_fa_t) 24360)
#define PK_repair_fa_fa_yes_c          ((PK_repair_fa_fa_t) 24361)

/* PK_neutral_ignore_fa_t */

#define PK_neutral_ignore_fa_no_c      ((PK_neutral_ignore_fa_t) 24370)
#define PK_neutral_ignore_fa_default_c ((PK_neutral_ignore_fa_t) 24371)

/* PK_blend_trim_extent_t */

#define PK_blend_trim_extent_all_c      ((PK_blend_trim_extent_t) 24380)
#define PK_blend_trim_extent_sides_c    ((PK_blend_trim_extent_t) 24381)

/* PK_redundant_propagate_t */

#define PK_redundant_propagate_no_c      ((PK_redundant_propagate_t) 24390)
#define PK_redundant_propagate_yes_c     ((PK_redundant_propagate_t) 24391)

/* PK_REPORT_3_t */

#define PK_REPORT_3_unset_c               ((PK_REPORT_3_t) 24400)
#define PK_REPORT_3_surf_extended_c       ((PK_REPORT_3_t) 24401)
#define PK_REPORT_3_blend_limit_topol_c   ((PK_REPORT_3_t) 24402)
#define PK_REPORT_3_blend_limit_data_c    ((PK_REPORT_3_t) 24403)
#define PK_REPORT_3_discontinuities_c     ((PK_REPORT_3_t) 24404)
#define PK_REPORT_3_neutral_face_data_c   ((PK_REPORT_3_t) 24405)
#define PK_REPORT_3_distance_err_c        ((PK_REPORT_3_t) 24406)
#define PK_REPORT_3_worse_curvature_c     ((PK_REPORT_3_t) 24407)
#define PK_REPORT_3_cover_surf_c          ((PK_REPORT_3_t) 24408)
#define PK_REPORT_3_sharp_eds_c           ((PK_REPORT_3_t) 24409)
#define PK_REPORT_3_tight_curvature_c     ((PK_REPORT_3_t) 24410)
#define PK_REPORT_3_proj_cu_split_c       ((PK_REPORT_3_t) 24411)
#define PK_REPORT_3_geom_extended_c       ((PK_REPORT_3_t) 24412)
#define PK_REPORT_3_blend_x_g1_c          ((PK_REPORT_3_t) 24413)
#define PK_REPORT_3_compound_split_c      ((PK_REPORT_3_t) 24415)
#define PK_REPORT_3_fill_hole_non_g2_c    ((PK_REPORT_3_t) 24416)
#define PK_REPORT_3_identified_blend_c    ((PK_REPORT_3_t) 24417)
#define PK_REPORT_3_line_fit_tols_c       ((PK_REPORT_3_t) 24418)


/* PK_FACE_trim_cb_t */

#define PK_FACE_trim_cb_auto_c    ((PK_FACE_trim_cb_t) 24420)
#define PK_FACE_trim_cb_fail_c    ((PK_FACE_trim_cb_t) 24421)

/* PK_patch_mobility_t */

#define PK_patch_mobility_fixed_c  ((PK_patch_mobility_t) 24430)
#define PK_patch_mobility_moving_c ((PK_patch_mobility_t) 24431)

/* PK_deform_uv_t */

#define PK_deform_uv_face_box_c    ((PK_deform_uv_t) 24440)
#define PK_deform_uv_all_c         ((PK_deform_uv_t) 24441)

/* PK_BODY_sweep_update_t */

#define PK_BODY_sweep_update_0_c       ((PK_BODY_sweep_update_t) 24450)
#define PK_BODY_sweep_update_default_c ((PK_BODY_sweep_update_t) 24451)
#define PK_BODY_sweep_update_1_c       ((PK_BODY_sweep_update_t) 24452)
#define PK_BODY_sweep_update_2_c       ((PK_BODY_sweep_update_t) 24453)
#define PK_BODY_sweep_update_3_c       ((PK_BODY_sweep_update_t) 24454)

/* PK_instance_repair_fa_fa_t */

#define PK_instance_repair_fa_fa_no_c  (( PK_instance_repair_fa_fa_t ) 24460)
#define PK_instance_repair_fa_fa_yes_c (( PK_instance_repair_fa_fa_t ) 24461)

/* PK_instance_track_type_t */

#define PK_instance_track_type_none_c   ((PK_instance_track_type_t) 24470)
#define PK_instance_track_type_inst_c   ((PK_instance_track_type_t) 24471)
#define PK_instance_track_type_topol_c  ((PK_instance_track_type_t) 24472)
#define PK_instance_track_type_both_c   ((PK_instance_track_type_t) 24473)

/* PK_instance_merge_t */

#define PK_instance_merge_no_c          (( PK_instance_merge_t ) 24480)
#define PK_instance_merge_new_c         (( PK_instance_merge_t ) 24481)

/* PK_DEBUG_report_cb_t */

#define PK_DEBUG_report_cb_no_c         ((PK_DEBUG_report_cb_t) 24490)
#define PK_DEBUG_report_cb_function_c   ((PK_DEBUG_report_cb_t) 24491)

/* PK_neutral_trim_method_t */

#define PK_neutral_trim_method_sheets_c ((PK_neutral_trim_method_t) 24500)
#define PK_neutral_trim_method_sides_c  ((PK_neutral_trim_method_t) 24501)

/* PK_fill_hole_body_type_t */

#define PK_fill_hole_body_type_orig_c      ((PK_fill_hole_body_type_t) 24510)
#define PK_fill_hole_body_type_sheet_c     ((PK_fill_hole_body_type_t) 24511)
#define PK_fill_hole_body_type_solid_c     ((PK_fill_hole_body_type_t) 24512)

/* PK_instance_track_edges_t */

#define PK_instance_track_edges_no_c        ((PK_instance_track_edges_t) 24520)
#define PK_instance_track_edges_laminar_c   ((PK_instance_track_edges_t) 24521)
#define PK_instance_track_edges_new_c       ((PK_instance_track_edges_t) 24522)

/* PK_outline_update_t */

#define PK_outline_update_default_c  ((PK_outline_update_t) 24531)
#define PK_outline_update_0_c        ((PK_outline_update_t) 24530)
#define PK_outline_update_1_c        ((PK_outline_update_t) 24532)
#define PK_outline_update_2_c        ((PK_outline_update_t) 24533)
#define PK_outline_update_3_c        ((PK_outline_update_t) 24534)
#define PK_outline_update_4_c        ((PK_outline_update_t) 24535)
#define PK_outline_update_5_c        ((PK_outline_update_t) 24536)
#define PK_outline_update_6_c        ((PK_outline_update_t) 24537)
#define PK_outline_update_7_c        ((PK_outline_update_t) 24538)

/* PK_neutral_overlap_t */

#define PK_neutral_overlap_no_c         ((PK_neutral_overlap_t) 24540)
#define PK_neutral_overlap_report_c     ((PK_neutral_overlap_t) 24541)
#define PK_neutral_overlap_repair_c     ((PK_neutral_overlap_t) 24542)

/* PK_isoparam_prefer_t */

#define PK_isoparam_prefer_simple_c            ((PK_isoparam_prefer_t) 24550)
#define PK_isoparam_prefer_bcurve_c            ((PK_isoparam_prefer_t) 24551)
#define PK_isoparam_prefer_spcurve_c           ((PK_isoparam_prefer_t) 24552)

/* PK_THREAD_exclusion_t */

#define PK_THREAD_exclusion_none_c      ((PK_THREAD_exclusion_t) 24560)
#define PK_THREAD_exclusion_serious_c   ((PK_THREAD_exclusion_t) 24561)
#define PK_THREAD_exclusion_fatal_c     ((PK_THREAD_exclusion_t) 24562)

/* PK_facet_pt_report_m */

#define PK_facet_pt_report_no_c        ((PK_facet_pt_report_t) 24570)
#define PK_facet_pt_report_off_eds_c   ((PK_facet_pt_report_t) 24571)
#define PK_facet_pt_report_off_tpl_c   ((PK_facet_pt_report_t) 24572)

/* PK_imprint_intersect_t */

#define PK_imprint_intersect_update_c    ((PK_imprint_intersect_t) 24580)
#define PK_imprint_intersect_fail_c      ((PK_imprint_intersect_t) 24581)
#define PK_imprint_intersect_fix_c       ((PK_imprint_intersect_t) 24582)

/* PK_SHELL_repair_tracking_t */

#define  PK_SHELL_repair_tracking_no_c    ((PK_SHELL_repair_tracking_t) 24590)
#define  PK_SHELL_repair_tracking_yes_c   ((PK_SHELL_repair_tracking_t) 24591)

/* PK_SHELL_repair_stat_t */

#define  PK_SHELL_repair_stat_ok_c      ((PK_SHELL_repair_stat_t) 24600)
#define  PK_SHELL_repair_stat_no_fix_c  ((PK_SHELL_repair_stat_t) 24601)
#define  PK_SHELL_repair_stat_invalid_c ((PK_SHELL_repair_stat_t) 24602)

/* PK_SURF_degen_type_t */

#define PK_SURF_degen_type_param_c         ((PK_SURF_degen_type_t) 24610)
#define PK_SURF_degen_type_phys_cvx_c      ((PK_SURF_degen_type_t) 24611)
#define PK_SURF_degen_type_phys_ccv_c      ((PK_SURF_degen_type_t) 24612)
#define PK_SURF_degen_type_phys_mixed_c    ((PK_SURF_degen_type_t) 24613)
#define PK_SURF_degen_type_phys_undef_c    ((PK_SURF_degen_type_t) 24614)

/* PK_check_state_t */

#define PK_ASSEMBLY_state_bad_type_c    ((PK_check_state_t) 24620   )
#define PK_ASSEMBLY_state_cyclic_ref_c  ((PK_check_state_t) 24621   )
#define PK_BODY_state_bad_type_c        ((PK_check_state_t) 24622   )
#define PK_BODY_state_no_region_c       ((PK_check_state_t) 24623   )
#define PK_BODY_state_no_shell_c        ((PK_check_state_t) 24624   )
#define PK_BODY_state_no_solid_reg_c    ((PK_check_state_t) 24625   )
#define PK_BODY_state_region_1_solid_c  ((PK_check_state_t) 24626   )
#define PK_BODY_state_shell_not_first_c ((PK_check_state_t) 24627   )
#define PK_BODY_state_wrong_ext_reg_c   ((PK_check_state_t) 24628   )
#define PK_BODY_state_wrong_num_regs_c  ((PK_check_state_t) 24629   )
#define PK_EDGE_state_bad_fins_c        ((PK_check_state_t) 24630   )
#define PK_EDGE_state_bad_tol_c         ((PK_check_state_t) 24631   )
#define PK_EDGE_state_fin_bad_ring_c    ((PK_check_state_t) 24632   )
#define PK_EDGE_state_fin_ed_next_pos_c ((PK_check_state_t) 24633   )
#define PK_EDGE_state_fin_ed_not_ed_c   ((PK_check_state_t) 24634   )
#define PK_EDGE_state_fin_not_pos_c     ((PK_check_state_t) 24635   )
#define PK_EDGE_state_single_vertex_c   ((PK_check_state_t) 24636   )
#define PK_EDGE_state_wire_corrupt_c    ((PK_check_state_t) 24637   )
#define PK_ENTITY_state_bad_owner_c     ((PK_check_state_t) 24639   )
#define PK_ENTITY_state_has_att_group_c ((PK_check_state_t) 24640   )
#define PK_ENTITY_state_shared_c        ((PK_check_state_t) 24641   )
#define PK_FACE_state_diff_sh_same_rg_c ((PK_check_state_t) 24642   )
#define PK_FACE_state_edge_moebius_c    ((PK_check_state_t) 24643   )
#define PK_FACE_state_wrong_sense_c     ((PK_check_state_t) 24646   )
#define PK_FIN_state_bad_c              ((PK_check_state_t) 24647   )
#define PK_FIN_state_bad_ed_fins_c      ((PK_check_state_t) 24648   )
#define PK_FIN_state_corrupt_c          ((PK_check_state_t) 24649   )
#define PK_FIN_state_ed_next_is_fin_c   ((PK_check_state_t) 24650   )
#define PK_FIN_state_edge_diff_vertex_c ((PK_check_state_t) 24651   )
#define PK_FIN_state_no_ed_next_in_sh_c ((PK_check_state_t) 24652   )
#define PK_FIN_state_non_zero_ident_c   ((PK_check_state_t) 24653   )
#define PK_FIN_state_not_ed_next_prev_c ((PK_check_state_t) 24654   )
#define PK_FIN_state_not_lp_next_prev_c ((PK_check_state_t) 24655   )
#define PK_FIN_state_vx_not_vx_c        ((PK_check_state_t) 24656   )
#define PK_FIN_state_wrong_vertex_c     ((PK_check_state_t) 24657   )
#define PK_GEOM_state_bad_dep_type_c    ((PK_check_state_t) 24658   )
#define PK_GEOM_state_bad_geom_owner_c  ((PK_check_state_t) 24659   )
#define PK_GEOM_state_bad_owner_c       ((PK_check_state_t) 24660   )
#define PK_GEOM_state_bad_topol_owner_c ((PK_check_state_t) 24661   )
#define PK_GEOM_state_dup_geom_owner_c  ((PK_check_state_t) 24662   )
#define PK_GEOM_state_not_owners_dep_c  ((PK_check_state_t) 24663   )
#define PK_GEOM_state_not_owning_dep_c  ((PK_check_state_t) 24664   )
#define PK_GROUP_state_bad_c            ((PK_check_state_t) 24665   )
#define PK_INSTANCE_state_bad_transf_c  ((PK_check_state_t) 24666   )
#define PK_INSTANCE_state_bad_type_c    ((PK_check_state_t) 24667   )
#define PK_INSTANCE_state_corrupt_c     ((PK_check_state_t) 24668   )
#define PK_LOOP_state_isolated_has_cu_c ((PK_check_state_t) 24669   )
#define PK_PART_state_bad_attrib_c      ((PK_check_state_t) 24670   )
#define PK_PART_state_bad_attrib_list_c ((PK_check_state_t) 24671   )
#define PK_PART_state_bad_state_c       ((PK_check_state_t) 24672   )
#define PK_PART_state_corrupt_c         ((PK_check_state_t) 24673   )
#define PK_PART_state_has_key_c         ((PK_check_state_t) 24674   )
#define PK_PART_state_no_key_c          ((PK_check_state_t) 24675   )
#define PK_REGION_state_no_shell_c      ((PK_check_state_t) 24676   )
#define PK_REGION_state_wrongly_solid_c ((PK_check_state_t) 24677   )
#define PK_SHELL_state_bad_body_c       ((PK_check_state_t) 24678   )
#define PK_SHELL_state_bad_fa_orient_c  ((PK_check_state_t) 24679   )
#define PK_SHELL_state_bad_wf_acorn_c   ((PK_check_state_t) 24680   )
#define PK_SHELL_state_bad_wf_c         ((PK_check_state_t) 24681   )
#define PK_SHELL_state_closed_bad_fa_c  ((PK_check_state_t) 24682   )
#define PK_SHELL_state_ed_fa_in_acorn_c ((PK_check_state_t) 24683   )
#define PK_SHELL_state_eds_fragmented_c ((PK_check_state_t) 24684   )
#define PK_SHELL_state_fas_fragmented_c ((PK_check_state_t) 24685   )
#define PK_SHELL_state_no_vx_ed_fa_c    ((PK_check_state_t) 24686   )
#define PK_SHELL_state_not_owning_vx_c  ((PK_check_state_t) 24687   )
#define PK_SHELL_state_open_bad_fa_c    ((PK_check_state_t) 24688   )
#define PK_SHELL_state_reg_meet_at_ed_c ((PK_check_state_t) 24689   )
#define PK_SHELL_state_reg_meet_at_vx_c ((PK_check_state_t) 24690   )
#define PK_SHELL_state_sheet_no_fa_c    ((PK_check_state_t) 24691   )
#define PK_SHELL_state_too_many_fas_c   ((PK_check_state_t) 24692   )
#define PK_TOPOL_state_bad_box_c        ((PK_check_state_t) 24693   )
#define PK_TOPOL_state_bad_geom_share_c ((PK_check_state_t) 24694   )
#define PK_TOPOL_state_bad_owner_type_c ((PK_check_state_t) 24695   )
#define PK_TOPOL_state_share_no_geom_c  ((PK_check_state_t) 24696   )
#define PK_VERTEX_state_bad_fin_c       ((PK_check_state_t) 24697   )
#define PK_VERTEX_state_bad_isolated_c  ((PK_check_state_t) 24698   )
#define PK_VERTEX_state_bad_tol_c       ((PK_check_state_t) 24699   )
#define PK_VERTEX_state_fin_chains_c    ((PK_check_state_t) 24700   )
#define PK_VERTEX_state_non_manifold_c  ((PK_check_state_t) 24701   )
#define PK_VERTEX_state_not_dep_of_sh_c ((PK_check_state_t) 24702   )
#define PK_VERTEX_state_owner_not_sh_c  ((PK_check_state_t) 24703   )
#define PK_VERTEX_state_sheet_corrupt_c ((PK_check_state_t) 24704   )
#define PK_VERTEX_state_too_many_eds_c  ((PK_check_state_t) 24705   )
#define PK_VERTEX_state_wf_ed_bad_sh_c  ((PK_check_state_t) 24706   )
#define PK_LOOP_state_not_closed_c      ((PK_check_state_t) 24707   )
#define PK_TOPOL_state_extra_child_c    ((PK_check_state_t) 24708   )
#define PK_TOPOL_state_extra_parent_c   ((PK_check_state_t) 24709   )
#define PK_TOPOL_state_missing_parent_c ((PK_check_state_t) 24710   )
#define PK_TOPOL_state_wrong_child_c    ((PK_check_state_t) 24711   )
#define PK_BODY_state_ok_but_alt_type_c ((PK_check_state_t) 24712   )

/* PK_check_extra_faults_t */

#define PK_check_extra_faults_0_c       ((PK_check_extra_faults_t) 24720)
#define PK_check_extra_faults_1_c       ((PK_check_extra_faults_t) 24721)
#define PK_check_extra_faults_latest_c  ((PK_check_extra_faults_t) 24722)

/* PK_extend_side_t */

#define PK_extend_side_default_c             ((PK_extend_side_t) 24730)
#define PK_extend_side_follow_adj_c          ((PK_extend_side_t) 24731)
#define PK_extend_side_ortho_base_c          ((PK_extend_side_t) 24732)

/* PK_blend_laminar_trim_t */

#define PK_blend_laminar_trim_edges_c        ((PK_blend_laminar_trim_t) 24740)
#define PK_blend_laminar_trim_bound_c        ((PK_blend_laminar_trim_t) 24741)

/* PK_blend_run_out_t */

#define PK_blend_run_out_angle_c      ((PK_blend_run_out_t) 24750)
#define PK_blend_run_out_no_c         ((PK_blend_run_out_t) 24751)

/* PK_check_vx_on_cu_t */

#define PK_check_vx_on_cu_all_c              ((PK_check_vx_on_cu_t) 24760)
#define PK_check_vx_on_cu_none_c             ((PK_check_vx_on_cu_t) 24761)
#define PK_check_vx_on_cu_unbounded_c        ((PK_check_vx_on_cu_t) 24762)

/* PK_GEOM_copy_t */

#define PK_GEOM_copy_always_c        ((PK_GEOM_copy_t) 24770)
#define PK_GEOM_copy_never_c         ((PK_GEOM_copy_t) 24771)
#define PK_GEOM_copy_auto_c          ((PK_GEOM_copy_t) 24772)

/* PK_GROUP_split_empty_m */

#define PK_GROUP_split_empty_no_c    ((PK_GROUP_split_empty_t) 24780)
#define PK_GROUP_split_empty_copy_c  ((PK_GROUP_split_empty_t) 24781)

/* PK_GROUP_merge_empty_m */

#define PK_GROUP_merge_empty_no_c    ((PK_GROUP_merge_empty_t) 24790)
#define PK_GROUP_merge_empty_yes_c   ((PK_GROUP_merge_empty_t) 24791)

/* PK_SURF_extend_update_m */

#define PK_SURF_extend_update_default_c  ((PK_SURF_extend_update_t) 24810)
#define PK_SURF_extend_update_0_c        ((PK_SURF_extend_update_t) 24811)

/* PK_change_track_edges_t */

#define PK_change_track_edges_no_c      ((PK_change_track_edges_t) 24820)
#define PK_change_track_edges_laminar_c ((PK_change_track_edges_t) 24821)

/* PK_imprint_dir_t */

#define PK_imprint_dir_consistent_c    ((PK_imprint_dir_t) 24830)
#define PK_imprint_dir_no_check_c      ((PK_imprint_dir_t) 24831)

/* PK_blend_suggest_limit_t */

#define PK_blend_suggest_limit_no_c     ((PK_blend_suggest_limit_t) 24780)
#define PK_blend_suggest_limit_yes_c    ((PK_blend_suggest_limit_t) 24781)
#define PK_blend_suggest_limit_patch_c  ((PK_blend_suggest_limit_t) 24782)

/* PK_fix_degens_t */

#define PK_fix_degens_no_c        ((PK_fix_degens_t) 24850)
#define PK_fix_degens_offset_c    ((PK_fix_degens_t) 24851)
#define PK_fix_degens_all_c       ((PK_fix_degens_t) 24852)

/* PK_constrained_update_t */

#define PK_constrained_update_0_c       ((PK_constrained_update_t) 24860)
#define PK_constrained_update_default_c ((PK_constrained_update_t) 24861)
#define PK_constrained_update_1_c       ((PK_constrained_update_t) 24862)

/* PK_constrained_opt_t */

#define PK_constrained_opt_perf_c          ((PK_constrained_opt_t) 24870)
#define PK_constrained_opt_smoothness_c    ((PK_constrained_opt_t) 24871)

/* PK_measure_t */

#define PK_measure_distance_c           ((PK_measure_t) 24880)
#define PK_measure_distance_ratio_c     ((PK_measure_t) 24881)
#define PK_measure_chord_c              ((PK_measure_t) 24882)
#define PK_measure_chord_ratio_c        ((PK_measure_t) 24883)
#define PK_measure_2_chords_ratio_c     ((PK_measure_t) 24884)


/* PK_CURVE_find_vectors_t */

#define PK_CURVE_find_vectors_ok_c      ((PK_CURVE_find_vectors_t) 24890)
#define PK_CURVE_find_vectors_err_c     ((PK_CURVE_find_vectors_t) 24891)
#define PK_CURVE_find_vectors_degen_c   ((PK_CURVE_find_vectors_t) 24892)
#define PK_CURVE_find_vectors_bounds_c  ((PK_CURVE_find_vectors_t) 24893)
#define PK_CURVE_find_vectors_tol_c     ((PK_CURVE_find_vectors_t) 24894)
#define PK_CURVE_find_vectors_tol_err_c ((PK_CURVE_find_vectors_t) 24895)

/* PK_CURVE_make_bcurve_t */

#define PK_CURVE_make_bcurve_exact_c     ((PK_CURVE_make_bcurve_t) 24900)
#define PK_CURVE_make_bcurve_approx_c    ((PK_CURVE_make_bcurve_t) 24901)

/* PK_fill_hole_patch_eds_t */

#define PK_fill_hole_patch_eds_sharp_c   ((PK_fill_hole_patch_eds_t) 24910)
#define PK_fill_hole_patch_eds_smooth_c   ((PK_fill_hole_patch_eds_t) 24911)

/* PK_THREAD_chain_type_t */

#define PK_THREAD_chain_concurrent_c    ((PK_THREAD_chain_type_t) 24920)
#define PK_THREAD_chain_exclusive_c     ((PK_THREAD_chain_type_t) 24921)
#define PK_THREAD_chain_none_c          ((PK_THREAD_chain_type_t) 24922)

/* PK_blend_limit_type_t */

#define PK_blend_limit_type_edge_c      ((PK_blend_limit_type_t) 24930)
#define PK_blend_limit_type_overlap_c   ((PK_blend_limit_type_t) 24931)

/* PK_boolean_update_t */

#define PK_boolean_update_0_c       ((PK_boolean_update_t) 24940)
#define PK_boolean_update_1_c       ((PK_boolean_update_t) 24942)
#define PK_boolean_update_2_c       ((PK_boolean_update_t) 24943)
#define PK_boolean_update_3_c       ((PK_boolean_update_t) 24944)
#define PK_boolean_update_4_c       ((PK_boolean_update_t) 24945)
#define PK_boolean_update_5_c       ((PK_boolean_update_t) 24946)
#define PK_boolean_update_default_c ((PK_boolean_update_t) 24941)

/* PK_ERROR_on_fail_t */

#define PK_ERROR_on_fail_any_c  ((PK_ERROR_on_fail_t) 24950)
#define PK_ERROR_on_fail_all_c  ((PK_ERROR_on_fail_t) 24951)
#define PK_ERROR_on_fail_no_c   ((PK_ERROR_on_fail_t) 24952)

/* PK_fill_hole_opt_t */

#define PK_fill_hole_opt_performance_c    ((PK_fill_hole_opt_t) 24960)
#define PK_fill_hole_opt_quality_c        ((PK_fill_hole_opt_t) 24961)

/* PK_make_bsurf_update_t */

#define PK_make_bsurf_update_default_c  ((PK_make_bsurf_update_t) 24970)
#define PK_make_bsurf_update_0_c        ((PK_make_bsurf_update_t) 24971)
#define PK_make_bsurf_update_1_c        ((PK_make_bsurf_update_t) 24972)

/* PK_fill_hole_imprint_t */

#define PK_fill_hole_imprint_sharp_c ((PK_fill_hole_imprint_t) 24980)
#define PK_fill_hole_imprint_yes_c   ((PK_fill_hole_imprint_t) 24981)

/* PK_range_param_entity_m */

#define PK_range_param_entity_topol_c   ((PK_range_param_entity_t) 24990)
#define PK_range_param_entity_sub_c     ((PK_range_param_entity_t) 24991)

/* PK_results_output_m */

#define PK_results_output_return_c   ((PK_results_output_t) 25000)
#define PK_results_output_report_c   ((PK_results_output_t) 25001)

/* PK_CURVE_degen_type_t */

#define PK_CURVE_degen_type_param_c         ((PK_CURVE_degen_type_t) 25010)
#define PK_CURVE_degen_type_phys_c          ((PK_CURVE_degen_type_t) 25011)
#define PK_CURVE_degen_type_on_surf_c       ((PK_CURVE_degen_type_t) 25012)

/* PK_neutral_method_t */

#define PK_neutral_method_mid_offset_c  ((PK_neutral_method_t) 25020)
#define PK_neutral_method_offset_left_c ((PK_neutral_method_t) 25021)
#define PK_neutral_method_medial_c      ((PK_neutral_method_t) 25022)

/* PK_blend_report_repaired_t */

#define PK_blend_report_repaired_yes_c   ((PK_blend_report_repaired_t) 25030)
#define PK_blend_report_repaired_no_c    ((PK_blend_report_repaired_t) 25031)

/* PK_blend_limit_patch_t */

#define PK_blend_limit_patch_yes_c       ((PK_blend_limit_patch_t) 25040)
#define PK_blend_limit_patch_no_c        ((PK_blend_limit_patch_t) 25041)

/* PK_EDGE_attach_update_t */

#define PK_EDGE_attach_update_default_c  ((PK_EDGE_attach_update_t) 25050)
#define PK_EDGE_attach_update_0_c        ((PK_EDGE_attach_update_t) 25051)

/* PK_FACE_cover_output_t */

#define PK_FACE_cover_output_replace_c    (( PK_FACE_cover_output_t ) 25060)
#define PK_FACE_cover_output_sheet_c      (( PK_FACE_cover_output_t ) 25061)

/* PK_FACE_cover_smooth_t */

#define PK_FACE_cover_smooth_yes_c    (( PK_FACE_cover_smooth_t ) 25070)
#define PK_FACE_cover_smooth_no_c     (( PK_FACE_cover_smooth_t ) 25071)

/* PK_mass_local_density_t */

#define PK_mass_local_density_override_c ((PK_mass_local_density_t) 25080)
#define PK_mass_local_density_additive_c ((PK_mass_local_density_t) 25081)
#define PK_mass_local_density_ignore_c   ((PK_mass_local_density_t) 25082)
#define PK_mass_local_density_unset_c    ((PK_mass_local_density_t) 25083)

/* PK_reset_prec_method_t */

#define PK_reset_prec_method_any_c         ((PK_reset_prec_method_t) 25090)
#define PK_reset_prec_method_inter_c       ((PK_reset_prec_method_t) 25091)
#define PK_reset_prec_method_int_only_c    ((PK_reset_prec_method_t) 25092)

/* PK_receive_compound_t */

#define PK_receive_compound_split_c    ((PK_receive_compound_t) 25100)
#define PK_receive_compound_keep_c     ((PK_receive_compound_t) 25101)
#define PK_receive_compound_fail_c     ((PK_receive_compound_t) 25102)

/* PK_fill_hole_clamp_t */

#define PK_fill_hole_clamp_no_c        ((PK_fill_hole_clamp_t) 25110)
#define PK_fill_hole_clamp_planar_c    ((PK_fill_hole_clamp_t) 25111)

/* PK_selector_split_t */

#define PK_selector_split_fail_c         ((PK_selector_split_t) 25130)
#define PK_selector_split_propagate_c    ((PK_selector_split_t) 25131)

/* PK_proj_connect_t */

#define PK_proj_connect_none_c       (( PK_proj_connect_t ) 25140)
#define PK_proj_connect_side_c       (( PK_proj_connect_t ) 25141)
#define PK_proj_connect_all_c        (( PK_proj_connect_t ) 25142)
#define PK_proj_connect_side_all_c   (( PK_proj_connect_t ) 25143)
#define PK_proj_connect_hidden_all_c (( PK_proj_connect_t ) 25144)

/* PK_proj_face_hidden_t */

#define PK_proj_face_hidden_no_c     (( PK_proj_face_hidden_t ) 25150)
#define PK_proj_face_hidden_array_c  (( PK_proj_face_hidden_t ) 25151)
#define PK_proj_face_hidden_body_c   (( PK_proj_face_hidden_t ) 25152)

/* PK_proj_max_dist_t */

#define PK_proj_max_dist_no_c     (( PK_proj_max_dist_t ) 25160)
#define PK_proj_max_dist_whole_c  (( PK_proj_max_dist_t ) 25161)

/* PK_proj_split_clash_t */

#define PK_proj_split_clash_no_c     ((PK_proj_split_clash_t) 25170)
#define PK_proj_split_clash_self_c   ((PK_proj_split_clash_t) 25171)
#define PK_proj_split_clash_all_c    ((PK_proj_split_clash_t) 25172)

/* PK_proj_to_points_t */

#define PK_proj_to_points_no_c     ((PK_proj_to_points_t) 25180)
#define PK_proj_to_points_tol_c    ((PK_proj_to_points_t) 25181)
#define PK_proj_to_points_all_c    ((PK_proj_to_points_t) 25182)

/* PK_ref_alignment_t */

#define PK_ref_alignment_opposed_c  ((PK_ref_alignment_t) 25190)
#define PK_ref_alignment_aligned_c  ((PK_ref_alignment_t) 25191)

/* PK_BODY_config_t */

#define PK_BODY_config_standard_c   ((PK_BODY_config_t) 25200)
#define PK_BODY_config_compound_c   ((PK_BODY_config_t) 25201)
#define PK_BODY_config_child_c      ((PK_BODY_config_t) 25202)

/* PK_selector_type_t */

#define PK_selector_type_exclude_c  ((PK_selector_type_t) 25210)
#define PK_selector_type_include_c  ((PK_selector_type_t) 25211)
#define PK_selector_type_off_c      ((PK_selector_type_t) 25212)

/* PK_compound_geom_attr_t */

#define PK_compound_geom_attr_keep_c   ((PK_compound_geom_attr_t) 25220)
#define PK_compound_geom_attr_merge_c  ((PK_compound_geom_attr_t) 25221)

/* PK_check_attribs_t */

#define PK_check_attribs_no_c     ((PK_check_attribs_t) 25230)
#define PK_check_attribs_yes_c    ((PK_check_attribs_t) 25231)

/* PK_EDGE_curve_dir_t */

#define PK_EDGE_curve_dir_none_c    ((PK_EDGE_curve_dir_t) 25240)
#define PK_EDGE_curve_dir_fin_c     ((PK_EDGE_curve_dir_t) 25241)
#define PK_EDGE_curve_dir_vertex_c  ((PK_EDGE_curve_dir_t) 25242)
#define PK_EDGE_curve_dir_point_c   ((PK_EDGE_curve_dir_t) 25243)

/* PK_GEOM_soft_extended_t */

#define PK_GEOM_soft_extended_no_c   ((PK_GEOM_soft_extended_t) 25250)
#define PK_GEOM_soft_extended_yes_c  ((PK_GEOM_soft_extended_t) 25251)

/* PK_chain_optimise_t */

#define PK_chain_optimise_none_c         ((PK_chain_optimise_t) 25270)
#define PK_chain_optimise_for_reblend_c  ((PK_chain_optimise_t) 25271)

/* PK_swept_tool_update_t */

#define PK_swept_tool_update_default_c ((PK_swept_tool_update_t) 25280)
#define PK_swept_tool_update_0_c       ((PK_swept_tool_update_t) 25281)
#define PK_swept_tool_update_1_c       ((PK_swept_tool_update_t) 25282)

/* PK_matrix_type_t */

#define PK_matrix_type_identity_c     ((PK_matrix_type_t) 25290)
#define PK_matrix_type_rotation_c     ((PK_matrix_type_t) 25291)
#define PK_matrix_type_reflection_c   ((PK_matrix_type_t) 25292)
#define PK_matrix_type_general_c      ((PK_matrix_type_t) 25293)
#define PK_matrix_type_unclassified_c ((PK_matrix_type_t) 25294)

/* PK_TRANSF_diagnostics_t */

#define PK_TRANSF_diagnostics_none_c   ((PK_TRANSF_diagnostics_t) 25300)
#define PK_TRANSF_diagnostics_all_c    ((PK_TRANSF_diagnostics_t) 25301)

/* PK_blend_cap_type_t */

#define PK_blend_cap_type_within_c       ((PK_blend_cap_type_t) 25310)
#define PK_blend_cap_type_beyond_c       ((PK_blend_cap_type_t) 25311)
#define PK_blend_cap_type_at_edge_c      ((PK_blend_cap_type_t) 25312)

/* PK_CURVE_is_isoparam_t */

#define PK_CURVE_is_isoparam_no_c       ((PK_CURVE_is_isoparam_t) 25310)
#define PK_CURVE_is_isoparam_yes_c      ((PK_CURVE_is_isoparam_t) 25319)

/* PK_isoparam_alignment_t */

#define PK_isoparam_alignment_aligned_c   ((PK_isoparam_alignment_t) 25320)
#define PK_isoparam_alignment_opposed_c   ((PK_isoparam_alignment_t) 25321)
#define PK_isoparam_alignment_unset_c     ((PK_isoparam_alignment_t) 25322)


/* PK_proj_complete_t */

#define PK_proj_complete_no_c      (( PK_proj_complete_t ) 25340)
#define PK_proj_complete_edge_c    (( PK_proj_complete_t ) 25341)
#define PK_proj_complete_laminar_c (( PK_proj_complete_t ) 25342)
#define PK_proj_complete_faceset_c (( PK_proj_complete_t ) 25343)

/* PK_proj_nominal_t */

#define PK_proj_nominal_yes_c      (( PK_proj_nominal_t ) 25350)
#define PK_proj_nominal_no_c       (( PK_proj_nominal_t ) 25351)

/* PK_proj_function_t */

#define PK_proj_function_project_c      ((PK_proj_function_t) 25360)
#define PK_proj_function_imprint_c      ((PK_proj_function_t) 25361)
#define PK_proj_function_both_c         ((PK_proj_function_t) 25362)

/* PK_proj_update_t */

#define PK_proj_update_default_c      ((PK_proj_update_t) 25370)
#define PK_proj_update_0_c            ((PK_proj_update_t) 25371)
#define PK_proj_update_1_c            ((PK_proj_update_t) 25372)
#define PK_proj_update_2_c            ((PK_proj_update_t) 25373)

/* PK_imprint_precision_t */

#define PK_imprint_precision_auto_c        ((PK_imprint_precision_t) 25380)
#define PK_imprint_precision_accurate_c    ((PK_imprint_precision_t) 25381)

/* PK_neutral_face_overlap_t */

#define PK_neutral_face_overlap_no_c    ((PK_neutral_face_overlap_t) 25390)
#define PK_neutral_face_overlap_yes_c   ((PK_neutral_face_overlap_t) 25391)

/* PK_facet_respect_t */

#define PK_facet_respect_no_c        (( PK_facet_respect_t ) 25400)
#define PK_facet_respect_yes_c       (( PK_facet_respect_t ) 25401)

/* PK_FUNCTION_run_t */

#define PK_FUNCTION_run_concurrent_c    (( PK_FUNCTION_run_t ) 25410)
#define PK_FUNCTION_run_exclusive_c     (( PK_FUNCTION_run_t ) 25411)
#define PK_FUNCTION_run_dynamic_c       (( PK_FUNCTION_run_t ) 25412)
#define PK_FUNCTION_run_mutable_conc_c  (( PK_FUNCTION_run_t ) 25413)
#define PK_FUNCTION_run_mutable_exc_c   (( PK_FUNCTION_run_t ) 25414)

/* PK_blend_fault_t            ( 25420 - 25429 ) (18390-18399) */

#define PK_blend_fault_g2_collar_setb_c    ((PK_blend_fault_t) 25420)

/* PK_track_edges_t */

#define PK_track_bodies_yes_c     ((PK_track_bodies_t) 25430)
#define PK_track_bodies_no_c      ((PK_track_bodies_t) 25431)

/* PK_outline_edge_on_t */

#define PK_outline_edge_on_none_c      (( PK_outline_edge_on_t ) 25440 )
#define PK_outline_edge_on_all_c       (( PK_outline_edge_on_t ) 25441 )

/* PK_fill_hole_non_smooth_t */

#define PK_fill_hole_non_smooth_fail_c  (( PK_fill_hole_non_smooth_t ) 25540 )
#define PK_fill_hole_non_smooth_allow_c (( PK_fill_hole_non_smooth_t ) 25541 )

/* PK_blend_params_t */

#define PK_blend_params_none_c          ((PK_blend_params_t) 25460)
#define PK_blend_params_face_offset_c   ((PK_blend_params_t) 25461)

/* PK_blend_report_blends_t */

#define PK_blend_report_blends_yes_c ((PK_blend_report_blends_t) 25470)
#define PK_blend_report_blends_no_c  ((PK_blend_report_blends_t) 25471)

/* PK_blend_distant_unders_t */

#define PK_blend_distant_unders_yes_c   ((PK_blend_distant_unders_t) 25480)
#define PK_blend_distant_unders_no_c    ((PK_blend_distant_unders_t) 25481)

/* PK_repair_fa_t  */

#define PK_repair_fa_yes_c        (( PK_repair_fa_t ) 25490 )
#define PK_repair_fa_local_c      (( PK_repair_fa_t ) 25491 )

/* PK_LOOP_sew_up_t */

#define PK_LOOP_sew_up_loop_c (( PK_LOOP_sew_up_t ) 25500 )
#define PK_LOOP_sew_up_no_c (( PK_LOOP_sew_up_t ) 25501 )

/* PK_shadow_check_fa_t */

#define PK_shadow_check_fa_no_c      (( PK_shadow_check_fa_t ) 25510 )
#define PK_shadow_check_fa_yes_c     (( PK_shadow_check_fa_t ) 25511 )

/* PK_proj_tracking_t */

#define PK_proj_tracking_basic_c      (( PK_proj_tracking_t ) 25520 )
#define PK_proj_tracking_completion_c (( PK_proj_tracking_t ) 25521 )

/* PK_render_report_line_t (25550-25559) */

#define PK_render_report_line_no_c         ((PK_render_report_line_t) 25550)
#define PK_render_report_line_fail_c       ((PK_render_report_line_t) 25551)
#define PK_render_report_line_loose_c      ((PK_render_report_line_t) 25552)
#define PK_render_report_line_all_c        ((PK_render_report_line_t) 25553)

/* PK_blend_use_master_faces_t */

#define PK_blend_use_master_faces_no_c    ((PK_blend_use_master_faces_t) 25560)
#define PK_blend_use_master_faces_yes_c   ((PK_blend_use_master_faces_t) 25561)

/* PK_FACE_cover_update_t */

#define PK_FACE_cover_update_default_c    ((PK_FACE_cover_update_t) 25570)
#define PK_FACE_cover_update_0_c          ((PK_FACE_cover_update_t) 25571)

/* PK_make_bcurve_update_t */

#define PK_make_bcurve_update_default_c  ((PK_make_bcurve_update_t) 25580)
#define PK_make_bcurve_update_0_c        ((PK_make_bcurve_update_t) 25581)

/* PK_ITEM_null */

#define PK_ITEM_null ((PK_ITEM_t) 0)

/* PK_ENTITY_null */

#define PK_ENTITY_null ((PK_ENTITY_t) 0)

/* PK_PMARK_null */

#define PK_PMARK_null ((PK_PMARK_t) 0)

/* PK_MARK_null */

#define PK_MARK_null ((PK_MARK_t) 0)

/* PK_PARTITION_null */

#define PK_PARTITION_null ((PK_PARTITION_t) 0)

/* PK_APPITEM_null */

#define PK_APPITEM_null ((PK_APPITEM_t) 0)

/* PK_REPORT_null */

#define PK_REPORT_null  ((PK_REPORT_t) -1)

/* PK_ERROR_severity_t */

#define PK_ERROR_none    ((PK_ERROR_severity_t) 0)
#define PK_ERROR_mild    ((PK_ERROR_severity_t) 1)
#define PK_ERROR_serious ((PK_ERROR_severity_t) 2)
#define PK_ERROR_fatal   ((PK_ERROR_severity_t) 3)

/* PK_LOGICAL_true, PK_LOGICAL_false */

#define PK_LOGICAL_true  ((PK_LOGICAL_t) 01)
#define PK_LOGICAL_false ((PK_LOGICAL_t) 00)

/* PK_LAW_sf_m */

#define PK_LAW_sf_m(sf)                                     \
    (                                                       \
       (sf).degree           = 0,                           \
       (sf).n_vertices       = 0,                           \
       (sf).vertex_dim       = 1,                           \
       (sf).is_rational      = PK_LOGICAL_false,            \
       (sf).vertex           = NULL,                        \
       (sf).n_knots          = 0,                           \
       (sf).knot_mult        = NULL,                        \
       (sf).knot             = NULL,                        \
       (sf).knot_type        = PK_knot_unset_c,             \
       (sf).is_periodic      = PK_LOGICAL_false,            \
       (sf).is_closed        = PK_LOGICAL_false             \
    )

/* #defines for PK_CLASS_xxx */

#define PK_CLASS_null      ((PK_CLASS_t) 500)
#define PK_CLASS_class     ((PK_CLASS_t)(PK_CLASS_null+ 1))

/* special classes */

#define PK_CLASS_entity    ((PK_CLASS_t) TYEN00)
#define PK_CLASS_primitive ((PK_CLASS_t)(PK_CLASS_null+ 2))
#define PK_CLASS_error     ((PK_CLASS_t)(PK_CLASS_null+ 3))
#define PK_CLASS_session   ((PK_CLASS_t)(PK_CLASS_null+ 4))
#define PK_CLASS_memory    ((PK_CLASS_t)(PK_CLASS_null+ 5))
#define PK_CLASS_mark      ((PK_CLASS_t)(PK_CLASS_null+ 6))
#define PK_CLASS_pmark     ((PK_CLASS_t)(PK_CLASS_null+ 7))
#define PK_CLASS_partition ((PK_CLASS_t)(PK_CLASS_null+ 8))
#define PK_CLASS_bb        ((PK_CLASS_t)(PK_CLASS_null+ 9))

/* primitive classes */

#define PK_CLASS_int       ((PK_CLASS_t)(PK_CLASS_null+10))
#define PK_CLASS_double    ((PK_CLASS_t)(PK_CLASS_null+11))
#define PK_CLASS_char      ((PK_CLASS_t)(PK_CLASS_null+12))
#define PK_CLASS_string    ((PK_CLASS_t)(PK_CLASS_null+13))
#define PK_CLASS_logical   ((PK_CLASS_t)(PK_CLASS_null+14))
#define PK_CLASS_vector    ((PK_CLASS_t)(PK_CLASS_null+15))
#define PK_CLASS_interval  ((PK_CLASS_t)(PK_CLASS_null+16))
#define PK_CLASS_box       ((PK_CLASS_t)(PK_CLASS_null+17))
#define PK_CLASS_uvbox     ((PK_CLASS_t)(PK_CLASS_null+18))
#define PK_CLASS_uv        ((PK_CLASS_t)(PK_CLASS_null+19))
#define PK_CLASS_pointer   ((PK_CLASS_t)(PK_CLASS_null+20))
#define PK_CLASS_vector1   ((PK_CLASS_t)(PK_CLASS_null+21))
#define PK_CLASS_size      ((PK_CLASS_t)(PK_CLASS_null+22))

/* entity classes */

#define PK_CLASS_attrib    ((PK_CLASS_t) TYENAD)
#define PK_CLASS_attdef    ((PK_CLASS_t) TYADAD)
#define PK_CLASS_group     ((PK_CLASS_t) TYADFE)
#define PK_CLASS_transf    ((PK_CLASS_t) TYGETF)
#define PK_CLASS_ki_list   ((PK_CLASS_t) TYADLI)

/* topol */

#define PK_CLASS_topol     ((PK_CLASS_t) TYENTO)
#define PK_CLASS_part      ((PK_CLASS_t) 5012)
#define PK_CLASS_assembly  ((PK_CLASS_t) TYTOAS)
#define PK_CLASS_body      ((PK_CLASS_t) TYTOBY)
#define PK_CLASS_instance  ((PK_CLASS_t) TYTOIN)
#define PK_CLASS_region    ((PK_CLASS_t) TYTORG)
#define PK_CLASS_shell     ((PK_CLASS_t) TYTOSH)
#define PK_CLASS_face      ((PK_CLASS_t) TYTOFA)
#define PK_CLASS_loop      ((PK_CLASS_t) TYTOLO)
#define PK_CLASS_edge      ((PK_CLASS_t) TYTOED)
#define PK_CLASS_fin       ((PK_CLASS_t) TYTOFN)
#define PK_CLASS_vertex    ((PK_CLASS_t) TYTOVX)

/* geom */

#define PK_CLASS_geom      ((PK_CLASS_t) TYENGE)

/* surf */

#define PK_CLASS_surf      ((PK_CLASS_t) TYGESU)
#define PK_CLASS_plane     ((PK_CLASS_t) TYSUPL)
#define PK_CLASS_cyl       ((PK_CLASS_t) TYSUCY)
#define PK_CLASS_cone      ((PK_CLASS_t) TYSUCO)
#define PK_CLASS_sphere    ((PK_CLASS_t) TYSUSP)
#define PK_CLASS_torus     ((PK_CLASS_t) TYSUTO)
#define PK_CLASS_bsurf     ((PK_CLASS_t) TYSUPA)
#define PK_CLASS_offset    ((PK_CLASS_t) TYSUOF)
#define PK_CLASS_fsurf     ((PK_CLASS_t) TYSUFG)
#define PK_CLASS_swept     ((PK_CLASS_t) TYSUSE)
#define PK_CLASS_spun      ((PK_CLASS_t) TYSUSU)
#define PK_CLASS_blendsf   ((PK_CLASS_t) TYSUBL)

/* curve */

#define PK_CLASS_curve     ((PK_CLASS_t) TYGECU)
#define PK_CLASS_line      ((PK_CLASS_t) TYCUST)
#define PK_CLASS_circle    ((PK_CLASS_t) TYCUCI)
#define PK_CLASS_ellipse   ((PK_CLASS_t) TYCUEL)
#define PK_CLASS_bcurve    ((PK_CLASS_t) TYCUPA)
#define PK_CLASS_icurve    ((PK_CLASS_t) TYCUIN)
#define PK_CLASS_fcurve    ((PK_CLASS_t) TYCUFG)
#define PK_CLASS_spcurve   ((PK_CLASS_t) TYCUSP)
#define PK_CLASS_trcurve   ((PK_CLASS_t) TYCUTR)
#define PK_CLASS_cpcurve   ((PK_CLASS_t) TYCUCP)

/* point */

#define PK_CLASS_point     ((PK_CLASS_t) TYPTCA)

/* nabox */

#define PK_CLASS_nabox     ((PK_CLASS_t) 2005)
#define PK_CLASS_item      ((PK_CLASS_t)(PK_CLASS_null+23))
#define PK_CLASS_appitem   ((PK_CLASS_t)(PK_CLASS_null+24))

/* alias names for where PK terminology is totally different from KI */

#define PK_ERROR_not_in_group               PK_ERROR_not_in_feat
#define PK_ERROR_wrong_class_for_group      PK_ERROR_wrong_type_for_feat
#define PK_ERROR_already_in_group           PK_ERROR_already_in_feat
#define PK_ERROR_existing_attdef            PK_ERROR_existing_attr_type
#define PK_ERROR_duplicate_array_item       PK_ERROR_duplicate_list_item
#define PK_ERROR_not_an_entity              PK_ERROR_not_a_tag
#define PK_ERROR_wrong_entity_in_array      PK_ERROR_wrong_entity_in_list
#define PK_ERROR_array_too_short            PK_ERROR_list_too_short
#define PK_ERROR_R1_R2_mismatch             PK_ERROR_majrad_minrad_mismatch
#define PK_ERROR_impossible_spin            PK_ERROR_impossible_swing
#define PK_ERROR_no_closest_approach        KI_closest_approach_failed
#define PK_ERROR_bad_class_event_comb       KI_bad_entity_event_comb
#define PK_ERROR_bb_is_off                  KI_bulletinb_is_off
#define PK_ERROR_FG_eval_not_found          PK_ERROR_FG_evaluator_not_found
#define PK_ERROR_FG_doubles                 PK_ERROR_FG_real_data_error
#define PK_ERROR_FG_ints                    PK_ERROR_FG_integer_data_error

/* #defines for PK_ERROR_code_t - which don't exist in the KI. */

#define PK_ERROR_not_implemented        ((PK_ERROR_code_t)  5000)
#define PK_ERROR_not_in_PK              ((PK_ERROR_code_t)  5001)
#define PK_ERROR_unknown_class          ((PK_ERROR_code_t)  5002)
#define PK_ERROR_frustrum_failure       ((PK_ERROR_code_t)  5003)
#define PK_ERROR_recursion_depth        ((PK_ERROR_code_t)  5004)
#define PK_ERROR_not_a_part             ((PK_ERROR_code_t)  5005)
#define PK_ERROR_bad_mark               ((PK_ERROR_code_t)  5006)
#define PK_ERROR_mark_ki_started        ((PK_ERROR_code_t)  5007)
#define PK_ERROR_mark_not_started       ((PK_ERROR_code_t)  5008)
#define PK_ERROR_num_derivs_not_equal   ((PK_ERROR_code_t)  5009)
#define PK_ERROR_memory_not_empty       ((PK_ERROR_code_t)  5010)
#define PK_ERROR_no_last_error          ((PK_ERROR_code_t)  5011)
#define PK_ERROR_zero_bytes_required    ((PK_ERROR_code_t)  5012)
#define PK_ERROR_bad_field_number       ((PK_ERROR_code_t)  5013)
#define PK_ERROR_field_of_wrong_type    ((PK_ERROR_code_t)  5014)
#define PK_ERROR_invalid_group_class    ((PK_ERROR_code_t)  5015)
#define PK_ERROR_unhandleable_condition ((PK_ERROR_code_t)  5016)
#define PK_ERROR_wrong_group_class      ((PK_ERROR_code_t)  5017)
#define PK_ERROR_eval_failure           ((PK_ERROR_code_t)  5018)
#define PK_ERROR_not_a_unit_vector      ((PK_ERROR_code_t)  5019)
#define PK_ERROR_existing_attrib        ((PK_ERROR_code_t)  5020)
#define PK_ERROR_solid_region           ((PK_ERROR_code_t)  5021)
#define PK_ERROR_o_t_version_unknown    ((PK_ERROR_code_t)  5022)
#define PK_ERROR_mark_pk_started        ((PK_ERROR_code_t)  5023)
#define PK_ERROR_vectors_are_parallel   ((PK_ERROR_code_t)  5024)
#define PK_ERROR_sum_of_offsets_eq_0    ((PK_ERROR_code_t)  5025)
#define PK_ERROR_distance_too_small     ((PK_ERROR_code_t)  5026)
#define PK_ERROR_vectors_not_orthogonal ((PK_ERROR_code_t)  5027)
#define PK_ERROR_zero_interval          ((PK_ERROR_code_t)  5028)
#define PK_ERROR_periodic_open          ((PK_ERROR_code_t)  5029)
#define PK_ERROR_periodic_not_smooth    ((PK_ERROR_code_t)  5030)
#define PK_ERROR_cant_get_point         ((PK_ERROR_code_t)  5031)
#define PK_ERROR_cant_get_curve         ((PK_ERROR_code_t)  5032)
#define PK_ERROR_edge_didnt_vanish      ((PK_ERROR_code_t)  5033)
#define PK_ERROR_face_face_check_fails  ((PK_ERROR_code_t)  5034)
#define PK_ERROR_face_check_fails       ((PK_ERROR_code_t)  5035)
#define PK_ERROR_not_a_hand             ((PK_ERROR_code_t)  5036)
#define PK_ERROR_bad_interval           ((PK_ERROR_code_t)  5037)
#define PK_ERROR_bad_uvbox              ((PK_ERROR_code_t)  5038)
#define PK_ERROR_cannot_make_current    ((PK_ERROR_code_t)  5039)
#define PK_ERROR_bb_not_empty           ((PK_ERROR_code_t)  5040)
#define PK_ERROR_bad_class              ((PK_ERROR_code_t)  5041)
#define PK_ERROR_bad_class_combn        ((PK_ERROR_code_t)  5042)
#define PK_ERROR_o_t_version_incorrect  ((PK_ERROR_code_t)  5043)
#define PK_ERROR_bad_boolean_function   ((PK_ERROR_code_t)  5044)
#define PK_ERROR_bad_boolean_region     ((PK_ERROR_code_t)  5045)
#define PK_ERROR_distancing_failed      ((PK_ERROR_code_t)  5046)
#define PK_ERROR_no_overlap             ((PK_ERROR_code_t)  5047)
#define PK_ERROR_rollback_not_started   ((PK_ERROR_code_t)  5048)
#define PK_ERROR_rollback_started       ((PK_ERROR_code_t)  5049)
#define PK_ERROR_cant_get_surf          ((PK_ERROR_code_t)  5050)
#define PK_ERROR_bad_section_fence      ((PK_ERROR_code_t)  5051)
#define PK_ERROR_bad_boolean_fence      ((PK_ERROR_code_t)  5052)
#define PK_ERROR_cant_get_side_curve    ((PK_ERROR_code_t)  5053)
#define PK_ERROR_cant_get_side_surf     ((PK_ERROR_code_t)  5054)
#define PK_ERROR_sewing_failed          ((PK_ERROR_code_t)  5055)
#define PK_ERROR_duplicate_parts        ((PK_ERROR_code_t)  5056)
#define PK_ERROR_deltas_not_available   ((PK_ERROR_code_t)  5057)
#define PK_ERROR_not_at_pmark           ((PK_ERROR_code_t)  5058)
#define PK_ERROR_bad_boolean_match      ((PK_ERROR_code_t)  5059)
#define PK_ERROR_invalid_match_region   ((PK_ERROR_code_t)  5060)
#define PK_ERROR_check_error            ((PK_ERROR_code_t)  5061)
#define PK_ERROR_check_failure          ((PK_ERROR_code_t)  5062)
#define PK_ERROR_no_approx_data         ((PK_ERROR_code_t)  5063)
#define PK_ERROR_not_general            ((PK_ERROR_code_t)  5064)
#define PK_ERROR_cant_merge_regions     ((PK_ERROR_code_t)  5065)
#define PK_ERROR_not_a_bb               ((PK_ERROR_code_t)  5066)
#define PK_ERROR_bad_bb_status          ((PK_ERROR_code_t)  5067)
#define PK_ERROR_unsupported_operation  ((PK_ERROR_code_t)  5068)
#define PK_ERROR_bad_end_condition      ((PK_ERROR_code_t)  5069)
#define PK_ERROR_bad_boolean_select     ((PK_ERROR_code_t)  5070)
#define PK_ERROR_bad_thread             ((PK_ERROR_code_t)  5071)
#define PK_ERROR_no_intersect           ((PK_ERROR_code_t)  5072)
#define PK_ERROR_obsolete_function      ((PK_ERROR_code_t)  5073)
#define PK_ERROR_reverse_edge_failed    ((PK_ERROR_code_t)  5074)
#define PK_ERROR_orientation_failed     ((PK_ERROR_code_t)  5075)
#define PK_ERROR_bad_edge               ((PK_ERROR_code_t)  5076)
#define PK_ERROR_curve_nmnl_off         ((PK_ERROR_code_t)  5077)
#define PK_ERROR_bad_pattern_check      ((PK_ERROR_code_t)  5078)
#define PK_ERROR_bad_pattern_status     ((PK_ERROR_code_t)  5079)
#define PK_ERROR_bad_pattern_result     ((PK_ERROR_code_t)  5080)
#define PK_ERROR_wrong_version_delta    ((PK_ERROR_code_t)  5081)
#define PK_ERROR_edge_not_open          ((PK_ERROR_code_t)  5082)
#define PK_ERROR_edge_not_manifold      ((PK_ERROR_code_t)  5083)
#define PK_ERROR_vertex_not_manifold    ((PK_ERROR_code_t)  5084)
#define PK_ERROR_no_common_vertex       ((PK_ERROR_code_t)  5085)
#define PK_ERROR_fin_not_at_vertex      ((PK_ERROR_code_t)  5086)
#define PK_ERROR_bad_fin                ((PK_ERROR_code_t)  5087)
#define PK_ERROR_not_laminar_side       ((PK_ERROR_code_t)  5088)
#define PK_ERROR_wireframe_edge         ((PK_ERROR_code_t)  5089)
#define PK_ERROR_different_shells       ((PK_ERROR_code_t)  5090)
#define PK_ERROR_face_contains_loop     ((PK_ERROR_code_t)  5091)
#define PK_ERROR_only_one_loop          ((PK_ERROR_code_t)  5092)
#define PK_ERROR_invalid_face           ((PK_ERROR_code_t)  5093)
#define PK_ERROR_fins_not_distinct      ((PK_ERROR_code_t)  5094)
#define PK_ERROR_bad_check_topol        ((PK_ERROR_code_t)  5095)
#define PK_ERROR_bad_check_su_X         ((PK_ERROR_code_t)  5096)
#define PK_ERROR_bad_change_topol       ((PK_ERROR_code_t)  5097)
#define PK_ERROR_bad_local_status       ((PK_ERROR_code_t)  5098)
#define PK_ERROR_bad_topol_track        ((PK_ERROR_code_t)  5099)
#define PK_ERROR_fin_not_in_loop        ((PK_ERROR_code_t)  5100)
#define PK_ERROR_too_many_edges         ((PK_ERROR_code_t)  5101)
#define PK_ERROR_loop_not_isolated      ((PK_ERROR_code_t)  5102)
#define PK_ERROR_loops_not_same_face    ((PK_ERROR_code_t)  5103)
#define PK_ERROR_bad_boolean_report     ((PK_ERROR_code_t)  5104)
#define PK_ERROR_bad_boolean_result     ((PK_ERROR_code_t)  5105)
#define PK_ERROR_bad_section_report     ((PK_ERROR_code_t)  5106)
#define PK_ERROR_bad_section_result     ((PK_ERROR_code_t)  5107)
#define PK_ERROR_edge_is_wire           ((PK_ERROR_code_t)  5108)
#define PK_ERROR_bad_boolean_check_fa   ((PK_ERROR_code_t)  5109)
#define PK_ERROR_bad_section_check_fa   ((PK_ERROR_code_t)  5110)
#define PK_ERROR_inconsistent_offset    ((PK_ERROR_code_t)  5111)
#define PK_ERROR_inconsistent_thicken   ((PK_ERROR_code_t)  5112)
#define PK_ERROR_bad_twist_law          ((PK_ERROR_code_t)  5113)
#define PK_ERROR_bad_scale_law          ((PK_ERROR_code_t)  5114)
#define PK_ERROR_bad_profile_matching   ((PK_ERROR_code_t)  5115)
#define PK_ERROR_bad_end_conditions     ((PK_ERROR_code_t)  5116)
#define PK_ERROR_loft_failed            ((PK_ERROR_code_t)  5117)
#define PK_ERROR_sweep_failed           ((PK_ERROR_code_t)  5118)
#define PK_ERROR_different_loops        ((PK_ERROR_code_t)  5119)
#define PK_ERROR_edge_is_ring           ((PK_ERROR_code_t)  5120)
#define PK_ERROR_loops_not_distinct     ((PK_ERROR_code_t)  5121)
#define PK_ERROR_point_contact          ((PK_ERROR_code_t)  5122)
#define PK_ERROR_sweep_need_piecewise   ((PK_ERROR_code_t)  5123)
#define PK_ERROR_zero_vector            ((PK_ERROR_code_t)  5124)
#define PK_ERROR_bad_iteration_count    ((PK_ERROR_code_t)  5125)
#define PK_ERROR_bad_gap_bound          ((PK_ERROR_code_t)  5126)
#define PK_ERROR_bad_match_style        ((PK_ERROR_code_t)  5127)
#define PK_ERROR_no_division            ((PK_ERROR_code_t)  5128)
#define PK_ERROR_no_nth_division        ((PK_ERROR_code_t)  5129)
#define PK_ERROR_bad_reference          ((PK_ERROR_code_t)  5130)
#define PK_ERROR_cant_fill_hole         ((PK_ERROR_code_t)  5131)
#define PK_ERROR_no_data                ((PK_ERROR_code_t)  5132)
#define PK_ERROR_too_many_geoms         ((PK_ERROR_code_t)  5133)
#define PK_ERROR_disjoint               ((PK_ERROR_code_t)  5134)
#define PK_ERROR_duplicate_name         ((PK_ERROR_code_t)  5135)
#define PK_ERROR_failed_to_make_outline ((PK_ERROR_code_t)  5136)
#define PK_ERROR_failed_to_blend        ((PK_ERROR_code_t)  5137)
#define PK_ERROR_failed_to_offset       ((PK_ERROR_code_t)  5138)
#define PK_ERROR_failed_to_taper        ((PK_ERROR_code_t)  5139)
#define PK_ERROR_failed_to_transform    ((PK_ERROR_code_t)  5140)
#define PK_ERROR_journalling_on         ((PK_ERROR_code_t)  5141)
#define PK_ERROR_dbg_rprt_not_stopped   ((PK_ERROR_code_t)  5142)
#define PK_ERROR_dbg_rprt_not_started   ((PK_ERROR_code_t)  5143)
#define PK_ERROR_imprint_shadows_failed ((PK_ERROR_code_t)  5144)
#define PK_ERROR_bad_combination        ((PK_ERROR_code_t)  5145)
#define PK_ERROR_partition_is_current   ((PK_ERROR_code_t)  5146)
#define PK_ERROR_partition_not_empty    ((PK_ERROR_code_t)  5147)
#define PK_ERROR_failed_to_bend         ((PK_ERROR_code_t)  5148)
#define PK_ERROR_cant_use_curve         ((PK_ERROR_code_t)  5149)
#define PK_ERROR_cant_extend            ((PK_ERROR_code_t)  5150)
#define PK_ERROR_bad_boolean_material   ((PK_ERROR_code_t)  5151)
#define PK_ERROR_cant_complete_imprint  ((PK_ERROR_code_t)  5152)
#define PK_ERROR_edge_closure_mismatch  ((PK_ERROR_code_t)  5153)
#define PK_ERROR_bad_boolean_prefer     ((PK_ERROR_code_t)  5154)
#define PK_ERROR_not_started            ((PK_ERROR_code_t)  5155)
#define PK_ERROR_not_stopped            ((PK_ERROR_code_t)  5156)
#define PK_ERROR_bad_output_session     ((PK_ERROR_code_t)  5157)
#define PK_ERROR_bad_boolean_no_effect  ((PK_ERROR_code_t)  5158)
#define PK_ERROR_null_evaluator         ((PK_ERROR_code_t)  5159)
#define PK_ERROR_ambiguous_imprint      ((PK_ERROR_code_t)  5160)
#define PK_ERROR_bad_match_update       ((PK_ERROR_code_t)  5161)
#define PK_ERROR_cant_limit_faces       ((PK_ERROR_code_t)  5162)
#define PK_ERROR_bad_partition          ((PK_ERROR_code_t)  5163)
#define PK_ERROR_edge_too_short         ((PK_ERROR_code_t)  5164)
#define PK_ERROR_loop_is_sliver         ((PK_ERROR_code_t)  5165)
#define PK_ERROR_cyclic_group           ((PK_ERROR_code_t)  5166)
#define PK_ERROR_find_self_int_failed   ((PK_ERROR_code_t)  5167)
#define PK_ERROR_indexio_not_registered ((PK_ERROR_code_t)  5168)
#define PK_ERROR_xt_data_not_indexed    ((PK_ERROR_code_t)  5169)
#define PK_ERROR_bad_report             ((PK_ERROR_code_t)  5170)
#define PK_ERROR_wrong_report           ((PK_ERROR_code_t)  5171)
#define PK_ERROR_fix_self_int_failed    ((PK_ERROR_code_t)  5172)
#define PK_ERROR_wrong_number_entities  ((PK_ERROR_code_t)  5173)
#define PK_ERROR_clashing_limits        ((PK_ERROR_code_t)  5174)
#define PK_ERROR_closed_report          ((PK_ERROR_code_t)  5175)
#define PK_ERROR_bad_cap_definition     ((PK_ERROR_code_t)  5176)
#define PK_ERROR_mutual_dependency      ((PK_ERROR_code_t)  5177)
#define PK_ERROR_artificial_error       ((PK_ERROR_code_t)  5178)
#define PK_ERROR_failed_to_deform       ((PK_ERROR_code_t)  5179)
#define PK_ERROR_evaluator_failed       ((PK_ERROR_code_t)  5180)
#define PK_ERROR_su_not_coincident      ((PK_ERROR_code_t)  5181)
#define PK_ERROR_tool_generation        ((PK_ERROR_code_t)  5182)
#define PK_ERROR_unsupported_transf     ((PK_ERROR_code_t)  5183)
#define PK_ERROR_bad_2d_viewport        ((PK_ERROR_code_t)  5184)
#define PK_ERROR_find_degens_failed     ((PK_ERROR_code_t)  5185)
#define PK_ERROR_fix_degens_failed      ((PK_ERROR_code_t)  5186)
#define PK_ERROR_bad_orientation        ((PK_ERROR_code_t)  5187)
#define PK_ERROR_laminar_edge           ((PK_ERROR_code_t)  5188)
#define PK_ERROR_copy_failed            ((PK_ERROR_code_t)  5189)
#define PK_ERROR_find_interior_failed   ((PK_ERROR_code_t)  5190)
#define PK_ERROR_failed_to_facet        ((PK_ERROR_code_t)  5191)
#define PK_ERROR_cant_get_vectors       ((PK_ERROR_code_t)  5192)
#define PK_ERROR_bad_chord              ((PK_ERROR_code_t)  5193)
#define PK_ERROR_interval_exceed_period ((PK_ERROR_code_t)  5194)
#define PK_ERROR_interval_le_0          ((PK_ERROR_code_t)  5195)
#define PK_ERROR_no_measurements        ((PK_ERROR_code_t)  5196)
#define PK_ERROR_failed_to_change       ((PK_ERROR_code_t)  5197)
#define PK_ERROR_invalid_methods        ((PK_ERROR_code_t)  5198)
#define PK_ERROR_cant_find_thickness    ((PK_ERROR_code_t)  5199)
#define PK_ERROR_zero_thickness         ((PK_ERROR_code_t)  5200)
#define PK_ERROR_cant_make_valid_split  ((PK_ERROR_code_t)  5201)
#define PK_ERROR_same_edge              ((PK_ERROR_code_t)  5202)
#define PK_ERROR_density_lt_0           ((PK_ERROR_code_t)  5203)
#define PK_ERROR_cant_cover             ((PK_ERROR_code_t)  5204)
#define PK_ERROR_bad_faces              ((PK_ERROR_code_t)  5205)
#define PK_ERROR_bad_acorn              ((PK_ERROR_code_t)  5206)
#define PK_ERROR_child_body             ((PK_ERROR_code_t)  5207)
#define PK_ERROR_grid_not_on_boundary   ((PK_ERROR_code_t)  5208)
#define PK_ERROR_grid_disjoint          ((PK_ERROR_code_t)  5209)
#define PK_ERROR_grid_not_wireframe     ((PK_ERROR_code_t)  5210)
#define PK_ERROR_grid_not_smooth        ((PK_ERROR_code_t)  5211)
#define PK_ERROR_not_smooth             ((PK_ERROR_code_t)  5212)
#define PK_ERROR_ambiguous_selector     ((PK_ERROR_code_t)  5213)
#define PK_ERROR_inconsistent_selection ((PK_ERROR_code_t)  5214)
#define PK_ERROR_callback_failed        ((PK_ERROR_code_t)  5215)
#define PK_ERROR_illegal_cliff          ((PK_ERROR_code_t)  5216)
#define PK_ERROR_bad_blend_rho_type     ((PK_ERROR_code_t)  5217)
#define PK_ERROR_failed_to_project      ((PK_ERROR_code_t)  5218)
#define PK_ERROR_all_edges_in_body      ((PK_ERROR_code_t)  5219)
#define PK_ERROR_not_edge_on            ((PK_ERROR_code_t)  5220)
#define PK_ERROR_function_not_conc      ((PK_ERROR_code_t)  5221)
#define PK_ERROR_function_not_exclusive ((PK_ERROR_code_t)  5222)
#define PK_ERROR_function_not_mutable   ((PK_ERROR_code_t)  5223)
#define PK_ERROR_invalid_object         ((PK_ERROR_code_t)  9999)

/* PK_imprint_face_list_t */

#define PK_imprint_face_list_no_c     (( PK_imprint_face_list_t ) 00)
#define PK_imprint_face_list_target_c (( PK_imprint_face_list_t ) 01)
#define PK_imprint_face_list_tool_c   (( PK_imprint_face_list_t ) 02)
#define PK_imprint_face_list_both_c   (( PK_imprint_face_list_t ) 03)

/* PK_FACE_heal_loops_t */

#define PK_FACE_heal_loops_together_c  (( PK_FACE_heal_loops_t ) 00)
#define PK_FACE_heal_loops_separate_c  (( PK_FACE_heal_loops_t ) 01)
#define PK_FACE_heal_loops_auto_c      (( PK_FACE_heal_loops_t ) 02)


/*********************************************************************/
/* FUNCTIONS */
/*********************************************************************/


#ifdef __cplusplus
#define PK_linkage_m extern "C"
#else
#define PK_linkage_m extern
#endif


PK_linkage_m PK_ERROR_code_t PK_CLASS_ask_superclass
(
/* received */
PK_CLASS_t         /*class*/,             /* a class */
/* returned */
PK_CLASS_t *const  /*superclass*/         /* immediate superclass of class */
);
/*
This function return the class token of the given class's immediate superclass.
*/

PK_linkage_m PK_ERROR_code_t PK_CLASS_is_subclass
(
/* received */
PK_CLASS_t           /*may_be_subclass*/, /* a potential subclass */
PK_CLASS_t           /*class*/,           /* a class */
/* returned */
PK_LOGICAL_t *const  /*is_subclass*/      /* whether it was a subclass */
);
/*
This function returns whether `may_be_subclass' is a subclass of `class'.
*/

PK_linkage_m PK_ERROR_code_t PK_DELTA_register_callbacks
(
/* received */
PK_DELTA_frustrum_t  /*frustrum*/  /* frustrum functions */
);
/*
This function registers the partitioned rollback frustrum, and switches on
partitioned rollback. It should be called before PK_SESSION_start.
(PK_SESSION_stop switches off partitioned rollback and deregisters the
partitioned rollback frustrum).
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_create
(
/* returned */
PK_MARK_t *const  /*mark*/               /* created mark */
);
/*
This function sets a rollmark and returns a mark identifier.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_goto
(
/* received */
PK_MARK_t        /*mark*/             /* mark to go to */
);
/*
This function returns the modeller to the state when the given mark was
created.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_delete
(
/* received */
PK_MARK_t        /*mark*/             /* mark to delete */
);
/*
This function deletes the given mark. The remaining marks, if any, will still
form a linear sequence.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_start
(
/* received */
PK_MARK_frustrum_t         /*frustrum*/,  /* frustrum functions */
const PK_MARK_start_o_t  * /*options*/    /* options structure */
);
/*
This function starts non-partitioned PK rollback.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_is_on
(
/* returned */
PK_LOGICAL_t *const  /*is_on*/           /* whether non-partitioned rollback active */
);
/*
This function returns whether the non-partitioned PK rollback system is active.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_is
(
/* received */
int                  /*may_be_mark*/,   /* potential mark */
/* returned */
PK_LOGICAL_t *const  /*is_mark*/        /* whether it is a mark */
);
/*
This function returns whether the given argument is a mark.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_following
(
/* received */
PK_MARK_t         /*mark*/,      /* a mark */
/* returned */
PK_MARK_t *const  /*following*/      /* its following mark */
);
/*
This function returns the mark following the given one. If the given mark is
the last mark, PK_MARK_null is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_preceding
(
/* received */
PK_MARK_t         /*mark*/,      /* a mark */
/* returned */
PK_MARK_t *const  /*preceding*/      /* its preceding mark */
);
/*
This function returns the mark preceding the given one. If the given mark is
the first mark, PK_MARK_null is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_state
(
/* returned */
PK_MARK_t    *const  /*current*/,        /* current (or immediately previous) mark */
PK_LOGICAL_t *const  /*is_at_mark*/      /* whether modeller is at mark */
);
/*
This function returns the current state of the non-partitioned PK rollback
system.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_frustrum
(
/* returned */
PK_MARK_frustrum_t *const  /*frustrum*/  /* frustrum functions */
);
/*
This function returns the registered frustrum of the non-partitioned PK
rollback system.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_forward
(
/* returned */
PK_LOGICAL_t *const  /*is_enabled*/      /* whether roll forward is enabled */
);
/*
This function returns PK_LOGICAL_true if roll-forward is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_stop
(
void
);
/*
This function shuts down the non-partitioned PK rollback system.
*/

PK_linkage_m PK_ERROR_code_t PK_MARK_ask_pmarks
(
/* received */
PK_MARK_t           /*mark*/,            /* mark to find pmarks for */
/* returned */
int         *const  /*n_pmarks*/,        /* number of pmarks of mark */
PK_PMARK_t **const  /*pmarks*/           /* pmarks of mark */
);
/*
This function returns the pmarks which are used by the given mark, i.e. those
which would be current if the given mark were rolled to - one for each
partition in the session.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_register_callbacks
(
/* received */
PK_MEMORY_frustrum_t  /*frustrum*/       /* application's memory handlers */
);
/*
This function registers memory allocation and free functions for Parasolid
to use when returning variable length information.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_ask_callbacks
(
/* returned */
PK_MEMORY_frustrum_t *const  /*frustrum*/       /* current memory handlers */
);
/*
This function returns the functions which are currently registered for
Parasolid to use when allocating and freeing variable length information
returned from the PK interface.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_free
(
/* received */
void           * /*pointer*/             /* pointer to allocated memory */
);
/*
This function frees previously allocated memory.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_alloc
(
/* received */
size_t           /*nbytes*/,             /* number of bytes required */
/* returned */
void    **const  /*pointer*/             /* allocated memory (possibly NULL) */
);
/*
This function allocates the specified amount of memory required in bytes.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_set_block_size
(
/* received */
size_t           /*size*/   /* required default block size */
);
/*
This function sets the size of the smallest block of memory that Parasolid
will request from FMALLO (PK_FMALLO_f_t) for modelling data.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_ask_block_size
(
/* returned */
size_t   *const  /*size*/   /* default block size */
);
/*
This function returns the current smallest size of a block of memory that
Parasolid will request from FMALLO (PK_FMALLO_f_t) for storing modelling data.
*/

PK_linkage_m PK_ERROR_code_t PK_MEMORY_block_f
(
/* received */
PK_MEMORY_block_t *const  /*block*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_entities
(
/* received */
PK_PMARK_t                        /*pmark*/,          /* destination pmark */
const PK_PMARK_ask_entities_o_t * /*options*/,        /* options structure */
/* returned */
int                       *const  /*n_new*/,          /* number of entities created */
int                      **const  /*new_entities*/,   /* entities created */
int                       *const  /*n_mod*/,          /* number of entities modified */
int                      **const  /*mod_entities*/,   /* entities modified */
int                       *const  /*n_del*/,          /* number of entities deleted */
int                      **const  /*del_entities*/    /* entities deleted */
);
/*
This function returns the entities that would be created, modified and deleted
if rolling to the destination `pmark'.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_is
(
/* received */
int                  /*may_be_pmark*/,  /* a potential pmark */
/* returned */
PK_LOGICAL_t *const  /*is_pmark*/       /* whether it is a pmark */
);
/*
This function returns PK_LOGICAL_true if its argument is a partition mark.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_delete
(
/* received */
int                 /*n_pmarks*/,         /* number of pmarks */
const PK_PMARK_t  * /*pmarks*/,           /* pmark array */
/* returned */
int         *const  /*n_bad_pmarks*/,     /* number of bad pmarks */
PK_PMARK_t **const  /*bad_pmarks*/        /* bad pmark array */
);
/*
This function deletes the given partition marks. It returns an array of
pmarks which could not be deleted.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_goto
(
/* received */
PK_PMARK_t           /*pmark*/,           /* pmark to go to */
/* returned */
int          *const  /*n_new*/,           /* number of entities created */
PK_ENTITY_t **const  /*new_entities*/,    /* entities created (optional) */
int          *const  /*n_mod*/,           /* number of entities modified */
PK_ENTITY_t **const  /*mod_entities*/,    /* entities modified (optional) */
int          *const  /*n_del*/,           /* number of entities deleted */
int         **const  /*del_entities*/     /* entities deleted (optional) */
);
/*
This function returns the partition to the state when the given pmark was
created.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_goto_2
(
/* received */
PK_PMARK_t                /*pmark*/,          /* pmark to go to */
const PK_PMARK_goto_o_t * /*options*/,        /* options structure */
/* returned */
int               *const  /*n_new*/,          /* number of entities created */
PK_ENTITY_t      **const  /*new_entities*/,   /* entities created */
int               *const  /*n_mod*/,          /* number of entities modified */
PK_ENTITY_t      **const  /*mod_entities*/,   /* entities modified */
int               *const  /*n_del*/,          /* number of entities deleted */
int              **const  /*del_entities*/    /* entities deleted */
);
/*
This function returns the partition to the state when the given pmark was
created.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_partition
(
/* received */
PK_PMARK_t             /*pmark*/,      /* a pmark */
/* returned */
PK_PARTITION_t *const  /*partition*/   /* the partition of the pmark */
);
/*
This function returns the partition of the given partition mark.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_following
(
/* received */
PK_PMARK_t          /*pmark*/,         /* a pmark */
/* returned */
int         *const  /*n_following*/,   /* number of following pmarks */
PK_PMARK_t **const  /*following*/      /* following pmarks (optional) */
);
/*
This function returns the pmarks following the given one, i.e. its alternative
future pmarks in the pmark graph.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_preceding
(
/* received */
PK_PMARK_t         /*pmark*/,         /* a pmark */
/* returned */
PK_PMARK_t *const  /*preceding*/      /* preceding pmark */
);
/*
This function returns the pmark preceding the given one, or PK_PMARK_null if
there is none.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_marks
(
/* received */
PK_PMARK_t         /*pmark*/,         /* a pmark */
/* returned */
int        *const  /*n_marks*/,       /* number of marks of pmark */
PK_MARK_t **const  /*marks*/          /* marks of pmark (optional) */
);
/*
This functions returns the marks which `use' the given pmark. A mark M uses
the given pmark if rolling to M would make the given pmark current.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_ask_identifier
(
/* received */
PK_PMARK_t       /*pmark*/,               /* pmark */
/* returned */
int      *const  /*identifier*/           /* identifier of pmark */
);
/*
This function returns the identifier of a pmark, which is a positive integer
unique within its partition.
*/

PK_linkage_m PK_ERROR_code_t PK_PMARK_is_used_by_mark
(
/* received */
PK_PMARK_t           /*pmark*/,       /* pmark to test */
/* returned */
PK_LOGICAL_t *const  /*is_used*/      /* whether it is used by a mark */
);
/*
This function returns PK_LOGICAL_true if the given pmark is used in a session
mark. That is, there is a session mark M such that if M were rolled to, the
given pmark would be current.
*/

PK_linkage_m PK_ERROR_code_t PK_BB_ask
(
/* received */
PK_BB_t            /*bb*/,       /* not used */
/* returned */
PK_BB_sf_t *const  /*bb_sf*/     /* bulletin board standard form */
);
/*
This function returns the standard form of the bulletin board.
*/

PK_linkage_m PK_ERROR_code_t PK_BB_ask_status
(
/* received */
PK_BB_t                /*bb*/,       /* not used */
/* returned */
PK_BB_status_t *const  /*status*/    /* present status */
);
/*
This function returns the status of the bulletin board.
*/

PK_linkage_m PK_ERROR_code_t PK_BB_create
(
/* received */
const PK_BB_sf_t * /*bb_sf*/,       /* bulletin board standard form */
/* returned */
PK_BB_t  *const    /*bb*/           /* not used */
);
/*
This function creates the bulletin board from its standard form.
*/

PK_linkage_m PK_ERROR_code_t PK_BB_is
(
/* received */
PK_BB_t              /*bb*/,       /* not used */
/* returned */
PK_LOGICAL_t *const  /*whether*/   /* whether the received argument is a bb */
);
/*
This function returns whether the received argument is a bulletin board.
*/

PK_linkage_m PK_ERROR_code_t PK_BB_is_empty
(
/* received */
PK_BB_t              /*bb*/,         /* not used */
/* returned */
PK_LOGICAL_t *const  /*is_empty*/    /* true if the BB is off or empty */
);
/*
This function returns PK_LOGICAL_true if the Bulletin Board is off, or on and
empty (i.e. has no events on it).
*/

PK_linkage_m PK_ERROR_code_t PK_BB_output_events
(
/* received */
PK_BB_t                /*bb*/,            /* not used */
PK_LOGICAL_t           /*empty*/,         /* whether to empty bulletin board */
/* returned */
int            *const  /*n_entities*/,    /* number of entities */
int           **const  /*events*/,        /* events to which entities belong */
PK_ENTITY_t   **const  /*entities*/,      /* entities */
PK_BB_event_t **const  /*event_types*/,   /* event types */
PK_CLASS_t    **const  /*classes*/,       /* classes of entities */
int           **const  /*user_fields*/    /* user fields */
);
/*
This function outputs the events stored in the bulletin board
*/

PK_linkage_m PK_ERROR_code_t PK_BB_set_status
(
/* received */
PK_BB_t          /*bb*/,       /* not used */
PK_BB_status_t   /*status*/    /* required status */
);
/*
This function sets the status of a bulletin board.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_close_knots
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether close knots are allowed */
);
/*
This function returns whether bgeometry may have knots closer together than the
session angular tolerance.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_angle_precision
(
/* returned */
double  *const   /*precision*/    /* precision */
);
/*
This function returns the session angle precision.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_attdefs
(
/* received */
const PK_SESSION_ask_attdefs_o_t * /*options*/,       /* options */
/* returned */
int                        *const  /*n_attdefs*/,     /* number of attribute */
PK_ATTDEF_t               **const  /*attdefs*/        /* attribute definitions */
);
/*
This function returns all user-defined attribute definitions in the session.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_check_arguments
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether argument checking is enabled */
);
/*
This function returns whether argument checking is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_check_continuity
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether continuity checking is enabled */
);
/*
This function returns whether continuity checking is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_check_self_int
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether self intersection checking is enabled */
);
/*
This function returns whether self intersection checking is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_curr_partition
(
/* returned */
PK_PARTITION_t *const  /*partition*/   /* current partition */
);
/*
This function returns the current partition.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_general_topology
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether generalised topology is enabled */
);
/*
This function returns whether generalised topology is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_function
(
/* returned */
const char   **const  /*fn_name*/          /* function name string */
);
/*
This function returns the name of the PK function currently being called.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_journalling
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether journalling is enabled */
);
/*
This function returns whether journalling is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_mark
(
/* returned */
PK_MARK_t    *const  /*mark*/,      /* current session mark (possibly PK_MARK_null) */
PK_LOGICAL_t *const  /*at_mark*/    /* whether at the mark or not */
);
/*
This function returns the current session mark, and whether the session is at
that mark or has been modified since it was created or rolled to.

If no session marks have been created, or they have all been deleted, then
PK_MARK_null will be returned.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_memory_usage
(
/* returned */
size_t   *const  /*total*/,   /* total amount of memory */
size_t   *const  /*free*/     /* free space */
);
/*
This function returns the amount of memory currently occupied by the model
data structure.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_partitions
(
/* returned */
int             *const  /*n_partitions*/,           /* number of partitions (>= 0) */
PK_PARTITION_t **const  /*partitions*/              /* partitions (optional) */
);
/*
This function returns the partitions in the session.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_parts
(
/* returned */
int        *const  /*n_parts*/,           /* number of parts (>= 0) */
PK_PART_t **const  /*parts*/              /* parts (optional) */
);
/*
This function returns all parts in the session.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_precision
(
/* returned */
double  *const   /*precision*/    /* required precision */
);
/*
This function returns the session precision.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_swept_spun_surfs
(
/* returned */
PK_LOGICAL_t *const  /*whether*/  /* whether swept/spun surfaces enabled */
);
/*
This function returns whether topological sweep and spin functions are
allowed to produce swept and spun surfaces.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_tag_highest
(
/* returned */
int      *const  /*highest_tag*/  /* value of highest tag allocated */
);
/*
This function returns the value of the highest tag allocated.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_tag_limit
(
/* returned */
int      *const  /*limit*/  /* tag value limit */
);
/*
This function returns whether tag limitation is enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_tags_remaining
(
/* returned */
int      *const  /*tags_remaining*/  /* number of available unused tags */
);
/*
This function returns the current number of tags which are available for
subsequent use.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_user_field_len
(
/* returned */
int *const       /*user_field_length*/  /* user field length */
);
/*
This function returns the length of the user fields.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_comment
(
/* received */
const char     * /*comment*/               /* null-terminated string to set */
);
/*
Write a comment to the journal file
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_is_roll_forward_on
(
/* returned */
PK_LOGICAL_t *const  /*roll_forward_on*/  /* roll forward interface parameter */
);
/*
This function returns PK_LOGICAL_true if the roll-forward interface parameter
is set to true, i.e. PK_MARK_goto is able to roll the session forwards.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_is_rollback_on
(
/* returned */
PK_LOGICAL_t *const  /*rollback_on*/  /* true if rollback is on */
);
/*
This function returns PK_LOGICAL_true if partitioned rollback has been enabled
(see PK_DELTA_register_callbacks), otherwise PK_LOGICAL_false.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_is_in_kernel
(
/* returned */
PK_LOGICAL_t *const  /*is_in_kernel*/,    /* whether called from within the kernel */
PK_LOGICAL_t *const  /*is_protected*/     /* whether called from protected region */
);
/*
This function returns whether it has been called from within the kernel or
from outside the kernel.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_is_in_kernel_2
(
/* returned */
PK_LOGICAL_t *const  /*is_in_kernel*/,    /* whether called from within the kernel */
PK_LOGICAL_t *const  /*is_protected*/,    /* whether called from protected region */
PK_LOGICAL_t *const  /*is_subthread*/     /* whether called from internal thread */
);
/*
This function returns whether it has been called from within the kernel or
from outside the kernel.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register_polling_cb
(
/* received */
const PK_SESSION_polling_cb_t   /*new*/,  /* function to register (may be NULL) */
/* returned */
PK_SESSION_polling_cb_t *const  /*old*/   /* pointer to space for previous */
);
/*
This function registers the given application polling callback function
and returns the previous value. `old' may be NULL, in which case the
previous value is not returned, `new' may also be NULL to cancel the
existing callback function.

The polling callback may be registered or changed at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_close_knots
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether close knots are allowed */
);
/*
This function sets whether bgeometry may have knots closer together than the
session angular tolerance.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_angle_precision
(
/* received */
double           /*angle_precision*/    /* required angle_precision */
);
/*
This function sets the session angle precision.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_check_arguments
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether argument checking required */
);
/*
This function sets whether argument checking is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_check_continuity
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether continuity checking required */
);
/*
This function sets whether continuity checking is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_check_self_int
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether self intersection checking required */
);
/*
This function sets whether self intersection checking is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_general_topology
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether generalised topology is to be enabled */
);
/*
This function sets whether generalised topology is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_journalling
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether journalling is to be enabled */
);
/*
This function sets whether journalling is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_precision
(
/* received */
double           /*precision*/    /* required precision */
);
/*
This function sets the session precision.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_roll_forward
(
/* received */
PK_LOGICAL_t   /*roll_forward_on*/  /* roll_forward parameter setting */
);
/*
This function sets the roll_forward interface parameter. If it is set to true,
PK_MARK_goto is able to roll the session forwards.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_swept_spun_surfs
(
/* received */
PK_LOGICAL_t     /*whether*/  /* whether swept/spun surfs are to be enabled */
);
/*
This function sets whether topological sweep and spin functions are
allowed to produce swept and spun surfaces.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_tag_limit
(
/* received */
int              /*limit*/  /* maximum tag value allowed */
);
/*
This function sets whether tag limitation is to be enabled.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_tidy
(
void
);
/*
This function ensures that PK is in a valid state whenever a longjump is made.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_smp
(
/* received */
const PK_SESSION_smp_o_t * /*options*/       /* SMP options */
);
/*
This function sets the Symmetric Multi-Processing (SMP) parameters
for the session.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_smp_stacksize
(
/* received */
size_t           /*size*/
);
/*
Set the size of the stack allocated to Parasolid SMP threads.

A zero value instructs Parasolid to use the platform default.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_smp
(
/* returned */
PK_SESSION_smp_r_t   *const  /*results*/       /* SMP return structure */
);
/*
This function retrieves the current session Symmetric Multi-Processing (SMP)
parameters.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_smp_stacksize
(
/* returned */
size_t   *const  /*size*/
);
/*
Returns the size of the stack allocated to Parasolid SMP threads.

A zero value means that Parasolid will use the platform default.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_watch_tags
(
/* received */
int                                  /*n_tags*/,      /* number of tags */
const int                            /*tags*/[],      /* tags to watch */
const PK_SESSION_watch_create_cb_t   /*create_fn*/,   /* create entity callback */
const PK_SESSION_watch_destroy_cb_t  /*destroy_fn*/   /* destroy entity callback */
);
/*
This function registers an array of tagged entities which are to be watched
via two application callback functions.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_software_option
(
/* received */
PK_SESSION_software_option_t     /*option*/,
/* returned */
int                            * /*ival*/
);
/*
Return the current setting of a variant software option.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_software_option
(
/* received */
PK_SESSION_software_option_t     /*option*/,
int                              /*ival*/
);
/*
Replace the setting of a variant software option.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register_frustrum
(
/* received */
const PK_SESSION_frustrum_t * /*new*/
);
/*
Installs a new frustrum.

This function may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_frustrum
(
/* returned */
PK_SESSION_frustrum_t *const  /*res*/
);
/*
Return the installed frustrum.

This function may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register_indexio
(
/* received */
const PK_SESSION_indexio_t * /*new*/
);
/*
Installs a new Indexed Frustrum.

This function may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_indexio
(
/* returned */
PK_SESSION_indexio_t *const  /*res*/
);
/*
Return the installed Indexed Frustrum.

This function may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register_applio
(
/* received */
const PK_SESSION_applio_t * /*new*/    /* functions to register (may be NULL) */
);
/*
This function registers a new set of functions for use when the 'applio' format
is selected for transmit files. If 'new' is NULL, all registered functions are
set to NULL.

It may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_applio
(
/* returned */
PK_SESSION_applio_t *const  /*res*/
);
/*
This function returns the registered 'applio' functions for transmit file
input and output.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register_applio_2
(
/* received */
const PK_SESSION_applio_t * /*new*/    /* functions to register (may be NULL) */
);
/*
This function registers a new set of functions for use when the 'applio' format
is selected for transmit files. If 'new' is NULL, all registered functions are
set to NULL.

It may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_applio_2
(
/* returned */
PK_SESSION_applio_t *const  /*res*/
);
/*
This function returns the registered 'applio' functions for transmit file
input and output.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_set_unicode
(
/* received */
PK_LOGICAL_t     /*whether*/      /* whether to enable Unicode keys */
);
/*
Enables/disables Unicode keys for Frustrum and application i/o.

This function can be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_unicode
(
/* returned */
PK_LOGICAL_t *const  /*whether*/
);
/*
Returns whether Unicode keys are enabled for Frustrum and application i/o.

This function can be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_kernel_version
(
/* returned */
PK_SESSION_kernel_version_t *const  /*info*/
);
/*
returns modeller version and datestamp
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_register
(
/* received */
int              /*code*/,
PK_POINTER_t     /*data*/
);
/*
This function allows mutual registration between Parasolid and companion
UGS toolkit products at run-time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_start
(
/* received */
const PK_SESSION_start_o_t * /*options*/
);
/*
This function starts the Parasolid modeller.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_stop
(
void
);
/*
This function stops the modeller.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_abort
(
/* received */
PK_abort_reason_t  /*reason*/
);
/*
This function makes a request to Parasolid to abort the interrupted current
operation.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_ask_binding
(
/* received */
PK_SESSION_binding_t             /*enquiry*/,
/* returned */
PK_SESSION_binding_t     *const  /*answer*/
);
/*
This function allows the application to identify the programming
language binding in use.

This function may be called at any time.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_receive
(
/* received */
const char                   * /*key*/,       /* key string */
const PK_SESSION_receive_o_t * /*options*/    /* receive options */
);
/*
This function receives a session from the given 'file' `key'.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_receive_u
(
/* received */
const PK_UCHAR_t             * /*key*/,       /* key string */
const PK_SESSION_receive_o_t * /*options*/    /* receive options */
);
/*
This function receives a session from the given Unicode 'file' `key'.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_receive_version
(
/* received */
const char                        * /*key*/,              /* key string */
PK_transmit_format_t                /*transmit_format*/,  /* file format */
/* returned */
PK_SESSION_kernel_version_t *const  /*version*/           /* version */
);
/*
This function returns information about the version of Parasolid used to create
a session transmit file.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_receive_version_u
(
/* received */
const PK_UCHAR_t                  * /*key*/,              /* key string */
PK_transmit_format_t                /*transmit_format*/,  /* file format */
/* returned */
PK_SESSION_kernel_version_t *const  /*version*/           /* version */
);
/*
This function returns information about the version of Parasolid used to create
a session transmit file.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_transmit
(
/* received */
const char                    * /*key*/,          /* key string */
const PK_SESSION_transmit_o_t * /*options*/       /* transmit options */
);
/*
This function transmits the session to the given 'file' `key'.
*/

PK_linkage_m PK_ERROR_code_t PK_SESSION_transmit_u
(
/* received */
const PK_UCHAR_t              * /*key*/,          /* key string */
const PK_SESSION_transmit_o_t * /*options*/       /* transmit options */
);
/*
This function transmits the session to the given Unicode 'file' `key'.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_ask_callbacks
(
/* returned */
PK_ERROR_frustrum_t *const  /*frustrum*/   /* session error handler */
);
/*
This function returns the application error handler for the session, (if one
is registered), or NULL.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_register_callbacks
(
/* received */
PK_ERROR_frustrum_t  /*frustrum*/          /* application's error handler */
);
/*
This function registers the given application error handler for the session.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_ask_last
(
/* returned */
PK_LOGICAL_t  *const  /*was_error*/,      /* whether there was an error */
PK_ERROR_sf_t *const  /*error_sf*/        /* description of the error */
);
/*
This function returns the standard form of the most recent PK error.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_clear_last
(
/* returned */
PK_LOGICAL_t *const  /*was_error*/        /* whether there was an error to clear */
);
/*
This function clears the most recent PK error.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_raise
(
/* received */
PK_ERROR_sf_t    /*error_sf*/         /* description of the error */
);
/*
This function raises a PK-format error.
*/

PK_linkage_m PK_ERROR_code_t PK_ERROR_reraise
(
/* returned */
PK_LOGICAL_t *const  /*was_error*/        /* whether there was an error to raise */
);
/*
This function repeats the most recent PK error.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_ask
(
/* received */
PK_REPORT_t           /*report*/,        /* which report required */
/* returned */
PK_REPORT_r_t *const  /*report_r*/        /* report data */
);
/*
This function returns the data of the requested `report'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_clear
(
/* received */
PK_REPORT_t      /*report*/    /* which report to clear */
);
/*
This function clears the requested `report'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_add_records
(
/* received */
PK_REPORT_t               /*report*/,            /* which report to append to */
int                       /*n_report_records*/,  /* number of report records */
const PK_REPORT_record_t  /*report_records*/[]   /* report records */
);
/*
This function adds the given `report_records' to the `report'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_r_f
(
/* received */
PK_REPORT_r_t *const  /*report_r*/    /* report return type */
);
/*
This function frees the memory of a PK_REPORT_r_t
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_close
(
/* received */
PK_REPORT_t      /*report*/
);
/*
This function closes the given `report'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_create
(
/* received */
const char        * /*name*/,        /* name of report */
/* returned */
PK_REPORT_t *const  /*report*/       /* identifier of report */
);
/*
This function creates a `report' with the given `name'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_find
(
/* received */
const char        * /*name*/,         /* name of report */
/* returned */
PK_REPORT_t *const  /*report*/       /* identifier of report */
);
/*
This function returns the `report' which has the given `name'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_delete
(
/* received */
PK_REPORT_t      /*report*/      /* report no longer required */
);
/*
This function deletes a `report'.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_set_function
(
/* received */
PK_REPORT_t      /*report*/,
const char     * /*function*/
);
/*
This function sets the function name of a report.
*/

PK_linkage_m PK_ERROR_code_t PK_REPORT_is_open
(
/* received */
PK_REPORT_t          /*report*/,     /* the report */
/* returned */
PK_LOGICAL_t *const  /*is_open*/     /* whether report is open or closed */
);
/*
This function returns PK_LOGICAL_true if the given report is open and
PK_LOGICAL_false if it is closed.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_function
(
/* received */
int                 /*depth*/,        /* recursion depth */
/* returned */
const char **const  /*fn_name*/,      /* function name string (may be NULL) */
int         *const  /*total_depth*/   /* current total recursion depth (>= 0) */
);
/*
This function returns the name of the PK function being executed in the
calling thread and the total recursion depth of its current call stack.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_is_in_kernel
(
/* returned */
PK_LOGICAL_t *const  /*is_in_kernel*/,    /* whether called from within the kernel */
PK_LOGICAL_t *const  /*is_protected*/,    /* whether called from protected region */
PK_LOGICAL_t *const  /*is_subthread*/,    /* whether called from internal thread */
PK_LOGICAL_t *const  /*is_excluding*/     /* whether function is excluding threads */
);
/*
This function returns whether the calling thread is executing inside the
kernel.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_tidy
(
void
);
/*
This function ensures that Parasolid is in a valid state for the calling
thread whenever a longjump is made.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_last_error
(
/* returned */
PK_LOGICAL_t  *const  /*was_error*/,      /* whether there was an error */
PK_ERROR_sf_t *const  /*error_sf*/        /* description of the error */
);
/*
This function returns the standard form of the most recent PK error in the
calling thread.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_clear_last_error
(
/* returned */
PK_LOGICAL_t *const  /*was_error*/        /* whether there was an error to clear */
);
/*
This function clears the most recent PK error in the calling thread.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_error_cbs
(
/* returned */
PK_ERROR_frustrum_t *const  /*frustrum*/   /* thread error handler */
);
/*
This function returns the error handler for the calling thread (if one is
registered), or NULL.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_register_error_cbs
(
/* received */
PK_ERROR_frustrum_t  /*frustrum*/          /* application's error handler */
);
/*
This function registers the given error handler for the calling thread.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_memory_cbs
(
/* returned */
PK_MEMORY_frustrum_t *const  /*frustrum*/       /* thread memory handlers */
);
/*
This function returns the functions which are currently registered for the
calling thread to use when allocating and freeing variable length information
returned from the PK interface.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_register_memory_cbs
(
/* received */
PK_MEMORY_frustrum_t  /*frustrum*/       /* application's memory handlers */
);
/*
This function registers memory allocation and free functions for the calling
thread to use in Parasolid when returning variable length information.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_exclusion
(
/* returned */
PK_THREAD_exclusion_t *const  /*exclusion*/,       /* type of thread exclusion */
PK_LOGICAL_t          *const  /*was_this_thread*/  /* whether the calling thread */
);
/*
This function returns whether the Parasolid interface is currently excluding
other threads entering and whether the calling thread caused the exclusion.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_clear_exclusion
(
/* received */
PK_THREAD_exclusion_t         /*clear*/,           /* type of exclusion to clear */
/* returned */
PK_THREAD_exclusion_t *const  /*exclusion*/,       /* type of thread exclusion */
PK_LOGICAL_t          *const  /*was_this_thread*/  /* whether the calling thread */
);
/*
This function tries to clear an exclusion that may be preventing other threads
from entering Parasolid.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_chain_start
(
/* received */
PK_THREAD_chain_type_t            /*type*/,
const PK_THREAD_chain_start_o_t * /*options*/
);
/*
This function starts chaining Parasolid functions in the calling thread.
The exclusivity of this function is dynamic and corresponds with the value
of `type'.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_chain_stop
(
/* received */
const PK_THREAD_chain_stop_o_t * /*options*/
);
/*
This function stops chaining Parasolid functions in the calling thread.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_is_in_chain
(
/* returned */
PK_THREAD_chain_type_t *const  /*type*/,
int                    *const  /*length*/,
int                    *const  /*remaining*/
);
/*
This function returns the type of chain running in the calling thread, along
with its link length and the maximum number of remaining functions in the
current chain link.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_ask_function_run
(
/* received */
int                                    /*n_functions*/,   /* number of functions */
const PK_FUNCTION_t                    /*functions*/[],   /* functions */
const PK_THREAD_ask_function_run_o_t * /*options*/,       /* options structure */
/* returned */
PK_FUNCTION_run_t                      /*run_values*/[]   /* how functions run */
);
/*
This function asks whether the given PK functions will be run concurrently
or exclusively in this thread.
*/

PK_linkage_m PK_ERROR_code_t PK_THREAD_set_function_run
(
/* received */
int                                    /*n_functions*/,   /* number of functions */
const PK_FUNCTION_t                    /*functions*/[],   /* functions */
const PK_FUNCTION_run_t                /*run_values*/[],  /* how functions run */
const PK_THREAD_set_function_run_o_t * /*options*/        /* options structure */
);
/*
This function sets whether the given PK functions will be run concurrently
or exclusively in this thread.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_track_r_f
(
/* received */
PK_ENTITY_track_r_t *const  /*tracking*/   /* tracking information to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_attribs
(
/* received */
PK_ENTITY_t          /*entity*/,          /* entity */
PK_ATTDEF_t          /*attdef*/,          /* attribute definition */
/* returned */
int          *const  /*n_attribs*/,       /* number of attributes (>=0) */
PK_ATTRIB_t **const  /*attribs*/          /* array of attributes  (optional) */
);
/*
This function returns all the attributes with the given attribute definition
directly attached to the given entity. If the attribute definition is
PK_ENTITY_null, then all attributes of any type are returned.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_class
(
/* received */
PK_ENTITY_t        /*entity*/,            /* entity */
/* returned */
PK_CLASS_t *const  /*class*/              /* class of entity */
);
/*
This function returns the given entity's concrete class.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_description
(
/* received */
int                                       /*tag*/,  /* PK entity or internal tag */
const PK_ENTITY_ask_description_o_t * /*options*/,  /* options structure */
/* returned */
char **const                      /*description*/   /* ptr to null terminated string */
);
/*
This function returns a textual description of Parasolid's internal
representation of a PK entity
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_first_attrib
(
/* received */
PK_ENTITY_t         /*entity*/,           /* entity */
PK_ATTDEF_t         /*attdef*/,           /* attribute definition */
/* returned */
PK_ATTRIB_t *const  /*attrib*/            /* an attribute on entity of given attdef. */
);
/*
This function returns an attribute with the given attribute definition
attached to the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_identifier
(
/* received */
PK_ENTITY_t      /*entity*/,              /* entity */
/* returned */
int      *const  /*identifier*/           /* identifier of entity (possibly 0) */
);
/*
This function returns the identifier of an entity within a part.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_owning_groups
(
/* received */
PK_ENTITY_t         /*entity*/,           /* an entity */
/* returned */
int         *const  /*n_groups*/,         /* number of groups (>=0) */
PK_GROUP_t **const  /*groups*/            /* groups (optional) */
);
/*
This function returns the set of groups of which the given entity is a member.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_partition
(
/* received */
PK_ENTITY_t            /*entity*/,      /* an entity */
/* returned */
PK_PARTITION_t *const  /*partition*/    /* partition of entity */
);
/*
This function returns the partition containing the given entity. If the
entity is an attribute definition, the partition will be PK_PARTITION_null,
otherwise it will be non-null.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_ask_user_field
(
/* received */
PK_ENTITY_t      /*entity*/,       /* entity to receive message */
/* returned */
int      *const  /*user_field*/    /* user_field values */
);
/*
This function returns the user field values for the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_check_attribs
(
/* received */
PK_ENTITY_t                          /*entity*/,      /* entity */
PK_ATTDEF_t                          /*attdef*/,      /* attribute definition */
const PK_ENTITY_check_attribs_o_t  * /*options*/,     /* options structure */
/* returned */
int                          *const  /*n_faults*/,    /* number of bad attributes */
PK_check_fault_t            **const  /*faults*/       /* attribute fault information */
);
/*
This function checks the system attributes attached to the given entity, and
returns information concerning the faulty attributes found, if any.  These are
attributes with definitions having names of the form "SDL/TYSA_xxx".
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_copy
(
/* received */
PK_ENTITY_t         /*entity*/,           /* an entity */
/* returned */
PK_ENTITY_t *const  /*entity_copy*/       /* copy of given entity */
);
/*
This function produces a new entity which is a copy of the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_copy_2
(
/* received */
PK_ENTITY_t                 /*entity*/,       /* an entity */
const PK_ENTITY_copy_o_t  * /*options*/,      /* options structure */
/* returned */
PK_ENTITY_t         *const  /*entity_copy*/,  /* copy of given entity */
PK_ENTITY_track_r_t *const  /*tracking*/      /* tracking information */
);
/*
This function produces a new entity which is a copy of the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_delete
(
/* received */
int                 /*n_entities*/,       /* number of entities to be deleted */
const PK_ENTITY_t * /*entities*/          /* entities to be deleted */
);
/*
This function deletes the given entities.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_delete_attribs
(
/* received */
PK_ENTITY_t      /*entity*/,              /* entity */
PK_ATTDEF_t      /*attdef*/,              /* attribute definition */
/* returned */
int      *const  /*n_deleted*/            /* number of attributes deleted (>=0) */
);
/*
This function deletes any attributes with the given definition directly
attached to the given entity.  If the attribute definition is
PK_ENTITY_null, all attributes, of any type, are deleted.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is
(
/* received */
int                  /*may_be_entity*/,   /* potential entity */
/* returned */
PK_LOGICAL_t *const  /*is_entity*/        /* whether it is an entity */
);
/*
This function returns whether the given argument is an entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is_curve
(
/* received */
PK_ENTITY_t          /*entity*/,          /* an entity */
/* returned */
PK_LOGICAL_t *const  /*is_curve*/         /* whether entity is a curve */
);
/*
This function returns whether the given entity is a curve.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is_geom
(
/* received */
PK_ENTITY_t          /*entity*/,          /*an  entity */
/* returned */
PK_LOGICAL_t *const  /*is_geom*/          /* whether entity is geometry */
);
/*
This function returns whether the given entity is geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is_part
(
/* received */
PK_ENTITY_t          /*entity*/,         /* an entity */
/* returned */
PK_LOGICAL_t *const  /*is_part*/         /* whether entity is a part */
);
/*
This function returns whether the given entity is a part.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is_surf
(
/* received */
PK_ENTITY_t          /*entity*/,          /* an entity */
/* returned */
PK_LOGICAL_t *const  /*is_surf*/          /* whether entity is a surface */
);
/*
This function returns whether the given entity is a surface.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_is_topol
(
/* received */
PK_ENTITY_t          /*entity*/,           /* entity */
/* returned */
PK_LOGICAL_t *const  /*is_topol*/          /* whether entity is topology */
);
/*
This function returns whether the given entity is topology.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_may_own_attdef
(
/* received */
PK_ENTITY_t          /*entity*/,          /* entity */
PK_ATTDEF_t          /*attdef*/,          /* attribute definition */
/* returned */
PK_LOGICAL_t *const  /*whether*/
);
/*
This function returns PK_LOGICAL_true if an attribute constructed from the
given attribute definition could be attached to the given entity, otherwise
PK_LOGICAL_false.
*/

PK_linkage_m PK_ERROR_code_t PK_ENTITY_set_user_field
(
/* received */
PK_ENTITY_t      /*entity*/,       /* entity to receive message */
const int      * /*user_field*/    /* user_field values */
/* returned */
);
/*
This function sets the user field values for the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_ask
(
/* received */
PK_ATTDEF_t            /*attdef*/,        /* attribute definition */
/* returned */
PK_ATTDEF_sf_t *const  /*attsf*/
);
/*
This function writes the standard form of an attribute definition at the
given address. The application is not required to initialise any of the fields
of the standard form but assumes responsibility for subsequently deallocating
array fields of non zero length.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_create
(
/* received */
const PK_ATTDEF_sf_t * /*attsf*/,
/* returned */
PK_ATTDEF_t    *const  /*attdef*/         /* attribute definition */
);
/*
This function creates an attribute definition from the given standard form.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_ask_2
(
/* received */
PK_ATTDEF_t              /*attdef*/,        /* attribute definition */
/* returned */
PK_ATTDEF_sf_2_t *const  /*attsf*/
);
/*
This function writes the standard form of an attribute definition at the
given address. The application is not required to initialise any of the fields
of the standard form but assumes responsibility for subsequently deallocating
array fields of non zero length.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_create_2
(
/* received */
const PK_ATTDEF_sf_2_t * /*attsf*/,
/* returned */
PK_ATTDEF_t      *const  /*attdef*/         /* attribute definition */
);
/*
This function creates an attribute definition from the given standard form.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_register_cb
(
/* received */
PK_ATTDEF_t                       /*attdef*/,     /* attribute definition */
const PK_ATTDEF_callback_fns_t  * /*callbacks*/,  /* callback functions */
const PK_ATTDEF_register_cb_o_t * /*options*/     /* options */
);
/*
This function registers a set of callback functions to be called when entities
with attributes with definition `attdef' undergo certain events.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_register_callbacks
(
/* received */
PK_ATTDEF_t                      /*attdef*/,        /* attribute definition */
const PK_ATTDEF_callback_fns_t * /*callbacks*/      /* callback functions */
);
/*
This function registers a set of callback functions to be called when entities
with attributes with definition `attdef' undergo certain events.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_ask_callbacks
(
/* received */
PK_ATTDEF_t                      /*attdef*/,        /* attribute definition */
/* returned */
PK_ATTDEF_callback_fns_t *const  /*callbacks*/      /* callback functions */
);
/*
This function returns the attribute callback functions associated with
`attdef'. If PK_ATTDEF_register_callbacks or PK_ATTDEF_register_cb has not yet
been called on this attribute definition, the functions returned will all be
NULL.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_set_callback_flags
(
/* received */
PK_ATTDEF_t                        /*attdef*/,        /* attribute definition */
const PK_ATTDEF_callback_flags_t * /*flags*/          /* callback flags */
);
/*
This functions set the callback function on/off flags associated with
`attdef'.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_ask_callback_flags
(
/* received */
PK_ATTDEF_t                      /*attdef*/,        /* attribute definition */
/* returned */
PK_ATTDEF_callback_flags_t *const  /*flags*/      /* callback flags */
);
/*
This function returns the attribute callback flags associated with
`attdef'. If PK_ATTDEF_set_callback_flags has not yet been called on this
attribute definition, the flags returned will all be PK_LOGICAL_false.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTDEF_find
(
/* received */
const char        * /*name*/,             /* attribute definition name */
/* returned */
PK_ATTDEF_t *const  /*attdef*/            /* attribute definition */
);
/*
This function returns the attribute definition that has the given name.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_owner
(
/* received */
PK_ATTRIB_t         /*attrib*/,           /* attribute */
/* returned */
PK_ENTITY_t *const  /*owner*/             /* entity which owns attribute */
);
/*
This function returns the owner of an attribute, i.e. the entity to which it
is attached.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_attdef
(
/* received */
PK_ATTRIB_t         /*attrib*/,           /* attribute */
/* returned */
PK_ATTDEF_t *const  /*attdef*/            /* attribute definition */
);
/*
This function returns the attribute definition of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_ints
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0 ) */
/* returned */
int      *const  /*n_ints*/,              /* number of ints    (>= 0) */
int     **const  /*ints*/                 /* integers (optional) */
);
/*
This function returns the array of integers from field `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_ints
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
/* returned */
int      *const  /*n_ints*/,              /* number of ints    (>= 0) */
int     **const  /*ints*/                 /* integers (optional) */
);
/*
This function returns the array of integers from field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_doubles
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
/* returned */
int      *const  /*n_doubles*/,           /* number of doubles (>=0) */
double  **const  /*doubles*/              /* doubles (optional) */
);
/*
This function returns the array of doubles from field `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_doubles
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
/* returned */
int      *const  /*n_doubles*/,           /* number of doubles (>=0) */
double  **const  /*doubles*/              /* doubles (optional) */
);
/*
This function returns the array of doubles from field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_string
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
/* returned */
char    **const  /*string*/               /* pointer to character string */
);
/*
This function returns the character string stored in field number `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_string
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
/* returned */
char    **const  /*string*/               /* pointer to character string */
);
/*
This function returns the character string stored in field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_ustring
(
/* received */
PK_ATTRIB_t         /*attrib*/,       /* attribute */
int                 /*field_no*/,     /* field number (>= 0) */
/* returned */
PK_UCHAR_t **const  /*string*/        /* pointer to Unicode string */
);
/*
This function returns the Unicode string stored in field number `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_ustring
(
/* received */
PK_ATTRIB_t         /*attrib*/,       /* attribute */
const char        * /*field_name*/,   /* field name */
/* returned */
PK_UCHAR_t **const  /*string*/        /* pointer to Unicode string */
);
/*
This function returns the Unicode string stored in field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_vectors
(
/* received */
PK_ATTRIB_t          /*attrib*/,          /* attribute */
int                  /*field_no*/,        /* field number (>= 0) */
/* returned */
int          *const  /*n_vectors*/,       /* number of vectors (>= 0) */
PK_VECTOR_t **const  /*vectors*/          /* vectors (optional) */
);
/*
This function returns the array of vectors from field `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_vectors
(
/* received */
PK_ATTRIB_t          /*attrib*/,          /* attribute */
const char         * /*field_name*/,      /* field name */
/* returned */
int          *const  /*n_vectors*/,       /* number of vectors (>= 0) */
PK_VECTOR_t **const  /*vectors*/          /* vectors (optional) */
);
/*
This function returns the array of vectors from field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_axes
(
/* received */
PK_ATTRIB_t            /*attrib*/,        /* attribute */
int                    /*field_no*/,      /* field number (>= 0) */
/* returned */
int            *const  /*n_axes*/,        /* number of axes (>=0) */
PK_AXIS1_sf_t **const  /*axes*/           /* axes (optional) */
);
/*
This function returns the array of axes from field `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_axes
(
/* received */
PK_ATTRIB_t            /*attrib*/,        /* attribute */
const char           * /*field_name*/,    /* field name */
/* returned */
int            *const  /*n_axes*/,        /* number of axes (>=0) */
PK_AXIS1_sf_t **const  /*axes*/           /* axes (optional) */
);
/*
This function returns the array of axes from field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_pointers
(
/* received */
PK_ATTRIB_t           /*attrib*/,               /* attribute */
int                   /*field_no*/,             /* field number (>= 0) */
/* returned */
int           *const  /*n_pointers*/,           /* number of pointers (>=0) */
PK_POINTER_t **const  /*pointers*/              /* pointers (optional) */
);
/*
This function returns the array of pointers from field `field_no'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_named_pointers
(
/* received */
PK_ATTRIB_t           /*attrib*/,               /* attribute */
const char          * /*field_name*/,           /* field name */
/* returned */
int           *const  /*n_pointers*/,           /* number of pointers (>=0) */
PK_POINTER_t **const  /*pointers*/              /* pointers (optional) */
);
/*
This function returns the array of pointers from field `field_name'
of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_nth_int
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
int              /*index*/,               /* index of integer (>= 0) */
/* returned */
int      *const  /*n*/                    /* nth integer */
);
/*
This function returns a single element of the integer array from field
`field_no' of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_nth_double
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
int              /*index*/,               /* index of double (>= 0) */
/* returned */
double   *const  /*d*/                    /* nth double. */
);
/*
This function returns a single element of the double array from field
`field_no' of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_nth_vector
(
/* received */
PK_ATTRIB_t         /*attrib*/,           /* attribute */
int                 /*field_no*/,         /* field number (>= 0) */
int                 /*index*/,            /* index of vector (>= 0) */
/* returned */
PK_VECTOR_t *const  /*vector*/             /* nth vector */
);
/*
This function returns a single element of the vector array from field
`field_no' of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_nth_axis
(
/* received */
PK_ATTRIB_t           /*attrib*/,         /* attribute */
int                   /*field_no*/,       /* field number (>= 0) */
int                   /*index*/,          /* index of axis (>= 0) */
/* returned */
PK_AXIS1_sf_t *const  /*axis*/            /* nth axis */
);
/*
This function returns a single element of the axis array from field
`field_no' of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_ask_nth_pointer
(
/* received */
PK_ATTRIB_t          /*attrib*/,              /* attribute */
int                  /*field_no*/,            /* field number (>= 0) */
int                  /*index*/,               /* index of pointer (>= 0) */
/* returned */
PK_POINTER_t *const  /*pointer*/              /* nth pointer. */
);
/*
This function returns a single element of the pointer array from field
`field_no' of the given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_create_empty
(
/* received */
PK_ENTITY_t         /*entity*/,           /* entity to attach to */
PK_ATTDEF_t         /*attdef*/,           /* attribute definition */
/* returned */
PK_ATTRIB_t *const  /*attrib*/            /* created attribute */
);
/*
This function creates an attribute with the given definition with no data
(all fields of length zero), and attaches it to the given entity.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_ints
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
int              /*n_ints*/,              /* number of ints (>= 0) */
const int        /*ints*/[]               /* ints to set */
);
/*
This function copies `ints' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_ints
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
int              /*n_ints*/,              /* number of ints (>= 0) */
const int        /*ints*/[]               /* ints to set */
);
/*
This function copies `ints' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_doubles
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
int              /*n_doubles*/,           /* number of doubles (>= 0) */
const double     /*doubles*/[]            /* doubles to set */
);
/*
This function copies `doubles' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_doubles
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
int              /*n_doubles*/,           /* number of doubles (>= 0) */
const double     /*doubles*/[]            /* doubles to set */
);
/*
This function copies `doubles' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_string
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
int              /*field_no*/,            /* field number (>= 0) */
const char     * /*string*/               /* null-terminated string to set */
);
/*
This function copies `string' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_string
(
/* received */
PK_ATTRIB_t      /*attrib*/,              /* attribute */
const char     * /*field_name*/,          /* field name */
const char     * /*string*/               /* null-terminated string to set */
);
/*
This function copies `string' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_ustring
(
/* received */
PK_ATTRIB_t        /*attrib*/,        /* attribute */
int                /*field_no*/,      /* field number (>= 0) */
const PK_UCHAR_t * /*string*/         /* null-terminated string to set */
);
/*
This function copies Unicode `string' into field number `field_no' of the
given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_ustring
(
/* received */
PK_ATTRIB_t        /*attrib*/,        /* attribute */
const char       * /*field_name*/,    /* field name */
const PK_UCHAR_t * /*string*/         /* null-terminated string to set */
);
/*
This function copies Unicode `string' into field `field_name' of the
given attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_vectors
(
/* received */
PK_ATTRIB_t        /*attrib*/,            /* attribute */
int                /*field_no*/,          /* field number (>= 0) */
int                /*n_vectors*/,         /* number of vectors (>=0) */
const PK_VECTOR_t  /*vectors*/[]          /* vectors to set */
);
/*
This function copies `vectors' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_vectors
(
/* received */
PK_ATTRIB_t        /*attrib*/,            /* attribute */
const char       * /*field_name*/,        /* field name */
int                /*n_vectors*/,         /* number of vectors (>=0) */
const PK_VECTOR_t  /*vectors*/[]          /* vectors to set */
);
/*
This function copies `vectors' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_axes
(
/* received */
PK_ATTRIB_t          /*attrib*/,          /* attribute */
int                  /*field_no*/,        /* field number (>= 0) */
int                  /*n_axes*/,          /* number of axes (>= 0) */
const PK_AXIS1_sf_t  /*axes*/[]           /* axes to set */
);
/*
This function copies `axes' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_axes
(
/* received */
PK_ATTRIB_t          /*attrib*/,          /* attribute */
const char         * /*field_name*/,      /* field name */
int                  /*n_axes*/,          /* number of axes (>= 0) */
const PK_AXIS1_sf_t  /*axes*/[]           /* axes to set */
);
/*
This function copies `axes' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_pointers
(
/* received */
PK_ATTRIB_t         /*attrib*/,              /* attribute */
int                 /*field_no*/,            /* field number (>= 0) */
int                 /*n_pointers*/,          /* number of pointers (>= 0) */
const PK_POINTER_t  /*pointers*/[]           /* pointers to set */
);
/*
This function copies `pointers' into field number `field_no' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_ATTRIB_set_named_pointers
(
/* received */
PK_ATTRIB_t         /*attrib*/,              /* attribute */
const char        * /*field_name*/,          /* field name */
int                 /*n_pointers*/,          /* number of pointers (>= 0) */
const PK_POINTER_t  /*pointers*/[]           /* pointers to set */
);
/*
This function copies `pointers' into field `field_name' of the given
attribute.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_create_from_entities
(
/* received */
PK_PART_t          /*part*/,              /* part within which group is to be */
PK_CLASS_t         /*entity_class*/,      /* allowed class of entities in group */
int                /*n_entities*/,        /* number of entities  (>=0) */
const PK_ENTITY_t  /*entities*/[],        /* entities */
/* returned */
PK_GROUP_t *const  /*group*/              /* group created */
);
/*
This function creates a group within the given part containing the given
set of entities.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_ask_entities
(
/* received */
PK_GROUP_t           /*group*/,           /* group */
/* returned */
int          *const  /*n_entities*/,      /* number of entities (>=0) */
PK_ENTITY_t **const  /*entities*/         /* entities  (optional) */
);
/*
This function returns the set of entities contained in the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_ask_entity_class
(
/* received */
PK_GROUP_t         /*group*/,             /* group */
/* returned */
PK_CLASS_t *const  /*entity_class*/       /* class of entity allowed in the group */
);
/*
This function returns the class of the entities allowed in the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_ask_entity_label
(
/* received */
PK_GROUP_t       /*group*/,           /* group */
PK_ENTITY_t      /*entity*/,          /* entity in the group */
/* returned */
int      *const  /*entity_label*/     /* label of the entity in the group */
);
/*
This function returns the label of the given entity in the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_ask_part
(
/* received */
PK_GROUP_t        /*group*/,              /* group */
/* returned */
PK_PART_t *const  /*part*/                /* the part containing this group */
);
/*
This function returns the part which contains the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_contains_entity
(
/* received */
PK_GROUP_t           /*group*/,           /* group */
PK_ENTITY_t          /*entity*/,          /* entity */
/* returned */
PK_LOGICAL_t *const  /*is_contained*/     /* is the entity contained in the group ? */
);
/*
This function returns whether the given entity is contained in the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_find_entities
(
/* received */
PK_GROUP_t                         /*group*/,       /* group */
const PK_GROUP_find_entities_o_t * /*options*/,     /* find options */
/* returned */
int                        *const  /*n_entities*/,  /* number of entities (>=0) */
PK_ENTITY_t               **const  /*entities*/     /* entities */
);
/*
This function finds entities in the given group based on the given options.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_add_entities
(
/* received */
PK_GROUP_t         /*group*/,             /* group */
int                /*n_entities*/,        /* number of entities (>=0) */
const PK_ENTITY_t  /*entities*/[]         /* entities */
);
/*
This function adds the given set of entities to the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_merge_entities
(
/* received */
PK_GROUP_t         /*group*/,             /* group */
int                /*n_entities*/,        /* number of entities (>=0) */
const PK_ENTITY_t  /*entities*/[],        /* entities */
/* returned */
int        *const  /*n_added*/            /* number of entities added to group (>=0) */
);
/*
This function merges the given array of entities into the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_remove_entities
(
/* received */
PK_GROUP_t         /*group*/,         /* group */
int                /*n_entities*/,    /* number of entities */
const PK_ENTITY_t  /*entities*/[],    /* entities */
/* returned */
int        *const  /*n_removed*/      /* number of entities removed from group */
);
/*
This function removes from the given group, any entities which are also in
the given array of entities.
*/

PK_linkage_m PK_ERROR_code_t PK_GROUP_set_entity_label
(
/* received */
PK_GROUP_t       /*group*/,           /* group */
PK_ENTITY_t      /*entity*/,          /* entity in the group */
int              /*entity_label*/     /* label of the entity in the group */
);
/*
This function sets the label of the given entity in the given group.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create
(
/* received */
const PK_TRANSF_sf_t * /*transf_sf*/,   /* transf standard form */
/* returned */
PK_TRANSF_t    *const  /*transf*/       /* created transf */
);
/*
This function creates a transf from the given standard form.  See
documentation for PK_TRANSF_sf_t.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_ask
(
/* received */
PK_TRANSF_t            /*transf*/,      /* transf to receive message */
/* returned */
PK_TRANSF_sf_t *const  /*transf_sf*/    /* transf standard form */
);
/*
This function returns the standard form of the given transf.
The application is responsible for allocating the standard form, but need not
initialise any of the fields.  See documentation for PK_TRANSF_sf_t.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_transform
(
/* received */
PK_TRANSF_t         /*transf_1*/,     /* first transformation */
PK_TRANSF_t         /*transf_2*/,     /* second transformation */
/* returned */
PK_TRANSF_t *const  /*transf_out*/
);
/*
This function evaluates the product of two transformations.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create_equal_scale
(
/* received */
double              /*scale*/,        /* scaling factor */
PK_VECTOR_t         /*centre*/,       /* centre of scaling */
/* returned */
PK_TRANSF_t *const  /*transf*/        /* equal scaling transformation */
);
/*
This function creates an equal scaling transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create_reflection
(
/* received */
PK_VECTOR_t         /*position*/,     /* position on plane */
PK_VECTOR1_t        /*normal*/,       /* normal direction */
/* returned */
PK_TRANSF_t *const  /*transf*/        /* reflection transformation */
);
/*
This function creates a reflection transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create_rotation
(
/* received */
PK_VECTOR_t         /*position*/,     /* position on axis */
PK_VECTOR1_t        /*axis*/,         /* axis direction */
double              /*angle*/,        /* rotation angle (radians) */
/* returned */
PK_TRANSF_t *const  /*transf*/        /* rotation transformation */
);
/*
This function creates a rotation transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create_translation
(
/* received */
PK_VECTOR_t         /*displacement*/,     /* direction and distance */
/* returned */
PK_TRANSF_t *const  /*transf*/            /* translation transformation */
);
/*
Create a translation transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_check
(
/* received */
PK_TRANSF_t                 /*transf*/,       /* transformation to be checked */
const PK_TRANSF_check_o_t * /*options*/,      /* options structure */
/* returned */
int                 *const  /*n_faults*/,     /* number of faults */
PK_check_fault_t   **const  /*faults*/        /* faults */
);
/*
This function checks the given transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_create_view
(
/* received */
PK_VECTOR1_t                       /*view_direction*/,       /* view direction */
const PK_TRANSF_create_view_o_t  * /*options*/,              /* option structure */
/* returned */
PK_TRANSF_t *const                 /*transf*/                /* the view transform */
);
/*
This function returns a valid viewing transform given a unit vector that
designates the desired `view_direction'. Optionally an `eye_position' can be
provided via the options structure in order to add perspective behaviour to the
transform. This can be done by setting the flag `have_eye_position' to
PK_LOGICAL_true.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_is_equal
(
/* received */
PK_TRANSF_t          /*t1*/,       /* first transformation */
PK_TRANSF_t          /*t2*/,       /* second transformation */
/* returned */
PK_LOGICAL_t *const  /*is_equal*/  /* whether transformations are equal */
);
/*
This function determines whether two transformations are equal.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_classify_r_f
(
/* received */
PK_TRANSF_classify_r_t *const  /*result*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TRANSF_classify
(
/* received */
PK_TRANSF_t                    /*transf*/,       /* transformation to be classified */
const PK_TRANSF_classify_o_t * /*options*/,      /* options structure */
/* returned */
PK_TRANSF_classify_r_t *const  /*results*/       /* results */
);
/*
This function classifies a supplied transform and optionally returns
diagnostic information in the form of numerical data.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_ask_entities_by_attdef
(
/* received */
PK_TOPOL_t           /*topol*/,           /* topological entity */
PK_CLASS_t           /*class*/,           /* class of requested entities */
PK_LOGICAL_t         /*have_attrib*/,     /* whether entities have an attribute */
PK_ATTDEF_t          /*attdef*/,          /* attribute definition */
/* returned */
int          *const  /*n_entities*/,      /* number of entities ( >= 0 ) */
PK_ENTITY_t **const  /*entities*/         /* entities ( optional ) */
);
/*
This function returns the set of `entities' of the given `class' which belong
to `topol' and either do or do not have an attribute of the given `attdef',
depending upon `have_attrib'.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_delete_redundant
(
/* received */
PK_TOPOL_t       /*topol*/      /* Topology to delete */
);
/*
This function removes redundant topology from the given `topol'.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_detach_geom
(
/* received */
PK_TOPOL_t       /*topol*/        /* topology from which geometry is to be detached */
);
/*
This function detaches geometry from topology.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_make_general_body
(
/* received */
int                /*n_topols*/,      /* number of topologies (> 0) */
const PK_TOPOL_t   /*topols*/[],      /* array of topologies */
/* returned */
PK_BODY_t  *const  /*body*/,          /* general body */
PK_TOPOL_t         /*copy_topols*/[]  /* corresponding copy topologies */
);
/*
This function creates a general body from a set of topologies.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_remove_body_component
(
/* received */
PK_TOPOL_t        /*topol*/,      /* a topological entity in required component */
/* returned */
PK_BODY_t *const  /*body*/        /* result body */
);
/*
This function extracts a connected component of a body as a new body.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_delete_redundant_2
(
/* received */
int                                     /*n_topols*/,  /* number of topols */
const PK_TOPOL_t                        /*topols*/[],  /* array of topols */
const PK_TOPOL_delete_redundant_2_o_t * /*options*/,   /* options structure */
/* returned */
PK_TOPOL_track_r_t              *const  /*tracking*/   /* tracking information */
);
/*
This function removes redundant topology or sub-topology from the given list
of topologies.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_identify_redundant
(
/* received */
int                                     /*n_topols*/,           /* number of topols */
const PK_TOPOL_t                        /*topols*/[],           /* array of topols */
const PK_TOPOL_identify_redundant_o_t * /*options*/,            /* options structure */
/* returned */
int                             *const  /*n_redundant_topols*/, /* number of topols */
PK_TOPOL_t                     **const  /*redundant_topols*/    /* identified topols */
);
/*
This function identifies redundant topology or subtopology from the given
list of topologies.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_make_new
(
/* received */
PK_TOPOL_t                      /*topol*/,        /* topol */
const PK_TOPOL_make_new_o_t   * /*options*/,      /* options structure */
/* returned */
PK_TOPOL_t              *const  /*new_topol*/     /* new topol */
);
/*
This function removes groups and attributes attached to `topol' and
replaces `topol' with `new_topol'.The topological entity must be a face.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_clash
(
/* received */
const int                  /*n_targets*/,     /* Number of target topologies */
const PK_TOPOL_t           /*targets*/[],     /* Array of target topols */
const PK_TRANSF_t          /*tf1*/[],         /* Transforms for targets */
const int                  /*n_tools*/,       /* Number of tool topologies */
const PK_TOPOL_t           /*tools*/[],       /* Array of tool topols */
const PK_TRANSF_t          /*tf2*/[],         /* Transforms for tools */
const PK_TOPOL_clash_o_t * /*options*/,       /* Options to be used */
/* returned */
int                *const  /*n_clash*/,       /* Number of clashes found */
PK_TOPOL_clash_t  **const  /*clashes*/        /* Returned array of clashes */
);
/*
This function clashes sets of topologies and returns the (list of)
body, face or edge pairs which clash; the test can be comprehensive, or just
find the first set, and can also return types of clashes.

This function supports body v body, body v face, and face v face clashing.

*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_eval_mass_props
(
/* received */
int                                  /*n_topols*/,     /* number of topols ( >0 ) */
const PK_TOPOL_t                     /*topols*/[],     /* topological entities array */
double                               /*accuracy*/,     /* 0.0 <= accuracy <= 1.0 */
const PK_TOPOL_eval_mass_props_o_t * /*options*/,      /* options structure */
/* returned */
double                               /*amount*/[],     /* amount */
double                               /*mass*/[],       /* mass */
double                               /*c_of_g*/[],     /* centre of gravity */
double                               /*m_of_i*/[],     /* moment of inertia */
double                               /*periphery*/[]   /* periphery */
);
/*
This function evaluates mass properties of a given set of topological
entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range
(
/* received */
PK_TOPOL_t                   /*topol_1*/,         /* first topological entity */
PK_TOPOL_t                   /*topol_2*/,         /* second topological entity */
const PK_TOPOL_range_o_t   * /*options*/,         /* options structure */
/* returned */
PK_range_result_t    *const  /*range_result*/,    /* whether range data returned */
PK_range_2_r_t       *const  /*range*/            /* range data */
);
/*
This function finds the global minimum/maximum distance between two
topological entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_local
(
/* received */
PK_TOPOL_t                       /*topol_1*/,         /* first topological entity */
PK_TOPOL_t                       /*topol_2*/,         /* second topological entity */
const PK_TOPOL_range_local_o_t * /*options*/,         /* options structure */
/* returned */
int                      *const  /*n_ranges*/,        /* no. local minima */
PK_range_2_r_t          **const  /*ranges*/           /* range data */
);
/*
This function finds the local minimum separations between two topological
entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_array
(
/* received */
int                              /*n_topols_1*/,      /* no. entities in 1st array */
const PK_TOPOL_t                 /*topols_1*/[],      /* first topological array */
int                              /*n_topols_2*/,      /* no. entities in 2nd array */
const PK_TOPOL_t                 /*topols_2*/[],      /* second topological array */
const PK_TOPOL_range_array_o_t * /*options*/,         /* options structure */
/* returned */
PK_range_result_t        *const  /*range_result*/,    /* whether range data returned */
PK_range_2_r_t           *const  /*range*/            /* range data */
);
/*
This function finds the global minimum/maximum separation between two arrays
of topological entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_vector
(
/* received */
PK_TOPOL_t                          /*topol*/,           /* topological entity */
PK_VECTOR_t                         /*vector*/,          /* position */
const PK_TOPOL_range_vector_o_t   * /*options*/,         /* options structure */
/* returned */
PK_range_result_t           *const  /*range_result*/,    /* if range data returned */
PK_range_1_r_t              *const  /*range*/            /* range data */
);
/*
This function finds the global minimum separation between a topological
entity and a position.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_local_vector
(
/* received */
PK_TOPOL_t                              /*topol*/,           /* topological entity */
PK_VECTOR_t                             /*vector*/,          /* position vector */
const PK_TOPOL_range_local_vector_o_t * /*options*/,         /* options structure */
/* returned */
int                             *const  /*n_ranges*/,        /* no. local extrema */
PK_range_1_r_t                 **const  /*ranges*/           /* range data */
);
/*
This function finds the local minimum/maximum separations between a topological
entity and a position.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_array_vector
(
/* received */
int                                     /*n_topols*/,        /* no. topologies */
const PK_TOPOL_t                        /*topols*/[],        /* topological array */
PK_VECTOR_t                             /*vector*/,          /* position vector */
const PK_TOPOL_range_array_vector_o_t * /*options*/,         /* options structure */
/* returned */
PK_range_result_t               *const  /*range_result*/,    /* whether range data */
PK_range_1_r_t                  *const  /*range*/            /* range data */
);
/*
This function finds the global minimum separation between an array
of topological entities and a position.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_geom
(
/* received */
PK_TOPOL_t                       /*topol*/,           /* topological entity */
PK_GEOM_t                        /*geom*/,            /* geometrical entity */
const PK_TOPOL_range_geom_o_t  * /*options*/,         /* option structure */
/* returned */
PK_range_result_t        *const  /*range_result*/,    /* whether range data returned */
PK_range_2_r_t           *const  /*range*/            /* range data */
);
/*
This function finds the global minimum/maximum distance between
a topology and a geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_range_geom_array
(
/* received */
int                                   /*n_topols*/,     /* no. entities */
const PK_TOPOL_t                      /*topols*/[],     /* topological array */
int                                   /*n_geoms*/,      /* no. entities */
const PK_GEOM_t                       /*geoms*/[],      /* geometrical array */
const PK_TOPOL_range_geom_array_o_t * /*options*/,      /* options structure */
/* returned */
PK_range_result_t             *const  /*range_result*/, /* whether range data */
PK_range_2_r_t                *const  /*range*/         /* range data */
);
/*
This function finds the global minimum / maximum separation between an array
of topological and an array of geometrical entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_find_box
(
/* received */
PK_TOPOL_t       /*topol*/,        /* entity for which a box is required */
/* returned */
PK_BOX_t *const  /*box*/           /* box containing entity */
);
/*
This function returns a BOX which bounds the given topological entity.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_find_nabox
(
/* received */
int                             /*n_topols*/,   /* number of entities */
const PK_TOPOL_t                /*topols*/[],   /* entities to be boxed */
const PK_TRANSF_t               /*transfs*/[],  /* transformations to be applied */
const PK_TOPOL_find_nabox_o_t * /*options*/,    /* options */
/* returned */
PK_NABOX_sf_t           *const  /*nabox*/       /* returned non-aligned box */
);
/*
This function returns a non-aligned box bounding the given topological
entities.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_track_r_f
(
/* received */
PK_TOPOL_track_r_t      *const  /*tracking*/   /* tracking information to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_local_r_f
(
/* received */
PK_TOPOL_local_r_t *const  /*loc*/
);
/*
Frees the memory associated with the TOPOL_local return structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_render_line
(
/* received */
const int                        /*n_topols*/,         /* number of entities */
const PK_TOPOL_t                 /*topols*/[],         /* entities to rendered */
const PK_TRANSF_t                /*topol_transfs*/[],  /* applied transformations */
const PK_TRANSF_t                /*view_transf*/,      /* viewing transformation */
const PK_TOPOL_render_line_o_t * /*options*/           /* options structure */
);
/*
Render an array of topological entities through GO as
a) a view independent wire frame drawing
b) a view dependent wire frame drawing
or  c) a hidden line drawing,
according to values supplied in an options structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_facet
(
/* received */
const int                         /*n_topols*/,         /* number of entities */
const PK_TOPOL_t                  /*topols*/[],         /* entities to be facetted */
const PK_TRANSF_t                 /*topol_transfs*/[],  /* applied transformations */
const PK_TRANSF_t                 /*view_transf*/,      /* viewing transformation */
const PK_TOPOL_facet_o_t        * /*options*/,          /* options structure */
/* returned */
PK_TOPOL_facet_r_t        *const  /*tables*/            /* addr of tabular structure */
);
/*
Generate a facetted representation of topological entities in tabular form
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_facet_2
(
/* received */
const int                         /*n_topols*/,         /* number of entities */
const PK_TOPOL_t                  /*topols*/[],         /* entities to be facetted */
const PK_TRANSF_t                 /*topol_transfs*/[],  /* applied transformations */
const PK_TOPOL_facet_2_o_t      * /*options*/,          /* options structure */
/* returned */
PK_TOPOL_facet_2_r_t      *const  /*tables*/            /* returned tables */
);
/*
Generate a facetted representation of topological entities in tabular form
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_facet_r_f
(
/* received */
PK_TOPOL_facet_r_t *const  /*tables*/   /* facet tables to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_facet_2_r_f
(
/* received */
PK_TOPOL_facet_2_r_t *const  /*tables*/   /* facet tables to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_TOPOL_render_facet
(
/* received */
const int                         /*n_topols*/,         /* number of entities */
const PK_TOPOL_t                  /*topols*/[],         /* entities to be facetted */
const PK_TRANSF_t                 /*topol_transfs*/[],  /* applied transformations */
const PK_TRANSF_t                 /*view_transf*/,      /* viewing transformation */
const PK_TOPOL_render_facet_o_t * /*options*/           /* options structure */
);
/*
Generate a facetted representation of topological entities through GO.
*/

PK_linkage_m PK_ERROR_code_t PK_boolean_r_f
(
/* received */
PK_boolean_r_t      *const  /*results*/   /* boolean results to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_section_r_f
(
/* received */
PK_BODY_make_section_r_t *const  /*results*/      /* section results to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_sect_with_sfs_r_f
(
/* received */
PK_FACE_make_sect_with_sfs_r_t *const  /*results*/   /* section results to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_section_2_r_f
(
/* received */
PK_section_2_r_t *const  /*results*/      /* section results to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_section_r_f
(
/* received */
PK_section_r_t *const  /*results*/    /* section results to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_imprint_r_f
(
/* received */
PK_imprint_r_t *const  /*results*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_add_geoms
(
/* received */
PK_PART_t         /*part*/,        /* part to have geoms added */
int               /*n_geoms*/,     /* number of geoms */
const PK_GEOM_t   /*geoms*/[]      /* geoms to be added to part */
/* returned */
);
/*
This function adds the given geometry to the part's construction geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_all_attdefs
(
/* received */
PK_PART_t            /*part*/,            /* part */
/* returned */
int          *const  /*n_attdefs*/,       /* number of attdefs (>= 0) */
PK_ATTDEF_t **const  /*attdefs*/          /* attdefs (optional) */
);
/*
This function returns the attribute definitions of all the attributes attached
to entities within the given part. If the part is an assembly, only the
attribute definitions of attributes directly attached to the assembly and its
instances are returned.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_all_attribs
(
/* received */
PK_PART_t            /*part*/,            /* part */
PK_ATTDEF_t          /*attdef*/,          /* attribute definition */
/* returned */
int          *const  /*n_attribs*/,       /* number of attributes (>= 0) */
PK_ATTRIB_t **const  /*attribs*/          /* attributes (optional) */
);
/*
This function returns all the attributes with the given attribute definition
attached to any entity within the given part. If the attribute definition is
PK_ENTITY_null, all attributes are returned, of any type.
If the part is an assembly, only the attributes directly attached to the
assembly and its instances are returned.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_attribs_cb
(
/* received */
PK_PART_t                          /*part*/,        /* part within which to select */
PK_ATTRIB_cb_f_t                   /*callback*/,    /* attribute selection callback */
PK_POINTER_t                       /*context*/,     /* context for callback function */
const PK_PART_ask_attribs_cb_o_t * /*options*/,     /* options */
/* returned */
int                        *const  /*n_attribs*/,   /* number of attributes (>= 0) */
PK_ATTRIB_t               **const  /*attribs*/,     /* attributes */
PK_ENTITY_t               **const  /*owners*/       /* owning entities */
);
/*
This function returns selected attributes and their owners from entities
within the given `part', using the `callback' function to select attributes
from their definition and field values.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_attribs_filter
(
/* received */
PK_PART_t             /*part*/,            /* entity */
PK_ATTDEF_t           /*attdef*/,          /* attribute definition */
int                   /*n_fields*/,        /* number of fields */
const int             /*fields*/[],        /* fields to check */
const int             /*indices*/[],       /* indices in fields */
const int     *const  /*values*/,          /* values to match ( may be NULL ) */
PK_ATTRIB_filter_f_t  /*filter*/,          /* filter function ( may be NULL ) */
PK_POINTER_t          /*context*/,         /* context for filter fn. */
/* returned */
int           *const  /*n_attribs*/,       /* number of attributes (>= 0) */
PK_ATTRIB_t  **const  /*attribs*/          /* attributes (optional) */
);
/*
This function returns all the attributes attached to any entities within the
given part which have the given attribute definition and the contents of whose
integer fields match those specified either by the array of values passed in,
or by the supplied filter function, or both.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_attrib_owners
(
/* received */
PK_PART_t             /*part*/,            /* entity */
PK_ATTDEF_t           /*attdef*/,          /* attribute definition */
int                   /*n_fields*/,        /* number of fields */
const int             /*fields*/[],        /* fields to check */
const int             /*indices*/[],       /* indices in fields */
const int     *const  /*values*/,          /* values to match ( may be NULL ) */
PK_ATTRIB_filter_f_t  /*filter*/,          /* filter function ( may be NULL ) */
PK_POINTER_t          /*context*/,         /* context for filter fn. */
/* returned */
int           *const  /*n_entities*/,      /* number of entities (>= 0) */
PK_ENTITY_t  **const  /*entities*/         /* entities (optional) */
);
/*
This function returns all the entities within the given part that have attached
attributes which are have the given attribute definition and the contents of
whose integer fields match those specified either by the array of values passed
in, or by the supplied filter function, or both.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_construction_surfs
(
/* received */
PK_PART_t          /*part*/,              /* a part */
/* returned */
int        *const  /*n_con_surfs*/,       /* number of construction surfaces (>=0) */
PK_SURF_t **const  /*con_surfs*/          /* construction surfaces (optional) */
);
/*
This function returns the set of construction surfaces connected to the
given part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_construction_curves
(
/* received */
PK_PART_t           /*part*/,             /* a part */
/* returned */
int         *const  /*n_con_curves*/,     /* number of construction curves (>=0) */
PK_CURVE_t **const  /*con_curves*/        /* construction curves (optional) */
);
/*
This function returns the set of construction curves connected to the given
part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_construction_points
(
/* received */
PK_PART_t           /*part*/,             /* a part */
/* returned */
int         *const  /*n_con_points*/,     /* number of construction points (>=0) */
PK_POINT_t **const  /*con_points*/        /* construction points (optional) */
);
/*
This function returns the set of construction points connected to the given
part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_geoms
(
/* received */
PK_PART_t           /*part*/,        /* part to have geoms asked */
/* returned */
int         *const  /*n_geoms*/,     /* number of geoms (>=0) */
PK_GEOM_t  **const  /*geoms*/        /* geoms (optional) */
);
/*
This function returns the set of geometric entities (points, curves and
surfaces) in the given part which are not attached to the part's topology.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_groups
(
/* received */
PK_PART_t           /*part*/,             /* a part */
/* returned */
int         *const  /*n_groups*/,     /* number of groups (>=0) */
PK_GROUP_t **const  /*groups*/        /* groups (optional) */
);
/*
This function returns the set of groups contained within the given part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_ask_ref_instances
(
/* received */
PK_PART_t              /*part*/,             /* a part */
/* returned */
int            *const  /*n_instances*/,      /* number of instances (>=0) */
PK_INSTANCE_t **const  /*instances*/         /* instances ( optional ) */
);
/*
This function returns the set of instances which instance the given part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_delete_attribs
(
/* received */
PK_PART_t                          /*part*/,          /* part within which to delete */
int                                /*n_attdefs*/,     /* number of attribute */
const PK_ATTDEF_t                  /*attdefs*/[],     /* attribute definitions */
const PK_PART_delete_attribs_o_t * /*options*/,       /* options */
/* returned */
int                        *const  /*n_deleted*/      /* number of attributes */
);
/*
This function deletes attributes of given attribute definitions from entities
within the given `part'.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_find_entity_by_ident
(
/* received */
PK_PART_t           /*part*/,         /* part in which to search for entity */
PK_CLASS_t          /*class*/,        /* class of entity */
int                 /*identifier*/,   /* identifier of entity */
/* returned */
PK_ENTITY_t *const  /*entity*/        /* entity (may be PK_ENTITY_null) */
);
/*
This function searches the given `part' for an `entity' of the given `class'
with the given `identifier'.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_rectify_identifiers
(
/* received */
PK_PART_t            /*part*/,        /* part to receive message */
/* returned */
int          *const  /*n_entities*/,  /* number of entities with changed idents */
PK_ENTITY_t **const  /*entities*/,    /* entities with changed idents */
int         **const  /*old_idents*/,  /* old idents of entities */
int         **const  /*new_idents*/   /* new idents of entities */
);
/*
This function ensures that a part has no duplicate or invalid identifiers.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_remove_geoms
(
/* received */
PK_PART_t         /*part*/,        /* part to have geoms removed */
int               /*n_geoms*/,     /* number of geoms to be removed */
const PK_GEOM_t   /*geoms*/[],     /* geoms to be removed from part */
/* returned */
int       *const  /*n_removed*/    /* number of geoms removed */
);
/*
This function removes from the part's construction geometry, any geometric
entities which are also in the given array of geoms.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive
(
/* received */
const char                 * /*key*/,          /* key string */
const PK_PART_receive_o_t  * /*options*/,      /* receive options */
/* returned */
int                  *const  /*n_parts*/,      /* number of parts received */
PK_PART_t           **const  /*parts*/         /* parts received */
);
/*
This function receives one or more parts using the given key string.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive_b
(
/* received */
      PK_MEMORY_block_t      /*block*/,
const PK_PART_receive_o_t  * /*options*/,      /* receive options */
/* returned */
int                  *const  /*n_parts*/,      /* number of parts received */
PK_PART_t           **const  /*parts*/         /* parts received */
);
/*
This function receives one or more parts directly from application memory.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive_u
(
/* received */
const PK_UCHAR_t           * /*key*/,          /* key string */
const PK_PART_receive_o_t  * /*options*/,      /* receive options */
/* returned */
int                  *const  /*n_parts*/,      /* number of parts received */
PK_PART_t           **const  /*parts*/         /* parts received */
);
/*
This function receives one or more parts using the given Unicode key string.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive_version
(
/* received */
const char                        * /*key*/,              /* key string */
PK_transmit_format_t                /*transmit_format*/,  /* file format */
/* returned */
PK_SESSION_kernel_version_t *const  /*version*/           /* version */
);
/*
This function returns information about the version of Parasolid used to create
a part transmit file.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive_version_b
(
/* received */
PK_MEMORY_block_t                   /*block*/,
PK_transmit_format_t                /*transmit_format*/,  /* file format */
/* returned */
PK_SESSION_kernel_version_t *const  /*version*/           /* version */
);
/*
This function returns information about the version of Parasolid used to
transmit a given part.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_receive_version_u
(
/* received */
const PK_UCHAR_t                  * /*key*/,              /* key string */
PK_transmit_format_t                /*transmit_format*/,  /* file format */
/* returned */
PK_SESSION_kernel_version_t *const  /*version*/           /* version */
);
/*
This function returns information about the version of Parasolid used to create
a part transmit file.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_transmit
(
/* received */
int                          /*n_parts*/,      /* number of parts */
const PK_PART_t            * /*parts*/,        /* parts */
const char                 * /*key*/,          /* key string */
const PK_PART_transmit_o_t * /*options*/       /* transmit options */
);
/*
This function transmits the given parts using the given key string.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_transmit_b
(
/* received */
int                          /*n_parts*/,      /* number of parts */
const PK_PART_t            * /*parts*/,        /* parts */
const PK_PART_transmit_o_t * /*options*/,      /* transmit options */
/* returned */
PK_MEMORY_block_t    *const  /*block*/         /* chain of XT data */
);
/*
This function transmits the given parts into application memory.
*/

PK_linkage_m PK_ERROR_code_t PK_PART_transmit_u
(
/* received */
int                          /*n_parts*/,      /* number of parts */
const PK_PART_t            * /*parts*/,        /* parts */
const PK_UCHAR_t           * /*key*/,          /* key string */
const PK_PART_transmit_o_t * /*options*/       /* transmit options */
);
/*
This function transmits the given parts using the given Unicode key string.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_ask_parts
(
/* received */
PK_ASSEMBLY_t      /*assembly*/,   /* assembly */
/* returned */
int        *const  /*n_parts*/,    /* number of parts in assembly (>=0) */
PK_PART_t **const  /*parts*/       /* parts in assembly (optional) */
);
/*
This function returns the parts in an assembly. As each part corresponds to one
instance, there may be duplicates.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_ask_parts_transfs
(
/* received */
PK_ASSEMBLY_t        /*assembly*/,   /* assembly */
/* returned */
int          *const  /*n_parts*/,    /* number of parts in assembly (>=0) */
PK_PART_t   **const  /*parts*/,      /* parts in assembly (optional) */
PK_TRANSF_t **const  /*transfs*/     /* transforms in assembly (optional) */
);
/*
This function returns the parts in an assembly, together with their associated
transforms. As each part corresponds to one instance, there may be duplicates
in the parts array.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_ask_instances
(
/* received */
PK_ASSEMBLY_t          /*assembly*/,       /* assembly */
/* returned */
int            *const  /*n_instances*/,    /* number of instances in assembly (>=0) */
PK_INSTANCE_t **const  /*instances*/       /* instances in assembly (optional) */
);
/*
This function returns the instances in an assembly.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_create_empty
(
/* returned */
PK_ASSEMBLY_t *const  /*assembly*/        /* created assembly */
);
/*
This function creates an empty assembly.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_make_level_assembly
(
/* received */
PK_ASSEMBLY_t         /*assembly*/,         /* assembly */
/* returned */
PK_ASSEMBLY_t *const  /*level_assembly*/    /* level assembly */
);
/*
This function creates a new assembly which contains, for each path from
the given assembly to a body contained in it, an instance of that body with a
transform equal to the product of the transforms attached to instances along
the path.
*/

PK_linkage_m PK_ERROR_code_t PK_ASSEMBLY_transform
(
/* received */
PK_ASSEMBLY_t       /*assembly*/,     /* assembly */
PK_TRANSF_t         /*transf*/        /* transform (may be PK_ENTITY_null) */
);
/*
This function transforms an assembly by transforming its top-level instances.
The given transform must be a rigid motion. The null transform is treated as
the identity.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_add_to_compound
(
/* received */
int                                 /*n_bodies*/,  /* number of bodies */
const PK_BODY_t                     /*bodies*/[],  /* bodies */
PK_BODY_t                           /*compound*/,  /* compound body */
const PK_BODY_add_to_compound_o_t * /*options*/    /* options */
);
/*
This function adds `bodies' to an existing `compound' body, so they become
child bodies with the compound body as their parent.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_change_partition
(
/* received */
PK_BODY_t         /*body*/,          /* body to move */
PK_PARTITION_t    /*partition*/      /* partition to move into */
);
/*
This function moves the given body and the entities within it into the given
partition, without changing their tags.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_contains_vector
(
/* received */
PK_BODY_t              /*body*/,       /* the body */
PK_VECTOR_t            /*vector*/,     /* the position vector */
/* returned */
PK_enclosure_t *const  /*enclosure*/,  /* enclosure code */
PK_TOPOL_t     *const  /*topology*/    /* topology which coincides with given vector */
);
/*
This function determines whether the point represented by the given
position vector lies inside, outside, or on the boundary of the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_copy_topology
(
/* received */
PK_BODY_t                               /*body*/,          /* body to copy */
const PK_BODY_copy_topology_o_t       * /*options*/,       /* options structure */
/* returned */
PK_BODY_t                       *const  /*body_copy*/,     /* copy of given body */
PK_TOPOL_track_r_t              *const  /*tracking*/       /* tracking information */
);
/*
This function produces a new body which is a copy of the given body, with no
geometry being copied.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_disjoin
(
/* received */
PK_BODY_t          /*target*/,            /* a body */
/* returned */
int        *const  /*n_bodies*/,          /* number of disjoint bodies (>= 1) */
PK_BODY_t **const  /*bodies*/             /* disjoint bodies */
);
/*
This function divides the target body into one or more disjoint bodies, each
of which represents a connected point-set.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_find_laminar_edges
(
/* received */
PK_BODY_t                /*body*/,            /* a body */
/* returned */
int              *const  /*n_components*/,    /* number of components (>= 0) */
PK_EDGE_array_t **const  /*components*/       /* components (optional) */
);
/*
This function returns the laminar edges in the given body. Laminar edges are
those with exactly one fin, i.e. one attached face on one 'side'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_manifold_bodies
(
/* received */
PK_BODY_t          /*body*/,          /* body to decompose */
/* returned */
int        *const  /*n_components*/,  /* number of manifold bodies */
PK_BODY_t **const  /*components*/     /* array of manifold bodies */
);
/*
This function breaks a body into manifold pieces.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_reverse_orientation
(
/* received */
PK_BODY_t         /*body*/               /* body to negate */
);
/*
This function reverses the orientation of a body
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_set_curve_nmnl_state
(
/* received */
PK_BODY_t                /*body*/,
PK_BODY_curve_nmnl_t     /*setting*/
);
/*
This function sets whether nominal curves are enabled for the `body'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_simplify_geom
(
/* received */
PK_BODY_t          /*body*/,          /* body */
PK_LOGICAL_t       /*local*/,         /* whether partial replacement allowed */
/* returned */
int        *const  /*n_geoms*/,       /* number of geoms returned */
PK_GEOM_t **const  /*geoms*/          /* new geoms (optional) */
);
/*
This function simplifies the geometry of a body where possible.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_repair_shells
(
/* received */
PK_BODY_t                         /*body*/,      /* body to repair */
const PK_BODY_repair_shells_o_t * /*options*/,   /* options structure */
/* returned */
PK_SHELL_repair_stat_t    *const  /*status*/,    /* status returned */
PK_TOPOL_track_r_t        *const  /*tracking*/   /* tracking information */
);
/*
This function attempts to repair the shell and region structure of the given
`body'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_remove_from_parents
(
/* received */
int                                     /*n_children*/,  /* number of children */
const PK_BODY_t                         /*children*/[],  /* children */
const PK_BODY_remove_from_parents_o_t * /*options*/      /* options */
);
/*
This function removes the given child bodies from their parents.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_compound
(
/* received */
int                               /*n_bodies*/,  /* number of bodies */
const PK_BODY_t                   /*bodies*/[],  /* bodies */
const PK_BODY_make_compound_o_t * /*options*/,   /* options */
/* returned */
PK_BODY_t                 *const  /*compound*/   /* compound body */
);
/*
This function creates a compound body containing `bodies'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_components
(
/* received */
PK_BODY_t            /*body*/,               /* a body */
/* returned */
int          *const  /*n_components*/,       /* number of components (>= 1) */
PK_SHELL_t  **const  /*components*/          /* components (optional) */
);
/*
This function returns the components of the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_regions
(
/* received */
PK_BODY_t            /*body*/,            /* a body */
/* returned */
int          *const  /*n_regions*/,       /* number of regions (>= 1) */
PK_REGION_t **const  /*regions*/          /* regions (optional) */
);
/*
This function returns the regions of the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_shells
(
/* received */
PK_BODY_t           /*body*/,             /* a body */
/* returned */
int         *const  /*n_shells*/,         /* number of shells (>= 0) */
PK_SHELL_t **const  /*shells*/            /* shells (optional) */
);
/*
This function returns the set of shells in the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_faces
(
/* received */
PK_BODY_t          /*body*/,              /* a body */
/* returned */
int        *const  /*n_faces*/,           /* number of faces (>= 0) */
PK_FACE_t **const  /*faces*/              /* faces (optional) */
);
/*
This function returns the set of faces in the given `body'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_loops
(
/* received */
PK_BODY_t          /*body*/,              /* a body */
/* returned */
int        *const  /*n_loops*/,           /* number of loops (>= 0) */
PK_LOOP_t **const  /*loops*/              /* loops (optional) */
);
/*
This function return the set of loops in the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_fins
(
/* received */
PK_BODY_t         /*body*/,               /* a body */
/* returned */
int       *const  /*n_fins*/,             /* number of fins (>= 0) */
PK_FIN_t **const  /*fins*/                /* fins (optional) */
);
/*
This function returns the set of fins in the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_edges
(
/* received */
PK_BODY_t          /*body*/,              /* a body */
/* returned */
int        *const  /*n_edges*/,           /* number of edges (>= 0) */
PK_EDGE_t **const  /*edges*/              /* edges (optional) */
);
/*
This function returns the set of edges in the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_vertices
(
/* received */
PK_BODY_t            /*body*/,            /* a body */
/* returned */
int          *const  /*n_vertices*/,      /* number of vertices (>= 0) */
PK_VERTEX_t **const  /*vertices*/         /* vertices (optional) */
);
/*
This function returns the set of vertices in the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_first_face
(
/* received */
PK_BODY_t         /*body*/,            /* a body */
/* returned */
PK_FACE_t *const  /*first_face*/       /* a face (possibly PK_ENTITY_null) */
);
/*
This function returns a face in the given body, if one exists, otherwise
PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_first_edge
(
/* received */
PK_BODY_t         /*body*/,          /* a body */
/* returned */
PK_EDGE_t *const  /*first_edge*/      /* an edge (possibly PK_ENTITY_null) */
);
/*
This function returns an edge in the given body, if one exists, otherwise
PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_memory_usage
(
/* received */
PK_BODY_t        /*body*/,
/* returned */
size_t   *const  /*total*/
);
/*
This function returns the amount of memory currently occupied by the
body's data structures. Note: this may vary during the course of a
session.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_curve_nmnl_state
(
/* received */
PK_BODY_t                    /*body*/,
/* returned */
PK_BODY_curve_nmnl_t *const  /*setting*/
);
/*
This function returns whether nominal curves are enabled for the `body'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_parent
(
/* received */
PK_BODY_t                      /*body*/,     /* body */
const PK_BODY_ask_parent_o_t * /*options*/,  /* options */
/* returned */
PK_BODY_t              *const  /*parent*/    /* parent (possibly PK_ENTITY_null) */
);
/*
This function returns the compound body containing `body', if any. Otherwise
it returns PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_children
(
/* received */
PK_BODY_t                        /*body*/,        /* body */
const PK_BODY_ask_children_o_t * /*options*/,     /* options */
/* returned */
int                      *const  /*n_children*/,  /* number of children (>= 0) */
PK_BODY_t               **const  /*children*/     /* children */
);
/*
If `body' is a compound body, this function returns its child bodies. If it is
not a compound body, no children are returned.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_type
(
/* received */
PK_BODY_t              /*body*/,        /* the body */
/* returned */
PK_BODY_type_t *const  /*body_type*/    /* the type of the body */
);
/*
This function classifies the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_config
(
/* received */
PK_BODY_t                /*body*/,         /* the body */
/* returned */
PK_BODY_config_t *const  /*body_config*/   /* the configuration of the body */
);
/*
The function returns the body configuration, which is described in the
documentation of PK_BODY_config_t.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_fix_blends
(
/* received */
PK_BODY_t                      /*body*/,          /* edge to have blends fixed */
const PK_BODY_fix_blends_o_t * /*options*/,       /* options structure */
/* returned */
int                    *const  /*n_blends*/,      /* number of blend faces */
PK_FACE_t             **const  /*blends*/,        /* created blend faces */
PK_FACE_array_t       **const  /*unders*/,        /* underlying topology/geometry */
int                   **const  /*topols*/,        /* topols that have been replaced */
PK_blend_fault_t       *const  /*fault*/,         /* status */
PK_EDGE_t              *const  /*fault_edge*/,    /* first edge for which blend */
PK_ENTITY_t            *const  /*fault_topol*/    /* topology associated with */
);
/*
This function changes any edges of the given body which have had blends set on
them by the PK_EDGE_set_blend_ functions, into faces with the appropriate
surface geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_boolean
(
/* received */
PK_BODY_t                   /*target*/,     /* body to receive message */
int                         /*n_tools*/,    /* number of tool bodies */
const PK_BODY_t             /*tools*/[],    /* tool bodies */
const PK_BODY_boolean_o_t * /*options*/,    /* boolean options */
/* returned */
int                 *const  /*n_bodies*/,   /* number of resultant bodies */
PK_BODY_t          **const  /*bodies*/      /* resultant bodies */
);
/*
This function performs a boolean operation between the target body
and the list of tool bodies.

NOTE: This function is obsolete and has been superseded by PK_BODY_boolean_2.

*/

PK_linkage_m PK_ERROR_code_t PK_BODY_boolean_2
(
/* received */
PK_BODY_t                       /*target*/,     /* target body */
int                             /*n_tools*/,    /* number of tool bodies */
const PK_BODY_t                 /*tools*/[],    /* tool bodies */
const PK_BODY_boolean_o_t     * /*options*/,    /* boolean options */
/* returned */
PK_TOPOL_track_r_t      *const  /*tracking*/,   /* tracking information */
PK_boolean_r_t          *const  /*results*/     /* boolean results */
);
/*
This function performs a boolean operation between the target body
and the list of tool bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_unite_bodies
(
/* received */
PK_BODY_t                   /*target*/,     /* Body to receive message */
int                         /*n_tools*/,    /* Number of tool bodies */
const PK_BODY_t             /*tools*/[],    /* Tool bodies */
/* returned */
int                 *const  /*n_bodies*/,   /* Number of resultant bodies */
PK_BODY_t          **const  /*bodies*/      /* Resultant bodies */
);
/*
This function performs a boolean unite operation between the target
body and the list of tool bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_subtract_bodies
(
/* received */
PK_BODY_t                   /*target*/,     /* Body to receive message */
int                         /*n_tools*/,    /* Number of tool bodies */
const PK_BODY_t             /*tools*/[],    /* Tool bodies */
/* returned */
int                 *const  /*n_bodies*/,   /* Number of resultant bodies */
PK_BODY_t          **const  /*bodies*/      /* Resultant bodies */
);
/*
This function performs a boolean subtract operation between the target
body and the list of tool bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_intersect_bodies
(
/* received */
PK_BODY_t                   /*target*/,     /* Body to receive message */
int                         /*n_tools*/,    /* Number of tool bodies */
const PK_BODY_t             /*tools*/[],    /* Tool bodies */
/* returned */
int                 *const  /*n_bodies*/,   /* Number of resultant bodies */
PK_BODY_t          **const  /*bodies*/      /* Resultant bodies */
);
/*
This function performs a boolean intersect operation between the target
body and the list of tool bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_check
(
/* received */
PK_BODY_t                     /*body*/,          /* body to be checked */
const PK_BODY_check_o_t     * /*options*/,       /* options structure */
/* returned */
int                   *const  /*n_faults*/,      /* number of faults */
PK_check_fault_t     **const  /*faults*/         /* faults */
);
/*
This function checks the given body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_minimum_topology
(
/* received */
int                      /*n_topols*/,     /* number of topols */
const PK_CLASS_t         /*classes*/[],    /* class of each topol */
int                      /*n_relations*/,  /* number of relations */
const int                /*parents*/[],    /* parents */
const int                /*children*/[],   /* children */
const PK_TOPOL_sense_t   /*senses*/[],     /* sense in which child used by parent */
/* returned */
PK_BODY_t        *const  /*body*/,         /* created body */
PK_TOPOL_t       *const  /*topols*/,       /* created topols */
PK_BODY_fault_t  *const  /*fault*/,        /* fault indicator */
int              *const  /*fault_index*/   /* index of fault topol */
);
/*
This function creates the topology of a minimum body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_sheet_circle
(
/* received */
double                /*radius*/,        /* radius of circle (>0) */
const PK_AXIS2_sf_t * /*basis_set*/,     /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/           /* sheet body returned */
);
/*
This function creates a circular sheet.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_sheet_planar
(
/* received */
int                                     /*n_vectors*/,   /* number of position */
const PK_VECTOR_t                       /*vectors*/[],   /* position vectors */
const PK_BODY_create_sheet_planar_o_t * /*options*/,     /* option structure */
/* returned */
PK_BODY_t                             *const  /*body*/   /* sheet body returned */
);
/*
This function creates a planar sheet whose boundary is an irregular polygon.
The option also exists to create irregular polygonal holes within this sheet.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_sheet_polygon
(
/* received */
double                /*radius*/,        /* radius of polygon (>0) */
int                   /*n_sides*/,       /* number of sides of polygon (>2) */
const PK_AXIS2_sf_t * /*basis_set*/,     /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/           /* sheet body returned */
);
/*
This function creates a polygonal sheet.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_sheet_rectangle
(
/* received */
double                /*x*/,             /* x dimension of rectangle (>0) */
double                /*y*/,             /* y dimension of rectangle (>0) */
const PK_AXIS2_sf_t * /*basis_set*/,     /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/           /* sheet body returned */
);
/*
This function creates a sheet rectangle.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_sheet_topology
(
/* received */
int                      /*n_topols*/,     /* number of topols */
const PK_CLASS_t         /*classes*/[],    /* class of each topol */
int                      /*n_relations*/,  /* number of relations */
const int                /*parents*/[],    /* parents */
const int                /*children*/[],   /* children */
const PK_TOPOL_sense_t   /*senses*/[],     /* sense in which child used by parent */
/* returned */
PK_BODY_t        *const  /*body*/,         /* created body */
PK_TOPOL_t       *const  /*topols*/,       /* created topols */
PK_BODY_fault_t  *const  /*fault*/,        /* fault indicator */
int              *const  /*fault_index*/   /* index of fault topol */
);
/*
This function creates the topology of a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_block
(
/* received */
double                /*x*/,          /* block extent in local x direction (>0) */
double                /*y*/,          /* block extent in local y direction (>0) */
double                /*z*/,          /* block extent in local z direction (>0) */
const PK_AXIS2_sf_t * /*basis_set*/,  /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/        /* solid body returned */
);
/*
This function creates a solid block.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_cone
(
/* received */
double                /*radius*/,     /* cone radius (may be 0) */
double                /*height*/,     /* cone height (>0) */
double                /*semi_angle*/, /* semi-vertex angle (>0, <Pi/2) */
const PK_AXIS2_sf_t * /*basis_set*/,  /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/        /* solid body returned */
);
/*
This function creates a solid cone.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_cyl
(
/* received */
double                /*radius*/,     /* cylinder radius (>0) */
double                /*height*/,     /* cylinder height (>0) */
const PK_AXIS2_sf_t * /*basis_set*/,  /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/        /* solid body returned */
);
/*
This function creates a solid cylinder.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_prism
(
/* received */
double                /*radius*/,     /* prism radius (>0) */
double                /*height*/,     /* prism height (>0) */
int                   /*n_sides*/,    /* number of sides (>2) */
const PK_AXIS2_sf_t * /*basis_set*/,  /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/        /* solid body returned */
);
/*
This function creates a solid prism.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_sphere
(
/* received */
double                /*radius*/,     /* sphere radius (>0) */
const PK_AXIS2_sf_t * /*basis_set*/,  /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/        /* solid body returned */
);
/*
This function creates a solid sphere.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_topology
(
/* received */
int                      /*n_topols*/,     /* number of topols */
const PK_CLASS_t         /*classes*/[],    /* class of each topol */
int                      /*n_relations*/,  /* number of relations */
const int                /*parents*/[],    /* parents */
const int                /*children*/[],   /* children */
const PK_TOPOL_sense_t   /*senses*/[],     /* sense in which child used by parent */
/* returned */
PK_BODY_t        *const  /*body*/,         /* created body */
PK_TOPOL_t       *const  /*topols*/,       /* created topols */
PK_BODY_fault_t  *const  /*fault*/,        /* fault indicator */
int              *const  /*fault_index*/   /* index of fault topol */
);
/*
This function creates the topology of a solid body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_solid_torus
(
/* received */
double                /*major_radius*/,  /* torus major radius */
double                /*minor_radius*/,  /* torus minor radius (> 0) */
const PK_AXIS2_sf_t * /*basis_set*/,     /* position and orientation (may be NULL) */
/* returned */
PK_BODY_t     *const  /*body*/           /* solid body returned */
);
/*
This function creates a solid torus.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_wire_topology
(
/* received */
int                      /*n_topols*/,     /* number of topols */
const PK_CLASS_t         /*classes*/[],    /* class of each topol */
int                      /*n_relations*/,  /* number of relations */
const int                /*parents*/[],    /* parents */
const int                /*children*/[],   /* children */
const PK_TOPOL_sense_t   /*senses*/[],     /* sense in which child used by parent */
/* returned */
PK_BODY_t        *const  /*body*/,         /* created body */
PK_TOPOL_t       *const  /*topols*/,       /* created topols */
PK_BODY_fault_t  *const  /*fault*/,        /* fault indicator */
int              *const  /*fault_index*/   /* index of fault topol */
);
/*
This function creates the topology of a wire body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_embed_in_surf
(
/* received */
PK_BODY_t          /*body*/,       /* sheet body to receive message */
PK_SURF_t          /*surf*/,       /* new surface for sheet body */
double             /*tolerance*/,  /* tolerance for SPCURVE generation */
/* returned */
int        *const  /*n_edges*/,    /* number of edges converted to SPCURVEs */
PK_EDGE_t **const  /*edges*/       /* edges converted to SPCURVEs (optional) */
);
/*
This function constructs the representation of a sheet body in the parameter
space of its existing surface and embeds that in the parameter space of a
new surface.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_emboss
(
/* received */
PK_BODY_t                  /*target*/,            /* sheet or solid where emboss */
PK_BODY_t                  /*profile*/,           /* sheet or closed wire defining */
PK_BODY_t                  /*endcap*/,            /* sheet or solid providing */
const PK_BODY_emboss_o_t * /*options*/,           /* options */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,          /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/            /* status information */
);
/*
This function creates emboss features on the target body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_extend
(
/* received */
PK_BODY_t                         /*body*/,              /* body */
int                               /*n_boundary_edges*/,  /* number of boundary edges */
const PK_EDGE_t                 * /*boundary_edges*/,    /* boundary edges */
const PK_BODY_extend_o_t        * /*options*/,           /* options structure */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/,          /* tracking information */
PK_TOPOL_local_r_t        *const  /*results*/            /* status information */
);
/*
This function will extend a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_extrude
(
/* received */
PK_BODY_t                   /*profile*/,      /* minimum, wire or sheet profile */
PK_VECTOR1_t                /*path*/,         /* direction of linear extrusion */
const PK_BODY_extrude_o_t * /*options*/,      /* options structure */
/* returned */
PK_BODY_t           *const  /*body*/,         /* resulting extruded body */
PK_TOPOL_track_r_t  *const  /*tracking*/,     /* tracking information */
PK_TOPOL_local_r_t  *const  /*results*/       /* status information */
);
/*
This function creates a new body by performing a linear extrusion of a given
profile.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_fill_hole
(
/* received */
PK_BODY_t                         /*target*/,          /* target body */
int                               /*n_edges*/,         /* number of edges */
const PK_EDGE_t                   /*edges*/[],         /* boundary edges of hole */
double                            /*tolerance*/,       /* tolerance */
const PK_BODY_fill_hole_o_t     * /*options*/,         /* options structure */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/,        /* tracking information */
PK_fill_hole_fault_t      *const  /*fault*/,           /* status */
int                       *const  /*n_fault_topols*/,  /* number of fault topologies */
PK_TOPOL_t               **const  /*fault_topols*/     /* topologies associated */
);
/*
This function will fill a hole in a body or collection of bodies with a
set of faces.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_hollow
(
/* received */
PK_BODY_t            /*body*/,               /* body to be hollowed */
double               /*offset*/,             /* offset distance */
double               /*tolerance*/,          /* tolerance */
PK_LOGICAL_t         /*face_face_check*/,    /* do face face checks */
/* returned */
int          *const  /*n_faces*/,            /* number of faces */
PK_FACE_t   **const  /*old_faces*/,          /* faces in original body (optional) */
PK_FACE_t   **const  /*new_faces*/           /* new faces corresponding to */
);
/*
This function hollows a solid body by offsetting all faces of the body
by the given offset distance

Note: This function is superseded by PK_BODY_hollow_2
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_hollow_2
(
/* received */
PK_BODY_t                   /*body*/,               /* body to be hollowed */
double                      /*offset*/,             /* offset distance */
double                      /*tolerance*/,          /* tolerance */
const PK_BODY_hollow_o_t  * /*options*/,            /* user options */
/* returned */
PK_TOPOL_track_r_t  *const  /*tracking*/,           /* tracking information */
PK_TOPOL_local_r_t  *const  /*results*/             /* status information */
);
/*
This function hollows a solid body by offsetting all faces of the body
by the given offset distance

NOTE : This function supersedes PK_BODY_hollow.

*/

PK_linkage_m PK_ERROR_code_t PK_identify_facesets_r_f
(
/* received */
PK_identify_facesets_r_t *const  /*facesets*/
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_identify_facesets
(
/* received */
PK_BODY_t                             /*target*/,             /* target body */
PK_BODY_t                             /*tool*/,               /* tool body */
int                                   /*n_edges*/,            /* number of common */
const PK_EDGE_t                       /*target_edges*/[],     /* target edges */
const PK_EDGE_t                       /*tool_edges*/[],       /* tool edges */
int                                   /*n_vertices*/,         /* number of common */
const PK_VERTEX_t                     /*target_vertices*/[],  /* target vertices */
const PK_VERTEX_t                     /*tool_vertices*/[],    /* tool vertices */
const PK_BODY_identify_facesets_o_t * /*options*/,            /* identify options */
/* returned */
PK_identify_facesets_r_t      *const  /*results*/             /* identify results */
);
/*

This function identifies surviving facesets, given matching edges on
the target and tool bodies.

*/

PK_linkage_m PK_ERROR_code_t PK_identify_details_r_f
(
/* received */
PK_identify_details_r_t *const  /*facesets*/
);
/*
This function frees the memory used by a PK_identify_details_r_t structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_identify_details
(
/* received */
PK_BODY_t                            /*body*/,       /* body to search */
int                                  /*n_details*/,  /* number of detail types */
const PK_detail_t                    /*details*/[],  /* detail types */
const PK_BODY_identify_details_o_t * /*options*/,    /* identify options */
/* returned */
PK_identify_details_r_t      *const  /*results*/     /* identify results */
);
/*
This function identifies details in the given `body' of the types specified
in `details'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_identify_general
(
/* received */
PK_BODY_t                            /*body*/,      /* body to search */
const PK_BODY_identify_general_o_t * /*options*/,   /* options */
/* returned */
PK_identify_general_r_t      *const  /*results*/     /* identify results */
);
/*
This function identifies characteristics of a general body which require it to
be of type PK_BODY_type_general_c.
*/

PK_linkage_m PK_ERROR_code_t PK_identify_general_r_f
(
/* received */
PK_identify_general_r_t *const  /*topol*/
);
/*
This function frees the memory used by a PK_identify_general_r_t structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_find_facesets_r_f
(
/* received */
PK_BODY_find_facesets_r_t    *const  /*facesets*/     /* facesets to be deleted */
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_find_facesets
(
/* received */
PK_BODY_t                            /*body*/,        /* body */
int                                  /*n_edges*/,     /* no of bounding edges */
const PK_EDGE_t                      /*edges*/[],     /* bounding edges from body */
const PK_BODY_find_facesets_o_t    * /*options*/,     /* find options */
/* returned */
PK_BODY_find_facesets_r_t    *const  /*results*/      /* find results */
);
/*

This function finds all the facesets on the body and splits those that are
divided by the input edges into smaller facesets. It then returns the facesets
that are selected by the options and, if requested, the input edges that
bound each faceset.

*/

PK_linkage_m PK_ERROR_code_t PK_BODY_find_extreme
(
/* received */
PK_BODY_t                          /*body*/,         /* body on which extreme sought */
PK_VECTOR_t                        /*direction_1*/,  /* first direction */
PK_VECTOR_t                        /*direction_2*/,  /* second direction */
PK_VECTOR_t                        /*direction_3*/,  /* third direction */
const PK_BODY_find_extreme_o_t   * /*options*/,      /* find extreme options */
/* returned */
PK_VECTOR_t                *const  /*extreme*/,      /* position of extreme point */
PK_TOPOL_t                 *const  /*topol*/         /* topology on which extreme */
);
/*
This function finds the extreme point on the given `body' in `direction_1'.
If this extreme is not a single point, then  `direction_2' and `direction_3'
are used successively to reduce the number of extreme points to one.

Currently `options' is an empty option structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_plane
(
/* received */
PK_BODY_t          /*body*/,          /* a body */
PK_PLANE_t         /*plane*/,         /* plane */
double             /*tol*/,           /* tolerance */
/* returned */
int        *const  /*n_edges*/,       /* number of edges imprinted */
PK_EDGE_t **const  /*edges*/          /* imprinted edges */
);
/*
This function imprints the given plane on the body.

NOTE: This function is deprecated and has been superseded by
PK_BODY_imprint_plane_2.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_plane_2
(
/* received */
PK_BODY_t                         /*body*/,         /* target body */
PK_PLANE_t                        /*plane*/,        /* tool plane */
const PK_BODY_imprint_plane_o_t * /*options*/,      /* options */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/      /* tracking information */
);
/*
This function imprints the given plane on the body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_faces_2
(
/* received */
PK_BODY_t                         /*body*/,         /* a target body */
int                               /*n_faces*/,      /* number of tool faces */
const PK_FACE_t                   /*faces*/[],      /* tool faces */
const PK_BODY_imprint_faces_o_t * /*options*/,      /* imprint options */
/* returned */
PK_imprint_r_t            *const  /*results*/,      /* imprint results */
PK_TOPOL_track_r_t        *const  /*tracking*/      /* tracking information */
);
/*
This function imprints edges on the given target body and tool faces.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_faces
(
/* received */
PK_BODY_t          /*body*/,          /* a body */
int                /*n_faces*/,       /* number of faces */
const PK_FACE_t    /*faces*/[],       /* faces */
double             /*tol*/,           /* tolerance */
/* returned */
int        *const  /*n_edges*/,       /* number of edges imprinted */
PK_EDGE_t **const  /*edges*/          /* imprinted edges */
);
/*
This function imprints the given faces on the body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_curve
(
/* received */
PK_BODY_t            /*body*/,                   /* body */
PK_CURVE_t           /*curve*/,                  /* curve */
PK_INTERVAL_t        /*bounds*/,                 /* bounds of curve */
/* returned */
int                *const  /*n_new_edges*/,      /* number of new edges */
PK_EDGE_t         **const  /*new_edges*/,        /* new edges (optional) */
int                *const  /*n_new_faces*/,      /* number of new faces */
PK_FACE_t         **const  /*new_faces*/         /* new faces (optional) */
);
/*
This function imprints a curve onto a body, thereby creating a new edge or
edges.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_curves_normal
(
/* received */
PK_BODY_t          /*body*/,          /* a body */
int                /*n_curves*/,      /* number of curves */
const PK_CURVE_t   /*curves*/[],      /* curves */
double             /*tol*/,           /* tolerance */
/* returned */
int        *const  /*n_edges*/,       /* number of edges imprinted */
PK_EDGE_t **const  /*edges*/          /* imprinted edges */
);
/*
This function imprints the given curves on the body by projecting them locally
down face normals.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_curves_vector
(
/* received */
PK_BODY_t          /*body*/,          /* a body */
int                /*n_curves*/,      /* number of curves */
const PK_CURVE_t   /*curves*/[],      /* curves */
double             /*tol*/,           /* tolerance */
PK_VECTOR_t        /*direction*/,     /* direction to project curves in */
/* returned */
int        *const  /*n_edges*/,       /* number of edges imprinted */
PK_EDGE_t **const  /*edges*/          /* imprinted edges */
);
/*
This function imprints the given curves on the body by projecting them in the
given direction.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_cus_normal
(
/* received */
PK_BODY_t                              /*body*/,          /* a body */
int                                    /*n_curves*/,      /* number of curves */
const PK_CURVE_t                       /*curves*/[],      /* curves */
const PK_INTERVAL_t                    /*intervals*/[],   /* parametric intervals */
double                                 /*tol*/,           /* tolerance */
const PK_BODY_imprint_cus_normal_o_t * /*options*/,       /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/       /* tracking information */
);
/*
This function imprints the given curves on the body by projecting them locally
down face normals.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_cus_vector
(
/* received */
PK_BODY_t                              /*body*/,          /* a body */
int                                    /*n_curves*/,      /* number of curves */
const PK_CURVE_t                       /*curves*/[],      /* curves */
const PK_INTERVAL_t                    /*intervals*/[],   /* parametric intervals */
double                                 /*tol*/,           /* tolerance */
const PK_VECTOR_t                      /*direction*/,     /* direction to project */
const PK_BODY_imprint_cus_vector_o_t * /*options*/,       /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/       /* tracking information */
);
/*
This function imprints the given curves on the body by projecting them in the
given direction.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_cus_vec
(
/* received */
PK_BODY_t                            /*body*/,         /* a body */
int                                  /*n_curves*/,     /* number of curves */
const PK_CURVE_t                     /*curves*/[],     /* curves */
const PK_INTERVAL_t                  /*intervals*/[],  /* parametric intervals */
double                               /*tol*/,          /* tolerance */
const PK_VECTOR_t                    /*direction*/,    /* direction to project */
const PK_BODY_imprint_cus_vec_o_t  * /*options*/,      /* options */
/* returned */
PK_TOPOL_track_r_t           *const  /*tracking*/      /* tracking information */
);
/*
This function imprints the given curves on the body by projecting them in the
given direction.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_body
(
/* received */
PK_BODY_t                     /*target*/,       /* target body */
PK_BODY_t                     /*tool*/,         /* tool body */
const PK_BODY_imprint_o_t   * /*options*/,      /* imprint options */
/* returned */
PK_imprint_r_t        *const  /*results*/       /* imprint results */
);
/*
This function imprints edges on the given target and tool bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_imprint_cus_shadow
(
/* received */
const int                               /*n_bodies*/,         /* number of bodies */
const PK_BODY_t                         /*bodies*/[],         /* bodies */
const PK_TRANSF_t                       /*transfs*/[],        /* body transformation */
const PK_VECTOR1_t                      /*view_direction*/,   /* viewing direction */
const PK_BODY_imprint_cus_shadow_o_t  * /*options*/,          /* option structure */
/* returned */
int                             *const  /*n_edges*/,          /* number of edges */
PK_EDGE_t                      **const  /*edges*/,            /* new edges */
int                             *const  /*n_visible_faces*/,  /* number of visible */
PK_FACE_t                      **const  /*visible_faces*/     /* visible faces */
);
/*
This function takes the given bodies and splits their faces into portions
which are completely visible in the given view direction by imprinting the
`shadow' curves cast by overlapping faces in front.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_tracked_loft_r_f
(
/* received */
PK_BODY_tracked_loft_r_t *const  /*lofted_body*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_lofted_body
(
/* received */
int                                  /*n_profiles*/,       /* number of profiles */
const PK_BODY_t                      /*profiles*/[],       /* profiles to loft */
const PK_VERTEX_t                    /*start_vertices*/[], /* start vertices */
const PK_BODY_make_lofted_body_o_t * /*options*/,          /* options on lofting */
/* returned */
PK_BODY_tracked_loft_r_t     *const  /*lofted_body*/       /* result lofted body */
);
/*
This function creates a sheet or solid body based on surfaces created by
lofting through a set of sheet, wire or minimum body profiles.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_curves_outline
(
/* received */
const int                               /*n_bodies*/,         /* number of bodies */
const PK_BODY_t                         /*bodies*/[],         /* bodies */
const PK_TRANSF_t                       /*transfs*/[],        /* body transformation */
const PK_VECTOR1_t                      /*view_direction*/,   /* viewing direction */
const PK_BODY_make_curves_outline_o_t * /*options*/,          /* option structure */
/* returned */
int                             *const  /*n_curves*/,         /* number of curves */
PK_CURVE_t                     **const  /*curves*/,           /* boundary curves */
PK_INTERVAL_t                  **const  /*intervals*/,        /* parametric */
PK_TOPOL_t                     **const  /*topols*/,           /* edges/faces of */
int                            **const  /*outlines*/,         /* indicates which */
double                         **const  /*curve_tolerances*/, /* curve tolerance */
double                          *const  /*max_separation*/    /* largest gap */
);
/*
This function outputs one or more outlines of a body or bodies for a given
view direction as a set of ordered curves together with their intervals.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_spun_outline
(
/* received */
const int                               /*n_bodies*/,         /* number of bodies */
const PK_BODY_t                         /*bodies*/[],         /* bodies */
const PK_TRANSF_t                       /*transfs*/[],        /* body transformation */
const PK_AXIS1_sf_t                   * /*spin_axis*/,        /* spin axis */
const PK_BODY_make_spun_outline_o_t   * /*options*/,          /* option structure */
/* returned */
int                             *const  /*n_curves*/,         /* number of curves */
PK_CURVE_t                     **const  /*curves*/,           /* boundary curves */
PK_INTERVAL_t                  **const  /*intervals*/,        /* parametric */
PK_TOPOL_t                     **const  /*topols*/,           /* edges/faces of */
int                            **const  /*outlines*/,         /* indicates which */
double                         **const  /*curve_tolerances*/, /* curve tolerance */
double                          *const  /*max_separation*/    /* largest gap */
);
/*
This function outputs one or more outlines of a body or bodies for a given
spin axis as a set of ordered curves together with their intervals.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_taper
(
/* received */
const PK_BODY_t               /*body*/,            /* body to be tapered */
int                           /*n_refs_above*/,    /* number of reference */
const PK_ENTITY_t             /*refs_above*/[],    /* reference entities */
int                           /*n_refs_below*/,    /* number of reference */
const PK_ENTITY_t             /*refs_below*/[],    /* reference entities */
const PK_BODY_t               /*parting_body*/,    /* parting body */
PK_VECTOR1_t                  /*direction*/,       /* draw direction */
double                        /*angle_above*/,     /* taper angle above */
double                        /*angle_below*/,     /* taper angle below */
const PK_BODY_taper_o_t     * /*options*/,         /* options */
/* returned */
PK_TOPOL_track_r_t    *const  /*tracking*/,        /* tracking information */
PK_TOPOL_local_r_t    *const  /*results*/          /* status information */
);
/*
This function applies two-sided tapering to the `body' parted
by the `parting_body'.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_trim_neutral_sheets
(
/* received */
PK_BODY_t                       /*body*/,              /* the target body */
int                             /*n_pairs*/,           /* the number of pairs */
const PK_FACE_set_pair_t        /*pairs*/[],           /* array of pairs */
double                          /*tol*/,               /* tolerance for curves */
/* returned */
PK_BODY_t                       /*neutral_sheets*/[],  /* neutral sheets */
PK_neutral_error_t              /*errors*/[],          /* status of neutral sheets */
PK_FACE_neutral_causes_array_t  /*causes*/[]           /* tracking information */
);
/*
This function trims the neutral sheets in accordance with their pairs
of face sets.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_trim_neutral_sheets_2
(
/* received */
PK_BODY_t                               /*body*/,              /* the target body */
int                                     /*n_pairs*/,           /* number of pairs */
const PK_FACE_set_pair_t                /*pairs*/[],           /* array of pairs */
double                                  /*tol*/,               /* tolerance for */
const PK_BODY_trim_neutral_sheets_o_t * /*options*/,           /* option structure */
/* returned */
PK_BODY_t                               /*neutral_sheets*/[],  /* neutral sheets */
PK_neutral_error_t                      /*errors*/[],          /* status of neutral */
PK_FACE_neutral_causes_array_t          /*causes*/[],          /* tracking */
PK_TOPOL_track_r_t              *const  /*tracking*/           /* tracking */
);
/*
This function trims the neutral sheets in accordance with their pairs
of face sets.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_offset
(
/* received */
PK_BODY_t            /*body*/,               /* body to be offset */
double               /*offset*/,             /* offset distance */
double               /*tolerance*/,          /* tolerance */
PK_LOGICAL_t         /*face_face_check*/     /* do face face checks */
/* returned */
);
/*
Offsets faces of a solid or sheet body
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_offset_2
(
/* received */
PK_BODY_t                    /*body*/,
double                       /*offset*/,           /* offset for each face */
double                       /*tolerance*/,        /* tolerance */
const PK_BODY_offset_o_t   * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t   *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t   *const  /*results*/           /* status information */
);
/*
This function offsets faces of a solid or sheet body.

NOTE : This function supersedes PK_BODY_offset.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_offset_planar_wire
(
/* received */
PK_BODY_t                              /*wire_body*/,    /* planar wire body */
double                                 /*offset*/,       /* offset distance */
PK_VECTOR1_t                           /*normal*/,       /* normal of the plane */
PK_EDGE_t                              /*ref*/,          /* reference edge */
const PK_BODY_offset_planar_wire_o_t * /*options*/,      /* options structure */
/* returned */
int                            *const  /*n_new_wires*/,  /* number of new wires */
PK_BODY_t                     **const  /*new_wires*/,    /* new wires */
PK_TOPOL_track_r_t             *const  /*tracking*/      /* tracking information */
);
/*
This function offsets a planar wire body in the plane by a specified
distance. Edges of the new offset wire bodies are paired with their
originating edges or vertices in the tracking information.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_pick_topols_r_f
(
/* received */
PK_BODY_pick_topols_r_t *const  /*picked*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_pick_topols
(
/* received */
const int                        /*n_bodies*/,        /* number of bodies */
const PK_PART_t                  /*bodies*/[],        /* body array */
const PK_TRANSF_t              * /*body_transfs*/,    /* transformations */
const PK_AXIS1_sf_t            * /*ray*/,             /* picking ray */
const PK_BODY_pick_topols_o_t  * /*options*/,         /* control options */
/* returned */
PK_BODY_pick_topols_r_t *const  /*picked*/            /* picked entities */
);
/*
Pick entities from an array of body instances by their proximity to a line
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_section_with_sheet
(
/* received */
PK_BODY_t                   /*target*/,         /* Body to be sectioned by sheet */
PK_BODY_t                   /*sheet*/,          /* Sectioning sheet body */
const PK_BODY_section_o_t * /*options*/,        /* Sectioning options */
/* returned */
PK_section_r_t      *const  /*results*/         /* front/back faces/bodies */
);
/*
This function sections the target body with the tool sheet body.

NOTE: This function is obsolete and has been superseded
by PK_BODY_section_with_sheet_2.

*/

PK_linkage_m PK_ERROR_code_t PK_BODY_section_with_sheet_2
(
/* received */
PK_BODY_t                       /*target*/,     /* body to be sectioned by sheet */
PK_BODY_t                       /*sheet*/,      /* sectioning sheet body */
const PK_BODY_section_o_t     * /*options*/,    /* sectioning options */
/* returned */
PK_TOPOL_track_r_t      *const  /*tracking*/,   /* tracking information */
PK_section_2_r_t        *const  /*results*/     /* front/back faces/bodies */
);
/*
This function sections the target body with the tool sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_section_with_surf
(
/* received */
PK_BODY_t                   /*target*/,         /* Body to be sectioned by surface */
PK_SURF_t                   /*surface*/,        /* Sectioning surface */
const PK_BODY_section_o_t * /*options*/,        /* Sectioning options */
/* returned */
PK_section_r_t      *const  /*results*/         /* front/back faces/bodies */
);
/*
This function sections the target body with the tool surface.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_section
(
/* received */
int                              /*n_targets*/,  /* number of target bodies */
PK_BODY_t                        /*targets*/[],  /* target bodies */
int                              /*n_tools*/,    /* number of tool bodies */
PK_BODY_t                        /*tools*/[],    /* tool bodies */
const PK_BODY_make_section_o_t * /*options*/,    /* Sectioning options */
/* returned */
PK_TOPOL_track_r_t       *const  /*tracking*/,   /* tracking information */
PK_BODY_make_section_r_t *const  /*results*/     /* resultant bodies */
);
/*
This function generates sections of target bodies using set of tool bodies.
Target bodies remain unchanged.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_section_with_surfs
(
/* received */
int                              /*n_targets*/,  /* number of target bodies */
PK_BODY_t                        /*targets*/[],  /* target bodies */
int                              /*n_tools*/,    /* number of tool surfaces */
PK_SURF_t                        /*tools*/[],    /* tool surfaces */
const PK_BODY_make_section_o_t * /*options*/,    /* Sectioning options */
/* returned */
PK_TOPOL_track_r_t       *const  /*tracking*/,   /* tracking information */
PK_BODY_make_section_r_t *const  /*results*/     /* resultant bodies */
);
/*
This function generates sections of target bodies using set of tool surfaces.
Target bodies remain unchanged.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_sew_bodies
(
/* received */
int                               /*n_bodies*/,         /* number of bodies to sew */
const PK_BODY_t                   /*bodies*/[],         /* bodies to sew */
double                            /*gap_width_bound*/,  /* lower bound on gap width */
const PK_BODY_sew_bodies_o_t    * /*options*/,          /* options on sewing */
/* returned */
int                       *const  /*n_sewn_bodies*/,    /* number of sewn bodies */
PK_BODY_t                **const  /*sewn_bodies*/,      /* bodies produced by sewing */
int                       *const  /*n_unsewn_bodies*/,  /* number of input bodies */
PK_BODY_t                **const  /*unsewn_bodies*/,    /* input bodies not sewn */
int                       *const  /*n_problem_groups*/, /* number of problem */
PK_BODY_problem_group_t  **const  /*problem_groups*/    /* problem edge groups */
);
/*
This function attempts to sew the received bodies together where they have
edges common to within a given tolerance upper bound.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_find_knit_pattern
(
/* received */
int                                   /*n_bodies*/,           /* array of */
const PK_BODY_t                       /*bodies*/[],           /* bodies between */
const PK_BODY_find_knit_pattern_o_t * /*options*/,            /* options */
/* returned */
PK_BODY_knit_pattern_t        *const  /*knit_pattern*/,       /* knitting pattern */
int                           *const  /*n_absent_bodies*/,    /* bodies not included */
PK_BODY_t                    **const  /*absent_bodies*/       /* in pattern */
);
/*
This function constructs a knitting pattern by matching and splitting
coincident edges, then pairing them off into corresponding entries in
two edge arrays.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_apply_knit_pattern
(
/* received */
const PK_BODY_t                        /*body*/,          /* target body */
const PK_BODY_knit_pattern_t         * /*knit_pattern*/,  /* knitting pattern */
const PK_BODY_apply_knit_pattern_o_t * /*options*/,       /* options */
/* returned */
PK_BODY_knit_result_t          *const  /*knit_result*/    /* status, edges not knit */
);
/*
This function assembles a composite sheet or solid body by merging paired edge
in the knit pattern
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_knit
(
/* received */
PK_BODY_t                           /*body*/,         /* target body */
int                                 /*n_topols*/,     /* number of topols */
const PK_TOPOL_t                    /*topols*/[],     /* topols */
const PK_TOPOL_t                    /*matches*/[],    /* matched topols */
PK_BODY_knit_o_t                  * /*options*/,      /* options */
/* returned */
PK_TOPOL_track_r_t          *const  /*tracking*/      /* tracking information */
);
/*
This function assembles a body by merging paired topols from the `topols'
and `matches' array.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_share_geom
(
/* received */
PK_BODY_t        /*body*/,         /* body on which to attempt sharing */
PK_LOGICAL_t     /*icurve_only*/,  /* only process intersection curves */
/* returned */
int      *const  /*n_geoms*/       /* number of geometries removed */
);
/*
This function attempts to reduce the size of a part by sharing geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_spin
(
/* received */
PK_BODY_t                /*body*/,           /* minimum, wire or sheet body */
const PK_AXIS1_sf_t    * /*axis*/,           /* spin axis */
double                   /*angle*/,          /* spin angle */
PK_LOGICAL_t             /*local_check*/,    /* whether local checking will be done */
/* returned */
int              *const  /*n_laterals*/,     /* number of laterals */
PK_TOPOL_t      **const  /*laterals*/,       /* new edges of faces (may be NULL) */
PK_TOPOL_t      **const  /*bases*/,          /* entities swept into laterals */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function spins a minimum body into a wire body, a wire body into a
sheet body, a sheet body into a solid body or a general body into a general
body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_tracked_sweep_r_f
(
/* received */
PK_BODY_tracked_sweep_r_t *const  /*profile*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_tracked_sweep_2_r_f
(
/* received */
PK_BODY_tracked_sweep_2_r_t *const  /*swept_body*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_sweep_tool_r_f
(
/* received */
PK_BODY_sweep_tool_r_t *const  /*swept_body*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_swept_body
(
/* received */
const PK_BODY_t                      /*profile*/,          /* profile to sweep */
const PK_BODY_t                      /*path*/,             /* path of sweep */
const PK_VERTEX_t                    /*path_start*/,       /* path start vertex */
const PK_BODY_make_swept_body_o_t  * /*options*/,          /* options on sweeping */
/* returned */
PK_BODY_tracked_sweep_r_t    *const  /*swept_body*/        /* result swept body */
);
/*
This function creates a sheet or solid body by sweeping a wire or sheet
profile along a wire path.

NOTE: This function is superseded by PK_BODY_make_swept_body_2.

*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_swept_body_2
(
/* received */
int                                   /*n_profiles*/,         /* number of profiles */
const PK_BODY_t                       /*profiles*/[],         /* profiles to sweep */
const PK_BODY_t                       /*path*/,               /* path of sweep */
const PK_VERTEX_t                     /*path_vertices*/[],    /* path vertices where */
const PK_BODY_make_swept_body_2_o_t * /*options*/,            /* options on sweeping */
/* returned */
PK_BODY_tracked_sweep_2_r_t   *const  /*swept_body*/          /* result swept body */
);
/*
This function creates a sheet or solid body by sweeping a set of
wire or sheet profiles along a wire path.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_swept_profiles
(
/* received */
const PK_BODY_t                          /*profile*/,       /* profile to sweep */
const PK_BODY_t                          /*path*/,          /* path of sweep */
const PK_VERTEX_t                        /*path_start*/,    /* path start vertex */
const PK_BODY_make_swept_profiles_o_t  * /*options*/,       /* options on sweeping */
/* returned */
int                              *const  /*n_profiles*/,
PK_BODY_tracked_sweep_r_t       **const  /*profiles*/        /* result profiles */
);
/*
This function sweeps a given profile along the specified path to produce
a set of profiles at each vertex of the path.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_make_swept_tool
(
/* received */
const PK_BODY_t                     /*tool*/,            /* tool to sweep */
const PK_AXIS1_sf_t               * /*tool_axis*/,       /* axis for tool */
const PK_BODY_t                     /*path*/,            /* path of sweep */
const PK_BODY_make_swept_tool_o_t * /*options*/,         /* options on sweeping */
/* returned */
PK_TOPOL_track_r_t          *const  /*tracking*/,        /* tracking information */
PK_BODY_sweep_tool_r_t      *const  /*swept_tool*/       /* resulting swept tool */
);
/*
This function creates a solid body by sweeping a solid tool body along a wire
path.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_sweep
(
/* received */
PK_BODY_t                /*body*/,           /* minimum, wire or sheet body */
PK_VECTOR_t              /*path*/,           /* translation vector */
PK_LOGICAL_t             /*local_check*/,    /* whether local checking will be done */
/* returned */
int              *const  /*n_laterals*/,     /* number of laterals */
PK_TOPOL_t      **const  /*laterals*/,       /* new edges or faces (may be NULL) */
PK_TOPOL_t      **const  /*bases*/,          /* entities swept into laterals */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function sweeps a minimum body into a wire body, a wire body into a
sheet body, a sheet body into a solid body or a general body into a general
body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_thicken
(
/* received */
PK_BODY_t            /*body*/,               /* sheet body to be thickened */
double               /*front*/,              /* thickness on front of face */
double               /*back*/,               /* thickness on back of face */
double               /*tolerance*/,          /* tolerance for SP-curve conversion */
PK_LOGICAL_t         /*face_face_check*/,    /* do face face checks */
/* returned */
int          *const  /*n_topols*/,           /* number of topols */
PK_TOPOL_t  **const  /*old_topols*/,         /* original topology (optional) */
PK_TOPOL_t  **const  /*new_topols*/          /* new topology      (optional) */
);
/*
Thickens a sheet body into a solid

NOTE: This function is obsolete and has been superseded by
PK_BODY_thicken_2

*/

PK_linkage_m PK_ERROR_code_t PK_BODY_thicken_2
(
/* received */
PK_BODY_t                   /*body*/,             /* body to be thickened */
double                      /*front_default*/,    /* default front offset */
double                      /*back_default*/,     /* default back offset */
double                      /*tolerance*/,        /* tolerance */
const PK_BODY_thicken_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t  *const  /*tracking*/,         /* tracking information */
PK_BODY_thicken_r_t *const  /*results*/           /* status information */
);
/*
Thickens a sheet body into a solid

NOTE: This function supersedes PK_BODY_thicken, which is now obsolete.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_thicken_3
(
/* received */
PK_BODY_t                   /*body*/,             /* body to be thickened */
double                      /*front_default*/,    /* default front offset */
double                      /*back_default*/,     /* default back offset */
double                      /*tolerance*/,        /* tolerance */
const PK_BODY_thicken_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t  *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t  *const  /*results*/           /* status information */
);
/*
This function thickens a sheet body into a solid body.

NOTE: This function supersedes PK_BODY_thicken_2, which is now obsolete.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_transform
(
/* received */
PK_BODY_t             /*body*/,           /* body to be transformed */
PK_TRANSF_t           /*transf*/,         /* transformation */
double                /*tolerance*/,      /* tolerance for replacement geometry */
/* returned */
int           *const  /*n_replaces*/,     /* number of geoms replaced */
PK_GEOM_t    **const  /*replaces*/,       /* replaced geometry (optional) */
PK_LOGICAL_t **const  /*exact*/           /* whether replaced geometry is exact */
);
/*
This function transforms the given body by the given transformation.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_transform_2
(
/* received */
PK_BODY_t                     /*body*/,             /* body to be transformed */
PK_TRANSF_t                   /*transf*/,           /* transformation */
double                        /*tolerance*/,        /* tolerance */
const PK_BODY_transform_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t    *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t    *const  /*results*/           /* status information */
);
/*
This function transforms the given body by the given transformation.

NOTE : This function supersedes PK_BODY_transform.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_trim
(
/* received */
PK_BODY_t          /*body*/,          /* a body */
int                /*n_edges*/,       /* number of edges */
const PK_EDGE_t    /*edges*/[],       /* edges */
int                /*n_faces*/,       /* number of faces */
const PK_FACE_t    /*faces*/[],       /* faces */
PK_LOGICAL_t       /*keep*/           /* Logical to determine whether we keep */
);
/*
This function trims the `body' which must be a sheet.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_trim_gap_analysis
(
/* received */
PK_BODY_t            /*body*/,        /* a body */
int                  /*n_edges*/,     /* number of edges */
const PK_EDGE_t      /*edges*/[],     /* edges */
double               /*tol*/,         /* tolerance */
/* returned */
int          *const  /*n_vertices*/,  /* number of problem vertices */
PK_VERTEX_t **const  /*vertices*/     /* problem vertices */
);
/*
This function finds gaps in the edges supplied to a failed trim operation.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_ask_topology
(
/* received */
PK_BODY_t                        /*body*/,         /* body */
const PK_BODY_ask_topology_o_t * /*options*/,      /* options */
/* returned */
int                      *const  /*n_topols*/,     /* number of topological */
PK_TOPOL_t              **const  /*topols*/,       /* topological entities */
PK_CLASS_t              **const  /*classes*/,      /* classes of topological */
int                      *const  /*n_relations*/,  /* number of relations */
int                     **const  /*parents*/,      /* parents in relations */
int                     **const  /*children*/,     /* children in relations */
PK_TOPOL_sense_t        **const  /*senses*/        /* senses in relations */
);
/*
This function returns a definition of the topology of a body in a general
topology representation.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_topology
(
/* received */
int                                 /*n_topols*/,     /* number of topols */
const PK_CLASS_t                    /*classes*/[],    /* class of each topol */
int                                 /*n_relations*/,  /* number of relations */
const int                           /*parents*/[],    /* parents */
const int                           /*children*/[],   /* children */
const PK_TOPOL_sense_t              /*senses*/[],     /* sense in which child */
const PK_BODY_create_topology_o_t * /*options*/,      /* options */
/* returned */
PK_BODY_t                   *const  /*body*/,         /* created body */
PK_TOPOL_t                  *const  /*topols*/,       /* created topols */
PK_BODY_fault_t             *const  /*fault*/,        /* fault indicator */
int                         *const  /*fault_index*/   /* index of fault topol */
);
/*
This function creates the topology of a general body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_topology_2
(
/* received */
int                                   /*n_topols*/,     /* number of topols */
const PK_CLASS_t                      /*classes*/[],    /* class of each topol */
int                                   /*n_relations*/,  /* number of relations */
const int                             /*parents*/[],    /* parents */
const int                             /*children*/[],   /* children */
const PK_TOPOL_sense_t                /*senses*/[],     /* sense in which child */
const PK_BODY_create_topology_2_o_t * /*options*/,      /* options */
/* returned */
PK_BODY_create_topology_2_r_t *const  /*creation*/      /* result */
);
/*
This function creates the topology of a general body.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_create_topology_2_r_f
(
/* received */
PK_BODY_create_topology_2_r_t *const  /*creation*/   /* structure to free */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_BODY_set_type
(
/* received */
PK_BODY_t                      /*body*/,          /* body to have its type changed */
PK_BODY_type_t                 /*new_type*/,      /* type to change to (if possible) */
const PK_BODY_set_type_o_t   * /*options*/        /* options structure */
);
/*
This function tries to change the type of the body (e.g. from General to
Solid). If the change is not possible, either a mild error is returned
and the body is unchanged, or in specific cases a serious error is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_INSTANCE_create
(
/* received */
const PK_INSTANCE_sf_t * /*instance_sf*/,   /* standard form of a instance */
/* returned */
PK_INSTANCE_t    *const  /*instance*/       /* the instance */
);
/*
This function creates a instance from the given standard form.
*/

PK_linkage_m PK_ERROR_code_t PK_INSTANCE_ask
(
/* received */
PK_INSTANCE_t            /*instance*/,      /* an instance */
/* returned */
PK_INSTANCE_sf_t *const  /*instance_sf*/    /* the standard form of the instance */
);
/*
This function returns the standard form of the given instance.
*/

PK_linkage_m PK_ERROR_code_t PK_INSTANCE_change_part
(
/* received */
PK_INSTANCE_t            /*instance*/,      /* an instance */
PK_PART_t                /*part*/           /* part to point to */
);
/*
This function modifies the given instance so that it instances a different
part.

If this would cause the assembly graph to become cyclic, PK_ERROR_cyclic_assy
will be returned.
*/

PK_linkage_m PK_ERROR_code_t PK_INSTANCE_transform
(
/* received */
PK_INSTANCE_t       /*instance*/,     /* instance */
PK_TRANSF_t         /*transf*/        /* transform (may be PK_ENTITY_null) */
);
/*
This function transforms an instance by transforming its transform. The given
transform must be a rigid motion. The null transform is treated as the
identity.
*/

PK_linkage_m PK_ERROR_code_t PK_INSTANCE_replace_transf
(
/* received */
PK_INSTANCE_t       /*instance*/,     /* instance */
PK_TRANSF_t         /*transf*/        /* replacement transform */
);
/*
This function replaces the transform of an instance by the given one. Either
(or both) of these transforms may be PK_ENTITY_null. The given transform must
be a rigid motion, or PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_ask_body
(
/* received */
PK_REGION_t       /*region*/,             /* a region */
/* returned */
PK_BODY_t *const  /*body*/                /* owning body */
);
/*
This function returns the body containing the given region.

If the region is contained within a compound body ( see PK_BODY_ask_config )
then the child body to which the region belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_ask_shells
(
/* received */
PK_REGION_t         /*region*/,           /* a region */
/* returned */
int         *const  /*n_shells*/,         /* number of shells (>= 0) */
PK_SHELL_t **const  /*shells*/            /* shells (optional) */
);
/*
This function returns the set of shells bounding the given region.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_is_solid
(
/* received */
PK_REGION_t          /*region*/,     /* the region */
/* returned */
PK_LOGICAL_t *const  /*is_solid*/    /* whether region is solid or void */
);
/*
This function returns PK_LOGICAL_true if the given region is solid and
PK_LOGICAL_false if it is void.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_combine_bodies
(
/* received */
PK_REGION_t      /*target_region*/,          /* a region of the first body */
PK_BODY_t        /*tool_body*/               /* the second body */
);
/*
This function combines two bodies into a single disconnected body.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_make_void
(
/* received */
PK_REGION_t      /*region*/      /* region to be made void */
);
/*
This function sets the type of the given `region' to be void.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_make_solid
(
/* received */
PK_REGION_t      /*region*/      /* region to be made solid */
);
/*
This function sets the type of the given region to be solid.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_imprint_curve
(
/* received */
PK_REGION_t          /*region*/,          /* region */
PK_CURVE_t           /*curve*/,           /* curve */
PK_INTERVAL_t        /*bounds*/,          /* bounds of curve */
/* returned */
int          *const  /*n_new_edges*/,     /* number of new edges */
PK_EDGE_t   **const  /*new_edges*/,       /* new edges (optional) */
int          *const  /*n_new_faces*/,     /* number of new faces */
PK_FACE_t   **const  /*new_faces*/        /* new faces (optional) */
);
/*
This function imprints a curve onto a region, thereby creating a new edge or
edges.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_imprint_point
(
/* received */
PK_REGION_t         /*region*/,       /* region */
PK_POINT_t          /*point*/,        /* point to imprint onto region */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/    /* new vertex */
);
/*
This function imprints a point onto a region, thereby creating a new acorn
vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_REGION_ask_regions_adjacent
(
/* received */
PK_REGION_t      /*region*/,              /* a region */
/* returned */
int            * /*n_regions_adjacent*/,  /* number of adjacent regions */
PK_REGION_t   ** /*regions_adjacent*/     /* adjacent regions ( may be NULL ) */
);
/*
This function returns all regions which are immediately adjacent to the given
region.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_acorn_vertex
(
/* received */
PK_SHELL_t          /*shell*/,        /* a shell */
/* returned */
PK_VERTEX_t *const  /*vertex*/        /* its acorn vertex (or PK_ENTITY_null) */
);
/*
This function returns the single acorn vertex of the given shell if the shell
is of type PK_SHELL_type_acorn_c, otherwise PK_ENTITY_null is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_body
(
/* received */
PK_SHELL_t        /*shell*/,                  /* a shell */
/* returned */
PK_BODY_t *const  /*body*/                    /* owning body */
);
/*
This function returns the body of the given shell.

If the shell is contained within a compound body ( see PK_BODY_ask_config )
then the child body to which the shell belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_oriented_faces
(
/* received */
PK_SHELL_t            /*shell*/,              /* a shell */
/* returned */
int           *const  /*n_faces*/,            /* number of faces (>= 0) */
PK_FACE_t    **const  /*faces*/,              /* faces (optional) */
PK_LOGICAL_t **const  /*orients*/             /* orientations (optional) */
);
/*
This function returns the list of faces in the given shell, together with their
orientations with respect to the shell.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_region
(
/* received */
PK_SHELL_t          /*shell*/,                /* a shell */
/* returned */
PK_REGION_t *const  /*region*/                /* owning region */
);
/*
This function returns the region of the given shell.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_type
(
/* received */
PK_SHELL_t              /*shell*/,        /* the shell */
/* returned */
PK_SHELL_type_t *const  /*shell_type*/    /* the type of the shell */
);
/*
This function classifies the given shell according to the types of
topological entities it contains.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_ask_wireframe_edges
(
/* received */
PK_SHELL_t         /*shell*/,             /* a shell */
/* returned */
int        *const  /*n_edges*/,           /* number of wireframe edges (>= 0) */
PK_EDGE_t **const  /*edges*/              /* wireframe edges (optional) */
);
/*
This function returns the set of wireframe edges in the given shell.
*/

PK_linkage_m PK_ERROR_code_t PK_SHELL_find_sign
(
/* received */
PK_SHELL_t              /*shell*/,        /* a shell */
/* returned */
PK_SHELL_sign_t *const  /*shell_sign*/    /* the sign of the shell */
);
/*
This function classifies the given shell according to whether it
closes off a volume and, if it does, whether the volume inside the
shell is finite or infinite.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_close_gaps
(
/* received */
PK_FACE_t                      /*face*/,         /* face */
const PK_FACE_close_gaps_o_t * /*options*/,      /* options on how to close loops */
/* returned */
int                    *const  /*n_vertices*/,   /* number of vertices where gaps */
PK_VERTEX_t           **const  /*vertices*/      /* vertices where gaps remain */
);
/*
This function closes gaps at tolerant vertices in the face loops by modifying
the fin geometries of the loops. Where gaps cannot be closed the vertices at
those gaps will be returned.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_contains_vectors
(
/* received */
PK_FACE_t                      /*face*/,  /* face */
PK_FACE_contains_vectors_o_t * /*options*/,
/* returned */
PK_TOPOL_t                     /*topologies*/[]
);
/*
This function determines whether the points represented by the given vectors
or parameters lie inside, outside or on the boundary of the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_is_uvbox
(
/* received */
PK_FACE_t            /*face*/,        /* face for which uvbox required */
/* returned */
PK_LOGICAL_t *const  /*is_uvbox*/,    /* whether `face' is parametric rectangle */
PK_UVBOX_t   *const  /*uvbox*/        /* `face's uvbox if `is_uvbox is */
);
/*
This function detects whether a face is parametrically rectangular.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_is_periodic
(
/* received */
PK_FACE_t                   /*face*/,         /* a face */
/* returned */
PK_PARAM_periodic_t *const  /*periodic_u*/,   /* periodicity in u */
PK_PARAM_periodic_t *const  /*periodic_v*/    /* periodicity in v */
);
/*
This function asks whether the face is periodic.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_sheet_body
(
/* received */
int               /*n_faces*/,             /* number of faces */
const PK_FACE_t   /*faces*/[],             /* array of faces */
/* returned */
PK_BODY_t *const  /*body*/                 /* sheet body */
);
/*
This function creates a sheet body from a collection of faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_sheet_bodies
(
/* received */
int                                    /*n_faces*/,   /* number of faces */
const PK_FACE_t                        /*faces*/[],   /* array of faces */
const PK_FACE_make_sheet_bodies_o_t  * /*options*/,   /* options structure */
/* returned */
int                            *const  /*n_bodies*/,  /* number of bodies */
PK_BODY_t                     **const  /*bodies*/,    /* sheet bodies */
PK_TOPOL_track_r_t             *const  /*tracking*/   /* tracking information */
);
/*
This function creates sheet bodies from a collection of faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_solid_bodies
(
/* received */
int                       /*n_faces*/,           /* number of faces */
const PK_FACE_t           /*faces*/[],           /* faces */
PK_FACE_heal_t            /*heal_action*/,       /* method for healing wounds */
PK_LOGICAL_t              /*local_check*/,       /* whether to perform local check */
/* returned */
int               *const  /*n_bodies*/,
PK_BODY_t        **const  /*bodies*/,            /* created solid bodies */
PK_local_check_t **const  /*check_results*/      /* results of local check */
);
/*
This function creates solid bodies from a collection of faces
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_neutral_sheet
(
/* received */
PK_FACE_t         /*faces*/[2],       /* two faces */
double            /*placement*/,      /* placement parameter */
/* returned */
PK_BODY_t *const  /*neutral_sheet*/   /* neutral sheet */
);
/*
This function creates the neutral surface defined by the surfaces on the
faces and returns it as a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_neutral_sheet_2
(
/* received */
int                                    /*n_left_faces*/,    /* number of left faces */
const PK_FACE_t                        /*left_faces*/[],    /* left faces */
int                                    /*n_right_faces*/,   /* number of right faces */
const PK_FACE_t                        /*right_faces*/[],   /* right faces */
double                                 /*placement*/,       /* placement parameter */
const PK_FACE_make_neutral_sheet_o_t * /*options*/,         /* options structure */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/         /* tracking information */
);
/*
This function creates the neutral sheet defined by the surfaces on the
faces and returns it as a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_valid_faces
(
/* received */
PK_FACE_t            /*face*/,           /* face */
/* returned */
int          *const  /*n_faces*/,
PK_FACE_t   **const  /*new_faces*/,
PK_LOGICAL_t *const  /*succeeded*/
);
/*

THIS IS ONLY AN INTERIM VERSION TO ALLOW TESTING - THE INTERFACE WILL
CHANGE

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_repair
(
/* received */
PK_FACE_t                   /*face*/,      /* face */
const PK_FACE_repair_o_t  * /*options*/,   /* options structure */
/* returned */
PK_TOPOL_track_r_t  *const  /*tracking*/   /* tracking information */
);
/*
This function attempts to repair an face, i.e. make it valid. The option
structure determines which type of repair is attempted. At present there are
two types of repair provided: splitting the face to remove G1 discontinuities
in the surface, and splitting the face to remove areas of surface
self-intersection which lie outside the face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_set_approx
(
/* received */
int              /*n_faces*/,         /* number of faces to process (>0) */
const PK_FACE_t  /*faces*/[]          /* faces for which approximations are required */
);
/*
This function produces an approximate representation of the edges of the
supplied faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_simplify_geom
(
/* received */
int                                  /*n_faces*/,     /* number of faces */
PK_FACE_t                            /*faces*/[],     /* faces */
const PK_FACE_simplify_geom_o_t    * /*options*/,     /* options */
/* returned */
int                          *const  /*n_geoms*/,     /* number of geoms returned */
PK_GEOM_t                   **const  /*geoms*/        /* new geoms (optional) */
);
/*
This function simplifies the geometries of the supplied faces, where possible.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_unset_approx
(
/* received */
int              /*n_faces*/,         /* number of faces to process (>0) */
const PK_FACE_t  /*faces*/[]          /* faces to clear of approximations */
);
/*
This function unsets the approximate representation of the edges of the
supplied faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_reverse
(
/* received */
int                         /*n_faces*/,     /* number of faces */
const PK_FACE_t             /*faces*/[],     /* faces */
const PK_FACE_reverse_o_t * /*options*/      /* options */
);
/*
This function reverses the orientation of a given set of faces, but will
not change any of their associated geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_body
(
/* received */
PK_FACE_t         /*face*/,              /* a face */
/* returned */
PK_BODY_t *const  /*body*/               /* owning body */
);
/*
This function returns the body which contains the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_shells
(
/* received */
PK_FACE_t        /*face*/,               /* a face */
/* returned */
PK_SHELL_t       /*shells*/[2]           /* pair of shells */
);
/*
This function returns the shells of the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_loops
(
/* received */
PK_FACE_t          /*face*/,             /* a face */
/* returned */
int        *const  /*n_loops*/,          /* number of loops (>= 0) */
PK_LOOP_t **const  /*loops*/             /* loops (optional) */
);
/*
This function returns the set of loops bounding the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_edges
(
/* received */
PK_FACE_t          /*face*/,             /* a face */
/* returned */
int        *const  /*n_edges*/,          /* number of edges (>= 0) */
PK_EDGE_t **const  /*edges*/             /* edges (optional) */
);
/*
This function returns the set of edges in the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_vertices
(
/* received */
PK_FACE_t            /*face*/,           /* a face */
/* returned */
int          *const  /*n_vertices*/,     /* number of vertices (>= 0) */
PK_VERTEX_t **const  /*vertices*/        /* vertices (optional) */
);
/*
This function returns the set of vertices in the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_next_in_body
(
/* received */
PK_FACE_t         /*face*/,           /* a face */
/* returned */
PK_FACE_t *const  /*next*/            /* the next face (possibly PK_ENTITY_null) */
);
/*
This function returns the next face in the body which contains the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_first_loop
(
/* received */
PK_FACE_t         /*face*/,           /* a face */
/* returned */
PK_LOOP_t *const  /*first_loop*/      /* the first loop (possibly PK_ENTITY_null) */
);
/*
This function returns the first loop in the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_oriented_surf
(
/* received */
PK_FACE_t            /*face*/,    /* a face */
/* returned */
PK_SURF_t    *const  /*surf*/,        /* the surface (possibly PK_ENTITY_null) */
PK_LOGICAL_t *const  /*orientation*/  /* the face orientation with respect to its */
);
/*
This function returns the surface and orientation of the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_surf
(
/* received */
PK_FACE_t         /*face*/,                /* a face */

/* returned */
PK_SURF_t *const  /*surf*/                 /* its surface (possibly PK_ENTITY_null) */
);
/*
This function returns the surface of the given face, if there is one, otherwise
PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_ask_faces_adjacent
(
/* received */
int                                    /*n_faces*/,           /* number of faces */
const PK_FACE_t                        /*faces*/[],           /* array of faces */
const PK_FACE_ask_faces_adjacent_o_t * /*options*/,           /* options structure */
/* returned */
int                            *const  /*n_faces_adjacent*/,  /* number of adjacent */
PK_FACE_t                     **const  /*faces_adjacent*/     /* adjacent faces */
);
/*
This function returns all faces which are immediately adjacent to the given
array of faces
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_attach_surf_fitting
(
/* received */
PK_FACE_t                /*face*/,                 /* face */
PK_LOGICAL_t             /*local_check*/,          /* whether to perform local check */
/* returned */
PK_local_check_t *const  /*local_check_result*/    /* result of local check */
);
/*
This function creates a surface to fit and attach to face
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_attach_surfs
(
/* received */
int                 /*n_faces*/,      /* number of faces */
const PK_FACE_t     /*faces*/[],      /* faces to have surfaces attached */
const PK_SURF_t     /*surfs*/[],      /* surfaces to be attached to faces */
const PK_LOGICAL_t  /*senses*/[]      /* face senses */
);
/*
This function attaches surfaces to faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_boolean
(
/* received */
int                          /*n_targets*/,   /* number of target faces */
const PK_FACE_t              /*targets*/[],   /* target faces */
int                          /*n_tools*/,     /* number of tool faces */
const PK_FACE_t              /*tools*/[],     /* tool faces */
const PK_FACE_boolean_o_t  * /*options*/,     /* boolean options */
/* returned */
int                  *const  /*n_bodies*/,    /* number of resultant bodies */
PK_BODY_t           **const  /*bodies*/       /* resultant bodies */
);
/*
This function performs a boolean operation between the list of faces
of a target body and the list of faces of a tool body.

NOTE: This function is obsolete and has been superseded by PK_FACE_boolean_2.

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_boolean_2
(
/* received */
int                             /*n_targets*/,   /* number of target faces */
const PK_FACE_t                 /*targets*/[],   /* target faces */
int                             /*n_tools*/,     /* number of tool faces */
const PK_FACE_t                 /*tools*/[],     /* tool faces */
const PK_FACE_boolean_o_t     * /*options*/,     /* boolean options */
/* returned */
PK_TOPOL_track_r_t      *const  /*tracking*/,    /* tracking information */
PK_boolean_r_t          *const  /*results*/      /* boolean results */
);
/*
This function performs a boolean operation between the list of faces
of a target body and the list of faces of a tool body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_check
(
/* received */
PK_FACE_t                     /*face*/,          /* face to be checked */
const PK_FACE_check_o_t     * /*options*/,       /* options structure */
/* returned */
int                   *const  /*n_faults*/,      /* number of faults */
PK_check_fault_t     **const  /*faults*/         /* faults */
);
/*
This function checks the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_check_pair
(
/* received */
PK_FACE_t                       /*face_1*/,        /* face to be checked */
PK_FACE_t                       /*face_2*/,        /* face to be checked */
const PK_FACE_check_pair_o_t  * /*options*/,       /* options structure */
/* returned */
int                     *const  /*n_faults*/,      /* number of faults */
PK_check_fault_t       **const  /*faults*/         /* faults */
);
/*
This function checks the given pair of faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_2
(
/* received */
int                        /*n_faces*/,           /* number of faces */
const PK_FACE_t            /*faces*/[],           /* faces to delete */
const PK_FACE_delete_o_t * /*options*/,           /* options structure */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/           /* tracking */
);
/*
This function deletes the given faces from a solid or sheet body and repairs
any resulting wounds.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete
(
/* received */
int                       /*n_faces*/,           /* number of faces */
const PK_FACE_t           /*faces*/[],           /* faces */
PK_FACE_heal_t            /*heal_action*/,       /* method for healing wounds */
PK_FACE_heal_loops_t      /*heal_loops*/,        /* how to process the loops of */
PK_LOGICAL_t              /*local_check*/,       /* whether to perform local check */
/* returned */
int               *const  /*n_bodies*/,          /* number of bodies */
PK_BODY_t        **const  /*bodies*/,            /* remaining bodies */
PK_local_check_t **const  /*check_results*/      /* result of local check */
);
/*
This function deletes the given faces from a solid or sheet body and repairs
any resulting holes.

Note: this function is superseded by the function PK_FACE_delete_2.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_from_sheet_body
(
/* received */
PK_FACE_t        /*face*/           /* face */
);
/*
This function removes a face from sheet.  This function is superseded by
the function PK_FACE_delete_from_sheet.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_from_sheet
(
/* received */
int                                   /*n_faces*/,  /* number of faces */
const PK_FACE_t                       /*faces*/[],  /* array of faces */
const PK_FACE_delete_from_sheet_o_t * /*options*/,  /* options structure */
/* returned */
int                           *const  /*n_bodies*/, /* number of bodies */
PK_BODY_t                    **const  /*bodies*/    /* array of bodies */
);
/*
This function removes the specified `faces' from a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_from_gen_body
(
/* received */
int                  /*n_faces*/,            /* number of faces */
const PK_FACE_t      /*faces*/[]             /* faces to delete */
);
/*
This function deletes the given faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_blends
(
/* received */
int                               /*n_faces*/,    /* number of faces */
const PK_FACE_t                   /*faces*/[],    /* faces to delete */
double                            /*tolerance*/,  /* tolerance */
const PK_FACE_delete_blends_o_t * /*options*/,    /* options */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/,   /* tracking information */
PK_TOPOL_local_r_t        *const  /*results*/     /* status information */
);
/*
This function deletes the given faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_delete_facesets
(
/* received */
int                                 /*n_facesets*/,   /* number of facesets */
PK_FACE_array_t                     /*facesets*/[],   /* facesets */
const PK_FACE_delete_facesets_o_t * /*options*/,      /* options structure */
/* returned */
int                         *const  /*n_bodies*/,     /* number of resulting bodies */
PK_BODY_t                  **const  /*bodies*/,       /* resulting bodies */
int                         *const  /*n_failed_facesets*/,
int                        **const  /*failed_facesets_indices*/
);
/*
This function deletes a collection of facesets from a body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_emboss
(
/* received */
int                        /*n_faces*/,           /* number of target faces > 0 */
const PK_FACE_t            /*faces*/[],           /* target faces upon which the */
PK_BODY_t                  /*profile*/,           /* sheet or closed wire defining */
PK_BODY_t                  /*endcap*/,            /* sheet or solid providing */
const PK_FACE_emboss_o_t * /*options*/,           /* options */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,          /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/            /* status information */
);
/*
This function creates emboss features on the target body over areas covered
by the specified `faces'.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_euler_unslit
(
/* received */
PK_FACE_t        /*face*/,        /* Face to be unslit */
PK_EDGE_t        /*surviving*/    /* Edge to survive the unslit */
);
/*
This function replaces a 2-edge face with an edge.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_euler_make_ring_face
(
/* received */
PK_FACE_t         /*face*/,       /* Face to contain new face */
/* returned */
PK_FACE_t *const  /*new_face*/    /* New face created */
);
/*
This function adds a new ring loop to a face, creating a new face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_euler_make_ring_loop
(
/* received */
PK_FACE_t         /*face*/,       /* Face to contain new loop */
/* returned */
PK_LOOP_t *const  /*new_loop*/    /* One of the two loops created */
);
/*
This function adds a new loop to a face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_euler_make_loop
(
/* received */
PK_FACE_t         /*face*/,       /* Face to contain new loop */
/* returned */
PK_LOOP_t *const  /*new_loop*/    /* New loop created */
);
/*
This function adds an isolated vertex and loop to a face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_edges_common
(
/* received */
PK_FACE_t          /*face_1*/,       /* first face */
PK_FACE_t          /*face_2*/,       /* second face */
/* returned */
int        *const  /*n_edges*/,     /* number of common edges */
PK_EDGE_t **const  /*edges*/        /* common edges */
);
/*
This function finds edges which are common to two faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_extreme
(
/* received */
PK_FACE_t           /*face*/,             /* face on which extreme sought */
PK_VECTOR_t         /*direction_1*/,      /* first direction */
PK_VECTOR_t         /*direction_2*/,      /* second direction */
PK_VECTOR_t         /*direction_3*/,      /* third direction */
/* returned */
PK_VECTOR_t *const  /*extreme*/,          /* position of extreme point */
PK_TOPOL_t  *const  /*topol*/             /* topology on which extreme point lies */
);
/*
This function finds the extreme point on the given `face' in `direction_1'.
If this extreme is not a single point, the `direction_2' and `direction_3'
are used successively to reduce the number of extreme points to one.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_uvbox
(
/* received */
PK_FACE_t          /*face*/,           /* face for which uvbox required */
/* returned */
PK_UVBOX_t *const  /*uvbox*/           /* uvbox containing face */
);
/*
This function finds a uvbox which bounds the given face in the parameter space
of the face's surface.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_outer_loop
(
/* received */
PK_FACE_t                           /*face*/,        /* face to find outer loop */
const PK_FACE_find_outer_loop_o_t * /*options*/,     /* provided options */
/* returned */
PK_LOOP_t *const                    /*outer_loop*/   /* the outer loop returned */
);
/*
The function returns the outer loop of the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_interior_vec
(
/* received */
PK_FACE_t                               /*face*/,         /* face to find interior */
const PK_FACE_find_interior_vec_o_t   * /*options*/,      /* options structure */
/* returned */
PK_VECTOR_t *const                      /*int_vec*/,      /* vector interior to face */
PK_UV_t *const                          /*uv_params*/     /* surface parameters */
);
/*
The function returns an arbitrary vector interior to the given face, and the
surface u- and v-parameters of the vector. The returned vector will always lie
in the interior of the given face, never on its boundary edges or vertices.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_hollow
(
/* received */
int                  /*n_faces*/,            /* number of faces */
PK_FACE_t            /*faces*/[],            /* faces to hollow */
double               /*offsets*/[],          /* offset distance for each face */
double               /*tolerance*/,          /* tolerance */
PK_LOGICAL_t         /*face_face_check*/,    /* do face face checks */
/* returned */
PK_FACE_t    *const  /*new_faces*/           /* new faces */
);
/*
This function hollows a solid body by offsetting the given `faces' by the
given `offsets'.

NOTE: this function is obsolete and has been superseded by PK_FACE_hollow_2.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_hollow_2
(
/* received */
int                  /*n_faces*/,            /* number of faces */
PK_FACE_t            /*faces*/[],            /* faces to hollow */
double               /*offsets*/[],          /* offset distance for each face */
double               /*tolerance*/,          /* tolerance */
PK_LOGICAL_t         /*face_face_check*/,    /* do face face checks */
/* returned */
int          *const  /*n_new_faces*/,
PK_FACE_t   **const  /*old_faces*/,          /* old faces ( optional ) */
PK_FACE_t   **const  /*new_faces*/           /* new faces ( optional ) */
);
/*
This function hollows a solid body by offsetting the given `faces' by the
given `offsets'.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_hollow_3
(
/* received */
int                        /*n_faces*/,          /* number of faces */
PK_FACE_t                  /*faces*/[],          /* faces to hollow */
double                     /*offsets*/[],        /* offset distance for each face */
double                     /*tolerance*/,        /* tolerance */

const PK_FACE_hollow_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/           /* status information */
);
/*
This function hollows a solid body by offsetting the given `faces' by the
given `offsets'.

NOTE : This function supersedes PK_FACE_hollow_2.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_identify_blends_r_f
(
/* received */
PK_FACE_identify_blends_r_t *const  /*blend_returns*/
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_identify_blends
(
/* received */
int                                 /*n_faces*/,      /* number of faces */
const PK_FACE_t                     /*faces*/[],      /* faces */
const PK_blend_identify_t           /*ident_type*/,   /* type of blend to identify */
const PK_FACE_identify_blends_o_t * /*options*/,      /* options */
/* returned */
PK_FACE_identify_blends_r_t *const  /*results*/       /* results */
);
/*
Given an array of `faces' (all belonging to the same body) and the type of
blends that should be identified this function will return all constant radius
rolling ball blends of the required `ident_type' which satisfy the `options'
specified.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_blend_unders_r_f
(
/* received */
PK_FACE_find_blend_unders_r_t *const  /*under_returns*/
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_find_blend_unders
(
/* received */
PK_FACE_t                             /*face*/,         /* the face */
const PK_FACE_find_blend_unders_o_t * /*options*/,      /* options */
/* returned */
PK_FACE_find_blend_unders_r_t *const  /*results*/       /* results */
);
/*
Given a constant radius blended face this function will return all underlying
faces associated with the blend face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_curve
(
/* received */
PK_FACE_t          /*face*/,              /* face */
PK_CURVE_t         /*curve*/,             /* curve */
PK_INTERVAL_t      /*bounds*/,            /* bounds of curve */
/* returned */
int        *const  /*n_new_edges*/,       /* number of new edges */
PK_EDGE_t **const  /*new_edges*/,         /* new edges (optional) */
int        *const  /*n_new_faces*/,       /* number of new faces */
PK_FACE_t **const  /*new_faces*/          /* new faces (optional) */
);
/*
This function imprints a curve onto a face, thereby creating a new edge or
edges.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_faces
(
/* received */
int                         /*n_targets*/,    /* number of target faces */
const PK_FACE_t             /*targets*/[],    /* target faces */
int                         /*n_tools*/,      /* number of tool faces */
const PK_FACE_t             /*tools*/[],      /* tool faces */
const PK_FACE_imprint_o_t * /*options*/,      /* imprint options */
/* returned */
PK_imprint_r_t      *const  /*results*/       /* imprint results */
);
/*
This function imprints edges on the given target and tool faces.


NOTE: This function is deprecated and has been superseded by
PK_FACE_imprint_faces_2.

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_faces_2
(
/* received */
int                               /*n_targets*/,    /* number of target faces */
const PK_FACE_t                   /*targets*/[],    /* target faces */
int                               /*n_tools*/,      /* number of tool faces */
const PK_FACE_t                   /*tools*/[],      /* tool faces */
const PK_FACE_imprint_faces_o_t * /*options*/,      /* imprint options */
/* returned */
PK_imprint_r_t            *const  /*results*/,      /* imprint results */
PK_TOPOL_track_r_t        *const  /*tracking*/      /* imprint tracking */
);
/*
This function imprints edges on the given target and tool faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_cus_normal
(
/* received */
int                                    /*n_targets*/,      /* number of faces */
const PK_FACE_t                        /*targets*/[],      /* array of faces */
int                                    /*n_curves*/,       /* number of curves */
const PK_CURVE_t                       /*curves*/[],       /* curves */
PK_INTERVAL_t                          /*intervals*/[],    /* parametric intervals */
double                                 /*tol*/,            /* tolerance */
const PK_FACE_imprint_cus_normal_o_t * /*options*/,        /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/        /* tracking information */
);
/*
This function imprints the given array of curves on the given array of faces
( of the same body) by projecting them locally down the respective face
normals.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_cus_vector
(
/* received */
int                                    /*n_targets*/,    /* number of faces */
const PK_FACE_t                        /*targets*/[],    /* array of faces */
int                                    /*n_curves*/,     /* number of curves */
const PK_CURVE_t                       /*curves*/[],     /* curves */
PK_INTERVAL_t                          /*intervals*/[],  /* parametric intervals */
PK_VECTOR_t                            /*direction*/,    /* direction to project */
double                                 /*tol*/,          /* tolerance */
const PK_FACE_imprint_cus_vector_o_t * /*options*/,      /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/      /* tracking information */
);
/*
This function imprints the given array of curves on the given array of faces
( of the same body ) by projecting them locally along the given vector
direction.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_cus_vec
(
/* received */
int                                    /*n_targets*/,    /* number of faces */
const PK_FACE_t                        /*targets*/[],    /* array of faces */
int                                    /*n_curves*/,     /* number of curves */
const PK_CURVE_t                       /*curves*/[],     /* curves */
PK_INTERVAL_t                          /*intervals*/[],  /* parametric intervals */
double                                 /*tol*/,          /* tolerance */
PK_VECTOR_t                            /*direction*/,    /* direction to project */
const PK_FACE_imprint_cus_vec_o_t    * /*options*/,      /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/      /* tracking information */
);
/*
This function imprints the given array of curves on the given array of faces
by projecting them locally along the given vector direction. The faces must
all belong to the same body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_point
(
/* received */
PK_FACE_t           /*face*/,         /* face */
PK_POINT_t          /*point*/,        /* point to imprint onto face */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/    /* new vertex */
);
/*
This function imprints a point onto a face, thereby creating a new vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_inst_tools_r_f
(
/* received */
PK_FACE_inst_tools_r_t *const  /*results*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_instance_tools
(
/* received */
int                            /*n_target_faces*/,  /* number of target faces (>0) */
const PK_FACE_t                /*target_faces*/[],  /* target faces */
int                            /*n_tool_faces*/,    /* number of tool faces (>0) */
const PK_FACE_t                /*tool_faces*/[],    /* tool faces to be instanced */
int                            /*n_transforms*/,    /* number of transforms (>0) */
const PK_TRANSF_t              /*transforms*/[],    /* instancing transforms */
const PK_FACE_boolean_o_t    * /*options*/,
/* returned */
PK_FACE_inst_tools_r_t *const  /*optional_returns*/
);
/*
This function instances (creates and then booleans transformed copies of...)
a single tool body with a single target body, the boolean operation being a
unite or subtract. The tool and target body are each identified by a subset of
their faces, the subset being those faces which clash with the other body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_instance_bodies
(
/* received */
int                                 /*n_target_faces*/,  /* number of target faces */
const PK_FACE_t                     /*target_faces*/[],  /* target faces */
int                                 /*n_tool_bodies*/,   /* number of tool bodies */
const PK_BODY_t                     /*tool_bodies*/[],   /* tool bodies to be */
const PK_TRANSF_array_t             /*transforms*/[],    /* instancing transforms */
const PK_FACE_instance_bodies_o_t * /*options*/,
/* returned */
PK_TOPOL_track_r_t          *const  /*instance_tracking*/,
PK_TOPOL_track_r_t          *const  /*tracking*/         /* tracking records */
);
/*

This function instances (creates and then booleans transformed copies of...)
tool bodies with a single target body.

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_intersect_curve
(
/* received */
PK_FACE_t                  /*face*/,            /* face */
PK_CURVE_t                 /*curve*/,           /* curve */
PK_INTERVAL_t              /*bounds*/,          /* bounds of curve */
/* returned */
int                *const  /*n_vectors*/,       /* number of intersections */
PK_VECTOR_t       **const  /*vectors*/,         /* positions of intersections */
PK_UV_t           **const  /*uvs*/,             /* parameters on face's surface */
double            **const  /*ts*/,              /* parameters on curve */
PK_TOPOL_t        **const  /*topols*/,          /* topological entities intersected */
PK_intersect_fc_t **const  /*types*/            /* types of intersections */
);
/*
PK_FACE_intersect_curve finds the intersections between a face and the
specified region of a curve.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_intersect_face
(
/* received */
PK_FACE_t                          /*face_1*/,      /* first face */
PK_FACE_t                          /*face_2*/,      /* second face */
const PK_FACE_intersect_face_o_t * /*options*/,     /* options structure */
/* returned */
int                        *const  /*n_vectors*/,   /* number of point intersections */
PK_VECTOR_t               **const  /*vectors*/,     /* posns of point intersections */
int                        *const  /*n_curves*/,    /* number of intersection curves */
PK_CURVE_t                **const  /*curves*/,      /* intersection curves */
PK_INTERVAL_t             **const  /*bounds*/,      /* bounds of curves */
PK_intersect_curve_t      **const  /*types*/        /* types of intersections */
);
/*
PK_FACE_intersect_face finds the intersections between two faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_intersect_surf
(
/* received */
PK_FACE_t                          /*face*/,        /* face */
PK_SURF_t                          /*surf*/,        /* surface */
const PK_FACE_intersect_surf_o_t * /*options*/,     /* options structure */
/* returned */
int                        *const  /*n_vectors*/,   /* number of point intersections */
PK_VECTOR_t               **const  /*vectors*/,     /* posns of point intersections */
int                        *const  /*n_curves*/,    /* number of intersection curves */
PK_CURVE_t                **const  /*curves*/,      /* intersection curves */
PK_INTERVAL_t             **const  /*bounds*/,      /* bounds of curves */
PK_intersect_curve_t      **const  /*types*/        /* types of intersections */
);
/*
PK_FACE_intersect_surf finds the intersections between a face and a surface.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_is_coincident
(
/* received */
PK_FACE_t                         /*face1*/,          /* first face */
PK_FACE_t                         /*face2*/,          /* second face */
double                            /*tol*/,            /* distance tolerance */
const PK_FACE_is_coincident_o_t * /*options*/,        /* option structure */
/* returned */
PK_FACE_coi_t             *const  /*result*/,         /* coincidence information */
PK_VECTOR_t               *const  /*point*/           /* non-coincidence point */
);
/*
This function checks if two faces, possibly under transformation,  are
coincident to tolerance.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_3_face_blend_r_f
(
/* received */
PK_FACE_make_3_face_blend_r_t *const  /*results*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_3_face_blend
(
/* received */
int                                   /*n_left_wall_faces*/,    /* number of faces */
const PK_FACE_t                       /*left_wall_faces*/[],    /* left wall faces */
int                                   /*n_right_wall_faces*/,   /* number of faces */
const PK_FACE_t                       /*right_wall_faces*/[],   /* right wall faces */
int                                   /*n_centre_wall_faces*/,  /* number of faces */
const PK_FACE_t                       /*centre_wall_faces*/[],  /* centre wall faces */
PK_BODY_t                             /*guide*/,                /* wire body for */
const PK_FACE_make_3_face_blend_o_t * /*options*/,              /* options structure */
/* returned */
PK_FACE_make_3_face_blend_r_t *const  /*results*/,              /* results of blend */
PK_TOPOL_track_r_t            *const  /*tracking*/              /* tracking */
);
/*
This function makes a three-face blend from the given faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_blend
(
/* received */
int                             /*n_left_wall_faces*/,    /* number of faces in */
const PK_FACE_t                 /*left_wall_faces*/[],    /* faces in left wall */
int                             /*n_right_wall_faces*/,   /* number of faces in */
const PK_FACE_t                 /*right_wall_faces*/[],   /* faces in right wall */
PK_LOGICAL_t                    /*left_sense*/,           /* blend direction */
PK_LOGICAL_t                    /*right_sense*/,          /* blend direction */
const PK_FACE_make_blend_o_t  * /*options*/,              /* options structure */
/* returned */
int                     *const  /*n_sheet_bodies*/,       /* number of sheet bodies */
PK_BODY_t              **const  /*sheet_bodies*/,         /* sheet bodies */
int                     *const  /*n_blend_topols*/,       /* number of blend */
PK_TOPOL_t             **const  /*blend_topols*/,         /* blend topologies */
PK_TOPOL_array_t       **const  /*unders*/,               /* originating topology */
PK_blend_rib_r_t        *const  /*ribs*/,                 /* ribs returned (if any) */
PK_fxf_error_t          *const  /*fault*/                 /* fault found (if any) */
);
/*
This function makes a blend of the given faces.
*/

PK_linkage_m PK_ERROR_code_t PK_blend_rib_r_f
(
/* received */
PK_blend_rib_r_t *const  /*ribs*/
);
/*
Frees the memory associated with the blend_rib return structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_install_surfs_isocline
(
/* received */
int                /*n_faces*/,           /* number of target faces (>0) */
const PK_FACE_t    /*faces*/[],           /* faces to be drafted */
const PK_ENTITY_t  /*references*/[],      /* reference entities */
PK_VECTOR1_t       /*direction*/,         /* isocline direction */
double             /*angle*/,             /* isocline angle */
double             /*tolerance*/,         /* max tol for applying surfs */
PK_LOGICAL_t       /*face_face_check*/    /* do face face checks */
);
/*
This function replaces the surfaces of given faces with isocline surfaces.
It has been superseded by PK_FACE_taper.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_curves_isocline
(
/* received */
int                   /*n_rec_faces*/,    /* number of received faces (>0) */
const PK_FACE_t       /*rec_faces*/[],    /* received faces */
PK_VECTOR1_t          /*direction*/,      /* isocline direction */
double                /*angle*/,          /* isocline angle */
double                /*tolerance*/,      /* max tol for applying surfs */
/* returned */
int           *const  /*n_ret_faces*/,    /* number of returned faces (>=0) */
PK_FACE_t    **const  /*ret_faces*/,      /* returned faces           (optional) */
PK_LOGICAL_t **const  /*is_steep*/,       /* whether faces are steep  (optional) */
int           *const  /*n_edges*/,        /* number of new edges      (>=0) */
PK_EDGE_t    **const  /*edges*/           /* new edges                (optional) */
);
/*
This function creates and imprints isocline curves on a given set of faces.

NOTE: This function is obsolete and has been superseded
by PK_FACE_imprint_cus_isoclin

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_imprint_cus_isoclin
(
/* received */
int                                     /*n_rec_faces*/, /* number of received faces */
const PK_FACE_t                         /*rec_faces*/[], /* received faces */
PK_VECTOR1_t                            /*direction*/,   /* isocline direction */
double                                  /*angle*/,       /* isocline angle */
double                                  /*tolerance*/,   /* max tol for applying */
const PK_FACE_imprint_cus_isoclin_o_t * /*options*/,     /* options structure */
/* returned */
int                             *const  /*n_ret_faces*/, /* number of returned faces */
PK_FACE_t                      **const  /*ret_faces*/,   /* returned faces */
PK_LOGICAL_t                   **const  /*is_steep*/,    /* whether faces are steep */
int                             *const  /*n_edges*/,     /* number of new edges */
PK_EDGE_t                      **const  /*edges*/        /* new edges */
);
/*
This function creates and imprints isocline curves on a given set of faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_taper
(
/* received */
int                        /*n_faces*/,         /* number of target faces (>0) */
const PK_FACE_t            /*faces*/[],         /* faces to be drafted */
const PK_ENTITY_t          /*references*/[],    /* reference entities */
PK_VECTOR1_t               /*direction*/,       /* taper direction */
double                     /*angle*/,           /* taper angle */
double                     /*tolerance*/,       /* max. tol. for applying surfaces */
const PK_FACE_taper_o_t  * /*options*/,         /* options */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,        /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/          /* status information */
);
/*
This function applies tapering to the given `faces' by replacing their
geometry with taper surfaces.

NOTE : This function supersedes PK_FACE_install_surfs_isocline.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_offset
(
/* received */
int                  /*n_faces*/,            /* number of faces > 0 */
const PK_FACE_t      /*faces*/[],            /* faces to offset */
const double         /*offsets*/[],          /* offset for each face */
double               /*tolerance*/,          /* tolerance */
PK_LOGICAL_t         /*face_face_check*/     /* do face face checks */
/* returned */
);
/*
Offsets faces of a solid or sheet body
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_offset_2
(
/* received */
int                        /*n_faces*/,          /* number of faces > 0 */
const PK_FACE_t            /*faces*/[],          /* faces to offset */
const double               /*offsets*/[],        /* offset for each face */
double                     /*tolerance*/,        /* tolerance */
const PK_FACE_offset_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/           /* status information */
);
/*
This function offsets faces of a solid or sheet body.

NOTE : This function supersedes PK_FACE_offset.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_output_surf_trimmed
(
/* received */
PK_FACE_t                               /*face*/,          /* face */
const PK_FACE_output_surf_trimmed_o_t * /*options*/,       /* options structure */
/* returned */
PK_SURF_t                       *const  /*surf*/,          /* surface */
PK_LOGICAL_t                    *const  /*sense*/,         /* which side of surface */
PK_SURF_trim_data_t             *const  /*trim_data*/,     /* trim data */
PK_GEOM_t                      **const  /*geoms*/,         /* points and curves */
PK_INTERVAL_t                  **const  /*intervals*/,     /* geom intervals */
PK_TOPOL_t                     **const  /*topols*/         /* topologies */
);
/*
This function returns a trimmed surface representation of the given face.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_pattern
(
/* received */
int                         /*n_pattern_faces*/,   /* number of pattern faces (>0) */
const PK_FACE_t             /*pattern_faces*/[],   /* pattern faces */
int                         /*n_transforms*/,      /* number of transforms (>0) */
const PK_TRANSF_t           /*transforms*/[],      /* pattern transformations */
const PK_FACE_pattern_o_t * /*options*/,           /* pattern options */
/* returned */
PK_FACE_pattern_r_t *const  /*pattern_results*/    /* status and tracking info */
);
/*
This function creates a pattern of a feature on the target body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_pattern_r_f
(
/* received */
PK_FACE_pattern_r_t *const  /*pattern_results*/    /* status and tracking info */
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_remove_to_solid_bodies
(
/* received */
int                       /*n_faces*/,              /* number of faces */
const PK_FACE_t           /*faces*/[],              /* faces */
PK_FACE_heal_t            /*parent_heal_action*/,   /* method for healing wounds */
PK_FACE_heal_t            /*child_heal_action*/,    /* method for healing wounds */
PK_LOGICAL_t              /*local_check*/,          /* whether to do local check */
/* returned */
int               *const  /*n_parent_bodies*/,      /* number of parent bpdies */
PK_BODY_t        **const  /*parent_bodies*/,        /* parent bodies */
PK_local_check_t **const  /*parent_check_results*/, /* results of local check */
int               *const  /*n_child_bodies*/,       /* number of child bodies */
PK_BODY_t        **const  /*child_bodies*/,         /* child bodies */
PK_local_check_t **const  /*child_check_results*/   /* results of local check */
);
/*
This function separates a body into two or more bodies by selecting which
faces are to be removed into new bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_replace_surfs
(
/* received */
int                      /*n_faces*/,        /* number of faces */
const PK_FACE_t          /*faces*/[],        /* faces */
const PK_SURF_t          /*surfs*/[],        /* replacement surfaces */
double                   /*tolerance*/,      /* tolerance for replacement geometry */
PK_LOGICAL_t             /*local_check*/,    /* whether to perform local check */
/* returned */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function replaces the geometry of the given faces with the
supplied surfaces.

NOTE: This functions is obsolete and has been superseded by
PK_FACE_replace_surfs_2
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_replace_surfs_2
(
/* received */
int                               /*n_faces*/,         /* number of faces */
const PK_FACE_t                   /*faces*/[],         /* faces */
const PK_SURF_t                   /*surfs*/[],         /* replacement surfaces */
const PK_LOGICAL_t                /*senses*/[],        /* surface orientation */
double                            /*tolerance*/,       /* tolerance for operation */
const PK_FACE_replace_surfs_o_t * /*options*/,         /* options */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/,        /* tracking information */
PK_FACE_replace_surfs_r_t *const  /*results*/          /* status information */
);
/*
This function replaces the geometry of the given faces with the
supplied surfaces.

NOTE: This function supersedes PK_FACE_replace_surfs, which is now obsolete.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_replace_surfs_3
(
/* received */
int                               /*n_faces*/,         /* number of faces */
const PK_FACE_t                   /*faces*/[],         /* faces */
const PK_SURF_t                   /*surfs*/[],         /* replacement surfaces */
const PK_LOGICAL_t                /*senses*/[],        /* surface orientation */
double                            /*tolerance*/,       /* tolerance for operation */
const PK_FACE_replace_surfs_o_t * /*options*/,         /* options */
/* returned */
PK_TOPOL_track_r_t        *const  /*tracking*/,        /* tracking information */
PK_TOPOL_local_r_t        *const  /*results*/          /* status information */
);
/*
This function replaces the geometry of the given faces with the
supplied surfaces.

NOTE: This function supersedes PK_FACE_replace_surfs_2, which is
now obsolete.

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_replace_with_sheet
(
/* received */
int                                    /*n_faces*/,    /* number of faces */
const PK_FACE_t                        /*faces*/[],    /* target faces to replace */
const PK_BODY_t                        /*sheet*/,      /* replacement sheet */
const PK_FACE_replace_with_sheet_o_t * /*options*/,    /* options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/,   /* tracking information */
PK_TOPOL_local_r_t             *const  /*results*/     /* status information */
);
/*
This function replaces a set of faces on a target body with a
set of faces from a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_cover
(
/* received */
int                         /*n_faces*/,         /* number of faces */
const PK_FACE_t             /*faces*/[],         /* target faces to cover */
const PK_FACE_cover_o_t   * /*options*/,         /* options */
/* returned */
PK_ENTITY_track_r_t *const  /*tracking*/         /* tracking information */
);
/*
This function creates a single face covering a set of input faces, which can
then be used to replace the original faces.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_change
(
/* received */
int                           /*n_faces*/,          /* number of faces */
const PK_FACE_t               /*faces*/[],          /* faces to change */
const int                     /*mapping*/[],        /* face-operation mapping */
int                           /*n_operations*/,     /* number of operations */
PK_FACE_change_t              /*operations*/[],     /* change operations to apply */
double                        /*tolerance*/,        /* tolerance */
const PK_FACE_change_o_t    * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t    *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t    *const  /*results*/           /* status information */
);
/*
This function changes the given faces by applying the related given operation
to each of them.
This function combines the features of : PK_FACE_offset_2, PK_FACE_taper,
PK_FACE_transform_2, PK_FACE_replace_surfs_3 and some of PK_FACE_make_blend.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_section_with_sheet
(
/* received */
int                         /*n_targets*/,      /* Number of target faces */
const PK_FACE_t             /*targets*/[],      /* Target faces */
int                         /*n_tools*/,        /* Number of tool faces */
const PK_FACE_t             /*tools*/[],        /* Tool faces */
const PK_FACE_section_o_t * /*options*/,        /* Sectioning options */
/* returned */
PK_section_r_t      *const  /*results*/         /* front/back faces/bodies */
);
/*
This function sections selected regions of the target body with
selected regions of the tool sheet body.

NOTE: This function is obsolete and has been superseded
by PK_FACE_section_with_sheet_2.

*/

PK_linkage_m PK_ERROR_code_t PK_FACE_section_with_sheet_2
(
/* received */
int                             /*n_targets*/,   /* number of target faces */
const PK_FACE_t                 /*targets*/[],   /* target faces */
int                             /*n_tools*/,     /* number of tool faces */
const PK_FACE_t                 /*tools*/[],     /* tool faces */
const PK_FACE_section_o_t     * /*options*/,     /* sectioning options */
/* returned */
PK_TOPOL_track_r_t      *const  /*tracking*/,    /* tracking information */
PK_section_2_r_t        *const  /*results*/      /* front/back faces/bodies */
);
/*
This function sections selected regions of the target body with
selected regions of the tool sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_make_sect_with_sfs
(
/* received */
int                                    /*n_targets*/,  /* Number of target faces */
PK_FACE_t                              /*targets*/[],  /* Target faces */
int                                    /*n_tools*/,    /* Number of tool surfaces */
PK_SURF_t                              /*tools*/[],    /* Tool surfaces */
const PK_FACE_make_sect_with_sfs_o_t * /*options*/,    /* Sectioning options */
/* returned */
PK_TOPOL_track_r_t             *const  /*tracking*/,   /* Tracking information */
PK_FACE_make_sect_with_sfs_r_t *const  /*results*/     /* Resultant bodies */
);
/*
This function sections selected regions of the target body with
tool surfaces. Target body remains unchanged.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_spin
(
/* received */
int                      /*n_faces*/,        /* number of faces */
const PK_FACE_t          /*faces*/[],        /* faces */
const PK_AXIS1_sf_t    * /*axis*/,           /* spin axis */
double                   /*angle*/,          /* spin angle */
PK_LOGICAL_t             /*local_check*/,    /* whether local checking will be done */
/* returned */
int              *const  /*n_laterals*/,     /* number of laterals */
PK_FACE_t       **const  /*laterals*/,       /* new faces (may be NULL) */
PK_EDGE_t       **const  /*bases*/,          /* edges swept into laterals */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function spins one or more faces of a solid or sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_sweep
(
/* received */
int                      /*n_faces*/,        /* number of faces */
const PK_FACE_t          /*faces*/[],        /* faces */
PK_VECTOR_t              /*path*/,           /* translation vector */
PK_LOGICAL_t             /*local_check*/,    /* whether local checking will be done */
/* returned */
int              *const  /*n_laterals*/,     /* number of laterals */
PK_FACE_t       **const  /*laterals*/,       /* new faces (may be NULL) */
PK_EDGE_t       **const  /*bases*/,          /* edges swept into laterals */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function sweeps one or more faces of a solid or sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_transform
(
/* received */
int                      /*n_faces*/,        /* number of faces */
const PK_FACE_t          /*faces*/[],        /* faces */
const PK_TRANSF_t        /*transfs*/[],      /* face transformations */
double                   /*tolerance*/,      /* tolerance for replacement geometry */
PK_LOGICAL_t             /*local_check*/,    /* whether to perform local check */
/* returned */
int              *const  /*n_replaces*/,     /* number of replaced geometry */
PK_GEOM_t       **const  /*replaces*/,       /* replaced geometry (optional) */
PK_LOGICAL_t    **const  /*exact*/,          /* whether replaced geometry is exact */
PK_local_check_t *const  /*check_result*/    /* result of local check */
);
/*
This function transforms the given faces by the given transformations.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_transform_2
(
/* received */
int                           /*n_faces*/,          /* number of faces > 0 */
const PK_FACE_t               /*faces*/[],          /* faces to transform */
const PK_TRANSF_t             /*transfs*/[],        /* face transformations */
double                        /*tolerance*/,        /* tolerance */

const PK_FACE_transform_o_t * /*options*/,          /* options */
/* returned */
PK_TOPOL_track_r_t    *const  /*tracking*/,         /* tracking information */
PK_TOPOL_local_r_t    *const  /*results*/           /* status information */
);
/*
This function transforms the given faces by the given transformations.

NOTE : This function supersedes PK_FACE_transform.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_classify_details_r_f
(
/* received */
PK_FACE_classify_details_r_t *const  /*results*/
);
/*
This function frees the PK memory referenced by the structure.
*/

PK_linkage_m PK_ERROR_code_t PK_FACE_classify_details
(
/* received */
int                                  /*n_facesets*/,   /* number of facesets */
PK_FACE_array_t                      /*facesets*/[],   /* facesets */
PK_detail_t                          /*details*/[],    /* details */
const PK_FACE_classify_details_o_t * /*options*/,      /* options structure */
/* returned */
PK_FACE_classify_details_r_t *const  /*results*/       /* results */
);
/*
This function classifies the given faceset as details of some type.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_body
(
/* received */
PK_LOOP_t         /*loop*/,               /* a loop */
/* returned */
PK_BODY_t *const  /*body*/                /* owning body */
);
/*
This function returns the body containing the given loop.

If the loop is contained within a compound body ( see PK_BODY_ask_config ) then
the child body to which the loop belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_edges
(
/* received */
PK_LOOP_t          /*loop*/,              /* a loop */
/* returned */
int        *const  /*n_edges*/,           /* number of edges (>= 0) */
PK_EDGE_t **const  /*edges*/              /* edges (optional) */
);
/*
This function returns a set of edges in the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_face
(
/* received */
PK_LOOP_t         /*loop*/,               /* a loop */
/* returned */
PK_FACE_t *const  /*face*/                /* owning face */
);
/*
This function returns the face containing the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_fins
(
/* received */
PK_LOOP_t         /*loop*/,               /* a loop */
/* returned */
int       *const  /*n_fins*/,             /* number of fins (>= 0) */
PK_FIN_t **const  /*fins*/                /* fins (optional) */
);
/*
This function returns an ordered list of fins around the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_first_fin
(
/* received */
PK_LOOP_t        /*loop*/,         /* a loop */
/* returned */
PK_FIN_t *const  /*first_fin*/     /* the first fin (possibly PK_ENTITY_null) */
);
/*
This function returns the first fin in the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_next_in_face
(
/* received */
PK_LOOP_t         /*loop*/,              /* a loop */
/* returned */
PK_LOOP_t *const  /*next*/               /* the next loop (possibly PK_ENTITY_null) */
);
/*
This function returns the next loop in the face containing the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_type
(
/* received */
PK_LOOP_t              /*loop*/,       /* the loop */
/* returned */
PK_LOOP_type_t *const  /*loop_type*/  /* the type of the loop */
);
/*
This function classifies the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_ask_vertices
(
/* received */
PK_LOOP_t            /*loop*/,               /* a loop */
/* returned */
int          *const  /*n_vertices*/,         /* number of vertices (>= 0) */
PK_VERTEX_t **const  /*vertices*/            /* vertices (optional) */
);
/*
This function returns an ordered list of vertices around the given loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_is_isolated
(
/* received */
PK_LOOP_t            /*loop*/,        /* a loop */
/* returned */
PK_LOGICAL_t *const  /*is_isolated*/  /* whether loop is isolated or not */
);
/*
This function returns whether the given loop is isolated.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_close_gaps
(
/* received */
PK_LOOP_t                      /*loop*/,        /* loop */
const PK_LOOP_close_gaps_o_t * /*options*/,     /* options on how to close loops */
/* returned */
int                    *const  /*n_vertices*/,  /* number of vertices where gaps */
PK_VERTEX_t           **const  /*vertices*/     /* vertices where gaps remain */
);
/*
This function closes gaps at tolerant vertices in the loop by modifying the
edge/fin geometry. Where gaps cannot be closed the vertices at those gaps will
be returned.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_delete_from_sheet_body
(
/* received */
int              /*n_loops*/,    /* number of loops to be deleted */
const PK_LOOP_t  /*loops*/[]     /* loops to be deleted */
);
/*
This function deletes interior loops from a sheet body.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_transfer
(
/* received */
PK_LOOP_t        /*loop*/,     /* loop to transfer */
PK_FACE_t        /*face*/      /* destination face */
);
/*
This function transfers a loop from one face to another.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_make_edge_face
(
/* received */
PK_LOOP_t         /*loop*/,       /* Loop of face */
PK_FIN_t          /*fin1*/,       /* Fin at first vertex to join */
PK_FIN_t          /*fin2*/,       /* Fin at second vertex to join */
/* returned */
PK_FACE_t *const  /*new_face*/,   /* New face created */
PK_EDGE_t *const  /*new_edge*/    /* New edge created */
);
/*
This function joins two vertices in the same loop, creating a new face.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_make_edge_loop
(
/* received */
PK_LOOP_t         /*loop*/,       /* Loop of face */
PK_FIN_t          /*fin1*/,       /* Fin at first vertex to join */
PK_FIN_t          /*fin2*/,       /* Fin at second vertex to join */
/* returned */
PK_LOOP_t *const  /*new_loop*/    /* New loop created */
);
/*
This function joins two vertices in the same loop of a face, creating a new
loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_delete_make_edge
(
/* received */
PK_LOOP_t         /*loop1*/,  /* Loop of fin1 */
PK_FIN_t          /*fin1*/,   /* Fin at first vertex to join */
PK_LOOP_t         /*loop2*/,  /* Loop of fin2 */
PK_FIN_t          /*fin2*/,   /* Fin at second vertex to join */
/* returned */
PK_EDGE_t *const  /*new_edge*/
);
/*
This function merges two loops in the same face into one by joining their
vertices with an edge.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_make_edge
(
/* received */
PK_LOOP_t           /*loop*/,         /* Loop in which to create the edge */
PK_FIN_t            /*fin*/,          /* Fin to create edge at */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/,   /* New vertex created */
PK_EDGE_t   *const  /*new_edge*/      /* New edge created */
);
/*
This function adds a new edge to a loop.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_create_edge
(
/* received */
PK_LOOP_t           /*loop*/,         /* Loop in which to create the edge */
PK_FIN_t            /*fin*/,          /* Fin to create edge at */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/,   /* New vertex created */
PK_EDGE_t   *const  /*new_edge*/      /* New edge created */
);
/*
This function is obsolete.

See documentation for PK_LOOP_euler_make_edge
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_euler_delete_isolated
(
/* received */
PK_LOOP_t        /*loop*/     /* Loop to delete */
);
/*
This function deletes an isolated vertex and loop from a face.
*/

PK_linkage_m PK_ERROR_code_t PK_LOOP_offset_planar
(
/* received */
PK_LOOP_t                         /*planar_loop*/,    /* input planar loop */
double                            /*offset*/,         /* input offset distance */
const PK_LOOP_offset_planar_o_t * /*options*/,        /* options structure */
/* returned */
int                       *const  /*n_new_loops*/,    /* number of new loops */
PK_LOOP_t                **const  /*new_loops*/,      /* array of new loops */
PK_TOPOL_track_r_t        *const  /*track_records*/   /* array of track records */
);
/*
This function offsets an input loop of a planar face by a specified distance.
Edges of the new offset loop/loops are paired with their originating edges or
vertices of the input loop. These corresponding new and old topologies are
returned in the form of PK topology track records.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_body
(
/* received */
PK_FIN_t          /*fin*/,                /* a fin */
/* returned */
PK_BODY_t *const  /*body*/                /* owning body */
);
/*
This function returns the body of the given fin.

If the fin is contained within a compound body ( see PK_BODY_ask_config ) then
the child body to which the fin belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_loop
(
/* received */
PK_FIN_t          /*fin*/,                /* a fin */
/* returned */
PK_LOOP_t *const  /*loop*/                /* owning loop */
);
/*
This function returns the loop of the given fin.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_face
(
/* received */
PK_FIN_t          /*fin*/,                /* a fin */
/* returned */
PK_FACE_t *const  /*face*/                /* owning face */
);
/*
This function returns the face of the given fin.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_edge
(
/* received */
PK_FIN_t          /*fin*/,                /* a fin */
/* returned */
PK_EDGE_t *const  /*edge*/                /* owning edge */
);
/*
This function returns the edge of the given fin.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_next_in_loop
(
/* received */
PK_FIN_t         /*fin*/,                /* a fin */
/* returned */
PK_FIN_t *const  /*next*/                /* the next fin around the loop */
);
/*
This function returns the next fin in order around the given fin's loop.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_previous_in_loop
(
/* received */
PK_FIN_t         /*fin*/,                /* a fin */
/* returned */
PK_FIN_t *const  /*previous*/            /* the previous fin around the loop */
);
/*
This function returns the previous fin in order around the given fin's loop.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_next_of_edge
(
/* received */
PK_FIN_t         /*fin*/,                /* a fin */
/* returned */
PK_FIN_t *const  /*next*/                /* the next fin around the edge */
);
/*
This function returns the next fin in order around the given fin's edge.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_previous_of_edge
(
/* received */
PK_FIN_t         /*fin*/,                /* a fin */
/* returned */
PK_FIN_t *const  /*previous*/            /* the previous fin around the edge */
);
/*
This function returns the previous fin in order around the given fin's edge.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_type
(
/* received */
PK_FIN_t              /*fin*/,        /* a fin */
/* returned */
PK_FIN_type_t *const  /*fin_type*/    /* the type of the fin */
);
/*
This function classifies the given fin according to the relationship
between its edge and its face.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_oriented_curve
(
/* received */
PK_FIN_t             /*fin*/,           /* a fin */
/* returned */
PK_CURVE_t   *const  /*curve*/,         /* the curve (possibly PK_ENTITY_null) */
PK_LOGICAL_t *const  /*orientation*/    /* the fin orientation with respect to its */
);
/*
This function returns the curve and orientation of the given fin, if any.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_curve
(
/* received */
PK_FIN_t           /*fin*/,               /* a fin */

/* returned */
PK_CURVE_t *const  /*curve*/              /* its curve (possibly PK_ENTITY_null) */
);
/*
This function returns the curve attached to the given fin, if there is one,
otherwise PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_ask_geometry
(
/* received */
PK_FIN_t              /*fin*/,            /* fin for which geometry is required */
PK_LOGICAL_t          /*want_interval*/,  /* whether parametric interval required */
/* returned */
PK_CURVE_t    *const  /*curve*/,          /* curve of fin (may be PK_ENTITY_null) */
PK_CLASS_t    *const  /*class*/,          /* class of curve */
PK_VECTOR_t           /*ends*/[2],        /* positions at ends of fin */
PK_INTERVAL_t *const  /*t_int*/,          /* parametric interval of fin */
PK_LOGICAL_t  *const  /*sense*/           /* whether curve in same direction as fin */
);
/*
This function returns the geometry of a fin
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_attach_curves
(
/* received */
int                  /*n_fins*/,        /* number of fins */
const PK_FIN_t       /*fins*/[],        /* fins to have curves attached */
const PK_CURVE_t     /*curves*/[],      /* curves to be attached to fins */
const PK_INTERVAL_t  /*intervals*/[]    /* parametric bounds of each curve */
/* returned */
);
/*
This function attaches curves to fins.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_find_curve_parameter
(
/* received */
PK_FIN_t         /*fin*/,         /* fin */
PK_UV_t          /*parms*/,       /* u,v parameters of surface attached to `fin' */
PK_LOGICAL_t     /*estimate*/,    /* whether `t_est' is supplied */
double           /*t_est*/,       /* estimate of parameter point `t' */
/* returned */
double   *const  /*t*/            /* t parameter on curve attached to `fin' */
);
/*
This function computes the fin curve parameter corresponding to the given
surface parameters.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_find_surf_parameters
(
/* received */
PK_FIN_t         /*fin*/,           /* fin */
double           /*t*/,             /* t parameter on curve attached to `fin' */
PK_LOGICAL_t     /*estimate*/,      /* whether `parms_est' is supplied */
PK_UV_t          /*parms_est*/,     /* estimate of u,v parameters */
/* returned */
PK_UV_t  *const  /*parms*/          /* u,v parameters on surface attached to `fin' */
);
/*
This function computes fin surface parameters corresponding to the given
curve parameter.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_find_interval
(
/* received */
PK_FIN_t              /*fin*/,            /* fin */
/* returned */
PK_INTERVAL_t *const  /*t_int*/           /* interval */
);
/*
This function computes the parameter interval of the curve, to which the fin
corresponds.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_find_uvbox
(
/* received */
PK_FIN_t          /*fin*/,           /* fin for which uvbox required */
/* returned */
PK_UVBOX_t *const  /*uvbox*/         /* uvbox containing fin */
);
/*
This function finds a uvbox which bounds the given fin in the parameter space
of the fin's owning face's surface.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_is_positive
(
/* received */
PK_FIN_t             /*fin*/,         /* a fin */
/* returned */
PK_LOGICAL_t *const  /*is_positive*/  /* whether fin is positive or negative */
);
/*
This function returns whether the given fin goes in the same direction as
its owning edge.
*/

PK_linkage_m PK_ERROR_code_t PK_FIN_euler_glue
(
/* received */
int              /*n_fins*/,      /* number of fins */
const PK_FIN_t   /*fins*/[],      /* fins to glue */
PK_LOGICAL_t     /*same_dir*/     /* orientation of fins belonging to second edge */
);
/*
This function glues fins from two edges in the order indicated so that in the
result the fins all belong to one edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_blend
(
/* received */
PK_EDGE_t                      /*edge*/,            /* an edge */
/* returned */
PK_blend_type_t        *const  /*type*/,            /* type of blend */
PK_FACE_t              *const  /*left_face*/,       /* face to left of edge */
PK_FACE_t              *const  /*right_face*/,      /* face to right of edge */
PK_blend_edge_shape_t  *const  /*edge_shape*/,      /* shape of blend */
PK_blend_properties_t  *const  /*properties*/,      /* blend properties */
PK_EDGE_t              *const  /*cliff_edge*/       /* cliff edge */
);
/*
This function returns information about the blend on a given edge if any.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_body
(
/* received */
PK_EDGE_t         /*edge*/,               /* an edge */
/* returned */
PK_BODY_t *const  /*body*/                /* owning body */
);
/*
This function returns the body which contains the given edge.

If the edge is contained within a compound body ( see PK_BODY_ask_config ) then
the child body to which the edge belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_curve
(
/* received */
PK_EDGE_t          /*edge*/,              /* an edge */
/* returned */
PK_CURVE_t *const  /*curve*/              /* its curve (possibly PK_ENTITY_null) */
);
/*
This function returns the curve of the given edge, if it has one, otherwise
PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_curve_nmnl
(
/* received */
PK_EDGE_t          /*edge*/,              /* an edge */
/* returned */
PK_CURVE_t *const  /*curve*/              /* its curve (possibly PK_ENTITY_null) */
);
/*
This function returns the nominal curve of the given `edge', if it has one,
otherwise PK_ENTITY_null.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_faces
(
/* received */
PK_EDGE_t          /*edge*/,               /* an edge */
/* returned */
int        *const  /*n_faces*/,            /* number of faces (>= 0) */
PK_FACE_t **const  /*faces*/               /* faces (optional) */
);
/*
This function returns the set of faces which contain the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_fins
(
/* received */
PK_EDGE_t         /*edge*/,               /* an edge */
/* returned */
int       *const  /*n_fins*/,             /* number of fins (>= 0) */
PK_FIN_t **const  /*fins*/                /* fins (optional) */
);
/*
This function returns an ordered list of fins connected to the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_first_fin
(
/* received */
PK_EDGE_t        /*edge*/,               /* an edge */
/* returned */
PK_FIN_t *const  /*first_fin*/           /* the first fin (possibly PK_ENTITY_null) */
);
/*
This function returns the first fin belonging to the given edge.

If the edge is wireframe and so has no fins, then PK_ENTITY_null will be
returned.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_geometry
(
/* received */
PK_EDGE_t             /*edge*/,           /* edge for which geometry is required */
PK_LOGICAL_t          /*want_interval*/,  /* whether parametric interval required */
/* returned */
PK_CURVE_t    *const  /*curve*/,          /* curve of edge (may be PK_ENTITY_null) */
PK_CLASS_t    *const  /*class*/,          /* class of curve */
PK_VECTOR_t           /*ends*/[2],        /* positions at ends of edge */
PK_INTERVAL_t *const  /*t_int*/,          /* parametric interval of edge */
PK_LOGICAL_t  *const  /*sense*/           /* whether curve in same direction as edge */
);
/*
This function returns the geometry of an edge
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_geometry_nmnl
(
/* received */
PK_EDGE_t             /*edge*/,           /* edge for which geometry is required */
PK_LOGICAL_t          /*want_interval*/,  /* whether parametric interval required */
/* returned */
PK_CURVE_t    *const  /*curve*/,          /* curve of edge (may be PK_ENTITY_null) */
PK_CLASS_t    *const  /*class*/,          /* class of curve */
PK_VECTOR_t           /*ends*/[2],        /* positions at ends of edge */
PK_INTERVAL_t *const  /*t_int*/,          /* parametric interval of edge */
PK_LOGICAL_t  *const  /*sense*/           /* whether curve in same direction as edge */
);
/*
This function returns the nominal geometry of an edge, if present.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_next_in_body
(
/* received */
PK_EDGE_t         /*edge*/,           /* an edge */
/* returned */
PK_EDGE_t *const  /*next*/            /* the next edge (possibly PK_ENTITY_null) */
);
/*
This function returns the next edge in the body which contains the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_oriented_curve
(
/* received */
PK_EDGE_t            /*edge*/,          /* an edge */
/* returned */
PK_CURVE_t   *const  /*curve*/,         /* the curve (possibly PK_ENTITY_null) */
PK_LOGICAL_t *const  /*orientation*/    /* the edge orientation with respect to its */
);
/*
This function returns the curve and orientation of the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_precision
(
/* received */
PK_EDGE_t        /*edge*/,       /* edge */
/* returned */
double   *const  /*precision*/   /* precision */
);
/*
This function returns the `precision' of the given `edge'.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_shells
(
/* received */
PK_EDGE_t           /*edge*/,               /* an edge */
/* returned */
int         *const  /*n_shells*/,           /* number of shells (>= 1) */
PK_SHELL_t **const  /*shells*/              /* shells (optional) */
);
/*
This function returns the set of shells which contain the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_type
(
/* received */
PK_EDGE_t                  /*edge*/,         /* the edge */
/* returned */
PK_EDGE_ask_type_t *const  /*edge_types*/    /* edge types structure */
);
/*
This function classifies the given edge according to whether it is
(a)     open, closed, or a ring.
(b)     surrounded by solid regions, by void regions, or by both.
(c)     wireframe, laminar, normal, or general.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_vertices
(
/* received */
PK_EDGE_t        /*edge*/,               /* an edge */
/* returned */
PK_VERTEX_t      /*vertices*/[2]         /* vertices (possibly both PK_ENTITY_null) */
);
/*
This function returns the vertices bounding the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_ask_convexity
(
/* received */
PK_EDGE_t                         /*edge*/,
const PK_EDGE_ask_convexity_o_t * /*options*/,
/* returned */
PK_EDGE_convexity_t             * /*convexity*/
);
/*
The function returns the convexity of the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_attach_curves
(
/* received */
int               /*n_edges*/,      /* number of edges */
const PK_EDGE_t   /*edges*/[],      /* edges to have curves attached */
const PK_CURVE_t  /*curves*/[]      /* curves to be attached to edges */
);
/*
This function attaches curves to edges.

Note: this function is deprecated and has been superseded by
PK_EDGE_attach_curves_2.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_attach_curves_2
(
/* received */
int                               /*n_edges*/,   /* number of edges */
const PK_EDGE_t                   /*edges*/[],   /* edges to have curves attached */
const PK_CURVE_t                  /*curves*/[],  /* curves to attach to edges */
const PK_EDGE_attach_curves_o_t * /*options*/,   /* options structure */
/* returned */
PK_ENTITY_track_r_t       *const  /*tracking*/   /* tracking information */
);
/*
This function attaches curves to edges.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_attach_curve_nmnl
(
/* received */
PK_EDGE_t                             /*edge*/,       /* edge to which 'curve' */
PK_CURVE_t                            /*curve*/,      /* curve of edge */
const PK_EDGE_attach_curve_nmnl_o_t * /*options*/     /* option structure */
);
/*
This function attaches the `curve' provided to the `edge' as a nominal curve.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_contains_vector
(
/* received */
PK_EDGE_t              /*edge*/,       /* the edge */
PK_VECTOR_t            /*vector*/,     /* the position vector */
/* returned */
PK_TOPOL_t     *const  /*topol*/       /* topology coincident with vector if any */
);
/*
This function determines whether the given position vector coincides with
the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_delete
(
/* received */
int                        /*n_edges*/,   /* number of edges */
const PK_EDGE_t            /*edges*/[],   /* edges to be deleted */
const PK_EDGE_delete_o_t * /*options*/,   /* options structure */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/,  /* tracking information */
PK_TOPOL_local_r_t *const  /*results*/    /* status information */
);
/*
This function deletes the given set of edges.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_delete_wireframe
(
/* received */
int                  /*n_edges*/,            /* number of edges */
const PK_EDGE_t      /*edges*/[]             /* wireframe edges to delete */
);
/*
This function deletes the given wireframe edges.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_detach_curve_nmnl
(
/* received */
PK_EDGE_t        /*edge*/  /* edge from which nominal curve is to be detached */
/* returned */
);
/*
This function detaches the nominal curve from a tolerant `edge' if it has one.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_blend_topol
(
/* received */
PK_EDGE_t            /*edge*/,            /* edge on which to */
/* returned */
int                *const  /*n_edges*/,   /* number of affected edges */
PK_EDGE_t         **const  /*edges*/,     /* affected edges */
int                *const  /*n_faces*/,   /* number of affected faces */
PK_FACE_t         **const  /*faces*/      /* affected faces */
);
/*
This function finds the edges and faces affected by the blend on
the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_interval
(
/* received */
PK_EDGE_t             /*edge*/,
/* returned */
PK_INTERVAL_t *const  /*t_int*/
);
/*
This function computes the parameter interval of the curve, to which the edge
corresponds.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_end_tangents
(
/* received */
PK_EDGE_t             /*edge*/,                /* edge */
/* returned */
PK_VECTOR_t   *const  /*start*/,               /* start position of edge */
PK_VECTOR_t   *const  /*start_tangent*/,       /* tangent at start position */
PK_VECTOR_t   *const  /*end*/,                 /* end position of edge */
PK_VECTOR_t   *const  /*end_tangent*/          /* tangent at end position */
);
/*
This function finds the end positions of an edge and the edge tangents at
those positions.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_extreme
(
/* received */
PK_EDGE_t           /*edge*/,         /* edge on which extreme sought */
PK_VECTOR_t         /*direction_1*/,  /* first direction */
PK_VECTOR_t         /*direction_2*/,  /* second direction */
PK_VECTOR_t         /*direction_3*/,  /* third direction */
/* returned */
PK_VECTOR_t *const  /*extreme*/,      /* position of extreme point */
PK_TOPOL_t  *const  /*topol*/         /* topology on which extreme point lies */
);
/*
This function finds the extreme point on the given `edge' in `direction_1'.
If this extreme is not a single point, then `direction_2' and `direction_3'
are used successively to reduce the number of extreme points to one.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_deviation
(
/* received */
PK_EDGE_t            /*edge1*/,              /* edge from which to find distances */
PK_EDGE_t            /*edge2*/,              /* edge to which to find distance */
int                  /*how_many*/,           /* how many distances to find */
/* returned */
int          *const  /*n_distances*/,        /* number of distances returned */
double      **const  /*distances*/,          /* distances */
PK_VECTOR_t **const  /*edge1_vecs*/,         /* points on edge1 */
PK_VECTOR_t **const  /*edge2_vecs*/          /* corresponding points on edge2 */
);
/*
NOTE:This function has been superseded by PK_EDGE_find_deviation_2.

This function computes distances from edge1 to edge2.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_deviation_2
(
/* received */
PK_EDGE_t                            /*edge1*/,       /* First edge */

PK_EDGE_t                            /*edge2*/,       /* Second edge */

const PK_EDGE_find_deviation_o_t   * /*options*/,     /* Option structure */
/* returned */
PK_EDGE_find_deviation_r_t  *const   /*result*/       /* Results */
);
/*
This function finds distance samples between the two edges.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_deviation_r_f
(
/* received */
PK_EDGE_find_deviation_r_t *const  /*results*/
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_find_g1_edges
(
/* received */
PK_EDGE_t          /*edge*/,          /* starting edge */
double             /*tolerance*/,     /* angular tolerance on tangency */
PK_LOGICAL_t       /*convexity*/,     /* convexity checking switch */
/* returned */
int        *const  /*n_edges*/,       /* number of edges (>= 1) */
PK_EDGE_t **const  /*edges*/          /* received edge and tangent edges */
);
/*
This function returns the set of tangent edges for a given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_imprint_point
(
/* received */
PK_EDGE_t           /*edge*/,         /* edge to be imprinted onto */
PK_POINT_t          /*point*/,        /* point to imprint */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/,   /* new vertex */
PK_EDGE_t   *const  /*new_edge*/      /* new edge   (may be PK_ENTITY_null) */
);
/*
This function imprints a point onto an edge, thereby creating a
new vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_is_planar
(
/* received */
PK_EDGE_t             /*edge*/,        /* edge */
PK_LOGICAL_t          /*want_plane*/,  /* whether plane is wanted */
/* returned */
PK_LOGICAL_t *const  /*is_planar*/,    /* whether `edge' is planar */
PK_PLANE_t   *const  /*plane*/         /* plane if `is_planar' and `want_plane' */
);
/*
This function detects whether an edge lies in a plane.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_is_smooth
(
/* received */
PK_EDGE_t            /*edge*/,        /* edge to test */
double               /*max_angle*/,   /* maximum angle between face normals */
/* returned */
PK_LOGICAL_t *const  /*is_smooth*/    /* whether the edge is smooth */
);
/*
This function checks whether the edge passed to it in `edge' is smooth
according to the angular criterion passed in `max_angle'.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_offset_on_body_r_f
(
/* received */
PK_EDGE_offset_on_body_r_t *const  /*results*/
);
/*
Free the memory associated with the given structure.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_offset_on_body
(
/* received */
int                                /*n_edges*/,      /* number of edges */
const PK_EDGE_t                    /*edges*/[],      /* edges */
PK_HAND_t                          /*direction*/,    /* direction for offset */
const PK_EDGE_offset_on_body_o_t * /*options*/,      /* options structure */
/* returned */
PK_EDGE_offset_on_body_r_t *const  /*results*/,      /* status and error information */
PK_TOPOL_track_r_t         *const  /*tracking*/      /* tracking information */
);
/*
This function offsets a set of edges in the faces of their body.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_optimise
(
/* received */
PK_EDGE_t                           /*edge*/,                 /* edge to be */
const PK_EDGE_optimise_o_t        * /*options*/,              /* option structure */
/* returned */
PK_EDGE_optimise_result_t   *const  /*result*/,               /* whether the edge */
double                      *const  /*achieved_deviation*/    /* maximum measured */
);
/*
Given a tolerant edge, this function attempts to set a tolerance on
the edge that lies between the maximum deviation and the desired upper bound.

*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_remove_blend
(
/* received */
PK_EDGE_t        /*edge*/         /* edge from which to remove blend */
/* returned */
);
/*
This function removes an unfixed blend from the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_remove_to_bodies
(
/* received */
int                                        /*n_edges*/,          /* no. of edges */
const PK_EDGE_t                            /*edges*/[],          /* edges */
const PK_EDGE_remove_to_bodies_o_t       * /*options*/,          /* options */
/* returned */
int                                *const  /*n_parent_bodies*/,  /* no. of parent */
PK_BODY_t                         **const  /*parent_bodies*/,    /* parent bodies */
int                                *const  /*n_child_bodies*/,   /* no. of child */
PK_BODY_t                         **const  /*child_bodies*/,     /* child bodies */
PK_TOPOL_track_r_t                 *const  /*tracking*/          /* tracking */
);
/*
This function separates a body into two or more bodies by selecting
wire edges which are to be removed into new bodies
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_repair
(
/* received */
int                        /*n_edges*/,   /* number of edges (may be zero) */
const PK_EDGE_t            /*edges*/[],   /* edges */
const PK_EDGE_repair_o_t * /*options*/,   /* options structure */
/* returned */
PK_TOPOL_track_r_t *const  /*tracking*/   /* tracking information */
);
/*
This function attempts to repair an array of edges, i.e. make them valid.
The option structure determines which type of repair is attempted.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_reset_precision
(
/* received */
PK_EDGE_t               /*edge*/,       /* edge */
/* returned */
PK_reset_prec_t *const  /*result*/
);
/*
NOTE: This function has been superseded by PK_EDGE_reset_precision_2.

This function attempts to reset the precision of the given `edge' to the
session precision: that is to make Parasolid regard the edge as exact.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_reset_precision_2
(
/* received */
PK_EDGE_t                           /*edge*/,     /* edge */
const PK_EDGE_reset_precision_o_t * /*options*/,  /* options */
/* returned */
PK_reset_prec_t             *const  /*result*/
);
/*
This function attempts to reset the precision of the given `edge' to the
session precision: that is to make Parasolid regard the edge as exact.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_reverse
(
/* received */
PK_EDGE_t        /*edge*/   /* edge to reverse */
);
/*
This function reverses the given edge and its associated geometry.

NOTE: This function is deprecated and has been superseded by PK_EDGE_reverse_2.

*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_propagate_orientation
(
/* received */
PK_EDGE_t        /*edge*/   /* orientation edge */
);
/*
This function orientates the edges of a wire body to be in the same direction
as the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_reverse_2
(
/* received */
int                           /*n_edges*/,    /* number of edges */
const PK_EDGE_t               /*edges*/[],    /* edges to be reversed */
const PK_EDGE_reverse_2_o_t * /*options*/     /* option structure */
);
/*
This function reverses the given edges and their associated geometry.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_set_precision
(
/* received */
PK_EDGE_t          /*edge*/,         /* edge */
double             /*precision*/,    /* required precision */
/* returned */
int        *const  /*n_new_edges*/,  /* number of new edges */
PK_EDGE_t **const  /*new_edges*/     /* new edges */
);
/*
This function sets the `precision' of the given `edge'.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_set_precision_2
(
/* received */
PK_EDGE_t                         /*edge*/,         /* edge */
double                            /*precision*/,    /* required precision */
const PK_EDGE_set_precision_o_t * /*options*/,      /* options */
/* returned */
int                       *const  /*n_new_edges*/,  /* number of new edges */
PK_EDGE_t                **const  /*new_edges*/     /* new edges */
);
/*
This function sets the `precision' of the given `edge'.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_check
(
/* received */
PK_EDGE_t                     /*edge*/,          /* edge to be checked */
const PK_EDGE_check_o_t     * /*options*/,       /* options structure */
/* returned */
int                   *const  /*n_faults*/,      /* number of faults */
PK_check_fault_t     **const  /*faults*/         /* faults */
);
/*
This function checks the given edge.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_check_blends
(
/* received */
int                  /*n_edges*/,         /* number of edges */
const PK_EDGE_t      /*edges*/[],         /* edges to have blends checked */
PK_blend_check_t     /*level*/,           /* level of checking required */
/* returned */
PK_blend_fault_t     /*faults*/[],        /* result of check */
PK_TOPOL_t           /*fault_topols*/[]   /* topology associated with fault */
);
/*
This function checks the unfixed blends on the given edges.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_make_faces_from_wire
(
/* received */
int                  /*n_edges*/,            /* number of edges */
const PK_EDGE_t      /*edges*/[],            /* initial wireframe edges */
const PK_LOGICAL_t   /*senses*/[],           /* senses of initial fins */
const int            /*shared_loop*/[],      /* mapping from loops to faces */
/* returned */
PK_FACE_t            /*new_faces*/[]         /* new faces created */
);
/*
This function attaches faces to closed loops of wireframe edges in a body.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_make_wire_body
(
/* received */
int                                /*n_edges*/,   /* number of edges */
const PK_EDGE_t                    /*edges*/[],   /* edges */
const PK_EDGE_make_wire_body_o_t * /*options*/,   /* options */
/* returned */
PK_BODY_t                  *const  /*body*/,      /* created body */
PK_TOPOL_track_r_t         *const  /*tracking*/   /* tracking */
);
/*
This function creates a wire body from a collection of existing edges. The
edges may come from different bodies.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_make_curve
(
/* received */

int                              /*n_edges*/,        /* number of edges */
const PK_EDGE_t                  /*edges*/[],        /* edge chain to make curve */
double                           /*tolerance*/,      /* tolerance */
const PK_EDGE_make_curve_o_t   * /*options*/,        /* options structure */

/* returned */

PK_ENTITY_track_r_t      *const  /*tracking*/        /* tracking information */

);
/*
This function makes a single continuous curve from a set of edges to a given
tolerance.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_set_blend_chamfer
(
/* received */
int                                    /*n_edges*/,         /* no. of edges to blend */
const PK_EDGE_t                        /*edges*/[],         /* edges to have */
double                                 /*range_2*/,         /* offset of face */
double                                 /*range_1*/,         /* offset of first face */
const PK_FACE_t                        /*faces*/[],         /* faces of first range */
const PK_EDGE_set_blend_chamfer_o_t  * /*options*/,         /* options structure */
/* returned */
int                            *const  /*n_blend_edges*/,   /* number of edges with */
PK_EDGE_t                     **const  /*blend_edges*/      /* edges with blends */
);
/*
This function sets edges to have a chamfer blend.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_set_blend_constant
(
/* received */
int                                    /*n_edges*/,         /* no. of edges to blend */
const PK_EDGE_t                        /*edges*/[],         /* edges to have */
double                                 /*radius*/,          /* blend radius */
const PK_EDGE_set_blend_constant_o_t * /*options*/,         /* options structure */
/* returned */
int                            *const  /*n_blend_edges*/,   /* number of edges with */
PK_EDGE_t                     **const  /*blend_edges*/      /* edges with blends */
);
/*
This function sets edges to have a constant `radius' blend.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_set_blend_variable
(
/* received */
PK_EDGE_t                              /*edge*/,            /* edge to have */
PK_blend_edge_shape_t                  /*edge_shape*/,      /* shape of blend */
const PK_EDGE_set_blend_variable_o_t * /*options*/,         /* options structure */
/* returned */
int                            *const  /*n_blend_edges*/,   /* number of edges with */
PK_EDGE_t                     **const  /*blend_edges*/      /* edges with blends */
);
/*
This function sets edges to have a variable `radius' blend.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_merge_vertices
(
/* received */
PK_EDGE_t        /*edge*/,    /* Edge to delete */
PK_VERTEX_t      /*vertex*/   /* Vertex to delete */
);
/*
This function deletes an edge by merging its vertices.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_close_zip
(
/* received */
PK_EDGE_t        /*edge1*/,   /* Edge to zip */
PK_EDGE_t        /*edge2*/    /* Edge to delete */
);
/*
This function "zips" two edges together by merging the vertices at either end.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_open_zip
(
/* received */
PK_EDGE_t           /*edge*/,         /* Edge to split */
PK_FIN_t            /*fin*/,          /* Fin at vertex to split */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/,   /* New vertex created */
PK_EDGE_t   *const  /*new_edge*/      /* New edge created */
);
/*
This function splits an edge lengthwise, replacing it with two edges
joined at one end.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_slit
(
/* received */
PK_EDGE_t         /*edge*/,       /* Edge to be slit */
PK_LOGICAL_t      /*on_left*/,    /* New face is on left of edge */
/* returned */
PK_FACE_t *const  /*new_face*/,   /* New face created by slit */
PK_EDGE_t *const  /*new_edge*/    /* New edge created by slit */
);
/*
This function replaces an edge by a 2-edge face.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_delete_with_face
(
/* received */
PK_EDGE_t        /*edge*/,    /* Edge to be deleted */
PK_LOGICAL_t     /*on_left*/  /* Face to delete is on left of edge */
);
/*
This function deletes an edge and merges two faces and loops into one.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_delete_with_loop
(
/* received */
PK_EDGE_t        /*edge*/,    /* Edge to be deleted */
PK_LOGICAL_t     /*on_left*/  /* Loop to delete is on left of edge */
);
/*
This function deletes an edge and merges loops of the same face into one.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_split
(
/* received */
PK_EDGE_t           /*edge*/,         /* Edge to be split */
PK_LOGICAL_t        /*forward*/,      /* New vertex is forward vertex */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/,   /* New vertex create by split */
PK_EDGE_t   *const  /*new_edge*/      /* New edge created by split */
);
/*
This function splits an edge by adding a vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_delete_make_loop
(
/* received */
PK_EDGE_t         /*edge*/,       /* Edge to be deleted */
PK_LOGICAL_t      /*forward*/,    /* Forward vertex connects to new loop */
/* returned */
PK_LOOP_t *const  /*new_loop*/    /* New loop created */
);
/*
This function deletes an edge from a loop splitting it into two loops.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_delete_ring_face
(
/* received */
PK_EDGE_t        /*edge*/,    /* Edge to be deleted */
PK_LOGICAL_t     /*on_left*/  /* Face on the left is to be deleted */
);
/*
This function deletes a ring edge and a face.
*/

PK_linkage_m PK_ERROR_code_t PK_EDGE_euler_delete_ring_loop
(
/* received */
PK_EDGE_t        /*edge*/     /* Edge to be deleted */
);
/*
This function deletes a bi-wire ring edge and its loops.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_delete_acorn
(
/* received */
int                /*n_vertices*/,          /* number of vertices */
const PK_VERTEX_t  /*vertices*/[]           /* acorn vertices to delete */
);
/*
This function deletes the given acorn vertices.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_remove_edge
(
/* received */
PK_VERTEX_t         /*vertex*/,      /* vertex to split */
PK_EDGE_t           /*edge*/,        /* wireframe edge incident with vertex */
/* returned */
PK_VERTEX_t *const  /*new_vertex*/   /* new vertex */
);
/*
This function cuts a body at a given vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_set_precision
(
/* received */
PK_VERTEX_t      /*vertex*/,       /* vertex */
double           /*precision*/     /* required precision */
/* returned */
);
/*
This function sets the `precision' of the given `vertex'.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_ask_body
(
/* received */
PK_VERTEX_t       /*vertex*/,             /* a vertex */
/* returned */
PK_BODY_t *const  /*body*/                /* owning body */
);
/*
This function returns the body of the given vertex.

If the vertex is contained within a compound body ( see PK_BODY_ask_config )
then the child body to which the vertex belongs is returned.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_ask_faces
(
/* received */
PK_VERTEX_t        /*vertex*/,             /* a vertex */
/* returned */
int        *const  /*n_faces*/,            /* number of faces (>= 0) */
PK_FACE_t **const  /*faces*/               /* faces (optional) */
);
/*
This function returns the set of faces at the given vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_ask_isolated_loops
(
/* received */
PK_VERTEX_t        /*vertex*/,             /* a vertex */
/* returned */
int        *const  /*n_loops*/,            /* number of isolated loops (>= 0) */
PK_LOOP_t **const  /*loops*/               /* isolated loops (optional) */
);
/*
This function returns the set of isolated loops at the given vertex.
*/

PK_linkage_m PK_ERROR_code_t PK_VERTEX_ask_oriented_edges
(
/* received */
PK_VERTEX_t           /*vertex*/,             /* a vertex */
/* returned */
int           *const  /*n_edges*/,            /* number of edges (>= 0) */
PK_EDGE_t    **const  /*edges*/,              /* edges (optional) */
PK_LOGICAL_t **