/* gmpc-rating.c generated by valac, the Vala compiler
 * generated from gmpc-rating.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include "gmpc-extras.h"
#include <libmpd/libmpd.h>
#include <libmpd/libmpdclient.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <main.h>
#include <stdlib.h>
#include <string.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GmpcRatingPrivate {
	MpdObj* server;
	mpd_Song* song;
	GtkImage** rat;
	gint rat_length1;
	gint rat_size;
	GtkHBox* box;
	gint rating;
	gulong status_changed_id;
};


static gint gmpc_rating_id;
static gint gmpc_rating_id = 0;
static gpointer gmpc_rating_parent_class = NULL;

#define GMPC_RATING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_TYPE_RATING, GmpcRatingPrivate))
enum  {
	GMPC_RATING_DUMMY_PROPERTY
};
#define GMPC_RATING_use_transition TRUE
static void gmpc_rating_status_changed (GmpcRating* self, MpdObj* server, ChangedStatusType what, GmpcConnection* conn);
static gboolean _gmpc_rating_button_press_event_callback_gtk_widget_button_press_event (GtkEventBox* _sender, GdkEventButton* event, gpointer self);
static GObject * gmpc_rating_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_rating_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



gboolean gmpc_rating_button_press_event_callback (GmpcRating* self, GtkEventBox* wid, GdkEventButton* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wid != NULL, FALSE);
	if ((*event).type == GDK_BUTTON_PRESS) {
		if ((*event).button == 1) {
			gint width;
			gint button;
			char* _tmp0_;
			width = ((GtkWidget*) self)->allocation.width;
			button = (gint) ((((*event).x / ((double) width)) + 0.15) * 5);
			mpd_sticker_song_set (self->priv->server, self->priv->song->file, "rating", _tmp0_ = g_strdup_printf ("%i", button));
			_g_free0 (_tmp0_);
			gmpc_rating_set_rating (self, button);
		}
	}
	result = FALSE;
	return result;
}


static void gmpc_rating_status_changed (GmpcRating* self, MpdObj* server, ChangedStatusType what, GmpcConnection* conn) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (conn != NULL);
	if ((what & MPD_CST_STICKER) != 0) {
		gmpc_rating_update (self);
	}
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


GmpcRating* gmpc_rating_construct (GType object_type, MpdObj* server, const mpd_Song* song) {
	GmpcRating * self;
	mpd_Song* _tmp0_;
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (song != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->server = server;
	self->priv->song = (_tmp0_ = _mpd_songDup0 (song), _mpd_freeSong0 (self->priv->song), _tmp0_);
	gmpc_rating_update (self);
	self->priv->status_changed_id = g_signal_connect_swapped (gmpcconn, "status_changed", (GCallback) gmpc_rating_status_changed, self);
	return self;
}


GmpcRating* gmpc_rating_new (MpdObj* server, const mpd_Song* song) {
	return gmpc_rating_construct (GMPC_TYPE_RATING, server, song);
}


void gmpc_rating_set_rating (GmpcRating* self, gint rating) {
	gint i;
	g_return_if_fail (self != NULL);
	i = 0;
	if (rating != self->priv->rating) {
		{
			gboolean _tmp0_;
			i = 0;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->rat[i], i < rating);
			}
		}
		self->priv->rating = rating;
	}
}


void gmpc_rating_update (GmpcRating* self) {
	char* value;
	g_return_if_fail (self != NULL);
	value = mpd_sticker_song_get (self->priv->server, self->priv->song->file, "rating");
	if (value == NULL) {
		gmpc_rating_set_rating (self, 0);
	} else {
		gmpc_rating_set_rating (self, atoi (value));
	}
	_g_free0 (value);
}


static gboolean _gmpc_rating_button_press_event_callback_gtk_widget_button_press_event (GtkEventBox* _sender, GdkEventButton* event, gpointer self) {
	return gmpc_rating_button_press_event_callback (self, _sender, event);
}


static GObject * gmpc_rating_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcRating * self;
	parent_class = G_OBJECT_CLASS (gmpc_rating_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_RATING (obj);
	{
		gint i = 0;
		GtkHBox* _tmp0_;
		GtkEventBox* _tmp1_;
		GtkImage** _tmp2_;
		g_object_set ((GtkFrame*) self, "shadow", GTK_SHADOW_NONE, NULL);
		self->priv->box = (_tmp0_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (TRUE, 6)), _g_object_unref0 (self->priv->box), _tmp0_);
		self->event_box = (_tmp1_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->event_box), _tmp1_);
		gtk_event_box_set_visible_window (self->event_box, FALSE);
		self->priv->rat = (_tmp2_ = g_new0 (GtkImage*, 5 + 1), self->priv->rat = (_vala_array_free (self->priv->rat, self->priv->rat_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->rat_length1 = 5, self->priv->rat_size = self->priv->rat_length1, _tmp2_);
		{
			gboolean _tmp3_;
			i = 0;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkImage* _tmp4_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < 5)) {
					break;
				}
				self->priv->rat[i] = (_tmp4_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("rating", GTK_ICON_SIZE_MENU)), _g_object_unref0 (self->priv->rat[i]), _tmp4_);
				gtk_box_pack_start ((GtkBox*) self->priv->box, (GtkWidget*) self->priv->rat[i], FALSE, FALSE, (guint) 0);
			}
		}
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->event_box);
		gtk_container_add ((GtkContainer*) self->event_box, (GtkWidget*) self->priv->box);
		g_signal_connect_object ((GtkWidget*) self->event_box, "button-press-event", (GCallback) _gmpc_rating_button_press_event_callback_gtk_widget_button_press_event, self, 0);
		gtk_widget_show_all ((GtkWidget*) self);
	}
	return obj;
}


static void gmpc_rating_class_init (GmpcRatingClass * klass) {
	gmpc_rating_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcRatingPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_rating_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_rating_finalize;
	gmpc_rating_id = gmpc_rating_id + 1;
}


static void gmpc_rating_instance_init (GmpcRating * self) {
	self->priv = GMPC_RATING_GET_PRIVATE (self);
	self->priv->server = NULL;
	self->priv->song = NULL;
	self->priv->rating = -1;
	self->priv->status_changed_id = (gulong) 0;
}


static void gmpc_rating_finalize (GObject* obj) {
	GmpcRating * self;
	self = GMPC_RATING (obj);
	{
		gboolean _tmp5_ = FALSE;
		if (self->priv->status_changed_id > 0) {
			_tmp5_ = g_signal_handler_is_connected (gmpcconn, self->priv->status_changed_id);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			g_signal_handler_disconnect (gmpcconn, self->priv->status_changed_id);
			self->priv->status_changed_id = (gulong) 0;
		}
	}
	_mpd_freeSong0 (self->priv->song);
	self->priv->rat = (_vala_array_free (self->priv->rat, self->priv->rat_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->event_box);
	G_OBJECT_CLASS (gmpc_rating_parent_class)->finalize (obj);
}


GType gmpc_rating_get_type (void) {
	static GType gmpc_rating_type_id = 0;
	if (gmpc_rating_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcRatingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_rating_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcRating), 0, (GInstanceInitFunc) gmpc_rating_instance_init, NULL };
		gmpc_rating_type_id = g_type_register_static (GTK_TYPE_FRAME, "GmpcRating", &g_define_type_info, 0);
	}
	return gmpc_rating_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




