/* music-tree.c generated by valac, the Vala compiler
 * generated from music-tree.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include "gmpc-extras.h"
#include <glib/gi18n-lib.h>
#include <plugin.h>
#include <config1.h>
#include <metadata.h>
#include <gmpc-profiles.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <gio/gio.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free_meta_data_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_meta_data_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _GmpcProviderMusicTreeGetArtistArtData GmpcProviderMusicTreeGetArtistArtData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _GmpcProviderMusicTreeGetAlbumCoverData GmpcProviderMusicTreeGetAlbumCoverData;

struct _GmpcProviderMusicTreePrivate {
	GRegex* image_filename;
};

struct _GmpcProviderMusicTreeGetArtistArtData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	char* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	char* base_path;
	char* path;
	GFile* dir;
	GList* queries;
	char* ipath;
	char* _tmp1_;
	char* _tmp0_;
	GFile* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp6_;
	char* _tmp5_;
	GFile* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp11_;
	char* _tmp10_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFileInfo* e;
	MetaData* item;
	MetaData* _tmp14_;
	GError * err;
	GList* opath_collection;
	GList* opath_it;
	char* opath;
	GList* _tmp15_;
	GError * _inner_error_;
};

struct _GmpcProviderMusicTreeGetAlbumCoverData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	char* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	char* base_path;
	char* path;
	GFile* dir;
	GFileEnumerator* e;
	GList* files;
	MetaData* item;
	char* _tmp0_;
	MetaData* _tmp1_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* info;
	GError * err;
	GFile* pdir;
	char* _tmp2_;
	GFileEnumerator* pe;
	GList* pfiles;
	MetaData* pitem;
	char* _tmp3_;
	MetaData* _tmp4_;
	GList* pinfo_collection;
	GList* pinfo_it;
	GFileInfo* pinfo;
	GError * perr;
	GList* _tmp5_;
	GError * _inner_error_;
};


static gpointer gmpc_provider_music_tree_parent_class = NULL;
static GmpcPluginMetaDataIfaceIface* gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_parent_iface = NULL;

#define use_transition_lp TRUE
#define some_unique_name_lp VERSION
#define GMPC_PROVIDER_MUSIC_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_PROVIDER_TYPE_MUSIC_TREE, GmpcProviderMusicTreePrivate))
enum  {
	GMPC_PROVIDER_MUSIC_TREE_DUMMY_PROPERTY
};
static gint* gmpc_provider_music_tree_real_get_version (GmpcPluginBase* base, int* result_length1);
static const char* gmpc_provider_music_tree_real_get_name (GmpcPluginBase* base);
static void gmpc_provider_music_tree_real_set_priority (GmpcPluginMetaDataIface* base, gint priority);
static gint gmpc_provider_music_tree_real_get_priority (GmpcPluginMetaDataIface* base);
static void _g_list_free_meta_data_free (GList* self);
static void gmpc_provider_music_tree_get_album_cover (GmpcProviderMusicTree* self, const char* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_album_cover_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_get_artist_art (GmpcProviderMusicTree* self, const char* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_artist_art_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target);
static void gmpc_provider_music_tree_get_artist_art_data_free (gpointer _data);
static void gmpc_provider_music_tree_get_artist_art_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free_g_free (GList* self);
static gboolean gmpc_provider_music_tree_get_artist_art_co (GmpcProviderMusicTreeGetArtistArtData* data);
static void gmpc_provider_music_tree_get_album_cover_data_free (gpointer _data);
static void gmpc_provider_music_tree_get_album_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free_g_object_unref (GList* self);
static gboolean gmpc_provider_music_tree_get_album_cover_co (GmpcProviderMusicTreeGetAlbumCoverData* data);
static GObject * gmpc_provider_music_tree_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_provider_music_tree_finalize (GObject* obj);



static gint* gmpc_provider_music_tree_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcProviderMusicTree * self;
	gint* result;
	gint* _tmp0_;
	self = (GmpcProviderMusicTree*) base;
	result = (_tmp0_ = GMPC_PROVIDER_MUSIC_TREE_version, *result_length1 = G_N_ELEMENTS (GMPC_PROVIDER_MUSIC_TREE_version), _tmp0_);
	return result;
}


static const char* gmpc_provider_music_tree_real_get_name (GmpcPluginBase* base) {
	GmpcProviderMusicTree * self;
	const char* result;
	self = (GmpcProviderMusicTree*) base;
	result = N_ ("Music Tree Provider");
	return result;
}


static void gmpc_provider_music_tree_real_set_priority (GmpcPluginMetaDataIface* base, gint priority) {
	GmpcProviderMusicTree * self;
	self = (GmpcProviderMusicTree*) base;
	cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "priority", priority);
}


static gint gmpc_provider_music_tree_real_get_priority (GmpcPluginMetaDataIface* base) {
	GmpcProviderMusicTree * self;
	gint result;
	self = (GmpcProviderMusicTree*) base;
	result = cfg_get_single_value_as_int_with_default (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "priority", 0);
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void _g_list_free_meta_data_free (GList* self) {
	g_list_foreach (self, (GFunc) meta_data_free, NULL);
	g_list_free (self);
}


static void gmpc_provider_music_tree_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target) {
	GmpcProviderMusicTree * self;
	GList* list;
	char* id;
	const char* directory;
	const char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	char* scheme;
	GList* _tmp6_;
	self = (GmpcProviderMusicTree*) base;
	g_return_if_fail (song != NULL);
	list = NULL;
	id = gmpc_profiles_get_current (gmpc_profiles);
	directory = NULL;
	g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:79: Starting Query");
	if (id != NULL) {
		directory = gmpc_profiles_get_music_directory (gmpc_profiles, id);
	}
	_tmp0_ = NULL;
	if (directory == NULL) {
		_tmp0_ = "(null)";
	} else {
		_tmp0_ = directory;
	}
	g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:85: Got directory: %s", _tmp0_);
	if (directory == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_get_length (directory) == 0;
	}
	if (_tmp1_) {
		GList* _tmp2_;
		g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:90: No Music directory specified");
		callback ((_tmp2_ = list, list = NULL, _tmp2_), callback_target);
		__g_list_free_meta_data_free0 (list);
		_g_free0 (id);
		return;
	}
	if (song == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = song->file == NULL;
	}
	if (_tmp3_) {
		GList* _tmp4_;
		g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:101: No Song or no song path specified");
		callback ((_tmp4_ = list, list = NULL, _tmp4_), callback_target);
		__g_list_free_meta_data_free0 (list);
		_g_free0 (id);
		return;
	}
	scheme = g_uri_parse_scheme (song->file);
	if (scheme != NULL) {
		GList* _tmp5_;
		g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:111: Scheme '%s' indicates no local file.", scheme);
		callback ((_tmp5_ = list, list = NULL, _tmp5_), callback_target);
		__g_list_free_meta_data_free0 (list);
		_g_free0 (id);
		_g_free0 (scheme);
		return;
	}
	g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:117: Music directory: %s", directory);
	switch (type) {
		case META_ALBUM_ART:
		{
			gmpc_provider_music_tree_get_album_cover (self, directory, song, callback, callback_target, NULL, NULL);
			__g_list_free_meta_data_free0 (list);
			_g_free0 (id);
			_g_free0 (scheme);
			return;
		}
		case META_ARTIST_ART:
		{
			gmpc_provider_music_tree_get_artist_art (self, directory, song, callback, callback_target, NULL, NULL);
			__g_list_free_meta_data_free0 (list);
			_g_free0 (id);
			_g_free0 (scheme);
			return;
		}
		default:
		{
			break;
		}
	}
	g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:134: Query done, %u results", g_list_length (list));
	callback ((_tmp6_ = list, list = NULL, _tmp6_), callback_target);
	__g_list_free_meta_data_free0 (list);
	_g_free0 (id);
	_g_free0 (scheme);
}


static void gmpc_provider_music_tree_get_artist_art_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetArtistArtData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	(data->callback_target_destroy_notify == NULL) ? NULL : data->callback_target_destroy_notify (data->callback_target);
	data->callback = NULL;
	data->callback_target = NULL;
	data->callback_target_destroy_notify = NULL;
	g_slice_free (GmpcProviderMusicTreeGetArtistArtData, data);
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void gmpc_provider_music_tree_get_artist_art (GmpcProviderMusicTree* self, const char* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetArtistArtData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetArtistArtData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_artist_art);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_artist_art_data_free);
	_data_->self = self;
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_artist_art_co (_data_);
}


static void gmpc_provider_music_tree_get_artist_art_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetArtistArtData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gmpc_provider_music_tree_get_artist_art_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetArtistArtData* data;
	data = _user_data_;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_artist_art_co (data);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean gmpc_provider_music_tree_get_artist_art_co (GmpcProviderMusicTreeGetArtistArtData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->list = NULL;
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:147: Query artist art ");
			data->base_path = g_path_get_dirname (data->song->file);
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:151: Got basename: %s", data->base_path);
			data->path = g_build_filename (data->directory, data->base_path, NULL);
			data->dir = g_file_new_for_path (data->path);
			data->queries = NULL;
			data->ipath = g_build_filename (data->path, "artist.jpg", NULL);
			data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			if (data->song->artist != NULL) {
				data->ipath = (data->_tmp1_ = g_build_filename (data->path, data->_tmp0_ = g_strdup_printf ("%s.jpg", data->song->artist), NULL), _g_free0 (data->ipath), data->_tmp1_);
				_g_free0 (data->_tmp0_);
				data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			}
			data->dir = (data->_tmp2_ = g_file_get_parent (data->dir), _g_object_unref0 (data->dir), data->_tmp2_);
			data->path = (data->_tmp3_ = g_file_get_path (data->dir), _g_free0 (data->path), data->_tmp3_);
			data->ipath = (data->_tmp4_ = g_build_filename (data->path, "artist.jpg", NULL), _g_free0 (data->ipath), data->_tmp4_);
			data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			if (data->song->artist != NULL) {
				data->ipath = (data->_tmp6_ = g_build_filename (data->path, data->_tmp5_ = g_strdup_printf ("%s.jpg", data->song->artist), NULL), _g_free0 (data->ipath), data->_tmp6_);
				_g_free0 (data->_tmp5_);
				data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			}
			data->dir = (data->_tmp7_ = g_file_get_parent (data->dir), _g_object_unref0 (data->dir), data->_tmp7_);
			data->path = (data->_tmp8_ = g_file_get_path (data->dir), _g_free0 (data->path), data->_tmp8_);
			data->ipath = (data->_tmp9_ = g_build_filename (data->path, "artist.jpg", NULL), _g_free0 (data->ipath), data->_tmp9_);
			data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			if (data->song->artist != NULL) {
				data->ipath = (data->_tmp11_ = g_build_filename (data->path, data->_tmp10_ = g_strdup_printf ("%s.jpg", data->song->artist), NULL), _g_free0 (data->ipath), data->_tmp11_);
				_g_free0 (data->_tmp10_);
				data->queries = g_list_append (data->queries, g_strdup (data->ipath));
			}
			data->dir = (data->_tmp12_ = NULL, _g_object_unref0 (data->dir), data->_tmp12_);
			{
				data->opath_collection = data->queries;
				for (data->opath_it = data->opath_collection; data->opath_it != NULL; data->opath_it = data->opath_it->next) {
					data->opath = g_strdup ((const char*) data->opath_it->data);
					{
						g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:185: Got path: %s. Checking info", data->opath);
						data->dir = (data->_tmp13_ = g_file_new_for_path (data->opath), _g_object_unref0 (data->dir), data->_tmp13_);
						{
							data->_state_ = 3;
							g_file_query_info_async (data->dir, "access::can-read", 0, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_get_artist_art_ready, data);
							return FALSE;
							case 3:
							data->e = g_file_query_info_finish (data->dir, data->_res_, &data->_inner_error_);
							if (data->_inner_error_ != NULL) {
								goto __catch26_g_error;
							}
							g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:191: Got path: %s. Have info", data->opath);
							if (g_file_info_get_attribute_boolean (data->e, "access::can-read")) {
								data->item = meta_data_new ();
								data->item->type = META_ALBUM_ART;
								data->item->plugin_name = gmpc_plugin_base_get_name ((GmpcPluginBase*) data->self);
								data->item->content_type = META_DATA_CONTENT_URI;
								meta_data_set_uri (data->item, data->opath);
								data->list = g_list_append (data->list, (data->_tmp14_ = data->item, data->item = NULL, data->_tmp14_));
								g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:201: Found %s, adding", data->opath);
								_meta_data_free0 (data->item);
							}
							_g_object_unref0 (data->e);
						}
						goto __finally26;
						__catch26_g_error:
						{
							data->err = data->_inner_error_;
							data->_inner_error_ = NULL;
							{
								g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:206: Error trying to get file info from '%s': %s\n", data->opath, data->err->message);
								_g_error_free0 (data->err);
							}
						}
						__finally26:
						if (data->_inner_error_ != NULL) {
							_g_free0 (data->opath);
							__g_list_free_meta_data_free0 (data->list);
							_g_free0 (data->base_path);
							_g_free0 (data->path);
							_g_object_unref0 (data->dir);
							__g_list_free_g_free0 (data->queries);
							_g_free0 (data->ipath);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
							g_clear_error (&data->_inner_error_);
							return FALSE;
						}
						_g_free0 (data->opath);
					}
				}
			}
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:211: Query done, %u results", g_list_length (data->list));
			g_list_first (data->list);
			data->callback ((data->_tmp15_ = data->list, data->list = NULL, data->_tmp15_), data->callback_target);
			__g_list_free_meta_data_free0 (data->list);
			_g_free0 (data->base_path);
			_g_free0 (data->path);
			_g_object_unref0 (data->dir);
			__g_list_free_g_free0 (data->queries);
			_g_free0 (data->ipath);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			__g_list_free_meta_data_free0 (data->list);
			_g_free0 (data->base_path);
			_g_free0 (data->path);
			_g_object_unref0 (data->dir);
			__g_list_free_g_free0 (data->queries);
			_g_free0 (data->ipath);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void gmpc_provider_music_tree_get_album_cover_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetAlbumCoverData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	(data->callback_target_destroy_notify == NULL) ? NULL : data->callback_target_destroy_notify (data->callback_target);
	data->callback = NULL;
	data->callback_target = NULL;
	data->callback_target_destroy_notify = NULL;
	g_slice_free (GmpcProviderMusicTreeGetAlbumCoverData, data);
}


static void gmpc_provider_music_tree_get_album_cover (GmpcProviderMusicTree* self, const char* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumCoverData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetAlbumCoverData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_album_cover);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_album_cover_data_free);
	_data_->self = self;
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_album_cover_co (_data_);
}


static void gmpc_provider_music_tree_get_album_cover_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetAlbumCoverData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gmpc_provider_music_tree_get_album_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumCoverData* data;
	data = _user_data_;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_album_cover_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean gmpc_provider_music_tree_get_album_cover_co (GmpcProviderMusicTreeGetAlbumCoverData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->list = NULL;
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:225: Query album cover");
			data->base_path = g_path_get_dirname (data->song->file);
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:229: Got basename: %s", data->base_path);
			data->path = g_build_filename (data->directory, data->base_path, NULL);
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:234: Got path: %s. Starting to itterate over childs", data->path);
			data->dir = g_file_new_for_path (data->path);
			{
				data->_state_ = 4;
				g_file_enumerate_children_async (data->dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_get_album_cover_ready, data);
				return FALSE;
				case 4:
				data->e = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch27_g_error;
				}
				while (TRUE) {
					data->_state_ = 5;
					g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_get_album_cover_ready, data);
					return FALSE;
					case 5:
					data->files = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->e);
						goto __catch27_g_error;
					}
					if (data->files == NULL) {
						__g_list_free_g_object_unref0 (data->files);
						break;
					}
					{
						data->info_collection = data->files;
						for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
							data->info = _g_object_ref0 ((GFileInfo*) data->info_it->data);
							{
								if (g_regex_match (data->self->priv->image_filename, g_file_info_get_name (data->info), 0, NULL)) {
									data->item = meta_data_new ();
									data->item->type = META_ALBUM_ART;
									data->item->plugin_name = gmpc_plugin_base_get_name ((GmpcPluginBase*) data->self);
									data->item->content_type = META_DATA_CONTENT_URI;
									meta_data_set_uri (data->item, data->_tmp0_ = g_build_filename (data->path, g_file_info_get_name (data->info), NULL));
									_g_free0 (data->_tmp0_);
									data->list = g_list_append (data->list, (data->_tmp1_ = data->item, data->item = NULL, data->_tmp1_));
									g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:254: Found %s, adding", g_file_info_get_name (data->info));
									_meta_data_free0 (data->item);
								}
								_g_object_unref0 (data->info);
							}
						}
					}
					__g_list_free_g_object_unref0 (data->files);
				}
				_g_object_unref0 (data->e);
			}
			goto __finally27;
			__catch27_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_WARNING, "music-tree.vala:261: Error trying to walk directory '%s': %s\n", data->path, data->err->message);
					_g_error_free0 (data->err);
				}
			}
			__finally27:
			if (data->_inner_error_ != NULL) {
				__g_list_free_meta_data_free0 (data->list);
				_g_free0 (data->base_path);
				_g_free0 (data->path);
				_g_object_unref0 (data->dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			if (g_list_length (data->list) == 0) {
				if (g_regex_match_simple ("(DISC|CD)[ 0-9]*$", data->path, G_REGEX_CASELESS, 0)) {
					data->pdir = g_file_get_parent (data->dir);
					data->path = (data->_tmp2_ = g_file_get_path (data->pdir), _g_free0 (data->path), data->_tmp2_);
					g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:271: Nothing found, trying parent: %s", data->path);
					{
						data->_state_ = 6;
						g_file_enumerate_children_async (data->pdir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_get_album_cover_ready, data);
						return FALSE;
						case 6:
						data->pe = g_file_enumerate_children_finish (data->pdir, data->_res_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							goto __catch28_g_error;
						}
						while (TRUE) {
							data->_state_ = 7;
							g_file_enumerator_next_files_async (data->pe, 10, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_get_album_cover_ready, data);
							return FALSE;
							case 7:
							data->pfiles = g_file_enumerator_next_files_finish (data->pe, data->_res_, &data->_inner_error_);
							if (data->_inner_error_ != NULL) {
								_g_object_unref0 (data->pe);
								goto __catch28_g_error;
							}
							if (data->pfiles == NULL) {
								__g_list_free_g_object_unref0 (data->pfiles);
								break;
							}
							{
								data->pinfo_collection = data->pfiles;
								for (data->pinfo_it = data->pinfo_collection; data->pinfo_it != NULL; data->pinfo_it = data->pinfo_it->next) {
									data->pinfo = _g_object_ref0 ((GFileInfo*) data->pinfo_it->data);
									{
										if (g_regex_match (data->self->priv->image_filename, g_file_info_get_name (data->pinfo), 0, NULL)) {
											data->pitem = meta_data_new ();
											data->pitem->type = META_ALBUM_ART;
											data->pitem->plugin_name = gmpc_plugin_base_get_name ((GmpcPluginBase*) data->self);
											data->pitem->content_type = META_DATA_CONTENT_URI;
											meta_data_set_uri (data->pitem, data->_tmp3_ = g_build_filename (data->path, g_file_info_get_name (data->pinfo), NULL));
											_g_free0 (data->_tmp3_);
											data->list = g_list_append (data->list, (data->_tmp4_ = data->pitem, data->pitem = NULL, data->_tmp4_));
											g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:290: Found %s, adding", g_file_info_get_name (data->pinfo));
											_meta_data_free0 (data->pitem);
										}
										_g_object_unref0 (data->pinfo);
									}
								}
							}
							__g_list_free_g_object_unref0 (data->pfiles);
						}
						_g_object_unref0 (data->pe);
					}
					goto __finally28;
					__catch28_g_error:
					{
						data->perr = data->_inner_error_;
						data->_inner_error_ = NULL;
						{
							g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_WARNING, "music-tree.vala:296: Error trying to walk parent of directory '%s': %s\n", data->path, data->perr->message);
							_g_error_free0 (data->perr);
						}
					}
					__finally28:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->pdir);
						__g_list_free_meta_data_free0 (data->list);
						_g_free0 (data->base_path);
						_g_free0 (data->path);
						_g_object_unref0 (data->dir);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (data->pdir);
				}
			}
			g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_DEBUG, "music-tree.vala:302: Query done, %u results", g_list_length (data->list));
			g_list_first (data->list);
			data->callback ((data->_tmp5_ = data->list, data->list = NULL, data->_tmp5_), data->callback_target);
			__g_list_free_meta_data_free0 (data->list);
			_g_free0 (data->base_path);
			_g_free0 (data->path);
			_g_object_unref0 (data->dir);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			__g_list_free_meta_data_free0 (data->list);
			_g_free0 (data->base_path);
			_g_free0 (data->path);
			_g_object_unref0 (data->dir);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


GmpcProviderMusicTree* gmpc_provider_music_tree_construct (GType object_type) {
	GmpcProviderMusicTree * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcProviderMusicTree* gmpc_provider_music_tree_new (void) {
	return gmpc_provider_music_tree_construct (GMPC_PROVIDER_TYPE_MUSIC_TREE);
}


static GObject * gmpc_provider_music_tree_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcProviderMusicTree * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (gmpc_provider_music_tree_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PROVIDER_MUSIC_TREE (obj);
	_inner_error_ = NULL;
	{
		((GmpcPluginBase*) self)->plugin_type = 8 + 32;
		{
			GRegex* _tmp0_;
			GRegex* _tmp1_;
			_tmp0_ = g_regex_new (".*\\.(png|jpg|jpeg|gif)$", G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
			self->priv->image_filename = (_tmp1_ = _tmp0_, _g_regex_unref0 (self->priv->image_filename), _tmp1_);
		}
		goto __finally29;
		__catch29_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_log ("Gmpc.Plugin.MusicTreeProvider", G_LOG_LEVEL_ERROR, "music-tree.vala:59: Failed to create regex: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally29:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void gmpc_provider_music_tree_class_init (GmpcProviderMusicTreeClass * klass) {
	gmpc_provider_music_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcProviderMusicTreePrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_provider_music_tree_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_provider_music_tree_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_provider_music_tree_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_provider_music_tree_finalize;
}


static void gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_interface_init (GmpcPluginMetaDataIfaceIface * iface) {
	gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_priority = gmpc_provider_music_tree_real_set_priority;
	iface->get_priority = gmpc_provider_music_tree_real_get_priority;
	iface->get_metadata = gmpc_provider_music_tree_real_get_metadata;
}


static void gmpc_provider_music_tree_instance_init (GmpcProviderMusicTree * self) {
	self->priv = GMPC_PROVIDER_MUSIC_TREE_GET_PRIVATE (self);
	self->priv->image_filename = NULL;
}


static void gmpc_provider_music_tree_finalize (GObject* obj) {
	GmpcProviderMusicTree * self;
	self = GMPC_PROVIDER_MUSIC_TREE (obj);
	_g_regex_unref0 (self->priv->image_filename);
	G_OBJECT_CLASS (gmpc_provider_music_tree_parent_class)->finalize (obj);
}


GType gmpc_provider_music_tree_get_type (void) {
	static GType gmpc_provider_music_tree_type_id = 0;
	if (gmpc_provider_music_tree_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcProviderMusicTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_provider_music_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcProviderMusicTree), 0, (GInstanceInitFunc) gmpc_provider_music_tree_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_meta_data_iface_info = { (GInterfaceInitFunc) gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gmpc_provider_music_tree_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcProviderMusicTree", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_provider_music_tree_type_id, GMPC_PLUGIN_TYPE_META_DATA_IFACE, &gmpc_plugin_meta_data_iface_info);
	}
	return gmpc_provider_music_tree_type_id;
}




