/*****************************************************************
 * gmerlin-avdecoder - a general purpose multimedia decoding library
 *
 * Copyright (c) 2001 - 2011 Members of the Gmerlin project
 * gmerlin-general@lists.sourceforge.net
 * http://gmerlin.sourceforge.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/

static const struct
  {
  char const * const iso_639_t;
  char const * const iso_639_b;
  char const * const iso_639_2;
  char const * const name;
  char const * const family;
  }
language_codes[] =
  {
    { "aar", "aar", "aa", "Afar", "Hamitic" },
    { "abk", "abk", "ab", "Abkhazian", "Ibero-caucasian" },
    { "ace", "ace", (char*)0, "Achinese", (char*)0 },
    { "ach", "ach", (char*)0, "Acoli", (char*)0 },
    { "ada", "ada", (char*)0, "Adangme", (char*)0 },
    { "afa", "afa", (char*)0, "Afro-Asiatic (Other)", (char*)0 },
    { "afh", "afh", (char*)0, "Afrihili", (char*)0 },
    { "afr", "afr", "af", "Afrikaans", "Germanic" },
    { "aka", "aka", (char*)0, "Akan", (char*)0 },
    { "akk", "akk", (char*)0, "Akkadian", (char*)0 },
    { "ale", "ale", (char*)0, "Aleut", (char*)0 },
    { "alg", "alg", (char*)0, "Algonquian languages", (char*)0 },
    { "amh", "amh", "am", "Amharic", "Semitic" },
    { "ang", "ang", (char*)0, "English, Old (ca. 450-1100)", (char*)0 },
    { "apa", "apa", (char*)0, "Apache languages", (char*)0 },
    { "ara", "ara", "ar", "Arabic", "Semitic" },
    { "arc", "arc", (char*)0, "Aramaic", (char*)0 },
    { "arn", "arn", (char*)0, "Araucanian", (char*)0 },
    { "arp", "arp", (char*)0, "Arapaho", (char*)0 },
    { "art", "art", (char*)0, "Artificial (Other)", (char*)0 },
    { "arw", "arw", (char*)0, "Arawak", (char*)0 },
    { "asm", "asm", "as", "Assamese", "Indian" },
    { "ath", "ath", (char*)0, "Athapascan languages", (char*)0 },
    { "aus", "aus", (char*)0, "Australian languages", (char*)0 },
    { "ava", "ava", (char*)0, "Avaric", (char*)0 },
    { "ave", "ave", "ae", "Avestan", (char*)0 },
    { "awa", "awa", (char*)0, "Awadhi", (char*)0 },
    { "aym", "aym", "ay", "Aymara", "Amerindian" },
    { "aze", "aze", "az", "Azerbaijani", "Turkic/altaic" },
    { "bad", "bad", (char*)0, "Banda", (char*)0 },
    { "bai", "bai", (char*)0, "Bamileke languages", (char*)0 },
    { "bak", "bak", "ba", "Bashkir", "Turkic/altaic" },
    { "bal", "bal", (char*)0, "Baluchi", (char*)0 },
    { "bam", "bam", (char*)0, "Bambara", (char*)0 },
    { "ban", "ban", (char*)0, "Balinese", (char*)0 },
    { "bas", "bas", (char*)0, "Basa", (char*)0 },
    { "bat", "bat", (char*)0, "Baltic (Other)", (char*)0 },
    { "bej", "bej", (char*)0, "Beja", (char*)0 },
    { "bel", "bel", "be", "Belarusian", "Slavic" },
    { "bem", "bem", (char*)0, "Bemba", (char*)0 },
    { "ben", "ben", "bn", "Bengali", "Indian" },
    { "ber", "ber", (char*)0, "Berber (Other)", (char*)0 },
    { "bho", "bho", (char*)0, "Bhojpuri", (char*)0 },
    { "bih", "bih", "bh", "Bihari", "Indian" },
    { "bik", "bik", (char*)0, "Bikol", (char*)0 },
    { "bin", "bin", (char*)0, "Bini", (char*)0 },
    { "bis", "bis", "bi", "Bislama", (char*)0 },
    { "bla", "bla", (char*)0, "Siksika", (char*)0 },
    { "bnt", "bnt", (char*)0, "Bantu (Other)", (char*)0 },
    { "bod", "tib", "bo", "Tibetan", "Asian" },
    { "bos", "bos", "bs", "Bosnian", (char*)0 },
    { "bra", "bra", (char*)0, "Braj", (char*)0 },
    { "bre", "bre", "br", "Breton", "Celtic" },
    { "btk", "btk", (char*)0, "Batak (Indonesia)", (char*)0 },
    { "bua", "bua", (char*)0, "Buriat", (char*)0 },
    { "bug", "bug", (char*)0, "Buginese", (char*)0 },
    { "bul", "bul", "bg", "Bulgarian", "Slavic" },
    { "cad", "cad", (char*)0, "Caddo", (char*)0 },
    { "cai", "cai", (char*)0, "Central American Indian (Other)", (char*)0 },
    { "car", "car", (char*)0, "Carib", (char*)0 },
    { "cat", "cat", "ca", "Catalan", "Romance" },
    { "cau", "cau", (char*)0, "Caucasian (Other)", (char*)0 },
    { "ceb", "ceb", (char*)0, "Cebuano", (char*)0 },
    { "cel", "cel", (char*)0, "Celtic (Other)", (char*)0 },
    { "ces", "cze", "cs", "Czech", "Slavic" },
    { "cha", "cha", "ch", "Chamorro", (char*)0 },
    { "chb", "chb", (char*)0, "Chibcha", (char*)0 },
    { "che", "che", "ce", "Chechen", (char*)0 },
    { "chg", "chg", (char*)0, "Chagatai", (char*)0 },
    { "chk", "chk", (char*)0, "Chuukese", (char*)0 },
    { "chm", "chm", (char*)0, "Mari", (char*)0 },
    { "chn", "chn", (char*)0, "Chinook jargon", (char*)0 },
    { "cho", "cho", (char*)0, "Choctaw", (char*)0 },
    { "chp", "chp", (char*)0, "Chipewyan", (char*)0 },
    { "chr", "chr", (char*)0, "Cherokee", (char*)0 },
    { "chu", "chu", "cu", "Church Slavic", (char*)0 },
    { "chv", "chv", "cv", "Chuvash", (char*)0 },
    { "chy", "chy", (char*)0, "Cheyenne", (char*)0 },
    { "cmc", "cmc", (char*)0, "Chamic languages", (char*)0 },
    { "cop", "cop", (char*)0, "Coptic", (char*)0 },
    { "cor", "cor", "kw", "Cornish", (char*)0 },
    { "cos", "cos", "co", "Corsican", "Romance" },
    { "cpe", "cpe", (char*)0, "Creoles and pidgins, English based (Other)", (char*)0 },
    { "cpf", "cpf", (char*)0, "Creoles and pidgins, French-based (Other)", (char*)0 },
    { "cpp", "cpp", (char*)0, "Creoles and pidgins, Portuguese-based (Other)", (char*)0 },
    { "cre", "cre", (char*)0, "Cree", (char*)0 },
    { "crp", "crp", (char*)0, "Creoles and pidgins (Other)", (char*)0 },
    { "cus", "cus", (char*)0, "Cushitic (Other)", (char*)0 },
    { "cym", "wel", "cy", "Welsh", "Celtic" },
    { "dak", "dak", (char*)0, "Dakota", (char*)0 },
    { "dan", "dan", "da", "Danish", "Germanic" },
    { "day", "day", (char*)0, "Dayak", (char*)0 },
    { "del", "del", (char*)0, "Delaware", (char*)0 },
    { "den", "den", (char*)0, "Slave (Athapascan)", (char*)0 },
    { "deu", "ger", "de", "German", "Germanic" },
    { "dgr", "dgr", (char*)0, "Dogrib", (char*)0 },
    { "din", "din", (char*)0, "Dinka", (char*)0 },
    { "div", "div", (char*)0, "Divehi", (char*)0 },
    { "doi", "doi", (char*)0, "Dogri", (char*)0 },
    { "dra", "dra", (char*)0, "Dravidian (Other)", (char*)0 },
    { "dua", "dua", (char*)0, "Duala", (char*)0 },
    { "dum", "dum", (char*)0, "Dutch, Middle (ca. 1050-1350)", (char*)0 },
    { "dyu", "dyu", (char*)0, "Dyula", (char*)0 },
    { "dzo", "dzo", "dz", "Dzongkha", "Asian" },
    { "efi", "efi", (char*)0, "Efik", (char*)0 },
    { "egy", "egy", (char*)0, "Egyptian (Ancient)", (char*)0 },
    { "eka", "eka", (char*)0, "Ekajuk", (char*)0 },
    { "ell", "gre", "el", "Greek, Modern (1453-)", "Latin/greek" },
    { "elx", "elx", (char*)0, "Elamite", (char*)0 },
    { "eng", "eng", "en", "English", "Germanic" },
    { "enm", "enm", (char*)0, "English, Middle (1100-1500)", (char*)0 },
    { "epo", "epo", "eo", "Esperanto", "International aux." },
    { "est", "est", "et", "Estonian", "Finno-ugric" },
    { "eus", "baq", "eu", "Basque", "Basque" },
    { "ewe", "ewe", (char*)0, "Ewe", (char*)0 },
    { "ewo", "ewo", (char*)0, "Ewondo", (char*)0 },
    { "fan", "fan", (char*)0, "Fang", (char*)0 },
    { "fao", "fao", "fo", "Faroese", "Germanic" },
    { "fas", "per", "fa", "Persian", (char*)0 },
    { "fat", "fat", (char*)0, "Fanti", (char*)0 },
    { "fij", "fij", "fj", "Fijian", "Oceanic/indonesian" },
    { "fin", "fin", "fi", "Finnish", "Finno-ugric" },
    { "fiu", "fiu", (char*)0, "Finno-Ugrian (Other)", (char*)0 },
    { "fon", "fon", (char*)0, "Fon", (char*)0 },
    { "fra", "fre", "fr", "French", "Romance" },
    { "frm", "frm", (char*)0, "French, Middle (ca. 1400-1600)", (char*)0 },
    { "fro", "fro", (char*)0, "French, Old (842-ca. 1400)", (char*)0 },
    { "fry", "fry", "fy", "Frisian", "Germanic" },
    { "ful", "ful", (char*)0, "Fulah", (char*)0 },
    { "fur", "fur", (char*)0, "Friulian", (char*)0 },
    { "gaa", "gaa", (char*)0, "Ga", (char*)0 },
    { "gay", "gay", (char*)0, "Gayo", (char*)0 },
    { "gba", "gba", (char*)0, "Gbaya", (char*)0 },
    { "gem", "gem", (char*)0, "Germanic (Other)", (char*)0 },
    { "gez", "gez", (char*)0, "Geez", (char*)0 },
    { "gil", "gil", (char*)0, "Gilbertese", (char*)0 },
    { "gla", "gla", "gd", "Gaelic (Scots)", "Celtic" },
    { "gle", "gle", "ga", "Irish", "Celtic" },
    { "glg", "glg", "gl", "Gallegan", "Romance" },
    { "glv", "glv", "gv", "Manx", (char*)0 },
    { "gmh", "gmh", (char*)0, "German, Middle High (ca. 1050-1500)", (char*)0 },
    { "goh", "goh", (char*)0, "German, Old High (ca. 750-1050)", (char*)0 },
    { "gon", "gon", (char*)0, "Gondi", (char*)0 },
    { "gor", "gor", (char*)0, "Gorontalo", (char*)0 },
    { "got", "got", (char*)0, "Gothic", (char*)0 },
    { "grb", "grb", (char*)0, "Grebo", (char*)0 },
    { "grc", "grc", (char*)0, "Greek, Ancient (to 1453)", (char*)0 },
    { "grn", "grn", "gn", "Guarani", "Amerindian" },
    { "guj", "guj", "gu", "Gujarati", "Indian" },
    { "gwi", "gwi", (char*)0, "Gwich´in", (char*)0 },
    { "hai", "hai", (char*)0, "Haida", (char*)0 },
    { "hau", "hau", "ha", "Hausa", "Negro-african" },
    { "haw", "haw", (char*)0, "Hawaiian", (char*)0 },
    { "heb", "heb", "he", "Hebrew", (char*)0 },
    { "her", "her", "hz", "Herero", (char*)0 },
    { "hil", "hil", (char*)0, "Hiligaynon", (char*)0 },
    { "him", "him", (char*)0, "Himachali", (char*)0 },
    { "hin", "hin", "hi", "Hindi", "Indian" },
    { "hit", "hit", (char*)0, "Hittite", (char*)0 },
    { "hmn", "hmn", (char*)0, "Hmong", (char*)0 },
    { "hmo", "hmo", "ho", "Hiri Motu", (char*)0 },
    { "hrv", "scr", "hr", "Croatian", "Slavic" },
    { "hun", "hun", "hu", "Hungarian", "Finno-ugric" },
    { "hup", "hup", (char*)0, "Hupa", (char*)0 },
    { "hye", "arm", "hy", "Armenian", "Indo-european (other)" },
    { "iba", "iba", (char*)0, "Iban", (char*)0 },
    { "ibo", "ibo", (char*)0, "Igbo", (char*)0 },
    { "ijo", "ijo", (char*)0, "Ijo", (char*)0 },
    { "iku", "iku", "iu", "Inuktitut", (char*)0 },
    { "ile", "ile", "ie", "Interlingue", "International aux." },
    { "ilo", "ilo", (char*)0, "Iloko", (char*)0 },
    { "ina", "ina", "ia", "Interlingua (International Auxiliary Language Association)", "International aux." },
    { "inc", "inc", (char*)0, "Indic (Other)", (char*)0 },
    { "ind", "ind", "id", "Indonesian", (char*)0 },
    { "ine", "ine", (char*)0, "Indo-European (Other)", (char*)0 },
    { "ipk", "ipk", "ik", "Inupiaq", "Eskimo" },
    { "ira", "ira", (char*)0, "Iranian (Other)", (char*)0 },
    { "iro", "iro", (char*)0, "Iroquoian languages", (char*)0 },
    { "isl", "ice", "is", "Icelandic", "Germanic" },
    { "ita", "ita", "it", "Italian", "Romance" },
    { "jaw", "jav", "jw", "Javanese", (char*)0 },
    { "jpn", "jpn", "ja", "Japanese", "Asian" },
    { "jpr", "jpr", (char*)0, "Judeo-Persian", (char*)0 },
    { "kaa", "kaa", (char*)0, "Kara-Kalpak", (char*)0 },
    { "kab", "kab", (char*)0, "Kabyle", (char*)0 },
    { "kac", "kac", (char*)0, "Kachin", (char*)0 },
    { "kal", "kal", "kl", "Kalaallisut", "Eskimo" },
    { "kam", "kam", (char*)0, "Kamba", (char*)0 },
    { "kan", "kan", "kn", "Kannada", "Dravidian" },
    { "kar", "kar", (char*)0, "Karen", (char*)0 },
    { "kas", "kas", "ks", "Kashmiri", "Indian" },
    { "kat", "geo", "ka", "Georgian", "Ibero-caucasian" },
    { "kau", "kau", (char*)0, "Kanuri", (char*)0 },
    { "kaw", "kaw", (char*)0, "Kawi", (char*)0 },
    { "kaz", "kaz", "kk", "Kazakh", "Turkic/altaic" },
    { "kha", "kha", (char*)0, "Khasi", (char*)0 },
    { "khi", "khi", (char*)0, "Khoisan (Other)", (char*)0 },
    { "khm", "khm", "km", "Khmer", "Asian" },
    { "kho", "kho", (char*)0, "Khotanese", (char*)0 },
    { "kik", "kik", "ki", "Kikuyu", (char*)0 },
    { "kin", "kin", "rw", "Kinyarwanda", "Negro-african" },
    { "kir", "kir", "ky", "Kirghiz", "Turkic/altaic" },
    { "kmb", "kmb", (char*)0, "Kimbundu", (char*)0 },
    { "kok", "kok", (char*)0, "Konkani", (char*)0 },
    { "kom", "kom", "kv", "Komi", (char*)0 },
    { "kon", "kon", (char*)0, "Kongo", (char*)0 },
    { "kor", "kor", "ko", "Korean", "Asian" },
    { "kos", "kos", (char*)0, "Kosraean", (char*)0 },
    { "kpe", "kpe", (char*)0, "Kpelle", (char*)0 },
    { "kro", "kro", (char*)0, "Kru", (char*)0 },
    { "kru", "kru", (char*)0, "Kurukh", (char*)0 },
    { "kum", "kum", (char*)0, "Kumyk", (char*)0 },
    { "kur", "kur", "ku", "Kurdish", "Iranian" },
    { "kut", "kut", (char*)0, "Kutenai", (char*)0 },
    { "lad", "lad", (char*)0, "Ladino", (char*)0 },
    { "lah", "lah", (char*)0, "Lahnda", (char*)0 },
    { "lam", "lam", (char*)0, "Lamba", (char*)0 },
    { "lao", "lao", "lo", "Lao", "Asian" },
    { "lat", "lat", "la", "Latin", "Latin/greek" },
    { "lav", "lav", "lv", "Latvian", "Baltic" },
    { "lez", "lez", (char*)0, "Lezghian", (char*)0 },
    { "lin", "lin", "ln", "Lingala", "Negro-african" },
    { "lit", "lit", "lt", "Lithuanian", "Baltic" },
    { "lol", "lol", (char*)0, "Mongo", (char*)0 },
    { "loz", "loz", (char*)0, "Lozi", (char*)0 },
    { "ltz", "ltz", "lb", "Letzeburgesch", (char*)0 },
    { "lua", "lua", (char*)0, "Luba-Lulua", (char*)0 },
    { "lub", "lub", (char*)0, "Luba-Katanga", (char*)0 },
    { "lug", "lug", (char*)0, "Ganda", (char*)0 },
    { "lui", "lui", (char*)0, "Luiseno", (char*)0 },
    { "lun", "lun", (char*)0, "Lunda", (char*)0 },
    { "luo", "luo", (char*)0, "Luo (Kenya and Tanzania)", (char*)0 },
    { "lus", "lus", (char*)0, "lushai", (char*)0 },
    { "mad", "mad", (char*)0, "Madurese", (char*)0 },
    { "mag", "mag", (char*)0, "Magahi", (char*)0 },
    { "mah", "mah", "mh", "Marshall", (char*)0 },
    { "mai", "mai", (char*)0, "Maithili", (char*)0 },
    { "mak", "mak", (char*)0, "Makasar", (char*)0 },
    { "mal", "mal", "ml", "Malayalam", "Dravidian" },
    { "man", "man", (char*)0, "Mandingo", (char*)0 },
    { "map", "map", (char*)0, "Austronesian (Other)", (char*)0 },
    { "mar", "mar", "mr", "Marathi", "Indian" },
    { "mas", "mas", (char*)0, "Masai", (char*)0 },
    { "mdr", "mdr", (char*)0, "Mandar", (char*)0 },
    { "men", "men", (char*)0, "Mende", (char*)0 },
    { "mga", "mga", (char*)0, "Irish, Middle (900-1200)", (char*)0 },
    { "mic", "mic", (char*)0, "Micmac", (char*)0 },
    { "min", "min", (char*)0, "Minangkabau", (char*)0 },
    { "mis", "mis", (char*)0, "Miscellaneous languages", (char*)0 },
    { "mkd", "mac", "mk", "Macedonian", "Slavic" },
    { "mkh", "mkh", (char*)0, "Mon-Khmer (Other)", (char*)0 },
    { "mlg", "mlg", "mg", "Malagasy", "Oceanic/indonesian" },
    { "mlt", "mlt", "mt", "Maltese", "Semitic" },
    { "mnc", "mnc", (char*)0, "Manchu", (char*)0 },
    { "mni", "mni", (char*)0, "Manipuri", (char*)0 },
    { "mno", "mno", (char*)0, "Manobo languages", (char*)0 },
    { "moh", "moh", (char*)0, "Mohawk", (char*)0 },
    { "mol", "mol", "mo", "Moldavian", "Romance" },
    { "mon", "mon", "mn", "Mongolian", (char*)0 },
    { "mos", "mos", (char*)0, "Mossi", (char*)0 },
    { "mri", "mao", "mi", "Maori", "Oceanic/indonesian" },
    { "msa", "may", "ms", "Malay", "Oceanic/indonesian" },
    { "mul", "mul", (char*)0, "Multiple languages", (char*)0 },
    { "mun", "mun", (char*)0, "Munda languages", (char*)0 },
    { "mus", "mus", (char*)0, "Creek", (char*)0 },
    { "mwr", "mwr", (char*)0, "Marwari", (char*)0 },
    { "mya", "bur", "my", "Burmese", "Asian" },
    { "myn", "myn", (char*)0, "Mayan languages", (char*)0 },
    { "nah", "nah", (char*)0, "Nahuatl", (char*)0 },
    { "nai", "nai", (char*)0, "North American Indian", (char*)0 },
    { "nau", "nau", "na", "Nauru", (char*)0 },
    { "nav", "nav", "nv", "Navajo", (char*)0 },
    { "nbl", "nbl", "nr", "Ndebele, South", (char*)0 },
    { "nde", "nde", "nd", "Ndebele, North", (char*)0 },
    { "ndo", "ndo", "ng", "Ndonga", (char*)0 },
    { "nds", "nds", (char*)0, "Low German; Low Saxon; German, Low; Saxon, Low", (char*)0 },
    { "nep", "nep", "ne", "Nepali", "Indian" },
    { "new", "new", (char*)0, "Newari", (char*)0 },
    { "nia", "nia", (char*)0, "Nias", (char*)0 },
    { "nic", "nic", (char*)0, "Niger-Kordofanian (Other)", (char*)0 },
    { "niu", "niu", (char*)0, "Niuean", (char*)0 },
    { "nld", "dut", "nl", "Dutch", "Germanic" },
    { "nno", "nno", "nn", "Norwegian Nynorsk", (char*)0 },
    { "nob", "nob", "nb", "Norwegian Bokmål", (char*)0 },
    { "non", "non", (char*)0, "Norse, Old", (char*)0 },
    { "nor", "nor", "no", "Norwegian", "Germanic" },
    { "nso", "nso", (char*)0, "Sotho, Northern", (char*)0 },
    { "nub", "nub", (char*)0, "Nubian languages", (char*)0 },
    { "nya", "nya", "ny", "Chichewa; Nyanja", (char*)0 },
    { "nym", "nym", (char*)0, "Nyamwezi", (char*)0 },
    { "nyn", "nyn", (char*)0, "Nyankole", (char*)0 },
    { "nyo", "nyo", (char*)0, "Nyoro", (char*)0 },
    { "nzi", "nzi", (char*)0, "Nzima", (char*)0 },
    { "oci", "oci", "oc", "Occitan (post 1500); Provençal", "Romance" },
    { "oji", "oji", (char*)0, "Ojibwa", (char*)0 },
    { "ori", "ori", "or", "Oriya", "Indian" },
    { "orm", "orm", "om", "Oromo", "Hamitic" },
    { "osa", "osa", (char*)0, "Osage", (char*)0 },
    { "oss", "oss", "os", "Ossetian; Ossetic", (char*)0 },
    { "ota", "ota", (char*)0, "Turkish, Ottoman (1500-1928)", (char*)0 },
    { "oto", "oto", (char*)0, "Otomian languages", (char*)0 },
    { "paa", "paa", (char*)0, "Papuan (Other)", (char*)0 },
    { "pag", "pag", (char*)0, "Pangasinan", (char*)0 },
    { "pal", "pal", (char*)0, "Pahlavi", (char*)0 },
    { "pam", "pam", (char*)0, "Pampanga", (char*)0 },
    { "pan", "pan", "pa", "Panjabi", "Indian" },
    { "pap", "pap", (char*)0, "Papiamento", (char*)0 },
    { "pau", "pau", (char*)0, "Palauan", (char*)0 },
    { "peo", "peo", (char*)0, "Persian, Old (ca. 600-400 b.c.)", (char*)0 },
    { "phi", "phi", (char*)0, "Philippine (Other)", (char*)0 },
    { "pli", "pli", "pi", "Pali", (char*)0 },
    { "pol", "pol", "pl", "Polish", "Slavic" },
    { "pon", "pon", (char*)0, "Pohnpeian", (char*)0 },
    { "por", "por", "pt", "Portuguese", "Romance" },
    { "pra", "pra", (char*)0, "Prakrit languages", (char*)0 },
    { "pro", "pro", (char*)0, "Provençal, Old (to 1500)", (char*)0 },
    { "pus", "pus", "ps", "Pushto", "Iranian" },
    { "que", "que", "qu", "Quechua", "Amerindian" },
    { "raj", "raj", (char*)0, "Rajasthani", (char*)0 },
    { "rap", "rap", (char*)0, "Rapanui", (char*)0 },
    { "rar", "rar", (char*)0, "Rarotongan", (char*)0 },
    { "roa", "roa", (char*)0, "Romance (Other)", (char*)0 },
    { "rom", "rom", (char*)0, "Romany", (char*)0 },
    { "ron", "rum", "ro", "Romanian", "Romance" },
    { "run", "run", "rn", "Rundi", "Negro-african" },
    { "rus", "rus", "ru", "Russian", "Slavic" },
    { "sad", "sad", (char*)0, "Sandawe", (char*)0 },
    { "sag", "sag", "sg", "Sango", "Negro-african" },
    { "sah", "sah", (char*)0, "Yakut", (char*)0 },
    { "sai", "sai", (char*)0, "South American Indian (Other)", (char*)0 },
    { "sal", "sal", (char*)0, "Salishan languages", (char*)0 },
    { "sam", "sam", (char*)0, "Samaritan Aramaic", (char*)0 },
    { "san", "san", "sa", "Sanskrit", "Indian" },
    { "sas", "sas", (char*)0, "Sasak", (char*)0 },
    { "sat", "sat", (char*)0, "Santali", (char*)0 },
    { "sco", "sco", (char*)0, "Scots", (char*)0 },
    { "sel", "sel", (char*)0, "Selkup", (char*)0 },
    { "sem", "sem", (char*)0, "Semitic (Other)", (char*)0 },
    { "sga", "sga", (char*)0, "Irish, Old (to 900)", (char*)0 },
    { "sgn", "sgn", (char*)0, "Sign Languages", (char*)0 },
    { "shn", "shn", (char*)0, "Shan", (char*)0 },
    { "sid", "sid", (char*)0, "Sidamo", (char*)0 },
    { "sin", "sin", "si", "Sinhalese", "Indian" },
    { "sio", "sio", (char*)0, "Siouan languages", (char*)0 },
    { "sit", "sit", (char*)0, "Sino-Tibetan (Other)", (char*)0 },
    { "sla", "sla", (char*)0, "Slavic (Other)", (char*)0 },
    { "slk", "slo", "sk", "Slovak", "Slavic" },
    { "slv", "slv", "sl", "Slovenian", "Slavic" },
    { "sme", "sme", "se", "Northern Sami", (char*)0 },
    { "smi", "smi", (char*)0, "Sami languages (Other)", (char*)0 },
    { "smo", "smo", "sm", "Samoan", "Oceanic/indonesian" },
    { "sna", "sna", "sn", "Shona", "Negro-african" },
    { "snd", "snd", "sd", "Sindhi", "Indian" },
    { "snk", "snk", (char*)0, "Soninke", (char*)0 },
    { "sog", "sog", (char*)0, "Sogdian", (char*)0 },
    { "som", "som", "so", "Somali", "Hamitic" },
    { "son", "son", (char*)0, "Songhai", (char*)0 },
    { "sot", "sot", "st", "Sotho, Southern", "Negro-african" },
    { "spa", "spa", "es", "Spanish", "Romance" },
    { "sqi", "alb", "sq", "Albanian", "Indo-european (other)" },
    { "srd", "srd", "sc", "Sardinian", (char*)0 },
    { "srp", "scc", "sr", "Serbian", "Slavic" },
    { "srr", "srr", (char*)0, "Serer", (char*)0 },
    { "ssa", "ssa", (char*)0, "Nilo-Saharan (Other)", (char*)0 },
    { "ssw", "ssw", "ss", "Swati", "Negro-african" },
    { "suk", "suk", (char*)0, "Sukuma", (char*)0 },
    { "sun", "sun", "su", "Sundanese", "Oceanic/indonesian" },
    { "sus", "sus", (char*)0, "Susu", (char*)0 },
    { "sux", "sux", (char*)0, "Sumerian", (char*)0 },
    { "swa", "swa", "sw", "Swahili", "Negro-african" },
    { "swe", "swe", "sv", "Swedish", "Germanic" },
    { "syr", "syr", (char*)0, "Syriac", (char*)0 },
    { "tah", "tah", "ty", "Tahitian", (char*)0 },
    { "tai", "tai", (char*)0, "Tai (Other)", (char*)0 },
    { "tam", "tam", "ta", "Tamil", "Dravidian" },
    { "tat", "tat", "tt", "Tatar", "Turkic/altaic" },
    { "tel", "tel", "te", "Telugu", "Dravidian" },
    { "tem", "tem", (char*)0, "Timne", (char*)0 },
    { "ter", "ter", (char*)0, "Tereno", (char*)0 },
    { "tet", "tet", (char*)0, "Tetum", (char*)0 },
    { "tgk", "tgk", "tg", "Tajik", "Iranian" },
    { "tgl", "tgl", "tl", "Tagalog", "Oceanic/indonesian" },
    { "tha", "tha", "th", "Thai", "Asian" },
    { "tig", "tig", (char*)0, "Tigre", (char*)0 },
    { "tir", "tir", "ti", "Tigrinya", "Semitic" },
    { "tiv", "tiv", (char*)0, "Tiv", (char*)0 },
    { "tkl", "tkl", (char*)0, "Tokelau", (char*)0 },
    { "tli", "tli", (char*)0, "Tlingit", (char*)0 },
    { "tmh", "tmh", (char*)0, "Tamashek", (char*)0 },
    { "tog", "tog", (char*)0, "Tonga (Nyasa)", (char*)0 },
    { "ton", "ton", "to", "Tonga (Tonga Islands)", "Oceanic/indonesian" },
    { "tpi", "tpi", (char*)0, "Tok Pisin", (char*)0 },
    { "tsi", "tsi", (char*)0, "Tsimshian", (char*)0 },
    { "tsn", "tsn", "tn", "Tswana", "Negro-african" },
    { "tso", "tso", "ts", "Tsonga", "Negro-african" },
    { "tuk", "tuk", "tk", "Turkmen", "Turkic/altaic" },
    { "tum", "tum", (char*)0, "Tumbuka", (char*)0 },
    { "tur", "tur", "tr", "Turkish", "Turkic/altaic" },
    { "tut", "tut", (char*)0, "Altaic (Other)", (char*)0 },
    { "tvl", "tvl", (char*)0, "Tuvalu", (char*)0 },
    { "twi", "twi", "tw", "Twi", "Negro-african" },
    { "tyv", "tyv", (char*)0, "Tuvinian", (char*)0 },
    { "uga", "uga", (char*)0, "Ugaritic", (char*)0 },
    { "uig", "uig", "ug", "Uighur", (char*)0 },
    { "ukr", "ukr", "uk", "Ukrainian", "Slavic" },
    { "umb", "umb", (char*)0, "Umbundu", (char*)0 },
    { "und", "und", (char*)0, "Undetermined", (char*)0 },
    { "urd", "urd", "ur", "Urdu", "Indian" },
    { "uzb", "uzb", "uz", "Uzbek", "Turkic/altaic" },
    { "vai", "vai", (char*)0, "Vai", (char*)0 },
    { "ven", "ven", (char*)0, "Venda", (char*)0 },
    { "vie", "vie", "vi", "Vietnamese", "Asian" },
    { "vol", "vol", "vo", "Volapük", "International aux." },
    { "vot", "vot", (char*)0, "Votic", (char*)0 },
    { "wak", "wak", (char*)0, "Wakashan languages", (char*)0 },
    { "wal", "wal", (char*)0, "Walamo", (char*)0 },
    { "war", "war", (char*)0, "Waray", (char*)0 },
    { "was", "was", (char*)0, "Washo", (char*)0 },
    { "wen", "wen", (char*)0, "Sorbian languages", (char*)0 },
    { "wol", "wol", "wo", "Wolof", "Negro-african" },
    { "xho", "xho", "xh", "Xhosa", "Negro-african" },
    { "yao", "yao", (char*)0, "Yao", (char*)0 },
    { "yap", "yap", (char*)0, "Yapese", (char*)0 },
    { "yid", "yid", "yi", "Yiddish", (char*)0 },
    { "yor", "yor", "yo", "Yoruba", "Negro-african" },
    { "ypk", "ypk", (char*)0, "Yupik languages", (char*)0 },
    { "zap", "zap", (char*)0, "Zapotec", (char*)0 },
    { "zen", "zen", (char*)0, "Zenaga", (char*)0 },
    { "zha", "zha", "za", "Zhuang", (char*)0 },
    { "zho", "chi", "zh", "Chinese", "Asian" },
    { "znd", "znd", (char*)0, "Zande", (char*)0 },
    { "zul", "zul", "zu", "Zulu", "Negro-african" },
    { "zun", "zun", (char*)0, "Zuni", (char*)0 },
  };
