/*Copyright (c) 2015 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#ifndef _DHT_MESSAGES_H_
#define _DHT_MESSAGES_H_

#include "glfs-message-id.h"

/* To add new message IDs, append new identifiers at the end of the list.
 *
 * Never remove a message ID. If it's not used anymore, you can rename it or
 * leave it as it is, but not delete it. This is to prevent reutilization of
 * IDs by other messages.
 *
 * The component name must match one of the entries defined in
 * glfs-message-id.h.
 */

GLFS_MSGID(DHT,
        DHT_MSG_CACHED_SUBVOL_GET_FAILED,
        DHT_MSG_CREATE_LINK_FAILED,
        DHT_MSG_DICT_SET_FAILED,
        DHT_MSG_DIR_ATTR_HEAL_FAILED,
        DHT_MSG_DIR_SELFHEAL_FAILED,
        DHT_MSG_DIR_SELFHEAL_XATTR_FAILED,
        DHT_MSG_FILE_ON_MULT_SUBVOL,
        DHT_MSG_FILE_TYPE_MISMATCH,
        DHT_MSG_GFID_MISMATCH,
        DHT_MSG_GFID_NULL,
        DHT_MSG_HASHED_SUBVOL_GET_FAILED,
        DHT_MSG_INIT_FAILED,
        DHT_MSG_INVALID_CONFIGURATION,
        DHT_MSG_INVALID_DISK_LAYOUT,
        DHT_MSG_INVALID_OPTION,
        DHT_MSG_LAYOUT_FIX_FAILED,
        DHT_MSG_LAYOUT_MERGE_FAILED,
        DHT_MSG_LAYOUT_MISMATCH,
        DHT_MSG_LAYOUT_NULL,
        DHT_MSG_MIGRATE_DATA_COMPLETE,
        DHT_MSG_MIGRATE_DATA_FAILED,
        DHT_MSG_MIGRATE_FILE_COMPLETE,
        DHT_MSG_MIGRATE_FILE_FAILED,
        DHT_MSG_NO_MEMORY,
        DHT_MSG_OPENDIR_FAILED,
        DHT_MSG_REBALANCE_FAILED,
        DHT_MSG_REBALANCE_START_FAILED,
        DHT_MSG_REBALANCE_STATUS,
        DHT_MSG_REBALANCE_STOPPED,
        DHT_MSG_RENAME_FAILED,
        DHT_MSG_SETATTR_FAILED,
        DHT_MSG_SUBVOL_INSUFF_INODES,
        DHT_MSG_SUBVOL_INSUFF_SPACE,
        DHT_MSG_UNLINK_FAILED,
        DHT_MSG_LAYOUT_SET_FAILED,
        DHT_MSG_LOG_FIXED_LAYOUT,
        DHT_MSG_LOG_TIER_ERROR,
        DHT_MSG_LOG_TIER_STATUS,
        DHT_MSG_GET_XATTR_FAILED,
        DHT_MSG_FILE_LOOKUP_FAILED,
        DHT_MSG_OPEN_FD_FAILED,
        DHT_MSG_SET_INODE_CTX_FAILED,
        DHT_MSG_UNLOCKING_FAILED,
        DHT_MSG_DISK_LAYOUT_NULL,
        DHT_MSG_SUBVOL_INFO,
        DHT_MSG_CHUNK_SIZE_INFO,
        DHT_MSG_LAYOUT_FORM_FAILED,
        DHT_MSG_SUBVOL_ERROR,
        DHT_MSG_LAYOUT_SORT_FAILED,
        DHT_MSG_REGEX_INFO,
        DHT_MSG_FOPEN_FAILED,
        DHT_MSG_SET_HOSTNAME_FAILED,
        DHT_MSG_BRICK_ERROR,
        DHT_MSG_SYNCOP_FAILED,
        DHT_MSG_MIGRATE_INFO,
        DHT_MSG_SOCKET_ERROR,
        DHT_MSG_CREATE_FD_FAILED,
        DHT_MSG_READDIR_ERROR,
        DHT_MSG_CHILD_LOC_BUILD_FAILED,
        DHT_MSG_SET_SWITCH_PATTERN_ERROR,
        DHT_MSG_COMPUTE_HASH_FAILED,
        DHT_MSG_FIND_LAYOUT_ANOMALIES_ERROR,
        DHT_MSG_ANOMALIES_INFO,
        DHT_MSG_LAYOUT_INFO,
        DHT_MSG_INODE_LK_ERROR,
        DHT_MSG_RENAME_INFO,
        DHT_MSG_DATA_NULL,
        DHT_MSG_AGGREGATE_QUOTA_XATTR_FAILED,
        DHT_MSG_UNLINK_LOOKUP_INFO,
        DHT_MSG_LINK_FILE_LOOKUP_INFO,
        DHT_MSG_OPERATION_NOT_SUP,
        DHT_MSG_NOT_LINK_FILE_ERROR,
        DHT_MSG_CHILD_DOWN,
        DHT_MSG_UUID_PARSE_ERROR,
        DHT_MSG_GET_DISK_INFO_ERROR,
        DHT_MSG_INVALID_VALUE,
        DHT_MSG_SWITCH_PATTERN_INFO,
        DHT_MSG_SUBVOL_OP_FAILED,
        DHT_MSG_LAYOUT_PRESET_FAILED,
        DHT_MSG_INVALID_LINKFILE,
        DHT_MSG_FIX_LAYOUT_INFO,
        DHT_MSG_GET_HOSTNAME_FAILED,
        DHT_MSG_WRITE_FAILED,
        DHT_MSG_MIGRATE_HARDLINK_FILE_FAILED,
        DHT_MSG_FSYNC_FAILED,
        DHT_MSG_SUBVOL_DECOMMISSION_INFO,
        DHT_MSG_BRICK_QUERY_FAILED,
        DHT_MSG_SUBVOL_NO_LAYOUT_INFO,
        DHT_MSG_OPEN_FD_ON_DST_FAILED,
        DHT_MSG_SUBVOL_NOT_FOUND,
        DHT_MSG_FILE_LOOKUP_ON_DST_FAILED,
        DHT_MSG_DISK_LAYOUT_MISSING,
        DHT_MSG_DICT_GET_FAILED,
        DHT_MSG_REVALIDATE_CBK_INFO,
        DHT_MSG_UPGRADE_BRICKS,
        DHT_MSG_LK_ARRAY_INFO,
        DHT_MSG_RENAME_NOT_LOCAL,
        DHT_MSG_RECONFIGURE_INFO,
        DHT_MSG_INIT_LOCAL_SUBVOL_FAILED,
        DHT_MSG_SYS_CALL_GET_TIME_FAILED,
        DHT_MSG_NO_DISK_USAGE_STATUS,
        DHT_MSG_SUBVOL_DOWN_ERROR,
        DHT_MSG_REBAL_THROTTLE_INFO,
        DHT_MSG_COMMIT_HASH_INFO,
        DHT_MSG_REBAL_STRUCT_SET,
        DHT_MSG_HAS_MIGINFO,
        DHT_MSG_LOG_IPC_TIER_ERROR,
        DHT_MSG_TIER_PAUSED,
        DHT_MSG_TIER_RESUME,
        DHT_MSG_SETTLE_HASH_FAILED,
        DHT_MSG_DEFRAG_PROCESS_DIR_FAILED,
        DHT_MSG_FD_CTX_SET_FAILED,
        DHT_MSG_STALE_LOOKUP,
        DHT_MSG_PARENT_LAYOUT_CHANGED,
        DHT_MSG_LOCK_MIGRATION_FAILED,
        DHT_MSG_LOCK_INODE_UNREF_FAILED,
        DHT_MSG_ASPRINTF_FAILED,
        DHT_MSG_DIR_LOOKUP_FAILED,
        DHT_MSG_INODELK_FAILED,
        DHT_MSG_LOCK_FRAME_FAILED,
        DHT_MSG_LOCAL_LOCK_INIT_FAILED,
        DHT_MSG_ENTRYLK_ERROR,
        DHT_MSG_INODELK_ERROR,
        DHT_MSG_LOC_FAILED,
        DHT_MSG_UNKNOWN_FOP,
        DHT_MSG_MIGRATE_FILE_SKIPPED,
        DHT_MSG_DIR_XATTR_HEAL_FAILED,
        DHT_MSG_HASHED_SUBVOL_DOWN,
        DHT_MSG_NON_HASHED_SUBVOL_DOWN
);

#endif /* _DHT_MESSAGES_H_ */
