/* !---- DO NOT EDIT: This file autogenerated by com\sun\gluegen\JavaEmitter.java on Mon Jul 31 16:26:59 PDT 2006 ----! */

package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;


public class UnixDynamicLinkerImpl implements DynamicLinker {

  public static final long RTLD_DEFAULT = 0;
  public static final int RTLD_LAZY     = 0x00001;
  public static final int RTLD_NOW      = 0x00002;
  public static final int RTLD_GLOBAL   = 0x00100;
  public static final int RTLD_LOCAL    = 0x00000;

  /** Interface to C language function: <br> <code> int dlclose(void * ); </code>    */
  private static native int dlclose(long arg0);

  /** Interface to C language function: <br> <code> char *  dlerror(void); </code>    */
  private static native java.lang.String dlerror();

  /** Interface to C language function: <br> <code> void *  dlopen(const char * , int); </code>    */
  private static native long dlopen(java.lang.String arg0, int arg1);

  /** Interface to C language function: <br> <code> void *  dlsym(void * , const char * ); </code>    */
  private static native long dlsym(long arg0, java.lang.String arg1);


  // --- Begin CustomJavaCode .cfg declarations
  public long openLibraryLocal(String pathname, boolean debug) {
    // Note we use RTLD_GLOBAL visibility to _NOT_ allow this functionality to
    // be used to pre-resolve dependent libraries of JNI code without
    // requiring that all references to symbols in those libraries be
    // looked up dynamically via the ProcAddressTable mechanism; in
    // other words, one can actually link against the library instead of
    // having to dlsym all entry points. System.loadLibrary() uses
    // RTLD_LOCAL visibility so can't be used for this purpose.
    return dlopen(pathname, RTLD_LAZY | RTLD_LOCAL);
  }

  public long openLibraryGlobal(String pathname, boolean debug) {
    // Note we use RTLD_GLOBAL visibility to allow this functionality to
    // be used to pre-resolve dependent libraries of JNI code without
    // requiring that all references to symbols in those libraries be
    // looked up dynamically via the ProcAddressTable mechanism; in
    // other words, one can actually link against the library instead of
    // having to dlsym all entry points. System.loadLibrary() uses
    // RTLD_LOCAL visibility so can't be used for this purpose.
    return dlopen(pathname, RTLD_LAZY | RTLD_GLOBAL);
  }
  
  public long lookupSymbol(long libraryHandle, String symbolName) {
    final long addr = dlsym(libraryHandle, symbolName);
    if(DEBUG_LOOKUP) {
        System.err.println("UnixDynamicLinkerImpl.lookupSymbol(0x"+Long.toHexString(libraryHandle)+", "+symbolName+") -> 0x"+Long.toHexString(addr));
    }
    return addr;    
  }

  public long lookupSymbolGlobal(String symbolName) {
    final long addr = dlsym(RTLD_DEFAULT, symbolName);
    if(DEBUG_LOOKUP) {
        System.err.println("UnixDynamicLinkerImpl.lookupSymbolGlobal("+symbolName+") -> 0x"+Long.toHexString(addr));
    }
    return addr;    
  }
  
  public void closeLibrary(long libraryHandle) {
    dlclose(libraryHandle);
  }
  // ---- End CustomJavaCode .cfg declarations

} // end of class UnixDynamicLinkerImpl
