/*
 *  Copyright (C) 2005  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __Texture__
#define __Texture__

#include "Rect.hxx"
#include <GL/gl.h>

class Texture
{
   friend class TextureLoader;
protected:
   GLuint gl_texture;

public:
   Rect rect; //TODO should be protected
   void Bind(void); //TODO should be protected
   Texture(GLuint _gl_texture)
         :gl_texture(_gl_texture)
   {}
   void Draw(const Rect & src, const Rect & dst);
   void Draw(const Rect & src, const Rect & dst, float angle);
};

#endif

