/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Should be as large as longest string stored in the DB that's returned
 * by a query (see db schema files), plus one for terminating null byte.
 */
#define MAXDBSTR	(250+1)

typedef globus_bool_t	(*db_str1_callback_t) (
  void		*a,
  char		*s);

typedef globus_bool_t	(*db_str2_callback_t) (
  void		*a,
  char		*s1,
  char		*s2);

typedef globus_bool_t	(*db_str3_callback_t) (
  void		*a,
  char		*s1,
  char		*s2,
  char		*s3);

typedef globus_bool_t	(*db_str4_callback_t) (
  void		*a,
  char		*s1,
  char		*s2,
  char		*s3,
  char		*s4);

/*
 * Table information.
 */
typedef struct {
  char			*name;	/* Name of table			*/
  int			nferr;	/* Error when select finds no records	*/
  int			count;	/* Count of records in table		*/
} TABLE;

/*
 * These defines are indexes into table[] array in db.c.
 */
#define T_LRCLFN	0
#define T_LRCPFN	1
#define T_LRCMAP	2
#define T_RLILFN	3
#define T_RLILRC	4
#define T_RLISENDER	5
#define T_RLIMAP	6
#define T_MAX		(T_RLIMAP+1)

void		db_init();
extern int	db_open(char *dbname, char *user, char *pwd,
			int lrcserver, void **hp, char *errmsg);
extern void	db_close(void *hv);
extern int	db_is_alive(void *hv);
extern int	db_update_add(void *hv, char *rli_url, int flags,
			      char *pattern, char *errmsg);
extern int	db_update_delete(void *hv, char *rli_url, char *pattern,
				 char *errmsg);
extern int	db_update_get_part(void *hv, char *rli_url, char *pattern,
				   db_str3_callback_t cb, void *a,
				   char *errmsg);
extern int	db_attr_add(void *hv, char *key, globus_rls_obj_type_t objtype,
			    globus_rls_attr_type_t type, char *name,
			    char *sval, char *errmsg);
extern int	db_attr_create(void *hv, char *name,
			       globus_rls_obj_type_t objtype,
			       globus_rls_attr_type_t type, char *errmsg);
extern int	db_attr_delete(void *hv, char *name,
			       globus_rls_obj_type_t objtype,
			       globus_bool_t clearvalues, char *errmsg);
extern int	db_attr_get(void *hv, char *name,
			    globus_rls_obj_type_t objtype,
			    db_str2_callback_t cb, void *a, char *errmsg);
extern int	db_attr_modify(void *hv, char *key, char *name,
			       globus_rls_obj_type_t objtype,
			       globus_rls_attr_type_t type, char *sval,
			       char *errmsg);
extern int	db_attr_remove(void *hv, char *key, char *name,
			       globus_rls_obj_type_t objtype, char *errmsg);
extern int	db_attr_search(void *hv, char *name,
			globus_rls_obj_type_t objtype, globus_rls_attr_op_t op,
			char *op1, char *op2, int offset, int reslimit,
			db_str3_callback_t cb, void *a, char *errmsg);
extern int	db_attr_value_get(void *hv, char *key, char *name,
				  globus_rls_obj_type_t objtype,
				  db_str3_callback_t cb, void *a, char *errmsg);
extern int	db_attr_value_get_bulk(void *hv, char *key, char *name,
				  globus_rls_obj_type_t objtype,
				  db_str4_callback_t cb, void *a, char *errmsg);
extern int	db_exists(void *hv, char *key, globus_rls_obj_type_t objtype,
			  char *errmsg);
extern int	db_lrc_add(void *hv, char *lfn, char *pfn, char *errmsg);
extern int	db_lrc_renamelfn(void *hv, char *oldname, char *newname, char *errmsg);
extern int	db_lrc_renamepfn(void *hv, char *oldname, char *newname, char *errmsg);
extern int	db_lrc_alllfn(void *hv, db_str1_callback_t cb, void *a,
			      char *errmsg);
extern int	db_lrc_clear(void *hv, char *errmsg);
extern int	db_lrc_create(void *hv, char *lfn, char *pfn, char *errmsg);
extern int	db_lrc_delete(void *hv, char *lfn, char *pfn, int *lfndeleted,
			      char *errmsg);
extern int	db_lrc_getlfn(void *hv, char *pfn, globus_bool_t wc,
			      int offset, int reslimit,
			      db_str2_callback_t cb, void *a, char *errmsg);
extern int	db_lrc_getpfn(void *hv, char *lfn, globus_bool_t wc,
			      int offset, int reslimit,
			      db_str2_callback_t cb, void *a, char *errmsg);
extern int	db_lrc_mapping_exists(void *hv, char *lfn, char *pfn,
				      char *errmsg);
extern int	db_rli_alllfn(void *hv, db_str2_callback_t cb, void *a,
			     char *errmsg);
extern int	db_rli_delete(void *hv, char *lfn, char *lrc, char *sender,
			      int *lfnchanged, char *errmsg);
extern int	db_rli_expire(void *hv, char *sender, time_t rlistaleint,
			      char *errmsg);
extern int	db_rli_getlrc(void *hv, char *lfn, globus_bool_t wc,
			      int offset, int reslimit, db_str2_callback_t cb,
			      void *a, char *errmsg);
extern int	db_rli_mapping_exists(void *hv, char *lfn, char *lrc,
				      char *errmsg);
extern int	db_rli_sender_list(void *hv, db_str2_callback_t cb, void *a,
				  char *errmsg);
extern int	db_rli_update(void *hv, char *lfn, char *lrc, char *sender,
			      char *ts, int *lfnchanged, char *errmsg);
