/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */

/******************************************************************************
globus_duct_control.h

Description:

  globus_duct control API defintions.  This API defines a simple set
  of communication abstractions to allow a set of processes to
  setup communication through a common manager process.

CVS Information:

  $Source: /home/globdev/CVS/globus-packages/duct/control/source/globus_duct_control.h,v $
  $Date: 2005/04/18 21:29:28 $
  $Revision: 1.3 $
  $State: Exp $
  $Author: smartin $
******************************************************************************/

#ifndef GLOBUS_DUCT_CONTROL_H
#define GLOBUS_DUCT_CONTROL_H

/******************************************************************************
			     Include header files
******************************************************************************/

#include "globus_common.h"    /* for globus_list_t and globus_hashtable_t */

#include "globus_duct_common.h"   /* for DUCT control/runtime return codes */

/* #include "globus_duct_runtime.h"  for GLOBUS_DUCT_MAX_MSG_LENGTH */


#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END 
}
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 
EXTERN_C_BEGIN


/******************************************************************************
			       Define constants
******************************************************************************/


/******************************************************************************
				Type definition
******************************************************************************/

typedef struct globus_duct_checkin_port_s {
  globus_nexus_endpointattr_t   epattr;
  globus_nexus_endpoint_t       ep;
  globus_nexus_startpoint_t     sp;
  unsigned short         portno;
  char                 * attach_url;
} globus_duct_checkin_port_t;

struct globus_duct_control_s;

typedef void (*globus_duct_configured_callback_t) (struct globus_duct_control_s * controlp,
					    int              size, 
					    void           * userdata);

typedef struct globus_duct_control_s {
  globus_mutex_t       mutex;
     
  int                  size;
  globus_list_t      * checkins;
  int                  next_free_addr;
  int                  aborted;
  int                  abort_reason;


  globus_duct_configured_callback_t   callback;
  void                              * callback_userdata;
  
  globus_duct_checkin_port_t checkin_port;
} globus_duct_control_t;


/******************************************************************************
			      Function prototypes
******************************************************************************/

extern int 
globus_duct_control_activate (void);

extern int
globus_duct_control_deactivate (void);

extern globus_module_descriptor_t globus_duct_control_module;

#define GLOBUS_DUCT_CONTROL_MODULE (&globus_duct_control_module)


/*
 * prepare to control a new group of size 'size'
 *   size > 0: coordinate exactly size members
 *   size = 0: size will be provided by subsequent set_groupsize operation
 *   size < 0: reserved for future use
 * report asynchronous group configuration by calling 'callback'
 */
extern int
globus_duct_control_init (globus_duct_control_t             * controlp,
			  int                                 size,
			  globus_duct_configured_callback_t   callback,
			  void                              * callback_userdata);


/*
 * set size for an already created control
 */
extern int 
globus_duct_control_set_groupsize (globus_duct_control_t * controlp,
				   int                     size);

/*
 * create a linearized startpoint 'contact' for this control
 */
extern int 
globus_duct_control_contact_lsp (globus_duct_control_t  * controlp,
				 char                  ** contact);

/*
 * create an attachment contact for this control
 */
extern int 
globus_duct_control_contact_url (globus_duct_control_t  * controlp,
				 char                  ** contact);

/* 
 * tell known group members there was an error
 */
extern void
globus_duct_control_abort (globus_duct_control_t * controlp,
			   int abort_reason);


/*
 * tear down a group controller
 * (no notification of group members)
 */
extern void 
globus_duct_control_destroy (globus_duct_control_t * controlp);


EXTERN_C_END

#endif /* GLOBUS_DUCT_CONTROL_H */

