import sre
import style12

import socket
import select

PROMPT          = 'fics% '
PROMPT_LOGIN    = 'login: '
LINE_GUEST_NAME = 'Press return to enter the server as "'

class Decoder:
    """
    """
    
    buffer = ''
    
    def __init__(self):
        """
        """
        self.announcePattern = sre.compile('(.+) [(](.{4})[)] seeking (\d+) (\d+) (\w+) (\w+)(.*) [(]"play (\d+)" to respond[)]')
        self.chatPattern = sre.compile('(.+) [(](.{4})[)] seeking (\d+) (\d+) (\w+) (\w+)(.*) [(]"play (\d+)" to respond[)]')
        self.movePattern = sre.compile('<12> ([prnbqkPRNBQK-]{8}{8}) ([BW]{1}) ([-]?\d+) ([01]{1}) ([01]{1}) ([01]{1}) ([01]{1}) (\d+) (\d+) (.*) (.*) ([-]?\d+)')

    def onLogin(self):
        """
        """
        pass
    
    def onPrompt(self):
        """
        """
        pass
    
    def onNameAssign(self, name):
        """
        """
        pass
    
    def onAnnounce(self, gameId, player, playerRating, a, b, gameRating, gameType, options):
        """
        """
        pass
    
    def parseLine(self, line):
        """
        """
        print '>> ' + repr(line)
        if line.startswith(LINE_GUEST_NAME):
            name = line[len(LINE_GUEST_NAME):-2]
            return (self.onNameAssign, (name,))
        
        # Look for announces
        result = self.announcePattern.findall(line)
        if len(result) == 0:
            return (None, None)
        
        (player, playerRating, a, b, gameRating, gameType, options, gameId) = result[0]
        return (self.onAnnounce, (gameId, player, playerRating, a, b, gameRating, gameType, options))
    
    def parsePrompt(self, line):
        """
        """
        if line == PROMPT_LOGIN:
            return (self.onLogin, ())
        elif line == PROMPT:
            return (self.onPrompt, ())
        return (None, None)
    
    def registerIncomingData(self, data):
        """
        """
        self.buffer += data
        
        callbacks = []
        while True:
            index = self.buffer.find('\n\r')
            if index < 0:
                break
            
            line = self.buffer[:index]
            self.buffer = self.buffer[index+2:]
            (callback, data) = self.parseLine(line)
            if callback is not None:
                callbacks.append((callback, data))

        (callback, data) = self.parsePrompt(self.buffer)
        if callback is not None:
            callbacks.append((callback, data))
            
        for (callback, data) in callbacks:
            callback(*data)

class P(Decoder):

    sentStyle = False
    
    def __init__(self):
        Decoder.__init__(self)
        self.s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.s.connect(('freechess.org', 23))
        
    def send(self, data):
        self.s.send(data)
        
    def onLogin(self):
        self.send('guest\n')
        
    def onPrompt(self):
        if not self.sendStyle:
            self.send('style 12\n')
            self.sendStyle = True

    def onNameAssign(self, name):
        print 'Assigned name: ' + repr(name)
        self.send('\n')
        
    def onAnnounce(self, gameId, player, playerRating, a, b, gameRating, gameType, options):
        print 'ANNOUNCE: PLAYER=' + player + ' (' + gameId + ')'

    def run(self):
        while True:
            (data, address) = self.s.recvfrom(65535)
            self.registerIncomingData(data)

        
p = P()
p.run()
