/*
  Glaurung, a UCI chess playing engine.
  Copyright (C) 2004-2007 Tord Romstad

  Glaurung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  Glaurung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#if !defined(UNDOINFO_H_INCLUDED)
#define UNDOINFO_H_INCLUDED

////
//// Includes
////

#include "bitboard.h"
#include "castle.h"
#include "move.h"
#include "piece.h"
#include "square.h"
#include "types.h"
#include "value.h"


////
//// Types
////

/// The UndoInfo class stores information we need to restore a Position
/// object to its previous state when we retract a move.  Whenever a move
/// is made on the board (by calling Position::do_move), an UndoInfo object
/// must be passed as a parameter.  When the move is unmade (by calling
/// Position::undo_move), the same UndoInfo object must be passed again.

class UndoInfo {

  friend class Position;

private:
  CastleRights castleRights;
  Square epSquare;
  Bitboard checkersBB;
  Key key, pawnKey, materialKey;
  int rule50;
  Move lastMove;
  PieceType capture;
  Value mgValue, egValue;
};


#endif // !defined(UNDOINFO_H_INCLUDED)
