#include <gtk/gtk.h>

#include "gkdial.h"
#include "defines.h"
#include "details.h"
#include "prefs.h"
#include "images.h"
#include "main_loop.h"

gboolean
tray_icon_clicked (GtkWidget * w, GdkEventButton * event, gpointer data)
{
  GkDial *gkdial = (GkDial *) data;
  GtkWidget *window_to_handle;

  if (gkdial->state == CONNECTING || gkdial->state == CONNECTED)
    window_to_handle = gkdial->details_window;
  else
    window_to_handle = gkdial->main_window;

  if (event->button != 3)
    {
      if (GTK_WIDGET_VISIBLE (window_to_handle))
	gtk_widget_hide (window_to_handle);
      else
	gtk_widget_show (window_to_handle);
      return TRUE;
    }
  else
    {
      return FALSE;
    }
}

typedef struct _MenuItem MenuItem;
struct _MenuItem
{
  char *name;
  char *icon;
  GCallback callback;
};

void
tray_exit_cb (GtkWidget * w, gpointer data)
{
  gtk_main_quit ();
}

GtkWidget *
tray_menu_init (GkDial * gkdial)
{
  MenuItem menuitems[] = {
    {N_("_Preferences"), GTK_STOCK_PREFERENCES,
     G_CALLBACK (gkdial_prefs_show)},
    {N_("Co_nnect"), GTK_STOCK_YES, G_CALLBACK (gk_connect)},
    {N_("Di_sconnect"), GTK_STOCK_NO, G_CALLBACK (gk_disconnect)},
    {N_("E_xit"), GTK_STOCK_CLOSE, G_CALLBACK (tray_exit_cb)},
    {NULL, NULL, NULL}
  };

  GtkWidget *menu;
  int i;

  menu = gtk_menu_new ();
  for (i = 0; menuitems[i].name != NULL; i++)
    {
      GtkWidget *item, *image;

      item = gtk_image_menu_item_new_with_mnemonic (_(menuitems[i].name));
      if (menuitems[i].icon != NULL)
	{
	  image = gtk_image_new_from_stock (menuitems[i].icon,
					    GTK_ICON_SIZE_MENU);

	  if (image != NULL)
	    {
	      gtk_widget_show (image);
	      gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item),
					     image);
	    }
	}

      gtk_widget_show (item);

      if (menuitems[i].callback == G_CALLBACK (gk_connect))
	gkdial->menu_item_connect = item;
      else if (menuitems[i].callback == G_CALLBACK (gk_disconnect))
	{
	  gkdial->menu_item_disconnect = item;
	  gtk_widget_hide (gkdial->menu_item_disconnect);
	}
      else if (menuitems[i].callback == G_CALLBACK (gkdial_prefs_show))
	gkdial->menu_item_prefs = item;

      gtk_menu_shell_append ((GtkMenuShell *) (menu), item);
      if (menuitems[i].callback != NULL)
	{
	  g_signal_connect (G_OBJECT (item), "activate",
			    G_CALLBACK (menuitems[i].callback), gkdial);
	}
    }

  return menu;
}

void
gkdial_tray_init (GkDial * gkdial)
{
  GtkWidget *box;
  GdkPixbuf *pixbuf;

  gkdial->tray = GTK_WIDGET (egg_tray_icon_new ("GkDial Tray Icon"));

  box = gtk_event_box_new ();
  g_signal_connect (G_OBJECT (box), "button_press_event",
		    G_CALLBACK (tray_icon_clicked), gkdial);
  gtk_container_add (GTK_CONTAINER (gkdial->tray), box);

  gkdial->tray_icon = gtk_image_new_from_pixbuf (gkdial->pixbuf_ppp_off);
  gtk_container_add (GTK_CONTAINER (box), gkdial->tray_icon);

  /*
   * from gnome-cd gcd->tray_tips = gtk_tooltips_new ();
   * gtk_tooltips_set_tip (GTK_TOOLTIPS(gcd->tray_tips), gcd->tray,
   * _("CD Player"), NULL); 
   */

  gnome_popup_menu_attach (tray_menu_init (gkdial), box, NULL);

}
