%define prefix /usr

Summary: Japanese dictionary for GNOME.
Name: gjiten
Version: 2.5
Release: 1
License: GPL
Group: Productivity/Office/Dictionary
Group: X11/Applications
Source: gjiten-2.5.tar.gz
BuildRoot: /var/tmp/gjiten-2.5-root
Packager: Botond Botyanszki <b0ti@users.sourceforge.net>
URL: http://gjiten.sourceforge.net

%description
Gjiten is a Japanese dictionary program for GNOME. It also has a kanji dictionary; 
any combination of stroke number, radicals and search key can be used for kanji lookups. 
Requires dictionary files in edict format and a working X Input Method [eg. kinput2] for Japanese input.

See http://gjiten.sourceforge.net for dictionary files and updates.

%prep
%setup
%build
export GCONF_SCHEMA_FILE_DIR=%{_sysconfdir}/gconf/schemas
./configure --prefix=%prefix \
	    --mandir=%{_mandir}
make

%install
export GCONF_SCHEMA_FILE_DIR=%{_sysconfdir}/gconf/schemas
if [ -d $RPM_BUILD_ROOT ] ; then rm -rf $RPM_BUILD_ROOT; fi
mkdir $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="gjiten.schemas gjiten-dicfiles.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S >/dev/nulldone
done
update-desktop-database %{_datadir}/applications

%postun
#FIXME uninstall schema
update-desktop-database %{_datadir}/applications

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc README COPYING TODO AUTHORS INSTALL NEWS ChangeLog
%{prefix}/bin/*
%{prefix}/share/*
%{_sysconfdir}/gconf/schemas/*
%{_mandir}/man1/*
