module Projects
  module ImportExport
    class ExportService < BaseService

      def execute(_options = {})
        @shared = Gitlab::ImportExport::Shared.new(relative_path: File.join(project.path_with_namespace, 'work'))
        save_all
      end

      private

      def save_all
        if [version_saver, project_tree_saver, uploads_saver, repo_saver, wiki_repo_saver].all?(&:save)
          Gitlab::ImportExport::Saver.save(shared: @shared)
          notify_success
        else
          cleanup_and_notify
        end
      end

      def version_saver
        Gitlab::ImportExport::VersionSaver.new(shared: @shared)
      end

      def project_tree_saver
        Gitlab::ImportExport::ProjectTreeSaver.new(project: project, shared: @shared)
      end

      def uploads_saver
        Gitlab::ImportExport::UploadsSaver.new(project: project, shared: @shared)
      end

      def repo_saver
        Gitlab::ImportExport::RepoSaver.new(project: project, shared: @shared)
      end

      def wiki_repo_saver
        Gitlab::ImportExport::WikiRepoSaver.new(project: project, shared: @shared)
      end

      def cleanup_and_notify
        FileUtils.rm_rf(@shared.export_path)

        notify_error
        raise Gitlab::ImportExport::Error.new(@shared.errors.join(', '))
      end

      def notify_success
        notification_service.project_exported(@project, @current_user)
      end

      def notify_error
        notification_service.project_not_exported(@project, @current_user, @shared.errors)
      end
    end
  end
end
