#! /bin/sh
# Read configuration values	
. /etc/gitlab/gitlab-debian.conf

echo "Initializing database..."
su ${gitlab_user} -s /bin/sh -c 'bundle exec rake gitlab:setup RAILS_ENV=production force=yes'
su ${gitlab_user} -s /bin/sh -c 'bundle exec rake gitlab:shell:install \
REDIS_URL=redis://localhost:6379 \
SHELL_ROOT_PATH=/usr/share/gitlab-shell RAILS_ENV=production'
echo "Precompiling assets..."
su ${gitlab_user} -s /bin/sh -c 'bundle exec rake assets:precompile RAILS_ENV=production'

# Start gitlab
invoke-rc.d gitlab start

# Check gitlab is configured correctly
su ${gitlab_user} -s /bin/sh -c 'bundle exec rake gitlab:check RAILS_ENV=production'

