#! /bin/sh

set -e

# Read and export debian specific configuration
# Only exported variables will be passed on to gitlab app
export $(cat /etc/gitlab/gitlab-debian.conf)
cd /usr/share/gitlab

# Check if the db is already present
if [ "$(LANG=C su postgres -c "psql gitlab_production -c \"\d\"")" = \
"No relations found." ]; then
  echo "Initializing database..."
  test -f ${gitlab_home}/db/schema.rb || \
  su ${gitlab_user} -s /bin/sh -c\
  "cp ${gitlab_data_dir}/db/schema.rb.template ${gitlab_data_dir}/db/schema.rb"
  su ${gitlab_user} -s /bin/sh -c 'bundle exec rake db:schema:load'
  su ${gitlab_user} -s /bin/sh -c 'bundle exec rake db:seed_fu'
else
  echo "gitlab_production database is not empty, skipping gitlab setup"
  su ${gitlab_user} -s /bin/sh -c 'bundle exec rake db:migrate'
fi

# Restrict permissions for secret files
chmod 0700 ${gitlab_data_dir}/.gitlab_shell_secret

echo "Precompiling assets..."
su ${gitlab_user} -s /bin/sh -c 'bundle exec rake tmp:cache:clear assets:precompile RAILS_ENV=production'
