// Code generated by protoc-gen-go. DO NOT EDIT.
// source: diff.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type CommitDiffRequest struct {
	Repository             *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId           string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId          string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
	IgnoreWhitespaceChange bool        `protobuf:"varint,4,opt,name=ignore_whitespace_change,json=ignoreWhitespaceChange" json:"ignore_whitespace_change,omitempty"`
	Paths                  [][]byte    `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	CollapseDiffs          bool        `protobuf:"varint,6,opt,name=collapse_diffs,json=collapseDiffs" json:"collapse_diffs,omitempty"`
	EnforceLimits          bool        `protobuf:"varint,7,opt,name=enforce_limits,json=enforceLimits" json:"enforce_limits,omitempty"`
	MaxFiles               int32       `protobuf:"varint,8,opt,name=max_files,json=maxFiles" json:"max_files,omitempty"`
	MaxLines               int32       `protobuf:"varint,9,opt,name=max_lines,json=maxLines" json:"max_lines,omitempty"`
	MaxBytes               int32       `protobuf:"varint,10,opt,name=max_bytes,json=maxBytes" json:"max_bytes,omitempty"`
	SafeMaxFiles           int32       `protobuf:"varint,11,opt,name=safe_max_files,json=safeMaxFiles" json:"safe_max_files,omitempty"`
	SafeMaxLines           int32       `protobuf:"varint,12,opt,name=safe_max_lines,json=safeMaxLines" json:"safe_max_lines,omitempty"`
	SafeMaxBytes           int32       `protobuf:"varint,13,opt,name=safe_max_bytes,json=safeMaxBytes" json:"safe_max_bytes,omitempty"`
}

func (m *CommitDiffRequest) Reset()                    { *m = CommitDiffRequest{} }
func (m *CommitDiffRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitDiffRequest) ProtoMessage()               {}
func (*CommitDiffRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *CommitDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetIgnoreWhitespaceChange() bool {
	if m != nil {
		return m.IgnoreWhitespaceChange
	}
	return false
}

func (m *CommitDiffRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *CommitDiffRequest) GetCollapseDiffs() bool {
	if m != nil {
		return m.CollapseDiffs
	}
	return false
}

func (m *CommitDiffRequest) GetEnforceLimits() bool {
	if m != nil {
		return m.EnforceLimits
	}
	return false
}

func (m *CommitDiffRequest) GetMaxFiles() int32 {
	if m != nil {
		return m.MaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxLines() int32 {
	if m != nil {
		return m.MaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxBytes() int32 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxFiles() int32 {
	if m != nil {
		return m.SafeMaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxLines() int32 {
	if m != nil {
		return m.SafeMaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxBytes() int32 {
	if m != nil {
		return m.SafeMaxBytes
	}
	return 0
}

// A CommitDiffResponse corresponds to a single changed file in a commit.
type CommitDiffResponse struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId       string `protobuf:"bytes,3,opt,name=from_id,json=fromId" json:"from_id,omitempty"`
	ToId         string `protobuf:"bytes,4,opt,name=to_id,json=toId" json:"to_id,omitempty"`
	OldMode      int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode" json:"old_mode,omitempty"`
	NewMode      int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode" json:"new_mode,omitempty"`
	Binary       bool   `protobuf:"varint,7,opt,name=binary" json:"binary,omitempty"`
	RawPatchData []byte `protobuf:"bytes,9,opt,name=raw_patch_data,json=rawPatchData,proto3" json:"raw_patch_data,omitempty"`
	EndOfPatch   bool   `protobuf:"varint,10,opt,name=end_of_patch,json=endOfPatch" json:"end_of_patch,omitempty"`
	// Indicates the diff file at which we overflow according to the limitations sent,
	// in which case only this attribute will be set.
	OverflowMarker bool `protobuf:"varint,11,opt,name=overflow_marker,json=overflowMarker" json:"overflow_marker,omitempty"`
	Collapsed      bool `protobuf:"varint,12,opt,name=collapsed" json:"collapsed,omitempty"`
}

func (m *CommitDiffResponse) Reset()                    { *m = CommitDiffResponse{} }
func (m *CommitDiffResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitDiffResponse) ProtoMessage()               {}
func (*CommitDiffResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *CommitDiffResponse) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDiffResponse) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDiffResponse) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDiffResponse) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDiffResponse) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDiffResponse) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

func (m *CommitDiffResponse) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

func (m *CommitDiffResponse) GetRawPatchData() []byte {
	if m != nil {
		return m.RawPatchData
	}
	return nil
}

func (m *CommitDiffResponse) GetEndOfPatch() bool {
	if m != nil {
		return m.EndOfPatch
	}
	return false
}

func (m *CommitDiffResponse) GetOverflowMarker() bool {
	if m != nil {
		return m.OverflowMarker
	}
	return false
}

func (m *CommitDiffResponse) GetCollapsed() bool {
	if m != nil {
		return m.Collapsed
	}
	return false
}

type CommitDeltaRequest struct {
	Repository    *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	LeftCommitId  string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId" json:"left_commit_id,omitempty"`
	RightCommitId string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId" json:"right_commit_id,omitempty"`
	Paths         [][]byte    `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (m *CommitDeltaRequest) Reset()                    { *m = CommitDeltaRequest{} }
func (m *CommitDeltaRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitDeltaRequest) ProtoMessage()               {}
func (*CommitDeltaRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *CommitDeltaRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDeltaRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type CommitDelta struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId  string `protobuf:"bytes,3,opt,name=from_id,json=fromId" json:"from_id,omitempty"`
	ToId    string `protobuf:"bytes,4,opt,name=to_id,json=toId" json:"to_id,omitempty"`
	OldMode int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode" json:"old_mode,omitempty"`
	NewMode int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode" json:"new_mode,omitempty"`
}

func (m *CommitDelta) Reset()                    { *m = CommitDelta{} }
func (m *CommitDelta) String() string            { return proto.CompactTextString(m) }
func (*CommitDelta) ProtoMessage()               {}
func (*CommitDelta) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *CommitDelta) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDelta) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDelta) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDelta) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDelta) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDelta) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

type CommitDeltaResponse struct {
	Deltas []*CommitDelta `protobuf:"bytes,1,rep,name=deltas" json:"deltas,omitempty"`
}

func (m *CommitDeltaResponse) Reset()                    { *m = CommitDeltaResponse{} }
func (m *CommitDeltaResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitDeltaResponse) ProtoMessage()               {}
func (*CommitDeltaResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *CommitDeltaResponse) GetDeltas() []*CommitDelta {
	if m != nil {
		return m.Deltas
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitDiffRequest)(nil), "gitaly.CommitDiffRequest")
	proto.RegisterType((*CommitDiffResponse)(nil), "gitaly.CommitDiffResponse")
	proto.RegisterType((*CommitDeltaRequest)(nil), "gitaly.CommitDeltaRequest")
	proto.RegisterType((*CommitDelta)(nil), "gitaly.CommitDelta")
	proto.RegisterType((*CommitDeltaResponse)(nil), "gitaly.CommitDeltaResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DiffService service

type DiffServiceClient interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error)
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error)
}

type diffServiceClient struct {
	cc *grpc.ClientConn
}

func NewDiffServiceClient(cc *grpc.ClientConn) DiffServiceClient {
	return &diffServiceClient{cc}
}

func (c *diffServiceClient) CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[0], c.cc, "/gitaly.DiffService/CommitDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDiffClient interface {
	Recv() (*CommitDiffResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDiffClient) Recv() (*CommitDiffResponse, error) {
	m := new(CommitDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DiffService_serviceDesc.Streams[1], c.cc, "/gitaly.DiffService/CommitDelta", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDeltaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDeltaClient interface {
	Recv() (*CommitDeltaResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDeltaClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDeltaClient) Recv() (*CommitDeltaResponse, error) {
	m := new(CommitDeltaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for DiffService service

type DiffServiceServer interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(*CommitDiffRequest, DiffService_CommitDiffServer) error
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(*CommitDeltaRequest, DiffService_CommitDeltaServer) error
}

func RegisterDiffServiceServer(s *grpc.Server, srv DiffServiceServer) {
	s.RegisterService(&_DiffService_serviceDesc, srv)
}

func _DiffService_CommitDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDiff(m, &diffServiceCommitDiffServer{stream})
}

type DiffService_CommitDiffServer interface {
	Send(*CommitDiffResponse) error
	grpc.ServerStream
}

type diffServiceCommitDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDiffServer) Send(m *CommitDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitDelta_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDeltaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDelta(m, &diffServiceCommitDeltaServer{stream})
}

type DiffService_CommitDeltaServer interface {
	Send(*CommitDeltaResponse) error
	grpc.ServerStream
}

type diffServiceCommitDeltaServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDeltaServer) Send(m *CommitDeltaResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DiffService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.DiffService",
	HandlerType: (*DiffServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "CommitDiff",
			Handler:       _DiffService_CommitDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitDelta",
			Handler:       _DiffService_CommitDelta_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "diff.proto",
}

func init() { proto.RegisterFile("diff.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 629 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x94, 0xcf, 0x6e, 0xdb, 0x38,
	0x10, 0xc6, 0x57, 0xb1, 0xad, 0xc8, 0x63, 0x25, 0xd9, 0x65, 0x16, 0x59, 0xc5, 0xd9, 0x83, 0x60,
	0xf4, 0x8f, 0x81, 0x02, 0x41, 0xe1, 0x5e, 0x7a, 0x4e, 0x82, 0x16, 0x09, 0x12, 0x34, 0x50, 0x0f,
	0x3d, 0x0a, 0x8c, 0x38, 0xb2, 0x88, 0x4a, 0xa2, 0x4b, 0xb2, 0x71, 0xfc, 0x3a, 0xbd, 0xf4, 0xd2,
	0x37, 0xea, 0xab, 0xf4, 0x50, 0x90, 0xb4, 0x64, 0xb9, 0xc8, 0x03, 0xe4, 0x38, 0xdf, 0xef, 0xd3,
	0xcc, 0x68, 0x86, 0x24, 0x00, 0xe3, 0x79, 0x7e, 0xba, 0x90, 0x42, 0x0b, 0xe2, 0xcf, 0xb9, 0xa6,
	0xe5, 0x6a, 0x1c, 0xaa, 0x82, 0x4a, 0x64, 0x4e, 0x9d, 0xfc, 0xea, 0xc1, 0x3f, 0xe7, 0xa2, 0xaa,
	0xb8, 0xbe, 0xe0, 0x79, 0x9e, 0xe0, 0x97, 0xaf, 0xa8, 0x34, 0x99, 0x01, 0x48, 0x5c, 0x08, 0xc5,
	0xb5, 0x90, 0xab, 0xc8, 0x8b, 0xbd, 0xe9, 0x68, 0x46, 0x4e, 0x5d, 0x82, 0xd3, 0xa4, 0x25, 0x49,
	0xc7, 0x45, 0x9e, 0xc1, 0x7e, 0x89, 0xb9, 0x4e, 0x33, 0x9b, 0x2d, 0xe5, 0x2c, 0xda, 0x89, 0xbd,
	0xe9, 0x30, 0x09, 0x8d, 0xea, 0x4a, 0x5c, 0x32, 0xf2, 0x02, 0x0e, 0x24, 0x9f, 0x17, 0x5d, 0x5b,
	0xcf, 0xda, 0xf6, 0xac, 0xdc, 0xfa, 0xde, 0x42, 0xc4, 0xe7, 0xb5, 0x90, 0x98, 0x2e, 0x0b, 0xae,
	0x51, 0x2d, 0x68, 0x86, 0x69, 0x56, 0xd0, 0x7a, 0x8e, 0x51, 0x3f, 0xf6, 0xa6, 0x41, 0x72, 0xe4,
	0xf8, 0xa7, 0x16, 0x9f, 0x5b, 0x4a, 0xfe, 0x85, 0xc1, 0x82, 0xea, 0x42, 0x45, 0x83, 0xb8, 0x37,
	0x0d, 0x13, 0x17, 0x90, 0xe7, 0xb0, 0x9f, 0x89, 0xb2, 0xa4, 0x0b, 0x85, 0xa9, 0x19, 0x8a, 0x8a,
	0x7c, 0x9b, 0x65, 0xaf, 0x51, 0xcd, 0xef, 0x5b, 0x1b, 0xd6, 0xb9, 0x90, 0x19, 0xa6, 0x25, 0xaf,
	0xb8, 0x56, 0xd1, 0xae, 0xb3, 0xad, 0xd5, 0x6b, 0x2b, 0x92, 0x13, 0x18, 0x56, 0xf4, 0x21, 0xcd,
	0x79, 0x89, 0x2a, 0x0a, 0x62, 0x6f, 0x3a, 0x48, 0x82, 0x8a, 0x3e, 0xbc, 0x33, 0x71, 0x03, 0x4b,
	0x5e, 0xa3, 0x8a, 0x86, 0x2d, 0xbc, 0x36, 0x71, 0x03, 0xef, 0x56, 0x1a, 0x55, 0x04, 0x2d, 0x3c,
	0x33, 0xb1, 0x19, 0xa1, 0xa2, 0x39, 0xa6, 0x9b, 0xdc, 0x23, 0xeb, 0x08, 0x8d, 0x7a, 0xd3, 0xe4,
	0xef, 0xba, 0x5c, 0x91, 0x70, 0xcb, 0xe5, 0x0a, 0x75, 0x5d, 0xae, 0xda, 0xde, 0x96, 0xcb, 0x56,
	0x9c, 0xfc, 0xdc, 0x01, 0xd2, 0x5d, 0xbf, 0x5a, 0x88, 0x5a, 0xa1, 0xe9, 0x32, 0x97, 0xa2, 0x4a,
	0xcd, 0xec, 0xec, 0xfa, 0xc3, 0x24, 0x30, 0xc2, 0x2d, 0xd5, 0x05, 0xf9, 0x0f, 0x76, 0xb5, 0x70,
	0x68, 0xc7, 0x22, 0x5f, 0x8b, 0x06, 0xd8, 0xaf, 0xda, 0x9d, 0xfa, 0x26, 0xbc, 0x64, 0xe4, 0x10,
	0x06, 0x5a, 0x18, 0xb9, 0x6f, 0xe5, 0xbe, 0x16, 0x97, 0x8c, 0x1c, 0x43, 0x20, 0x4a, 0x96, 0x56,
	0x82, 0x61, 0x34, 0xb0, 0xad, 0xed, 0x8a, 0x92, 0xdd, 0x08, 0x86, 0x06, 0xd5, 0xb8, 0x74, 0xc8,
	0x77, 0xa8, 0xc6, 0xa5, 0x45, 0x47, 0xe0, 0xdf, 0xf1, 0x9a, 0xca, 0xd5, 0x7a, 0x31, 0xeb, 0xc8,
	0xfc, 0xae, 0xa4, 0x4b, 0xd3, 0x55, 0x56, 0xa4, 0x8c, 0x6a, 0x6a, 0x27, 0x1f, 0x26, 0xa1, 0xa4,
	0xcb, 0x5b, 0x23, 0x5e, 0x50, 0x4d, 0x49, 0x0c, 0x21, 0xd6, 0x2c, 0x15, 0xb9, 0x33, 0xda, 0x05,
	0x04, 0x09, 0x60, 0xcd, 0x3e, 0xe4, 0xd6, 0x45, 0x5e, 0xc2, 0x81, 0xb8, 0x47, 0x99, 0x97, 0x62,
	0x99, 0x56, 0x54, 0x7e, 0x46, 0x69, 0x77, 0x10, 0x24, 0xfb, 0x8d, 0x7c, 0x63, 0x55, 0xf2, 0x3f,
	0x0c, 0x9b, 0xa3, 0xc3, 0xec, 0x02, 0x82, 0x64, 0x23, 0x5c, 0xf5, 0x83, 0xe0, 0xef, 0xe1, 0xe4,
	0x87, 0xd7, 0x4e, 0x17, 0x4b, 0x4d, 0x9f, 0xce, 0xed, 0x6a, 0xef, 0x48, 0xbf, 0x73, 0x47, 0x26,
	0xdf, 0x3d, 0x18, 0x75, 0xda, 0x7d, 0xba, 0xa7, 0x60, 0x72, 0x06, 0x87, 0x5b, 0x73, 0x5d, 0x1f,
	0xdb, 0x57, 0xe0, 0x33, 0x23, 0xa8, 0xc8, 0x8b, 0x7b, 0xd3, 0xd1, 0xec, 0xb0, 0x19, 0x6a, 0xd7,
	0xbc, 0xb6, 0xcc, 0xbe, 0x79, 0x30, 0x32, 0x87, 0xfe, 0x23, 0xca, 0x7b, 0x9e, 0x21, 0x79, 0x0f,
	0xb0, 0xb9, 0x09, 0xe4, 0xf8, 0x8f, 0x4f, 0x37, 0x8f, 0xe3, 0x78, 0xfc, 0x18, 0x72, 0x1d, 0x4c,
	0xfe, 0x7a, 0xed, 0x91, 0xab, 0xed, 0x29, 0x8e, 0x1f, 0x6b, 0x62, 0x9d, 0xea, 0xe4, 0x51, 0xb6,
	0xc9, 0x75, 0xe7, 0xdb, 0x57, 0xfa, 0xcd, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2a, 0x75, 0x5b,
	0xf9, 0xc9, 0x05, 0x00, 0x00,
}
