// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commit.proto

package gitaly

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type TreeEntryResponse_ObjectType int32

const (
	TreeEntryResponse_COMMIT TreeEntryResponse_ObjectType = 0
	TreeEntryResponse_BLOB   TreeEntryResponse_ObjectType = 1
	TreeEntryResponse_TREE   TreeEntryResponse_ObjectType = 2
	TreeEntryResponse_TAG    TreeEntryResponse_ObjectType = 3
)

var TreeEntryResponse_ObjectType_name = map[int32]string{
	0: "COMMIT",
	1: "BLOB",
	2: "TREE",
	3: "TAG",
}
var TreeEntryResponse_ObjectType_value = map[string]int32{
	"COMMIT": 0,
	"BLOB":   1,
	"TREE":   2,
	"TAG":    3,
}

func (x TreeEntryResponse_ObjectType) String() string {
	return proto.EnumName(TreeEntryResponse_ObjectType_name, int32(x))
}
func (TreeEntryResponse_ObjectType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{5, 0}
}

type TreeEntry_EntryType int32

const (
	TreeEntry_BLOB   TreeEntry_EntryType = 0
	TreeEntry_TREE   TreeEntry_EntryType = 1
	TreeEntry_COMMIT TreeEntry_EntryType = 3
)

var TreeEntry_EntryType_name = map[int32]string{
	0: "BLOB",
	1: "TREE",
	3: "COMMIT",
}
var TreeEntry_EntryType_value = map[string]int32{
	"BLOB":   0,
	"TREE":   1,
	"COMMIT": 3,
}

func (x TreeEntry_EntryType) String() string {
	return proto.EnumName(TreeEntry_EntryType_name, int32(x))
}
func (TreeEntry_EntryType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{10, 0} }

type FindAllCommitsRequest_Order int32

const (
	FindAllCommitsRequest_NONE FindAllCommitsRequest_Order = 0
	FindAllCommitsRequest_TOPO FindAllCommitsRequest_Order = 1
	FindAllCommitsRequest_DATE FindAllCommitsRequest_Order = 2
)

var FindAllCommitsRequest_Order_name = map[int32]string{
	0: "NONE",
	1: "TOPO",
	2: "DATE",
}
var FindAllCommitsRequest_Order_value = map[string]int32{
	"NONE": 0,
	"TOPO": 1,
	"DATE": 2,
}

func (x FindAllCommitsRequest_Order) String() string {
	return proto.EnumName(FindAllCommitsRequest_Order_name, int32(x))
}
func (FindAllCommitsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{17, 0}
}

type CommitStatsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitStatsRequest) Reset()                    { *m = CommitStatsRequest{} }
func (m *CommitStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsRequest) ProtoMessage()               {}
func (*CommitStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *CommitStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitStatsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitStatsResponse struct {
	// OID is the commit. Empty means not found
	Oid       string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	Additions int32  `protobuf:"varint,2,opt,name=additions" json:"additions,omitempty"`
	Deletions int32  `protobuf:"varint,3,opt,name=deletions" json:"deletions,omitempty"`
}

func (m *CommitStatsResponse) Reset()                    { *m = CommitStatsResponse{} }
func (m *CommitStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsResponse) ProtoMessage()               {}
func (*CommitStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *CommitStatsResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *CommitStatsResponse) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *CommitStatsResponse) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

type CommitIsAncestorRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	AncestorId string      `protobuf:"bytes,2,opt,name=ancestor_id,json=ancestorId" json:"ancestor_id,omitempty"`
	ChildId    string      `protobuf:"bytes,3,opt,name=child_id,json=childId" json:"child_id,omitempty"`
}

func (m *CommitIsAncestorRequest) Reset()                    { *m = CommitIsAncestorRequest{} }
func (m *CommitIsAncestorRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorRequest) ProtoMessage()               {}
func (*CommitIsAncestorRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *CommitIsAncestorRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitIsAncestorRequest) GetAncestorId() string {
	if m != nil {
		return m.AncestorId
	}
	return ""
}

func (m *CommitIsAncestorRequest) GetChildId() string {
	if m != nil {
		return m.ChildId
	}
	return ""
}

type CommitIsAncestorResponse struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *CommitIsAncestorResponse) Reset()                    { *m = CommitIsAncestorResponse{} }
func (m *CommitIsAncestorResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorResponse) ProtoMessage()               {}
func (*CommitIsAncestorResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CommitIsAncestorResponse) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type TreeEntryRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// commit ID or refname
	Revision []byte `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	// entry path relative to repository root
	Path  []byte `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Limit int64  `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *TreeEntryRequest) Reset()                    { *m = TreeEntryRequest{} }
func (m *TreeEntryRequest) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryRequest) ProtoMessage()               {}
func (*TreeEntryRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *TreeEntryRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *TreeEntryRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *TreeEntryRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntryRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type TreeEntryResponse struct {
	Type TreeEntryResponse_ObjectType `protobuf:"varint,1,opt,name=type,enum=gitaly.TreeEntryResponse_ObjectType" json:"type,omitempty"`
	// SHA1 object ID
	Oid  string `protobuf:"bytes,2,opt,name=oid" json:"oid,omitempty"`
	Size int64  `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	// file mode
	Mode int32 `protobuf:"varint,4,opt,name=mode" json:"mode,omitempty"`
	// raw object contents
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *TreeEntryResponse) Reset()                    { *m = TreeEntryResponse{} }
func (m *TreeEntryResponse) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryResponse) ProtoMessage()               {}
func (*TreeEntryResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *TreeEntryResponse) GetType() TreeEntryResponse_ObjectType {
	if m != nil {
		return m.Type
	}
	return TreeEntryResponse_COMMIT
}

func (m *TreeEntryResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntryResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *TreeEntryResponse) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntryResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type CommitsBetweenRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	From       []byte      `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	To         []byte      `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
}

func (m *CommitsBetweenRequest) Reset()                    { *m = CommitsBetweenRequest{} }
func (m *CommitsBetweenRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenRequest) ProtoMessage()               {}
func (*CommitsBetweenRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *CommitsBetweenRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitsBetweenRequest) GetFrom() []byte {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *CommitsBetweenRequest) GetTo() []byte {
	if m != nil {
		return m.To
	}
	return nil
}

type CommitsBetweenResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *CommitsBetweenResponse) Reset()                    { *m = CommitsBetweenResponse{} }
func (m *CommitsBetweenResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenResponse) ProtoMessage()               {}
func (*CommitsBetweenResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CommitsBetweenResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CountCommitsRequest struct {
	Repository *Repository                `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte                     `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	After      *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=after" json:"after,omitempty"`
	Before     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=before" json:"before,omitempty"`
	Path       []byte                     `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *CountCommitsRequest) Reset()                    { *m = CountCommitsRequest{} }
func (m *CountCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsRequest) ProtoMessage()               {}
func (*CountCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *CountCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CountCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CountCommitsRequest) GetAfter() *google_protobuf.Timestamp {
	if m != nil {
		return m.After
	}
	return nil
}

func (m *CountCommitsRequest) GetBefore() *google_protobuf.Timestamp {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *CountCommitsRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type CountCommitsResponse struct {
	Count int32 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
}

func (m *CountCommitsResponse) Reset()                    { *m = CountCommitsResponse{} }
func (m *CountCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsResponse) ProtoMessage()               {}
func (*CountCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *CountCommitsResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type TreeEntry struct {
	// OID of the object this tree entry points to
	Oid string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	// OID of the tree attached to commit_oid
	RootOid string `protobuf:"bytes,2,opt,name=root_oid,json=rootOid" json:"root_oid,omitempty"`
	// Path relative to repository root
	Path []byte              `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Type TreeEntry_EntryType `protobuf:"varint,4,opt,name=type,enum=gitaly.TreeEntry_EntryType" json:"type,omitempty"`
	// File mode e.g. 0644
	Mode int32 `protobuf:"varint,5,opt,name=mode" json:"mode,omitempty"`
	// The commit object via which this entry was retrieved
	CommitOid string `protobuf:"bytes,6,opt,name=commit_oid,json=commitOid" json:"commit_oid,omitempty"`
}

func (m *TreeEntry) Reset()                    { *m = TreeEntry{} }
func (m *TreeEntry) String() string            { return proto.CompactTextString(m) }
func (*TreeEntry) ProtoMessage()               {}
func (*TreeEntry) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *TreeEntry) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntry) GetRootOid() string {
	if m != nil {
		return m.RootOid
	}
	return ""
}

func (m *TreeEntry) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntry) GetType() TreeEntry_EntryType {
	if m != nil {
		return m.Type
	}
	return TreeEntry_BLOB
}

func (m *TreeEntry) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntry) GetCommitOid() string {
	if m != nil {
		return m.CommitOid
	}
	return ""
}

type GetTreeEntriesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *GetTreeEntriesRequest) Reset()                    { *m = GetTreeEntriesRequest{} }
func (m *GetTreeEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesRequest) ProtoMessage()               {}
func (*GetTreeEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *GetTreeEntriesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type GetTreeEntriesResponse struct {
	Entries []*TreeEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *GetTreeEntriesResponse) Reset()                    { *m = GetTreeEntriesResponse{} }
func (m *GetTreeEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesResponse) ProtoMessage()               {}
func (*GetTreeEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *GetTreeEntriesResponse) GetEntries() []*TreeEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type ListFilesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *ListFilesRequest) Reset()                    { *m = ListFilesRequest{} }
func (m *ListFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListFilesRequest) ProtoMessage()               {}
func (*ListFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *ListFilesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListFilesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

// A single 'page' of the paginated response
type ListFilesResponse struct {
	// Remember to force encoding utf-8 on the client side
	Paths [][]byte `protobuf:"bytes,1,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (m *ListFilesResponse) Reset()                    { *m = ListFilesResponse{} }
func (m *ListFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListFilesResponse) ProtoMessage()               {}
func (*ListFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListFilesResponse) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type FindCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *FindCommitRequest) Reset()                    { *m = FindCommitRequest{} }
func (m *FindCommitRequest) String() string            { return proto.CompactTextString(m) }
func (*FindCommitRequest) ProtoMessage()               {}
func (*FindCommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *FindCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindCommitRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type FindCommitResponse struct {
	// commit is nil when the commit was not found
	Commit *GitCommit `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
}

func (m *FindCommitResponse) Reset()                    { *m = FindCommitResponse{} }
func (m *FindCommitResponse) String() string            { return proto.CompactTextString(m) }
func (*FindCommitResponse) ProtoMessage()               {}
func (*FindCommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *FindCommitResponse) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

type FindAllCommitsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// When nil, return all commits reachable by any branch in the repo
	Revision []byte                      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	MaxCount int32                       `protobuf:"varint,3,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
	Skip     int32                       `protobuf:"varint,4,opt,name=skip" json:"skip,omitempty"`
	Order    FindAllCommitsRequest_Order `protobuf:"varint,5,opt,name=order,enum=gitaly.FindAllCommitsRequest_Order" json:"order,omitempty"`
}

func (m *FindAllCommitsRequest) Reset()                    { *m = FindAllCommitsRequest{} }
func (m *FindAllCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsRequest) ProtoMessage()               {}
func (*FindAllCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *FindAllCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *FindAllCommitsRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

func (m *FindAllCommitsRequest) GetSkip() int32 {
	if m != nil {
		return m.Skip
	}
	return 0
}

func (m *FindAllCommitsRequest) GetOrder() FindAllCommitsRequest_Order {
	if m != nil {
		return m.Order
	}
	return FindAllCommitsRequest_NONE
}

// A single 'page' of the result set
type FindAllCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *FindAllCommitsResponse) Reset()                    { *m = FindAllCommitsResponse{} }
func (m *FindAllCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsResponse) ProtoMessage()               {}
func (*FindAllCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *FindAllCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CommitLanguagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitLanguagesRequest) Reset()                    { *m = CommitLanguagesRequest{} }
func (m *CommitLanguagesRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesRequest) ProtoMessage()               {}
func (*CommitLanguagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *CommitLanguagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitLanguagesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitLanguagesResponse struct {
	Languages []*CommitLanguagesResponse_Language `protobuf:"bytes,1,rep,name=languages" json:"languages,omitempty"`
}

func (m *CommitLanguagesResponse) Reset()                    { *m = CommitLanguagesResponse{} }
func (m *CommitLanguagesResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse) ProtoMessage()               {}
func (*CommitLanguagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *CommitLanguagesResponse) GetLanguages() []*CommitLanguagesResponse_Language {
	if m != nil {
		return m.Languages
	}
	return nil
}

type CommitLanguagesResponse_Language struct {
	Name  string  `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Share float32 `protobuf:"fixed32,2,opt,name=share" json:"share,omitempty"`
	Color string  `protobuf:"bytes,3,opt,name=color" json:"color,omitempty"`
}

func (m *CommitLanguagesResponse_Language) Reset()         { *m = CommitLanguagesResponse_Language{} }
func (m *CommitLanguagesResponse_Language) String() string { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse_Language) ProtoMessage()    {}
func (*CommitLanguagesResponse_Language) Descriptor() ([]byte, []int) {
	return fileDescriptor1, []int{20, 0}
}

func (m *CommitLanguagesResponse_Language) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CommitLanguagesResponse_Language) GetShare() float32 {
	if m != nil {
		return m.Share
	}
	return 0
}

func (m *CommitLanguagesResponse_Language) GetColor() string {
	if m != nil {
		return m.Color
	}
	return ""
}

type RawBlameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *RawBlameRequest) Reset()                    { *m = RawBlameRequest{} }
func (m *RawBlameRequest) String() string            { return proto.CompactTextString(m) }
func (*RawBlameRequest) ProtoMessage()               {}
func (*RawBlameRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{21} }

func (m *RawBlameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawBlameRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RawBlameRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type RawBlameResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *RawBlameResponse) Reset()                    { *m = RawBlameResponse{} }
func (m *RawBlameResponse) String() string            { return proto.CompactTextString(m) }
func (*RawBlameResponse) ProtoMessage()               {}
func (*RawBlameResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{22} }

func (m *RawBlameResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitStatsRequest)(nil), "gitaly.CommitStatsRequest")
	proto.RegisterType((*CommitStatsResponse)(nil), "gitaly.CommitStatsResponse")
	proto.RegisterType((*CommitIsAncestorRequest)(nil), "gitaly.CommitIsAncestorRequest")
	proto.RegisterType((*CommitIsAncestorResponse)(nil), "gitaly.CommitIsAncestorResponse")
	proto.RegisterType((*TreeEntryRequest)(nil), "gitaly.TreeEntryRequest")
	proto.RegisterType((*TreeEntryResponse)(nil), "gitaly.TreeEntryResponse")
	proto.RegisterType((*CommitsBetweenRequest)(nil), "gitaly.CommitsBetweenRequest")
	proto.RegisterType((*CommitsBetweenResponse)(nil), "gitaly.CommitsBetweenResponse")
	proto.RegisterType((*CountCommitsRequest)(nil), "gitaly.CountCommitsRequest")
	proto.RegisterType((*CountCommitsResponse)(nil), "gitaly.CountCommitsResponse")
	proto.RegisterType((*TreeEntry)(nil), "gitaly.TreeEntry")
	proto.RegisterType((*GetTreeEntriesRequest)(nil), "gitaly.GetTreeEntriesRequest")
	proto.RegisterType((*GetTreeEntriesResponse)(nil), "gitaly.GetTreeEntriesResponse")
	proto.RegisterType((*ListFilesRequest)(nil), "gitaly.ListFilesRequest")
	proto.RegisterType((*ListFilesResponse)(nil), "gitaly.ListFilesResponse")
	proto.RegisterType((*FindCommitRequest)(nil), "gitaly.FindCommitRequest")
	proto.RegisterType((*FindCommitResponse)(nil), "gitaly.FindCommitResponse")
	proto.RegisterType((*FindAllCommitsRequest)(nil), "gitaly.FindAllCommitsRequest")
	proto.RegisterType((*FindAllCommitsResponse)(nil), "gitaly.FindAllCommitsResponse")
	proto.RegisterType((*CommitLanguagesRequest)(nil), "gitaly.CommitLanguagesRequest")
	proto.RegisterType((*CommitLanguagesResponse)(nil), "gitaly.CommitLanguagesResponse")
	proto.RegisterType((*CommitLanguagesResponse_Language)(nil), "gitaly.CommitLanguagesResponse.Language")
	proto.RegisterType((*RawBlameRequest)(nil), "gitaly.RawBlameRequest")
	proto.RegisterType((*RawBlameResponse)(nil), "gitaly.RawBlameResponse")
	proto.RegisterEnum("gitaly.TreeEntryResponse_ObjectType", TreeEntryResponse_ObjectType_name, TreeEntryResponse_ObjectType_value)
	proto.RegisterEnum("gitaly.TreeEntry_EntryType", TreeEntry_EntryType_name, TreeEntry_EntryType_value)
	proto.RegisterEnum("gitaly.FindAllCommitsRequest_Order", FindAllCommitsRequest_Order_name, FindAllCommitsRequest_Order_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CommitService service

type CommitServiceClient interface {
	CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error)
	TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error)
	CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error)
	CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error)
	GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error)
	ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error)
	FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error)
	CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error)
	CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error)
	RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error)
}

type commitServiceClient struct {
	cc *grpc.ClientConn
}

func NewCommitServiceClient(cc *grpc.ClientConn) CommitServiceClient {
	return &commitServiceClient{cc}
}

func (c *commitServiceClient) CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error) {
	out := new(CommitIsAncestorResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitIsAncestor", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[0], c.cc, "/gitaly.CommitService/TreeEntry", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceTreeEntryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_TreeEntryClient interface {
	Recv() (*TreeEntryResponse, error)
	grpc.ClientStream
}

type commitServiceTreeEntryClient struct {
	grpc.ClientStream
}

func (x *commitServiceTreeEntryClient) Recv() (*TreeEntryResponse, error) {
	m := new(TreeEntryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[1], c.cc, "/gitaly.CommitService/CommitsBetween", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceCommitsBetweenClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_CommitsBetweenClient interface {
	Recv() (*CommitsBetweenResponse, error)
	grpc.ClientStream
}

type commitServiceCommitsBetweenClient struct {
	grpc.ClientStream
}

func (x *commitServiceCommitsBetweenClient) Recv() (*CommitsBetweenResponse, error) {
	m := new(CommitsBetweenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error) {
	out := new(CountCommitsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CountCommits", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[2], c.cc, "/gitaly.CommitService/GetTreeEntries", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceGetTreeEntriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_GetTreeEntriesClient interface {
	Recv() (*GetTreeEntriesResponse, error)
	grpc.ClientStream
}

type commitServiceGetTreeEntriesClient struct {
	grpc.ClientStream
}

func (x *commitServiceGetTreeEntriesClient) Recv() (*GetTreeEntriesResponse, error) {
	m := new(GetTreeEntriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[3], c.cc, "/gitaly.CommitService/ListFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListFilesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListFilesClient interface {
	Recv() (*ListFilesResponse, error)
	grpc.ClientStream
}

type commitServiceListFilesClient struct {
	grpc.ClientStream
}

func (x *commitServiceListFilesClient) Recv() (*ListFilesResponse, error) {
	m := new(ListFilesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error) {
	out := new(FindCommitResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/FindCommit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error) {
	out := new(CommitStatsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[4], c.cc, "/gitaly.CommitService/FindAllCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFindAllCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_FindAllCommitsClient interface {
	Recv() (*FindAllCommitsResponse, error)
	grpc.ClientStream
}

type commitServiceFindAllCommitsClient struct {
	grpc.ClientStream
}

func (x *commitServiceFindAllCommitsClient) Recv() (*FindAllCommitsResponse, error) {
	m := new(FindAllCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error) {
	out := new(CommitLanguagesResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitLanguages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[5], c.cc, "/gitaly.CommitService/RawBlame", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceRawBlameClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_RawBlameClient interface {
	Recv() (*RawBlameResponse, error)
	grpc.ClientStream
}

type commitServiceRawBlameClient struct {
	grpc.ClientStream
}

func (x *commitServiceRawBlameClient) Recv() (*RawBlameResponse, error) {
	m := new(RawBlameResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for CommitService service

type CommitServiceServer interface {
	CommitIsAncestor(context.Context, *CommitIsAncestorRequest) (*CommitIsAncestorResponse, error)
	TreeEntry(*TreeEntryRequest, CommitService_TreeEntryServer) error
	CommitsBetween(*CommitsBetweenRequest, CommitService_CommitsBetweenServer) error
	CountCommits(context.Context, *CountCommitsRequest) (*CountCommitsResponse, error)
	GetTreeEntries(*GetTreeEntriesRequest, CommitService_GetTreeEntriesServer) error
	ListFiles(*ListFilesRequest, CommitService_ListFilesServer) error
	FindCommit(context.Context, *FindCommitRequest) (*FindCommitResponse, error)
	CommitStats(context.Context, *CommitStatsRequest) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(*FindAllCommitsRequest, CommitService_FindAllCommitsServer) error
	CommitLanguages(context.Context, *CommitLanguagesRequest) (*CommitLanguagesResponse, error)
	RawBlame(*RawBlameRequest, CommitService_RawBlameServer) error
}

func RegisterCommitServiceServer(s *grpc.Server, srv CommitServiceServer) {
	s.RegisterService(&_CommitService_serviceDesc, srv)
}

func _CommitService_CommitIsAncestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitIsAncestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitIsAncestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, req.(*CommitIsAncestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_TreeEntry_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TreeEntryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).TreeEntry(m, &commitServiceTreeEntryServer{stream})
}

type CommitService_TreeEntryServer interface {
	Send(*TreeEntryResponse) error
	grpc.ServerStream
}

type commitServiceTreeEntryServer struct {
	grpc.ServerStream
}

func (x *commitServiceTreeEntryServer) Send(m *TreeEntryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitsBetween_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitsBetweenRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).CommitsBetween(m, &commitServiceCommitsBetweenServer{stream})
}

type CommitService_CommitsBetweenServer interface {
	Send(*CommitsBetweenResponse) error
	grpc.ServerStream
}

type commitServiceCommitsBetweenServer struct {
	grpc.ServerStream
}

func (x *commitServiceCommitsBetweenServer) Send(m *CommitsBetweenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CountCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CountCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CountCommits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CountCommits(ctx, req.(*CountCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_GetTreeEntries_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTreeEntriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).GetTreeEntries(m, &commitServiceGetTreeEntriesServer{stream})
}

type CommitService_GetTreeEntriesServer interface {
	Send(*GetTreeEntriesResponse) error
	grpc.ServerStream
}

type commitServiceGetTreeEntriesServer struct {
	grpc.ServerStream
}

func (x *commitServiceGetTreeEntriesServer) Send(m *GetTreeEntriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_ListFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListFilesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListFiles(m, &commitServiceListFilesServer{stream})
}

type CommitService_ListFilesServer interface {
	Send(*ListFilesResponse) error
	grpc.ServerStream
}

type commitServiceListFilesServer struct {
	grpc.ServerStream
}

func (x *commitServiceListFilesServer) Send(m *ListFilesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FindCommit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindCommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).FindCommit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/FindCommit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).FindCommit(ctx, req.(*FindCommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_CommitStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitStats(ctx, req.(*CommitStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_FindAllCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).FindAllCommits(m, &commitServiceFindAllCommitsServer{stream})
}

type CommitService_FindAllCommitsServer interface {
	Send(*FindAllCommitsResponse) error
	grpc.ServerStream
}

type commitServiceFindAllCommitsServer struct {
	grpc.ServerStream
}

func (x *commitServiceFindAllCommitsServer) Send(m *FindAllCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitLanguages(ctx, req.(*CommitLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_RawBlame_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawBlameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).RawBlame(m, &commitServiceRawBlameServer{stream})
}

type CommitService_RawBlameServer interface {
	Send(*RawBlameResponse) error
	grpc.ServerStream
}

type commitServiceRawBlameServer struct {
	grpc.ServerStream
}

func (x *commitServiceRawBlameServer) Send(m *RawBlameResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _CommitService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.CommitService",
	HandlerType: (*CommitServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitIsAncestor",
			Handler:    _CommitService_CommitIsAncestor_Handler,
		},
		{
			MethodName: "CountCommits",
			Handler:    _CommitService_CountCommits_Handler,
		},
		{
			MethodName: "FindCommit",
			Handler:    _CommitService_FindCommit_Handler,
		},
		{
			MethodName: "CommitStats",
			Handler:    _CommitService_CommitStats_Handler,
		},
		{
			MethodName: "CommitLanguages",
			Handler:    _CommitService_CommitLanguages_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "TreeEntry",
			Handler:       _CommitService_TreeEntry_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitsBetween",
			Handler:       _CommitService_CommitsBetween_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTreeEntries",
			Handler:       _CommitService_GetTreeEntries_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListFiles",
			Handler:       _CommitService_ListFiles_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllCommits",
			Handler:       _CommitService_FindAllCommits_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawBlame",
			Handler:       _CommitService_RawBlame_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "commit.proto",
}

func init() { proto.RegisterFile("commit.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 1122 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0x5d, 0x6f, 0x23, 0x35,
	0x17, 0xee, 0xe4, 0xab, 0xc9, 0x69, 0xde, 0x6e, 0xea, 0x77, 0xcb, 0xa6, 0xd3, 0xdd, 0x6d, 0x65,
	0x3e, 0xd4, 0xd5, 0xa2, 0xb4, 0x0a, 0x42, 0x82, 0x2b, 0xd4, 0x6e, 0xd3, 0x52, 0xe8, 0x6e, 0x90,
	0x1b, 0x89, 0xcb, 0x6a, 0x9a, 0x71, 0x5b, 0xc3, 0xcc, 0x38, 0xcc, 0x38, 0xdd, 0x2d, 0xfc, 0x02,
	0x24, 0xfe, 0x0a, 0x7f, 0x86, 0x7b, 0xc4, 0x3d, 0x3f, 0x81, 0x2b, 0xe4, 0x8f, 0x19, 0xcf, 0x24,
	0x13, 0x90, 0x58, 0x65, 0x6f, 0x22, 0xfb, 0x1c, 0x8f, 0xcf, 0xe3, 0xe3, 0xe7, 0x3c, 0x3e, 0x81,
	0xf6, 0x98, 0x87, 0x21, 0x13, 0xbd, 0x49, 0xcc, 0x05, 0x47, 0x8d, 0x1b, 0x26, 0xbc, 0xe0, 0xde,
	0x6d, 0x27, 0xb7, 0x5e, 0x4c, 0x7d, 0x6d, 0x75, 0x77, 0x6e, 0x38, 0xbf, 0x09, 0xe8, 0xbe, 0x9a,
	0x5d, 0x4d, 0xaf, 0xf7, 0x05, 0x0b, 0x69, 0x22, 0xbc, 0x70, 0xa2, 0x17, 0x60, 0x1f, 0xd0, 0x0b,
	0xb5, 0xcd, 0x85, 0xf0, 0x44, 0x42, 0xe8, 0x0f, 0x53, 0x9a, 0x08, 0xd4, 0x07, 0x88, 0xe9, 0x84,
	0x27, 0x4c, 0xf0, 0xf8, 0xbe, 0xeb, 0xec, 0x3a, 0x7b, 0x6b, 0x7d, 0xd4, 0xd3, 0x11, 0x7a, 0x24,
	0xf3, 0x90, 0xdc, 0x2a, 0xe4, 0x42, 0x33, 0xa6, 0x77, 0x2c, 0x61, 0x3c, 0xea, 0x56, 0x76, 0x9d,
	0xbd, 0x36, 0xc9, 0xe6, 0x78, 0x0c, 0xff, 0x2f, 0x44, 0x49, 0x26, 0x3c, 0x4a, 0x28, 0xea, 0x40,
	0x95, 0x33, 0x5f, 0xed, 0xdf, 0x22, 0x72, 0x88, 0x1e, 0x43, 0xcb, 0xf3, 0x7d, 0x26, 0x18, 0x8f,
	0x12, 0xb5, 0x4b, 0x9d, 0x58, 0x83, 0xf4, 0xfa, 0x34, 0xa0, 0xda, 0x5b, 0xd5, 0xde, 0xcc, 0x80,
	0x7f, 0x76, 0xe0, 0x91, 0x8e, 0x72, 0x96, 0x1c, 0x46, 0x63, 0x9a, 0x08, 0x1e, 0xbf, 0xcd, 0x81,
	0x76, 0x60, 0xcd, 0x33, 0xdb, 0x5c, 0x32, 0x5f, 0xa1, 0x69, 0x11, 0x48, 0x4d, 0x67, 0x3e, 0xda,
	0x82, 0xe6, 0xf8, 0x96, 0x05, 0xbe, 0xf4, 0x56, 0x95, 0x77, 0x55, 0xcd, 0xcf, 0x7c, 0x7c, 0x00,
	0xdd, 0x79, 0x28, 0xe6, 0xd4, 0x0f, 0xa1, 0x7e, 0xe7, 0x05, 0x53, 0xaa, 0x60, 0x34, 0x89, 0x9e,
	0xe0, 0x5f, 0x1c, 0xe8, 0x8c, 0x62, 0x4a, 0x07, 0x91, 0x88, 0xef, 0x97, 0x74, 0x0f, 0x08, 0x41,
	0x6d, 0xe2, 0x89, 0x5b, 0x85, 0xb6, 0x4d, 0xd4, 0x58, 0xc2, 0x09, 0x58, 0xc8, 0x44, 0xb7, 0xb6,
	0xeb, 0xec, 0x55, 0x89, 0x9e, 0xe0, 0xdf, 0x1c, 0xd8, 0xc8, 0xc1, 0x31, 0xd0, 0x3f, 0x83, 0x9a,
	0xb8, 0x9f, 0x68, 0xe4, 0xeb, 0xfd, 0x0f, 0x52, 0x24, 0x73, 0x0b, 0x7b, 0xc3, 0xab, 0xef, 0xe8,
	0x58, 0x8c, 0xee, 0x27, 0x94, 0xa8, 0x2f, 0xd2, 0xab, 0xae, 0xd8, 0xab, 0x46, 0x50, 0x4b, 0xd8,
	0x8f, 0x54, 0x61, 0xa9, 0x12, 0x35, 0x96, 0xb6, 0x90, 0xfb, 0x54, 0x41, 0xa9, 0x13, 0x35, 0x96,
	0x36, 0xdf, 0x13, 0x5e, 0xb7, 0xae, 0x31, 0xcb, 0x31, 0xfe, 0x14, 0xc0, 0x46, 0x40, 0x00, 0x8d,
	0x17, 0xc3, 0x97, 0x2f, 0xcf, 0x46, 0x9d, 0x15, 0xd4, 0x84, 0xda, 0xd1, 0xf9, 0xf0, 0xa8, 0xe3,
	0xc8, 0xd1, 0x88, 0x0c, 0x06, 0x9d, 0x0a, 0x5a, 0x85, 0xea, 0xe8, 0xf0, 0xb4, 0x53, 0xc5, 0x1c,
	0x36, 0xf5, 0xad, 0x24, 0x47, 0x54, 0xbc, 0xa6, 0x34, 0x7a, 0x9b, 0x3c, 0x23, 0xa8, 0x5d, 0xc7,
	0x3c, 0x34, 0x39, 0x56, 0x63, 0xb4, 0x0e, 0x15, 0xc1, 0x4d, 0x76, 0x2b, 0x82, 0xe3, 0x01, 0xbc,
	0x37, 0x1b, 0xd0, 0x64, 0xf2, 0x39, 0xac, 0xea, 0xf2, 0x4d, 0xba, 0xce, 0x6e, 0x75, 0x6f, 0xad,
	0xbf, 0x91, 0x86, 0x3b, 0x65, 0x42, 0x7f, 0x43, 0xd2, 0x15, 0xf8, 0x0f, 0x47, 0xd6, 0xcf, 0x34,
	0x32, 0x8e, 0x65, 0x95, 0x29, 0x3a, 0x80, 0xba, 0x77, 0x2d, 0x68, 0xac, 0x4e, 0xb0, 0xd6, 0x77,
	0x7b, 0x5a, 0x3d, 0x7a, 0xa9, 0x7a, 0xf4, 0x46, 0xa9, 0x7a, 0x10, 0xbd, 0x10, 0xf5, 0xa1, 0x71,
	0x45, 0xaf, 0x79, 0xac, 0xaf, 0xec, 0x9f, 0x3f, 0x31, 0x2b, 0x33, 0x12, 0xd6, 0x2d, 0x09, 0xf1,
	0xc7, 0xf0, 0xb0, 0x78, 0x40, 0x5b, 0x2b, 0x63, 0x69, 0x57, 0x87, 0xab, 0x13, 0x3d, 0xc1, 0xbf,
	0x3b, 0xd0, 0xca, 0x38, 0x57, 0xa2, 0x22, 0x5b, 0xd0, 0x8c, 0x39, 0x17, 0x97, 0x96, 0x71, 0xab,
	0x72, 0x3e, 0xd4, 0xac, 0x9b, 0xab, 0x80, 0x7d, 0xc3, 0xea, 0x9a, 0x62, 0xf5, 0xf6, 0x1c, 0xab,
	0x7b, 0xea, 0x37, 0x47, 0xe6, 0x94, 0xa6, 0xf5, 0x1c, 0x4d, 0x9f, 0x00, 0xe8, 0xeb, 0x52, 0x51,
	0x1b, 0x2a, 0x6a, 0x4b, 0x5b, 0x86, 0xcc, 0xc7, 0xcf, 0xa1, 0x95, 0xed, 0x92, 0x91, 0x74, 0x25,
	0x23, 0xa9, 0x93, 0x23, 0x71, 0x15, 0xff, 0x04, 0x9b, 0xa7, 0x54, 0xa4, 0xf1, 0x19, 0x4d, 0xde,
	0xa1, 0x1e, 0x48, 0xce, 0xce, 0x06, 0xb7, 0x9c, 0xa5, 0xda, 0x34, 0xcb, 0x59, 0x2b, 0x00, 0xe9,
	0x0a, 0x7c, 0x05, 0x9d, 0x73, 0x96, 0x88, 0x13, 0x16, 0x2c, 0x0d, 0x3e, 0x7e, 0x06, 0x1b, 0xb9,
	0x18, 0x96, 0x32, 0xf2, 0x1c, 0x1a, 0x63, 0x9b, 0xe8, 0x09, 0x1e, 0xc3, 0xc6, 0x09, 0x8b, 0x7c,
	0x53, 0x59, 0x4b, 0xc2, 0xf3, 0x05, 0xa0, 0x7c, 0x10, 0x03, 0xe8, 0x19, 0x34, 0x34, 0x0f, 0x4c,
	0x84, 0x92, 0x4a, 0x37, 0x0b, 0xf0, 0x5f, 0x0e, 0x6c, 0xca, 0x1d, 0x0e, 0x83, 0x60, 0xc9, 0xa5,
	0xbe, 0x0d, 0xad, 0xd0, 0x7b, 0x73, 0xa9, 0x8b, 0x4b, 0x3f, 0xa5, 0xcd, 0xd0, 0x7b, 0xa3, 0x8a,
	0x50, 0x49, 0xf3, 0xf7, 0x6c, 0x92, 0xca, 0xb0, 0x1c, 0xa3, 0xcf, 0xa1, 0xce, 0x63, 0x9f, 0xc6,
	0x8a, 0xf4, 0xeb, 0xfd, 0xf7, 0xd3, 0xd8, 0xa5, 0x70, 0x7b, 0x43, 0xb9, 0x94, 0xe8, 0x2f, 0xf0,
	0x87, 0x50, 0x57, 0x73, 0xc9, 0xf6, 0x57, 0xc3, 0x57, 0x03, 0xc3, 0xfb, 0xe1, 0x37, 0x43, 0x2d,
	0xd3, 0xc7, 0x87, 0xa3, 0x41, 0xa7, 0x22, 0x89, 0x37, 0xbb, 0xd9, 0x7f, 0x11, 0xcb, 0xdb, 0x54,
	0x73, 0xcf, 0xbd, 0xe8, 0x66, 0xea, 0xdd, 0x2c, 0x8f, 0x7e, 0xbf, 0x66, 0x0d, 0x47, 0x2e, 0x94,
	0x81, 0x7c, 0x02, 0xad, 0x20, 0x35, 0x1a, 0xd0, 0x7b, 0x69, 0xa8, 0x05, 0xdf, 0xf4, 0x52, 0x0b,
	0xb1, 0x9f, 0xba, 0x5f, 0x41, 0x33, 0x35, 0xcb, 0x6b, 0x89, 0xbc, 0x90, 0x1a, 0xa5, 0x53, 0x63,
	0xc9, 0x76, 0xd5, 0xf0, 0x29, 0x70, 0x15, 0xa2, 0x27, 0x5a, 0x36, 0x03, 0x1e, 0x9b, 0xb6, 0x44,
	0x4f, 0xf0, 0x14, 0x1e, 0x10, 0xef, 0xf5, 0x51, 0xe0, 0x85, 0xf4, 0x5d, 0x0a, 0xca, 0x47, 0xd0,
	0xb1, 0x61, 0x4d, 0x7a, 0xd2, 0x47, 0xdd, 0xb1, 0x8f, 0x7a, 0xff, 0xcf, 0x06, 0xfc, 0xcf, 0x74,
	0x89, 0x34, 0xbe, 0x63, 0x63, 0x8a, 0xbe, 0x85, 0xce, 0x6c, 0x17, 0x85, 0x76, 0x8a, 0x59, 0x9c,
	0x6b, 0xf5, 0xdc, 0xdd, 0xc5, 0x0b, 0x74, 0x70, 0xbc, 0x82, 0x8e, 0xf3, 0xef, 0x47, 0xb7, 0xa4,
	0x8d, 0xd1, 0x5b, 0x6d, 0x2d, 0x6c, 0x70, 0xf0, 0xca, 0x81, 0x83, 0x2e, 0x60, 0xbd, 0xf8, 0xba,
	0xa3, 0x27, 0xc5, 0xd8, 0x33, 0x6d, 0x86, 0xfb, 0x74, 0x91, 0x3b, 0xb7, 0xe9, 0xd7, 0xd0, 0xce,
	0xbf, 0x84, 0x68, 0xdb, 0x7e, 0x33, 0xd7, 0x00, 0xb8, 0x8f, 0xcb, 0x9d, 0xd9, 0x39, 0x2f, 0x60,
	0xbd, 0xa8, 0xe5, 0x16, 0x61, 0xe9, 0x03, 0x63, 0x11, 0x96, 0x3f, 0x01, 0x0a, 0xe1, 0x31, 0xb4,
	0x32, 0xd5, 0xb5, 0xc9, 0x9b, 0x15, 0x7b, 0x9b, 0xbc, 0x39, 0x89, 0x56, 0xbb, 0x0c, 0x00, 0xac,
	0x56, 0xa2, 0xad, 0xbc, 0x9c, 0x14, 0x44, 0xda, 0x75, 0xcb, 0x5c, 0xd9, 0x09, 0xbf, 0x84, 0xb5,
	0xdc, 0x3f, 0x0b, 0xe4, 0x16, 0x33, 0x9c, 0xff, 0x53, 0xe3, 0x6e, 0x97, 0xfa, 0xf2, 0xb9, 0x2a,
	0xca, 0x8f, 0xcd, 0x55, 0xa9, 0xc6, 0xd9, 0x5c, 0x95, 0xab, 0x96, 0x3a, 0xe5, 0x08, 0x1e, 0xcc,
	0x54, 0x3b, 0x7a, 0xba, 0x50, 0x06, 0xf4, 0xb6, 0x3b, 0xff, 0x22, 0x13, 0x78, 0x05, 0x1d, 0x42,
	0x33, 0xad, 0x28, 0xf4, 0x28, 0xab, 0xd6, 0x62, 0x69, 0xbb, 0xdd, 0x79, 0x87, 0x05, 0x76, 0xd5,
	0x50, 0x0d, 0xda, 0x27, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0xfb, 0xdb, 0xf3, 0x6d, 0x45, 0x0e,
	0x00, 0x00,
}
