/* gitg-commit.c generated by valac 0.26.1, the Vala compiler
 * generated from gitg-commit.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;
typedef struct _GitgCommitPrivate GitgCommitPrivate;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ggit_commit_parents_unref0(var) ((var == NULL) ? NULL : (var = (ggit_commit_parents_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GITG_TYPE_DATE (gitg_date_get_type ())
#define GITG_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DATE, GitgDate))
#define GITG_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DATE, GitgDateClass))
#define GITG_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DATE))
#define GITG_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DATE))
#define GITG_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DATE, GitgDateClass))

typedef struct _GitgDate GitgDate;
typedef struct _GitgDateClass GitgDateClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GitgCommit {
	GgitCommit parent_instance;
	GitgCommitPrivate * priv;
};

struct _GitgCommitClass {
	GgitCommitClass parent_class;
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4
} GitgLaneTag;

struct _GitgCommitPrivate {
	GitgLaneTag _tag;
	guint d_mylane;
	GSList* d_lanes;
};

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};


static gpointer gitg_commit_parent_class = NULL;

GType gitg_commit_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GType gitg_lane_get_type (void) G_GNUC_CONST;
#define GITG_COMMIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_COMMIT, GitgCommitPrivate))
enum  {
	GITG_COMMIT_DUMMY_PROPERTY,
	GITG_COMMIT_TAG,
	GITG_COMMIT_MYLANE,
	GITG_COMMIT_LANE,
	GITG_COMMIT_FORMAT_PATCH_NAME,
	GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY,
	GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_commit_update_lane_tag (GitgCommit* self);
GType gitg_color_get_type (void) G_GNUC_CONST;
GitgLaneTag gitg_commit_get_tag (GitgCommit* self);
void gitg_commit_update_lanes (GitgCommit* self, GSList* lanes, gint mylane);
GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options);
GitgCommit* gitg_commit_new (void);
GitgCommit* gitg_commit_construct (GType object_type);
void gitg_commit_set_tag (GitgCommit* self, GitgLaneTag value);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
GitgLane* gitg_commit_get_lane (GitgCommit* self);
gchar* gitg_commit_get_format_patch_name (GitgCommit* self);
gchar* gitg_commit_get_committer_date_for_display (GitgCommit* self);
GitgDate* gitg_date_new_for_date_time (GDateTime* dt);
GitgDate* gitg_date_construct_for_date_time (GType object_type, GDateTime* dt);
GType gitg_date_get_type (void) G_GNUC_CONST;
gchar* gitg_date_for_display (GitgDate* self);
gchar* gitg_commit_get_author_date_for_display (GitgCommit* self);
static void gitg_commit_finalize (GObject* obj);
static void _vala_gitg_commit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_commit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 167 "gitg-commit.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_slist_free (self);
#line 176 "gitg-commit.c"
}


GSList* gitg_commit_get_lanes (GitgCommit* self) {
	GSList* result = NULL;
	GSList* _tmp0_ = NULL;
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 191 "gitg-commit.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return self ? g_object_ref (self) : NULL;
#line 198 "gitg-commit.c"
}


GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx) {
	GSList* result = NULL;
	GitgLane* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSList* _tmp3_ = NULL;
#line 50 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (lane != NULL, NULL);
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lane;
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = idx;
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = g_slist_insert (self->priv->d_lanes, _tmp1_, _tmp2_);
#line 53 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = self->priv->d_lanes;
#line 53 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp3_;
#line 53 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 226 "gitg-commit.c"
}


GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane) {
	GSList* result = NULL;
	GitgLane* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (lane != NULL, NULL);
#line 58 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lane;
#line 58 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = g_slist_remove (self->priv->d_lanes, _tmp0_);
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_lanes;
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp1_;
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 248 "gitg-commit.c"
}


static void gitg_commit_update_lane_tag (GitgCommit* self) {
	GitgLane* lane = NULL;
	GSList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	GitgLane* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
	GitgLaneTag _tmp6_ = 0;
	GitgLaneTag _tmp7_ = 0;
#line 62 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_mylane;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = g_slist_nth_data (_tmp0_, _tmp1_);
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	lane = (GitgLane*) _tmp2_;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = lane;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	if (_tmp3_ == NULL) {
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		return;
#line 278 "gitg-commit.c"
	}
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = lane;
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = lane;
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = _tmp5_->tag;
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = self->priv->_tag;
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp5_->tag = _tmp6_ & ((~((GITG_LANE_TAG_SIGN_STASH | GITG_LANE_TAG_SIGN_STAGED) | GITG_LANE_TAG_SIGN_UNSTAGED)) | _tmp7_);
#line 290 "gitg-commit.c"
}


void gitg_commit_update_lanes (GitgCommit* self, GSList* lanes, gint mylane) {
	GSList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = lanes;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	lanes = NULL;
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_lanes);
#line 78 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv->d_lanes = _tmp0_;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = mylane;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	if (_tmp1_ >= 0) {
#line 311 "gitg-commit.c"
		gint _tmp2_ = 0;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp2_ = mylane;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		self->priv->d_mylane = (guint) ((gushort) _tmp2_);
#line 317 "gitg-commit.c"
	}
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	gitg_commit_update_lane_tag (self);
#line 76 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (lanes);
#line 323 "gitg-commit.c"
}


GgitDiff* gitg_commit_get_diff (GitgCommit* self, GgitDiffOptions* options) {
	GgitDiff* result = NULL;
	GgitDiff* diff = NULL;
	GgitRepository* repo = NULL;
	GgitRepository* _tmp0_ = NULL;
	GgitDiff* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	diff = NULL;
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_object_get_owner ((GgitObject*) self);
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	repo = _tmp0_;
#line 342 "gitg-commit.c"
	{
		GgitCommitParents* parents = NULL;
		GgitCommitParents* _tmp1_ = NULL;
		GgitCommitParents* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp1_ = ggit_commit_get_parents ((GgitCommit*) self);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		parents = _tmp1_;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp2_ = parents;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp3_ = ggit_commit_parents_size (_tmp2_);
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		if (_tmp3_ == ((guint) 0)) {
#line 358 "gitg-commit.c"
			GgitDiff* _tmp4_ = NULL;
			GgitRepository* _tmp5_ = NULL;
			GgitTree* _tmp6_ = NULL;
			GgitTree* _tmp7_ = NULL;
			GgitDiffOptions* _tmp8_ = NULL;
			GgitDiff* _tmp9_ = NULL;
			GgitDiff* _tmp10_ = NULL;
			GgitDiff* _tmp11_ = NULL;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp5_ = repo;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp6_ = ggit_commit_get_tree ((GgitCommit*) self);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp7_ = _tmp6_;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp8_ = options;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp9_ = ggit_diff_new_tree_to_tree (_tmp5_, NULL, _tmp7_, _tmp8_, &_inner_error_);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp10_ = _tmp9_;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp7_);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp4_ = _tmp10_;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
				_ggit_commit_parents_unref0 (parents);
#line 387 "gitg-commit.c"
				goto __catch12_g_error;
			}
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp11_ = _tmp4_;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp4_ = NULL;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (diff);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			diff = _tmp11_;
#line 125 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (_tmp4_);
#line 400 "gitg-commit.c"
		} else {
			{
				gint i = 0;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
				i = 0;
#line 406 "gitg-commit.c"
				{
					gboolean _tmp12_ = FALSE;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
					_tmp12_ = TRUE;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
					while (TRUE) {
#line 413 "gitg-commit.c"
						gint _tmp14_ = 0;
						GgitCommitParents* _tmp15_ = NULL;
						guint _tmp16_ = 0U;
						GgitCommit* parent = NULL;
						GgitCommitParents* _tmp17_ = NULL;
						GgitCommit* _tmp18_ = NULL;
						gint _tmp19_ = 0;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						if (!_tmp12_) {
#line 423 "gitg-commit.c"
							gint _tmp13_ = 0;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp13_ = i;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							i = _tmp13_ + 1;
#line 429 "gitg-commit.c"
						}
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp12_ = FALSE;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp14_ = i;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp15_ = parents;
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp16_ = ggit_commit_parents_size (_tmp15_);
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						if (!(((guint) _tmp14_) < _tmp16_)) {
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							break;
#line 443 "gitg-commit.c"
						}
#line 136 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp17_ = parents;
#line 136 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp18_ = ggit_commit_parents_get (_tmp17_, (guint) 0);
#line 136 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						parent = _tmp18_;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_tmp19_ = i;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						if (_tmp19_ == 0) {
#line 455 "gitg-commit.c"
							GgitDiff* _tmp20_ = NULL;
							GgitRepository* _tmp21_ = NULL;
							GgitCommit* _tmp22_ = NULL;
							GgitTree* _tmp23_ = NULL;
							GgitTree* _tmp24_ = NULL;
							GgitTree* _tmp25_ = NULL;
							GgitTree* _tmp26_ = NULL;
							GgitDiffOptions* _tmp27_ = NULL;
							GgitDiff* _tmp28_ = NULL;
							GgitDiff* _tmp29_ = NULL;
							GgitDiff* _tmp30_ = NULL;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp21_ = repo;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp22_ = parent;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp23_ = ggit_commit_get_tree (_tmp22_);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp24_ = _tmp23_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp25_ = ggit_commit_get_tree ((GgitCommit*) self);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp26_ = _tmp25_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp27_ = options;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp28_ = ggit_diff_new_tree_to_tree (_tmp21_, _tmp24_, _tmp26_, _tmp27_, &_inner_error_);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp29_ = _tmp28_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (_tmp26_);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (_tmp24_);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp20_ = _tmp29_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_g_object_unref0 (parent);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_ggit_commit_parents_unref0 (parents);
#line 497 "gitg-commit.c"
								goto __catch12_g_error;
							}
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp30_ = _tmp20_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp20_ = NULL;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (diff);
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							diff = _tmp30_;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (_tmp20_);
#line 510 "gitg-commit.c"
						} else {
							GgitDiff* d = NULL;
							GgitRepository* _tmp31_ = NULL;
							GgitCommit* _tmp32_ = NULL;
							GgitTree* _tmp33_ = NULL;
							GgitTree* _tmp34_ = NULL;
							GgitTree* _tmp35_ = NULL;
							GgitTree* _tmp36_ = NULL;
							GgitDiffOptions* _tmp37_ = NULL;
							GgitDiff* _tmp38_ = NULL;
							GgitDiff* _tmp39_ = NULL;
							GgitDiff* _tmp40_ = NULL;
							GgitDiff* _tmp41_ = NULL;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp31_ = repo;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp32_ = parent;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp33_ = ggit_commit_get_tree (_tmp32_);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp34_ = _tmp33_;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp35_ = ggit_commit_get_tree ((GgitCommit*) self);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp36_ = _tmp35_;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp37_ = options;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp38_ = ggit_diff_new_tree_to_tree (_tmp31_, _tmp34_, _tmp36_, _tmp37_, &_inner_error_);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp39_ = _tmp38_;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (_tmp36_);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (_tmp34_);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							d = _tmp39_;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_g_object_unref0 (parent);
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_ggit_commit_parents_unref0 (parents);
#line 554 "gitg-commit.c"
								goto __catch12_g_error;
							}
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp40_ = diff;
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_tmp41_ = d;
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							ggit_diff_merge (_tmp40_, _tmp41_, &_inner_error_);
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_g_object_unref0 (d);
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_g_object_unref0 (parent);
#line 152 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
								_ggit_commit_parents_unref0 (parents);
#line 571 "gitg-commit.c"
								goto __catch12_g_error;
							}
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
							_g_object_unref0 (d);
#line 576 "gitg-commit.c"
						}
#line 134 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
						_g_object_unref0 (parent);
#line 580 "gitg-commit.c"
					}
				}
			}
		}
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_ggit_commit_parents_unref0 (parents);
#line 587 "gitg-commit.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp42_ = NULL;
		GError* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		e = _inner_error_;
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_inner_error_ = NULL;
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp42_ = stderr;
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp43_ = e;
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_tmp44_ = _tmp43_->message;
#line 159 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		fprintf (_tmp42_, "Error when getting diff: %s\n", _tmp44_);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_g_error_free0 (e);
#line 610 "gitg-commit.c"
	}
	__finally12:
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (repo);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		_g_object_unref0 (diff);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		return NULL;
#line 625 "gitg-commit.c"
	}
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp45_ = diff;
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	if (_tmp45_ != NULL) {
#line 631 "gitg-commit.c"
		{
			GgitDiff* _tmp46_ = NULL;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_tmp46_ = diff;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			ggit_diff_find_similar (_tmp46_, NULL, &_inner_error_);
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 640 "gitg-commit.c"
				goto __catch13_g_error;
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			g_clear_error (&_inner_error_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_inner_error_ = NULL;
#line 651 "gitg-commit.c"
		}
		__finally13:
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (repo);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			_g_object_unref0 (diff);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			g_clear_error (&_inner_error_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
			return NULL;
#line 666 "gitg-commit.c"
		}
	}
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = diff;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (repo);
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 675 "gitg-commit.c"
}


GitgCommit* gitg_commit_construct (GType object_type) {
	GitgCommit * self = NULL;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self = (GitgCommit*) g_object_new (object_type, NULL);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return self;
#line 685 "gitg-commit.c"
}


GitgCommit* gitg_commit_new (void) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return gitg_commit_construct (GITG_TYPE_COMMIT);
#line 692 "gitg-commit.c"
}


GitgLaneTag gitg_commit_get_tag (GitgCommit* self) {
	GitgLaneTag result;
	GitgLaneTag _tmp0_ = 0;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->_tag;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 707 "gitg-commit.c"
}


void gitg_commit_set_tag (GitgCommit* self, GitgLaneTag value) {
	GitgLaneTag _tmp0_ = 0;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = value;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv->_tag = _tmp0_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_notify ((GObject *) self, "tag");
#line 721 "gitg-commit.c"
}


guint gitg_commit_get_mylane (GitgCommit* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_mylane;
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp0_;
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 736 "gitg-commit.c"
}


void gitg_commit_set_mylane (GitgCommit* self, guint value) {
	guint _tmp0_ = 0U;
#line 38 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = value;
#line 40 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv->d_mylane = _tmp0_;
#line 41 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	gitg_commit_update_lane_tag (self);
#line 38 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_notify ((GObject *) self, "mylane");
#line 752 "gitg-commit.c"
}


GitgLane* gitg_commit_get_lane (GitgCommit* self) {
	GitgLane* result;
	GSList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = self->priv->d_lanes;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = self->priv->d_mylane;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = g_slist_nth_data (_tmp0_, _tmp1_);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = (GitgLane*) _tmp2_;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 773 "gitg-commit.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 786 "gitg-commit.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 817 "gitg-commit.c"
				goto __catch14_g_regex_error;
			}
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			return NULL;
#line 826 "gitg-commit.c"
		}
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 842 "gitg-commit.c"
				goto __catch14_g_regex_error;
			}
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
			return NULL;
#line 853 "gitg-commit.c"
		}
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 867 "gitg-commit.c"
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 881 "gitg-commit.c"
	}
	__finally14:
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return NULL;
#line 892 "gitg-commit.c"
	}
}


gchar* gitg_commit_get_format_patch_name (GitgCommit* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_subject ((GgitCommit*) self);
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = string_replace (_tmp0_, " ", "-");
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = _tmp1_;
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = string_replace (_tmp2_, "/", "-");
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = _tmp3_;
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_free0 (_tmp2_);
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp4_;
#line 92 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 922 "gitg-commit.c"
}


gchar* gitg_commit_get_committer_date_for_display (GitgCommit* self) {
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GitgDate* _tmp4_ = NULL;
	GitgDate* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 98 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_committer ((GgitCommit*) self);
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _tmp0_;
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = ggit_signature_get_time (_tmp1_);
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = _tmp2_;
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp1_);
#line 100 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	dt = _tmp3_;
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = gitg_date_new_for_date_time (dt);
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = _tmp4_;
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = gitg_date_for_display (_tmp5_);
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = _tmp6_;
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp7_;
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_date_time_unref0 (dt);
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 967 "gitg-commit.c"
}


gchar* gitg_commit_get_author_date_for_display (GitgCommit* self) {
	gchar* result;
	GDateTime* dt = NULL;
	GgitSignature* _tmp0_ = NULL;
	GgitSignature* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GitgDate* _tmp4_ = NULL;
	GitgDate* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp0_ = ggit_commit_get_author ((GgitCommit*) self);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp1_ = _tmp0_;
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp2_ = ggit_signature_get_time (_tmp1_);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp3_ = _tmp2_;
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp1_);
#line 109 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	dt = _tmp3_;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp4_ = gitg_date_new_for_date_time (dt);
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp5_ = _tmp4_;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp6_ = gitg_date_for_display (_tmp5_);
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_object_unref0 (_tmp5_);
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	result = _tmp7_;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	_g_date_time_unref0 (dt);
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	return result;
#line 1012 "gitg-commit.c"
}


static void gitg_commit_class_init (GitgCommitClass * klass) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	gitg_commit_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_type_class_add_private (klass, sizeof (GitgCommitPrivate));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_commit_get_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_commit_set_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_commit_finalize;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_TAG, g_param_spec_flags ("tag", "tag", "tag", GITG_TYPE_LANE_TAG, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_MYLANE, g_param_spec_uint ("mylane", "mylane", "mylane", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_LANE, g_param_spec_object ("lane", "lane", "lane", GITG_TYPE_LANE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_FORMAT_PATCH_NAME, g_param_spec_string ("format-patch-name", "format-patch-name", "format-patch-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY, g_param_spec_string ("committer-date-for-display", "committer-date-for-display", "committer-date-for-display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY, g_param_spec_string ("author-date-for-display", "author-date-for-display", "author-date-for-display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1039 "gitg-commit.c"
}


static void gitg_commit_instance_init (GitgCommit * self) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self->priv = GITG_COMMIT_GET_PRIVATE (self);
#line 1046 "gitg-commit.c"
}


static void gitg_commit_finalize (GObject* obj) {
	GitgCommit * self;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_COMMIT, GitgCommit);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_lanes);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	G_OBJECT_CLASS (gitg_commit_parent_class)->finalize (obj);
#line 1058 "gitg-commit.c"
}


GType gitg_commit_get_type (void) {
	static volatile gsize gitg_commit_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_commit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgCommitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_commit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCommit), 0, (GInstanceInitFunc) gitg_commit_instance_init, NULL };
		GType gitg_commit_type_id;
		gitg_commit_type_id = g_type_register_static (ggit_commit_get_type (), "GitgCommit", &g_define_type_info, 0);
		g_once_init_leave (&gitg_commit_type_id__volatile, gitg_commit_type_id);
	}
	return gitg_commit_type_id__volatile;
}


static void _vala_gitg_commit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_TAG:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_set_flags (value, gitg_commit_get_tag (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_MYLANE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_set_uint (value, gitg_commit_get_mylane (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_LANE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_set_object (value, gitg_commit_get_lane (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_FORMAT_PATCH_NAME:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_format_patch_name (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_COMMITTER_DATE_FOR_DISPLAY:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_committer_date_for_display (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_AUTHOR_DATE_FOR_DISPLAY:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		g_value_take_string (value, gitg_commit_get_author_date_for_display (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 1115 "gitg-commit.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 1121 "gitg-commit.c"
	}
}


static void _vala_gitg_commit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgCommit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_COMMIT, GitgCommit);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_TAG:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		gitg_commit_set_tag (self, g_value_get_flags (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		case GITG_COMMIT_MYLANE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		gitg_commit_set_mylane (self, g_value_get_uint (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 1143 "gitg-commit.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-commit.vala"
		break;
#line 1149 "gitg-commit.c"
	}
}



