-- history-must-be-merges.update.lua
--
-- Example for hooks/update.lua in a project which ensures that all
-- branches (refs/heads/...) only ever get merge commits.
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--

local repo, ref, oldsha, newsha = ...

local branch = ref:match("^refs/heads/(.+)$")
if branch then
   log.state("Looking at commit history on: " .. branch)

   local commit = repo:get(newsha)

   while commit.sha ~= oldsha do
      commit = commit.content
      local parents = commit.parents
      if #parents < 2 then
         error("Detected non-merge-commit during parent walk, at " .. commit.sha)
      end
      commit = parents[1]
   end

   log.state("Commits between old and new sha seem to all be merge commits")
else
   log.state("Skipping commit history check on: " .. ref)
end
