-- jenkins-notify.post-receive.lua
--
-- Example post-receive global hook which notifies a Jenkins instance on
-- any and all refs updates (except refs/gitano/*) which happen.
--
-- It notifies Jenkins *before* passing the updates on to the project hook.
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- This is an example which is part of Gitano.
--

local project_hook, repo, updates = ...

local jenkinshost = "ci.gitano.org.uk"
local basepath = "/jenkins/git/notifyCommit?url="
local urlbase = "git://git.gitano.org.uk/"

local notify_jenkins = false

for ref in pairs(updates) do
   if not ref:match("^refs/gitano/") then
      notify_jenkins = true
   end
end

if notify_jenkins then
   log.state("Notifying Jenkins...")
   local code, msg, headers, content =
      http_get(jenkinshost, basepath .. urlbase .. repo.name .. ".git")
   if code ~= "200" then
      log.state("Notification failed somehow")
   end
   for line in content:gmatch("([^\r\n]*)\r?\n") do
      log.state("jenkins: " .. line)
   end
end

-- Finally, chain to the project hook
return project_hook(repo, updates)
