-- Demo Plugin
--
-- This is a demonstration plugin which will not be installed as part of
-- Gitano.  Its purpose is to show the way that a plugin can add commands
-- to Gitano if it so desires.
--
-- Copyright 2014 Daniel Silverstone <daniel.silverstone@codethink.co.uk>

local gitano = require "gitano"

local demo_short_help = "Simple demo command"
local demo_helptext = [[
This is the long help text for the demonstration plugin 'demo' command.

Enjoy.
]]

local function demo_validate(config, repo, cmdline)
   if #cmdline ~= 2 then
      gitano.log.error("usage: demo <reponame>")
      return false
   end
   return true
end

local function demo_prep(config, repo, cmdline, context)
   context.operation = "read"
   return config.repo:run_lace(context)
end

local function demo_run(config, repo, cmdline, env)
   local p = gitano.log.stdout
   p(("Repo is: %s"):format(tostring(repo)))
   for i, n in ipairs(cmdline) do
      p(("cmdline[%d] is: %s"):format(i, tostring(n)))
   end
   for k, v in pairs(env) do
      p(("env[%s] is: %s"):format(k, tostring(v)))
   end
   return "exit", 0
end

assert(gitano.command.register("demo",
                               demo_short_help, demo_helptext,
                               demo_validate, demo_prep, demo_run,
                               true, false, false))
