local gitano = require "gitano"

local function builtin_upload_archive_validate(config, repo, cmdline)
   -- git-upload-archive repo
   if #cmdline > 2 then
      return false
   end
   cmdline[2] = repo:fs_path()
   return true
end

local function builtin_upload_archive_prep(config, repo, cmdline, context)
   if repo.is_nascent then
      return "deny", "Repository " .. repo.name .. " does not exist"
   end
   -- git-upload-archive is always a simple write operation
   context.operation = "read"
   return repo:run_lace(context)
end

local function builtin_upload_archive_run(config, repo, cmdline, env)
   local cmdcopy = {"upload-archive", env=env}
   for i = 2, #cmdline do cmdcopy[i] = cmdline[i] end
   return repo:git_command(cmdcopy)
end

assert(gitano.command.register("git-upload-archive", nil, nil,
                               builtin_upload_archive_validate,
                               builtin_upload_archive_prep,
                               builtin_upload_archive_run,
                               true, true))
