-- cia-notify.post-receive.lua
--
-- Example post-receive global hook which notifies cia.vc on ref updates
-- which match any of the patterns provided by the project.
--
-- It notifies CIA.vc *before* passing the updates on to the project hook.
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- This is an example which is part of Gitano.
--

local project_hook, repo, updates = ...

local empty = "0000000000000000000000000000000000000000"

local cia_project = repo:get_config("cia.project")
if cia_project then
   local refpatterns = repo:get_config_list("cia.branches")
   if not refpatterns or #refpatterns == 0 then
      refpatterns = { ".*" }
   end
   for i = 1, #refpatterns do
      refpatterns[i] = "^refs/heads/" .. refpatterns[i]
   end
   for ref, details in pairs(updates) do
      if details.newsha ~= empty and details.oldsha ~= empty then
	 local refmatched = false
	 for i = 1, #refpatterns do
	    if ref:match(refpatterns[i]) then
	       refmatched = true
	       break
	    end
	 end
	 if refmatched then
	    log.chat("Informing CIA of commits on", ref:sub(12))
	    cia.inform_commits(cia_project, ref:sub(12), repo,
			       details.oldsha, details.newsha)
	 end
      end
   end
end

-- Finally, chain to the project hook
return project_hook(repo, updates)
