-- en.lua
--
-- English language pack base for Gitano (Basically en_GB)
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--

return {
   -- The SETUP_ tokens are for the gitano-setup binary
   SETUP_USAGE = [[
usage: gitano-setup [<answers-file>...]

This tool creates the basic repository setup for a Gitano instance.

This is an interactive tool where if it has any questions for you, it will
visit each answers file in turn until it finds the answer.  This means
that for automation purposes you can specify multiple answers files with
the earlier ones overriding the later ones.

In summary, the behaviour is as follows:

The repository root is created if it does not exist, and a gitano-admin.git
repository is created within it.  Said repository is populated with the
example administration repository rules and an admin user and group.
]],
   SETUP_DEBUG_PARSING_ANSWERS = "Parsing answers file: ${file}",
   SETUP_DEBUG_COMBINE_ANSWERS = "Combining answers into conf...",
   SETUP_WELCOME = "Welcome to the Gitano setup process",
   SETUP_DO_CHECKS = "Performing system checks",
   SETUP_CHECK_SUPPLE = "... Checking supple sandboxing",
   SETUP_CHECK_SUPPLE_UNABLE = "... Supple unable to run trivial sandboxed code",
   SETUP_CHECK_SUPPLE_VALUES = "... Supple unable to pass trivial values in and out",
   SETUP_CHECK_SUPPLE_BIDIRECTIONAL = "... Supple unable to communicate bidirectionally",
   SETUP_CHECK_FAILED = "... Unable to run supple test",
   SETUP_CHECK_OK = "System checks out",
   SETUP_SETTING_IS = "Setting: ${key} is ${value}",
   SETUP_NOT_A_DIR = "${path}: not a directory",
   SETUP_ERROR_INVALID_NAME = "Invalid name: ${name}",
   SETUP_BATCH_MODE = "Batch mode engaged",
   SETUP_INTERACTIVE_MODE = "Interactive mode engaged",
   SETUP_STEP_1 = "Step 1: Determine everything",
   SETUP_PATHS_HOME_INFO = "Home directory for new Gitano user",
   SETUP_PATHS_SSH_INFO = "SSH directory for new Gitano user",
   SETUP_PATHS_PUBKEY_INFO = "Public key file for admin user",
   SETUP_PATHS_PUBKEY_NOT_FOUND = "Cannot find public key",
   SETUP_PATHS_REPOS_INFO = "Repository path for new Gitano instance",
   SETUP_ADMIN_USERNAME_INFO = "User name for admin user",
   SETUP_ADMIN_REALNAME_INFO = "Real name for admin user",
   SETUP_ADMIN_EMAIL_INFO = "Email address for admin user",
   SETUP_ADMIN_KEYNAME_INFO = "Key name for administrator",
   SETUP_SITE_NAME_INFO = "Site name",
   SETUP_LOG_PREFIX_INFO = "Site log prefix",
   SETUP_USE_HTPASSWD_INFO = "Store passwords with htpasswd? (needed for http authentication)",
   SETUP_PATHS_SKEL_INFO = "Path to skeleton gitano-admin content",
   SETUP_STEP_2 = "Step 2: Gather required content",
   SETUP_PREP_SITE_CONFIG = "=> Prepare site config",
   SETUP_ACQUIRE_SKEL = "=> Acquire skeleton gitano-admin",
   SETUP_PREP_ADMIN_USER = "=> Preparing administration user (${user})",
   SETUP_PREP_GITANO_ADMIN = "=> Preparing gitano-admin group",
   SETUP_STEP_3 = "Step 3: Write out paths and gitano-admin.git",
   SETUP_MAKE_PATHS = "=> Make paths",
   SETUP_PREPARE_REPO = "=> Prepare repository",
   SETUP_PREPARE_FLAT_TREE = "=> Create a flattened tree",
   SETUP_PREPARE_COMMIT = "=> Commit that tree",
   SETUP_PREPARE_MASTER = "=> Attach that commit to master",
   SETUP_CHECK_ADMIN_REPO = "=> Ensure we can parse our resultant admin repository",
   SETUP_ERROR_NO_USER = "Could not find user",
   SETUP_ERROR_NOT_ADMIN = "User was not a gitano-admin",
   SETUP_ADMIN_REF = "=> Change the admin ref for gitano-admin.git",
   SETUP_WRITE_SSHKEYS = "=> Write the SSH authorized_keys file out",
   SETUP_COMPLETED = "Gitano setup completed",

   -- General errors used in many scripts
   ERROR_CANNOT_FIND_ADMIN_REPO = "Unable to locate administration repository.  Cannot continue",
   ERROR_BAD_ADMIN_REPO = "Unable to find the HEAD of the administration repository.  Cannot continue",
   ERROR_NO_COMMAND = "No command provided, cannot continue",
   ERROR_COMMAND_FAILED = "Error running command, exiting",
   ERROR_NOT_AUTHORISED = "Not authorised",
   ERROR_NO_ADMIN_REPO = "Unable to locate administration repository.  Cannot continue",
   ERROR_CANNOT_PARSE_ADMIN = "Unable to parse administration repository.",
   ERROR_CANNOT_CONTINUE = "Cannot continue",
   ERROR_CANNOT_LOCATE_REPO = "Unable to locate repository.",
   ERROR_REPO_IS_NASCENT = "Repository ${name} is nascent.",
   ERROR_NO_ERROR_FOUND = "No reason given, but errored somehow.",
   ERROR_RULESET_UNCLEAN_FINISH = "Ruleset did not complete cleanly.",
   ERROR_RULESET_DENIED_ACTION = "Ruleset denied action.  Sorry.",
   ERROR_ACTIONS_REFUSED_ACTION = "Builtin action handlers denied action.  Sorry",

   -- General messages which might be useful in various places
   FINISHED = "Finished",
   
   -- Messages from post-receive
   CHANGES_TO_ADMINREF_APPLIED = "<${name}> Any changes to admin ref have been applied",
   CHANGES_TO_HOOKS_APPLIED = "<${name}> Any changes to hooks etc have been applied",
   ERROR_UNABLE_TO_PROCESS = "<${name}> Unable to process: ${msg}",
   SCANNING_FOR_UPDATES = "Scanning repositories to apply hook/rules updates...",
   ALL_UPDATES_DONE = "All repositories updated where possible.",
   ERROR_UPDATE_SSH_NOT_WORK = "Updating SSH keys didn't work?",
   UPDATE_HTTP_INFO = "Updating server info for dumb HTTP transport",
   UPDATE_LASTMOD_DATE = "Updating last-modified date",
   RUNNING_POST_RECEIVE_HOOK = "Running repository post-receive hook",

   -- Messages from pre-receive
   RUNNING_PRE_RECEIVE_HOOK = "Running repository pre-receive hook",
   ODD_OLD_OBJECT_NOT_COMMIT_OR_TAG = "Odd, old object ${sha} is not a commit or tag",
   ODD_NEW_OBJECT_NOT_COMMIT_OR_TAG = "Odd, old object ${sha} is not a commit or tag",
   GENERATING_TREEDELTAS = "Treedeltas generating because of ${key}, please hold.",
   GENERATED_TREEDELTAS = "Treedeltas built, continuing.",
   ERROR_RULES_REFUSED_UPDATE = "Rules refused update: ${reason}",
   ERROR_BUILTIN_HANDLERS_SAID = "Builtin action handlers said: ${msg}",
   RUNNING_UPDATE_HOOK = "Running repository update hook",
   ALLOWING_UPDATE = "Allowing ref update of ${ref} from ${old} to ${new}",

   -- Messages from update-ssh
   UPDATE_SSH_USAGE = "Usage: gitano-update-ssh /path/to/repos",
}
