// Code generated by smithy-go-codegen DO NOT EDIT.

package greengrassv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/greengrassv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateServiceRoleToAccount struct {
}

func (*awsRestjson1_serializeOpAssociateServiceRoleToAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateServiceRoleToAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateServiceRoleToAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/servicerole")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateServiceRoleToAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateServiceRoleToAccountInput(v *AssociateServiceRoleToAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateServiceRoleToAccountInput(v *AssociateServiceRoleToAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpBatchAssociateClientDeviceWithCoreDevice struct {
}

func (*awsRestjson1_serializeOpBatchAssociateClientDeviceWithCoreDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchAssociateClientDeviceWithCoreDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchAssociateClientDeviceWithCoreDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}/associateClientDevices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchAssociateClientDeviceWithCoreDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchAssociateClientDeviceWithCoreDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchAssociateClientDeviceWithCoreDeviceInput(v *BatchAssociateClientDeviceWithCoreDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchAssociateClientDeviceWithCoreDeviceInput(v *BatchAssociateClientDeviceWithCoreDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entries != nil {
		ok := object.Key("entries")
		if err := awsRestjson1_serializeDocumentAssociateClientDeviceWithCoreDeviceEntryList(v.Entries, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDisassociateClientDeviceFromCoreDevice struct {
}

func (*awsRestjson1_serializeOpBatchDisassociateClientDeviceFromCoreDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDisassociateClientDeviceFromCoreDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDisassociateClientDeviceFromCoreDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}/disassociateClientDevices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDisassociateClientDeviceFromCoreDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDisassociateClientDeviceFromCoreDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDisassociateClientDeviceFromCoreDeviceInput(v *BatchDisassociateClientDeviceFromCoreDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDisassociateClientDeviceFromCoreDeviceInput(v *BatchDisassociateClientDeviceFromCoreDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entries != nil {
		ok := object.Key("entries")
		if err := awsRestjson1_serializeDocumentDisassociateClientDeviceFromCoreDeviceEntryList(v.Entries, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelDeployment struct {
}

func (*awsRestjson1_serializeOpCancelDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/deployments/{deploymentId}/cancel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelDeploymentInput(v *CancelDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member deploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("deploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateComponentVersion struct {
}

func (*awsRestjson1_serializeOpCreateComponentVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateComponentVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateComponentVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/createComponentVersion")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateComponentVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateComponentVersionInput(v *CreateComponentVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateComponentVersionInput(v *CreateComponentVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.InlineRecipe != nil {
		ok := object.Key("inlineRecipe")
		ok.Base64EncodeBytes(v.InlineRecipe)
	}

	if v.LambdaFunction != nil {
		ok := object.Key("lambdaFunction")
		if err := awsRestjson1_serializeDocumentLambdaFunctionRecipeSource(v.LambdaFunction, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDeployment struct {
}

func (*awsRestjson1_serializeOpCreateDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/deployments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDeploymentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDeploymentInput(v *CreateDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDeploymentInput(v *CreateDeploymentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Components != nil {
		ok := object.Key("components")
		if err := awsRestjson1_serializeDocumentComponentDeploymentSpecifications(v.Components, ok); err != nil {
			return err
		}
	}

	if v.DeploymentName != nil {
		ok := object.Key("deploymentName")
		ok.String(*v.DeploymentName)
	}

	if v.DeploymentPolicies != nil {
		ok := object.Key("deploymentPolicies")
		if err := awsRestjson1_serializeDocumentDeploymentPolicies(v.DeploymentPolicies, ok); err != nil {
			return err
		}
	}

	if v.IotJobConfiguration != nil {
		ok := object.Key("iotJobConfiguration")
		if err := awsRestjson1_serializeDocumentDeploymentIoTJobConfiguration(v.IotJobConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteComponent struct {
}

func (*awsRestjson1_serializeOpDeleteComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components/{arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(v *DeleteComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCoreDevice struct {
}

func (*awsRestjson1_serializeOpDeleteCoreDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCoreDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCoreDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCoreDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCoreDeviceInput(v *DeleteCoreDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDeployment struct {
}

func (*awsRestjson1_serializeOpDeleteDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/deployments/{deploymentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDeploymentInput(v *DeleteDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member deploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("deploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeComponent struct {
}

func (*awsRestjson1_serializeOpDescribeComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components/{arn}/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeComponentInput(v *DescribeComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateServiceRoleFromAccount struct {
}

func (*awsRestjson1_serializeOpDisassociateServiceRoleFromAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateServiceRoleFromAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateServiceRoleFromAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/servicerole")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateServiceRoleFromAccountInput(v *DisassociateServiceRoleFromAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetComponent struct {
}

func (*awsRestjson1_serializeOpGetComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components/{arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetComponentInput(v *GetComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	if len(v.RecipeOutputFormat) > 0 {
		encoder.SetQuery("recipeOutputFormat").String(string(v.RecipeOutputFormat))
	}

	return nil
}

type awsRestjson1_serializeOpGetComponentVersionArtifact struct {
}

func (*awsRestjson1_serializeOpGetComponentVersionArtifact) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetComponentVersionArtifact) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetComponentVersionArtifactInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components/{arn}/artifacts/{artifactName+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetComponentVersionArtifactInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetComponentVersionArtifactInput(v *GetComponentVersionArtifactInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	if v.ArtifactName == nil || len(*v.ArtifactName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member artifactName must not be empty")}
	}
	if v.ArtifactName != nil {
		if err := encoder.SetURI("artifactName").String(*v.ArtifactName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConnectivityInfo struct {
}

func (*awsRestjson1_serializeOpGetConnectivityInfo) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConnectivityInfo) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConnectivityInfoInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/things/{thingName}/connectivityInfo")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConnectivityInfoInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConnectivityInfoInput(v *GetConnectivityInfoInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCoreDevice struct {
}

func (*awsRestjson1_serializeOpGetCoreDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCoreDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCoreDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCoreDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCoreDeviceInput(v *GetCoreDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDeployment struct {
}

func (*awsRestjson1_serializeOpGetDeployment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDeployment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeploymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/deployments/{deploymentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDeploymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDeploymentInput(v *GetDeploymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeploymentId == nil || len(*v.DeploymentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member deploymentId must not be empty")}
	}
	if v.DeploymentId != nil {
		if err := encoder.SetURI("deploymentId").String(*v.DeploymentId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetServiceRoleForAccount struct {
}

func (*awsRestjson1_serializeOpGetServiceRoleForAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetServiceRoleForAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetServiceRoleForAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/servicerole")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetServiceRoleForAccountInput(v *GetServiceRoleForAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListClientDevicesAssociatedWithCoreDevice struct {
}

func (*awsRestjson1_serializeOpListClientDevicesAssociatedWithCoreDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListClientDevicesAssociatedWithCoreDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClientDevicesAssociatedWithCoreDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}/associatedClientDevices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListClientDevicesAssociatedWithCoreDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListClientDevicesAssociatedWithCoreDeviceInput(v *ListClientDevicesAssociatedWithCoreDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListComponents struct {
}

func (*awsRestjson1_serializeOpListComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListComponentsInput(v *ListComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Scope) > 0 {
		encoder.SetQuery("scope").String(string(v.Scope))
	}

	return nil
}

type awsRestjson1_serializeOpListComponentVersions struct {
}

func (*awsRestjson1_serializeOpListComponentVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListComponentVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListComponentVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/components/{arn}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListComponentVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListComponentVersionsInput(v *ListComponentVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("arn").String(*v.Arn); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCoreDevices struct {
}

func (*awsRestjson1_serializeOpListCoreDevices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCoreDevices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCoreDevicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCoreDevicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCoreDevicesInput(v *ListCoreDevicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	if v.ThingGroupArn != nil {
		encoder.SetQuery("thingGroupArn").String(*v.ThingGroupArn)
	}

	return nil
}

type awsRestjson1_serializeOpListDeployments struct {
}

func (*awsRestjson1_serializeOpListDeployments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDeployments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDeploymentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/deployments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDeploymentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDeploymentsInput(v *ListDeploymentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.HistoryFilter) > 0 {
		encoder.SetQuery("historyFilter").String(string(v.HistoryFilter))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TargetArn != nil {
		encoder.SetQuery("targetArn").String(*v.TargetArn)
	}

	return nil
}

type awsRestjson1_serializeOpListEffectiveDeployments struct {
}

func (*awsRestjson1_serializeOpListEffectiveDeployments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEffectiveDeployments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEffectiveDeploymentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}/effectiveDeployments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEffectiveDeploymentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEffectiveDeploymentsInput(v *ListEffectiveDeploymentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInstalledComponents struct {
}

func (*awsRestjson1_serializeOpListInstalledComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInstalledComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstalledComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/coreDevices/{coreDeviceThingName}/installedComponents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInstalledComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInstalledComponentsInput(v *ListInstalledComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CoreDeviceThingName == nil || len(*v.CoreDeviceThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member coreDeviceThingName must not be empty")}
	}
	if v.CoreDeviceThingName != nil {
		if err := encoder.SetURI("coreDeviceThingName").String(*v.CoreDeviceThingName); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpResolveComponentCandidates struct {
}

func (*awsRestjson1_serializeOpResolveComponentCandidates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpResolveComponentCandidates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResolveComponentCandidatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/v2/resolveComponentCandidates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentResolveComponentCandidatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsResolveComponentCandidatesInput(v *ResolveComponentCandidatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentResolveComponentCandidatesInput(v *ResolveComponentCandidatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentCandidates != nil {
		ok := object.Key("componentCandidates")
		if err := awsRestjson1_serializeDocumentComponentCandidateList(v.ComponentCandidates, ok); err != nil {
			return err
		}
	}

	if v.Platform != nil {
		ok := object.Key("platform")
		if err := awsRestjson1_serializeDocumentComponentPlatform(v.Platform, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConnectivityInfo struct {
}

func (*awsRestjson1_serializeOpUpdateConnectivityInfo) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConnectivityInfo) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectivityInfoInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/greengrass/things/{thingName}/connectivityInfo")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConnectivityInfoInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConnectivityInfoInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConnectivityInfoInput(v *UpdateConnectivityInfoInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ThingName == nil || len(*v.ThingName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member thingName must not be empty")}
	}
	if v.ThingName != nil {
		if err := encoder.SetURI("thingName").String(*v.ThingName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConnectivityInfoInput(v *UpdateConnectivityInfoInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectivityInfo != nil {
		ok := object.Key("ConnectivityInfo")
		if err := awsRestjson1_serializeDocumentConnectivityInfoList(v.ConnectivityInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssociateClientDeviceWithCoreDeviceEntry(v *types.AssociateClientDeviceWithCoreDeviceEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssociateClientDeviceWithCoreDeviceEntryList(v []types.AssociateClientDeviceWithCoreDeviceEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssociateClientDeviceWithCoreDeviceEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentCandidate(v *types.ComponentCandidate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.ComponentVersion != nil {
		ok := object.Key("componentVersion")
		ok.String(*v.ComponentVersion)
	}

	if v.VersionRequirements != nil {
		ok := object.Key("versionRequirements")
		if err := awsRestjson1_serializeDocumentComponentVersionRequirementMap(v.VersionRequirements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentCandidateList(v []types.ComponentCandidate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentCandidate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentConfigurationPathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentConfigurationUpdate(v *types.ComponentConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Merge != nil {
		ok := object.Key("merge")
		ok.String(*v.Merge)
	}

	if v.Reset != nil {
		ok := object.Key("reset")
		if err := awsRestjson1_serializeDocumentComponentConfigurationPathList(v.Reset, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentDependencyMap(v map[string]types.ComponentDependencyRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentDependencyRequirement(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentDependencyRequirement(v *types.ComponentDependencyRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DependencyType) > 0 {
		ok := object.Key("dependencyType")
		ok.String(string(v.DependencyType))
	}

	if v.VersionRequirement != nil {
		ok := object.Key("versionRequirement")
		ok.String(*v.VersionRequirement)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentDeploymentSpecification(v *types.ComponentDeploymentSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentVersion != nil {
		ok := object.Key("componentVersion")
		ok.String(*v.ComponentVersion)
	}

	if v.ConfigurationUpdate != nil {
		ok := object.Key("configurationUpdate")
		if err := awsRestjson1_serializeDocumentComponentConfigurationUpdate(v.ConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.RunWith != nil {
		ok := object.Key("runWith")
		if err := awsRestjson1_serializeDocumentComponentRunWith(v.RunWith, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentDeploymentSpecifications(v map[string]types.ComponentDeploymentSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentDeploymentSpecification(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentPlatform(v *types.ComponentPlatform, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentPlatformAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentPlatformList(v []types.ComponentPlatform, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentPlatform(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentRunWith(v *types.ComponentRunWith, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PosixUser != nil {
		ok := object.Key("posixUser")
		ok.String(*v.PosixUser)
	}

	if v.SystemResourceLimits != nil {
		ok := object.Key("systemResourceLimits")
		if err := awsRestjson1_serializeDocumentSystemResourceLimits(v.SystemResourceLimits, ok); err != nil {
			return err
		}
	}

	if v.WindowsUser != nil {
		ok := object.Key("windowsUser")
		ok.String(*v.WindowsUser)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentVersionRequirementMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentConnectivityInfo(v *types.ConnectivityInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HostAddress != nil {
		ok := object.Key("HostAddress")
		ok.String(*v.HostAddress)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		ok.String(*v.Metadata)
	}

	if v.PortNumber != 0 {
		ok := object.Key("PortNumber")
		ok.Integer(v.PortNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectivityInfoList(v []types.ConnectivityInfo, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentConnectivityInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDeploymentComponentUpdatePolicy(v *types.DeploymentComponentUpdatePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.TimeoutInSeconds != 0 {
		ok := object.Key("timeoutInSeconds")
		ok.Integer(v.TimeoutInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeploymentConfigurationValidationPolicy(v *types.DeploymentConfigurationValidationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeoutInSeconds != 0 {
		ok := object.Key("timeoutInSeconds")
		ok.Integer(v.TimeoutInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeploymentIoTJobConfiguration(v *types.DeploymentIoTJobConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbortConfig != nil {
		ok := object.Key("abortConfig")
		if err := awsRestjson1_serializeDocumentIoTJobAbortConfig(v.AbortConfig, ok); err != nil {
			return err
		}
	}

	if v.JobExecutionsRolloutConfig != nil {
		ok := object.Key("jobExecutionsRolloutConfig")
		if err := awsRestjson1_serializeDocumentIoTJobExecutionsRolloutConfig(v.JobExecutionsRolloutConfig, ok); err != nil {
			return err
		}
	}

	if v.TimeoutConfig != nil {
		ok := object.Key("timeoutConfig")
		if err := awsRestjson1_serializeDocumentIoTJobTimeoutConfig(v.TimeoutConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDeploymentPolicies(v *types.DeploymentPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentUpdatePolicy != nil {
		ok := object.Key("componentUpdatePolicy")
		if err := awsRestjson1_serializeDocumentDeploymentComponentUpdatePolicy(v.ComponentUpdatePolicy, ok); err != nil {
			return err
		}
	}

	if v.ConfigurationValidationPolicy != nil {
		ok := object.Key("configurationValidationPolicy")
		if err := awsRestjson1_serializeDocumentDeploymentConfigurationValidationPolicy(v.ConfigurationValidationPolicy, ok); err != nil {
			return err
		}
	}

	if len(v.FailureHandlingPolicy) > 0 {
		ok := object.Key("failureHandlingPolicy")
		ok.String(string(v.FailureHandlingPolicy))
	}

	return nil
}

func awsRestjson1_serializeDocumentDisassociateClientDeviceFromCoreDeviceEntry(v *types.DisassociateClientDeviceFromCoreDeviceEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDisassociateClientDeviceFromCoreDeviceEntryList(v []types.DisassociateClientDeviceFromCoreDeviceEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDisassociateClientDeviceFromCoreDeviceEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIoTJobAbortConfig(v *types.IoTJobAbortConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CriteriaList != nil {
		ok := object.Key("criteriaList")
		if err := awsRestjson1_serializeDocumentIoTJobAbortCriteriaList(v.CriteriaList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIoTJobAbortCriteria(v *types.IoTJobAbortCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if len(v.FailureType) > 0 {
		ok := object.Key("failureType")
		ok.String(string(v.FailureType))
	}

	{
		ok := object.Key("minNumberOfExecutedThings")
		ok.Integer(v.MinNumberOfExecutedThings)
	}

	{
		ok := object.Key("thresholdPercentage")
		switch {
		case math.IsNaN(v.ThresholdPercentage):
			ok.String("NaN")

		case math.IsInf(v.ThresholdPercentage, 1):
			ok.String("Infinity")

		case math.IsInf(v.ThresholdPercentage, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.ThresholdPercentage)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIoTJobAbortCriteriaList(v []types.IoTJobAbortCriteria, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIoTJobAbortCriteria(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIoTJobExecutionsRolloutConfig(v *types.IoTJobExecutionsRolloutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExponentialRate != nil {
		ok := object.Key("exponentialRate")
		if err := awsRestjson1_serializeDocumentIoTJobExponentialRolloutRate(v.ExponentialRate, ok); err != nil {
			return err
		}
	}

	if v.MaximumPerMinute != 0 {
		ok := object.Key("maximumPerMinute")
		ok.Integer(v.MaximumPerMinute)
	}

	return nil
}

func awsRestjson1_serializeDocumentIoTJobExponentialRolloutRate(v *types.IoTJobExponentialRolloutRate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("baseRatePerMinute")
		ok.Integer(v.BaseRatePerMinute)
	}

	{
		ok := object.Key("incrementFactor")
		switch {
		case math.IsNaN(v.IncrementFactor):
			ok.String("NaN")

		case math.IsInf(v.IncrementFactor, 1):
			ok.String("Infinity")

		case math.IsInf(v.IncrementFactor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.IncrementFactor)

		}
	}

	if v.RateIncreaseCriteria != nil {
		ok := object.Key("rateIncreaseCriteria")
		if err := awsRestjson1_serializeDocumentIoTJobRateIncreaseCriteria(v.RateIncreaseCriteria, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIoTJobRateIncreaseCriteria(v *types.IoTJobRateIncreaseCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumberOfNotifiedThings != 0 {
		ok := object.Key("numberOfNotifiedThings")
		ok.Integer(v.NumberOfNotifiedThings)
	}

	if v.NumberOfSucceededThings != 0 {
		ok := object.Key("numberOfSucceededThings")
		ok.Integer(v.NumberOfSucceededThings)
	}

	return nil
}

func awsRestjson1_serializeDocumentIoTJobTimeoutConfig(v *types.IoTJobTimeoutConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InProgressTimeoutInMinutes != 0 {
		ok := object.Key("inProgressTimeoutInMinutes")
		ok.Long(v.InProgressTimeoutInMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaContainerParams(v *types.LambdaContainerParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Devices != nil {
		ok := object.Key("devices")
		if err := awsRestjson1_serializeDocumentLambdaDeviceList(v.Devices, ok); err != nil {
			return err
		}
	}

	if v.MemorySizeInKB != 0 {
		ok := object.Key("memorySizeInKB")
		ok.Integer(v.MemorySizeInKB)
	}

	if v.MountROSysfs {
		ok := object.Key("mountROSysfs")
		ok.Boolean(v.MountROSysfs)
	}

	if v.Volumes != nil {
		ok := object.Key("volumes")
		if err := awsRestjson1_serializeDocumentLambdaVolumeList(v.Volumes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaDeviceList(v []types.LambdaDeviceMount, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLambdaDeviceMount(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLambdaDeviceMount(v *types.LambdaDeviceMount, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddGroupOwner {
		ok := object.Key("addGroupOwner")
		ok.Boolean(v.AddGroupOwner)
	}

	if v.Path != nil {
		ok := object.Key("path")
		ok.String(*v.Path)
	}

	if len(v.Permission) > 0 {
		ok := object.Key("permission")
		ok.String(string(v.Permission))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaEnvironmentVariables(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentLambdaEventSource(v *types.LambdaEventSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Topic != nil {
		ok := object.Key("topic")
		ok.String(*v.Topic)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaEventSourceList(v []types.LambdaEventSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLambdaEventSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLambdaExecArgsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLambdaExecutionParameters(v *types.LambdaExecutionParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnvironmentVariables != nil {
		ok := object.Key("environmentVariables")
		if err := awsRestjson1_serializeDocumentLambdaEnvironmentVariables(v.EnvironmentVariables, ok); err != nil {
			return err
		}
	}

	if v.EventSources != nil {
		ok := object.Key("eventSources")
		if err := awsRestjson1_serializeDocumentLambdaEventSourceList(v.EventSources, ok); err != nil {
			return err
		}
	}

	if v.ExecArgs != nil {
		ok := object.Key("execArgs")
		if err := awsRestjson1_serializeDocumentLambdaExecArgsList(v.ExecArgs, ok); err != nil {
			return err
		}
	}

	if len(v.InputPayloadEncodingType) > 0 {
		ok := object.Key("inputPayloadEncodingType")
		ok.String(string(v.InputPayloadEncodingType))
	}

	if v.LinuxProcessParams != nil {
		ok := object.Key("linuxProcessParams")
		if err := awsRestjson1_serializeDocumentLambdaLinuxProcessParams(v.LinuxProcessParams, ok); err != nil {
			return err
		}
	}

	if v.MaxIdleTimeInSeconds != 0 {
		ok := object.Key("maxIdleTimeInSeconds")
		ok.Integer(v.MaxIdleTimeInSeconds)
	}

	if v.MaxInstancesCount != 0 {
		ok := object.Key("maxInstancesCount")
		ok.Integer(v.MaxInstancesCount)
	}

	if v.MaxQueueSize != 0 {
		ok := object.Key("maxQueueSize")
		ok.Integer(v.MaxQueueSize)
	}

	if v.Pinned {
		ok := object.Key("pinned")
		ok.Boolean(v.Pinned)
	}

	if v.StatusTimeoutInSeconds != 0 {
		ok := object.Key("statusTimeoutInSeconds")
		ok.Integer(v.StatusTimeoutInSeconds)
	}

	if v.TimeoutInSeconds != 0 {
		ok := object.Key("timeoutInSeconds")
		ok.Integer(v.TimeoutInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaFunctionRecipeSource(v *types.LambdaFunctionRecipeSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentDependencies != nil {
		ok := object.Key("componentDependencies")
		if err := awsRestjson1_serializeDocumentComponentDependencyMap(v.ComponentDependencies, ok); err != nil {
			return err
		}
	}

	if v.ComponentLambdaParameters != nil {
		ok := object.Key("componentLambdaParameters")
		if err := awsRestjson1_serializeDocumentLambdaExecutionParameters(v.ComponentLambdaParameters, ok); err != nil {
			return err
		}
	}

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.ComponentPlatforms != nil {
		ok := object.Key("componentPlatforms")
		if err := awsRestjson1_serializeDocumentComponentPlatformList(v.ComponentPlatforms, ok); err != nil {
			return err
		}
	}

	if v.ComponentVersion != nil {
		ok := object.Key("componentVersion")
		ok.String(*v.ComponentVersion)
	}

	if v.LambdaArn != nil {
		ok := object.Key("lambdaArn")
		ok.String(*v.LambdaArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaLinuxProcessParams(v *types.LambdaLinuxProcessParams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerParams != nil {
		ok := object.Key("containerParams")
		if err := awsRestjson1_serializeDocumentLambdaContainerParams(v.ContainerParams, ok); err != nil {
			return err
		}
	}

	if len(v.IsolationMode) > 0 {
		ok := object.Key("isolationMode")
		ok.String(string(v.IsolationMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaVolumeList(v []types.LambdaVolumeMount, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLambdaVolumeMount(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLambdaVolumeMount(v *types.LambdaVolumeMount, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddGroupOwner {
		ok := object.Key("addGroupOwner")
		ok.Boolean(v.AddGroupOwner)
	}

	if v.DestinationPath != nil {
		ok := object.Key("destinationPath")
		ok.String(*v.DestinationPath)
	}

	if len(v.Permission) > 0 {
		ok := object.Key("permission")
		ok.String(string(v.Permission))
	}

	if v.SourcePath != nil {
		ok := object.Key("sourcePath")
		ok.String(*v.SourcePath)
	}

	return nil
}

func awsRestjson1_serializeDocumentPlatformAttributesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSystemResourceLimits(v *types.SystemResourceLimits, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cpus != 0 {
		ok := object.Key("cpus")
		switch {
		case math.IsNaN(v.Cpus):
			ok.String("NaN")

		case math.IsInf(v.Cpus, 1):
			ok.String("Infinity")

		case math.IsInf(v.Cpus, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Cpus)

		}
	}

	if v.Memory != 0 {
		ok := object.Key("memory")
		ok.Long(v.Memory)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
