// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents information about an action configuration.
type ActionConfiguration struct {

	// The configuration data for the action.
	Configuration map[string]string

	noSmithyDocumentSerde
}

// Represents information about an action configuration property.
type ActionConfigurationProperty struct {

	// Whether the configuration property is a key.
	//
	// This member is required.
	Key bool

	// The name of the action configuration property.
	//
	// This member is required.
	Name *string

	// Whether the configuration property is a required value.
	//
	// This member is required.
	Required bool

	// Whether the configuration property is secret. Secrets are hidden from all calls
	// except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and
	// PollForThirdPartyJobs. When updating a pipeline, passing * * * * * without
	// changing any other values of the action preserves the previous value of the
	// secret.
	//
	// This member is required.
	Secret bool

	// The description of the action configuration property that is displayed to users.
	Description *string

	// Indicates that the property is used with PollForJobs. When creating a custom
	// action, an action can have up to one queryable property. If it has one, that
	// property must be both required and not secret. If you create a pipeline with a
	// custom action type, and that custom action contains a queryable property, the
	// value for that configuration property is subject to other restrictions. The
	// value must be less than or equal to twenty (20) characters. The value can
	// contain only alphanumeric characters, underscores, and hyphens.
	Queryable bool

	// The type of the configuration property.
	Type ActionConfigurationPropertyType

	noSmithyDocumentSerde
}

// Represents the context of an action in the stage of a pipeline to a job worker.
type ActionContext struct {

	// The system-generated unique ID that corresponds to an action's execution.
	ActionExecutionId *string

	// The name of the action in the context of a job.
	Name *string

	noSmithyDocumentSerde
}

// Represents information about an action declaration.
type ActionDeclaration struct {

	// Specifies the action type and the provider of the action.
	//
	// This member is required.
	ActionTypeId *ActionTypeId

	// The action declaration's name.
	//
	// This member is required.
	Name *string

	// The action's configuration. These are key-value pairs that specify input values
	// for an action. For more information, see Action Structure Requirements in
	// CodePipeline
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	// For the list of configuration properties for the AWS CloudFormation action type
	// in CodePipeline, see Configuration Properties Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html)
	// in the AWS CloudFormation User Guide. For template snippets with examples, see
	// Using Parameter Override Functions with CodePipeline Pipelines
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html)
	// in the AWS CloudFormation User Guide. The values can be represented in either
	// JSON or YAML format. For example, the JSON configuration item format is as
	// follows: JSON: "Configuration" : { Key : Value },
	Configuration map[string]string

	// The name or ID of the artifact consumed by the action, such as a test or build
	// artifact.
	InputArtifacts []InputArtifact

	// The variable namespace associated with the action. All variables produced as
	// output by this action fall under this namespace.
	Namespace *string

	// The name or ID of the result of the action declaration, such as a test or build
	// artifact.
	OutputArtifacts []OutputArtifact

	// The action declaration's AWS Region, such as us-east-1.
	Region *string

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string

	// The order in which actions are run.
	RunOrder *int32

	noSmithyDocumentSerde
}

// Represents information about the run of an action.
type ActionExecution struct {

	// ID of the workflow action execution in the current stage. Use the
	// GetPipelineState action to retrieve the current action execution details of the
	// current stage. For older executions, this field might be empty. The action
	// execution ID is available for executions run on or after March 2020.
	ActionExecutionId *string

	// The details of an error returned by a URL external to AWS.
	ErrorDetails *ErrorDetails

	// The external ID of the run of the action.
	ExternalExecutionId *string

	// The URL of a resource external to AWS that is used when running the action (for
	// example, an external repository URL).
	ExternalExecutionUrl *string

	// The last status change of the action.
	LastStatusChange *time.Time

	// The ARN of the user who last changed the pipeline.
	LastUpdatedBy *string

	// A percentage of completeness of the action as it runs.
	PercentComplete *int32

	// The status of the action, or for a completed action, the last status of the
	// action.
	Status ActionExecutionStatus

	// A summary of the run of the action.
	Summary *string

	// The system-generated token used to identify a unique approval request. The token
	// for each open approval request can be obtained using the GetPipelineState
	// command. It is used to validate that the approval request corresponding to this
	// token is still valid.
	Token *string

	noSmithyDocumentSerde
}

// Returns information about an execution of an action, including the action
// execution ID, and the name, version, and timing of the action.
type ActionExecutionDetail struct {

	// The action execution ID.
	ActionExecutionId *string

	// The name of the action.
	ActionName *string

	// Input details for the action execution, such as role ARN, Region, and input
	// artifacts.
	Input *ActionExecutionInput

	// The last update time of the action execution.
	LastUpdateTime *time.Time

	// Output details for the action execution, such as the action execution result.
	Output *ActionExecutionOutput

	// The pipeline execution ID for the action execution.
	PipelineExecutionId *string

	// The version of the pipeline where the action was run.
	PipelineVersion *int32

	// The name of the stage that contains the action.
	StageName *string

	// The start time of the action execution.
	StartTime *time.Time

	// The status of the action execution. Status categories are InProgress, Succeeded,
	// and Failed.
	Status ActionExecutionStatus

	noSmithyDocumentSerde
}

// Filter values for the action execution.
type ActionExecutionFilter struct {

	// The pipeline execution ID used to filter action execution history.
	PipelineExecutionId *string

	noSmithyDocumentSerde
}

// Input information used for an action execution.
type ActionExecutionInput struct {

	// Represents information about an action type.
	ActionTypeId *ActionTypeId

	// Configuration data for an action execution.
	Configuration map[string]string

	// Details of input artifacts of the action that correspond to the action
	// execution.
	InputArtifacts []ArtifactDetail

	// The variable namespace associated with the action. All variables produced as
	// output by this action fall under this namespace.
	Namespace *string

	// The AWS Region for the action, such as us-east-1.
	Region *string

	// Configuration data for an action execution with all variable references replaced
	// with their real values for the execution.
	ResolvedConfiguration map[string]string

	// The ARN of the IAM service role that performs the declared action. This is
	// assumed through the roleArn for the pipeline.
	RoleArn *string

	noSmithyDocumentSerde
}

// Output details listed for an action execution, such as the action execution
// result.
type ActionExecutionOutput struct {

	// Execution result information listed in the output details for an action
	// execution.
	ExecutionResult *ActionExecutionResult

	// Details of output artifacts of the action that correspond to the action
	// execution.
	OutputArtifacts []ArtifactDetail

	// The outputVariables field shows the key-value pairs that were output as part of
	// that execution.
	OutputVariables map[string]string

	noSmithyDocumentSerde
}

// Execution result information, such as the external execution ID.
type ActionExecutionResult struct {

	// The action provider's external ID for the action execution.
	ExternalExecutionId *string

	// The action provider's summary for the action execution.
	ExternalExecutionSummary *string

	// The deepest external link to the external resource (for example, a repository
	// URL or deployment endpoint) that is used when running the action.
	ExternalExecutionUrl *string

	noSmithyDocumentSerde
}

// Represents information about the version (or revision) of an action.
type ActionRevision struct {

	// The date and time when the most recent version of the action was created, in
	// timestamp format.
	//
	// This member is required.
	Created *time.Time

	// The unique identifier of the change that set the state to this revision (for
	// example, a deployment ID or timestamp).
	//
	// This member is required.
	RevisionChangeId *string

	// The system-generated unique ID that identifies the revision number of the
	// action.
	//
	// This member is required.
	RevisionId *string

	noSmithyDocumentSerde
}

// Represents information about the state of an action.
type ActionState struct {

	// The name of the action.
	ActionName *string

	// Represents information about the version (or revision) of an action.
	CurrentRevision *ActionRevision

	// A URL link for more information about the state of the action, such as a
	// deployment group details page.
	EntityUrl *string

	// Represents information about the run of an action.
	LatestExecution *ActionExecution

	// A URL link for more information about the revision, such as a commit details
	// page.
	RevisionUrl *string

	noSmithyDocumentSerde
}

// Returns information about the details of an action type.
type ActionType struct {

	// Represents information about an action type.
	//
	// This member is required.
	Id *ActionTypeId

	// The details of the input artifact for the action, such as its commit ID.
	//
	// This member is required.
	InputArtifactDetails *ArtifactDetails

	// The details of the output artifact of the action, such as its commit ID.
	//
	// This member is required.
	OutputArtifactDetails *ArtifactDetails

	// The configuration properties for the action type.
	ActionConfigurationProperties []ActionConfigurationProperty

	// The settings for the action type.
	Settings *ActionTypeSettings

	noSmithyDocumentSerde
}

// Information about parameters for artifacts associated with the action type, such
// as the minimum and maximum artifacts allowed.
type ActionTypeArtifactDetails struct {

	// The maximum number of artifacts that can be used with the actiontype. For
	// example, you should specify a minimum and maximum of zero input artifacts for an
	// action type with a category of source.
	//
	// This member is required.
	MaximumCount int32

	// The minimum number of artifacts that can be used with the action type. For
	// example, you should specify a minimum and maximum of zero input artifacts for an
	// action type with a category of source.
	//
	// This member is required.
	MinimumCount int32

	noSmithyDocumentSerde
}

// The parameters for the action type definition that are provided when the action
// type is created or updated.
type ActionTypeDeclaration struct {

	// Information about the executor for an action type that was created with any
	// supported integration model.
	//
	// This member is required.
	Executor *ActionTypeExecutor

	// The action category, owner, provider, and version of the action type to be
	// updated.
	//
	// This member is required.
	Id *ActionTypeIdentifier

	// Details for the artifacts, such as application files, to be worked on by the
	// action. For example, the minimum and maximum number of input artifacts allowed.
	//
	// This member is required.
	InputArtifactDetails *ActionTypeArtifactDetails

	// Details for the output artifacts, such as a built application, that are the
	// result of the action. For example, the minimum and maximum number of output
	// artifacts allowed.
	//
	// This member is required.
	OutputArtifactDetails *ActionTypeArtifactDetails

	// The description for the action type to be updated.
	Description *string

	// Details identifying the accounts with permissions to use the action type.
	Permissions *ActionTypePermissions

	// The properties of the action type to be updated.
	Properties []ActionTypeProperty

	// The links associated with the action type to be updated.
	Urls *ActionTypeUrls

	noSmithyDocumentSerde
}

// The action engine, or executor, for an action type created for a provider, where
// the action is to be used by customers of the provider. The action engine is
// associated with the model used to create and update the action, such as the
// Lambda integration model.
type ActionTypeExecutor struct {

	// The action configuration properties for the action type. These properties are
	// specified in the action definition when the action type is created.
	//
	// This member is required.
	Configuration *ExecutorConfiguration

	// The integration model used to create and update the action type, Lambda or
	// JobWorker.
	//
	// This member is required.
	Type ExecutorType

	// The timeout in seconds for the job. An action execution can have multiple jobs.
	// This is the timeout for a single job, not the entire action execution.
	JobTimeout *int32

	// The policy statement that specifies the permissions in the CodePipeline
	// customer’s account that are needed to successfully run an action. To grant
	// permission to another account, specify the account ID as the Principal, a
	// domain-style identifier defined by the service, for example
	// codepipeline.amazonaws.com. The size of the passed JSON policy document cannot
	// exceed 2048 characters.
	PolicyStatementsTemplate *string

	noSmithyDocumentSerde
}

// Represents information about an action type.
type ActionTypeId struct {

	// A category defines what kind of action can be taken in the stage, and constrains
	// the provider type for the action. Valid categories are limited to one of the
	// following values.
	//
	// * Source
	//
	// * Build
	//
	// * Test
	//
	// * Deploy
	//
	// * Invoke
	//
	// * Approval
	//
	// This member is required.
	Category ActionCategory

	// The creator of the action being called. There are three valid values for the
	// Owner field in the action category section within your pipeline structure: AWS,
	// ThirdParty, and Custom. For more information, see Valid Action Types and
	// Providers in CodePipeline
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
	//
	// This member is required.
	Owner ActionOwner

	// The provider of the service being called by the action. Valid providers are
	// determined by the action category. For example, an action in the Deploy category
	// type might have a provider of AWS CodeDeploy, which would be specified as
	// CodeDeploy. For more information, see Valid Action Types and Providers in
	// CodePipeline
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers).
	//
	// This member is required.
	Provider *string

	// A string that describes the action version.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Specifies the category, owner, provider, and version of the action type.
type ActionTypeIdentifier struct {

	// Defines what kind of action can be taken in the stage, one of the following:
	//
	// *
	// Source
	//
	// * Build
	//
	// * Test
	//
	// * Deploy
	//
	// * Approval
	//
	// * Invoke
	//
	// This member is required.
	Category ActionCategory

	// The creator of the action type being called: AWS or ThirdParty.
	//
	// This member is required.
	Owner *string

	// The provider of the action type being called. The provider name is supplied when
	// the action type is created.
	//
	// This member is required.
	Provider *string

	// A string that describes the action type version.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Details identifying the users with permissions to use the action type.
type ActionTypePermissions struct {

	// A list of AWS account IDs with access to use the action type in their pipelines.
	//
	// This member is required.
	AllowedAccounts []string

	noSmithyDocumentSerde
}

// Represents information about each property specified in the action
// configuration, such as the description and key name that display for the
// customer using the action type.
type ActionTypeProperty struct {

	// Whether the configuration property is a key.
	//
	// This member is required.
	Key bool

	// The property name that is displayed to users.
	//
	// This member is required.
	Name *string

	// Whether to omit the field value entered by the customer in the log. If true, the
	// value is not saved in CloudTrail logs for the action execution.
	//
	// This member is required.
	NoEcho bool

	// Whether the configuration property is an optional value.
	//
	// This member is required.
	Optional bool

	// The description of the property that is displayed to users.
	Description *string

	// Indicates that the property is used with polling. An action type can have up to
	// one queryable property. If it has one, that property must be both required and
	// not secret.
	Queryable bool

	noSmithyDocumentSerde
}

// Returns information about the settings for an action type.
type ActionTypeSettings struct {

	// The URL returned to the AWS CodePipeline console that provides a deep link to
	// the resources of the external system, such as the configuration page for an AWS
	// CodeDeploy deployment group. This link is provided as part of the action display
	// in the pipeline.
	EntityUrlTemplate *string

	// The URL returned to the AWS CodePipeline console that contains a link to the
	// top-level landing page for the external system, such as the console page for AWS
	// CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline
	// console and provides a link to the execution entity of the external action.
	ExecutionUrlTemplate *string

	// The URL returned to the AWS CodePipeline console that contains a link to the
	// page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string

	// The URL of a sign-up page where users can sign up for an external service and
	// perform initial configuration of the action provided by that service.
	ThirdPartyConfigurationUrl *string

	noSmithyDocumentSerde
}

// Returns information about URLs for web pages that display to customers as links
// on the pipeline view, such as an external configuration page for the action
// type.
type ActionTypeUrls struct {

	// The URL returned to the CodePipeline console that contains a link to the page
	// where customers can configure the external action.
	ConfigurationUrl *string

	// The URL returned to the CodePipeline console that provides a deep link to the
	// resources of the external system, such as a status page. This link is provided
	// as part of the action display in the pipeline.
	EntityUrlTemplate *string

	// The link to an execution page for the action type in progress. For example, for
	// a CodeDeploy action, this link is shown on the pipeline view page in the
	// CodePipeline console, and it links to a CodeDeploy status page.
	ExecutionUrlTemplate *string

	// The URL returned to the CodePipeline console that contains a link to the page
	// where customers can update or change the configuration of the external action.
	RevisionUrlTemplate *string

	noSmithyDocumentSerde
}

// Represents information about the result of an approval request.
type ApprovalResult struct {

	// The response submitted by a reviewer assigned to an approval action request.
	//
	// This member is required.
	Status ApprovalStatus

	// The summary of the current status of the approval request.
	//
	// This member is required.
	Summary *string

	noSmithyDocumentSerde
}

// Represents information about an artifact that is worked on by actions in the
// pipeline.
type Artifact struct {

	// The location of an artifact.
	Location *ArtifactLocation

	// The artifact's name.
	Name *string

	// The artifact's revision ID. Depending on the type of object, this could be a
	// commit ID (GitHub) or a revision ID (Amazon S3).
	Revision *string

	noSmithyDocumentSerde
}

// Artifact details for the action execution, such as the artifact location.
type ArtifactDetail struct {

	// The artifact object name for the action execution.
	Name *string

	// The Amazon S3 artifact location for the action execution.
	S3location *S3Location

	noSmithyDocumentSerde
}

// Returns information about the details of an artifact.
type ArtifactDetails struct {

	// The maximum number of artifacts allowed for the action type.
	//
	// This member is required.
	MaximumCount int32

	// The minimum number of artifacts allowed for the action type.
	//
	// This member is required.
	MinimumCount int32

	noSmithyDocumentSerde
}

// Represents information about the location of an artifact.
type ArtifactLocation struct {

	// The S3 bucket that contains the artifact.
	S3Location *S3ArtifactLocation

	// The type of artifact in the location.
	Type ArtifactLocationType

	noSmithyDocumentSerde
}

// Represents revision details of an artifact.
type ArtifactRevision struct {

	// The date and time when the most recent revision of the artifact was created, in
	// timestamp format.
	Created *time.Time

	// The name of an artifact. This name might be system-generated, such as "MyApp",
	// or defined by the user when an action is created.
	Name *string

	// An additional identifier for a revision, such as a commit date or, for artifacts
	// stored in Amazon S3 buckets, the ETag value.
	RevisionChangeIdentifier *string

	// The revision ID of the artifact.
	RevisionId *string

	// Summary information about the most recent revision of the artifact. For GitHub
	// and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or
	// actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string

	// The commit ID for the artifact revision. For artifacts stored in GitHub or AWS
	// CodeCommit repositories, the commit ID is linked to a commit details page.
	RevisionUrl *string

	noSmithyDocumentSerde
}

// The S3 bucket where artifacts for the pipeline are stored. You must include
// either artifactStore or artifactStores in your pipeline, but you cannot use
// both. If you create a cross-region action in your pipeline, you must use
// artifactStores.
type ArtifactStore struct {

	// The S3 bucket used for storing the artifacts for a pipeline. You can specify the
	// name of an S3 bucket but not a folder in the bucket. A folder to contain the
	// pipeline artifacts is created for you based on the name of the pipeline. You can
	// use any S3 bucket in the same AWS Region as the pipeline to store your pipeline
	// artifacts.
	//
	// This member is required.
	Location *string

	// The type of the artifact store, such as S3.
	//
	// This member is required.
	Type ArtifactStoreType

	// The encryption key used to encrypt the data in the artifact store, such as an
	// AWS Key Management Service (AWS KMS) key. If this is undefined, the default key
	// for Amazon S3 is used.
	EncryptionKey *EncryptionKey

	noSmithyDocumentSerde
}

// Represents an AWS session credentials object. These credentials are temporary
// credentials that are issued by AWS Secure Token Service (STS). They can be used
// to access input and output artifacts in the S3 bucket used to store artifact for
// the pipeline in AWS CodePipeline.
type AWSSessionCredentials struct {

	// The access key for the session.
	//
	// This member is required.
	AccessKeyId *string

	// The secret access key for the session.
	//
	// This member is required.
	SecretAccessKey *string

	// The token for the session.
	//
	// This member is required.
	SessionToken *string

	noSmithyDocumentSerde
}

// Reserved for future use.
type BlockerDeclaration struct {

	// Reserved for future use.
	//
	// This member is required.
	Name *string

	// Reserved for future use.
	//
	// This member is required.
	Type BlockerType

	noSmithyDocumentSerde
}

// Represents information about a current revision.
type CurrentRevision struct {

	// The change identifier for the current revision.
	//
	// This member is required.
	ChangeIdentifier *string

	// The revision ID of the current version of an artifact.
	//
	// This member is required.
	Revision *string

	// The date and time when the most recent revision of the artifact was created, in
	// timestamp format.
	Created *time.Time

	// The summary of the most recent revision of the artifact.
	RevisionSummary *string

	noSmithyDocumentSerde
}

// Represents information about the key used to encrypt data in the artifact store,
// such as an AWS Key Management Service (AWS KMS) key.
type EncryptionKey struct {

	// The ID used to identify the key. For an AWS KMS key, you can use the key ID, the
	// key ARN, or the alias ARN. Aliases are recognized only in the account that
	// created the customer master key (CMK). For cross-account actions, you can only
	// use the key ID or key ARN to identify the key.
	//
	// This member is required.
	Id *string

	// The type of encryption key, such as an AWS Key Management Service (AWS KMS) key.
	// When creating or updating a pipeline, the value must be set to 'KMS'.
	//
	// This member is required.
	Type EncryptionKeyType

	noSmithyDocumentSerde
}

// Represents information about an error in AWS CodePipeline.
type ErrorDetails struct {

	// The system ID or number code of the error.
	Code *string

	// The text of the error message.
	Message *string

	noSmithyDocumentSerde
}

// The details of the actions taken and results produced on an artifact as it
// passes through stages in the pipeline.
type ExecutionDetails struct {

	// The system-generated unique ID of this action used to identify this job worker
	// in any external systems, such as AWS CodeDeploy.
	ExternalExecutionId *string

	// The percentage of work completed on the action, represented on a scale of 0 to
	// 100 percent.
	PercentComplete *int32

	// The summary of the current status of the actions.
	Summary *string

	noSmithyDocumentSerde
}

// The interaction or event that started a pipeline execution.
type ExecutionTrigger struct {

	// Detail related to the event that started a pipeline execution, such as the
	// webhook ARN of the webhook that triggered the pipeline execution or the user ARN
	// for a user-initiated start-pipeline-execution CLI command.
	TriggerDetail *string

	// The type of change-detection method, command, or user interaction that started a
	// pipeline execution.
	TriggerType TriggerType

	noSmithyDocumentSerde
}

// The action engine, or executor, related to the supported integration model used
// to create and update the action type. The available executor types are Lambda
// and JobWorker.
type ExecutorConfiguration struct {

	// Details about the JobWorker executor of the action type.
	JobWorkerExecutorConfiguration *JobWorkerExecutorConfiguration

	// Details about the Lambda executor of the action type.
	LambdaExecutorConfiguration *LambdaExecutorConfiguration

	noSmithyDocumentSerde
}

// Represents information about failure details.
type FailureDetails struct {

	// The message about the failure.
	//
	// This member is required.
	Message *string

	// The type of the failure.
	//
	// This member is required.
	Type FailureType

	// The external ID of the run of the action that failed.
	ExternalExecutionId *string

	noSmithyDocumentSerde
}

// Represents information about an artifact to be worked on, such as a test or
// build artifact.
type InputArtifact struct {

	// The name of the artifact to be worked on (for example, "My App"). The input
	// artifact of an action must exactly match the output artifact declared in a
	// preceding action, but the input artifact does not have to be the next action in
	// strict sequence from the action that provided the output artifact. Actions in
	// parallel can declare different output artifacts, which are in turn consumed by
	// different following actions.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents information about a job.
type Job struct {

	// The ID of the AWS account to use when performing the job.
	AccountId *string

	// Other data about a job.
	Data *JobData

	// The unique system-generated ID of the job.
	Id *string

	// A system-generated random number that AWS CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Use this number in an
	// AcknowledgeJob request.
	Nonce *string

	noSmithyDocumentSerde
}

// Represents other information about a job required for a job worker to complete
// the job.
type JobData struct {

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration

	// Represents information about an action type.
	ActionTypeId *ActionTypeId

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be used
	// to access input and output artifacts in the S3 bucket used to store artifacts
	// for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials

	// A system-generated token, such as a AWS CodeDeploy deployment ID, required by a
	// job to continue the job asynchronously.
	ContinuationToken *string

	// Represents information about the key used to encrypt data in the artifact store,
	// such as an AWS Key Management Service (AWS KMS) key.
	EncryptionKey *EncryptionKey

	// The artifact supplied to the job.
	InputArtifacts []Artifact

	// The output of the job.
	OutputArtifacts []Artifact

	// Represents information about a pipeline to a job worker. Includes pipelineArn
	// and pipelineExecutionId for custom jobs.
	PipelineContext *PipelineContext

	noSmithyDocumentSerde
}

// Represents information about the details of a job.
type JobDetails struct {

	// The AWS account ID associated with the job.
	AccountId *string

	// Represents other information about a job required for a job worker to complete
	// the job.
	Data *JobData

	// The unique system-generated ID of the job.
	Id *string

	noSmithyDocumentSerde
}

// Details about the polling configuration for the JobWorker action engine, or
// executor.
type JobWorkerExecutorConfiguration struct {

	// The accounts in which the job worker is configured and might poll for jobs as
	// part of the action execution.
	PollingAccounts []string

	// The service Principals in which the job worker is configured and might poll for
	// jobs as part of the action execution.
	PollingServicePrincipals []string

	noSmithyDocumentSerde
}

// Details about the configuration for the Lambda action engine, or executor.
type LambdaExecutorConfiguration struct {

	// The ARN of the Lambda function used by the action engine.
	//
	// This member is required.
	LambdaFunctionArn *string

	noSmithyDocumentSerde
}

// The detail returned for each webhook after listing webhooks, such as the webhook
// URL, the webhook name, and the webhook ARN.
type ListWebhookItem struct {

	// The detail returned for each webhook, such as the webhook authentication type
	// and filter rules.
	//
	// This member is required.
	Definition *WebhookDefinition

	// A unique URL generated by CodePipeline. When a POST request is made to this URL,
	// the defined pipeline is started as long as the body of the post request
	// satisfies the defined authentication and filtering conditions. Deleting and
	// re-creating a webhook makes the old URL invalid and generates a new one.
	//
	// This member is required.
	Url *string

	// The Amazon Resource Name (ARN) of the webhook.
	Arn *string

	// The number code of the error.
	ErrorCode *string

	// The text of the error message about the webhook.
	ErrorMessage *string

	// The date and time a webhook was last successfully triggered, in timestamp
	// format.
	LastTriggered *time.Time

	// Specifies the tags applied to the webhook.
	Tags []Tag

	noSmithyDocumentSerde
}

// Represents information about the output of an action.
type OutputArtifact struct {

	// The name of the output of an artifact, such as "My App". The input artifact of
	// an action must exactly match the output artifact declared in a preceding action,
	// but the input artifact does not have to be the next action in strict sequence
	// from the action that provided the output artifact. Actions in parallel can
	// declare different output artifacts, which are in turn consumed by different
	// following actions. Output artifact names must be unique within a pipeline.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents information about a pipeline to a job worker. PipelineContext
// contains pipelineArn and pipelineExecutionId for custom action jobs. The
// pipelineArn and pipelineExecutionId fields are not populated for ThirdParty
// action jobs.
type PipelineContext struct {

	// The context of an action to a job worker in the stage of a pipeline.
	Action *ActionContext

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The execution ID of the pipeline.
	PipelineExecutionId *string

	// The name of the pipeline. This is a user-specified value. Pipeline names must be
	// unique across all pipeline names under an Amazon Web Services account.
	PipelineName *string

	// The stage of the pipeline.
	Stage *StageContext

	noSmithyDocumentSerde
}

// Represents the structure of actions and stages to be performed in the pipeline.
type PipelineDeclaration struct {

	// The name of the pipeline.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform
	// actions with no actionRoleArn, or to use to assume roles for actions with an
	// actionRoleArn.
	//
	// This member is required.
	RoleArn *string

	// The stage in which to perform the action.
	//
	// This member is required.
	Stages []StageDeclaration

	// Represents information about the S3 bucket where artifacts are stored for the
	// pipeline. You must include either artifactStore or artifactStores in your
	// pipeline, but you cannot use both. If you create a cross-region action in your
	// pipeline, you must use artifactStores.
	ArtifactStore *ArtifactStore

	// A mapping of artifactStore objects and their corresponding AWS Regions. There
	// must be an artifact store for the pipeline Region and for each cross-region
	// action in the pipeline. You must include either artifactStore or artifactStores
	// in your pipeline, but you cannot use both. If you create a cross-region action
	// in your pipeline, you must use artifactStores.
	ArtifactStores map[string]ArtifactStore

	// The version number of the pipeline. A new pipeline always has a version number
	// of 1. This number is incremented when a pipeline is updated.
	Version *int32

	noSmithyDocumentSerde
}

// Represents information about an execution of a pipeline.
type PipelineExecution struct {

	// A list of ArtifactRevision objects included in a pipeline execution.
	ArtifactRevisions []ArtifactRevision

	// The ID of the pipeline execution.
	PipelineExecutionId *string

	// The name of the pipeline with the specified pipeline execution.
	PipelineName *string

	// The version number of the pipeline with the specified pipeline execution.
	PipelineVersion *int32

	// The status of the pipeline execution.
	//
	// * Cancelled: The pipeline’s definition
	// was updated before the pipeline execution could be completed.
	//
	// * InProgress: The
	// pipeline execution is currently running.
	//
	// * Stopped: The pipeline execution was
	// manually stopped. For more information, see Stopped Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	// *
	// Stopping: The pipeline execution received a request to be manually stopped.
	// Depending on the selected stop mode, the execution is either completing or
	// abandoning in-progress actions. For more information, see Stopped Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	// *
	// Succeeded: The pipeline execution was completed successfully.
	//
	// * Superseded:
	// While this pipeline execution was waiting for the next stage to be completed, a
	// newer pipeline execution advanced and continued through the pipeline instead.
	// For more information, see Superseded Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	// *
	// Failed: The pipeline execution was not completed successfully.
	Status PipelineExecutionStatus

	// A summary that contains a description of the pipeline execution status.
	StatusSummary *string

	noSmithyDocumentSerde
}

// Summary information about a pipeline execution.
type PipelineExecutionSummary struct {

	// The date and time of the last change to the pipeline execution, in timestamp
	// format.
	LastUpdateTime *time.Time

	// The ID of the pipeline execution.
	PipelineExecutionId *string

	// A list of the source artifact revisions that initiated a pipeline execution.
	SourceRevisions []SourceRevision

	// The date and time when the pipeline execution began, in timestamp format.
	StartTime *time.Time

	// The status of the pipeline execution.
	//
	// * InProgress: The pipeline execution is
	// currently running.
	//
	// * Stopped: The pipeline execution was manually stopped. For
	// more information, see Stopped Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	// *
	// Stopping: The pipeline execution received a request to be manually stopped.
	// Depending on the selected stop mode, the execution is either completing or
	// abandoning in-progress actions. For more information, see Stopped Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped).
	//
	// *
	// Succeeded: The pipeline execution was completed successfully.
	//
	// * Superseded:
	// While this pipeline execution was waiting for the next stage to be completed, a
	// newer pipeline execution advanced and continued through the pipeline instead.
	// For more information, see Superseded Executions
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded).
	//
	// *
	// Failed: The pipeline execution was not completed successfully.
	Status PipelineExecutionStatus

	// The interaction that stopped a pipeline execution.
	StopTrigger *StopExecutionTrigger

	// The interaction or event that started a pipeline execution, such as automated
	// change detection or a StartPipelineExecution API call.
	Trigger *ExecutionTrigger

	noSmithyDocumentSerde
}

// Information about a pipeline.
type PipelineMetadata struct {

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time

	noSmithyDocumentSerde
}

// Returns a summary of a pipeline.
type PipelineSummary struct {

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time

	// The name of the pipeline.
	Name *string

	// The date and time of the last update to the pipeline, in timestamp format.
	Updated *time.Time

	// The version number of the pipeline.
	Version *int32

	noSmithyDocumentSerde
}

// The location of the S3 bucket that contains a revision.
type S3ArtifactLocation struct {

	// The name of the S3 bucket.
	//
	// This member is required.
	BucketName *string

	// The key of the object in the S3 bucket, which uniquely identifies the object in
	// the bucket.
	//
	// This member is required.
	ObjectKey *string

	noSmithyDocumentSerde
}

// The Amazon S3 artifact location for an action's artifacts.
type S3Location struct {

	// The Amazon S3 artifact bucket for an action's artifacts.
	Bucket *string

	// The artifact name.
	Key *string

	noSmithyDocumentSerde
}

// Information about the version (or revision) of a source artifact that initiated
// a pipeline execution.
type SourceRevision struct {

	// The name of the action that processed the revision to the source artifact.
	//
	// This member is required.
	ActionName *string

	// The system-generated unique ID that identifies the revision number of the
	// artifact.
	RevisionId *string

	// Summary information about the most recent revision of the artifact. For GitHub
	// and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or
	// actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string

	// The commit ID for the artifact revision. For artifacts stored in GitHub or AWS
	// CodeCommit repositories, the commit ID is linked to a commit details page.
	RevisionUrl *string

	noSmithyDocumentSerde
}

// Represents information about a stage to a job worker.
type StageContext struct {

	// The name of the stage.
	Name *string

	noSmithyDocumentSerde
}

// Represents information about a stage and its definition.
type StageDeclaration struct {

	// The actions included in a stage.
	//
	// This member is required.
	Actions []ActionDeclaration

	// The name of the stage.
	//
	// This member is required.
	Name *string

	// Reserved for future use.
	Blockers []BlockerDeclaration

	noSmithyDocumentSerde
}

// Represents information about the run of a stage.
type StageExecution struct {

	// The ID of the pipeline execution associated with the stage.
	//
	// This member is required.
	PipelineExecutionId *string

	// The status of the stage, or for a completed stage, the last status of the stage.
	// A status of cancelled means that the pipeline’s definition was updated before
	// the stage execution could be completed.
	//
	// This member is required.
	Status StageExecutionStatus

	noSmithyDocumentSerde
}

// Represents information about the state of the stage.
type StageState struct {

	// The state of the stage.
	ActionStates []ActionState

	// Represents information about the run of a stage.
	InboundExecution *StageExecution

	// The state of the inbound transition, which is either enabled or disabled.
	InboundTransitionState *TransitionState

	// Information about the latest execution in the stage, including its ID and
	// status.
	LatestExecution *StageExecution

	// The name of the stage.
	StageName *string

	noSmithyDocumentSerde
}

// The interaction that stopped a pipeline execution.
type StopExecutionTrigger struct {

	// The user-specified reason the pipeline was stopped.
	Reason *string

	noSmithyDocumentSerde
}

// A tag is a key-value pair that is used to manage the resource.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A response to a PollForThirdPartyJobs request returned by AWS CodePipeline when
// there is a job to be worked on by a partner action.
type ThirdPartyJob struct {

	// The clientToken portion of the clientId and clientToken pair used to verify that
	// the calling entity is allowed access to the job and its details.
	ClientId *string

	// The identifier used to identify the job in AWS CodePipeline.
	JobId *string

	noSmithyDocumentSerde
}

// Represents information about the job data for a partner action.
type ThirdPartyJobData struct {

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration

	// Represents information about an action type.
	ActionTypeId *ActionTypeId

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be used
	// to access input and output artifacts in the S3 bucket used to store artifact for
	// the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a job
	// requires to continue the job asynchronously.
	ContinuationToken *string

	// The encryption key used to encrypt and decrypt data in the artifact store for
	// the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is
	// optional and might not be present.
	EncryptionKey *EncryptionKey

	// The name of the artifact that is worked on by the action, if any. This name
	// might be system-generated, such as "MyApp", or it might be defined by the user
	// when the action is created. The input artifact name must match the name of an
	// output artifact generated by an action in an earlier action or stage of the
	// pipeline.
	InputArtifacts []Artifact

	// The name of the artifact that is the result of the action, if any. This name
	// might be system-generated, such as "MyBuiltApp", or it might be defined by the
	// user when the action is created.
	OutputArtifacts []Artifact

	// Represents information about a pipeline to a job worker. Does not include
	// pipelineArn and pipelineExecutionId for ThirdParty jobs.
	PipelineContext *PipelineContext

	noSmithyDocumentSerde
}

// The details of a job sent in response to a GetThirdPartyJobDetails request.
type ThirdPartyJobDetails struct {

	// The data to be returned by the third party job worker.
	Data *ThirdPartyJobData

	// The identifier used to identify the job details in AWS CodePipeline.
	Id *string

	// A system-generated random number that AWS CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Use this number in an
	// AcknowledgeThirdPartyJob request.
	Nonce *string

	noSmithyDocumentSerde
}

// Represents information about the state of transitions between one stage and
// another stage.
type TransitionState struct {

	// The user-specified reason why the transition between two stages of a pipeline
	// was disabled.
	DisabledReason *string

	// Whether the transition between stages is enabled (true) or disabled (false).
	Enabled bool

	// The timestamp when the transition state was last changed.
	LastChangedAt *time.Time

	// The ID of the user who last changed the transition state.
	LastChangedBy *string

	noSmithyDocumentSerde
}

// The authentication applied to incoming webhook trigger requests.
type WebhookAuthConfiguration struct {

	// The property used to configure acceptance of webhooks in an IP address range.
	// For IP, only the AllowedIPRange property must be set. This property must be set
	// to a valid CIDR range.
	AllowedIPRange *string

	// The property used to configure GitHub authentication. For GITHUB_HMAC, only the
	// SecretToken property must be set.
	SecretToken *string

	noSmithyDocumentSerde
}

// Represents information about a webhook and its definition.
type WebhookDefinition struct {

	// Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
	//
	// * For information
	// about the authentication scheme implemented by GITHUB_HMAC, see Securing your
	// webhooks (https://developer.github.com/webhooks/securing/) on the GitHub
	// Developer website.
	//
	// * IP rejects webhooks trigger requests unless they originate
	// from an IP address in the IP range whitelisted in the authentication
	// configuration.
	//
	// * UNAUTHENTICATED accepts all webhook trigger requests
	// regardless of origin.
	//
	// This member is required.
	Authentication WebhookAuthenticationType

	// Properties that configure the authentication applied to incoming webhook trigger
	// requests. The required properties depend on the authentication type. For
	// GITHUB_HMAC, only the SecretToken property must be set. For IP, only the
	// AllowedIPRange property must be set to a valid CIDR range. For UNAUTHENTICATED,
	// no properties can be set.
	//
	// This member is required.
	AuthenticationConfiguration *WebhookAuthConfiguration

	// A list of rules applied to the body/payload sent in the POST request to a
	// webhook URL. All defined rules must pass for the request to be accepted and the
	// pipeline started.
	//
	// This member is required.
	Filters []WebhookFilterRule

	// The name of the webhook.
	//
	// This member is required.
	Name *string

	// The name of the action in a pipeline you want to connect to the webhook. The
	// action must be from the source (first) stage of the pipeline.
	//
	// This member is required.
	TargetAction *string

	// The name of the pipeline you want to connect to the webhook.
	//
	// This member is required.
	TargetPipeline *string

	noSmithyDocumentSerde
}

// The event criteria that specify when a webhook notification is sent to your URL.
type WebhookFilterRule struct {

	// A JsonPath expression that is applied to the body/payload of the webhook. The
	// value selected by the JsonPath expression must match the value specified in the
	// MatchEquals field. Otherwise, the request is ignored. For more information, see
	// Java JsonPath implementation (https://github.com/json-path/JsonPath) in GitHub.
	//
	// This member is required.
	JsonPath *string

	// The value selected by the JsonPath expression must match what is supplied in the
	// MatchEquals field. Otherwise, the request is ignored. Properties from the target
	// action configuration can be included as placeholders in this value by
	// surrounding the action configuration key with curly brackets. For example, if
	// the value supplied here is "refs/heads/{Branch}" and the target action has an
	// action configuration property called "Branch" with a value of "master", the
	// MatchEquals value is evaluated as "refs/heads/master". For a list of action
	// configuration properties for built-in action types, see Pipeline Structure
	// Reference Action Requirements
	// (https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements).
	MatchEquals *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
